/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel;

import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.graphpanel.EditorResources;
import holmes.graphpanel.ElementDrawSettings;
import holmes.graphpanel.SelectionManager;
import holmes.graphpanel.popupmenu.ArcPopupMenu;
import holmes.graphpanel.popupmenu.MetaNodePopupMenu;
import holmes.graphpanel.popupmenu.PlacePopupMenu;
import holmes.graphpanel.popupmenu.SheetPopupMenu;
import holmes.graphpanel.popupmenu.TransitionPopupMenu;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionColored;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.subnets.SubnetsTools;
import holmes.utilities.Tools;
import holmes.varia.NetworkTransformations;
import holmes.workspace.WorkspaceSheet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JViewport;

public class GraphPanel
extends JComponent {
    private static final long serialVersionUID = -5746225670483573975L;
    private static final int meshSize = 20;
    private GUIManager overlord;
    private PetriNet petriNet;
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<Arc> arcs = new ArrayList();
    private SelectionManager selectionManager;
    private Point mousePt;
    private DrawModes drawMode = DrawModes.POINTER;
    private Rectangle selectingRect = null;
    private Arc drawnArc = null;
    private int sheetId;
    private boolean autoDragScroll = false;
    private boolean isSimulationActive = false;
    private int zoom = 100;
    private Dimension originSize;
    private boolean drawMesh = false;
    private boolean snapToMesh = false;
    public Point arcBreakPoint = null;
    public Point arcNewBreakPoint = null;

    public GraphPanel(int sheetId, PetriNet petriNet, ArrayList<Node> nodesList, ArrayList<Arc> arcsList) {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.petriNet = petriNet;
        this.sheetId = sheetId;
        this.setNodesAndArcs(nodesList, arcsList);
        this.Initialize();
    }

    public void Initialize() {
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setOpaque(true);
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        this.addKeyListener(new KeyboardHandler());
        this.addMouseWheelListener(new MouseWheelHandler());
        this.setSelectionManager(new SelectionManager(this));
        this.getSelectionManager().setActionListener(this.petriNet);
    }

    public void setNodesAndArcs(ArrayList<Node> nodes, ArrayList<Arc> arcs) {
        this.nodes = nodes;
        this.arcs = arcs;
        this.revalidate();
        this.repaint();
    }

    public void resetNodesAndArcs(ArrayList<Node> nodes, ArrayList<Arc> arcs) {
        this.nodes = nodes;
        this.arcs = arcs;
    }

    public void setNodes(ArrayList<Node> nodes) {
        this.nodes = nodes;
        this.revalidate();
        this.repaint();
    }

    public void setCursorForMode() {
        if (this.getDrawMode() == DrawModes.POINTER) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = null;
            String modeName = "";
            try {
                modeName = this.getDrawMode().toString();
                image = Tools.getImageFromIcon("/cursors/" + modeName + ".gif");
            }
            catch (Exception e) {
                this.overlord.log("Critical error, no " + modeName + ".gif in jar file. Thank java un-catchable exceptions...", "error", true);
            }
            Point hotSpot = new Point(0, 0);
            Cursor cursor = toolkit.createCustomCursor(image, hotSpot, this.getDrawMode().toString());
            this.setCursor(cursor);
        }
    }

    public BufferedImage createImageFromSheet() {
        Rectangle r = this.getBounds();
        BufferedImage image = new BufferedImage(r.width, r.height, 1);
        Graphics g = image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawPetriNet((Graphics2D)g.create());
        return image;
    }

    public int getSheetId() {
        return this.sheetId;
    }

    public void setSheetId(int sheetID) {
        this.sheetId = sheetID;
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public void setArcs(ArrayList<Arc> arcs) {
        this.arcs = arcs;
        this.revalidate();
        this.repaint();
    }

    public ArrayList<Arc> getArcs() {
        return this.arcs;
    }

    public Rectangle getSelectingRect() {
        return this.selectingRect;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(new Color(0xF0F0F0));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.isDrawMesh()) {
            this.drawMesh(g2d);
        }
        try {
            this.drawPetriNet(g2d);
        }
        catch (Exception e) {
            this.overlord.log("CRITICAL error while drawing net. (Which should not happen. Obviously.) Loaded file probably corrupted (if after project loading). Restarting program.", "error", true);
            this.overlord.reset.emergencyRestart();
        }
    }

    private void drawMesh(Graphics2D g2d) {
        int i;
        g2d.setColor(EditorResources.graphPanelMeshColor);
        for (i = 20; i < this.getWidth(); i += 20) {
            g2d.drawLine(i, 0, i, this.getHeight());
        }
        for (i = 20; i < this.getHeight(); i += 20) {
            g2d.drawLine(0, i, this.getWidth(), i);
        }
    }

    public void drawPetriNet(Graphics2D g2d) {
        g2d.translate(0, 0);
        g2d.scale((float)this.getZoom() / 100.0f, (float)this.getZoom() / 100.0f);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.overlord.getSettingsManager().getValue("editorGridLines").equals("1")) {
            int i;
            g2d.setColor(Color.lightGray);
            int maxWidth = this.getWidth() * 100 / this.getZoom();
            int maxHeight = this.getHeight() * 100 / this.getZoom();
            int counterVertical = 1;
            int counterHorizontal = 1;
            for (i = 1; i < maxWidth / 20; ++i) {
                g2d.drawLine(counterVertical * 20, 0, counterVertical * 20, maxHeight);
                ++counterVertical;
            }
            for (i = 1; i < maxHeight / 20; ++i) {
                g2d.drawLine(0, counterHorizontal * 20, maxWidth, counterHorizontal * 20);
                ++counterHorizontal;
            }
        }
        ElementDrawSettings eds = new ElementDrawSettings();
        if (GUIManager.getDefaultGUIManager().getWorkspace().getProject().getSimulator().getSimNetType() == SimulatorGlobals.SimNetType.COLOR) {
            eds.color = true;
        }
        for (Arc a : this.getArcs()) {
            a.draw(g2d, this.sheetId, this.getZoom(), eds);
        }
        if (this.isSimulationActive()) {
            for (Arc a : this.getArcs()) {
                a.drawSimulationMovingToken(g2d, this.sheetId);
            }
        }
        for (Node n : this.getNodes()) {
            n.draw(g2d, this.sheetId, eds);
        }
        ArrayList<ArrayList<Node>> elements = this.petriNet.getPNelements();
        for (Node n : this.getNodes()) {
            n.drawName(g2d, this.sheetId, elements.get(0), elements.get(1), elements.get(2), elements.get(3));
        }
        if (this.getSelectingRect() != null) {
            g2d.setColor(EditorResources.selectionRectColor);
            g2d.setStroke(EditorResources.selectionRectStroke);
            g2d.drawRoundRect(this.getSelectingRect().x, this.getSelectingRect().y, this.getSelectingRect().width, this.getSelectingRect().height, 3, 3);
            g2d.setColor(EditorResources.selectionRectFill);
            g2d.fillRoundRect(this.getSelectingRect().x, this.getSelectingRect().y, this.getSelectingRect().width, this.getSelectingRect().height, 3, 3);
        }
        if (this.drawnArc != null) {
            this.drawnArc.draw(g2d, this.sheetId, this.getZoom(), eds);
        }
        if (this.overlord.debug) {
            this.debugInfo(g2d);
        }
    }

    private void debugInfo(Graphics2D g2d) {
        g2d.setColor(Color.RED);
        g2d.setFont(new Font("TimesRoman", 1, 15));
        int x = 20;
        int y = 0;
        Object status = "DEBUG MODE ACTIVATED";
        g2d.drawString((String)status, x, y += 20);
        g2d.setColor(Color.BLACK);
        status = this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus().toString();
        status = ((String)status).equals("LOOP") ? "Status: ACTIVE" : "Status: " + (String)status;
        g2d.drawString((String)status, x, y += 20);
        status = this.overlord.simSettings.getNetType().toString();
        status = "Status: " + (String)status;
        g2d.drawString((String)status, x, y += 20);
        boolean max = this.overlord.simSettings.isMaxMode();
        status = max ? "Maximum mode ON" : "Maximum mode OFF";
        g2d.drawString((String)status, x, y += 20);
        boolean single = this.overlord.simSettings.isSingleMode();
        status = single ? "Single mode ON" : "Single mode OFF";
        g2d.drawString((String)status, x, y += 20);
        int arcDelay = this.overlord.simSettings.getArcGraphicDelay();
        status = "Arc delay: " + arcDelay;
        g2d.drawString((String)status, x, y += 20);
        int transDelay = this.overlord.simSettings.getTransitionGraphicDelay();
        status = "Trans. firing delay: " + transDelay;
        g2d.drawString((String)status, x, y);
    }

    public void setZoom(int zoom, int oldZoom) {
        if (this.getOriginSize() == null) {
            this.setOriginSize(this.getSize());
        }
        Dimension hidden = this.getOriginSize();
        int orgHeight = (int)hidden.getHeight();
        int orgWidth = (int)hidden.getWidth();
        if (this.getOriginSize().width * zoom / 100 < 10) {
            return;
        }
        this.zoom = zoom;
        int h = orgHeight;
        h = (int)((double)h * (double)zoom / 100.0);
        int w = orgWidth;
        w = (int)((double)w * (double)zoom / 100.0);
        this.setSize(w, h);
        WorkspaceSheet sheet = this.overlord.getWorkspace().getSheets().get(this.overlord.IDtoIndex(this.sheetId));
        sheet.revalidate();
        this.invalidate();
        this.repaint();
    }

    public void scrollSheetHorizontal(int delta) {
        WorkspaceSheet sheet = this.overlord.getWorkspace().getSheets().get(this.overlord.IDtoIndex(this.sheetId));
        sheet.scrollHorizontal(delta);
    }

    public Point nameLocationChangeHorizontal(int delta, GUIManager.locationMoveType nameType) {
        Node n = this.overlord.getNameLocChangeNode();
        ElementLocation el = this.overlord.getNameLocChangeEL();
        int nameLocIndex = n.getElementLocations().indexOf(el);
        int oldX = n.getTextsLocations((GUIManager.locationMoveType)nameType).get((int)nameLocIndex).getPosition().x;
        int x = (oldX += delta) + el.getPosition().x;
        int oldY = n.getTextsLocations((GUIManager.locationMoveType)nameType).get((int)nameLocIndex).getPosition().y;
        int y = oldY + el.getPosition().y;
        if (this.isLegalLocation(new Point(x, y))) {
            n.getTextsLocations(nameType).get(nameLocIndex).getPosition().setLocation(oldX + delta, oldY);
        }
        return n.getTextsLocations(nameType).get(nameLocIndex).getPosition();
    }

    public void scrollSheetVertical(int delta) {
        WorkspaceSheet sheet = this.overlord.getWorkspace().getSheets().get(this.overlord.IDtoIndex(this.sheetId));
        sheet.scrollVertical(delta);
    }

    public Point nameLocationChangeVertical(int delta, GUIManager.locationMoveType nameType) {
        Node n = this.overlord.getNameLocChangeNode();
        ElementLocation el = this.overlord.getNameLocChangeEL();
        int nameLocIndex = n.getElementLocations().indexOf(el);
        int oldX = n.getTextsLocations((GUIManager.locationMoveType)nameType).get((int)nameLocIndex).getPosition().x;
        int oldY = n.getTextsLocations((GUIManager.locationMoveType)nameType).get((int)nameLocIndex).getPosition().y;
        int x = oldX + el.getPosition().x;
        int y = (oldY += delta) + el.getPosition().y;
        if (this.isLegalLocation(new Point(x, y))) {
            n.getTextsLocations(nameType).get(nameLocIndex).getPosition().setLocation(oldX, oldY);
        }
        return n.getTextsLocations(nameType).get(nameLocIndex).getPosition();
    }

    public void adjustScroll(Point currentPoint, Point previousPoint) {
        if (!this.isAutoDragScroll()) {
            return;
        }
        WorkspaceSheet sheet = this.overlord.getWorkspace().getSheets().get(this.overlord.IDtoIndex(this.sheetId));
        Dimension viewSize = sheet.getViewport().getSize();
        Point delta = new Point();
        delta.setLocation(currentPoint.x - previousPoint.x, currentPoint.y - previousPoint.y);
        JViewport viewport = sheet.getViewport();
        Point viewPoint = new Point(currentPoint.x - viewport.getViewPosition().x, currentPoint.y - viewport.getViewPosition().y);
        if (this.isAutoDragScroll() && (viewSize.width - 20 < viewPoint.x || viewSize.height - 20 < viewPoint.y || 20 > viewPoint.x || 20 > viewPoint.y)) {
            sheet.scrollHorizontal(delta.x);
            sheet.scrollVertical(delta.y);
        }
    }

    private void addNewPlace(Point p) {
        if (this.isLegalLocation(p)) {
            Place place = new Place(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            this.getSelectionManager().selectOneElementLocation(place.getLastLocation());
            this.getNodes().add(place);
            this.overlord.getWorkspace().getProject().accessStatesManager().addPlace(place);
            this.overlord.getWorkspace().getProject().accessSSAmanager().addPlace();
        }
    }

    private void addNewCPlace(Point p) {
        if (this.isLegalLocation(p)) {
            PlaceColored place = new PlaceColored(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            place.isColored = true;
            this.getSelectionManager().selectOneElementLocation(place.getLastLocation());
            this.getNodes().add(place);
            this.overlord.getWorkspace().getProject().accessStatesManager().addPlace(place);
            this.overlord.getWorkspace().getProject().accessSSAmanager().addPlace();
        }
    }

    private void addNewTransition(Point p) {
        if (this.isLegalLocation(p)) {
            Transition trans = new Transition(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            this.getSelectionManager().selectOneElementLocation(trans.getLastLocation());
            this.getNodes().add(trans);
            this.overlord.getWorkspace().getProject().accessFiringRatesManager().addTrans();
        }
    }

    private void addNewStochasticTransition(Point p) {
        if (this.isLegalLocation(p)) {
            Transition trans = new Transition(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            trans.spnExtension.setSPNtype(TransitionSPNExtension.StochaticsType.ST);
            trans.setTransType(Transition.TransitionType.SPN);
            this.getSelectionManager().selectOneElementLocation(trans.getLastLocation());
            this.getNodes().add(trans);
            this.overlord.getWorkspace().getProject().accessFiringRatesManager().addTrans();
        }
    }

    private void addNewCTransition(Point p) {
        if (this.isLegalLocation(p)) {
            TransitionColored trans = new TransitionColored(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            trans.setTransType(Transition.TransitionType.CPN);
            this.getSelectionManager().selectOneElementLocation(trans.getLastLocation());
            this.getNodes().add(trans);
            this.overlord.getWorkspace().getProject().accessFiringRatesManager().addTrans();
        }
    }

    private void addNewTimeTransition(Point p) {
        if (this.isLegalLocation(p)) {
            Transition trans = new Transition(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            trans.setTransType(Transition.TransitionType.TPN);
            trans.timeExtension.setTPNstatus(true);
            this.getSelectionManager().selectOneElementLocation(trans.getLastLocation());
            this.getNodes().add(trans);
            this.overlord.getWorkspace().getProject().accessFiringRatesManager().addTrans();
        }
    }

    private void addNewXTPNTransition(Point p) {
        if (this.isLegalLocation(p)) {
            TransitionXTPN trans = new TransitionXTPN(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            trans.setTransType(Transition.TransitionType.XTPN);
            this.getSelectionManager().selectOneElementLocation(trans.getLastLocation());
            this.getNodes().add(trans);
            this.overlord.getWorkspace().getProject().accessFiringRatesManager().addTrans();
        }
    }

    private void addNewNXTPNPlace(Point p) {
        if (this.isLegalLocation(p)) {
            PlaceXTPN place = new PlaceXTPN(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            this.getSelectionManager().selectOneElementLocation(place.getLastLocation());
            this.getNodes().add(place);
            this.overlord.getWorkspace().getProject().accessStatesManager().addPlace(place);
            this.overlord.getWorkspace().getProject().accessSSAmanager().addPlace();
        }
    }

    private void addNewFunctionalTransition(Point p) {
        if (this.isLegalLocation(p)) {
            Transition trans = new Transition(IdGenerator.getNextId(), this.sheetId, NetworkTransformations.alignToGrid(p));
            trans.fpnExtension.setFunctional(true);
            this.getSelectionManager().selectOneElementLocation(trans.getLastLocation());
            this.getNodes().add(trans);
            this.overlord.getWorkspace().getProject().accessFiringRatesManager().addTrans();
        }
    }

    private void addNewSubnetP(Point p) {
        if (this.isLegalLocation(p)) {
            this.overlord.getWorkspace().newTab(true, p, this.sheetId, MetaNode.MetaType.SUBNETPLACE);
        }
    }

    private void addNewSubnetT(Point p) {
        if (this.isLegalLocation(p)) {
            this.overlord.getWorkspace().newTab(true, p, this.sheetId, MetaNode.MetaType.SUBNETTRANS);
        }
    }

    private void addNewSubnetPT(Point p) {
        if (this.isLegalLocation(p)) {
            if (this.overlord.getSettingsManager().getValue("editorSnoopyCompatibleMode").equals("1")) {
                JOptionPane.showMessageDialog(null, "Snoopy compatibility mode is activated in program options.\nDual interface (PT) subnetworks are not allowed.", "Compatibility issue", 1);
                return;
            }
            this.overlord.getWorkspace().newTab(true, p, this.sheetId, MetaNode.MetaType.SUBNET);
        }
    }

    public boolean isLegalLocation(Point point) {
        Dimension orgSize = this.getOriginSize();
        int panelWidht = orgSize.width;
        int panelHeight = orgSize.height;
        return point.x > 20 && point.y > 20 && point.x < panelWidht - 20 && point.y < panelHeight - 20;
    }

    public void clearDrawnArc() {
        if (this.drawnArc != null) {
            this.drawnArc.unlinkElementLocations();
            this.drawnArc = null;
        }
    }

    public PetriNet getPetriNet() {
        return this.petriNet;
    }

    public void setSelectingRect(Rectangle selectingRect) {
        this.selectingRect = selectingRect;
    }

    public DrawModes getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(DrawModes newMode) {
        this.drawMode = newMode;
        this.setCursorForMode();
    }

    public boolean isSimulationActive() {
        return this.isSimulationActive;
    }

    public void setSimulationActive(boolean isSimulationActive) {
        this.isSimulationActive = isSimulationActive;
    }

    public void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public SheetPopupMenu getSheetPopupMenu(PetriNetElement.PetriNetElementType pne) {
        return new SheetPopupMenu(this, pne);
    }

    public PlacePopupMenu getPlacePopupMenu(ElementLocation el, PetriNetElement.PetriNetElementType pne) {
        return new PlacePopupMenu(this, el, pne);
    }

    public TransitionPopupMenu getTransitionPopupMenu(ElementLocation el, PetriNetElement.PetriNetElementType pne) {
        return new TransitionPopupMenu(this, el, pne);
    }

    public MetaNodePopupMenu getMetaNodePopupMenu(ElementLocation el, PetriNetElement.PetriNetElementType pne) {
        return new MetaNodePopupMenu(this, el, pne);
    }

    public ArcPopupMenu getArcPopupMenu(Arc arc, PetriNetElement.PetriNetElementType pne, Point mousePt2) {
        this.arcNewBreakPoint = (Point)mousePt2.clone();
        return new ArcPopupMenu(this, arc, pne);
    }

    public boolean isDrawMesh() {
        return this.drawMesh;
    }

    public void setDrawMesh(boolean drawMesh) {
        this.drawMesh = drawMesh;
        this.invalidate();
        this.repaint();
    }

    public boolean isAutoDragScroll() {
        return this.autoDragScroll;
    }

    public void setAutoDragScroll(boolean autoDragScroll) {
        this.autoDragScroll = autoDragScroll;
    }

    public boolean isSnapToMesh() {
        return this.snapToMesh;
    }

    public void setSnapToMesh(boolean snapToMesh) {
        this.snapToMesh = snapToMesh;
    }

    public int getZoom() {
        return this.zoom;
    }

    public Dimension getOriginSize() {
        return this.originSize;
    }

    public void setOriginSize(Dimension originSize) {
        this.originSize = originSize;
    }

    public void centerOnPoint(Point mousePt) {
        WorkspaceSheet ws = this.overlord.getWorkspace().getSelectedSheet();
        if (ws == null) {
            this.overlord.log("Unable to obtaint WorkspaceSheet object. Net sheet panel probably externized outside program bounds.", "warning", true);
            return;
        }
        int visibleX = ws.getWidth();
        int visibleY = ws.getHeight();
        int clickedX = mousePt.x;
        int clickedY = mousePt.y;
        int centerX = visibleX / 2;
        int centerY = visibleY / 2;
        int barHorX = ws.getHorizontalScrollBar().getValue();
        int barVerY = ws.getVerticalScrollBar().getValue();
        centerX += barHorX;
        centerY += barVerY;
        double zoom = this.getZoom();
        zoom = 100.0 / zoom;
        centerX = (int)((double)centerX * zoom);
        centerY = (int)((double)centerY * zoom);
        if (clickedX <= centerX && clickedY <= centerY) {
            this.scrollSheetHorizontal(-(centerX - clickedX));
            this.scrollSheetVertical(-(centerY - clickedY));
        } else if (clickedX > centerX && clickedY <= centerY) {
            this.scrollSheetHorizontal(clickedX - centerX);
            this.scrollSheetVertical(-(centerY - clickedY));
        } else if (clickedX > centerX && clickedY > centerY) {
            this.scrollSheetHorizontal(clickedX - centerX);
            this.scrollSheetVertical(clickedY - centerY);
        } else if (clickedX <= centerX && clickedY > centerY) {
            this.scrollSheetHorizontal(-(centerX - clickedX));
            this.scrollSheetVertical(clickedY - centerY);
        }
    }

    public Arc.TypeOfArc convertType(DrawModes arcType) {
        if (arcType == DrawModes.ARC_INHIBITOR) {
            return Arc.TypeOfArc.INHIBITOR;
        }
        if (arcType == DrawModes.ARC_EQUAL) {
            return Arc.TypeOfArc.EQUAL;
        }
        if (arcType == DrawModes.ARC_RESET) {
            return Arc.TypeOfArc.RESET;
        }
        if (arcType == DrawModes.READARC) {
            return Arc.TypeOfArc.READARC;
        }
        return Arc.TypeOfArc.NORMAL;
    }

    public void clearSelectionColors() {
        ArrayList<Node> nodes = this.overlord.getWorkspace().getProject().getNodes();
        for (Node n : nodes) {
            if (!n.isPortal()) continue;
            for (ElementLocation el : n.getElementLocations()) {
                el.setSelected(false);
                el.setPortalSelected(false);
            }
        }
    }

    public boolean isReverseArcPresent(ElementLocation startLocation, ElementLocation endLocation) {
        Node node = endLocation.getParentNode();
        for (ElementLocation el : node.getElementLocations()) {
            ArrayList<Arc> candidates = el.getOutArcs();
            for (Arc a : candidates) {
                if (!this.locationFamily(a.getEndLocation(), startLocation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean locationFamily(ElementLocation location, ElementLocation testLoc) {
        Node node = location.getParentNode();
        for (ElementLocation el : node.getElementLocations()) {
            if (el != testLoc) continue;
            return true;
        }
        return false;
    }

    public boolean isArcDuplicated(ElementLocation startLocation, ElementLocation endLocation) {
        boolean result = false;
        block0: for (ElementLocation el : startLocation.getParentNode().getElementLocations()) {
            ArrayList<Arc> outArcs = el.getOutArcs();
            for (Arc a : outArcs) {
                ElementLocation arcEndLocation = a.getEndLocation();
                if (arcEndLocation == null) continue;
                Node endNode = arcEndLocation.getParentNode();
                if (!endLocation.getParentNode().equals(endNode)) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public static enum DrawModes {
        POINTER,
        ERASER,
        PLACE,
        TRANSITION,
        TIMETRANSITION,
        FUNCTIONALTRANS,
        STOCHASTICTRANS,
        IMMEDIATETRANS,
        DETERMINISTICTRANS,
        SCHEDULEDTRANS,
        ARC,
        ARC_INHIBITOR,
        ARC_RESET,
        ARC_EQUAL,
        READARC,
        ARC_MODIFIER,
        SUBNET_T,
        SUBNET_P,
        SUBNET_PT,
        CPLACE,
        CTRANSITION,
        CARC,
        XTRANSITION,
        XPLACE,
        XARC,
        XINHIBITOR;

    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (GraphPanel.this.arcBreakPoint != null) {
                GraphPanel.this.mousePt = e.getPoint();
                GraphPanel.this.mousePt.setLocation(e.getPoint().getX() * 100.0 / (double)GraphPanel.this.zoom, e.getPoint().getY() * 100.0 / (double)GraphPanel.this.zoom);
                GraphPanel.this.arcBreakPoint.setLocation(GraphPanel.this.mousePt.x, GraphPanel.this.mousePt.y);
                GraphPanel.this.arcBreakPoint = null;
                GraphPanel.this.setSelectingRect(null);
                e.getComponent().repaint();
            } else {
                GraphPanel.this.setSelectingRect(null);
                e.getComponent().repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getButton() == 1 && !e.isShiftDown()) {
                    GraphPanel.this.getSelectionManager().doubleClickReactionHandler();
                }
                if (e.getButton() == 1 && e.isShiftDown()) {
                    GraphPanel.this.getSelectionManager().decreaseTokensNumber();
                }
            } else if (e.getClickCount() == 1 && e.getButton() == 1 && e.isControlDown()) {
                GraphPanel.this.getSelectionManager().doubleClickReactionHandler();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            GraphPanel.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
            GraphPanel.this.mousePt = e.getPoint();
            GraphPanel.this.mousePt.setLocation(e.getPoint().getX() * 100.0 / (double)GraphPanel.this.zoom, e.getPoint().getY() * 100.0 / (double)GraphPanel.this.zoom);
            ElementLocation el = GraphPanel.this.getSelectionManager().getPossiblySelectedElementLocation(GraphPanel.this.mousePt, 0);
            Arc a = GraphPanel.this.getSelectionManager().getPossiblySelectedArc(GraphPanel.this.mousePt);
            if (a != null && el == null && e.getButton() == 1) {
                GraphPanel.this.arcBreakPoint = a.checkBreakIntersection(GraphPanel.this.mousePt);
                if (GraphPanel.this.arcBreakPoint != null) {
                    return;
                }
            }
            if (el == null && a == null) {
                if (e.getButton() == 3) {
                    if (GraphPanel.this.getDrawMode() == DrawModes.POINTER) {
                        GraphPanel.this.getSheetPopupMenu(PetriNetElement.PetriNetElementType.UNKNOWN).show(e);
                    }
                    GraphPanel.this.setDrawMode(DrawModes.POINTER);
                    GraphPanel.this.overlord.getToolBox().selectPointer();
                }
                if (!e.isShiftDown() && !e.isControlDown()) {
                    GraphPanel.this.overlord.getWorkspace().globalDeselection();
                    GraphPanel.this.getSelectionManager().deselectAllElements();
                    GraphPanel.this.clearSelectionColors();
                }
                if (e.isAltDown()) {
                    GraphPanel.this.centerOnPoint(GraphPanel.this.mousePt);
                }
                PetriNet project = GraphPanel.this.overlord.getWorkspace().getProject();
                switch (GraphPanel.this.getDrawMode()) {
                    case POINTER: {
                        GraphPanel.this.getSelectionManager().selectSheet();
                        GraphPanel.this.setSelectingRect(new Rectangle(GraphPanel.this.mousePt.x, GraphPanel.this.mousePt.y, 0, 0));
                        GraphPanel.this.clearDrawnArc();
                        break;
                    }
                    case PLACE: {
                        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                            JOptionPane.showMessageDialog(null, "Normal place cannot be used with XTPN nodes.", "Problem", 2);
                            break;
                        }
                        this._putPlace();
                        break;
                    }
                    case TRANSITION: {
                        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                            JOptionPane.showMessageDialog(null, "Normal transition cannot be used with XTPN nodes.", "Problem", 2);
                            break;
                        }
                        this._putTransition();
                        break;
                    }
                    case STOCHASTICTRANS: {
                        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                            JOptionPane.showMessageDialog(null, "Stochastic transition cannot be used with XTPN nodes.", "Problem", 2);
                            break;
                        }
                        this._putStochasticTransition();
                        break;
                    }
                    case ARC: 
                    case XARC: 
                    case XINHIBITOR: {
                        GraphPanel.this.clearDrawnArc();
                        break;
                    }
                    case TIMETRANSITION: {
                        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                            JOptionPane.showMessageDialog(null, "Time transition cannot be used with XTPN nodes.", "Problem", 2);
                            break;
                        }
                        this._putTimeTransition();
                        break;
                    }
                    case XTRANSITION: {
                        if (project.getNodes().size() == 0) {
                            this._putXTPNtransition(project);
                            break;
                        }
                        if (project.hasNonXTPNnodes()) {
                            JOptionPane.showMessageDialog(null, "TODO: transformation. Please create clean new project to use XTPN nodes.", "Compatibility issue", 1);
                            break;
                        }
                        this._putXTPNtransition(project);
                        break;
                    }
                    case XPLACE: {
                        if (project.getNodes().size() == 0) {
                            this._putXTPNplace(project);
                            break;
                        }
                        if (project.hasNonXTPNnodes()) {
                            JOptionPane.showMessageDialog(null, "TODO: transformation. Please create clean new project to use XTPN nodes.", "Compatibility issue", 1);
                            break;
                        }
                        this._putXTPNplace(project);
                        break;
                    }
                    case CPLACE: {
                        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                            JOptionPane.showMessageDialog(null, "Color place cannot be used with XTPN nodes.", "Problem", 2);
                            break;
                        }
                        this._putColorPlace();
                        break;
                    }
                    case CTRANSITION: {
                        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                            JOptionPane.showMessageDialog(null, "Color transition cannot be used with XTPN nodes.", "Problem", 2);
                            break;
                        }
                        this._putColorTransition();
                        break;
                    }
                    case SUBNET_P: {
                        GraphPanel.this.addNewSubnetP(GraphPanel.this.mousePt);
                        break;
                    }
                    case SUBNET_T: {
                        GraphPanel.this.addNewSubnetT(GraphPanel.this.mousePt);
                        break;
                    }
                    case SUBNET_PT: {
                        GraphPanel.this.addNewSubnetPT(GraphPanel.this.mousePt);
                        break;
                    }
                }
            } else if (el != null) {
                if (GraphPanel.this.getDrawMode() == DrawModes.ARC || GraphPanel.this.getDrawMode() == DrawModes.READARC || GraphPanel.this.getDrawMode() == DrawModes.ARC_INHIBITOR || GraphPanel.this.getDrawMode() == DrawModes.ARC_RESET || GraphPanel.this.getDrawMode() == DrawModes.ARC_EQUAL || GraphPanel.this.getDrawMode() == DrawModes.CARC || GraphPanel.this.getDrawMode() == DrawModes.XARC || GraphPanel.this.getDrawMode() == DrawModes.XINHIBITOR) {
                    this.handleArcsDrawing(el, GraphPanel.this.getDrawMode());
                } else if (GraphPanel.this.getDrawMode() == DrawModes.ERASER) {
                    if (GraphPanel.this.overlord.reset.isSimulatorActiveWarning("Operation impossible when simulator is working.", "Warning")) {
                        return;
                    }
                    if (GraphPanel.this.overlord.reset.isXTPNSimulatorActiveWarning("Operation impossible when XTPN simulator is working.", "Warning")) {
                        return;
                    }
                    Object[] options = new Object[]{"Delete", "Cancel"};
                    int n = JOptionPane.showOptionDialog(null, "Do you want to delete selected elements?", "Deletion warning?", 0, 3, null, options, options[0]);
                    if (n == 0) {
                        GraphPanel.this.getSelectionManager().deleteElementLocation(el);
                        GraphPanel.this.overlord.reset.reset2ndOrderData(true);
                        GraphPanel.this.overlord.markNetChange();
                    }
                } else {
                    if (e.isShiftDown()) {
                        GraphPanel.this.getSelectionManager().selectElementLocation(el);
                    } else if (e.isControlDown()) {
                        GraphPanel.this.getSelectionManager().toggleElementLocationSelection(el);
                    } else if (!GraphPanel.this.getSelectionManager().isElementLocationSelected(el)) {
                        GraphPanel.this.getSelectionManager().selectOneElementLocation(el);
                        GraphPanel.this.getSelectionManager().deselectAllArcs();
                    }
                    GraphPanel.this.clearDrawnArc();
                }
                if (e.getButton() == 3) {
                    if (el.getParentNode().getType() == PetriNetElement.PetriNetElementType.PLACE) {
                        GraphPanel.this.getPlacePopupMenu(el, PetriNetElement.PetriNetElementType.PLACE).show(e);
                    } else if (el.getParentNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                        GraphPanel.this.getTransitionPopupMenu(el, PetriNetElement.PetriNetElementType.TRANSITION).show(e);
                    } else if (el.getParentNode().getType() == PetriNetElement.PetriNetElementType.META) {
                        GraphPanel.this.getMetaNodePopupMenu(el, PetriNetElement.PetriNetElementType.META).show(e);
                    }
                }
            } else {
                if (GraphPanel.this.getDrawMode() == DrawModes.ERASER) {
                    if (GraphPanel.this.overlord.reset.isSimulatorActiveWarning("Operation impossible when simulator is working.", "Warning")) {
                        return;
                    }
                    if (GraphPanel.this.overlord.reset.isXTPNSimulatorActiveWarning("Operation impossible when XTPN simulator is working.", "Warning")) {
                        return;
                    }
                    Object[] options = new Object[]{"Delete", "Cancel"};
                    int n = JOptionPane.showOptionDialog(null, "Do you want to delete selected elements?", "Deletion warning?", 0, 3, null, options, options[0]);
                    if (n == 0) {
                        GraphPanel.this.getSelectionManager().deleteArc(a);
                        GraphPanel.this.overlord.reset.reset2ndOrderData(true);
                        GraphPanel.this.overlord.markNetChange();
                    }
                } else if (e.isShiftDown()) {
                    a.setSelected(true);
                } else if (e.isControlDown()) {
                    a.setSelected(!a.getSelected());
                } else if (!GraphPanel.this.getSelectionManager().isArcSelected(a)) {
                    GraphPanel.this.getSelectionManager().deselectAllElementLocations();
                    GraphPanel.this.getSelectionManager().selectOneArc(a);
                }
                GraphPanel.this.clearDrawnArc();
                if (e.getButton() == 3) {
                    GraphPanel.this.getArcPopupMenu(a, PetriNetElement.PetriNetElementType.ARC, GraphPanel.this.mousePt).show(e);
                }
            }
            e.getComponent().repaint();
        }

        private void _putPlace() {
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(false);
            GraphPanel.this.addNewPlace(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void _putTransition() {
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(false);
            GraphPanel.this.addNewTransition(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void _putStochasticTransition() {
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(false);
            GraphPanel.this.addNewStochasticTransition(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void _putTimeTransition() {
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(false);
            GraphPanel.this.addNewTimeTransition(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void _putColorPlace() {
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(false);
            GraphPanel.this.addNewCPlace(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void _putColorTransition() {
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(false);
            GraphPanel.this.addNewCTransition(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void _putXTPNtransition(PetriNet project) {
            project.setProjectType(PetriNet.GlobalNetType.XTPN);
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(true);
            GraphPanel.this.addNewXTPNTransition(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void _putXTPNplace(PetriNet project) {
            project.setProjectType(PetriNet.GlobalNetType.XTPN);
            GraphPanel.this.overlord.getWorkspace().getProject().selectProperSimulatorBox(true);
            GraphPanel.this.addNewNXTPNPlace(GraphPanel.this.mousePt);
            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
            GraphPanel.this.overlord.markNetChange();
        }

        private void handleArcsDrawing(ElementLocation clickedLocation, DrawModes arcType) {
            GraphPanel.this.getSelectionManager().deselectAllElements();
            Node node = clickedLocation.getParentNode();
            if (node.isInvisible()) {
                JOptionPane.showMessageDialog(null, "Cannot draw arc to invisible node!", "Problem", 2);
                return;
            }
            if (GraphPanel.this.drawnArc == null && node instanceof MetaNode) {
                if (arcType == DrawModes.ARC) {
                    GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.NORMAL);
                    return;
                }
                JOptionPane.showMessageDialog(null, "Only normal arc allowed from meta-node!", "Problem", 2);
                return;
            }
            if (GraphPanel.this.drawnArc == null) {
                if (arcType == DrawModes.ARC) {
                    GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.NORMAL);
                } else if (arcType == DrawModes.XARC) {
                    GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.NORMAL);
                    GraphPanel.this.drawnArc.arcXTPNbox.setXTPNstatus(true);
                } else if (arcType == DrawModes.XINHIBITOR) {
                    GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.INHIBITOR);
                    GraphPanel.this.drawnArc.arcXTPNbox.setXTPNinhibitorStatus(true);
                } else if (arcType == DrawModes.READARC) {
                    if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                        JOptionPane.showMessageDialog(null, "Only XTPN normal arc and inhibitors are allowed in XTPN net mode.", "Wrong arc type", 2);
                    } else {
                        GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.READARC);
                    }
                } else if (arcType == DrawModes.ARC_INHIBITOR) {
                    if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                        JOptionPane.showMessageDialog(null, "Only XTPN normal arc and inhibitors are allowed in XTPN net mode.", "Wrong arc type", 2);
                    } else {
                        GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.INHIBITOR);
                    }
                } else if (arcType == DrawModes.ARC_RESET) {
                    if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                        JOptionPane.showMessageDialog(null, "Only XTPN normal arc and inhibitors are allowed in XTPN net mode.", "Wrong arc type", 2);
                    } else {
                        GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.RESET);
                    }
                } else if (arcType == DrawModes.ARC_EQUAL) {
                    if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                        JOptionPane.showMessageDialog(null, "Only XTPN normal arc and inhibitors are allowed in XTPN net mode.", "Wrong arc type", 2);
                    } else {
                        GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.EQUAL);
                    }
                } else if (arcType == DrawModes.CARC) {
                    if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                        JOptionPane.showMessageDialog(null, "Only XTPN normal arc and inhibitors are allowed in XTPN net mode.", "Wrong arc type", 2);
                    } else {
                        GraphPanel.this.drawnArc = new Arc(clickedLocation, Arc.TypeOfArc.NORMAL);
                    }
                }
            } else {
                if (clickedLocation.getParentNode() instanceof MetaNode) {
                    if (GraphPanel.this.drawnArc.getStartLocation().getParentNode() instanceof MetaNode) {
                        JOptionPane.showMessageDialog(null, "Direct connection between two meta-nodes not possible.", "Problem", 2);
                        GraphPanel.this.clearDrawnArc();
                        return;
                    }
                    if (GraphPanel.this.drawnArc.getArcType() != Arc.TypeOfArc.NORMAL) {
                        JOptionPane.showMessageDialog(null, "Only normal arc can be connected with meta-node.", "Problem", 2);
                        GraphPanel.this.clearDrawnArc();
                        return;
                    }
                    MetaNode n = (MetaNode)clickedLocation.getParentNode();
                    if (GraphPanel.this.drawnArc.getStartLocation().getParentNode() instanceof Place && n.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                        JOptionPane.showMessageDialog(null, "Meta-node type P (transitions-interfaced) can get connection only from transitions!", "Problem", 2);
                        GraphPanel.this.clearDrawnArc();
                        return;
                    }
                    if (GraphPanel.this.drawnArc.getStartLocation().getParentNode() instanceof Transition && n.getMetaType() == MetaNode.MetaType.SUBNETTRANS) {
                        JOptionPane.showMessageDialog(null, "Meta-node type T (places-interfaced) can get connection only from places!", "Problem", 2);
                        GraphPanel.this.clearDrawnArc();
                        return;
                    }
                    GraphPanel.this.overlord.subnetsHQ.addArcToMetanode(GraphPanel.this.drawnArc.getStartLocation(), clickedLocation, GraphPanel.this.drawnArc);
                    GraphPanel.this.clearDrawnArc();
                    return;
                }
                if (GraphPanel.this.drawnArc.getStartLocation().getParentNode() instanceof MetaNode) {
                    MetaNode n = (MetaNode)GraphPanel.this.drawnArc.getStartLocation().getParentNode();
                    if (clickedLocation.getParentNode() instanceof Place && n.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                        JOptionPane.showMessageDialog(null, "Meta-node type P (transitions-interfaced) can get connection only from transitions!", "Problem", 2);
                        GraphPanel.this.clearDrawnArc();
                        return;
                    }
                    if (clickedLocation.getParentNode() instanceof Transition && n.getMetaType() == MetaNode.MetaType.SUBNETTRANS) {
                        JOptionPane.showMessageDialog(null, "Meta-node type T (places-interfaced) can get connection only from places!", "Problem", 2);
                        GraphPanel.this.clearDrawnArc();
                        return;
                    }
                    GraphPanel.this.overlord.subnetsHQ.addArcFromMetanode(clickedLocation, GraphPanel.this.drawnArc.getStartLocation(), GraphPanel.this.drawnArc);
                    GraphPanel.this.clearDrawnArc();
                    return;
                }
                if (GraphPanel.this.drawnArc.checkIsCorect(clickedLocation)) {
                    boolean proceed = true;
                    if (GraphPanel.this.isArcDuplicated(GraphPanel.this.drawnArc.getStartLocation(), clickedLocation)) {
                        JOptionPane.showMessageDialog(null, "Arc going in this direction already exists.", "Problem", 2);
                        proceed = false;
                    } else if (GraphPanel.this.isReverseArcPresent(GraphPanel.this.drawnArc.getStartLocation(), clickedLocation)) {
                        if (arcType == DrawModes.ARC) {
                            proceed = true;
                        } else if (arcType == DrawModes.READARC) {
                            JOptionPane.showMessageDialog(null, "Please remove arc between these two nodes in order to create a read-arc.", "Problem", 2);
                            proceed = false;
                        }
                    }
                    if (clickedLocation.getSheetID() > 0) {
                        ArrayList<MetaNode> metas = GraphPanel.this.overlord.getWorkspace().getProject().getMetaNodes();
                        int first = SubnetsTools.isInterface(GraphPanel.this.drawnArc.getStartLocation(), metas);
                        int second = SubnetsTools.isInterface(clickedLocation, metas);
                        if (first > 0 && second > 0) {
                            JOptionPane.showMessageDialog(null, "Two interfaces cannot be linked directly within single subnet.", "Don't cross the streams!", 2);
                            proceed = false;
                        }
                    }
                    if (proceed) {
                        if ((arcType == DrawModes.ARC_INHIBITOR || arcType == DrawModes.ARC_RESET || arcType == DrawModes.ARC_EQUAL || arcType == DrawModes.XINHIBITOR) && clickedLocation.getParentNode() instanceof Place) {
                            JOptionPane.showMessageDialog(null, "This type of arc can only go FROM place TO transition!", "Problem", 2);
                            GraphPanel.this.clearDrawnArc();
                        } else {
                            Arc.TypeOfArc thisArc = GraphPanel.this.convertType(arcType);
                            Arc arc = new Arc(IdGenerator.getNextId(), GraphPanel.this.drawnArc.getStartLocation(), clickedLocation, thisArc);
                            if (arcType == DrawModes.ARC) {
                                if (arc.getArcType() != Arc.TypeOfArc.READARC) {
                                    arc.setArcType(Arc.TypeOfArc.NORMAL);
                                }
                                GraphPanel.this.getArcs().add(arc);
                            } else if (arcType == DrawModes.XARC) {
                                arc.setArcType(Arc.TypeOfArc.NORMAL);
                                arc.arcXTPNbox.setXTPNstatus(true);
                                GraphPanel.this.getArcs().add(arc);
                            } else if (arcType == DrawModes.XINHIBITOR) {
                                arc.setArcType(Arc.TypeOfArc.INHIBITOR);
                                arc.arcXTPNbox.setXTPNinhibitorStatus(true);
                                GraphPanel.this.getArcs().add(arc);
                            } else if (arcType == DrawModes.READARC) {
                                GraphPanel.this.getArcs().add(arc);
                                Arc arc2 = new Arc(IdGenerator.getNextId(), clickedLocation, GraphPanel.this.drawnArc.getStartLocation(), Arc.TypeOfArc.READARC);
                                GraphPanel.this.getArcs().add(arc2);
                                arc.setArcType(Arc.TypeOfArc.READARC);
                                arc2.setArcType(Arc.TypeOfArc.READARC);
                            } else if (arcType == DrawModes.ARC_INHIBITOR) {
                                arc.setArcType(Arc.TypeOfArc.INHIBITOR);
                                GraphPanel.this.getArcs().add(arc);
                            } else if (arcType == DrawModes.ARC_RESET) {
                                arc.setArcType(Arc.TypeOfArc.RESET);
                                GraphPanel.this.getArcs().add(arc);
                            } else if (arcType == DrawModes.ARC_EQUAL) {
                                arc.setArcType(Arc.TypeOfArc.EQUAL);
                                GraphPanel.this.getArcs().add(arc);
                            } else if (arcType == DrawModes.CARC) {
                                arc.setArcType(Arc.TypeOfArc.COLOR);
                                GraphPanel.this.getArcs().add(arc);
                            }
                            GraphPanel.this.clearDrawnArc();
                            int arcSheet = arc.getStartLocation().getSheetID();
                            if (arcSheet > 0) {
                                GraphPanel.this.overlord.subnetsHQ.addMetaArc(arc);
                            }
                            GraphPanel.this.overlord.reset.reset2ndOrderData(true);
                            GraphPanel.this.overlord.markNetChange();
                        }
                    } else {
                        GraphPanel.this.clearDrawnArc();
                    }
                }
            }
        }
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        Point delta = new Point();

        private MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point dragPoint = e.getPoint();
            dragPoint.setLocation(e.getX() * 100 / GraphPanel.this.zoom, e.getY() * 100 / GraphPanel.this.zoom);
            if (GraphPanel.this.arcBreakPoint != null) {
                int x = Math.max(dragPoint.x, 10);
                int y = Math.max(dragPoint.y, 10);
                GraphPanel.this.arcBreakPoint.setLocation(x, y);
                e.getComponent().repaint();
                return;
            }
            if ((GraphPanel.this.getDrawMode() == DrawModes.ARC || GraphPanel.this.getDrawMode() == DrawModes.READARC || GraphPanel.this.getDrawMode() == DrawModes.ARC_INHIBITOR || GraphPanel.this.getDrawMode() == DrawModes.ARC_RESET || GraphPanel.this.getDrawMode() == DrawModes.ARC_EQUAL || GraphPanel.this.getDrawMode() == DrawModes.CARC || GraphPanel.this.getDrawMode() == DrawModes.XARC || GraphPanel.this.getDrawMode() == DrawModes.XINHIBITOR) && GraphPanel.this.drawnArc != null) {
                return;
            }
            if (GraphPanel.this.getSelectingRect() != null) {
                GraphPanel.this.getSelectingRect().setBounds(Math.min(GraphPanel.this.mousePt.x, dragPoint.x), Math.min(GraphPanel.this.mousePt.y, dragPoint.y), Math.abs(GraphPanel.this.mousePt.x - dragPoint.x), Math.abs(GraphPanel.this.mousePt.y - dragPoint.y));
                GraphPanel.this.getSelectionManager().selectInRect(GraphPanel.this.getSelectingRect());
            } else {
                this.delta.setLocation(dragPoint.getX() - (double)GraphPanel.this.mousePt.x, dragPoint.getY() - (double)GraphPanel.this.mousePt.y);
                for (ElementLocation el : GraphPanel.this.getSelectionManager().getSelectedElementLocations()) {
                    if (GraphPanel.this.isSnapToMesh()) {
                        el.updateLocationWithMeshSnap(this.delta, 20);
                    } else {
                        el.updateLocation(this.delta);
                    }
                    GraphPanel.this.getSelectionManager().dragSelected();
                }
                for (Arc a : GraphPanel.this.getSelectionManager().getSelectedArcs()) {
                    a.updateAllBreakPointsLocations(this.delta);
                }
                GraphPanel.this.adjustScroll(dragPoint, GraphPanel.this.mousePt);
                GraphPanel.this.mousePt = dragPoint;
            }
            e.getComponent().repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getButton() == 3) {
                return;
            }
            if ((GraphPanel.this.getDrawMode() == DrawModes.ARC || GraphPanel.this.getDrawMode() == DrawModes.READARC || GraphPanel.this.getDrawMode() == DrawModes.ARC_INHIBITOR || GraphPanel.this.getDrawMode() == DrawModes.ARC_RESET || GraphPanel.this.getDrawMode() == DrawModes.ARC_EQUAL || GraphPanel.this.getDrawMode() == DrawModes.CARC || GraphPanel.this.getDrawMode() == DrawModes.XARC || GraphPanel.this.getDrawMode() == DrawModes.XINHIBITOR) && GraphPanel.this.drawnArc != null) {
                Point movePoint = e.getPoint();
                movePoint.setLocation(e.getX() * 100 / GraphPanel.this.zoom, e.getY() * 100 / GraphPanel.this.zoom);
                GraphPanel.this.drawnArc.setEndPoint(movePoint);
                GraphPanel.this.drawnArc.checkIsCorect(GraphPanel.this.getSelectionManager().getPossiblySelectedElementLocation(movePoint, 0));
                if (GraphPanel.this.drawnArc.getIsCorect()) {
                    ElementLocation el = GraphPanel.this.getSelectionManager().getPossiblySelectedElementLocation(movePoint, 20);
                    GraphPanel.this.drawnArc.setEndPoint(el.getPosition());
                }
                e.getComponent().repaint();
            }
        }
    }

    private static class KeyboardHandler
    implements KeyListener {
        private KeyboardHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            System.out.println(e.getKeyChar());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            System.out.println(e.getKeyChar());
        }

        @Override
        public void keyReleased(KeyEvent e) {
            System.out.println(e.getKeyChar());
        }
    }

    public class MouseWheelHandler
    implements MouseWheelListener {
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown()) {
                double oldZoom = GraphPanel.this.getZoom();
                GraphPanel.this.setZoom(GraphPanel.this.getZoom() - 10 * e.getWheelRotation(), GraphPanel.this.getZoom());
                double newZoom = GraphPanel.this.getZoom();
                Point dragPoint = e.getPoint();
                Point newPoint = new Point();
                newPoint.setLocation((double)(e.getX() * 100) / newZoom, (double)(e.getY() * 100) / newZoom);
                GraphPanel.this.centerOnPoint(newPoint);
            } else if (e.isShiftDown()) {
                if (GraphPanel.this.overlord.getNameLocChangeMode() != GUIManager.locationMoveType.NONE) {
                    Point newP = GraphPanel.this.nameLocationChangeHorizontal(e.getWheelRotation() * e.getScrollAmount(), GraphPanel.this.overlord.getNameLocChangeMode());
                    e.getComponent().repaint();
                    if (GraphPanel.this.overlord.getNameLocChangeMode() == GUIManager.locationMoveType.NAME && GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().nameLocationXSpinnerModel != null) {
                        GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().doNotUpdate = true;
                        GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().nameLocationXSpinnerModel.setValue(newP.x);
                        GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().nameLocationYSpinnerModel.setValue(newP.y);
                        GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().doNotUpdate = false;
                    }
                } else {
                    GraphPanel.this.scrollSheetHorizontal(e.getWheelRotation() * e.getScrollAmount() * 30);
                }
            } else if (GraphPanel.this.overlord.getNameLocChangeMode() != GUIManager.locationMoveType.NONE) {
                Point newP = GraphPanel.this.nameLocationChangeVertical(e.getWheelRotation() * e.getScrollAmount(), GraphPanel.this.overlord.getNameLocChangeMode());
                e.getComponent().repaint();
                if (GraphPanel.this.overlord.getNameLocChangeMode() == GUIManager.locationMoveType.NAME && GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().nameLocationXSpinnerModel != null) {
                    GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().doNotUpdate = true;
                    GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().nameLocationXSpinnerModel.setValue(newP.x);
                    GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().nameLocationYSpinnerModel.setValue(newP.y);
                    GraphPanel.this.overlord.getPropertiesBox().getCurrentDockWindow().doNotUpdate = false;
                }
            } else {
                GraphPanel.this.scrollSheetVertical(e.getWheelRotation() * e.getScrollAmount() * 30);
            }
        }
    }
}

