/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io.snoopy;

import holmes.darkgui.GUIManager;
import holmes.files.io.snoopy.SnoopyToolClass;
import holmes.graphpanel.EditorResources;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Transition;
import holmes.varia.NetworkTransformations;
import java.awt.Color;
import java.awt.Point;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class SnoopyWriterTransition {
    protected Transition holmesTransition;
    protected int snoopyStartingID;
    protected int globalTransID;
    protected ArrayList<Integer> grParents = new ArrayList();
    protected ArrayList<Point> grParentsLocation = new ArrayList();
    protected boolean portal = false;

    public SnoopyWriterTransition() {
    }

    public SnoopyWriterTransition(Transition t) {
        this();
        this.holmesTransition = t;
    }

    /*
     * WARNING - void declaration
     */
    public int writeTransitionInfoToFile(BufferedWriter bw, int newFreeId, int globalID) {
        void var12_20;
        void var12_18;
        void var12_16;
        this.snoopyStartingID = newFreeId;
        this.globalTransID = globalID;
        int currID = this.snoopyStartingID;
        int locations = 1;
        int xOff = 25;
        int yOff = 25;
        ArrayList<Integer> locationsSheetID = new ArrayList<Integer>();
        int netMainID = 0;
        boolean isInterface = false;
        for (ElementLocation elementLocation : this.holmesTransition.getElementLocations()) {
            if (elementLocation.accessMetaInArcs().size() <= 0 && elementLocation.accessMetaOutArcs().size() <= 0) continue;
            isInterface = true;
            break;
        }
        ArrayList<Integer> stateForEL = new ArrayList<Integer>();
        for (ElementLocation el3 : this.holmesTransition.getElementLocations()) {
            locationsSheetID.add(el3.getSheetID() + 1);
            if (isInterface) {
                if (el3.getSheetID() != 0) {
                    stateForEL.add(8);
                } else if (el3.accessMetaInArcs().size() > 0 || el3.accessMetaOutArcs().size() > 0) {
                    stateForEL.add(4);
                } else {
                    stateForEL.add(1);
                }
            } else {
                stateForEL.add(1);
            }
            if (locations == 1) {
                currID += 8;
            } else if (locations == 2) {
                currID += 31;
                this.portal = true;
            } else {
                currID += 9;
                this.portal = true;
            }
            this.grParents.add(currID);
            Point pxy = el3.getPosition();
            if (GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorGridAlignWhenSaved").equals("1")) {
                pxy = NetworkTransformations.alignToGrid(pxy);
            }
            this.grParentsLocation.add(pxy);
            ++locations;
        }
        Iterator iterator = locationsSheetID.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            if (x != 1) continue;
            netMainID = 1;
        }
        if (netMainID == 0) {
            netMainID = (Integer)locationsSheetID.get(0);
        }
        currID = this.snoopyStartingID;
        if (--locations == 1) {
            this.write(bw, "      <node id=\"" + currID + "\" net=\"" + netMainID + "\">");
        } else {
            this.write(bw, "      <node id=\"" + currID + "\" net=\"" + netMainID + "\" logic=\"1\">");
        }
        this.write(bw, "        <attribute name=\"Name\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        this.write(bw, "          <![CDATA[" + this.holmesTransition.getName() + "]]>");
        this.write(bw, "          <graphics count=\"" + locations + "\">");
        xOff = 5;
        yOff = 20;
        boolean bl = false;
        while (var12_16 < locations) {
            xOff = this.holmesTransition.getTextLocation_X((int)var12_16, GUIManager.locationMoveType.NAME);
            yOff = this.holmesTransition.getTextLocation_Y((int)var12_16, GUIManager.locationMoveType.NAME);
            yOff = SnoopyToolClass.getNormalizedY(yOff);
            if (var12_16 == false) {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_16).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_16).y + yOff) + ".00\" id=\"" + currID + "\" net=\"" + locationsSheetID.get((int)var12_16) + "\" show=\"1\" grparent=\"" + this.grParents.get((int)var12_16) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            } else {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_16).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_16).y + yOff) + ".00\" id=\"" + (this.grParents.get((int)var12_16) - 3) + "\" net=\"" + locationsSheetID.get((int)var12_16) + "\" show=\"1\" grparent=\"" + this.grParents.get((int)var12_16) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            }
            ++var12_16;
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"ID\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        this.write(bw, "          <![CDATA[" + this.globalTransID + "]]>");
        this.write(bw, "          <graphics count=\"" + locations + "\">");
        xOff = 25;
        yOff = 20;
        boolean bl2 = false;
        while (var12_18 < locations) {
            if (var12_18 == false) {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_18).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_18).y + yOff) + ".00\" id=\"" + currID + "\" net=\"" + locationsSheetID.get((int)var12_18) + "\" show=\"0\" grparent=\"" + this.grParents.get((int)var12_18) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            } else {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_18).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_18).y + yOff) + ".00\" id=\"" + (this.grParents.get((int)var12_18) - 2) + "\" net=\"" + locationsSheetID.get((int)var12_18) + "\" show=\"0\" grparent=\"" + this.grParents.get((int)var12_18) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            }
            ++var12_18;
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"Logic\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        if (locations == 1) {
            this.write(bw, "          <![CDATA[0]]>");
        } else {
            this.write(bw, "          <![CDATA[1]]>");
        }
        this.write(bw, "          <graphics count=\"0\"/>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"Comment\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        this.write(bw, "          <![CDATA[" + this.holmesTransition.getComment() + "]]>");
        this.write(bw, "          <graphics count=\"" + locations + "\">");
        xOff = 40;
        yOff = 0;
        boolean bl3 = false;
        while (var12_20 < locations) {
            if (var12_20 == false) {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_20).x + xOff) + ".00\" y=\"" + this.grParentsLocation.get((int)var12_20).y + ".00\" id=\"" + currID + "\" net=\"" + locationsSheetID.get((int)var12_20) + "\" show=\"0\" grparent=\"" + this.grParents.get((int)var12_20) + "\" state=\"" + stateForEL.get((int)var12_20) + "\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            } else {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_20).x + xOff) + ".00\" y=\"" + this.grParentsLocation.get((int)var12_20).y + ".00\" id=\"" + (this.grParents.get((int)var12_20) - 1) + "\" net=\"" + locationsSheetID.get((int)var12_20) + "\" show=\"0\" grparent=\"" + this.grParents.get((int)var12_20) + "\" state=\"" + stateForEL.get((int)var12_20) + "\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            }
            ++var12_20;
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        if (++currID != this.grParents.get(0)) {
            GUIManager.getDefaultGUIManager().log("Critical error: Snoopy ID's do not match while writing", "errer", true);
        }
        this.write(bw, "        <graphics count=\"" + locations + "\">");
        if (currID != this.grParents.get(0)) {
            GUIManager.getDefaultGUIManager().log("Critical error while writing Snoopy file. ID's don't match.", "error", true);
        }
        Color color = EditorResources.transDefColor;
        Object brushStr = "255,255,255";
        if (!color.equals(new Color(224, 224, 224))) {
            brushStr = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        for (int i2 = 0; i2 < locations; ++i2) {
            this.write(bw, "          <graphic x=\"" + this.grParentsLocation.get((int)i2).x + ".00\" y=\"" + this.grParentsLocation.get((int)i2).y + ".00\" id=\"" + this.grParents.get(i2) + "\" net=\"" + locationsSheetID.get(i2) + "\" show=\"1\" w=\"20.00\" h=\"20.00\" state=\"1\" pen=\"0,0,0\" brush=\"" + (String)brushStr + "\"/>");
        }
        this.write(bw, "        </graphics>");
        this.write(bw, "      </node>");
        return this.grParents.get(locations - 1);
    }

    protected void write(BufferedWriter bw, String text) {
        try {
            bw.write(text + "\n");
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (116799585) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        int tPos = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().indexOf(this.holmesTransition);
        txt.append("T").append(tPos).append(" [gTransID:").append(this.globalTransID).append("]");
        txt.append(" [SnoopyStartID: ").append(this.snoopyStartingID).append("]");
        if (this.grParents.size() > 0) {
            txt.append(" [gParentID:");
            for (int x : this.grParents) {
                txt.append(" ").append(x);
            }
            txt.append("]");
        }
        return txt.toString();
    }
}

