/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io.snoopy;

import holmes.darkgui.GUIManager;
import holmes.files.io.snoopy.SnoopyToolClass;
import holmes.graphpanel.EditorResources;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.varia.NetworkTransformations;
import java.awt.Color;
import java.awt.Point;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class SnoopyWriterPlace {
    private Place holmesPlace;
    public int snoopyStartingID = -1;
    public int globalPlaceID = -1;
    public ArrayList<Integer> grParents = new ArrayList();
    public ArrayList<Point> grParentsLocation = new ArrayList();
    public boolean portal = false;

    public SnoopyWriterPlace() {
    }

    public SnoopyWriterPlace(Place p) {
        this();
        this.holmesPlace = p;
    }

    /*
     * WARNING - void declaration
     */
    public int writePlaceInfoToFile(BufferedWriter bw, int newFreeId, int globalID) {
        int i;
        void var12_16;
        int yOff;
        int xOff;
        void var12_14;
        this.snoopyStartingID = newFreeId;
        this.globalPlaceID = globalID;
        int currID = this.snoopyStartingID;
        int locations = 1;
        ArrayList<Integer> locationsSheetID = new ArrayList<Integer>();
        int netMainID = 0;
        boolean isInterface = false;
        for (ElementLocation elementLocation : this.holmesPlace.getElementLocations()) {
            if (elementLocation.accessMetaInArcs().size() <= 0 && elementLocation.accessMetaOutArcs().size() <= 0) continue;
            isInterface = true;
            break;
        }
        ArrayList<Integer> stateForEL = new ArrayList<Integer>();
        for (ElementLocation el3 : this.holmesPlace.getElementLocations()) {
            locationsSheetID.add(el3.getSheetID() + 1);
            if (isInterface) {
                if (el3.getSheetID() != 0) {
                    stateForEL.add(8);
                } else if (el3.accessMetaInArcs().size() > 0 || el3.accessMetaOutArcs().size() > 0) {
                    stateForEL.add(4);
                } else {
                    stateForEL.add(1);
                }
            } else {
                stateForEL.add(1);
            }
            if (locations == 1) {
                currID += 10;
            } else if (locations == 2) {
                currID += 36;
                this.portal = true;
            } else {
                currID += 11;
                this.portal = true;
            }
            this.grParents.add(currID);
            Point pxy = el3.getPosition();
            if (GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorGridAlignWhenSaved").equals("1")) {
                pxy = NetworkTransformations.alignToGrid(pxy);
            }
            this.grParentsLocation.add(pxy);
            ++locations;
        }
        Iterator iterator = locationsSheetID.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            if (x != 1) continue;
            netMainID = 1;
        }
        if (netMainID == 0) {
            netMainID = (Integer)locationsSheetID.get(0);
        }
        currID = this.snoopyStartingID;
        if (--locations == 1) {
            this.write(bw, "      <node id=\"" + currID + "\" net=\"" + netMainID + "\">");
        } else {
            this.write(bw, "      <node id=\"" + currID + "\" net=\"" + netMainID + "\" logic=\"1\">");
        }
        this.write(bw, "        <attribute name=\"Name\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        this.write(bw, "          <![CDATA[" + this.holmesPlace.getName() + "]]>");
        this.write(bw, "          <graphics count=\"" + locations + "\">");
        boolean bl = false;
        while (var12_14 < locations) {
            xOff = this.holmesPlace.getTextLocation_X((int)var12_14, GUIManager.locationMoveType.NAME);
            yOff = this.holmesPlace.getTextLocation_Y((int)var12_14, GUIManager.locationMoveType.NAME);
            yOff = SnoopyToolClass.getNormalizedY(yOff);
            if (var12_14 == false) {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_14).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_14).y + yOff) + ".00\" id=\"" + currID + "\" net=\"" + locationsSheetID.get((int)var12_14) + "\" show=\"1\" grparent=\"" + this.grParents.get((int)var12_14) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            } else {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_14).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_14).y + yOff) + ".00\" id=\"" + (this.grParents.get((int)var12_14) - 4) + "\" net=\"" + locationsSheetID.get((int)var12_14) + "\" show=\"1\" grparent=\"" + this.grParents.get((int)var12_14) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            }
            ++var12_14;
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"ID\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        this.write(bw, "          <![CDATA[" + this.globalPlaceID + "]]>");
        this.write(bw, "          <graphics count=\"" + locations + "\">");
        xOff = 25;
        yOff = 20;
        boolean bl2 = false;
        while (var12_16 < locations) {
            if (var12_16 == false) {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_16).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_16).y + yOff) + ".00\" id=\"" + currID + "\" net=\"" + locationsSheetID.get((int)var12_16) + "\" show=\"0\" grparent=\"" + this.grParents.get((int)var12_16) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            } else {
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)var12_16).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)var12_16).y + yOff) + ".00\" id=\"" + (this.grParents.get((int)var12_16) - 3) + "\" net=\"" + locationsSheetID.get((int)var12_16) + "\" show=\"0\" grparent=\"" + this.grParents.get((int)var12_16) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            }
            ++var12_16;
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"Marking\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        int n = this.holmesPlace.getTokensNumber();
        this.write(bw, "          <![CDATA[" + n + "]]>");
        this.write(bw, "          <graphics count=\"" + locations + "\">");
        for (i = 0; i < locations; ++i) {
            if (i == 0) {
                this.write(bw, "            <graphic x=\"" + this.grParentsLocation.get((int)i).x + ".00\" y=\"" + this.grParentsLocation.get((int)i).y + ".00\" id=\"" + currID + "\" net=\"" + locationsSheetID.get(i) + "\" show=\"1\" grparent=\"" + this.grParents.get(i) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                continue;
            }
            this.write(bw, "            <graphic x=\"" + this.grParentsLocation.get((int)i).x + ".00\" y=\"" + this.grParentsLocation.get((int)i).y + ".00\" id=\"" + (this.grParents.get(i) - 2) + "\" net=\"" + locationsSheetID.get(i) + "\" show=\"1\" grparent=\"" + this.grParents.get(i) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"Logic\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        if (locations == 1) {
            this.write(bw, "          <![CDATA[0]]>");
        } else {
            this.write(bw, "          <![CDATA[1]]>");
        }
        this.write(bw, "          <graphics count=\"0\"/>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"Comment\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        this.write(bw, "          <![CDATA[" + this.holmesPlace.getComment() + "]]>");
        this.write(bw, "          <graphics count=\"" + locations + "\">");
        xOff = 0;
        yOff = 40;
        for (i = 0; i < locations; ++i) {
            if (i == 0) {
                this.write(bw, "            <graphic yoff=\"" + yOff + ".00\" x=\"" + this.grParentsLocation.get((int)i).x + ".00\" y=\"" + (this.grParentsLocation.get((int)i).y + yOff) + ".00\" id=\"" + currID + "\" net=\"" + locationsSheetID.get(i) + "\" show=\"0\" grparent=\"" + this.grParents.get(i) + "\" state=\"" + stateForEL.get(i) + "\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                continue;
            }
            this.write(bw, "            <graphic yoff=\"" + yOff + ".00\" x=\"" + this.grParentsLocation.get((int)i).x + ".00\" y=\"" + (this.grParentsLocation.get((int)i).y + yOff) + ".00\" id=\"" + (this.grParents.get(i) - 1) + "\" net=\"" + locationsSheetID.get(i) + "\" show=\"0\" grparent=\"" + this.grParents.get(i) + "\" state=\"" + stateForEL.get(i) + "\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <graphics count=\"" + locations + "\">");
        if (++currID != this.grParents.get(0)) {
            GUIManager.getDefaultGUIManager().log("Critical error while writing Snoopy file. ID's don't match.", "error", true);
        }
        Color snoopyColor = EditorResources.placeDefColor;
        Object brushStr = "255,255,255";
        if (!snoopyColor.equals(Color.WHITE)) {
            brushStr = snoopyColor.getRed() + "," + snoopyColor.getGreen() + "," + snoopyColor.getBlue();
        }
        for (int i3 = 0; i3 < locations; ++i3) {
            this.write(bw, "          <graphic x=\"" + this.grParentsLocation.get((int)i3).x + ".00\" y=\"" + this.grParentsLocation.get((int)i3).y + ".00\" id=\"" + this.grParents.get(i3) + "\" net=\"" + locationsSheetID.get(i3) + "\" show=\"1\" w=\"20.00\" h=\"20.00\" state=\"1\" pen=\"0,0,0\" brush=\"" + (String)brushStr + "\"/>");
        }
        this.write(bw, "        </graphics>");
        this.write(bw, "      </node>");
        return this.grParents.get(locations - 1);
    }

    private void write(BufferedWriter bw, String text) {
        try {
            bw.write(text + "\n");
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (198617391) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        int pPos = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().indexOf(this.holmesPlace);
        txt.append("P").append(pPos).append(" [gPlaceID:").append(this.globalPlaceID).append("]");
        txt.append(" [SnoopyStartID: ").append(this.snoopyStartingID).append("]");
        if (this.grParents.size() > 0) {
            txt.append(" [gParentID:");
            for (int x : this.grParents) {
                txt.append(" ").append(x);
            }
            txt.append("]");
        }
        return txt.toString();
    }
}

