/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io.snoopy;

import holmes.darkgui.GUIManager;
import holmes.files.io.snoopy.SnoopyToolClass;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.varia.NetworkTransformations;
import java.awt.Point;
import java.io.BufferedWriter;
import java.util.ArrayList;

public class SnoopyWriterCoarse {
    private MetaNode coarseNode;
    public int snoopyStartingID = -1;
    public int globalCoarseID = -1;
    public ArrayList<Integer> grParents = new ArrayList();
    public ArrayList<Point> grParentsLocation = new ArrayList();

    public SnoopyWriterCoarse() {
    }

    public SnoopyWriterCoarse(MetaNode m) {
        this();
        this.coarseNode = m;
    }

    public int writeMetaNodeInfoToFile(BufferedWriter bw, int newFreeId, int globalID) {
        this.snoopyStartingID = newFreeId;
        this.globalCoarseID = globalID;
        int currID = this.snoopyStartingID;
        ElementLocation alphaAndOmega = this.coarseNode.getElementLocations().get(0);
        int netMainID = alphaAndOmega.getSheetID() + 1;
        int subnetID = this.coarseNode.getRepresentedSheetID() + 1;
        this.grParents.add(currID + 5);
        Point pxy = alphaAndOmega.getPosition();
        if (GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorGridAlignWhenSaved").equals("1")) {
            pxy = NetworkTransformations.alignToGrid(pxy);
        }
        this.grParentsLocation.add(pxy);
        currID = this.snoopyStartingID;
        this.write(bw, "      <node id=\"" + currID + "\" net=\"" + netMainID + "\" coarse=\"" + subnetID + "\">");
        this.write(bw, "        <attribute name=\"Name\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        ++currID;
        this.write(bw, "          <![CDATA[" + this.coarseNode.getName() + "]]>");
        this.write(bw, "          <graphics count=\"1\">");
        int xOff = this.coarseNode.getTextLocation_X(0, GUIManager.locationMoveType.NAME);
        int yOff = this.coarseNode.getTextLocation_Y(0, GUIManager.locationMoveType.NAME);
        yOff = SnoopyToolClass.getNormalizedY(yOff);
        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" yoff=\"" + yOff + ".00\" x=\"" + (this.grParentsLocation.get((int)0).x + xOff) + ".00\" y=\"" + (this.grParentsLocation.get((int)0).y + yOff) + ".00\" id=\"" + currID + "\" net=\"" + netMainID + "\" show=\"1\" grparent=\"" + this.grParents.get(0) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <attribute name=\"Comment\" id=\"" + ++currID + "\" net=\"" + netMainID + "\">");
        this.write(bw, "          <![CDATA[" + this.coarseNode.getComment() + "]]>");
        this.write(bw, "          <graphics count=\"1\">");
        xOff = 40;
        yOff = 0;
        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (this.grParentsLocation.get((int)0).x + xOff) + ".00\" y=\"" + this.grParentsLocation.get((int)0).y + ".00\" id=\"" + ++currID + "\" net=\"" + netMainID + "\" show=\"0\" grparent=\"" + this.grParents.get(0) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <graphics count=\"1\">");
        if (++currID != this.grParents.get(0)) {
            GUIManager.getDefaultGUIManager().log("Critical error while writing Snoopy file. ID's don't match.", "error", true);
        }
        this.write(bw, "          <graphic x=\"" + this.grParentsLocation.get((int)0).x + ".00\" y=\"" + this.grParentsLocation.get((int)0).y + ".00\" id=\"" + this.grParents.get(0) + "\" net=\"" + netMainID + "\" show=\"1\" w=\"20.00\" h=\"20.00\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
        this.write(bw, "        </graphics>");
        this.write(bw, "      </node>");
        return this.grParents.get(0);
    }

    private void write(BufferedWriter bw, String text) {
        try {
            bw.write(text + "\n");
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (620782847) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public String toString() {
        Object txt = "";
        String type = this.coarseNode.getMetaType() == MetaNode.MetaType.SUBNETPLACE ? "[cPlace]" : "[cTrans]";
        int mPos = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMetaNodes().indexOf(this.coarseNode);
        txt = (String)txt + "M" + mPos + " [gcID:" + this.globalCoarseID + "]";
        txt = (String)txt + " [SnoopyStartID: " + this.snoopyStartingID + "]";
        txt = (String)txt + " " + type;
        if (this.grParents.size() > 0) {
            txt = (String)txt + " [gParentID:" + this.grParents.get(0) + "]";
        }
        return txt;
    }
}

