/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io.snoopy;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class SnoopyReader {
    private ArrayList<Arc> arcList = new ArrayList();
    private ArrayList<Node> nodesList = new ArrayList();
    private ArrayList<Integer> snoopyNodesIdList = new ArrayList();
    private ArrayList<Integer> snoopyCoarseNodesIdList = new ArrayList();
    private ArrayList<ArrayList<Integer>> snoopyNodesElLocIDList = new ArrayList();
    private ArrayList<ArrayList<Integer>> snoopyCoarseNodesElLocIDList = new ArrayList();
    private boolean warnings = false;

    public SnoopyReader(int type, String path) {
        this.coreReader(path);
        if (this.warnings) {
            GUIManager.getDefaultGUIManager().log("Warnings while reading file.", "error", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coreReader(String filepath) {
        BufferedReader buffer = null;
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(filepath));
            buffer = new BufferedReader(new InputStreamReader(dis));
            GUIManager.getDefaultGUIManager().log("Reading Snoopy file: " + filepath, "text", true);
            this.readNodesBlock(buffer);
            this.readArcsBlock(buffer);
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Reading Snoopy net failed.", "error", true);
        }
        finally {
            try {
                buffer.close();
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error: 818881476 | Exception " + ex, "error", true);
            }
        }
    }

    private void readNodesBlock(BufferedReader buffer) throws IOException {
        String line = buffer.readLine();
        if (!line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<nodeclass count=") && !line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<nodeclass count=\"0\"") && line.contains("name=\"Place\"")) {
            this.readSnoopyPlaces(buffer, line);
        }
        if (!line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<nodeclass count=") && !line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<nodeclass count=\"0\"") && line.contains("name=\"Transition\"")) {
            this.readSnoopyTransitions(buffer, line);
        }
        if (!line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<nodeclass count=") && !line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<nodeclass count=\"0\"")) {
            this.readSnoopyCoarsePlaces(buffer, line);
        }
        if (!line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<nodeclass count=") && !line.contains("</nodeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<nodeclass count=\"0\"")) {
            this.readSnoopyCoarseTransitions(buffer, line);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSnoopyPlaces(BufferedReader buffer, String line) {
        backFirstLine = line;
        placesCounter = -1;
        placesLimit = 0;
        try {
            line = line.substring(line.indexOf("count=") + 7);
            line = line.substring(0, line.indexOf("\""));
            placesLimit = Integer.parseInt(line) - 1;
            readForward = true;
            goBoldly = true;
            block4: while (true) {
                if (!line.contains("<node id=\"")) {
                    line = buffer.readLine();
                    if (!line.contains("</nodeclass>")) continue;
                    readForward = false;
                }
                if (!readForward || line.contains("</nodeclass>")) break;
                nodeSnoopyID = (int)this.getAttributeValue(line, " id=\"", -1.0);
                if (nodeSnoopyID == -1) {
                    GUIManager.getDefaultGUIManager().log("Error: program cannot read Snoopy Place ID from line: " + backFirstLine, "error", true);
                    break;
                }
                this.snoopyNodesIdList.add(nodeSnoopyID);
                subNet = (int)this.getAttributeValue(line, " net=\"", 0.0);
                if (subNet > 0) {
                    --subNet;
                }
                place = new Place(IdGenerator.getNextId(), subNet, new Point(100, 100));
                this.nodesList.add(place);
                ++placesCounter;
                if (nodeSnoopyID == 951675) {
                    var11_12 = true;
                }
                goBoldly = true;
                logicalELNumber_names = -1;
                logicalELNumber_graphics = -1;
                firstPass = true;
                readAnything = false;
                while (goBoldly) {
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!line.contains("<attribute name=\"")) {
                        line = buffer.readLine();
                    }
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!firstPass && !readAnything) {
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    firstPass = false;
                    readAnything = false;
                    if (line.contains("<attribute name=\"Name\"")) {
                        readAnything = true;
                        name = "Locus" + placesCounter;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (line.contains("<![CDATA[")) {
                                name = this.readStrCDATA(buffer, line, (String)name);
                                place.setName((String)name);
                            }
                            if (!line.contains("<graphic ")) continue;
                            ++logicalELNumber_names;
                            xOff = (int)this.getAttributeValue(line, " xoff=\"", 0.0);
                            yOff = (int)this.getAttributeValue(line, " yoff=\"", 0.0);
                            sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                            if (sub != 0) {
                                --sub;
                            }
                            if ((yOff -= 20) < -8) {
                                yOff = -55;
                            }
                            if (!GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorUseSnoopyOffsets").equals("1")) {
                                xOff = 0;
                                yOff = 0;
                            }
                            if (logicalELNumber_names == 0) {
                                place.getTextsLocations(GUIManager.locationMoveType.NAME).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                                place.getTextsLocations(GUIManager.locationMoveType.ALPHA).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                                place.getTextsLocations(GUIManager.locationMoveType.BETA).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                                place.getTextsLocations(GUIManager.locationMoveType.GAMMA).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                                place.getTextsLocations(GUIManager.locationMoveType.TAU).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                                continue;
                            }
                            place.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(xOff, yOff), place));
                            place.getTextsLocations(GUIManager.locationMoveType.ALPHA).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                            place.getTextsLocations(GUIManager.locationMoveType.BETA).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                            place.getTextsLocations(GUIManager.locationMoveType.GAMMA).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                            place.getTextsLocations(GUIManager.locationMoveType.TAU).set(0, new ElementLocation(sub, new Point(xOff, yOff), place));
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"ID\"")) {
                        readAnything = true;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Marking\"")) {
                        readAnything = true;
                        tokens = 0;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (!line.contains("<![CDATA[")) continue;
                            tokens = (int)this.readDoubleCDATA(buffer, line, 0.0);
                        }
                        place.setTokensNumber(tokens);
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Logic\"")) {
                        readAnything = true;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Comment\"")) {
                        readAnything = true;
                        wittyComment = "";
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (!line.contains("<![CDATA[")) continue;
                            wittyComment = this.readStrCDATA(buffer, line, "");
                        }
                        place.setComment(wittyComment);
                        line = buffer.readLine();
                    }
                    if (!line.contains("<graphics count=\"")) continue;
                    readAnything = true;
                    subIDs = new ArrayList<Integer>();
                    while (!(line = buffer.readLine()).contains("</graphics>")) {
                        if (!line.contains("<graphic ")) continue;
                        ++logicalELNumber_graphics;
                        x = (int)this.getAttributeValue(line, " x=\"", 100.0);
                        y = (int)this.getAttributeValue(line, " y=\"", 100.0);
                        sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                        elLocID = (int)this.getAttributeValue(line, " id=\"", 0.0);
                        brush = this.getAttributeValueStr(line, " brush=\"", "255,255,255");
                        this.setBrushColor(place, brush);
                        if (sub != 0) {
                            --sub;
                        }
                        resizeFactor = 1.0;
                        try {
                            addF = Integer.parseInt(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("programSnoopyLoaderNetExtFactor"));
                            resizeFactor = (double)addF / 100.0;
                            if (resizeFactor == 0.0) {
                                resizeFactor = 1.0;
                            }
                        }
                        catch (Exception ex) {
                            GUIManager.getDefaultGUIManager().log("Error (721736374) | Exception:  " + ex.getMessage(), "error", true);
                        }
                        x = (int)((double)x * resizeFactor);
                        y = (int)((double)y * resizeFactor);
                        if (logicalELNumber_graphics == 0) {
                            place.getElementLocations().set(0, new ElementLocation(sub, new Point(x, y), place));
                            subIDs.add(elLocID);
                            continue;
                        }
                        place.getElementLocations().add(new ElementLocation(sub, new Point(x, y), place));
                        subIDs.add(elLocID);
                    }
                    this.snoopyNodesElLocIDList.add(subIDs);
                }
                if (logicalELNumber_graphics > 0) {
                    place.setPortal(true);
                }
                if (logicalELNumber_graphics == logicalELNumber_names) continue;
                this.warnings = true;
                GUIManager.getDefaultGUIManager().log("Warning: names locations number and graphics locations number vary for place " + place.getName(), "warning", true);
                GUIManager.getDefaultGUIManager().log(" Fix: resetting names locations (offsets) array.", "warning", true);
                place.getTextsLocations(GUIManager.locationMoveType.NAME).clear();
                place.getTextsLocations(GUIManager.locationMoveType.ALPHA).clear();
                place.getTextsLocations(GUIManager.locationMoveType.BETA).clear();
                place.getTextsLocations(GUIManager.locationMoveType.GAMMA).clear();
                place.getTextsLocations(GUIManager.locationMoveType.TAU).clear();
                i = 0;
                while (true) {
                    if (i < place.getElementLocations().size()) ** break;
                    continue block4;
                    sub = place.getElementLocations().get(i).getSheetID();
                    place.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(0, 0), place));
                    place.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sub, new Point(0, 0), place));
                    place.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sub, new Point(0, 0), place));
                    place.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sub, new Point(0, 0), place));
                    place.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sub, new Point(0, 0), place));
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Reading Snoopy places failed in line:", "error", true);
            GUIManager.getDefaultGUIManager().log(line, "error", true);
        }
        if (placesCounter != placesLimit) {
            this.warnings = true;
            GUIManager.getDefaultGUIManager().log("Warning: places read: " + (placesCounter + 1) + ", places number set in file: " + (placesLimit + 1), "warning", true);
        }
    }

    private void setBrushColor(Node node, String brush) {
        try {
            String[] tableRGB = brush.split(",");
            int r = Integer.parseInt(tableRGB[0]);
            int g = Integer.parseInt(tableRGB[1]);
            int b = Integer.parseInt(tableRGB[2]);
            if (r == 255 && g == 255 && b == 255) {
                return;
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (288907374) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSnoopyTransitions(BufferedReader buffer, String line) {
        backFirstLine = line;
        transitionsCounter = -1;
        transitionsLimit = 0;
        try {
            line = line.substring(line.indexOf("count=") + 7);
            line = line.substring(0, line.indexOf("\""));
            transitionsLimit = Integer.parseInt(line) - 1;
            readForward = true;
            goBoldly = true;
            block4: while (true) {
                if (!line.contains("<node id=\"")) {
                    line = buffer.readLine();
                    if (!line.contains("</nodeclass>")) continue;
                    readForward = false;
                }
                if (!readForward || line.contains("</nodeclass>")) break;
                nodeSnoopyID = (int)this.getAttributeValue(line, " id=\"", -1.0);
                if (nodeSnoopyID == -1) {
                    GUIManager.getDefaultGUIManager().log("Catastrophic error: could not read Snoopy Transition ID from line: " + backFirstLine, "error", true);
                    break;
                }
                this.snoopyNodesIdList.add(nodeSnoopyID);
                subNet = (int)this.getAttributeValue(line, " net=\"", 0.0);
                if (subNet > 0) {
                    --subNet;
                }
                transition = new Transition(IdGenerator.getNextId(), subNet, new Point(100, 100));
                this.nodesList.add(transition);
                ++transitionsCounter;
                goBoldly = true;
                logicalELNumber_names = -1;
                logicalELNumber_graphics = -1;
                firstPass = true;
                readAnything = false;
                while (goBoldly) {
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!line.contains("<attribute name=\"")) {
                        line = buffer.readLine();
                    }
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!firstPass && !readAnything) {
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    firstPass = false;
                    readAnything = false;
                    if (line.contains("<attribute name=\"Name\"")) {
                        readAnything = true;
                        name = "Locus" + transitionsCounter;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (line.contains("<![CDATA[")) {
                                name = this.readStrCDATA(buffer, line, (String)name);
                                transition.setName((String)name);
                            }
                            if (!line.contains("<graphic ")) continue;
                            ++logicalELNumber_names;
                            xOff = (int)this.getAttributeValue(line, " xoff=\"", 0.0);
                            yOff = (int)this.getAttributeValue(line, " yoff=\"", 0.0);
                            sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                            if (sub != 0) {
                                --sub;
                            }
                            if ((yOff -= 20) < -8) {
                                yOff = -55;
                            }
                            if (!GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorUseSnoopyOffsets").equals("1")) {
                                xOff = 0;
                                yOff = 0;
                            }
                            if (logicalELNumber_names == 0) {
                                transition.getTextsLocations(GUIManager.locationMoveType.NAME).set(0, new ElementLocation(sub, new Point(xOff, yOff), transition));
                                transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).set(0, new ElementLocation(sub, new Point(xOff, yOff), transition));
                                transition.getTextsLocations(GUIManager.locationMoveType.BETA).set(0, new ElementLocation(sub, new Point(xOff, yOff), transition));
                                transition.getTextsLocations(GUIManager.locationMoveType.GAMMA).set(0, new ElementLocation(sub, new Point(xOff, yOff), transition));
                                transition.getTextsLocations(GUIManager.locationMoveType.TAU).set(0, new ElementLocation(sub, new Point(xOff, yOff), transition));
                                continue;
                            }
                            transition.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(xOff, yOff), transition));
                            transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sub, new Point(xOff, yOff), transition));
                            transition.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sub, new Point(xOff, yOff), transition));
                            transition.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sub, new Point(xOff, yOff), transition));
                            transition.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sub, new Point(xOff, yOff), transition));
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"ID\"")) {
                        readAnything = true;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Logic\"")) {
                        readAnything = true;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Comment\"")) {
                        readAnything = true;
                        wittyComment = "";
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (!line.contains("<![CDATA[")) continue;
                            wittyComment = this.readStrCDATA(buffer, line, "");
                        }
                        transition.setComment(wittyComment);
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Duration\"")) {
                        readAnything = true;
                        tableVector = new ArrayList<Object>();
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (!line.contains("<![CDATA[")) continue;
                            tableVector.add(this.readStrCDATA(buffer, line, ""));
                        }
                        this.parseDuration(transition, tableVector);
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Interval\"")) {
                        readAnything = true;
                        tableVector = new ArrayList<E>();
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (!line.contains("<![CDATA[")) continue;
                            tableVector.add(this.readStrCDATA(buffer, line, ""));
                        }
                        this.parseIntervals(transition, tableVector);
                        line = buffer.readLine();
                    }
                    if (!line.contains("<graphics count=\"")) continue;
                    readAnything = true;
                    subIDs = new ArrayList<Integer>();
                    while (!(line = buffer.readLine()).contains("</graphics>")) {
                        if (!line.contains("<graphic ")) continue;
                        ++logicalELNumber_graphics;
                        x = (int)this.getAttributeValue(line, " x=\"", 100.0);
                        y = (int)this.getAttributeValue(line, " y=\"", 100.0);
                        sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                        elLocID = (int)this.getAttributeValue(line, " id=\"", 0.0);
                        brush = this.getAttributeValueStr(line, " brush=\"", "255,255,255");
                        this.setBrushColor(transition, brush);
                        if (sub != 0) {
                            --sub;
                        }
                        resizeFactor = 1.0;
                        try {
                            addF = Integer.parseInt(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("programSnoopyLoaderNetExtFactor"));
                            resizeFactor = (double)addF / 100.0;
                            if (resizeFactor == 0.0) {
                                resizeFactor = 1.0;
                            }
                        }
                        catch (Exception ex) {
                            GUIManager.getDefaultGUIManager().log("Error (289585336) | Exception:  " + ex.getMessage(), "error", true);
                        }
                        x = (int)((double)x * resizeFactor);
                        y = (int)((double)y * resizeFactor);
                        if (logicalELNumber_graphics == 0) {
                            transition.getElementLocations().set(0, new ElementLocation(sub, new Point(x, y), transition));
                            subIDs.add(elLocID);
                            continue;
                        }
                        transition.getElementLocations().add(new ElementLocation(sub, new Point(x, y), transition));
                        subIDs.add(elLocID);
                    }
                    this.snoopyNodesElLocIDList.add(subIDs);
                    if (!transition.timeExtension.isDPN() && !transition.timeExtension.isTPN()) continue;
                    transition.setTransType(Transition.TransitionType.TPN);
                }
                if (logicalELNumber_graphics > 0) {
                    transition.setPortal(true);
                }
                if (logicalELNumber_graphics == logicalELNumber_names) continue;
                this.warnings = true;
                GUIManager.getDefaultGUIManager().log("Warning: names locations number and graphics locations number vary for transition " + transition.getName(), "warning", true);
                GUIManager.getDefaultGUIManager().log(" Fix: resetting names locations (offsets) array.", "warning", true);
                transition.getTextsLocations(GUIManager.locationMoveType.NAME).clear();
                transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).clear();
                transition.getTextsLocations(GUIManager.locationMoveType.BETA).clear();
                transition.getTextsLocations(GUIManager.locationMoveType.GAMMA).clear();
                transition.getTextsLocations(GUIManager.locationMoveType.TAU).clear();
                i = 0;
                while (true) {
                    if (i < transition.getElementLocations().size()) ** break;
                    continue block4;
                    sub = transition.getElementLocations().get(i).getSheetID();
                    transition.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(0, 0), transition));
                    transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sub, new Point(0, 0), transition));
                    transition.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sub, new Point(0, 0), transition));
                    transition.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sub, new Point(0, 0), transition));
                    transition.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sub, new Point(0, 0), transition));
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Reading Snoopy transitions failed in line:", "error", true);
            GUIManager.getDefaultGUIManager().log(line, "error", true);
        }
        if (transitionsCounter != transitionsLimit) {
            this.warnings = true;
            GUIManager.getDefaultGUIManager().log("Warning: places read: " + (transitionsCounter + 1) + ", places number set in file: " + (transitionsLimit + 1), "warning", true);
        }
    }

    private void parseDuration(Transition transition, ArrayList<Object> tableVector) {
        try {
            transition.timeExtension.setDPNduration(Double.parseDouble((String)tableVector.get(3)));
            transition.timeExtension.setDPNstatus(transition.timeExtension.getDPNduration() != 0.0);
        }
        catch (Exception e) {
            transition.timeExtension.setDPNduration(0.0);
            transition.timeExtension.setDPNstatus(false);
        }
    }

    private void parseIntervals(Transition transition, ArrayList<Object> tableVector) {
        try {
            double eft = Double.parseDouble((String)tableVector.get(4));
            double lft = Double.parseDouble((String)tableVector.get(5));
            transition.timeExtension.setLFT(lft);
            transition.timeExtension.setEFT(eft);
            transition.timeExtension.setTPNstatus(true);
        }
        catch (Exception e) {
            transition.timeExtension.setEFT(0.0);
            transition.timeExtension.setLFT(0.0);
            transition.timeExtension.setTPNstatus(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSnoopyCoarsePlaces(BufferedReader buffer, String line) {
        backFirstLine = line;
        coarsePlacesCounter = -1;
        coarsePlacesLimit = 0;
        try {
            line = line.substring(line.indexOf("count=") + 7);
            line = line.substring(0, line.indexOf("\""));
            coarsePlacesLimit = Integer.parseInt(line) - 1;
            readForward = true;
            goBoldly = true;
            block4: while (true) {
                if (!line.contains("<node id=\"")) {
                    line = buffer.readLine();
                    if (!line.contains("</nodeclass>")) continue;
                    readForward = false;
                }
                if (!readForward || line.contains("</nodeclass>")) break;
                nodeSnoopyID = (int)this.getAttributeValue(line, " id=\"", -1.0);
                nodeCoarseNumber = (int)this.getAttributeValue(line, " coarse=\"", -1.0);
                if (nodeSnoopyID == -1) {
                    GUIManager.getDefaultGUIManager().log("Catastrophic error: could not read Snoopy Coarse Place ID from line: " + backFirstLine, "error", true);
                    break;
                }
                this.snoopyNodesIdList.add(nodeSnoopyID);
                this.snoopyCoarseNodesIdList.add(nodeSnoopyID);
                subNet = (int)this.getAttributeValue(line, " net=\"", 0.0);
                if (subNet > 0) {
                    --subNet;
                }
                metaNode = new MetaNode(subNet, IdGenerator.getNextId(), new Point(100, 100), MetaNode.MetaType.SUBNETPLACE);
                metaNode.setRepresentedSheetID(nodeCoarseNumber - 1);
                this.nodesList.add(metaNode);
                ++coarsePlacesCounter;
                goBoldly = true;
                logicalELNumber_names = -1;
                logicalELNumber_graphics = -1;
                firstPass = true;
                readAnything = false;
                while (goBoldly) {
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!line.contains("<attribute name=\"")) {
                        line = buffer.readLine();
                    }
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!firstPass && !readAnything) {
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    firstPass = false;
                    readAnything = false;
                    if (line.contains("<attribute name=\"Name\"")) {
                        readAnything = true;
                        name = "cPlace" + coarsePlacesCounter;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (line.contains("<![CDATA[")) {
                                name = this.readStrCDATA(buffer, line, (String)name);
                                metaNode.setName((String)name);
                            }
                            if (!line.contains("<graphic ")) continue;
                            ++logicalELNumber_names;
                            xOff = (int)this.getAttributeValue(line, " xoff=\"", 0.0);
                            yOff = (int)this.getAttributeValue(line, " yoff=\"", 0.0);
                            sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                            if (sub != 0) {
                                --sub;
                            }
                            if ((yOff -= 20) < -8) {
                                yOff = -55;
                            }
                            if (!GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorUseSnoopyOffsets").equals("1")) {
                                xOff = 0;
                                yOff = 0;
                            }
                            if (logicalELNumber_names == 0) {
                                metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                continue;
                            }
                            metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Comment\"")) {
                        readAnything = true;
                        wittyComment = "";
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (!line.contains("<![CDATA[")) continue;
                            wittyComment = this.readStrCDATA(buffer, line, "");
                        }
                        metaNode.setComment(wittyComment);
                        line = buffer.readLine();
                    }
                    if (!line.contains("<graphics count=\"")) continue;
                    readAnything = true;
                    subIDs = new ArrayList<Integer>();
                    while (!(line = buffer.readLine()).contains("</graphics>")) {
                        if (!line.contains("<graphic ")) continue;
                        ++logicalELNumber_graphics;
                        x = (int)this.getAttributeValue(line, " x=\"", 100.0);
                        y = (int)this.getAttributeValue(line, " y=\"", 100.0);
                        sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                        elLocID = (int)this.getAttributeValue(line, " id=\"", 0.0);
                        if (sub != 0) {
                            --sub;
                        }
                        resizeFactor = 1.0;
                        try {
                            addF = Integer.parseInt(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("programSnoopyLoaderNetExtFactor"));
                            resizeFactor = (double)addF / 100.0;
                            if (resizeFactor == 0.0) {
                                resizeFactor = 1.0;
                            }
                        }
                        catch (Exception ex) {
                            GUIManager.getDefaultGUIManager().log("Error (805518514) | Exception:  " + ex.getMessage(), "error", true);
                        }
                        x = (int)((double)x * resizeFactor);
                        y = (int)((double)y * resizeFactor);
                        if (logicalELNumber_graphics == 0) {
                            metaNode.getElementLocations().set(0, new ElementLocation(sub, new Point(x, y), metaNode));
                            subIDs.add(elLocID);
                            continue;
                        }
                        metaNode.getElementLocations().add(new ElementLocation(sub, new Point(x, y), metaNode));
                        subIDs.add(elLocID);
                    }
                    this.snoopyNodesElLocIDList.add(subIDs);
                    this.snoopyCoarseNodesElLocIDList.add(subIDs);
                }
                if (logicalELNumber_graphics == logicalELNumber_names) continue;
                this.warnings = true;
                GUIManager.getDefaultGUIManager().log("Warning: names locations number and graphics locations number vary for c-place " + metaNode.getName(), "warning", true);
                GUIManager.getDefaultGUIManager().log(" Fix: resetting names locations (offsets) array.", "warning", true);
                metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).clear();
                i = 0;
                while (true) {
                    if (i < metaNode.getElementLocations().size()) ** break;
                    continue block4;
                    sub = metaNode.getElementLocations().get(i).getSheetID();
                    metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Reading Snoopy coarse places failed in line:", "error", true);
            GUIManager.getDefaultGUIManager().log(line, "error", true);
        }
        if (coarsePlacesCounter != coarsePlacesLimit) {
            this.warnings = true;
            GUIManager.getDefaultGUIManager().log("Warning: c-places read: " + (coarsePlacesCounter + 1) + ", c-places number set in file: " + (coarsePlacesLimit + 1), "warning", true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSnoopyCoarseTransitions(BufferedReader buffer, String line) {
        backFirstLine = line;
        coarseTransitionsCounter = -1;
        coarseTransitionsLimit = 0;
        try {
            line = line.substring(line.indexOf("count=") + 7);
            line = line.substring(0, line.indexOf("\""));
            coarseTransitionsLimit = Integer.parseInt(line) - 1;
            readForward = true;
            goBoldly = true;
            block4: while (true) {
                if (!line.contains("<node id=\"")) {
                    line = buffer.readLine();
                    if (!line.contains("</nodeclass>")) continue;
                    readForward = false;
                }
                if (!readForward || line.contains("</nodeclass>")) break;
                nodeSnoopyID = (int)this.getAttributeValue(line, " id=\"", -1.0);
                nodeCoarseNumber = (int)this.getAttributeValue(line, " coarse=\"", -1.0);
                if (nodeSnoopyID == -1) {
                    GUIManager.getDefaultGUIManager().log("Catastrophic error: could not read Snoopy Coarse Transition ID from line: " + backFirstLine, "error", true);
                    break;
                }
                this.snoopyNodesIdList.add(nodeSnoopyID);
                this.snoopyCoarseNodesIdList.add(nodeSnoopyID);
                subNet = (int)this.getAttributeValue(line, " net=\"", 0.0);
                if (subNet > 0) {
                    --subNet;
                }
                metaNode = new MetaNode(subNet, IdGenerator.getNextId(), new Point(100, 100), MetaNode.MetaType.SUBNETTRANS);
                metaNode.setRepresentedSheetID(nodeCoarseNumber - 1);
                this.nodesList.add(metaNode);
                ++coarseTransitionsCounter;
                goBoldly = true;
                logicalELNumber_names = -1;
                logicalELNumber_graphics = -1;
                firstPass = true;
                readAnything = false;
                while (goBoldly) {
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!line.contains("<attribute name=\"")) {
                        line = buffer.readLine();
                    }
                    if (line.contains("</node>")) {
                        goBoldly = false;
                        continue;
                    }
                    if (!firstPass && !readAnything) {
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                        }
                        line = buffer.readLine();
                    }
                    firstPass = false;
                    readAnything = false;
                    if (line.contains("<attribute name=\"Name\"")) {
                        readAnything = true;
                        name = "cTransition" + coarseTransitionsCounter;
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (line.contains("<![CDATA[")) {
                                name = this.readStrCDATA(buffer, line, (String)name);
                                metaNode.setName((String)name);
                            }
                            if (!line.contains("<graphic ")) continue;
                            ++logicalELNumber_names;
                            xOff = (int)this.getAttributeValue(line, " xoff=\"", 0.0);
                            yOff = (int)this.getAttributeValue(line, " yoff=\"", 0.0);
                            sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                            if (sub != 0) {
                                --sub;
                            }
                            if ((yOff -= 20) < -8) {
                                yOff = -55;
                            }
                            if (!GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorUseSnoopyOffsets").equals("1")) {
                                xOff = 0;
                                yOff = 0;
                            }
                            if (logicalELNumber_names == 0) {
                                metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).set(0, new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                                continue;
                            }
                            metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                            metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sub, new Point(xOff, yOff), metaNode));
                        }
                        line = buffer.readLine();
                    }
                    if (line.contains("<attribute name=\"Comment\"")) {
                        readAnything = true;
                        wittyComment = "";
                        while (!(line = buffer.readLine()).contains("</attribute>")) {
                            if (!line.contains("<![CDATA[")) continue;
                            wittyComment = this.readStrCDATA(buffer, line, "");
                        }
                        metaNode.setComment(wittyComment);
                        line = buffer.readLine();
                    }
                    if (!line.contains("<graphics count=\"")) continue;
                    readAnything = true;
                    subIDs = new ArrayList<Integer>();
                    while (!(line = buffer.readLine()).contains("</graphics>")) {
                        if (!line.contains("<graphic ")) continue;
                        ++logicalELNumber_graphics;
                        x = (int)this.getAttributeValue(line, " x=\"", 100.0);
                        y = (int)this.getAttributeValue(line, " y=\"", 100.0);
                        sub = (int)this.getAttributeValue(line, " net=\"", 0.0);
                        elLocID = (int)this.getAttributeValue(line, " id=\"", 0.0);
                        if (sub != 0) {
                            --sub;
                        }
                        resizeFactor = 1.0;
                        try {
                            addF = Integer.parseInt(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("programSnoopyLoaderNetExtFactor"));
                            resizeFactor = (double)addF / 100.0;
                            if (resizeFactor == 0.0) {
                                resizeFactor = 1.0;
                            }
                        }
                        catch (Exception ex) {
                            GUIManager.getDefaultGUIManager().log("Error (979647504) | Exception:  " + ex.getMessage(), "error", true);
                        }
                        x = (int)((double)x * resizeFactor);
                        y = (int)((double)y * resizeFactor);
                        if (logicalELNumber_graphics == 0) {
                            metaNode.getElementLocations().set(0, new ElementLocation(sub, new Point(x, y), metaNode));
                            subIDs.add(elLocID);
                            continue;
                        }
                        metaNode.getElementLocations().add(new ElementLocation(sub, new Point(x, y), metaNode));
                        subIDs.add(elLocID);
                    }
                    this.snoopyNodesElLocIDList.add(subIDs);
                    this.snoopyCoarseNodesElLocIDList.add(subIDs);
                }
                if (logicalELNumber_graphics == logicalELNumber_names) continue;
                this.warnings = true;
                GUIManager.getDefaultGUIManager().log("Warning: names locations number and graphics locations number vary for c-transition " + metaNode.getName(), "warning", true);
                GUIManager.getDefaultGUIManager().log(" Fix: resetting names locations (offsets) array.", "warning", true);
                metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).clear();
                metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).clear();
                i = 0;
                while (true) {
                    if (i < metaNode.getElementLocations().size()) ** break;
                    continue block4;
                    sub = metaNode.getElementLocations().get(i).getSheetID();
                    metaNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    metaNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sub, new Point(0, 0), metaNode));
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Reading Snoopy coarse transitions failed in line: ", "error", true);
            GUIManager.getDefaultGUIManager().log(line, "error", true);
        }
        if (coarseTransitionsCounter != coarseTransitionsLimit) {
            this.warnings = true;
            GUIManager.getDefaultGUIManager().log("Warning: c-transitions read: " + (coarseTransitionsCounter + 1) + ", c-transitions number set in file: " + (coarseTransitionsLimit + 1), "warning", true);
        }
    }

    private void readArcsBlock(BufferedReader buffer) throws IOException {
        String line = "";
        while (!(line = buffer.readLine()).contains(" <edgeclasses count=\"")) {
        }
        int loc = line.indexOf("count=\"");
        String txtNumber = line.substring(loc + 7);
        loc = txtNumber.indexOf("\"");
        txtNumber = txtNumber.substring(0, loc);
        int arcClasses = Integer.parseInt(txtNumber);
        line = buffer.readLine();
        while (!line.contains("<edgeclass count=") && !line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<edgeclass count=\"0\"") && line.contains("name=\"Edge\"")) {
            this.readEdges(buffer, line, Arc.TypeOfArc.NORMAL);
        }
        if (!line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<edgeclass count=") && !line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<edgeclass count=\"0\"") && line.contains("name=\"Read Edge\"")) {
            this.readEdges(buffer, line, Arc.TypeOfArc.READARC);
        }
        if (!line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<edgeclass count=") && !line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<edgeclass count=\"0\"") && line.contains("name=\"Inhibitor Edge\"")) {
            this.readEdges(buffer, line, Arc.TypeOfArc.INHIBITOR);
        }
        if (!line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<edgeclass count=") && !line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<edgeclass count=\"0\"") && line.contains("name=\"Reset Edge\"")) {
            this.readEdges(buffer, line, Arc.TypeOfArc.RESET);
        }
        if (!line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        while (!line.contains("<edgeclass count=") && !line.contains("</edgeclasses>")) {
            line = buffer.readLine();
        }
        if (!line.contains("<edgeclass count=\"0\"") && line.contains("name=\"Equal Edge\"")) {
            this.readEdges(buffer, line, Arc.TypeOfArc.EQUAL);
        }
    }

    /*
     * Exception decompiling
     */
    private void readEdges(BufferedReader buffer, String line, Arc.TypeOfArc arcType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[UNCONDITIONALDOLOOP]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private double getAttributeValue(String line, String signature, double defaultVal) {
        double result = defaultVal;
        try {
            int location = line.indexOf(signature);
            String tmp = line.substring(location + signature.length());
            location = tmp.indexOf("\"");
            tmp = tmp.substring(0, location);
            result = Double.parseDouble(tmp);
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (251415203) | Exception:  " + ex.getMessage(), "error", true);
        }
        return result;
    }

    private String getAttributeValueStr(String line, String signature, String defaultVal) {
        String result = defaultVal;
        try {
            int location = line.indexOf(signature);
            String tmp = line.substring(location + signature.length());
            location = tmp.indexOf("\"");
            result = tmp.substring(0, location);
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (835501362) | Exception:  " + ex.getMessage(), "error", true);
        }
        return result;
    }

    private String readStrCDATA(BufferedReader buffer, String line, String defaultVal) {
        try {
            StringBuilder resultLine = new StringBuilder(line);
            boolean reset = false;
            while (!line.contains("]]>")) {
                buffer.mark(1024);
                line = buffer.readLine();
                resultLine.append(line);
                reset = true;
            }
            if (reset) {
                buffer.reset();
            }
            int location = resultLine.indexOf("[CDATA[");
            resultLine = new StringBuilder(resultLine.substring(location + 7));
            location = resultLine.indexOf("]]>");
            resultLine = new StringBuilder(resultLine.substring(0, location));
            return resultLine.toString();
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    private double readDoubleCDATA(BufferedReader buffer, String line, double defaultVal) {
        try {
            StringBuilder resultLine = new StringBuilder(line);
            boolean reset = false;
            while (!line.contains("]]>")) {
                buffer.mark(1024);
                line = buffer.readLine();
                resultLine.append(line);
                reset = true;
            }
            if (reset) {
                buffer.reset();
            }
            int location = resultLine.indexOf("[CDATA[");
            resultLine = new StringBuilder(resultLine.substring(location + 7));
            location = resultLine.indexOf("]]>");
            resultLine = new StringBuilder(resultLine.substring(0, location));
            return Double.parseDouble(resultLine.toString());
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public ArrayList<Arc> getArcList() {
        return this.arcList;
    }

    public ArrayList<Node> getNodesList() {
        return this.nodesList;
    }
}

