/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class MCSoperations {
    public static boolean saveSingleMCS(MCSDataMatrix data, int pos, String name) {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("ObjR single MCS data file (.objR)", new String[]{"OBJR"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "Select objR MCS file target path", "");
        if (!((String)selectedFile).equals("")) {
            String extension = ".objR";
            if (!((String)selectedFile).contains(extension)) {
                selectedFile = (String)selectedFile + extension;
            }
            try {
                PrintWriter pw = new PrintWriter((String)selectedFile);
                pw.write("Objective reaction: " + name + "\n");
                pw.write("Location:" + pos + "\n");
                Object buffer = "";
                ArrayList<ArrayList<Integer>> dataMatrix = data.getMCSlist(pos);
                ArrayList<ArrayList<Integer>> infoMatrix = data.getMCSlistInfo(pos);
                int currentProcessed = 0;
                for (ArrayList<Integer> set : dataMatrix) {
                    buffer = "[";
                    for (int el : set) {
                        buffer = (String)buffer + el + ",";
                    }
                    buffer = (String)buffer + "]";
                    buffer = ((String)buffer).replace(",]", "]");
                    ArrayList<Integer> infoSet = infoMatrix.get(currentProcessed);
                    buffer = (String)buffer + " info: [";
                    for (int el : infoSet) {
                        buffer = (String)buffer + el + ",";
                    }
                    buffer = (String)buffer + "]";
                    buffer = ((String)buffer).replace(",]", "]\n");
                    ++currentProcessed;
                    pw.write((String)buffer);
                }
                pw.close();
                return true;
            }
            catch (Exception e) {
                GUIManager.getDefaultGUIManager().log("MCS data file writing operation failed.", "error", true);
                return false;
            }
        }
        JOptionPane.showMessageDialog(null, "Incorrect file location.", "Operation failed.", 0);
        return false;
    }

    public static boolean saveAllMCS(MCSDataMatrix data) {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("MCS full data file (.mcs)", new String[]{"MCS"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "Select MCS data file target path", "");
        if (!((String)selectedFile).equals("")) {
            String extension = ".mcs";
            if (!((String)selectedFile).contains(extension)) {
                selectedFile = (String)selectedFile + extension;
            }
            try {
                PrintWriter pw = new PrintWriter((String)selectedFile);
                int dataSize = data.accessMCStransitions().size();
                pw.write("MCS list size:" + dataSize + "\n");
                for (int i = 0; i < dataSize; ++i) {
                    Object buffer = "";
                    pw.write("[[" + data.accessMCStransitions().get(i) + "]]\n");
                    ArrayList<ArrayList<Integer>> dataMatrix = data.accessMCSdata().get(i);
                    ArrayList<ArrayList<Integer>> infoMatrix = data.accessMCSinfo().get(i);
                    int currentProcessed = 0;
                    for (ArrayList<Integer> set : dataMatrix) {
                        buffer = "--[";
                        for (int el : set) {
                            buffer = (String)buffer + el + ",";
                        }
                        buffer = (String)buffer + "]";
                        buffer = ((String)buffer).replace(",]", "]");
                        ArrayList<Integer> infoSet = infoMatrix.get(currentProcessed);
                        buffer = (String)buffer + " info: [";
                        for (int el : infoSet) {
                            buffer = (String)buffer + el + ",";
                        }
                        buffer = (String)buffer + "]";
                        buffer = ((String)buffer).replace(",]", "]\n");
                        ++currentProcessed;
                        pw.write((String)buffer);
                    }
                }
                pw.close();
                return true;
            }
            catch (Exception e) {
                GUIManager.getDefaultGUIManager().log("MCS data file writing operation failed.", "error", true);
                return false;
            }
        }
        return false;
    }

    public static boolean loadSingleMCS() {
        FileFilter[] filters;
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        String selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("ObjR single MCS data file (.objr)", new String[]{"OBJR"})}, "Load", "Select objR MCS data file", "");
        if (selectedFile.equals("")) {
            JOptionPane.showMessageDialog(null, "Incorrect file location.", "Operation failed.", 0);
            return false;
        }
        MCSDataMatrix dataCore = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore();
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(selectedFile));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(dis));
            String line = "";
            line = buffer.readLine();
            line = line.substring(line.indexOf(":") + 1);
            GUIManager.getDefaultGUIManager().accessMCSWindow().accessLogField().append("Read line:" + line + "\n");
            line = buffer.readLine();
            int index = line.indexOf(":");
            line = line.substring(index + 1);
            int insertPos = Integer.parseInt(line);
            int transSize = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size();
            int dataSize = dataCore.getSize();
            if (dataSize == 0) {
                dataCore.initiateMCS();
                dataSize = dataCore.getSize();
            }
            if (insertPos >= dataSize) {
                JOptionPane.showMessageDialog(null, "Invalid entry location. Not enough transition in net.", "Operation failed.", 0);
                buffer.close();
                return false;
            }
            GUIManager.getDefaultGUIManager().accessMCSWindow().accessLogField().append("Net transition: " + GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(insertPos).getName() + "\n");
            ArrayList<ArrayList<Integer>> dataMatrix = new ArrayList<ArrayList<Integer>>();
            ArrayList<ArrayList<Integer>> infoMatrix = new ArrayList<ArrayList<Integer>>();
            line = buffer.readLine();
            while (line != null && line.contains("[")) {
                int separator = line.indexOf("info");
                String secondLine = line.substring(separator + 5);
                line = line.substring(0, separator - 1);
                line = line.substring(line.indexOf("[") + 1);
                line = line.substring(0, line.length() - 1);
                String[] numberOfSet = (line = line.trim()).split(",");
                if (numberOfSet.length == 0) {
                    line = buffer.readLine();
                    continue;
                }
                ArrayList<Integer> set = new ArrayList<Integer>();
                for (String element : numberOfSet) {
                    int t = Integer.parseInt(element);
                    if (t >= transSize) {
                        JOptionPane.showMessageDialog(null, "Transition index in read MCS set exceed transitions number!", "Operation failed.", 0);
                        buffer.close();
                        GUIManager.getDefaultGUIManager().accessMCSWindow().accessLogField().append("MCS data for given transition read: failed.\n");
                        return false;
                    }
                    set.add(t);
                }
                dataMatrix.add(set);
                secondLine = secondLine.substring(secondLine.indexOf("[") + 1);
                secondLine = secondLine.substring(0, secondLine.length() - 1);
                secondLine = secondLine.trim();
                String[] secondInfoSet = secondLine.split(",");
                if (secondInfoSet.length == 0) {
                    line = buffer.readLine();
                    continue;
                }
                ArrayList<Integer> infoSet = new ArrayList<Integer>();
                for (String element : secondInfoSet) {
                    int t = Integer.parseInt(element);
                    infoSet.add(t);
                }
                infoMatrix.add(infoSet);
                line = buffer.readLine();
            }
            dataCore.insertMCS(dataMatrix, infoMatrix, insertPos, true);
            GUIManager.getDefaultGUIManager().accessMCSWindow().accessLogField().append("MCS data for given transition read: success.\n");
            buffer.close();
            return true;
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Reading MCS data file failed. File corrupt.", "error", true);
            GUIManager.getDefaultGUIManager().accessMCSWindow().accessLogField().append("MCS data for given transition read: failed.\n");
            return false;
        }
    }

    public static boolean loadAllMCS() {
        FileFilter[] filters;
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        String selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("MCS full data file (.mcs)", new String[]{"MCS"})}, "Load", "Select MCS data file", "");
        if (selectedFile.equals("")) {
            JOptionPane.showMessageDialog(null, "Incorrect file location.", "Operation failed.", 0);
            return false;
        }
        MCSDataMatrix dataCore = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore();
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(selectedFile));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(dis));
            String line = "";
            line = buffer.readLine();
            int index = line.indexOf(":");
            line = line.substring(index + 1);
            int dataSize = Integer.parseInt(line);
            int transSize = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size();
            if (dataSize != transSize) {
                JOptionPane.showMessageDialog(null, "MCS data file refers to different number of transitions!", "Operation failed.", 0);
                buffer.close();
                return false;
            }
            if (!dataCore.checkDataReplacing()) {
                buffer.close();
                return false;
            }
            dataCore.initiateMCS();
            line = buffer.readLine();
            int readData = 0;
            while (line != null && line.contains("[[")) {
                ++readData;
                line = buffer.readLine();
                if (line == null) break;
                if (line.contains("[[")) continue;
                ArrayList<ArrayList<Integer>> dataVector = new ArrayList<ArrayList<Integer>>();
                ArrayList<ArrayList<Integer>> infoMatrix = new ArrayList<ArrayList<Integer>>();
                while (line.contains("--")) {
                    int separator = line.indexOf("info");
                    String secondLine = line.substring(separator + 5);
                    line = line.substring(0, separator - 1);
                    line = line.substring(line.indexOf("[") + 1);
                    line = line.substring(0, line.length() - 1);
                    String[] numberOfSet = (line = line.trim()).split(",");
                    if (numberOfSet.length == 0) {
                        line = buffer.readLine();
                        continue;
                    }
                    ArrayList<Integer> set = new ArrayList<Integer>();
                    for (String element : numberOfSet) {
                        int t = Integer.parseInt(element);
                        set.add(t);
                    }
                    dataVector.add(set);
                    secondLine = secondLine.substring(secondLine.indexOf("[") + 1);
                    secondLine = secondLine.substring(0, secondLine.length() - 1);
                    secondLine = secondLine.trim();
                    String[] secondInfoSet = secondLine.split(",");
                    if (secondInfoSet.length == 0) {
                        line = buffer.readLine();
                        continue;
                    }
                    ArrayList<Integer> infoSet = new ArrayList<Integer>();
                    for (String element : secondInfoSet) {
                        int t = Integer.parseInt(element);
                        infoSet.add(t);
                    }
                    infoMatrix.add(infoSet);
                    line = buffer.readLine();
                    if (line != null) continue;
                    break;
                }
                dataCore.insertMCS(dataVector, infoMatrix, readData - 1, false);
            }
            if (transSize != readData) {
                JOptionPane.showMessageDialog(null, "Warning! Not all MCS data have been read!", "Operation malfunction.", 2);
            }
            int dataMCSsize = dataCore.getCalculatedMCSnumber();
            GUIManager.getDefaultGUIManager().accessMCSWindow().accessLogField().append("MCS data for whole net have been read: " + dataMCSsize + " lists with sets.\n");
            buffer.close();
            return true;
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Reading MCS data file failed. File corrupt.", "error", true);
            return false;
        }
    }
}

