/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.clusters;

import holmes.darkgui.GUIManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import rcaller.RCaller;
import rcaller.RCode;

public class Rprotocols
implements Runnable {
    String pathToR;
    String pathOutput;
    String fileNameCSV;
    String scriptName;
    String miara_odl;
    String algorytm_c;
    int nrClusters;
    String commands;
    String scriptNamePearson;
    String commandsPearson;
    int processingMode = 0;
    ArrayList<String> commandsValidate;

    @Override
    public void run() {
        try {
            if (this.processingMode == 0) {
                this.executeAllClustersScripts();
                this.scriptName = this.scriptNamePearson;
                this.commands = this.commandsPearson;
                this.executeAllClustersScripts();
            } else if (this.processingMode == 1) {
                this.executeCHmetricScripts();
                this.scriptName = this.scriptNamePearson;
                this.commands = this.commandsPearson;
                this.executeCHmetricScripts();
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error: 579016465 (Rprotocols) | Exception " + ex, "error", true);
        }
    }

    public void setForRunnableAllClusters(String pathToR, String pathOutput, String fileNameCSV, String scriptName, String commands, String pearsonScript, String pearsonCommand, int nrClusters, ArrayList<String> commandsValidate) {
        this.pathToR = pathToR;
        this.pathOutput = pathOutput;
        this.fileNameCSV = fileNameCSV;
        this.scriptName = scriptName;
        this.nrClusters = nrClusters;
        this.commands = commands;
        this.scriptNamePearson = pearsonScript;
        this.commandsPearson = pearsonCommand;
        this.commandsValidate = commandsValidate;
    }

    public Rprotocols() {
    }

    public Rprotocols(int mode) {
        this();
        this.setWorkingMode(mode);
    }

    public void setWorkingMode(int mode) {
        this.processingMode = mode;
    }

    String getFileContent(String source) throws IOException {
        String linia;
        FileReader we = new FileReader(source);
        BufferedReader in = new BufferedReader(we);
        StringBuilder sb = new StringBuilder();
        while ((linia = in.readLine()) != null) {
            sb.append(linia).append("\n");
        }
        in.close();
        return sb.toString();
    }

    public void executeCHmetricScripts() throws IOException {
        String line;
        File file = new File(this.scriptName);
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        String str = new String(data, "UTF-8");
        BufferedReader br = new BufferedReader(new FileReader(this.commands));
        while ((line = br.readLine()) != null) {
            if (!this.commandsValidate.contains(line)) continue;
            RCaller rcaller = new RCaller();
            RCode code = new RCode();
            rcaller.setRscriptExecutable(this.pathToR);
            rcaller.cleanRCode();
            code.addRCode(str);
            GUIManager.getDefaultGUIManager().log("Processing CH: " + line, "text", true);
            String function = "veni1(" + line + ", \"" + this.pathOutput + "\",\"" + this.fileNameCSV + "\"," + this.nrClusters + ")";
            code.addRCode(function);
            String replaced = line.replace("\"", "");
            String[] parts = replaced.split(",");
            String filename = this.pathOutput + parts[1] + "_" + parts[0] + "_clusters.txt";
            rcaller.redirectROutputToFile(filename, false);
            rcaller.setRCode(code);
            rcaller.runOnly();
        }
        br.close();
        GUIManager.getDefaultGUIManager().log("All Celi\u0144ski-Harabasz metrics has been computed.", "text", true);
    }

    public void executeAllClustersScripts() throws IOException {
        String line;
        File file = new File(this.scriptName);
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        String str = new String(data, "UTF-8");
        BufferedReader br = new BufferedReader(new FileReader(this.commands));
        while ((line = br.readLine()) != null) {
            if (!this.commandsValidate.contains(line)) continue;
            RCaller rcaller = new RCaller();
            RCode code = new RCode();
            rcaller.setRscriptExecutable(this.pathToR);
            rcaller.cleanRCode();
            code.addRCode(str);
            GUIManager.getDefaultGUIManager().log("Processing: " + line, "text", true);
            String function = "veni1(" + line + ", \"" + this.pathOutput + "\",\"" + this.fileNameCSV + "\"," + this.nrClusters + ")";
            code.addRCode(function);
            String replaced = line.replace("\"", "");
            String[] parts = replaced.split(",");
            String filename = this.pathOutput + parts[1] + "_" + parts[0] + "_clusters.txt";
            rcaller.redirectROutputToFile(filename, false);
            rcaller.setRCode(code);
            rcaller.runOnly();
        }
        br.close();
        GUIManager.getDefaultGUIManager().log("All clusterings has been computed.", "text", true);
    }

    public String generateSingleClustering(String pathToR, String pathOutput, String fileNameCSV, String scriptName, String miara_odl, String algorytm_c, int nrClusters) throws IOException {
        File file = new File(scriptName);
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        String str = new String(data, "UTF-8");
        RCaller rcaller = new RCaller();
        RCode code = new RCode();
        rcaller.setRscriptExecutable(pathToR);
        rcaller.cleanRCode();
        code.addRCode(str);
        String function = "veni1(\"" + miara_odl + "\",\"" + algorytm_c + "\", \"" + pathOutput + "\",\"" + fileNameCSV + "\"," + nrClusters + ")";
        code.addRCode(function);
        String filename = pathOutput + algorytm_c + "_" + miara_odl + "_clusters_ext_" + nrClusters + ".txt";
        rcaller.redirectROutputToFile(filename, false);
        rcaller.setRCode(code);
        rcaller.runOnly();
        return filename;
    }
}

