/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.clusters;

import holmes.clusters.ClusterRepresentation;
import holmes.utilities.ByExt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class RClusteringParserToXLS {
    private static WritableCellFormat getCellFormat(Colour colour, boolean header) throws WriteException {
        WritableFont cellFont;
        if (!header) {
            cellFont = new WritableFont(WritableFont.TIMES, 12);
        } else {
            cellFont = new WritableFont(WritableFont.COURIER, 12);
            cellFont.setBoldStyle(WritableFont.BOLD);
        }
        WritableCellFormat cellFormat = new WritableCellFormat(cellFont);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
        cellFormat.setBackground(colour);
        cellFormat.setAlignment(Alignment.CENTRE);
        return cellFormat;
    }

    private Colour setColorMeanMssPerCluster(double meanValue) {
        if (meanValue >= 0.71) {
            return Colour.DARK_GREEN;
        }
        if (meanValue >= 0.61) {
            return Colour.LIGHT_GREEN;
        }
        if (meanValue >= 0.5) {
            return Colour.SEA_GREEN;
        }
        if (meanValue >= 0.34) {
            return Colour.YELLOW;
        }
        if (meanValue > 0.25) {
            return Colour.LIGHT_ORANGE;
        }
        if (meanValue <= 0.25) {
            return Colour.RED;
        }
        return Colour.WHITE;
    }

    private Colour setColorSingleInvariantPerCluster(int singleInvCluster) {
        if (singleInvCluster <= 4) {
            return Colour.DARK_GREEN;
        }
        if (singleInvCluster <= 9) {
            return Colour.YELLOW;
        }
        if (singleInvCluster >= 10) {
            return Colour.RED;
        }
        return Colour.WHITE;
    }

    private void setTableHeader(WritableSheet sheet, int column) throws WriteException {
        WritableFont cellFont = new WritableFont(WritableFont.COURIER, 14);
        cellFont.setBoldStyle(WritableFont.BOLD);
        WritableCellFormat cellFormat = new WritableCellFormat(cellFont);
        cellFormat.setWrap(true);
        cellFormat.setAlignment(Alignment.CENTRE);
        sheet.addCell(new Label(0, 2, "Distance/Cluster alg.", (CellFormat)cellFormat));
        sheet.setColumnView(0, 30);
        sheet.mergeCells(1, 2, column + 1, 2);
        sheet.addCell(new Label(1, 2, "Silhouette", (CellFormat)cellFormat));
    }

    private void setTableLegend(WritableSheet sheet, int column) throws WriteException {
        WritableFont cellFont = new WritableFont(WritableFont.COURIER, 12);
        cellFont.setBoldStyle(WritableFont.BOLD);
        WritableCellFormat cellFormat = new WritableCellFormat(cellFont);
        cellFormat.setWrap(true);
        cellFormat.setAlignment(Alignment.CENTRE);
        sheet.addCell(new Label(column, 2, "Range", (CellFormat)cellFormat));
        sheet.setColumnView(column, 30);
        sheet.addCell(new Label(column + 1, 2, "Evaluation", (CellFormat)cellFormat));
        sheet.setColumnView(column + 1, 20);
        sheet.addCell(new Label(column, 3, "0.71-1.00", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.9), false)));
        sheet.addCell(new Label(column + 1, 3, "Strong structure", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.9), false)));
        sheet.addCell(new Label(column, 4, "0.61-0.70", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.7), false)));
        sheet.addCell(new Label(column + 1, 4, "Important structure", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.7), false)));
        sheet.addCell(new Label(column, 5, "0.50-0.60", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.6), false)));
        sheet.addCell(new Label(column + 1, 5, "Important structure", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.6), false)));
        sheet.addCell(new Label(column, 6, "0.34-0.49", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.4), false)));
        sheet.addCell(new Label(column + 1, 6, "Weak structure", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.4), false)));
        sheet.addCell(new Label(column, 7, "0.25-0.33", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.3), false)));
        sheet.addCell(new Label(column + 1, 7, "Weak structure", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.3), false)));
        sheet.addCell(new Label(column, 8, "<= 0.25", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.1), false)));
        sheet.addCell(new Label(column + 1, 8, "No structure", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(0.1), false)));
        sheet.addCell(new Label(column, 10, "Single clusters", (CellFormat)cellFormat));
        sheet.addCell(new Label(column + 1, 10, "Evaluation", (CellFormat)cellFormat));
        sheet.addCell(new Label(column, 11, "1-4", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorSingleInvariantPerCluster(1), false)));
        sheet.addCell(new Label(column + 1, 11, "Very good", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorSingleInvariantPerCluster(1), false)));
        sheet.addCell(new Label(column, 12, "5-9", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorSingleInvariantPerCluster(6), false)));
        sheet.addCell(new Label(column + 1, 12, "Quite good", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorSingleInvariantPerCluster(6), false)));
        sheet.addCell(new Label(column, 13, "> 10", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorSingleInvariantPerCluster(11), false)));
        sheet.addCell(new Label(column + 1, 13, "Bad", (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorSingleInvariantPerCluster(11), false)));
    }

    private String getFileContent(String source) throws IOException {
        String linia;
        FileReader we = new FileReader(source);
        BufferedReader in = new BufferedReader(we);
        StringBuilder sb = new StringBuilder();
        while ((linia = in.readLine()) != null) {
            sb.append(linia + "\n");
        }
        in.close();
        return sb.toString();
    }

    private ClusterRepresentation parseSingleClusterInfo(String source) throws NumberFormatException {
        int nrCurrentReadClustersValues = 0;
        ClusterRepresentation clusterSingle = new ClusterRepresentation();
        Pattern pattern = Pattern.compile("in (.*?) clusters");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            int nrClusters;
            String[] lines = source.split("Output:");
            clusterSingle.nrClusters = nrClusters = Integer.parseInt(matcher.group(1));
            for (int i = 2; i < lines.length; ++i) {
                if (nrCurrentReadClustersValues < nrClusters) {
                    String[] mssPerCluster;
                    String[] nrInvariantsPerCluster = lines[i++].split("[\\s\\t\\n]+");
                    for (int j = 1; j < nrInvariantsPerCluster.length; ++j) {
                        clusterSingle.nrInvariantsPerCluster.add(Integer.parseInt(nrInvariantsPerCluster[j]));
                        ++nrCurrentReadClustersValues;
                    }
                    for (String s : mssPerCluster = lines[i].split("[\\s\\t\\n]+")) {
                        clusterSingle.mssPerCluster.add(clusterSingle.ParseDouble(s));
                    }
                    continue;
                }
                if (lines[i].indexOf("Mean") <= 0) continue;
                String[] meanValue = lines[i + 1].trim().split("\\s+");
                clusterSingle.meanValue = clusterSingle.ParseDouble(meanValue[3]);
                break;
            }
        }
        return clusterSingle;
    }

    public void extractAllRClusteringToXLS(String pathInput, String outputFile) throws IOException, WriteException {
        int column;
        int[] tabIndexes = new int[100];
        Arrays.fill(tabIndexes, 3);
        RClusteringParserToXLS r = new RClusteringParserToXLS();
        WritableWorkbook workbook = Workbook.createWorkbook(new File(outputFile));
        WritableSheet sheet = workbook.createSheet("Clusters", 0);
        File fp1 = new File(pathInput);
        ByExt only = new ByExt("_clusters.txt");
        Object[] dirList = fp1.list(only);
        Arrays.sort(dirList);
        for (int columnPosition = 0; columnPosition < 100; ++columnPosition) {
            if (columnPosition % 2 != 0) {
                sheet.setColumnView(columnPosition, 5);
                continue;
            }
            sheet.setColumnView(columnPosition, 15);
        }
        int kolumna = column = 0;
        boolean newColumn = true;
        String compare = ((String)dirList[0]).substring(0, 4);
        for (Object s : dirList) {
            String[] parts;
            String fileContent = r.getFileContent(pathInput + "//" + (String)s);
            String[] clusters = fileContent.split("Output:Silhouette");
            if (((String)s).startsWith(compare)) {
                parts = ((String)s).split("_");
                parts[0] = parts[0].substring(0, 1).toUpperCase() + parts[0].substring(1);
                parts[1] = parts[1].substring(0, 1).toUpperCase() + parts[1].substring(1);
                kolumna = newColumn ? column + 1 : column;
                if (newColumn) {
                    sheet.addCell(new Label(column, tabIndexes[column], parts[1], (CellFormat)RClusteringParserToXLS.getCellFormat(Colour.WHITE, true)));
                }
                sheet.addCell(new Label(kolumna, tabIndexes[column], "1:", (CellFormat)RClusteringParserToXLS.getCellFormat(Colour.WHITE, true)));
                int n = column;
                int n2 = tabIndexes[n];
                tabIndexes[n] = n2 + 1;
                sheet.addCell(new Label(kolumna + 1, n2, parts[0], (CellFormat)RClusteringParserToXLS.getCellFormat(Colour.WHITE, true)));
                if (newColumn) {
                    for (int k = 1; k < clusters.length; ++k) {
                        sheet.addCell(new Number(column, tabIndexes[column] + k - 1, (double)(k + 1), (CellFormat)RClusteringParserToXLS.getCellFormat(Colour.WHITE, false)));
                    }
                }
            } else {
                compare = ((String)s).substring(0, 4);
                column = newColumn ? (column += 3) : (column += 2);
                newColumn = false;
                parts = ((String)s).split("_");
                parts[0] = parts[0].substring(0, 1).toUpperCase() + parts[0].substring(1);
                parts[1] = parts[1].substring(0, 1).toUpperCase() + parts[1].substring(1);
                sheet.addCell(new Label(column, tabIndexes[column], "1:", (CellFormat)RClusteringParserToXLS.getCellFormat(Colour.WHITE, true)));
                int n = column;
                int n3 = tabIndexes[n];
                tabIndexes[n] = n3 + 1;
                sheet.addCell(new Label(column + 1, n3, parts[0], (CellFormat)RClusteringParserToXLS.getCellFormat(Colour.WHITE, true)));
            }
            for (int j = 1; j < clusters.length; ++j) {
                ClusterRepresentation cluster = r.parseSingleClusterInfo(clusters[j]);
                int singleInvCluster = 0;
                kolumna = newColumn ? column + 1 : column;
                for (int k = 0; k < cluster.nrInvariantsPerCluster.size(); ++k) {
                    if (cluster.nrInvariantsPerCluster.get(k) != 1) continue;
                    ++singleInvCluster;
                }
                sheet.addCell(new Number(kolumna, tabIndexes[column], (double)singleInvCluster, (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorSingleInvariantPerCluster(singleInvCluster), false)));
                int n = column;
                int n4 = tabIndexes[n];
                tabIndexes[n] = n4 + 1;
                sheet.addCell(new Number(kolumna + 1, n4, cluster.meanValue, (CellFormat)RClusteringParserToXLS.getCellFormat(this.setColorMeanMssPerCluster(cluster.meanValue), false)));
            }
        }
        this.setTableHeader(sheet, column);
        this.setTableLegend(sheet, column + 3);
        workbook.write();
        workbook.close();
    }
}

