/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.clusters;

import holmes.clusters.Clustering;
import holmes.clusters.ClusteringExtended;
import holmes.darkgui.GUIManager;
import holmes.utilities.Tools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class ClusterReader {
    private String[] fileInfo = ClusterReader.fillFileInfo();

    public ArrayList<ArrayList<Clustering>> readDirectory(String path) {
        if (this.checkFiles(path) == -2) {
            return null;
        }
        if (this.checkFiles(path) == -1) {
            GUIManager.getDefaultGUIManager().log("Some files are still missing in " + path + " Possible further errors.", "error", true);
        }
        ArrayList<ArrayList<Clustering>> bigTable = new ArrayList<ArrayList<Clustering>>();
        for (int metric = 1; metric <= 8; ++metric) {
            for (int alg = 1; alg <= 7; ++alg) {
                int tableLocation = (metric - 1) * 7 + alg;
                String fileName = this.fileInfo[tableLocation];
                String[] splited = fileName.split("_");
                ArrayList<Clustering> table = this.readClusterFile(path + "\\" + fileName, splited[0], splited[1]);
                GUIManager.getDefaultGUIManager().logNoEnter("Processing data for: ", "text", true);
                GUIManager.getDefaultGUIManager().log(splited[0] + " " + splited[1], "italic", false);
                if (table == null) {
                    GUIManager.getDefaultGUIManager().log("Failure to fill the data for " + splited[0] + "/" + splited[1], "error", true);
                }
                bigTable.add(table);
            }
        }
        return bigTable;
    }

    public int checkFiles(String path) {
        int i;
        int result = 0;
        boolean firstFound = false;
        String foundTemplateName = "";
        int[] checkList = new int[57];
        for (i = 1; i <= 56; ++i) {
            File check = new File(path + "\\" + this.fileInfo[i]);
            if (!check.exists()) continue;
            checkList[i] = 1;
            if (firstFound) continue;
            foundTemplateName = this.fileInfo[i];
            firstFound = true;
        }
        if (!firstFound) {
            result = -2;
            GUIManager.getDefaultGUIManager().log("Critical error. Directory " + path + " does not contain any cluster file.", "error", true);
            return result;
        }
        for (i = 1; i <= 56; ++i) {
            if (checkList[i] != 0) continue;
            try {
                GUIManager.getDefaultGUIManager().logNoEnter("Missing file: " + this.fileInfo[i], "warning", true);
                Tools.copyFileByPath(path + "\\" + foundTemplateName, path + "\\" + this.fileInfo[i] + ".tmp");
                this.nullFile(path + "\\" + this.fileInfo[i] + ".tmp", path);
                GUIManager.getDefaultGUIManager().log(" - Fixed: recreated clean.", "text", false);
                continue;
            }
            catch (IOException e) {
                GUIManager.getDefaultGUIManager().log("Restoring missing file has failed.", "error", true);
                GUIManager.getDefaultGUIManager().log("Error: " + e.getMessage(), "error", true);
                result = -1;
            }
        }
        return result;
    }

    private void nullFile(String filePath, String path) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            BufferedWriter bw = new BufferedWriter(new FileWriter(path + "\\c_tmp.txt"));
            while ((line = br.readLine()) != null) {
                if (!line.contains("Output:Silhouette of ")) {
                    line = line.replaceAll("(-)?\\d+(\\.\\d*)?", "0");
                }
                bw.write(line + "\n");
            }
            br.close();
            bw.close();
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Critical error. Cleaning file " + filePath + " has failed.", "error", true);
        }
        try {
            String newFilePath = filePath.replace(".tmp", "");
            Tools.copyFileByPath(path + "\\c_tmp.txt", newFilePath);
            File d = new File(path + "\\c_tmp.txt");
            d.delete();
            d = new File(filePath);
            d.delete();
        }
        catch (IOException e) {
            GUIManager.getDefaultGUIManager().log("Critical error. Creating of cleaning file " + filePath + " has failed.", "error", true);
        }
    }

    public ArrayList<Clustering> readClusterFile(String path, String nameAlg, String nameMetr) {
        File x = new File(path);
        if (!x.exists()) {
            return null;
        }
        ArrayList<Clustering> resTable = new ArrayList<Clustering>();
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = br.readLine()) != null) {
                int i;
                if (!line.contains("Output:Silhouette of")) continue;
                Clustering entry = new Clustering();
                String[] splited = line.split("\\s+");
                entry.invNumber = Integer.parseInt(splited[2]);
                entry.clusterNumber = Integer.parseInt(splited[5]);
                if (entry.clusterNumber < 1) {
                    entry.clusterNumber = 1;
                }
                if (nameAlg.equals("average")) {
                    nameAlg = "UPGMA";
                }
                entry.algorithmName = nameAlg;
                entry.metricName = nameMetr;
                line = br.readLine();
                int readValues = 0;
                while (!(line = br.readLine()).contains("Output:Individual")) {
                    line = line.replace(":", " ");
                    String[] line1 = line.split("\\s+");
                    line = br.readLine();
                    line = line.replace(":", " ");
                    String[] line2 = line.split("\\s+");
                    for (int i2 = 1; i2 < line1.length; ++i2) {
                        entry.clusterSize.add(Integer.parseInt(line1[i2]));
                        entry.clusterMSS.add(Float.valueOf(Float.parseFloat(line2[i2])));
                        if (++readValues - 1 <= entry.clusterNumber) continue;
                        throw new Exception();
                    }
                }
                line = br.readLine();
                line = br.readLine();
                splited = (line = line.replace(":", " ")).split("\\s+");
                if (splited.length != 7) {
                    throw new Exception();
                }
                for (i = 1; i < 7; ++i) {
                    entry.vectorMSS.add(Float.valueOf(Float.parseFloat(splited[i])));
                }
                entry.evalMSS = Float.parseFloat(splited[4]);
                for (i = 0; i < entry.clusterNumber; ++i) {
                    if (entry.clusterSize.get(i) != 1) continue;
                    ++entry.zeroClusters;
                }
                resTable.add(entry);
            }
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Critical error in readCluserFile while reading " + path, "error", true);
        }
        return resTable;
    }

    public ClusteringExtended readSingleClustering(String[] filePaths, Clustering dataPackage) {
        Object line;
        BufferedReader br;
        if (filePaths.length < 3) {
            return null;
        }
        ClusteringExtended data = new ClusteringExtended();
        data.metaData = Clustering.clone(dataPackage);
        int transitionNumber = 0;
        File csvFile = new File(filePaths[0]);
        File mctFile = new File(filePaths[2]);
        File clustersFile = new File(filePaths[1]);
        GUIManager.getDefaultGUIManager().log("Attempting to extract clustering data from the following files:", "text", true);
        GUIManager.getDefaultGUIManager().logNoEnter("Invariants CSV:  ", "text", false);
        GUIManager.getDefaultGUIManager().log(csvFile.getAbsolutePath(), "italic", false);
        GUIManager.getDefaultGUIManager().logNoEnter("MCT master file: ", "text", false);
        GUIManager.getDefaultGUIManager().log(mctFile.getAbsolutePath(), "italic", false);
        GUIManager.getDefaultGUIManager().logNoEnter("Clustering file: ", "text", false);
        GUIManager.getDefaultGUIManager().log(clustersFile.getAbsolutePath(), "italic", false);
        if (!csvFile.exists()) {
            GUIManager.getDefaultGUIManager().log("CSV file missing, wrong path: " + filePaths[0], "error", true);
            return null;
        }
        try {
            br = new BufferedReader(new FileReader(csvFile));
            line = br.readLine();
            if (((String)line).charAt(0) != ';') {
                line = ";" + (String)line;
            }
            data.transNames = ((String)line).split(";");
            data.metaData.transNumber = transitionNumber = data.transNames.length - 1;
            data.csvInvariants = new ArrayList();
            while ((line = br.readLine()) != null && ((String)line).length() > 3) {
                ArrayList<Integer> invRow = new ArrayList<Integer>();
                String[] invTmp = ((String)line).split(";");
                int n = Integer.parseInt(invTmp[0]);
                invRow.add(n);
                for (int i = 1; i < invTmp.length; ++i) {
                    invRow.add(Integer.parseInt(invTmp[i]));
                }
                data.csvInvariants.add(invRow);
            }
            br.close();
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("CSV file corrupt, unable to retrieve invariants data. Path: " + filePaths[0], "error", true);
            return null;
        }
        GUIManager.getDefaultGUIManager().log("CSV invariants: extracted.", "text", true);
        if (!mctFile.exists()) {
            GUIManager.getDefaultGUIManager().log("MCT file missing, wrong path: " + filePaths[2], "error", true);
            return null;
        }
        try {
            br = new BufferedReader(new FileReader(mctFile));
            while ((line = br.readLine()) != null && !((String)line).contains("Proper MCT sets")) {
            }
            ArrayList<Object> tmpMCT = new ArrayList<Object>();
            if (line != null && ((String)line).contains("Proper MCT sets")) {
                while ((line = br.readLine()) != null && !((String)line).contains("Single MCT sets") && !((String)line).equals("")) {
                    tmpMCT.add(line);
                }
                br.close();
                data.mctSets = new ArrayList();
                for (String string : tmpMCT) {
                    ArrayList<Integer> newMctList = new ArrayList<Integer>();
                    line = string;
                    line = ((String)line).substring(((String)line).indexOf("{") + 1);
                    line = ((String)line).substring(0, ((String)line).indexOf("}"));
                    line = ((String)line).trim().replaceAll("\\s+", "");
                    String[] tmpSplit = ((String)line).split(",");
                    int lastFound = 0;
                    for (String value : tmpSplit) {
                        int transIndex = -1;
                        for (int k = lastFound; k < data.transNames.length; ++k) {
                            if (!value.equals(data.transNames[k])) continue;
                            transIndex = k;
                            lastFound = k;
                            break;
                        }
                        if (transIndex == -1) {
                            transIndex = -1;
                            GUIManager.getDefaultGUIManager().log("Something is wrong with MCT data. File:" + filePaths[2], "error", true);
                            lastFound = 0;
                        }
                        newMctList.add(transIndex);
                    }
                    data.mctSets.add(newMctList);
                }
            } else {
                GUIManager.getDefaultGUIManager().log("MCT file corrupt. Path: " + filePaths[2], "error", true);
                br.close();
                return null;
            }
            data.metaData.MCTnumber = data.mctSets.size();
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("MCT file reading error. Path: " + filePaths[2], "error", true);
            return null;
        }
        GUIManager.getDefaultGUIManager().log("MCT data: extracted.", "text", true);
        if (!clustersFile.exists()) {
            GUIManager.getDefaultGUIManager().log("Cluster file missing. Path: " + filePaths[1], "error", true);
            return null;
        }
        try {
            br = new BufferedReader(new FileReader(clustersFile));
            while ((line = br.readLine()) != null && !((String)line).contains("Silhouette of ")) {
            }
            if (!((String)line).contains("" + data.metaData.invNumber)) {
                GUIManager.getDefaultGUIManager().log("Critical error. File: " + filePaths[1] + "contains invalid number of invariants previously read from file " + filePaths[1], "error", true);
                br.close();
                return null;
            }
            if (!((String)(line = ((String)line).substring(((String)line).indexOf("" + data.metaData.invNumber) + ("" + data.metaData.invNumber).length()))).contains("" + data.metaData.clusterNumber)) {
                GUIManager.getDefaultGUIManager().log("Critical error. File: " + filePaths[1] + "contains invalid number of clusters.", "error", true);
                br.close();
                return null;
            }
            while ((line = br.readLine()) != null && !((String)line).contains("Cluster sizes and average silhouette widths")) {
            }
            ArrayList<Float> mssVector = new ArrayList<Float>();
            ArrayList<Integer> sizeVector = new ArrayList<Integer>();
            while (!((String)(line = br.readLine())).contains("Output:Individual")) {
                line = ((String)line).replace(":", " ");
                String[] stringArray = ((String)line).split("\\s+");
                line = br.readLine();
                line = ((String)line).replace(":", " ");
                String[] line2 = ((String)line).split("\\s+");
                for (int i = 1; i < stringArray.length; ++i) {
                    mssVector.add(Float.valueOf(Float.parseFloat(line2[i])));
                    sizeVector.add(Integer.parseInt(stringArray[i]));
                }
            }
            data.metaData.clusterMSS = new ArrayList(mssVector);
            data.metaData.clusterSize = new ArrayList(sizeVector);
            while ((line = br.readLine()) != null && !((String)line).contains("[1]")) {
            }
            data.clustersInv = new ArrayList();
            while (line != null && ((String)line).contains("[1]")) {
                StringBuilder stringBuilder = new StringBuilder(((String)line).substring(((String)line).indexOf("]") + 1));
                while ((line = br.readLine()) != null && !((String)line).contains("[1]") && ((String)line).contains("\"")) {
                    line = ((String)line).substring(((String)line).indexOf("]") + 1);
                    stringBuilder.append(((String)line).substring(((String)line).indexOf("]") + 1));
                }
                StringBuilder stringBuilder3 = new StringBuilder(stringBuilder.toString().replace("\"", " "));
                stringBuilder3 = new StringBuilder(stringBuilder3.toString().trim().replaceAll("\\s+", " "));
                String[] clustInv = stringBuilder3.toString().split(" ");
                ArrayList<Integer> cluster = new ArrayList<Integer>();
                for (String s : clustInv) {
                    int invNo = Integer.parseInt(s);
                    cluster.add(invNo - 1);
                }
                data.clustersInv.add(cluster);
            }
            br.close();
            if (data.metaData.clusterNumber != data.clustersInv.size()) {
                GUIManager.getDefaultGUIManager().log("Error: more clusters have been read than should be possible. Cluster file corrupt. Aborting procedure. Path: " + filePaths[1], "error", true);
                return null;
            }
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Cluster file corrupt. Path: " + filePaths[1], "error", true);
            return null;
        }
        GUIManager.getDefaultGUIManager().log("Clustering data: extracted.", "text", true);
        return data;
    }

    public static String[] fillFileInfo() {
        String[] fileNames = new String[57];
        fileNames[1] = "average_correlation_clusters.txt";
        fileNames[2] = "centroid_correlation_clusters.txt";
        fileNames[3] = "complete_correlation_clusters.txt";
        fileNames[4] = "mcquitty_correlation_clusters.txt";
        fileNames[5] = "median_correlation_clusters.txt";
        fileNames[6] = "single_correlation_clusters.txt";
        fileNames[7] = "ward_correlation_clusters.txt";
        fileNames[8] = "average_pearson_clusters.txt";
        fileNames[9] = "centroid_pearson_clusters.txt";
        fileNames[10] = "complete_pearson_clusters.txt";
        fileNames[11] = "mcquitty_pearson_clusters.txt";
        fileNames[12] = "median_pearson_clusters.txt";
        fileNames[13] = "single_pearson_clusters.txt";
        fileNames[14] = "ward_pearson_clusters.txt";
        fileNames[15] = "average_binary_clusters.txt";
        fileNames[16] = "centroid_binary_clusters.txt";
        fileNames[17] = "complete_binary_clusters.txt";
        fileNames[18] = "mcquitty_binary_clusters.txt";
        fileNames[19] = "median_binary_clusters.txt";
        fileNames[20] = "single_binary_clusters.txt";
        fileNames[21] = "ward.D_binary_clusters.txt";
        fileNames[22] = "average_canberra_clusters.txt";
        fileNames[23] = "centroid_canberra_clusters.txt";
        fileNames[24] = "complete_canberra_clusters.txt";
        fileNames[25] = "mcquitty_canberra_clusters.txt";
        fileNames[26] = "median_canberra_clusters.txt";
        fileNames[27] = "single_canberra_clusters.txt";
        fileNames[28] = "ward.D_canberra_clusters.txt";
        fileNames[29] = "average_euclidean_clusters.txt";
        fileNames[30] = "centroid_euclidean_clusters.txt";
        fileNames[31] = "complete_euclidean_clusters.txt";
        fileNames[32] = "mcquitty_euclidean_clusters.txt";
        fileNames[33] = "median_euclidean_clusters.txt";
        fileNames[34] = "single_euclidean_clusters.txt";
        fileNames[35] = "ward.D_euclidean_clusters.txt";
        fileNames[36] = "average_manhattan_clusters.txt";
        fileNames[37] = "centroid_manhattan_clusters.txt";
        fileNames[38] = "complete_manhattan_clusters.txt";
        fileNames[39] = "mcquitty_manhattan_clusters.txt";
        fileNames[40] = "median_manhattan_clusters.txt";
        fileNames[41] = "single_manhattan_clusters.txt";
        fileNames[42] = "ward.D_manhattan_clusters.txt";
        fileNames[43] = "average_maximum_clusters.txt";
        fileNames[44] = "centroid_maximum_clusters.txt";
        fileNames[45] = "complete_maximum_clusters.txt";
        fileNames[46] = "mcquitty_maximum_clusters.txt";
        fileNames[47] = "median_maximum_clusters.txt";
        fileNames[48] = "single_maximum_clusters.txt";
        fileNames[49] = "ward.D_maximum_clusters.txt";
        fileNames[50] = "average_minkowski_clusters.txt";
        fileNames[51] = "centroid_minkowski_clusters.txt";
        fileNames[52] = "complete_minkowski_clusters.txt";
        fileNames[53] = "mcquitty_minkowski_clusters.txt";
        fileNames[54] = "median_minkowski_clusters.txt";
        fileNames[55] = "single_minkowski_clusters.txt";
        fileNames[56] = "ward.D_minkowski_clusters.txt";
        return fileNames;
    }
}

