/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.clusters;

import holmes.darkgui.GUIManager;
import holmes.files.clusters.ClusterReader;
import holmes.utilities.ByExt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class CHmetricReader {
    double ParseDouble(String strNumber) {
        if (strNumber != null && strNumber.length() > 0) {
            try {
                return Double.parseDouble(strNumber);
            }
            catch (Exception e) {
                return -1.0;
            }
        }
        return 0.0;
    }

    private ArrayList<Double> parseSingleClusterInfo(String source) throws NumberFormatException, IOException {
        ArrayList<Double> measureValuesHC = new ArrayList<Double>();
        File file = new File(source);
        if (!file.exists()) {
            return measureValuesHC;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        String str = new String(data, "UTF-8");
        String[] lines = str.split("Output:");
        for (int i = 3; i < lines.length; i += 3) {
            String[] hcValues;
            lines[i] = lines[i].replace("[2,]", "").trim();
            for (String hcValue : hcValues = lines[i].split("[\\s\\t\\n]+")) {
                measureValuesHC.add(this.ParseDouble(hcValue));
            }
        }
        return measureValuesHC;
    }

    public ArrayList<ArrayList<Double>> readCHmetricsDirectory(String CHmetricsPath) {
        ArrayList<ArrayList<Double>> chData = new ArrayList<ArrayList<Double>>();
        Object currentFile = "";
        try {
            File fp1 = new File(CHmetricsPath);
            ByExt only = new ByExt("_clusters.txt");
            String[] tempList = fp1.list(only);
            if (tempList.length != 56) {
                String msg = "Warning. Directory " + CHmetricsPath + " may not contain all necessary files. Operation will continue, but may fail.";
                GUIManager.getDefaultGUIManager().log(msg, "warning", true);
            }
            String[] dirList = ClusterReader.fillFileInfo();
            for (int i = 1; i < dirList.length; ++i) {
                currentFile = CHmetricsPath + "//" + dirList[i];
                ArrayList<Double> measureValuesHS = this.parseSingleClusterInfo((String)currentFile);
                chData.add(measureValuesHS);
            }
        }
        catch (IOException e) {
            GUIManager.getDefaultGUIManager().log("Reading failed for Celi\u0144ski-Harabasz metric in file " + (String)currentFile, "error", true);
        }
        return chData;
    }
}

