/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.toolbar;

import com.javadocking.DockingManager;
import com.javadocking.dock.BorderDock;
import com.javadocking.dock.CompositeLineDock;
import com.javadocking.dock.LineDock;
import com.javadocking.dock.Position;
import com.javadocking.dock.docker.BorderDocker;
import com.javadocking.dock.factory.CompositeToolBarDockFactory;
import com.javadocking.dock.factory.ToolBarDockFactory;
import com.javadocking.dockable.ButtonDockable;
import com.javadocking.dockable.DefaultDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import com.javadocking.visualizer.SingleMaximizer;
import holmes.analyse.GraphletsCalculator;
import holmes.analyse.MDTSCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.toolbar.ToolbarButton;
import holmes.darkgui.toolbar.ToolbarButtonAction;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.StandardRandom;
import holmes.utilities.Tools;
import holmes.varia.NetworkTransformations;
import holmes.windows.HolmesNotepad;
import holmes.windows.managers.HolmesSPNmanager;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;

public class Toolbar
extends BorderDock {
    private static final long serialVersionUID = 640320332920131092L;
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private SingleMaximizer maximizePanel = this.overlord.getMaximizer();
    private BorderDock toolBarBorderDock;
    private CompositeLineDock horizontalCompositeToolBarDock;
    private CompositeLineDock verticalCompositeToolBarDock;
    private LineDock defaultVerticalToolBarDock;
    private boolean buttonsDraggable = false;
    ToolbarButtonAction reverseLoopButton;
    ToolbarButtonAction reverseStepButton;
    ToolbarButtonAction loopSimButton;
    ToolbarButtonAction singleTransitionLoopSimButton;
    ToolbarButtonAction pauseSimButton;
    ToolbarButtonAction stopSimButton;
    ToolbarButtonAction smallStepFwdSimButton;
    ToolbarButtonAction stepFwdSimButton;
    ToolbarButtonAction resetSimButton;
    ArrayList<ButtonDockable> ioButtonsDockables = new ArrayList();
    ArrayList<ButtonDockable> analysisDockables;
    ArrayList<ButtonDockable> netTransformDockables;
    ArrayList<ButtonDockable> simulationDockables;

    public Toolbar() {
        this.createIObuttons();
        BorderDock minimizerBorderDock = new BorderDock(new ToolBarDockFactory());
        minimizerBorderDock.setMode(2);
        minimizerBorderDock.setCenterComponent(this.maximizePanel);
        BorderDocker borderDocker = new BorderDocker();
        borderDocker.setBorderDock(minimizerBorderDock);
        this.setToolBarBorderDock(new BorderDock(new CompositeToolBarDockFactory(), minimizerBorderDock));
        this.getToolBarBorderDock().setMode(1);
        this.horizontalCompositeToolBarDock = new CompositeLineDock(0, false, new ToolBarDockFactory(), 2048, 4096);
        this.verticalCompositeToolBarDock = new CompositeLineDock(1, false, new ToolBarDockFactory(), 2048, 4096);
        this.getToolBarBorderDock().setDock(this.horizontalCompositeToolBarDock, 3);
        this.getToolBarBorderDock().setDock(this.verticalCompositeToolBarDock, 1);
        this.defaultVerticalToolBarDock = new LineDock(1, false, 2048, 4096);
        this.ioButtonsDockables = this.createIObuttons();
        this.horizontalCompositeToolBarDock.addChildDock(this.createHorizontalBarDock(this.ioButtonsDockables), new Position(0));
        this.netTransformDockables = this.createNetTransformBar();
        this.horizontalCompositeToolBarDock.addChildDock(this.createHorizontalBarDock(this.netTransformDockables), new Position(1));
        this.analysisDockables = this.createAnalysisBar();
        this.horizontalCompositeToolBarDock.addChildDock(this.createHorizontalBarDock(this.analysisDockables), new Position(2));
        this.verticalCompositeToolBarDock.addChildDock(this.defaultVerticalToolBarDock, new Position(0));
    }

    public void addAllButtonDockablesHorizontally(ArrayList<ButtonDockable> buttons, LineDock horizontalToolBarDock) {
        int i = 0;
        for (ButtonDockable button : buttons) {
            horizontalToolBarDock.addDockable(button, new Position(i));
            ++i;
        }
    }

    public void addAllButtonDockablesVertically(ArrayList<ButtonDockable> buttons) {
        int i = 0;
        for (ButtonDockable button : buttons) {
            this.defaultVerticalToolBarDock.addDockable(button, new Position(i));
            ++i;
        }
    }

    public LineDock createHorizontalBarDock(ArrayList<ButtonDockable> buttons) {
        LineDock horizontalToolBarDock = new LineDock();
        int i = 0;
        for (ButtonDockable button : buttons) {
            horizontalToolBarDock.addDockable(button, new Position(i));
            ++i;
        }
        return horizontalToolBarDock;
    }

    public LineDock createHorizontalBarDockVaria(JPanel panel) {
        LineDock horizontalToolBarDock = new LineDock();
        DefaultDockable dockable1 = new DefaultDockable("IDPanel1", panel, "PanelDockable", null, 2147354623);
        horizontalToolBarDock.addDockable(dockable1, new Position(0));
        return horizontalToolBarDock;
    }

    private ArrayList<ButtonDockable> createIObuttons() {
        ArrayList<ButtonDockable> ioDockables = new ArrayList<ButtonDockable>();
        ToolbarButtonAction addButton = new ToolbarButtonAction(this, "New project", "Clear current project", Tools.getResIcon48("/icons/toolbar/add_panel.png")){
            private static final long serialVersionUID = -3039335266465055547L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIManager.getDefaultGUIManager().reset.newProjectInitiated();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableAdd", addButton));
        ToolbarButtonAction openButton = new ToolbarButtonAction(this, "Open project...", "Open Abyss project file (.abyss)", Tools.getResIcon48("/icons/toolbar/open.png")){
            private static final long serialVersionUID = -8017306615290773915L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.io.selectAndOpenHolmesProject();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableOpen", openButton));
        ToolbarButtonAction importButton = new ToolbarButtonAction(this, "Import project...", "Import Petri net saved in other file formats", Tools.getResIcon48("/icons/toolbar/import_net.png")){
            private static final long serialVersionUID = 5723070117312880726L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.io.importNetwork();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableImport", importButton));
        ToolbarButtonAction saveProjectButton = new ToolbarButtonAction(this, "Save project", "Save Petri net as Holmes project file (always right option)", Tools.getResIcon48("/icons/toolbar/holmesSave.png")){
            private static final long serialVersionUID = 5723070117312880726L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.io.saveAsAbyssFile();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableImport", saveProjectButton));
        ToolbarButtonAction exportButton = new ToolbarButtonAction(this, "Export net", "Export Petri net to other file formats", Tools.getResIcon48("/icons/toolbar/snoopyExport.png")){
            private static final long serialVersionUID = 5723070117312880726L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.io.saveAsGlobal();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableImport", exportButton));
        ToolbarButtonAction pictureButton = new ToolbarButtonAction(this, "Save picture...", "Save the network as picture", Tools.getResIcon48("/icons/toolbar/save_picture.png")){
            private static final long serialVersionUID = 932011484445458070L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.io.exportProjectToImage();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableImport", pictureButton));
        ToolbarButtonAction refreshButton = new ToolbarButtonAction(this, "Refresh", "Refresh all graph panels with net structures", Tools.getResIcon48("/icons/toolbar/refresh.png")){
            private static final long serialVersionUID = -5107926050446252487L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableRefresh", refreshButton));
        ToolbarButtonAction clearProject = new ToolbarButtonAction(this, "Clear project", "Clears all data of the project", Tools.getResIcon48("/icons/toolbar/clear_project.png")){
            private static final long serialVersionUID = 2969893062492924300L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.reset.newProjectInitiated();
            }
        };
        ioDockables.add(this.createButtonDockable("ButtonDockableRefresh", clearProject));
        return ioDockables;
    }

    private ArrayList<ButtonDockable> createAnalysisBar() {
        ArrayList<ButtonDockable> analysisDockables = new ArrayList<ButtonDockable>();
        ToolbarButtonAction clusterButton = new ToolbarButtonAction(this, "ClusterAnalysis", "Cluster creation and analysis", Tools.getResIcon48("/icons/toolbar/clusters.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.showClusterWindow();
            }
        };
        analysisDockables.add(this.createButtonDockable("Clusters", clusterButton));
        ToolbarButtonAction netTablesButton = new ToolbarButtonAction(this, "NetDataTables", "Show net data as tables", Tools.getResIcon48("/icons/toolbar/netTables.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.showNetTablesWindow();
            }
        };
        analysisDockables.add(this.createButtonDockable("NetTables", netTablesButton));
        ToolbarButtonAction netSimLogButton = new ToolbarButtonAction(this, "NetSimLog", "Network simulation log", Tools.getResIcon32("/icons/toolbar/simLog.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.showSimLogWindow();
            }
        };
        netSimLogButton.setEnabled(false);
        analysisDockables.add(this.createButtonDockable("SimLog", netSimLogButton));
        ToolbarButtonAction consoleButton = new ToolbarButtonAction(this, "ShowConsole", "Show program log console", Tools.getResIcon48("/icons/toolbar/terminal2.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.showConsole(true);
            }
        };
        analysisDockables.add(this.createButtonDockable("ShowConsole", consoleButton));
        ToolbarButtonAction cleanButton = new ToolbarButtonAction(this, "ClearColors", "Restore net default colors", Tools.getResIcon48("/icons/toolbar/cleanGraphColors.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.reset.clearGraphColors();
            }
        };
        analysisDockables.add(this.createButtonDockable("CleanColor", cleanButton));
        ToolbarButtonAction fireRatesButton = new ToolbarButtonAction(this, "FiringRates", "Show Firing rates manager window", Tools.getResIcon48("/icons/toolbar/firingRates.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HolmesSPNmanager(GUIManager.getDefaultGUIManager().getFrame());
            }
        };
        analysisDockables.add(this.createButtonDockable("FiringRates", fireRatesButton));
        ToolbarButtonAction testButton = new ToolbarButtonAction(this, "Debug1", "Debug", Tools.getResIcon48("/icons/toolbar/aaa.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardRandom generator2 = new StandardRandom();
                for (Transition t : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) {
                    int duration;
                    int lft;
                    int eft;
                    t.setTransType(Transition.TransitionType.TPN);
                    int value = (int)generator2.nextLong(10L);
                    if (value > 7) {
                        eft = (int)generator2.nextLong(6L);
                        lft = (int)generator2.nextLong(eft + 6) + 1;
                        duration = (int)generator2.nextLong(10L);
                        t.timeExtension.setDPNstatus(true);
                        t.timeExtension.setTPNstatus(true);
                        t.timeExtension.setLFT(lft);
                        t.timeExtension.setEFT(eft);
                        t.timeExtension.setDPNduration(duration);
                        continue;
                    }
                    if (value > 3) {
                        duration = (int)generator2.nextLong(10L);
                        t.timeExtension.setDPNstatus(true);
                        t.timeExtension.setDPNduration(duration);
                        continue;
                    }
                    eft = (int)generator2.nextLong(6L);
                    lft = (int)generator2.nextLong(eft + 6) + 1;
                    t.timeExtension.setTPNstatus(true);
                    t.timeExtension.setLFT(lft);
                    t.timeExtension.setEFT(eft);
                }
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            }
        };
        ToolbarButtonAction testButton2 = new ToolbarButtonAction(this, "DEBUG2", "Debug2", Tools.getResIcon48("/icons/toolbar/a.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTree test = Toolbar.this.overlord.getToolBox().getTree();
                Toolbar.this.overlord.getToolBox().selectPointer();
                boolean x = true;
                MDTSCalculator mdts = new MDTSCalculator();
                ArrayList<Set<Integer>> results = mdts.calculateMDTS();
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL("", "text");
                notePad.addTextLineNL("Maximal Dependend Transition sets:", "text");
                int setNo = 0;
                for (Set<Integer> set : results) {
                    StringBuilder text = new StringBuilder();
                    text.append("Set #").append(++setNo).append(": [");
                    for (int i : set) {
                        text.append("t").append(i).append(", ");
                    }
                    text.append("]");
                    text = new StringBuilder(text.toString().replace(", ]", "]"));
                    notePad.addTextLineNL(text.toString(), "text");
                }
            }
        };
        ToolbarButtonAction testGraphletButton = new ToolbarButtonAction(this, "Debug1", "Debug", Tools.getResIcon48("/icons/toolbar/aaa.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphletsCalculator.generateGraphlets();
                ArrayList<int[]> GDV = new ArrayList<int[]>();
                boolean test = false;
                if (test) {
                    System.out.println(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().get(1));
                    int[] nArray = GraphletsCalculator.vectorOrbit(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().get(1), test);
                } else {
                    for (Node startNode : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes()) {
                        int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, test);
                        GDV.add(vectorOrbit);
                    }
                    for (int j = 0; j < GDV.size(); ++j) {
                        System.out.print(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().get(j).getName() + " - ");
                        int[] vector = (int[])GDV.get(j);
                        for (int i = 0; i < vector.length; ++i) {
                            if (vector[i] < 0) {
                                System.out.print("X, \t");
                                continue;
                            }
                            System.out.print(vector[i] + "\t ");
                        }
                        System.out.println();
                    }
                }
            }
        };
        return analysisDockables;
    }

    private ArrayList<ButtonDockable> createNetTransformBar() {
        ArrayList<ButtonDockable> analysisDockables = new ArrayList<ButtonDockable>();
        ToolbarButtonAction extendNetButton = new ToolbarButtonAction(this, "ExtNet", "Extend the net by 10%", Tools.getResIcon32("/icons/toolbar/resizeMax.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTransformations nt = new NetworkTransformations();
                nt.extendNetwork(true);
            }
        };
        analysisDockables.add(this.createButtonDockable("EXTnetButton", extendNetButton));
        ToolbarButtonAction shrinkNetButton = new ToolbarButtonAction(this, "ShrNet", "Shrink the net by 10%", Tools.getResIcon32("/icons/toolbar/resizeMin.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTransformations nt = new NetworkTransformations();
                nt.extendNetwork(false);
            }
        };
        analysisDockables.add(this.createButtonDockable("SHRButton", shrinkNetButton));
        ToolbarButtonAction gridButton = new ToolbarButtonAction(this, "ShowGrid", "Show grid line", Tools.getResIcon32("/icons/toolbar/grid.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Toolbar.this.overlord.getSettingsManager().getValue("editorGridLines").equals("1")) {
                    Toolbar.this.overlord.getSettingsManager().setValue("editorGridLines", "0", true);
                } else {
                    Toolbar.this.overlord.getSettingsManager().setValue("editorGridLines", "1", true);
                }
                Toolbar.this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
            }
        };
        analysisDockables.add(this.createButtonDockable("GridButton", gridButton));
        ToolbarButtonAction gridAlignButton = new ToolbarButtonAction(this, "GridAlign", "Align net to grid line", Tools.getResIcon32("/icons/toolbar/gridAlign.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTransformations nt = new NetworkTransformations();
                nt.alignNetToGrid();
                Toolbar.this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
            }
        };
        analysisDockables.add(this.createButtonDockable("GridAlignButton", gridAlignButton));
        return analysisDockables;
    }

    private ButtonDockable createButtonDockable(String id, ToolbarButtonAction action) {
        ToolbarButton button = new ToolbarButton(action);
        ButtonDockable buttonDockable = new ButtonDockable(id, button);
        if (this.buttonsDraggable) {
            this.createDockableDragger(buttonDockable);
        }
        return buttonDockable;
    }

    private void createDockableDragger(Dockable dockable) {
        DragListener dragListener = DockingManager.getDockableDragListenerFactory().createDragListener(dockable);
        dockable.getContent().addMouseListener(dragListener);
        dockable.getContent().addMouseMotionListener(dragListener);
    }

    public BorderDock getToolBarBorderDock() {
        return this.toolBarBorderDock;
    }

    private void setToolBarBorderDock(BorderDock toolBarBorderDock) {
        this.toolBarBorderDock = toolBarBorderDock;
    }

    public void setEnabledSimulationInitiateButtons(boolean enabled) {
        for (int i = 0; i < this.simulationDockables.size(); ++i) {
            if (i == 4 || i == 5) continue;
            this.simulationDockables.get(i).getContent().setEnabled(enabled);
        }
    }

    public void setEnabledSimulationDisruptButtons(boolean enabled) {
        this.simulationDockables.get(4).getContent().setEnabled(enabled);
        this.simulationDockables.get(5).getContent().setEnabled(enabled);
    }

    public void allowOnlySimulationInitiateButtons() {
        this.setEnabledSimulationInitiateButtons(true);
        this.setEnabledSimulationDisruptButtons(false);
    }

    public void allowOnlySimulationDisruptButtons() {
        this.setEnabledSimulationInitiateButtons(false);
        this.setEnabledSimulationDisruptButtons(true);
    }

    public void allowOnlyUnpauseButton() {
        this.allowOnlySimulationDisruptButtons();
        this.simulationDockables.get(5).getContent().setEnabled(false);
    }

    private ArrayList<ButtonDockable> createSimulationBar() {
        ArrayList<ButtonDockable> simulationDockables = new ArrayList<ButtonDockable>();
        this.reverseLoopButton = new ToolbarButtonAction(this, "LoopBack", "Loop back to oldest action saved", Tools.getResIcon48("/icons/toolbar/sim_back.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.LOOP_BACK);
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableStepBack", this.reverseLoopButton));
        this.reverseStepButton = new ToolbarButtonAction(this, "StepBack", "Single action back simulation", Tools.getResIcon48("/icons/toolbar/sim_back_step.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.ACTION_BACK);
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableSmallStepBack", this.reverseStepButton));
        this.loopSimButton = new ToolbarButtonAction(this, "Loop", "Loop simulation", Tools.getResIcon48("/icons/toolbar/sim_start.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.LOOP);
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableLoopSim", this.loopSimButton));
        this.singleTransitionLoopSimButton = new ToolbarButtonAction(this, "LoopSingleTrans", "Loop single transition simulation", Tools.getResIcon48("/icons/toolbar/sim_start_single.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION_LOOP);
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableLoopSingleTransitionSim", this.singleTransitionLoopSimButton));
        this.pauseSimButton = new ToolbarButtonAction(this, "Pause", "Pause simulation", Tools.getResIcon48("/icons/toolbar/sim_pause.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().pause();
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockablePauseSim", this.pauseSimButton));
        this.stopSimButton = new ToolbarButtonAction(this, "Stop", "Schedule a stop for the simulation", Tools.getResIcon48("/icons/toolbar/sim_stop.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().stop();
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableStopSim", this.stopSimButton));
        this.smallStepFwdSimButton = new ToolbarButtonAction(this, "SingleForward", "Single transition forward simulation", Tools.getResIcon48("/icons/toolbar/sim_forward_step.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION);
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableSmallStepFwdSim", this.smallStepFwdSimButton));
        this.stepFwdSimButton = new ToolbarButtonAction(this, "StepForward", "Step forward simulation", Tools.getResIcon48("/icons/toolbar/sim_forward.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                Toolbar.this.overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.STEP);
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableStepFwdSim", this.stepFwdSimButton));
        this.resetSimButton = new ToolbarButtonAction(this, "Reset", "Reset simulator", Tools.getResIcon48("/icons/toolbar/sim_reset.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.overlord.getWorkspace().getProject().restoreMarkingZero();
            }
        };
        simulationDockables.add(this.createButtonDockable("ButtonDockableResetSim", this.resetSimButton));
        return simulationDockables;
    }

    private JPanel createSubtoolsPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setPreferredSize(new Dimension(200, 60));
        panel.setMaximumSize(new Dimension(200, 60));
        JButton button1 = new JButton("Ext.Net");
        button1.setName("extNet");
        button1.setPreferredSize(new Dimension(60, 40));
        button1.setToolTipText("Extend net elements");
        button1.addActionListener(actionEvent -> {});
        panel.add(button1);
        return panel;
    }
}

