/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.settings;

import holmes.darkgui.GUIManager;
import holmes.darkgui.settings.Setting;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class SettingsManager {
    private ArrayList<Setting> settings = new ArrayList();

    public String getValue(String ID) {
        for (Setting s : this.settings) {
            if (!s.getID().equals(ID)) continue;
            return s.getValue();
        }
        return null;
    }

    public int setValue(String ID, String value, boolean save) {
        boolean found = false;
        for (Setting s : this.settings) {
            if (!s.getID().equals(ID)) continue;
            found = true;
            s.setValue(value);
        }
        if (!found) {
            this.settings.add(new Setting(ID, value));
            if (save) {
                this.writeSettingsFile();
            }
            return -1;
        }
        if (save) {
            this.writeSettingsFile();
        }
        return 0;
    }

    private void addSetting(ArrayList<Setting> settings, String ID, String value) {
        for (Setting s : settings) {
            if (!s.getID().equals(ID)) continue;
            Random rand = new Random();
            ID = (String)ID + rand.nextInt(999999);
            break;
        }
        settings.add(new Setting((String)ID, value));
    }

    private void checkAndRestoreSetting() {
        int test;
        String tmp;
        ArrayList<Setting> settingsNew = new ArrayList<Setting>();
        settingsNew.add(new Setting("holmes_version", "1.5.0"));
        this.checkAndFix(settingsNew, "r_path", "c://Program Files//R//R-3.1.2//bin//Rscript.exe");
        this.checkAndFix(settingsNew, "r_path64", "c://Program Files//R//R-3.1.2//bin//x64//Rscript.exe");
        this.checkAndFix(settingsNew, "lastOpenedPath", "");
        this.checkAndFix(settingsNew, "ina_bat", "START INAwin32.exe COMMAND.ina");
        this.checkAndFix(settingsNew, "ina_COMMAND1", " 80 4294901760 0 1 :BNNATTFFFFFFFFTFTFFFFFTFFFFFFTTFFFFTFasiec");
        this.checkAndFix(settingsNew, "ina_COMMAND2", "nnsyp");
        this.checkAndFix(settingsNew, "ina_COMMAND2p", "nnsnnnfnn");
        this.checkAndFix(settingsNew, "ina_COMMAND3", "nnnfnn");
        this.checkAndFix(settingsNew, "ina_COMMAND4", "eqqy");
        this.checkAndFix(settingsNew, "programUseOldSnoopyLoaders", "0");
        this.checkAndFix(settingsNew, "programAskForRonStartup", "0");
        try {
            tmp = this.getValue("programSnoopyLoaderNetExtFactor");
            test = Integer.parseInt(tmp);
            this.checkAndFix(settingsNew, "programSnoopyLoaderNetExtFactor", "100");
        }
        catch (Exception e) {
            settingsNew.add(new Setting("programSnoopyLoaderNetExtFactor", "100"));
        }
        this.checkAndFix(settingsNew, "programUseSimpleEditor", "0");
        this.checkAndFix(settingsNew, "programDebugMode", "0");
        this.checkAndFix(settingsNew, "editorGridLines", "1");
        this.checkAndFix(settingsNew, "editorGridAlignWhenSaved", "1");
        this.checkAndFix(settingsNew, "editorUseSnoopyOffsets", "1");
        try {
            tmp = this.getValue("editorGraphArcLineSize");
            test = Integer.parseInt(tmp);
            if (test < 1 || test > 3) {
                throw new Exception();
            }
            this.checkAndFix(settingsNew, "editorGraphArcLineSize", "1");
        }
        catch (Exception e) {
            settingsNew.add(new Setting("editorGraphArcLineSize", "1"));
        }
        this.checkAndFix(settingsNew, "editor3Dview", "0");
        this.checkAndFix(settingsNew, "editorSnoopyStyleGraphic", "0");
        this.checkAndFix(settingsNew, "editorSnoopyColors", "0");
        this.checkAndFix(settingsNew, "editorSnoopyCompatibleMode", "1");
        this.checkAndFix(settingsNew, "editorShowShortNames", "0");
        this.checkAndFix(settingsNew, "editorExportCheckAndWarning", "1");
        try {
            tmp = this.getValue("editorGraphFontSize");
            test = Integer.parseInt(tmp);
            if (test < 7 || test > 25) {
                throw new Exception();
            }
            this.checkAndFix(settingsNew, "editorGraphFontSize", "11");
        }
        catch (Exception e) {
            settingsNew.add(new Setting("editorGraphFontSize", "11"));
        }
        this.checkAndFix(settingsNew, "editorGraphFontBold", "0");
        this.checkAndFix(settingsNew, "editorSubnetCompressMode", "0");
        this.checkAndFix(settingsNew, "analysisBinaryCSVInvariants", "0");
        this.checkAndFix(settingsNew, "analysisFeasibleSelfPropAccepted", "1");
        this.checkAndFix(settingsNew, "analysisMCSReduction", "1");
        this.checkAndFix(settingsNew, "analysisRemoveNonInv", "0");
        this.checkAndFix(settingsNew, "analysisRemoveSingleElementInv", "0");
        this.checkAndFix(settingsNew, "mctNameShow", "1");
        this.checkAndFix(settingsNew, "simTransReadArcTokenReserv", "1");
        this.checkAndFix(settingsNew, "simPlacesColors", "1");
        this.checkAndFix(settingsNew, "simSingleMode", "1");
        this.checkAndFix(settingsNew, "simTDPNrunWhenEft", "0");
        this.checkAndFix(settingsNew, "simXTPNmassAction", "0");
        this.checkAndFix(settingsNew, "simXTPNreadArcTokens", "0");
        this.checkAndFix(settingsNew, "editorShortNameLowerIndex", "0");
        this.settings = new ArrayList<Setting>(settingsNew);
        this.writeSettingsFile();
    }

    private void checkAndFix(ArrayList<Setting> settings, String ID, String value) {
        if (this.getValue(ID) == null) {
            this.addSetting(settings, ID, value);
        } else {
            this.addSetting(settings, ID, this.getValue(ID));
        }
    }

    private void writeSettingsFile() {
        try {
            File configFile = new File("holmes.cfg");
            FileWriter cfgFileWriter = new FileWriter(configFile, false);
            for (Setting data : this.settings) {
                cfgFileWriter.write(data.getID() + " " + data.getValue() + "\n");
            }
            cfgFileWriter.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "For some reason, settings could not be saved.", "Unknown error", 0);
            GUIManager.getDefaultGUIManager().log("Unknown error, for some reason, settings could not be saved.", "error", true);
        }
    }

    private void readSettingsFile(boolean error) {
        Path path = Paths.get("holmes.cfg", new String[0]);
        this.settings.clear();
        try (Scanner scanner = new Scanner(path);){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                this.settings.add(this.convertLineToSetting(currentLine));
            }
            this.checkAndRestoreSetting();
            GUIManager.getDefaultGUIManager().log("Settings file read:", "text", true);
            for (Setting s : this.settings) {
                GUIManager.getDefaultGUIManager().logNoEnter("ID: ", "bold", false);
                GUIManager.getDefaultGUIManager().logNoEnter(s.getID(), "italic", false);
                GUIManager.getDefaultGUIManager().logNoEnter(" VALUE: ", "bold", false);
                GUIManager.getDefaultGUIManager().log(s.getValue(), "italic", false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "The file \"holmes\".cfg, which normally contains the settings for this application,\nhas not been found or contains invalid values. Restoring default file.", "Settings file not found or damaged", 0);
            GUIManager.getDefaultGUIManager().log("Settings file not found or damaged. The file \"holmes\".cfg, which normally contains the settings for this application, has not been found or contains invalid values. Restoring default file.", "error", true);
            if (error) {
                return;
            }
            this.checkAndRestoreSetting();
            this.writeSettingsFile();
        }
    }

    private Setting convertLineToSetting(String line) {
        try {
            Random rand = new Random();
            Object ID = "";
            String value = "";
            int index = line.indexOf(" ");
            if (index < 1) {
                ID = "Unknown_" + rand.nextInt(999999);
                value = line;
            } else {
                ID = line.substring(0, index);
                value = line.substring(index + 1, line.length());
            }
            return new Setting((String)ID, value);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "The file \"holmes\".cfg, which normally contains the settings for this application, is corrupt. Unable to load settings.", "Settings corrupt, converting line has failed.", 0);
            GUIManager.getDefaultGUIManager().log("Settings corrupt! The file \"holmes\".cfg, which normally contains the settings for this application, is corrupt. Unable to load setting line: ", "error", true);
            GUIManager.getDefaultGUIManager().log(line, "italic", false);
            return null;
        }
    }

    public void loadSettings() {
        this.readSettingsFile(false);
    }

    public void saveSettings() {
        this.writeSettingsFile();
    }
}

