/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.holmesInterface;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;

public class OvalButton
extends JButton
implements MouseListener,
MouseMotionListener {
    public static final int SHAPE_OVAL = 0;
    public static final int SHAPE_CAPSULE = 1;
    public static final int VERTICAL = 2;
    public static final int HORIZONTAL = 4;
    private Color colorNormal;
    private Color colorHighlighted;
    private Color colorBorderNormal;
    private Color colorBorderHighlighted;
    private int borderThickness;
    private boolean borderHighlighted;
    private Color currentBackground;
    protected final int shape;
    protected final int orientation;
    protected double radius;

    public OvalButton() {
        this(0, 2);
    }

    public OvalButton(int shape, int orientation) {
        this(shape, orientation, Color.WHITE, Color.LIGHT_GRAY, Color.BLACK, Color.RED);
    }

    public OvalButton(int shape, int orientation, Color colorNormal, Color colorHighlighted, Color colorBorderNormal, Color colorBorderHighlighted) {
        if (shape != 1 && shape != 0) {
            throw new IllegalArgumentException("Invalid shape chosen for OvalButton: " + shape);
        }
        if (orientation != 2 && orientation != 4) {
            throw new IllegalArgumentException("Invalid orientation chosen for OvalButton: " + orientation);
        }
        this.shape = shape;
        this.orientation = orientation;
        this.radius = 0.5;
        this.colorNormal = colorNormal;
        this.currentBackground = colorNormal;
        this.colorHighlighted = colorHighlighted;
        this.colorBorderNormal = colorBorderNormal;
        this.colorBorderHighlighted = colorBorderHighlighted;
        this.borderThickness = 5;
        this.borderHighlighted = false;
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setColorNormal(Color colorNormal) {
        this.colorNormal = colorNormal;
    }

    public void setColorHighlighted(Color colorHighlighted) {
        this.colorHighlighted = colorHighlighted;
    }

    public void setColorBorderNormal(Color colorBorderNormal) {
        this.colorBorderNormal = colorBorderNormal;
    }

    public void setColorBorderHighlighted(Color colorBorderHighlighted) {
        this.colorBorderHighlighted = colorBorderHighlighted;
    }

    public void setBorderThickness(int borderThickness) {
        this.borderThickness = borderThickness < 0 ? 0 : borderThickness;
    }

    public void setRadius(double newRadius) {
        if (newRadius < 0.0 || newRadius > 1.0) {
            throw new IllegalArgumentException("Invalid radius: " + newRadius);
        }
        this.radius = newRadius;
    }

    public void setHighlightedBorder(boolean isHighlighted) {
        this.borderHighlighted = isHighlighted;
    }

    @Override
    public void addActionListener(ActionListener l) {
        super.addActionListener(e -> {
            if (this.isValidClickPosition(MouseInfo.getPointerInfo().getLocation())) {
                l.actionPerformed(e);
            }
        });
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public boolean isBorderHighlighted() {
        return this.borderHighlighted;
    }

    protected boolean isValidClickPosition(Point screenPosition) {
        if (this.shape == 0) {
            return this.isInOval(screenPosition);
        }
        return this.isInCapsule(screenPosition);
    }

    protected BufferedImage getBackgroundImage() {
        return null;
    }

    private boolean isInOval(Point p) {
        double x = p.x;
        double s1 = this.getLocationOnScreen().x + this.getSize().width / 2;
        double a = this.getSize().width / 2;
        double y = p.y;
        double s2 = this.getLocationOnScreen().y + this.getSize().height / 2;
        double b = this.getSize().height / 2;
        return (x - s1) * (x - s1) / (a * a) + (y - s2) * (y - s2) / (b * b) <= 1.0;
    }

    private boolean isInCapsule(Point p) {
        double x = p.x;
        double y = p.y;
        if (this.orientation == 2) {
            Double r = 0.5 * this.radius * (double)this.getSize().height;
            double buttonX = this.getLocationOnScreen().x;
            double buttonY = this.getLocationOnScreen().y;
            if (y < buttonY + r) {
                double b;
                double s1 = buttonX + (double)(this.getSize().width / 2);
                double a = this.getSize().width / 2;
                double s2 = buttonY + r;
                return (x - s1) * (x - s1) / (a * a) + (y - s2) * (y - s2) / ((b = r.doubleValue()) * b) <= 1.0;
            }
            if (y > buttonY + (double)this.getSize().height - r) {
                double b;
                double s1 = buttonX + (double)(this.getSize().width / 2);
                double a = this.getSize().width / 2;
                double s2 = buttonY + (double)this.getSize().height - r;
                return (x - s1) * (x - s1) / (a * a) + (y - s2) * (y - s2) / ((b = r.doubleValue()) * b) <= 1.0;
            }
            return true;
        }
        Double r = 0.5 * this.radius * (double)this.getSize().width;
        double buttonX = this.getLocationOnScreen().x;
        double buttonY = this.getLocationOnScreen().y;
        if (x < buttonX + r) {
            double b;
            double s1 = buttonX + r;
            double s2 = buttonY + (double)(this.getSize().height / 2);
            double a = r;
            return (x - s1) * (x - s1) / (a * a) + (y - s2) * (y - s2) / ((b = (double)(this.getSize().height / 2)) * b) <= 1.0;
        }
        if (x > buttonX + (double)this.getSize().width - r) {
            double b;
            double s1 = buttonX + (double)this.getSize().width - r;
            double s2 = buttonY + (double)(this.getSize().height / 2);
            double a = r;
            return (x - s1) * (x - s1) / (a * a) + (y - s2) * (y - s2) / ((b = (double)(this.getSize().height / 2)) * b) <= 1.0;
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        if (this.shape == 0) {
            this.paintOval(gr);
        } else if (this.shape == 1) {
            this.paintCapsule(gr);
        }
        super.paintComponent(g);
    }

    private void setMainColor(Graphics g) {
        if (this.isEnabled()) {
            g.setColor(this.currentBackground);
        } else {
            g.setColor(this.colorNormal);
        }
    }

    private void paintOval(Graphics2D g) {
        Dimension d = this.getSize();
        BufferedImage img = this.getBackgroundImage();
        if (img == null) {
            this.setMainColor(g);
            g.fillOval(0, 0, d.width, d.height);
        } else {
            g.setClip(new Ellipse2D.Double(0.0, 0.0, d.width, d.height));
            g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), this);
        }
        Shape border = this.createOvalBorder();
        if (this.borderHighlighted) {
            g.setColor(this.colorBorderHighlighted);
        } else {
            g.setColor(this.colorBorderNormal);
        }
        g.fill(border);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private Shape createOvalBorder() {
        double width = this.getSize().width;
        double height = this.getSize().height;
        Ellipse2D.Double outer = new Ellipse2D.Double(0.0, 0.0, width, height);
        double inX = width / 2.0 - (width / 2.0 - (double)this.borderThickness);
        double inY = height / 2.0 - (height / 2.0 - (double)this.borderThickness);
        double inW = width - (double)(2 * this.borderThickness);
        double inH = height - (double)(2 * this.borderThickness);
        Ellipse2D.Double inner = new Ellipse2D.Double(inX, inY, inW, inH);
        Area area = new Area(outer);
        area.subtract(new Area(inner));
        return area;
    }

    private void paintCapsule(Graphics2D g) {
        Shape mainCapsule = this.createCapsule(0.0, 0.0, this.getWidth(), this.getHeight());
        BufferedImage img = this.getBackgroundImage();
        if (img == null) {
            this.setMainColor(g);
            g.fill(mainCapsule);
        } else {
            g.setClip(mainCapsule);
            g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), this);
        }
        Shape border = this.createCapsuleBorder();
        if (this.borderHighlighted) {
            g.setColor(this.colorBorderHighlighted);
        } else {
            g.setColor(this.colorBorderNormal);
        }
        g.fill(border);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private Shape createCapsule(double x, double y, double width, double height) {
        Ellipse2D.Double lower;
        Rectangle2D.Double middle;
        Ellipse2D.Double upper;
        if (this.orientation == 2) {
            double r = 0.5 * this.radius * height;
            upper = new Ellipse2D.Double(x, y, width, 2.0 * r);
            middle = new Rectangle2D.Double(x, y + r, width, height - 2.0 * r);
            lower = new Ellipse2D.Double(x, y + (height - 2.0 * r), width, 2.0 * r);
        } else {
            double r = 0.5 * this.radius * width;
            upper = new Ellipse2D.Double(x, y, 2.0 * r, height);
            middle = new Rectangle2D.Double(x + r, y, width - 2.0 * r, height);
            lower = new Ellipse2D.Double(x + (width - 2.0 * r), y, 2.0 * r, height);
        }
        Area capsule = new Area(upper);
        capsule.add(new Area(middle));
        capsule.add(new Area(lower));
        return capsule;
    }

    private Shape createCapsuleBorder() {
        double width = this.getSize().width;
        double height = this.getSize().height;
        Shape outer = this.createCapsule(0.0, 0.0, width, height);
        double inX = width / 2.0 - (width / 2.0 - (double)this.borderThickness);
        double inY = height / 2.0 - (height / 2.0 - (double)this.borderThickness);
        double inW = width - (double)(2 * this.borderThickness);
        double inH = height - (double)(2 * this.borderThickness);
        Shape inner = this.createCapsule(inX, inY, inW, inH);
        Area area = new Area(outer);
        area.subtract(new Area(inner));
        return area;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isValidClickPosition(e.getLocationOnScreen())) {
            this.currentBackground = this.colorHighlighted.darker();
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.currentBackground = this.isValidClickPosition(e.getLocationOnScreen()) ? this.colorHighlighted : this.colorNormal;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isValidClickPosition(e.getLocationOnScreen())) {
            this.currentBackground = this.colorHighlighted;
        }
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.currentBackground = this.colorNormal;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.currentBackground = this.isValidClickPosition(e.getLocationOnScreen()) ? this.colorHighlighted : this.colorNormal;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

