/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.holmesInterface;

import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class HolmesRoundedButton
extends JButton {
    private ImageIcon normal;
    private ImageIcon hover;
    private ImageIcon clicked;
    private JLabel title;

    public HolmesRoundedButton(String text, String normalName, String howerName, String clickedName) {
        this.setLayout(new BorderLayout());
        Dimension size = this.getPreferredSize();
        size.width = size.height = Math.max(size.width, size.height);
        this.setPreferredSize(size);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.normal = Tools.getResIcon22("/buttons/" + normalName);
        this.hover = Tools.getResIcon22("/buttons/" + howerName);
        this.clicked = Tools.getResIcon22("/buttons/" + clickedName);
        this.title = new JLabel(text);
        this.title.setHorizontalAlignment(0);
        this.add((Component)this.title, "Center");
    }

    public void setNewText(String text) {
        this.title.setText(text);
    }

    public void repaintBackground(String normalName, String howerName, String clickedName) {
        this.normal = Tools.getResIcon22("/buttons/" + normalName);
        this.hover = Tools.getResIcon22("/buttons/" + howerName);
        this.clicked = Tools.getResIcon22("/buttons/" + clickedName);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int offset = 0;
        g.setColor(this.getBackground());
        if (this.getModel().isArmed()) {
            this.setIcon(HolmesRoundedButton.resizeIcon(this.clicked, this.getWidth() - offset, this.getHeight() - offset));
        } else if (this.getModel().isRollover()) {
            this.setIcon(HolmesRoundedButton.resizeIcon(this.hover, this.getWidth() - offset, this.getHeight() - offset));
        } else {
            this.setIcon(HolmesRoundedButton.resizeIcon(this.normal, this.getWidth() - offset, this.getHeight() - offset));
        }
        super.paintComponent(g);
    }

    private static Icon resizeIcon(ImageIcon icon, int resizedWidth, int resizedHeight) {
        Image img = icon.getImage();
        Image resizedImage = img.getScaledInstance(resizedWidth, resizedHeight, 4);
        return new ImageIcon(resizedImage);
    }

    @Override
    protected void paintBorder(Graphics g) {
        g.setColor(this.getForeground());
    }
}

