/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.dockwindows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.workspace.WorkspaceSheet;
import java.awt.event.ActionEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SharedActionsXTPN {
    private static final SharedActionsXTPN singleton = new SharedActionsXTPN();
    private GUIManager overlord = GUIManager.getDefaultGUIManager();

    private SharedActionsXTPN() {
    }

    public static SharedActionsXTPN access() {
        return singleton;
    }

    public void buttonAlphaSwitchMode(ActionEvent e, TransitionXTPN transition, JFrame caller, HolmesRoundedButton tauVisibilityButton, HolmesRoundedButton buttonClassicMode, JFormattedTextField alphaMaxTextField, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isAlphaModeActive()) {
            if (transition.isBetaModeActive() && transition.getBetaMinValue() < this.overlord.simSettings.getCalculationsAccuracy() && transition.getBetaMaxValue() < this.overlord.simSettings.getCalculationsAccuracy() && (transition.isInputTransition() || transition.isOutputTransition())) {
                JOptionPane.showMessageDialog(null, "Input or output XTPN transitions cannot be immediate. This transition\nis not in Beta-mode or Beta time values are zero. Change impossible.", "Immediate int/out XTPN transitions problem", 0);
                return;
            }
            transition.setAlphaModeStatus(false);
            button.setNewText("<html>Alpha: OFF</html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            if (!transition.isBetaModeActive()) {
                buttonClassicMode.setNewText("<html>Classical<html>");
                buttonClassicMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                tauVisibilityButton.setEnabled(false);
                transition.setTauTimersVisibility(false);
            }
        } else {
            transition.setAlphaModeStatus(true);
            button.setNewText("<html>Alpha: ON</html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            if (transition.getAlphaMinValue() < this.overlord.simSettings.getCalculationsAccuracy() && transition.getAlphaMaxValue() < this.overlord.simSettings.getCalculationsAccuracy()) {
                transition.setAlphaMaxValue(1.0, false);
                alphaMaxTextField.setValue(0.0);
            }
            if (!transition.isBetaModeActive()) {
                buttonClassicMode.setNewText("<html>XTPN<html>");
                buttonClassicMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                tauVisibilityButton.setEnabled(true);
                transition.setTauTimersVisibility(true);
            }
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
    }

    public void buttonBetaSwitchMode(ActionEvent e, TransitionXTPN transition, JFrame caller, HolmesRoundedButton tauVisibilityButton, HolmesRoundedButton buttonClassicMode, JFormattedTextField betaMaxTextField, ElementLocation elementLocation) {
        double accuracy;
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isBetaModeActive()) {
            accuracy = this.overlord.simSettings.getCalculationsAccuracy();
            if (transition.isAlphaModeActive() && transition.getAlphaMinValue() < accuracy && transition.getAlphaMaxValue() < accuracy && (transition.isInputTransition() || transition.isOutputTransition())) {
                JOptionPane.showMessageDialog(null, "Input or output XTPN transitions cannot be immediate. This transition\nis not in Alfa-mode and Beta time values are zero. Change impossible.", "Immediate int/out XTPN transitions problem", 0);
                return;
            }
            transition.setBetaModeStatus(false);
            button.setNewText("<html>Beta: OFF</html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            if (!transition.isAlphaModeActive()) {
                button.setNewText("<html>Classical<html>");
                buttonClassicMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                tauVisibilityButton.setEnabled(false);
                transition.setTauTimersVisibility(false);
            }
        } else {
            transition.setBetaModeStatus(true);
            button.setNewText("<html>Beta: ON</html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            accuracy = this.overlord.simSettings.getCalculationsAccuracy();
            if (transition.getBetaMinValue() < accuracy && transition.getBetaMaxValue() < accuracy) {
                transition.setBetaMaxValue(1.0, false);
                betaMaxTextField.setValue(0.0);
            }
            if (!transition.isAlphaModeActive()) {
                buttonClassicMode.setNewText("<html>XTPN<html>");
                buttonClassicMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                tauVisibilityButton.setEnabled(true);
                transition.setTauTimersVisibility(true);
            }
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
    }

    public void buttonTransitionToXTPN_classicSwitchMode(ActionEvent e, TransitionXTPN transition, JFrame caller, JFormattedTextField alphaMaxTextField, JFormattedTextField betaMaxTextField, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isAlphaModeActive() || transition.isBetaModeActive()) {
            Object[] options = new Object[]{"Confirm", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Reduce XTPN transition into classical one? This can reset\ncurrent time values assigned to Alfa/Beta ranges.", "XTPN transition reduction", 0, 3, null, options, options[1]);
            if (n == 1) {
                return;
            }
            transition.setAlphaModeStatus(false);
            transition.setBetaModeStatus(false);
            transition.setTauTimersVisibility(false);
            button.setNewText("<html>Classical<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        } else {
            transition.setAlphaModeStatus(true);
            transition.setBetaModeStatus(true);
            transition.setTauTimersVisibility(true);
            button.setNewText("<html>XTPN<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            double accuracy = this.overlord.simSettings.getCalculationsAccuracy();
            if (transition.getAlphaMinValue() < accuracy && transition.getAlphaMaxValue() < accuracy) {
                transition.setAlphaMaxValue(1.0, false);
                alphaMaxTextField.setValue(0.0);
            }
            if (transition.getBetaMinValue() < accuracy && transition.getBetaMaxValue() < accuracy) {
                transition.setBetaMaxValue(1.0, false);
                betaMaxTextField.setValue(0.0);
            }
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
    }

    public void buttonGammaSwitchMode(ActionEvent e, PlaceXTPN place, JFrame caller, HolmesRoundedButton gammaVisibilityButton, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        int tokensNum = place.getTokensNumber();
        if (place.isGammaModeActive()) {
            Object[] options = new String[]{"Reduce to classical place", "Stay as XTPN"};
            int answer = JOptionPane.showOptionDialog(null, "Turning \u03b3-mode off will clear all times of tokens (" + tokensNum + ") and \nas a result place will have classical PN features.\nTransform XTPN place into classical place?", "Transformation into classical place", -1, 3, null, options, options[0]);
            if (answer == 0) {
                button.setNewText("<html><center>Gamma<br>OFF</center></html>");
                button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                place.transformXTPNintoPNpace();
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                button.setFocusPainted(false);
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
                gammaVisibilityButton.setEnabled(false);
            }
        } else {
            Object[] options = new String[]{"Transform into XTPN", "Stay as classical PN place"};
            int answer = JOptionPane.showOptionDialog(null, "This will transform classical PN place into XTPN.\nAll tokens (" + tokensNum + ") will be assigned 0.0 time values.\nTransform into XTPN place?", "Conversion into XTPN place", -1, 3, null, options, options[0]);
            if (answer == 0) {
                button.setNewText("<html><center>Gamma<br>ON</center></html>");
                button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                place.transformIntoXTPNplace();
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                button.setFocusPainted(false);
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
                gammaVisibilityButton.setEnabled(true);
            }
        }
    }

    public boolean alphaVisButtonAction(ActionEvent e, TransitionXTPN transition, HolmesRoundedButton alphaLocChangeButton, boolean alphaLocChangeMode, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isAlphaRangeVisible()) {
            transition.setAlphaRangeVisibility(false);
            button.setNewText("<html>\u03b1:hidden<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            alphaLocChangeButton.setEnabled(false);
        } else {
            transition.setAlphaRangeVisibility(true);
            button.setNewText("<html>\u03b1:visible<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            alphaLocChangeMode = false;
            this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
        return alphaLocChangeMode;
    }

    public boolean betaVisButtonAction(ActionEvent e, TransitionXTPN transition, HolmesRoundedButton betaLocChangeButton, boolean betaLocChangeMode, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isBetaRangeVisible()) {
            transition.setBetaRangeVisibility(false);
            button.setNewText("<html>\u03b2:hidden<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            betaLocChangeButton.setEnabled(false);
        } else {
            transition.setBetaRangeVisibility(true);
            button.setNewText("<html>\u03b2:visible<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            betaLocChangeMode = false;
            this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
        return betaLocChangeMode;
    }

    public boolean tauVisButtonAction(ActionEvent e, TransitionXTPN transition, HolmesRoundedButton tauLocChangeButton, boolean tauLocChangeMode, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isTauTimerVisible()) {
            transition.setTauTimersVisibility(false);
            button.setNewText("<html>\u03c4:hidden<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            tauLocChangeButton.setEnabled(false);
        } else {
            transition.setTauTimersVisibility(true);
            button.setNewText("<html>\u03c4:visible<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            tauLocChangeMode = false;
            this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
        return tauLocChangeMode;
    }

    public boolean setAlfaMinTime(double newAlphaMin, TransitionXTPN transition, ElementLocation elementLocation) {
        double alfaMax = transition.getAlphaMaxValue();
        if (newAlphaMin > alfaMax) {
            Object[] options = new String[]{"\u25b2 Increase \u03b1-max to " + newAlphaMin, "\u25bc Decrease \u03b1-min to " + alfaMax, "\u274c Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "Proposed value \u03b1-min = " + newAlphaMin + " cannot be higher than current \u03b1-max = " + alfaMax + "\nIncrease old alphaMaximum (default action) or decrease new alphaMinimum?", "Alpha range problem: \u03b1-min too high", -1, 3, null, options, options[0]);
            switch (answer) {
                case 0: {
                    transition.setAlphaMaxValue(newAlphaMin, true);
                    transition.setAlphaMinValue(newAlphaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setAlphaMinValue(alfaMax, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setAlphaMinValue(newAlphaMin, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setAlfaMaxTime(double newAlphaMax, TransitionXTPN transition, ElementLocation elementLocation) {
        double accuracy;
        double alfaMin = transition.getAlphaMinValue();
        if (alfaMin < (accuracy = this.overlord.simSettings.getCalculationsAccuracy()) && newAlphaMax < accuracy && (transition.getBetaMinValue() < accuracy && transition.getBetaMaxValue() < accuracy || !transition.isBetaModeActive()) && (transition.isInputTransition() || transition.isOutputTransition())) {
            JOptionPane.showMessageDialog(null, "Input or output XTPN transitions cannot be immediate. Alternatively\nturn off both Alfa and Beta modes for a classical immediate transition.", "Immediate int/out XTPN transitions problem", 0);
            return false;
        }
        if (alfaMin < accuracy && newAlphaMax < accuracy) {
            transition.setAlphaMaxValue(0.0, false);
            transition.setAlphaModeStatus(false);
            this.repaintGraphPanel(elementLocation);
            return true;
        }
        if (newAlphaMax < alfaMin) {
            Object[] options = new String[]{"\u25b2 Increase \u03b1-max to " + alfaMin, "\u25bc Decrease \u03b1-min " + newAlphaMax, "\u274c Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "Proposed value \u03b1-max = " + newAlphaMax + " cannot be lower than current \u03b1-min = " + alfaMin + "\nIncrease new alphaMaximum or decrease old alphaMinimum (default action)?", "Alpha range problem: \u03b1-max too low", -1, 3, null, options, options[1]);
            switch (answer) {
                case 0: {
                    transition.setAlphaMaxValue(alfaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setAlphaMinValue(newAlphaMax, true);
                    transition.setAlphaMaxValue(newAlphaMax, false);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setAlphaMaxValue(newAlphaMax, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setBetaMinTime(double newBetaMin, TransitionXTPN transition, ElementLocation elementLocation) {
        double betaMax = transition.getBetaMaxValue();
        if (newBetaMin > betaMax) {
            Object[] options = new String[]{"\u25b2 Increase \u03b2-max to " + newBetaMin, "\u25bc Decrease \u03b2-min to " + betaMax, "\u274c Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "Proposed value \u03b2-min = " + newBetaMin + " cannot be higher than current \u03b2-max = " + betaMax + "\nIncrease old betaMaximum (default action) or decrease new betaMinimum?", "Beta range problem: \u03b2-min too high", -1, 3, null, options, options[0]);
            switch (answer) {
                case 0: {
                    transition.setBetaMaxValue(newBetaMin, true);
                    transition.setBetaMinValue(newBetaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setBetaMinValue(betaMax, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setBetaMinValue(newBetaMin, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setBetaMaxTime(double newBetaMax, TransitionXTPN transition, ElementLocation elementLocation) {
        double accuracy;
        double betaMin = transition.getBetaMinValue();
        if (betaMin < (accuracy = this.overlord.simSettings.getCalculationsAccuracy()) && newBetaMax < accuracy && (transition.getAlphaMinValue() < accuracy && transition.getAlphaMaxValue() < accuracy || !transition.isAlphaModeActive())) {
            boolean input = transition.isInputTransition();
            boolean output = transition.isOutputTransition();
            if (input || output) {
                JOptionPane.showMessageDialog(null, "Input or output XTPN transitions cannot be immediate. Alternatively\nturn off both Alfa and Beta modes for a classical immediate transition.", "Immediate int/out XTPN transitions problem", 0);
                return false;
            }
        }
        if (betaMin < accuracy && newBetaMax < accuracy) {
            transition.setBetaMaxValue(0.0, false);
            transition.setBetaModeStatus(false);
            this.repaintGraphPanel(elementLocation);
            return true;
        }
        if (newBetaMax < betaMin) {
            Object[] options = new String[]{"\u25b2 Increase \u03b2-max to " + betaMin, "\u25bc Decrease \u03b2-min to " + newBetaMax, "\u274c Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "Proposed value \u03b2-max = " + newBetaMax + " cannot be lower than current \u03b2-min = " + betaMin + "\nIncrease new betaMax or decrease old betaMin (default action)?", "Beta range problem: \u03b2-max too low", -1, 3, null, options, options[1]);
            switch (answer) {
                case 0: {
                    transition.setBetaMaxValue(betaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setBetaMinValue(newBetaMax, true);
                    transition.setBetaMaxValue(newBetaMax, false);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setBetaMaxValue(newBetaMax, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setGammaMinTime(double newGammaMin, PlaceXTPN place, ElementLocation elementLocation) {
        double gammaMax = place.getGammaMaxValue();
        if (newGammaMin > gammaMax) {
            Object[] options = new String[]{"\u25b2 Increase \u03b3-max to " + newGammaMin, "\u25bc Decrease \u03b3-min to " + gammaMax, "\u274c Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "Proposed value \u03b3-min = " + newGammaMin + " cannot be higher than current \u03b3-max = " + gammaMax + "\nIncrease current gammaMaximum (default action) or decrease proposed gammaMinimum?", "Gamma range problem: \u03b3-min too high", -1, 3, null, options, options[0]);
            switch (answer) {
                case 0: {
                    place.setGammaMaxValue(newGammaMin, true);
                    place.setGammaMinValue(newGammaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    place.setGammaMinValue(gammaMax, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        place.setGammaMinValue(newGammaMin, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setGammaMaxTime(double newGammaMax, PlaceXTPN place, ElementLocation elementLocation) {
        double gammaMin = place.getGammaMinValue();
        if (newGammaMax < gammaMin) {
            Object[] options = new String[]{"\u25b2 Increase \u03b3-max to " + gammaMin, "\u25bc Decrease \u03b3-min to " + newGammaMax, "\u274c Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "Proposed value \u03b3-max = " + newGammaMax + " cannot be lower than current \u03b3-min = " + gammaMin + "\nIncrease proposed gammaMaximum or decrease current gammaMinimum (default action)?", "Gamma range problem: \u03b3-max too low", -1, 3, null, options, options[1]);
            switch (answer) {
                case 0: {
                    place.setGammaMaxValue(gammaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    place.setGammaMinValue(newGammaMax, true);
                    place.setGammaMaxValue(newGammaMax, false);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        place.setGammaMaxValue(newGammaMax, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    private void repaintGraphPanel(ElementLocation elementLocation) {
        int sheetIndex = this.overlord.IDtoIndex(elementLocation.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        graphPanel.repaint();
    }
}

