/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.dockwindows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsTools;
import holmes.analyse.MCTCalculator;
import holmes.analyse.ProblemDetector;
import holmes.analyse.SubnetCalculator;
import holmes.analyse.TimeComputations;
import holmes.clusters.ClusterDataPackage;
import holmes.clusters.ClusterTransition;
import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.darkgui.dockwindows.SharedActionsXTPN;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.graphpanel.EditorResources;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SPNtransitionData;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionColored;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.QuickSimTools;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import holmes.utilities.ColorPalette;
import holmes.utilities.Tools;
import holmes.windows.HolmesFunctionsBuilder;
import holmes.windows.HolmesInvariantsViewer;
import holmes.windows.HolmesNotepad;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.ssim.HolmesSimSetup;
import holmes.windows.xtpn.HolmesXTPNtokens;
import holmes.workspace.WorkspaceSheet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;

public class HolmesDockWindowsTable
extends JPanel {
    private static final long serialVersionUID = 4510802239873443705L;
    private final GUIManager overlord;
    private ArrayList<JComponent> components;
    private int mode;
    public int simulatorType = 0;
    private ArrayList<Transition> transitions;
    private ArrayList<Place> places;
    private ArrayList<ArrayList<Transition>> mctGroups;
    private ArrayList<ArrayList<Integer>> knockoutData;
    private JPanel panel;
    private boolean stopAction = false;
    public boolean doNotUpdate = false;
    public ButtonGroup group = new ButtonGroup();
    public JComboBox<String> simMode;
    private JCheckBox maximumModeCheckBox;
    private JCheckBox singleModeCheckBox;
    public JLabel timeStepLabelValue;
    public JLabel timeLabelXTPN;
    public JLabel stepLabelXTPN;
    private GraphicalSimulator simulator;
    private GraphicalSimulatorXTPN simulatorXTPN;
    private final ButtonGroup groupRadioMetaType = new ButtonGroup();
    private boolean nameLocChangeMode = false;
    private PetriNetElement element;
    private ElementLocation elementLocation;
    public SpinnerModel nameLocationXSpinnerModel = null;
    public SpinnerModel nameLocationYSpinnerModel = null;
    private Arc pairedArc = null;
    private JCheckBox timeTransitionCheckBox;
    private JCheckBox classicalTransitionCheckBox;
    private JCheckBox stochasticTransitionCheckBox;
    private int selectedMCTindex = -1;
    private boolean colorMCT = false;
    private boolean allMCTselected = false;
    private JTextArea MCTnameField;
    private JTextArea knockoutTextArea;
    private JComboBox<String> chooseInvBox;
    private JComboBox<String> chooseSurInvBox;
    private JComboBox<String> chooseSubInvBox;
    private JComboBox<String> chooseNoneInvBox;
    private ArrayList<ArrayList<Integer>> t_invariantsMatrix;
    private int selectedT_invIndex = -1;
    private boolean markMCT = false;
    private boolean glowT_inv = true;
    private JTextArea t_invNameField;
    private ArrayList<ArrayList<Integer>> p_invariantsMatrix;
    private int selectedP_invIndex = -1;
    private JTextArea p_invNameField;
    private boolean invStructure = true;
    private JLabel minTimeLabel;
    private JLabel avgTimeLabel;
    private JLabel maxTimeLabel;
    private JLabel structureLabel;
    private JComboBox<String> chooseCluster;
    private JComboBox<String> chooseClusterInv;
    private ClusterDataPackage clusterColorsData;
    private int selectedClusterIndex = -1;
    private int selectedClusterInvIndex = -1;
    private boolean clustersMCT = false;
    private JProgressBar progressBar = null;
    private JLabel mssValueLabel;
    private JComboBox<String> mcsObjRCombo;
    private JComboBox<String> mcsMCSforObjRCombo;
    private WorkspaceSheet currentSheet;
    public JLabel fixInvariants;
    public JLabel fixInvariants2;
    public JLabel fixIOPlaces;
    public JLabel fixIOTransitions;
    public JLabel fixlinearTrans;
    private ProblemDetector detector;
    private QuickSimTools quickSim;
    private boolean scanTransitions = true;
    private boolean scanPlaces = true;
    private boolean markArcs = true;
    private boolean repetitions = true;
    private JProgressBar quickProgressBar;
    private int choosenDeco = 0;
    private JTextArea elementsOfDecomposedStructure;
    private int selectedSubNetindex = -1;
    private boolean allSubNetsselected = false;
    private JButton c1Button;
    private JButton c2Button;
    private JLabel projectTypeLabelText;
    private HolmesRoundedButton alfaVisibilityButton;
    private HolmesRoundedButton betaVisibilityButton;
    private HolmesRoundedButton tauVisibilityButton;
    private HolmesRoundedButton alphaLocChangeButton;
    private HolmesRoundedButton betaLocChangeButton;
    private HolmesRoundedButton tauLocChangeButton;
    private HolmesRoundedButton buttonClassicMode;
    private HolmesRoundedButton buttonGammaMode;
    private HolmesRoundedButton gammaVisibilityButton;
    private HolmesRoundedButton gammaLocChangeButton;
    private boolean alphaLocChangeMode = false;
    private boolean betaLocChangeMode = false;
    private boolean gammaLocChangeMode = false;
    private boolean tauLocChangeMode = false;
    private JFormattedTextField alphaMinTextField;
    private JFormattedTextField alphaMaxTextField;
    private JFormattedTextField betaMinTextField;
    private JFormattedTextField betaMaxTextField;
    private boolean alphaValuesVisible = true;
    private boolean betaValuesVisible = true;
    private boolean gammaValuesVisible = true;
    private boolean tauValuesVisible = true;
    JCheckBox qSimXTPNStatsStepsCheckbox;
    JCheckBox qSimXTPNStatsTimeCheckbox;
    boolean qSimXTPNSbySteps = true;
    boolean qSimXTPNrepeateSim = false;
    double qSimXTPNStatsTime = 500.0;
    int qSimXTPNsimStatsSteps = 10000;
    int qSimXTPNStatsRepetitions = 10;
    boolean qSimXTPNknockoutMode = false;
    private JProgressBar qSimXTPNProgressBar = null;
    private HolmesRoundedButton acqDataButtonXTPN = null;
    private static final int PLACE = 0;
    private static final int TRANSITION = 1;
    private static final int ARC = 2;
    private static final int SHEET = 3;
    private static final int SIMULATOR = 4;
    private static final int tINVARIANTS = 5;
    private static final int MCT = 6;
    private static final int TIMETRANSITION = 7;
    private static final int pINVARIANTS = 8;
    private static final int CLUSTERS = 9;
    private static final int KNOCKOUT = 10;
    private static final int META = 11;
    private static final int CTRANSITION = 12;
    private static final int DECOMPOSITION = 13;
    private static final int XTPN_TRANS = 14;
    private static final int XTPN_PLACE = 15;
    private static final int XARC = 16;
    private static final int SPN = 99;

    public JPanel getPanel() {
        return this.panel;
    }

    public void setPanel(JPanel panel) {
        this.panel = panel;
    }

    public HolmesDockWindowsTable(SubWindow subType, Object ... blackBox) {
        this.overlord = GUIManager.getDefaultGUIManager();
        switch (subType) {
            case SIMULATOR: {
                this.createSimulatorSubWindow((GraphicalSimulator)blackBox[0], (GraphicalSimulatorXTPN)blackBox[1], (Boolean)blackBox[2]);
                break;
            }
            case PLACE: {
                this.createPlaceSubWindow((Place)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case TRANSITION: {
                this.createTransitionSubWindow((Transition)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case TIMETRANSITION: {
                this.createTimeTransitionSubWindow((Transition)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case SPNTRANSITION: {
                this.createSPNTransitionSubWindow((Transition)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case XTPNTRANSITION: {
                this.createXTPNTransitionSubWindow((TransitionXTPN)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case XTPNPLACE: {
                this.createXTPNPlaceSubWindow((PlaceXTPN)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case CTRANSITION: {
                this.createColorTransitionSubWindow((Transition)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case META: {
                this.createMetaNodeSubWindow((MetaNode)blackBox[0], (ElementLocation)blackBox[1]);
                break;
            }
            case ARC: 
            case XARC: {
                this.createArcSubWindow((Arc)blackBox[0]);
                break;
            }
            case SHEET: {
                this.createSheetSubWindow((WorkspaceSheet)blackBox[0]);
                break;
            }
            case T_INVARIANTS: {
                this.createT_invSubWindow((ArrayList)blackBox[0]);
                break;
            }
            case P_INVARIANTS: {
                this.createP_invSubWindow((ArrayList)blackBox[0]);
                break;
            }
            case MCT: {
                this.createMCTSubWindow((ArrayList)blackBox[0]);
                break;
            }
            case CLUSTERS: {
                this.createClustersSubWindow((ClusterDataPackage)blackBox[0]);
                break;
            }
            case MCS: {
                this.createMCSSubWindow((MCSDataMatrix)blackBox[0]);
                break;
            }
            case FIXER: {
                this.createFixerSubWindow();
                break;
            }
            case QUICKSIM: {
                this.createQuickSimSubWindow();
                break;
            }
            case KNOCKOUT: {
                this.createKnockoutData((ArrayList)blackBox[0]);
                break;
            }
            case DECOMPOSITION: {
                this.createDecompositionData();
            }
        }
    }

    private void createSimulatorSubWindow(GraphicalSimulator sim, GraphicalSimulatorXTPN simXTPN, boolean XTPNmode) {
        String[] simModeName;
        JLabel netTypeLabel;
        int columnA_posX = 10;
        int columnB_posX = 80;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 70;
        this.initiateContainers();
        this.mode = 4;
        this.setSimulator(sim, simXTPN);
        this.simulatorType = XTPNmode ? 1 : 0;
        if (XTPNmode) {
            netTypeLabel = new JLabel("Mode:");
            netTypeLabel.setBounds(columnA_posX - 5, columnA_Y += 10, colACompLength, 20);
            this.components.add(netTypeLabel);
            simModeName = new String[]{"XTPN simulator", "Other simulators"};
            this.simMode = new JComboBox<String>(simModeName);
            this.simMode.setLocation(columnB_posX - 40, columnB_Y += 10);
            this.simMode.setSize(colBCompLength + 50, 20);
            this.simMode.setSelectedIndex(0);
            this.simMode.addActionListener(actionEvent -> {
                if (this.doNotUpdate) {
                    return;
                }
                if (this.simulatorXTPN.getsimulatorStatusXTPN() != GraphicalSimulatorXTPN.SimulatorModeXTPN.STOPPED) {
                    JOptionPane.showMessageDialog(null, "XTPN simulator must be stopped first.", "Simulator working", 2);
                    return;
                }
                int selectedModeIndex = this.simMode.getSelectedIndex();
                if (selectedModeIndex == 1) {
                    this.overlord.getSimulatorBox().createSimulatorProperties(false);
                    return;
                }
                this.doNotUpdate = false;
            });
            this.components.add(this.simMode);
        } else {
            netTypeLabel = new JLabel("Mode:");
            netTypeLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
            this.components.add(netTypeLabel);
            simModeName = new String[]{"Petri Net", "Timed Petri Net", "Hybrid mode", "Color", "XTPN"};
            this.simMode = new JComboBox<String>(simModeName);
            this.simMode.setLocation(columnB_posX - 25, columnB_Y += 10);
            this.simMode.setSize(colBCompLength + 30, 20);
            this.simMode.setSelectedIndex(0);
            this.simMode.addActionListener(actionEvent -> {
                if (this.doNotUpdate) {
                    return;
                }
                if (this.simulator.getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                    JOptionPane.showMessageDialog(null, "Net simulator must be stopped first.", "Simulator working", 2);
                    return;
                }
                int selectedModeIndex = this.simMode.getSelectedIndex();
                if (selectedModeIndex == 4) {
                    this.overlord.getSimulatorBox().createSimulatorProperties(true);
                    return;
                }
                int change = this.simulator.setGraphicalSimulatorNetType(selectedModeIndex);
                this.doNotUpdate = true;
                this.c1Button.setEnabled(false);
                this.c2Button.setEnabled(false);
                if (change == 0) {
                    this.simMode.setSelectedIndex(0);
                } else if (change == 1) {
                    this.simMode.setSelectedIndex(1);
                } else if (change == 2) {
                    this.simMode.setSelectedIndex(2);
                } else if (change == 3) {
                    this.simMode.setSelectedIndex(3);
                    this.c1Button.setEnabled(true);
                    this.c2Button.setEnabled(true);
                } else {
                    this.overlord.log("Error while changing graphical simulator mode.", "error", true);
                }
                this.doNotUpdate = false;
            });
            this.components.add(this.simMode);
        }
        if (!XTPNmode) {
            this.stepLabelXTPN = new JLabel("0");
            this.timeLabelXTPN = new JLabel("0.0");
            JLabel timeStepLabel = new JLabel("Time/step:");
            timeStepLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
            this.components.add(timeStepLabel);
            this.timeStepLabelValue = new JLabel("0");
            this.timeStepLabelValue.setBounds(columnA_posX + 70, columnB_Y += 20, colACompLength, 20);
            this.components.add(this.timeStepLabelValue);
            JLabel controlsLabel = new JLabel("Simulation options:");
            controlsLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength * 2, 20);
            this.components.add(controlsLabel);
            columnB_Y += 20;
            JButton loopSimulation = new JButton(Tools.getResIcon22("/icons/simulation/simPN_start.png"));
            loopSimulation.setName("simB5");
            loopSimulation.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 30);
            loopSimulation.setToolTipText("Loop simulation");
            loopSimulation.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulator.startSimulation(GraphicalSimulator.SimulatorMode.LOOP);
                this.mode = 4;
            });
            this.components.add(loopSimulation);
            JButton singleTransitionLoopSimulation = new JButton(Tools.getResIcon22("/icons/simulation/simPN_startSingle.png"));
            singleTransitionLoopSimulation.setName("simB6");
            singleTransitionLoopSimulation.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 30);
            singleTransitionLoopSimulation.setToolTipText("Loop single transition simulation");
            singleTransitionLoopSimulation.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulator.startSimulation(GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION_LOOP);
                this.mode = 4;
            });
            this.components.add(singleTransitionLoopSimulation);
            JButton pauseSimulation = new JButton(Tools.getResIcon22("/icons/simulation/simPN_pause.png"));
            pauseSimulation.setName("pause");
            pauseSimulation.setBounds(columnA_posX, columnA_Y += 30, colACompLength, 30);
            pauseSimulation.setToolTipText("Pause simulation");
            pauseSimulation.setEnabled(false);
            pauseSimulation.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulator.pause();
                this.mode = 4;
            });
            this.components.add(pauseSimulation);
            JButton stopSimulation = new JButton(Tools.getResIcon22("/icons/simulation/simPN_stop.png"));
            stopSimulation.setName("stop");
            stopSimulation.setBounds(columnB_posX, columnB_Y += 30, colBCompLength, 30);
            stopSimulation.setToolTipText("Schedule a stop for the simulation");
            stopSimulation.setEnabled(false);
            stopSimulation.addActionListener(actionEvent -> {
                this.simulator.stop();
                this.mode = 4;
            });
            this.components.add(stopSimulation);
            JButton resetButton = new JButton(Tools.getResIcon22("/icons/simulation/control_sim_reset.png"));
            resetButton.setName("reset");
            resetButton.setBounds(columnA_posX, columnB_Y += 30, colACompLength, 30);
            resetButton.setToolTipText("Reset all tokens in places.");
            resetButton.setEnabled(false);
            resetButton.addActionListener(actionEvent -> this.overlord.getWorkspace().getProject().restoreMarkingZero());
            this.components.add(resetButton);
            JButton saveButton = new JButton(Tools.getResIcon22("/icons/simulation/control_sim_save_m0.png"));
            saveButton.setName("Save m0");
            saveButton.setBounds(columnB_posX, columnA_Y += 30, colBCompLength, 30);
            saveButton.setToolTipText("Save m0 state.");
            saveButton.addActionListener(actionEvent -> {
                if (this.overlord.reset.isSimulatorActiveWarning("Operation impossible while simulator is working.", "Warning")) {
                    return;
                }
                if (this.overlord.reset.isXTPNSimulatorActiveWarning("Operation impossible while XTPN simulator is working.", "Warning")) {
                    return;
                }
                Object[] options = new Object[]{"Save new m0 state", "Cancel"};
                int n = JOptionPane.showOptionDialog(null, "Add new net state to states table?", "Saving m0 state", 0, 3, null, options, options[0]);
                if (n == 0) {
                    this.overlord.getWorkspace().getProject().accessStatesManager().addCurrentStatePN();
                }
            });
            this.components.add(saveButton);
            JLabel otherControlsLabel = new JLabel("Other modes:");
            otherControlsLabel.setBounds(columnA_posX, columnA_Y += 30, colACompLength * 2, 20);
            this.components.add(otherControlsLabel);
            columnB_Y += 20;
            JButton oneActionBack = new JButton(Tools.getResIcon22("/icons/simulation/control_sim_back.png"));
            oneActionBack.setName("simB1");
            oneActionBack.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 30);
            oneActionBack.setToolTipText("One action back");
            oneActionBack.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulator.startSimulation(GraphicalSimulator.SimulatorMode.ACTION_BACK);
                this.mode = 4;
            });
            this.components.add(oneActionBack);
            JButton oneTransitionForward = new JButton(Tools.getResIcon22("/icons/simulation/simPN_1transForw.png"));
            oneTransitionForward.setName("simB2");
            oneTransitionForward.setBounds(columnB_posX, columnB_Y += 30, colBCompLength, 30);
            oneTransitionForward.setToolTipText("One transition forward");
            oneTransitionForward.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulator.startSimulation(GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION);
                this.mode = 4;
            });
            this.components.add(oneTransitionForward);
            JButton loopBack = new JButton(Tools.getResIcon22("/icons/simulation/control_sim_backLoop.png"));
            loopBack.setName("simB3");
            loopBack.setBounds(columnA_posX, columnA_Y += 30, colACompLength, 30);
            loopBack.setToolTipText("Loop back to oldest saved action");
            loopBack.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulator.startSimulation(GraphicalSimulator.SimulatorMode.LOOP_BACK);
                this.mode = 4;
            });
            this.components.add(loopBack);
            JButton oneStepForward = new JButton(Tools.getResIcon22("/icons/simulation/simPN_1stepForw.png"));
            oneStepForward.setName("simB4");
            oneStepForward.setBounds(columnB_posX, columnB_Y += 30, colBCompLength, 30);
            oneStepForward.setToolTipText("One step forward");
            oneStepForward.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulator.startSimulation(GraphicalSimulator.SimulatorMode.STEP);
                this.mode = 4;
            });
            this.components.add(oneStepForward);
            this.c1Button = new JButton("<html><center>Store<br>colors</center></html>");
            this.c1Button.setName("resetColor");
            this.c1Button.setBounds(columnA_posX, columnB_Y += 30, colACompLength, 30);
            this.c1Button.setToolTipText("Reset all color tokens in places.");
            this.c1Button.setEnabled(false);
            this.c1Button.addActionListener(actionEvent -> this.overlord.getWorkspace().getProject().storeColors());
            this.components.add(this.c1Button);
            this.c2Button = new JButton("<html><center>Restore<br>colors</center></html>");
            this.c2Button.setName("SaveM0Color");
            this.c2Button.setBounds(columnB_posX, columnA_Y += 30, colBCompLength, 30);
            this.c2Button.setToolTipText("Reset all color tokens in places.");
            this.c2Button.setEnabled(false);
            this.c2Button.addActionListener(actionEvent -> this.overlord.getWorkspace().getProject().restoreColors());
            this.components.add(this.c2Button);
            JButton statesButton = new JButton("State manager");
            statesButton.setName("State manager");
            statesButton.setBounds(columnA_posX, columnB_Y += 35, colACompLength * 2, 30);
            statesButton.setToolTipText("Open states manager window.");
            statesButton.setEnabled(true);
            statesButton.addActionListener(actionEvent -> {
                if (this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                    JOptionPane.showMessageDialog(null, "Net simulator must be stopped in order to access state manager.", "Simulator working", 2);
                } else {
                    new HolmesStatesManager();
                }
            });
            this.components.add(statesButton);
            columnB_Y += 35;
            columnA_Y += 35;
            this.maximumModeCheckBox = new JCheckBox("Maximum mode");
            this.maximumModeCheckBox.setBounds(columnA_posX, columnA_Y += 30, 200, 20);
            this.maximumModeCheckBox.addActionListener(actionEvent -> {
                if (this.doNotUpdate) {
                    return;
                }
                if (this.singleModeCheckBox.isSelected()) {
                    JOptionPane.showMessageDialog(null, "Mode overrided by an active single mode.", "Cannot change now", 2);
                    this.doNotUpdate = true;
                    this.maximumModeCheckBox.setSelected(this.overlord.getSettingsManager().getValue("simSingleMode").equals("1"));
                    this.doNotUpdate = false;
                }
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                this.simulator.setMaxMode(abstractButton.getModel().isSelected());
            });
            this.components.add(this.maximumModeCheckBox);
            this.singleModeCheckBox = new JCheckBox("Single mode");
            this.singleModeCheckBox.setBounds(columnA_posX, columnA_Y += 20, 200, 20);
            this.singleModeCheckBox.addActionListener(actionEvent -> {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                if (abstractButton.getModel().isSelected()) {
                    this.simulator.setSingleMode(true);
                    this.doNotUpdate = true;
                    this.maximumModeCheckBox.setSelected(this.overlord.getSettingsManager().getValue("simSingleMode").equals("1"));
                    this.doNotUpdate = false;
                } else {
                    this.simulator.setSingleMode(false);
                    this.doNotUpdate = true;
                    this.maximumModeCheckBox.setSelected(false);
                    this.simulator.setMaxMode(false);
                    this.doNotUpdate = false;
                }
            });
            this.components.add(this.singleModeCheckBox);
        } else {
            int internalX = 5;
            int internalY = 10;
            this.timeStepLabelValue = new JLabel("0");
            JLabel stepLabelText = new JLabel("Step:");
            stepLabelText.setBounds(internalX, internalY += 20, 90, 20);
            this.components.add(stepLabelText);
            this.stepLabelXTPN = new JLabel("0");
            this.stepLabelXTPN.setBounds(internalX + 60, internalY, 90, 20);
            this.components.add(this.stepLabelXTPN);
            JLabel timeLabelText = new JLabel("Time:");
            timeLabelText.setBounds(internalX, internalY += 20, 90, 20);
            this.components.add(timeLabelText);
            this.timeLabelXTPN = new JLabel("0.0");
            this.timeLabelXTPN.setBounds(internalX + 60, internalY, 90, 20);
            this.components.add(this.timeLabelXTPN);
            JLabel optionsLavel = new JLabel("Simulation buttons:");
            optionsLavel.setBounds(internalX, internalY += 20, 120, 20);
            this.components.add(optionsLavel);
            HolmesRoundedButton loopSimulation = new HolmesRoundedButton("", "simulator/simStart1.png", "simulator/simStart2.png", "simulator/simStart3.png");
            loopSimulation.setName("XTPNstart");
            loopSimulation.setBounds(internalX, internalY += 20, 40, 35);
            loopSimulation.setToolTipText("Loop simulation");
            loopSimulation.addActionListener(actionEvent -> {
                if (this.overlord.getWorkspace().getProject().isSimulationActive()) {
                    JOptionPane.showMessageDialog(null, "Holmes simulator is running. Please wait or stop it manually first.", "Simulator active", 2);
                } else {
                    this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                    this.simulatorXTPN.startSimulation(GraphicalSimulatorXTPN.SimulatorModeXTPN.XTPNLOOP);
                    this.mode = 4;
                }
            });
            this.components.add(loopSimulation);
            HolmesRoundedButton pauseSimulation = new HolmesRoundedButton("", "simulator/simPause1.png", "simulator/simPause2.png", "simulator/simPause3.png");
            pauseSimulation.setName("XTPNpause");
            pauseSimulation.setBounds(internalX + 40, internalY, 40, 35);
            pauseSimulation.setToolTipText("Pause simulation");
            pauseSimulation.setEnabled(false);
            pauseSimulation.addActionListener(actionEvent -> {
                this.overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                this.simulatorXTPN.pause();
                this.mode = 4;
            });
            this.components.add(pauseSimulation);
            HolmesRoundedButton stopSimulation = new HolmesRoundedButton("", "simulator/simStop1.png", "simulator/simStop2.png", "simulator/simStop2.png");
            stopSimulation.setName("XTPNstop");
            stopSimulation.setBounds(internalX + 80, internalY, 40, 35);
            stopSimulation.setToolTipText("Schedule a stop for the simulation");
            stopSimulation.setEnabled(false);
            stopSimulation.addActionListener(actionEvent -> {
                this.simulatorXTPN.stop();
                this.mode = 4;
            });
            this.components.add(stopSimulation);
            HolmesRoundedButton resetButton = new HolmesRoundedButton("<html><center>Reset<br>p-state</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            resetButton.setName("resetM0button");
            resetButton.setBounds(internalX, internalY += 40, 75, 40);
            resetButton.setToolTipText("Reset all tokens in places.");
            resetButton.setEnabled(true);
            resetButton.addActionListener(actionEvent -> this.overlord.getWorkspace().getProject().restoreMarkingZero());
            this.components.add(resetButton);
            HolmesRoundedButton storeButton = new HolmesRoundedButton("<html><center>Store<br>p-state</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            storeButton.setName("storeM0button");
            storeButton.setBounds(internalX + 75, internalY, 75, 40);
            storeButton.setToolTipText("Reset all tokens in places.");
            storeButton.setEnabled(true);
            storeButton.addActionListener(actionEvent -> {
                int selected = 0;
                Object[] options = new Object[]{"Replace XTPN state", "Cancel"};
                int n = JOptionPane.showOptionDialog(null, "Replace first p-state vector with the current net state?", "Replace XTPN state", 0, 3, null, options, options[1]);
                if (n == 1) {
                    return;
                }
                this.overlord.getWorkspace().getProject().accessStatesManager().replaceStoredMultiset_M_withCurrentNetState(selected);
                this.overlord.markNetChange();
            });
            this.components.add(storeButton);
            JLabel transDelayLabel = new JLabel("Firing delay:");
            transDelayLabel.setBounds(internalX, internalY += 50, 150, 20);
            this.components.add(transDelayLabel);
            JSlider arcDelaySlider = new JSlider(0, 5, 85, 25);
            arcDelaySlider.setBounds(internalX, internalY += 20, 150, 50);
            arcDelaySlider.setMinorTickSpacing(5);
            arcDelaySlider.setMajorTickSpacing(20);
            arcDelaySlider.setPaintTicks(true);
            arcDelaySlider.setPaintLabels(true);
            arcDelaySlider.setLabelTable(arcDelaySlider.createStandardLabels(20));
            arcDelaySlider.addChangeListener(e -> {
                int reference;
                JSlider s = (JSlider)e.getSource();
                int val = s.getValue();
                if (val <= (reference = GUIManager.getDefaultGUIManager().simSettings.getTransitionGraphicDelay())) {
                    arcDelaySlider.setValue(val);
                    GUIManager.getDefaultGUIManager().simSettings.setArcGraphicDelay(val);
                } else {
                    s.setValue(reference);
                }
            });
            this.components.add(arcDelaySlider);
            JLabel arcDelayLabel = new JLabel("Tokens delay:");
            arcDelayLabel.setBounds(internalX, internalY += 50, 120, 20);
            this.components.add(arcDelayLabel);
            final JSlider transDelaySlider = new JSlider(0, 5, 85, 25);
            transDelaySlider.setBounds(internalX, internalY += 20, 150, 50);
            transDelaySlider.setMinorTickSpacing(5);
            transDelaySlider.setMajorTickSpacing(20);
            transDelaySlider.setPaintTicks(true);
            transDelaySlider.setPaintLabels(true);
            transDelaySlider.setLabelTable(transDelaySlider.createStandardLabels(20));
            transDelaySlider.addChangeListener(new ChangeListener(){
                private JSlider anotherSlider = null;

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider s = (JSlider)e.getSource();
                    int value = s.getValue();
                    transDelaySlider.setValue(value);
                    GUIManager.getDefaultGUIManager().simSettings.setTransitionGraphicDelay(value);
                    if (value < GUIManager.getDefaultGUIManager().simSettings.getArcGraphicDelay()) {
                        this.anotherSlider.setValue(value);
                    }
                }

                private ChangeListener yesWeCan(JSlider slider) {
                    this.anotherSlider = slider;
                    return this;
                }
            }.yesWeCan(arcDelaySlider));
            this.components.add(transDelaySlider);
            JLabel timeValuesVisLabel = new JLabel("Time values visibility:");
            timeValuesVisLabel.setBounds(internalX, internalY += 50, 140, 20);
            this.components.add(timeValuesVisLabel);
            HolmesRoundedButton showAlfaSwitchButton = new HolmesRoundedButton("<html><center>\u03b1:ON</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            showAlfaSwitchButton.setName("switchAlphas");
            showAlfaSwitchButton.setBounds(internalX, internalY += 20, 80, 30);
            showAlfaSwitchButton.setToolTipText("Switch alpha visibility.");
            showAlfaSwitchButton.setEnabled(true);
            showAlfaSwitchButton.addActionListener(actionEvent -> {
                HolmesRoundedButton button = (HolmesRoundedButton)actionEvent.getSource();
                if (this.alphaValuesVisible) {
                    this.alphaValuesVisible = false;
                    button.setNewText("<html><center>\u03b1:OFF</center></html>");
                } else {
                    this.alphaValuesVisible = true;
                    button.setNewText("<html><center>\u03b1:ON</center></html>");
                }
                for (Transition trans : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) {
                    ((TransitionXTPN)trans).setAlphaRangeVisibility(this.alphaValuesVisible);
                }
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            });
            this.components.add(showAlfaSwitchButton);
            HolmesRoundedButton showBetaSwitchButton = new HolmesRoundedButton("<html><center>\u03b2:ON</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            showBetaSwitchButton.setName("switchBetas");
            showBetaSwitchButton.setBounds(internalX + 80, internalY, 80, 30);
            showBetaSwitchButton.setToolTipText("Switch beta visibility.");
            showBetaSwitchButton.setEnabled(true);
            showBetaSwitchButton.addActionListener(actionEvent -> {
                HolmesRoundedButton button = (HolmesRoundedButton)actionEvent.getSource();
                if (this.betaValuesVisible) {
                    this.betaValuesVisible = false;
                    button.setNewText("<html><center>\u03b2:OFF</center></html>");
                } else {
                    this.betaValuesVisible = true;
                    button.setNewText("<html><center>\u03b2:ON</center></html>");
                }
                for (Transition trans : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) {
                    ((TransitionXTPN)trans).setBetaRangeVisibility(this.betaValuesVisible);
                }
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            });
            this.components.add(showBetaSwitchButton);
            HolmesRoundedButton showGammaSwitchButton = new HolmesRoundedButton("<html><center>\u03b3:ON</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            showGammaSwitchButton.setName("switchGammas");
            showGammaSwitchButton.setBounds(internalX, internalY += 30, 80, 30);
            showGammaSwitchButton.setToolTipText("Switch gamma visibility.");
            showGammaSwitchButton.setEnabled(true);
            showGammaSwitchButton.addActionListener(actionEvent -> {
                HolmesRoundedButton button = (HolmesRoundedButton)actionEvent.getSource();
                if (this.gammaValuesVisible) {
                    this.gammaValuesVisible = false;
                    button.setNewText("<html><center>\u03b3:OFF</center></html>");
                } else {
                    this.gammaValuesVisible = true;
                    button.setNewText("<html><center>\u03b3:ON</center></html>");
                }
                for (Place place : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces()) {
                    ((PlaceXTPN)place).setGammaRangeVisibility(this.gammaValuesVisible);
                }
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            });
            this.components.add(showGammaSwitchButton);
            HolmesRoundedButton showTauSwitchButton = new HolmesRoundedButton("<html><center>\u03c4:ON</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            showTauSwitchButton.setName("switchTaus");
            showTauSwitchButton.setBounds(internalX + 80, internalY, 80, 30);
            showTauSwitchButton.setToolTipText("Switch tau visibility.");
            showTauSwitchButton.setEnabled(true);
            showTauSwitchButton.addActionListener(actionEvent -> {
                HolmesRoundedButton button = (HolmesRoundedButton)actionEvent.getSource();
                if (this.tauValuesVisible) {
                    this.tauValuesVisible = false;
                    button.setNewText("<html><center>\u03c4:OFF</center></html>");
                } else {
                    this.tauValuesVisible = true;
                    button.setNewText("<html><center>\u03c4:ON</center></html>");
                }
                for (Transition trans : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) {
                    ((TransitionXTPN)trans).setTauTimersVisibility(this.tauValuesVisible);
                }
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            });
            this.components.add(showTauSwitchButton);
            this.quickSim = new QuickSimTools(this);
            JLabel qSimLabel = new JLabel("Fast simulation options:");
            qSimLabel.setBounds(internalX, internalY += 40, 140, 20);
            this.components.add(qSimLabel);
            this.acqDataButtonXTPN = new HolmesRoundedButton("<html>Simulate</html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            this.acqDataButtonXTPN.setBounds(internalX, internalY += 20, 100, 30);
            this.acqDataButtonXTPN.setMargin(new Insets(0, 0, 0, 0));
            this.acqDataButtonXTPN.setFocusPainted(false);
            this.acqDataButtonXTPN.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
            this.acqDataButtonXTPN.setToolTipText("Compute steps from zero marking through the number of states");
            this.acqDataButtonXTPN.addActionListener(actionEvent -> {
                if (this.overlord.getWorkspace().getProject().isSimulationActive()) {
                    JOptionPane.showMessageDialog(null, "Holmes simulator is running. Please wait or stop it manually first.", "Simulator active", 2);
                } else {
                    this.quickSim.acquireDataXTPN(this.qSimXTPNSbySteps, this.qSimXTPNsimStatsSteps, this.qSimXTPNStatsTime, this.qSimXTPNrepeateSim, this.qSimXTPNStatsRepetitions, this.qSimXTPNknockoutMode, this.qSimXTPNProgressBar, this.acqDataButtonXTPN);
                }
            });
            this.components.add(this.acqDataButtonXTPN);
            this.qSimXTPNProgressBar = new JProgressBar();
            this.qSimXTPNProgressBar.setBounds(internalX, internalY += 35, 160, 20);
            this.qSimXTPNProgressBar.setMaximum(100);
            this.qSimXTPNProgressBar.setMinimum(0);
            this.qSimXTPNProgressBar.setValue(0);
            this.qSimXTPNProgressBar.setStringPainted(true);
            this.components.add(this.qSimXTPNProgressBar);
            this.qSimXTPNStatsStepsCheckbox = new JCheckBox("Steps");
            this.qSimXTPNStatsStepsCheckbox.setBounds(internalX, internalY += 25, 70, 20);
            this.qSimXTPNStatsStepsCheckbox.setSelected(this.qSimXTPNSbySteps);
            this.qSimXTPNStatsStepsCheckbox.addItemListener(e -> {
                if (this.doNotUpdate) {
                    return;
                }
                JCheckBox box = (JCheckBox)e.getSource();
                this.qSimXTPNSbySteps = box.isSelected();
                this.doNotUpdate = true;
                this.qSimXTPNStatsTimeCheckbox.setSelected(!this.qSimXTPNSbySteps);
                this.doNotUpdate = false;
            });
            this.components.add(this.qSimXTPNStatsStepsCheckbox);
            SpinnerNumberModel qSimStepsSpinnerModel = new SpinnerNumberModel(this.qSimXTPNsimStatsSteps, 0, 100000000, 1000);
            JSpinner qsimStepsSpinner = new JSpinner(qSimStepsSpinnerModel);
            qsimStepsSpinner.setBounds(internalX + 70, internalY, 90, 20);
            qsimStepsSpinner.addChangeListener(e -> {
                int tmp;
                JSpinner spinner = (JSpinner)e.getSource();
                this.qSimXTPNsimStatsSteps = tmp = ((Integer)spinner.getValue()).intValue();
            });
            this.components.add(qsimStepsSpinner);
            this.qSimXTPNStatsTimeCheckbox = new JCheckBox("Time");
            this.qSimXTPNStatsTimeCheckbox.setBounds(internalX, internalY += 22, 70, 20);
            this.qSimXTPNStatsTimeCheckbox.setSelected(!this.qSimXTPNSbySteps);
            this.qSimXTPNStatsTimeCheckbox.addItemListener(e -> {
                if (this.doNotUpdate) {
                    return;
                }
                JCheckBox box = (JCheckBox)e.getSource();
                this.qSimXTPNSbySteps = !box.isSelected();
                this.doNotUpdate = true;
                this.qSimXTPNStatsStepsCheckbox.setSelected(this.qSimXTPNSbySteps);
                this.doNotUpdate = false;
            });
            this.components.add(this.qSimXTPNStatsTimeCheckbox);
            SpinnerNumberModel qsimTimeLengthSpinnerModel = new SpinnerNumberModel(this.qSimXTPNStatsTime, 0.0, 1000000.0, 100.0);
            JSpinner qsimTimeSpinner = new JSpinner(qsimTimeLengthSpinnerModel);
            qsimTimeSpinner.setBounds(internalX + 70, internalY, 90, 20);
            qsimTimeSpinner.addChangeListener(e -> {
                JSpinner spinner = (JSpinner)e.getSource();
                this.qSimXTPNStatsTime = (Double)spinner.getValue();
            });
            this.components.add(qsimTimeSpinner);
            JCheckBox qSimXTPNrepetitionsCheckBox = new JCheckBox("Rep.:");
            qSimXTPNrepetitionsCheckBox.setBounds(internalX, internalY += 22, 70, 20);
            qSimXTPNrepetitionsCheckBox.setSelected(!this.qSimXTPNSbySteps);
            qSimXTPNrepetitionsCheckBox.addItemListener(e -> {
                JCheckBox box = (JCheckBox)e.getSource();
                this.qSimXTPNrepeateSim = box.isSelected();
            });
            this.components.add(qSimXTPNrepetitionsCheckBox);
            SpinnerNumberModel qsimRepetitionsSpinnerModel = new SpinnerNumberModel(this.qSimXTPNStatsRepetitions, 10, 100, 10);
            JSpinner qsimRepetitionsSpinner = new JSpinner(qsimRepetitionsSpinnerModel);
            qsimRepetitionsSpinner.setBounds(internalX + 70, internalY, 90, 20);
            qsimRepetitionsSpinner.addChangeListener(e -> {
                JSpinner spinner = (JSpinner)e.getSource();
                this.qSimXTPNStatsRepetitions = (Integer)spinner.getValue();
            });
            this.components.add(qsimRepetitionsSpinner);
            JCheckBox qSimXTPNknockoutCheckBox = new JCheckBox("Knockout simulation");
            qSimXTPNknockoutCheckBox.setBounds(internalX, internalY += 22, 150, 20);
            qSimXTPNknockoutCheckBox.setSelected(this.qSimXTPNknockoutMode);
            qSimXTPNknockoutCheckBox.addItemListener(e -> {
                JCheckBox box = (JCheckBox)e.getSource();
                this.qSimXTPNknockoutMode = box.isSelected();
            });
            this.components.add(qSimXTPNknockoutCheckBox);
            HolmesRoundedButton sSimAlpha = new HolmesRoundedButton("<html><center>XTPN net<br>simulator</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
            sSimAlpha.setBounds(internalX, internalY += 30, 100, 35);
            sSimAlpha.setMargin(new Insets(0, 0, 0, 0));
            sSimAlpha.setFocusPainted(false);
            sSimAlpha.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
            sSimAlpha.setToolTipText("Compute steps from zero marking through the number of states");
            sSimAlpha.addActionListener(actionEvent -> {
                if (this.overlord.getWorkspace().getProject().isSimulationActive()) {
                    JOptionPane.showMessageDialog(null, "Holmes simulator is running. Please wait or stop it manually first.", "Simulator active", 2);
                } else {
                    this.overlord.showStateSimulatorWindowXTPN();
                }
            });
            this.components.add(sSimAlpha);
        }
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void createPlaceSubWindow(Place place, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.elementLocation = location;
        this.initiateContainers();
        this.mode = 0;
        this.element = place;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("ID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        int gID = this.overlord.getWorkspace().getProject().getPlaces().indexOf(place);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 10, 50, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("gID:");
        idLabel3.setBounds(columnB_posX + 35, columnA_Y, 50, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + place.getID());
        idLabel4.setBounds(columnB_posX + 60, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        JFormattedTextField nameField = new JFormattedTextField();
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setText(place.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(place.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        if (!place.isColored) {
            JLabel tokenLabel = new JLabel("Tokens:", 2);
            tokenLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
            this.components.add(tokenLabel);
            int tok = place.getTokensNumber();
            boolean problem = false;
            if (tok < 0) {
                this.overlord.log("Negative number of tokens in " + place.getName(), "error", true);
                tok = 0;
                problem = true;
            }
            SpinnerNumberModel tokenSpinnerModel = new SpinnerNumberModel(tok, 0, Integer.MAX_VALUE, 1);
            JSpinner tokenSpinner = new JSpinner(tokenSpinnerModel);
            tokenSpinner.setBounds(columnB_posX, columnB_Y += 20, 95, 20);
            tokenSpinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setTokens(tokenz);
                this.overlord.markNetChange();
            });
            if (problem) {
                tokenSpinner.setEnabled(false);
            }
            this.components.add(tokenSpinner);
        }
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnB_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnB_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel portalLabel = new JLabel("Portal:", 2);
        portalLabel.setBounds(columnB_posX + 110, columnB_Y, colACompLength, 20);
        this.components.add(portalLabel);
        JCheckBox portalBox = new JCheckBox("", place.isPortal());
        portalBox.setBounds(columnB_posX + 180, columnB_Y, colACompLength, 20);
        portalBox.setSelected(((Place)this.element).isPortal());
        portalBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                this.makePortal();
            } else if (((Place)this.element).getElementLocations().size() > 1) {
                JOptionPane.showMessageDialog(null, "Place contains more than one location!", "Cannot proceed", 1);
            } else {
                this.unPortal();
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(portalBox);
        JLabel locLabel = new JLabel("Location:", 2);
        locLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(locLabel);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        JPanel locationSpinnerPanel = new JPanel();
        locationSpinnerPanel.setLayout(new BoxLayout(locationSpinnerPanel, 0));
        locationSpinnerPanel.add(locationXSpinner);
        locationSpinnerPanel.add(new JLabel(" , "));
        locationSpinnerPanel.add(locationYSpinner);
        locationSpinnerPanel.setBounds(columnA_posX + 90, columnB_Y += 20, colBCompLength, 20);
        this.components.add(locationSpinnerPanel);
        columnB_Y += 20;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = place.getElementLocations().indexOf(location);
        int xNameOffset = place.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = place.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("xOff: ", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnA_Y, 40, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 125, columnA_Y, 60, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private Place place_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.place_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Place inPlace, ElementLocation inLoc) {
                this.place_tmp = inPlace;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(place, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("yOff: ", 2);
        locNameLabelY.setBounds(columnA_posX + 195, columnB_Y, 40, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 230, columnA_Y, 60, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private Place place_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.place_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Place inPlace, ElementLocation inLoc) {
                this.place_tmp = inPlace;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(place, location));
        this.components.add(nameLocationYSpinner);
        JButton nameLocChangeButton = new JButton(Tools.getResIcon22("/icons/changeNameLocation.png"));
        nameLocChangeButton.setName("LocNameChanger");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnA_posX + 90, columnA_Y += 25, 150, 40);
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setFocusPainted(false);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private Place place_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton button_tmp = (JButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocationON.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.place_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocation.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Place inPlace, ElementLocation inLoc) {
                this.place_tmp = inPlace;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(place, location));
        this.components.add(nameLocChangeButton);
        if (place.isColored) {
            JLabel tokenLabel = new JLabel("T0 Red:", 2);
            tokenLabel.setBounds(columnA_posX, columnA_Y += 50, colACompLength, 20);
            this.components.add(tokenLabel);
            int tok0 = place.getTokensNumber();
            boolean problem = false;
            if (tok0 < 0) {
                this.overlord.log("Negative number of tokens in " + place.getName(), "error", true);
                tok0 = 0;
                problem = true;
            }
            SpinnerNumberModel tokenSpinnerModel = new SpinnerNumberModel(tok0, 0, Integer.MAX_VALUE, 1);
            JSpinner tokenSpinner = new JSpinner(tokenSpinnerModel);
            tokenSpinner.setBounds(columnB_posX - 30, columnB_Y += 75, 75, 20);
            tokenSpinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setTokens(tokenz);
                this.overlord.markNetChange();
            });
            if (problem) {
                tokenSpinner.setEnabled(false);
            }
            this.components.add(tokenSpinner);
            JLabel token3Label = new JLabel("T3 Yellow:", 2);
            token3Label.setBounds(columnB_posX + 60, columnB_Y, colACompLength, 20);
            this.components.add(token3Label);
            int tok3 = ((PlaceColored)place).getColorTokensNumber(3);
            SpinnerNumberModel token3SpinnerModel = new SpinnerNumberModel(tok3, 0, Integer.MAX_VALUE, 1);
            JSpinner token3Spinner = new JSpinner(token3SpinnerModel);
            token3Spinner.setBounds(columnB_posX + 130, columnB_Y, 75, 20);
            token3Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorTokens(tokenz, 3);
                this.overlord.markNetChange();
            });
            this.components.add(token3Spinner);
            JLabel token1Label = new JLabel("T1 Green:", 2);
            token1Label.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
            this.components.add(token1Label);
            int tok1 = ((PlaceColored)place).getColorTokensNumber(1);
            SpinnerNumberModel token1SpinnerModel = new SpinnerNumberModel(tok1, 0, Integer.MAX_VALUE, 1);
            JSpinner token1Spinner = new JSpinner(token1SpinnerModel);
            token1Spinner.setBounds(columnB_posX - 30, columnB_Y += 20, 75, 20);
            token1Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorTokens(tokenz, 1);
                this.overlord.markNetChange();
            });
            this.components.add(token1Spinner);
            JLabel token4Label = new JLabel("T4 Grey:", 2);
            token4Label.setBounds(columnB_posX + 60, columnB_Y, colACompLength, 20);
            this.components.add(token4Label);
            int tok4 = ((PlaceColored)place).getColorTokensNumber(4);
            SpinnerNumberModel token4SpinnerModel = new SpinnerNumberModel(tok4, 0, Integer.MAX_VALUE, 1);
            JSpinner token4Spinner = new JSpinner(token4SpinnerModel);
            token4Spinner.setBounds(columnB_posX + 130, columnB_Y, 75, 20);
            token4Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorTokens(tokenz, 4);
                this.overlord.markNetChange();
            });
            this.components.add(token4Spinner);
            JLabel token2Label = new JLabel("T2 Blue:", 2);
            token2Label.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
            this.components.add(token2Label);
            int tok2 = ((PlaceColored)place).getColorTokensNumber(2);
            SpinnerNumberModel token2SpinnerModel = new SpinnerNumberModel(tok2, 0, Integer.MAX_VALUE, 1);
            JSpinner token2Spinner = new JSpinner(token2SpinnerModel);
            token2Spinner.setBounds(columnB_posX - 30, columnB_Y += 20, 75, 20);
            token2Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorTokens(tokenz, 2);
                this.overlord.markNetChange();
            });
            this.components.add(token2Spinner);
            JLabel token5Label = new JLabel("T5 Black:", 2);
            token5Label.setBounds(columnB_posX + 60, columnB_Y, colACompLength, 20);
            this.components.add(token5Label);
            int tok5 = ((PlaceColored)place).getColorTokensNumber(5);
            SpinnerNumberModel token5SpinnerModel = new SpinnerNumberModel(tok5, 0, Integer.MAX_VALUE, 1);
            JSpinner token5Spinner = new JSpinner(token5SpinnerModel);
            token5Spinner.setBounds(columnB_posX + 130, columnB_Y, 75, 20);
            token5Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorTokens(tokenz, 5);
                this.overlord.markNetChange();
            });
            this.components.add(token5Spinner);
        }
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createXTPNPlaceSubWindow(PlaceXTPN place, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.elementLocation = location;
        this.initiateContainers();
        this.mode = 15;
        this.element = place;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("ID XTPN:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        int gID = this.overlord.getWorkspace().getProject().getPlaces().indexOf(place);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 10, 50, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("global ID:");
        idLabel3.setBounds(columnB_posX + 55, columnA_Y, 60, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + place.getID());
        idLabel4.setBounds(columnB_posX + 120, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        JFormattedTextField nameField = new JFormattedTextField();
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setText(place.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(place.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        JLabel gammaLabel = new JLabel("XTPN mode:", 2);
        gammaLabel.setBounds(columnA_posX, columnA_Y += 25, colACompLength + 15, 20);
        this.components.add(gammaLabel);
        this.buttonGammaMode = new HolmesRoundedButton("<html><center>Gamma<br>ON</center></html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.buttonGammaMode.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGammaMode.setName("gammaModeButton");
        this.buttonGammaMode.setBounds(columnB_posX, columnB_Y += 25, 65, 35);
        this.buttonGammaMode.setFocusPainted(false);
        if (place.isGammaModeActive()) {
            this.buttonGammaMode.setNewText("<html><center>Gamma<br>ON</center></html>");
            this.buttonGammaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        } else {
            this.buttonGammaMode.setNewText("<html><center>Gamma<br>OFF</center></html>");
            this.buttonGammaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        }
        this.buttonGammaMode.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            SharedActionsXTPN.access().buttonGammaSwitchMode(e, place, null, this.gammaVisibilityButton, this.elementLocation);
        });
        this.components.add(this.buttonGammaMode);
        this.gammaVisibilityButton = new HolmesRoundedButton("<html><center>Gamma<br>visible</center></html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.gammaVisibilityButton.setName("gammaVisButton");
        this.gammaVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.gammaVisibilityButton.setBounds(columnB_posX + 65, columnB_Y, 65, 35);
        this.gammaVisibilityButton.setFocusPainted(false);
        if (place.isGammaModeActive()) {
            if (place.isGammaRangeVisible()) {
                this.gammaVisibilityButton.setNewText("<html><center>Gamma<br>visible</center><html>");
                this.gammaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.gammaVisibilityButton.setNewText("<html><center>Gamma<br>hidden</center><html>");
                this.gammaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            this.gammaVisibilityButton.setEnabled(false);
        }
        this.gammaVisibilityButton.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
            if (place.isGammaRangeVisible()) {
                ((PlaceXTPN)this.element).setGammaRangeVisibility(false);
                button.setNewText("<html><center>Gamma<br>hidden</center><html>");
                button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                ((PlaceXTPN)this.element).setGammaRangeVisibility(true);
                button.setNewText("<html><center>Gamma<br>visible</center><html>");
                button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            }
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(this.gammaVisibilityButton);
        this.gammaLocChangeButton = new HolmesRoundedButton("<html><center>Gamma<br>offset</center></html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.gammaLocChangeButton.setName("gammaOffsetButton");
        this.gammaLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        this.gammaLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        this.gammaLocChangeButton.setBounds(columnB_posX + 130, columnB_Y, 65, 35);
        this.gammaLocChangeButton.setFocusPainted(false);
        if (place.isGammaModeActive() && place.isGammaRangeVisible()) {
            if (this.gammaLocChangeMode) {
                this.gammaLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                this.gammaLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                this.gammaLocChangeButton.setNewText("<html><center>Gamma<br>offset</center><html>");
                this.gammaLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            }
        } else {
            this.gammaLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
            this.gammaLocChangeMode = false;
            this.gammaLocChangeButton.setEnabled(false);
        }
        this.gammaLocChangeButton.addActionListener(new ActionListener(){
            private Place place_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HolmesDockWindowsTable.this.gammaLocChangeMode) {
                    HolmesDockWindowsTable.this.gammaLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                    HolmesDockWindowsTable.this.gammaLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                    HolmesDockWindowsTable.this.gammaLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.place_tmp, this.el_tmp, GUIManager.locationMoveType.GAMMA);
                } else {
                    HolmesDockWindowsTable.this.gammaLocChangeButton.setNewText("<html><center>Gamma<br>offset</center><html>");
                    HolmesDockWindowsTable.this.gammaLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                    HolmesDockWindowsTable.this.gammaLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Place place, ElementLocation inLoc) {
                this.place_tmp = place;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(place, location));
        this.components.add(this.gammaLocChangeButton);
        JLabel minMaxLabel = new JLabel("\u03b3 (min/max): ", 2);
        minMaxLabel.setBounds(columnA_posX, columnA_Y += 40, colACompLength + 20, 20);
        this.components.add(minMaxLabel);
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(place.getFractionForPlaceXTPN());
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        Double example = 3.14;
        JFormattedTextField gammaMinTextField = new JFormattedTextField(formatter);
        gammaMinTextField.setValue(example);
        gammaMinTextField.setValue(place.getGammaMinValue());
        gammaMinTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double min = Double.parseDouble("" + field.getValue());
            if (!SharedActionsXTPN.access().setGammaMinTime(min, (PlaceXTPN)this.element, this.elementLocation)) {
                this.doNotUpdate = true;
                field.setValue(place.getGammaMinValue());
                this.doNotUpdate = false;
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        JFormattedTextField gammaMaxTextField = new JFormattedTextField(formatter);
        gammaMaxTextField.setValue(example);
        gammaMaxTextField.setValue(place.getGammaMaxValue());
        gammaMaxTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double max = Double.parseDouble("" + field.getValue());
            if (!SharedActionsXTPN.access().setGammaMaxTime(max, (PlaceXTPN)this.element, this.elementLocation)) {
                this.doNotUpdate = true;
                field.setValue(place.getGammaMaxValue());
                this.doNotUpdate = false;
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        if (!place.isGammaModeActive()) {
            gammaMinTextField.setEnabled(false);
            gammaMaxTextField.setEnabled(false);
        }
        gammaMinTextField.setBounds(columnB_posX, columnB_Y += 41, 90, 20);
        this.components.add(gammaMinTextField);
        JLabel slash1 = new JLabel(" / ", 2);
        slash1.setBounds(columnB_posX + 95, columnA_Y, 15, 20);
        this.components.add(slash1);
        gammaMaxTextField.setBounds(columnB_posX + 110, columnB_Y, 90, 20);
        this.components.add(gammaMaxTextField);
        JLabel tokensXTPNLabel2 = new JLabel("Tokens in place: " + place.getTokensNumber(), 2);
        tokensXTPNLabel2.setBounds(columnA_posX, columnA_Y += 20, 140, 20);
        this.components.add(tokensXTPNLabel2);
        JLabel fractionLabel = new JLabel("Fraction:", 2);
        fractionLabel.setBounds(columnA_posX, columnA_Y += 22, 70, 20);
        this.components.add(fractionLabel);
        int fract = place.getFractionForPlaceXTPN();
        SpinnerNumberModel fractionSpinnerModel = new SpinnerNumberModel(fract, 0, 6, 1);
        JSpinner fractionSpinner = new JSpinner(fractionSpinnerModel);
        fractionSpinner.setBounds(columnB_posX, columnB_Y += 42, 40, 20);
        fractionSpinner.addChangeListener(e -> {
            int fraction = (Integer)((JSpinner)e.getSource()).getValue();
            place.setFractionForPlaceXTPN(fraction);
        });
        this.components.add(fractionSpinner);
        HolmesRoundedButton nameLocChangeButton = new HolmesRoundedButton("<html><center>Name<br>offset</center><html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        nameLocChangeButton.setName("placeLocOffsetButton");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnB_posX + 131, columnB_Y - 12, 65, 35);
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setFocusPainted(false);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private Place place_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HolmesRoundedButton button = (HolmesRoundedButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button.setNewText("<html><center>Change<br>location</center><html>");
                    button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.place_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button.setNewText("<html><center>Name<br>offset</center><html>");
                    button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Place inPlace, ElementLocation inLoc) {
                this.place_tmp = inPlace;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(place, location));
        this.components.add(nameLocChangeButton);
        HolmesRoundedButton tokensWindowButton = new HolmesRoundedButton("<html>Tokens<br>window</html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        tokensWindowButton.setMargin(new Insets(0, 0, 0, 0));
        tokensWindowButton.setBounds(columnA_posX, columnA_Y += 30, 90, 40);
        if (!place.isGammaModeActive()) {
            tokensWindowButton.setEnabled(false);
        }
        tokensWindowButton.addActionListener(actionEvent -> new HolmesXTPNtokens((PlaceXTPN)this.element, null, place.accessMultiset(), place.isGammaModeActive()));
        this.components.add(tokensWindowButton);
        HolmesRoundedButton add0tokenButton = new HolmesRoundedButton("<html><center>Add<br>0-token</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        add0tokenButton.setMargin(new Insets(0, 0, 0, 0));
        add0tokenButton.setBounds(columnB_posX, columnA_Y, 90, 40);
        if (place.isGammaModeActive()) {
            add0tokenButton.setText("<html>Add<br>0-token</html>");
            add0tokenButton.setBackground(Color.GREEN);
        } else {
            add0tokenButton.setText("<html>Add<br>token</html>");
            add0tokenButton.setBackground(null);
        }
        add0tokenButton.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JButton button = (JButton)e.getSource();
            place.addTokens_XTPN(1, 0.0);
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(add0tokenButton);
        HolmesRoundedButton remove0tokenButton = new HolmesRoundedButton("<html><center>Remove<br>0-token</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        remove0tokenButton.setMargin(new Insets(0, 0, 0, 0));
        remove0tokenButton.setBounds(columnB_posX + 90, columnA_Y, 90, 40);
        if (place.isGammaModeActive()) {
            remove0tokenButton.setText("<html>Remove<br>0-token</html>");
        } else {
            remove0tokenButton.setText("<html>Remove<br>token</html>");
        }
        remove0tokenButton.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JButton button = (JButton)e.getSource();
            if (place.isGammaModeActive()) {
                double lastToken;
                int size = place.accessMultiset().size();
                if (size > 0 && (lastToken = place.accessMultiset().get(size - 1).doubleValue()) == 0.0) {
                    place.accessMultiset().remove(size - 1);
                    place.modifyTokensNumber(-1);
                }
            } else {
                int tokens = place.getTokensNumber();
                if (tokens > 0) {
                    place.modifyTokensNumber(-1);
                }
            }
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(remove0tokenButton);
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 40, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnA_Y, colBCompLength, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnA_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnA_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel portalLabel = new JLabel("Portal:", 2);
        portalLabel.setBounds(columnB_posX + 110, columnA_Y, colACompLength, 20);
        this.components.add(portalLabel);
        JCheckBox portalBox = new JCheckBox("", place.isPortal());
        portalBox.setBounds(columnB_posX + 180, columnA_Y, colACompLength, 20);
        portalBox.setSelected(((Place)this.element).isPortal());
        portalBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                this.makePortal();
            } else if (((Place)this.element).getElementLocations().size() > 1) {
                JOptionPane.showMessageDialog(null, "Place contains more than one location!", "Cannot proceed", 1);
            } else {
                this.unPortal();
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(portalBox);
        JLabel locLabel = new JLabel("Location:", 2);
        locLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(locLabel);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.setBounds(columnB_posX, columnA_Y, 60, 20);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JLabel labelCom = new JLabel(" , ");
        labelCom.setBounds(columnB_posX + 60, columnA_Y, 10, 20);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.setBounds(columnB_posX + 70, columnA_Y, 60, 20);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        this.components.add(locationXSpinner);
        this.components.add(labelCom);
        this.components.add(locationYSpinner);
        columnB_Y += 25;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = place.getElementLocations().indexOf(location);
        int xNameOffset = place.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = place.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("x: ", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnA_Y, 20, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 105, columnA_Y, 45, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private Place place_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.place_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Place inPlace, ElementLocation inLoc) {
                this.place_tmp = inPlace;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(place, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("y: ", 2);
        locNameLabelY.setBounds(columnA_posX + 160, columnA_Y, 15, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 175, columnA_Y, 45, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private Place place_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.place_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Place inPlace, ElementLocation inLoc) {
                this.place_tmp = inPlace;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(place, location));
        this.components.add(nameLocationYSpinner);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createTransitionSubWindow(Transition transition, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.mode = 1;
        this.elementLocation = location;
        this.initiateContainers();
        this.element = transition;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("ID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        int gID = this.overlord.getWorkspace().getProject().getTransitions().lastIndexOf(transition);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 10, colACompLength, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("gID:");
        idLabel3.setBounds(columnB_posX + 35, columnA_Y, 50, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + transition.getID());
        idLabel4.setBounds(columnB_posX + 60, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setValue(transition.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(transition.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        JLabel changeTypeLabel = new JLabel("Trans. Type:", 2);
        changeTypeLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(changeTypeLabel);
        this.classicalTransitionCheckBox = new JCheckBox("PN");
        this.classicalTransitionCheckBox.setBounds(columnB_posX, columnB_Y += 20, 60, 20);
        this.classicalTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.PN);
        this.classicalTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.PN);
                this.doNotUpdate = true;
                this.timeTransitionCheckBox.setSelected(false);
                this.stochasticTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.classicalTransitionCheckBox);
        this.timeTransitionCheckBox = new JCheckBox("TPN");
        this.timeTransitionCheckBox.setBounds(columnB_posX + 70, columnB_Y, 60, 20);
        this.timeTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.TPN);
        this.timeTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.TPN);
                this.doNotUpdate = true;
                this.classicalTransitionCheckBox.setSelected(false);
                this.stochasticTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.timeTransitionCheckBox);
        this.stochasticTransitionCheckBox = new JCheckBox("SPN");
        this.stochasticTransitionCheckBox.setBounds(columnB_posX + 130, columnB_Y, 60, 20);
        this.stochasticTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.SPN);
        this.stochasticTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.SPN);
                this.doNotUpdate = true;
                this.classicalTransitionCheckBox.setSelected(false);
                this.timeTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.stochasticTransitionCheckBox);
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnB_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnB_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel locLabel = new JLabel("Location:", 2);
        locLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(locLabel);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        JPanel locationSpinnerPanel = new JPanel();
        locationSpinnerPanel.setLayout(new BoxLayout(locationSpinnerPanel, 0));
        locationSpinnerPanel.add(locationXSpinner);
        locationSpinnerPanel.add(new JLabel(" , "));
        locationSpinnerPanel.add(locationYSpinner);
        locationSpinnerPanel.setBounds(columnA_posX + 90, columnB_Y += 20, colBCompLength, 20);
        this.components.add(locationSpinnerPanel);
        JLabel portalLabel = new JLabel("Portal:", 2);
        portalLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(portalLabel);
        JCheckBox portalBox = new JCheckBox("", transition.isPortal());
        portalBox.setBounds(columnB_posX, columnB_Y += 20, 30, 20);
        portalBox.setSelected(((Transition)this.element).isPortal());
        portalBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                this.makePortal();
            } else if (((Transition)this.element).getElementLocations().size() > 1) {
                JOptionPane.showMessageDialog(null, "Transition contains more than one location!", "Cannot proceed", 1);
            } else {
                this.unPortal();
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(portalBox);
        JLabel functionLabel = new JLabel("Functional:", 2);
        functionLabel.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
        this.components.add(functionLabel);
        JCheckBox functionalCheckBox = new JCheckBox("", transition.fpnExtension.isFunctional());
        functionalCheckBox.setBounds(columnB_posX, columnB_Y += 20, 30, 20);
        functionalCheckBox.setSelected(((Transition)this.element).fpnExtension.isFunctional());
        functionalCheckBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            ((Transition)this.element).fpnExtension.setFunctional(box.isSelected());
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(functionalCheckBox);
        JButton functionsEditorButton = new JButton(Tools.getResIcon32("/icons/functionsWindow/functionsIcon.png"));
        functionsEditorButton.setName("Functions editor");
        functionsEditorButton.setText("<html>Functions<br>&nbsp;&nbsp;&nbsp;editor&nbsp;</html>");
        functionsEditorButton.setMargin(new Insets(0, 0, 0, 0));
        functionsEditorButton.setBounds(columnA_posX + 125, columnA_Y - 16, 110, 32);
        functionsEditorButton.addActionListener(actionEvent -> new HolmesFunctionsBuilder((Transition)this.element));
        this.components.add(functionsEditorButton);
        columnB_Y += 20;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = transition.getElementLocations().indexOf(location);
        int xNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("xOff: ", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnA_Y, 40, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 125, columnA_Y, 60, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("yOff: ", 2);
        locNameLabelY.setBounds(columnA_posX + 195, columnB_Y, 40, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 230, columnA_Y, 60, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationYSpinner);
        JButton nameLocChangeButton = new JButton(Tools.getResIcon22("/icons/changeNameLocation.png"));
        nameLocChangeButton.setName("LocNameChanger");
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnA_posX + 90, columnA_Y += 25, 150, 40);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton button_tmp = (JButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocationON.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocation.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocChangeButton);
        JLabel debugModeLabel1 = new JLabel("Debug1:", 2);
        debugModeLabel1.setBounds(columnA_posX, columnA_Y += 45, colACompLength, 20);
        this.components.add(debugModeLabel1);
        JTextArea debugChangeID = new JTextArea("");
        debugChangeID.setBounds(columnB_posX, columnB_Y += 70, 60, 20);
        debugChangeID.setLineWrap(true);
        debugChangeID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newFR = "";
                if (field != null) {
                    newFR = field.getText();
                }
                try {
                    int id = Integer.parseInt(newFR);
                    ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
                    if (id >= 0 && id < transitions.size()) {
                        Transition t1 = (Transition)HolmesDockWindowsTable.this.element;
                        Transition t2 = transitions.get(id);
                        if (transitions.indexOf(t1) == id) {
                            return;
                        }
                        int pos1 = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().indexOf(t1);
                        int pos2 = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().indexOf(t2);
                        Collections.swap(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes(), pos1, pos2);
                        GUIManager.getDefaultGUIManager().log("Swapping transitions " + t1.getName() + " and " + t2.getName() + " successfull.", "text", true);
                        WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(HolmesDockWindowsTable.this.elementLocation);
                    }
                }
                catch (Exception ee) {
                    System.out.println(ee.getMessage());
                }
            }
        });
        this.components.add(debugChangeID);
        JButton aaa = new JButton();
        aaa.setName("ChangeID");
        aaa.setText("Change ID");
        aaa.setMargin(new Insets(0, 0, 0, 0));
        aaa.setBounds(columnB_posX + 70, columnB_Y, 80, 20);
        aaa.addActionListener(actionEvent -> {});
        this.components.add(aaa);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createColorTransitionSubWindow(Transition transition, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.mode = 12;
        this.elementLocation = location;
        this.initiateContainers();
        this.element = transition;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel colorLabel = new JLabel("Colored transition data:", 2);
        colorLabel.setBounds(columnA_posX, columnA_Y += 10, 220, 20);
        this.components.add(colorLabel);
        columnB_Y += 10;
        JLabel idLabel = new JLabel("ID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(idLabel);
        int gID = this.overlord.getWorkspace().getProject().getTransitions().lastIndexOf(transition);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 20, colACompLength, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("gID:");
        idLabel3.setBounds(columnB_posX + 35, columnA_Y, 50, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + transition.getID());
        idLabel4.setBounds(columnB_posX + 60, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setValue(transition.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(transition.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnB_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnB_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel portalLabel = new JLabel("Portal:", 2);
        portalLabel.setBounds(columnB_posX + 120, columnB_Y, colACompLength, 20);
        this.components.add(portalLabel);
        JCheckBox portalBox = new JCheckBox("", transition.isPortal());
        portalBox.setBounds(columnB_posX + 180, columnB_Y, 30, 20);
        portalBox.setSelected(((Transition)this.element).isPortal());
        portalBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                this.makePortal();
            } else if (((Transition)this.element).getElementLocations().size() > 1) {
                JOptionPane.showMessageDialog(null, "Transition contains more than one location!", "Cannot proceed", 1);
            } else {
                this.unPortal();
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(portalBox);
        JLabel locLabel = new JLabel("Location:", 2);
        locLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(locLabel);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        JPanel locationSpinnerPanel = new JPanel();
        locationSpinnerPanel.setLayout(new BoxLayout(locationSpinnerPanel, 0));
        locationSpinnerPanel.add(locationXSpinner);
        locationSpinnerPanel.add(new JLabel(" , "));
        locationSpinnerPanel.add(locationYSpinner);
        locationSpinnerPanel.setBounds(columnA_posX + 90, columnB_Y += 20, colBCompLength, 20);
        this.components.add(locationSpinnerPanel);
        columnB_Y += 20;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = transition.getElementLocations().indexOf(location);
        int xNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("xOff: ", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnA_Y, 40, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 125, columnA_Y, 60, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("yOff: ", 2);
        locNameLabelY.setBounds(columnA_posX + 195, columnB_Y, 40, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 230, columnA_Y, 60, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationYSpinner);
        JButton nameLocChangeButton = new JButton(Tools.getResIcon22("/icons/changeNameLocation.png"));
        nameLocChangeButton.setName("LocNameChanger");
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnA_posX + 90, columnA_Y += 25, 150, 40);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton button_tmp = (JButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocationON.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocation.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocChangeButton);
        JLabel reqLabel = new JLabel("Required tokens threshold:", 2);
        reqLabel.setBounds(columnA_posX, columnA_Y += 50, 220, 20);
        columnB_Y += 76;
        this.components.add(reqLabel);
        JLabel reqT0Label = new JLabel("T0 red:", 2);
        reqT0Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
        this.components.add(reqT0Label);
        SpinnerNumberModel weightT0SpinnerModel = new SpinnerNumberModel(((TransitionColored)transition).getRequiredColoredTokens(0), 0, Integer.MAX_VALUE, 1);
        JSpinner weightT0Spinner = new JSpinner(weightT0SpinnerModel);
        weightT0Spinner.setBounds(columnB_posX - 35, columnB_Y += 20, 65, 20);
        weightT0Spinner.addChangeListener(e -> {
            int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
            this.setActivationWeight(tokenz, (Transition)this.element, 0);
        });
        this.components.add(weightT0Spinner);
        JLabel reqT3Label = new JLabel("T3 yellow:", 2);
        reqT3Label.setBounds(columnB_posX + 40, columnB_Y, 80, 20);
        this.components.add(reqT3Label);
        SpinnerNumberModel weightT3SpinnerModel = new SpinnerNumberModel(((TransitionColored)transition).getRequiredColoredTokens(3), 0, Integer.MAX_VALUE, 1);
        JSpinner weightT3Spinner = new JSpinner(weightT3SpinnerModel);
        weightT3Spinner.setBounds(columnB_posX + 100, columnB_Y, 65, 20);
        weightT3Spinner.addChangeListener(e -> {
            int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
            this.setActivationWeight(tokenz, (Transition)this.element, 3);
        });
        this.components.add(weightT3Spinner);
        JLabel reqT1Label = new JLabel("T1 green:", 2);
        reqT1Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
        this.components.add(reqT1Label);
        SpinnerNumberModel weightT1SpinnerModel = new SpinnerNumberModel(((TransitionColored)transition).getRequiredColoredTokens(1), 0, Integer.MAX_VALUE, 1);
        JSpinner weightT1Spinner = new JSpinner(weightT1SpinnerModel);
        weightT1Spinner.setBounds(columnB_posX - 35, columnB_Y += 20, 65, 20);
        weightT1Spinner.addChangeListener(e -> {
            int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
            this.setActivationWeight(tokenz, (Transition)this.element, 1);
        });
        this.components.add(weightT1Spinner);
        JLabel reqT4Label = new JLabel("T4 gray:", 2);
        reqT4Label.setBounds(columnB_posX + 40, columnB_Y, 80, 20);
        this.components.add(reqT4Label);
        SpinnerNumberModel weightT4SpinnerModel = new SpinnerNumberModel(((TransitionColored)transition).getRequiredColoredTokens(4), 0, Integer.MAX_VALUE, 1);
        JSpinner weightT4Spinner = new JSpinner(weightT4SpinnerModel);
        weightT4Spinner.setBounds(columnB_posX + 100, columnB_Y, 65, 20);
        weightT4Spinner.addChangeListener(e -> {
            int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
            this.setActivationWeight(tokenz, (Transition)this.element, 4);
        });
        this.components.add(weightT4Spinner);
        JLabel reqT2Label = new JLabel("T2 blue:", 2);
        reqT2Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
        this.components.add(reqT2Label);
        SpinnerNumberModel weightT2SpinnerModel = new SpinnerNumberModel(((TransitionColored)transition).getRequiredColoredTokens(2), 0, Integer.MAX_VALUE, 1);
        JSpinner weightT2Spinner = new JSpinner(weightT2SpinnerModel);
        weightT2Spinner.setBounds(columnB_posX - 35, columnB_Y += 20, 65, 20);
        weightT2Spinner.addChangeListener(e -> {
            int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
            this.setActivationWeight(tokenz, (Transition)this.element, 2);
        });
        this.components.add(weightT2Spinner);
        JLabel reqT5Label = new JLabel("T5 black:", 2);
        reqT5Label.setBounds(columnB_posX + 40, columnB_Y, 80, 20);
        this.components.add(reqT5Label);
        SpinnerNumberModel weightT5SpinnerModel = new SpinnerNumberModel(((TransitionColored)transition).getRequiredColoredTokens(5), 0, Integer.MAX_VALUE, 1);
        JSpinner weightT5Spinner = new JSpinner(weightT5SpinnerModel);
        weightT5Spinner.setBounds(columnB_posX + 100, columnB_Y, 65, 20);
        weightT5Spinner.addChangeListener(e -> {
            int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
            this.setActivationWeight(tokenz, (Transition)this.element, 5);
        });
        this.components.add(weightT5Spinner);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createSPNTransitionSubWindow(Transition transition, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.mode = 99;
        this.elementLocation = location;
        this.initiateContainers();
        this.element = transition;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("ID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        final int gID = this.overlord.getWorkspace().getProject().getTransitions().lastIndexOf(transition);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 10, colACompLength, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("gID:");
        idLabel3.setBounds(columnB_posX + 35, columnA_Y, 50, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + transition.getID());
        idLabel4.setBounds(columnB_posX + 60, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setValue(transition.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(transition.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        JLabel changeTypeLabel = new JLabel("Trans. Type:", 2);
        changeTypeLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(changeTypeLabel);
        this.classicalTransitionCheckBox = new JCheckBox("PN");
        this.classicalTransitionCheckBox.setBounds(columnB_posX, columnB_Y += 20, 60, 20);
        this.classicalTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.PN);
        this.classicalTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.PN);
                this.doNotUpdate = true;
                this.timeTransitionCheckBox.setSelected(false);
                this.stochasticTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.classicalTransitionCheckBox);
        this.timeTransitionCheckBox = new JCheckBox("TPN");
        this.timeTransitionCheckBox.setBounds(columnB_posX + 70, columnB_Y, 60, 20);
        this.timeTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.TPN);
        this.timeTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.TPN);
                this.doNotUpdate = true;
                this.classicalTransitionCheckBox.setSelected(false);
                this.stochasticTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.timeTransitionCheckBox);
        this.stochasticTransitionCheckBox = new JCheckBox("SPN");
        this.stochasticTransitionCheckBox.setBounds(columnB_posX + 130, columnB_Y, 60, 20);
        this.stochasticTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.SPN);
        this.stochasticTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.SPN);
                this.doNotUpdate = true;
                this.classicalTransitionCheckBox.setSelected(false);
                this.timeTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.stochasticTransitionCheckBox);
        JLabel frLabel = new JLabel("Firing rate:", 2);
        frLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(frLabel);
        JTextArea frField = new JTextArea("" + ((Transition)this.element).spnExtension.getFiringRate());
        frField.setBounds(columnB_posX, columnB_Y += 20, 60, 20);
        frField.setLineWrap(true);
        frField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newFR = "";
                if (field != null) {
                    newFR = field.getText();
                }
                try {
                    double newVal = Double.parseDouble(newFR);
                    SPNtransitionData xxx = GUIManager.getDefaultGUIManager().getWorkspace().getProject().accessFiringRatesManager().getCurrentSPNdataVector().accessVector().get(gID);
                    ((Transition)HolmesDockWindowsTable.this.element).spnExtension.setFiringRate(newVal);
                    xxx.ST_function = newFR;
                }
                catch (Exception ee) {
                    System.out.println(ee.getMessage());
                }
            }
        });
        this.components.add(frField);
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnB_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnB_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel locLabel = new JLabel("Location:", 2);
        locLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(locLabel);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        JPanel locationSpinnerPanel = new JPanel();
        locationSpinnerPanel.setLayout(new BoxLayout(locationSpinnerPanel, 0));
        locationSpinnerPanel.add(locationXSpinner);
        locationSpinnerPanel.add(new JLabel(" , "));
        locationSpinnerPanel.add(locationYSpinner);
        locationSpinnerPanel.setBounds(columnA_posX + 90, columnB_Y += 20, colBCompLength, 20);
        this.components.add(locationSpinnerPanel);
        JLabel portalLabel = new JLabel("Portal:", 2);
        portalLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(portalLabel);
        JCheckBox portalBox = new JCheckBox("", transition.isPortal());
        portalBox.setBounds(columnB_posX, columnB_Y += 20, 30, 20);
        portalBox.setSelected(((Transition)this.element).isPortal());
        portalBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                this.makePortal();
            } else if (((Transition)this.element).getElementLocations().size() > 1) {
                JOptionPane.showMessageDialog(null, "Transition contains more than one location!", "Cannot proceed", 1);
            } else {
                this.unPortal();
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(portalBox);
        JLabel functionLabel = new JLabel("Functional:", 2);
        functionLabel.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
        this.components.add(functionLabel);
        JCheckBox functionalCheckBox = new JCheckBox("", transition.fpnExtension.isFunctional());
        functionalCheckBox.setBounds(columnB_posX, columnB_Y += 20, 30, 20);
        functionalCheckBox.setSelected(((Transition)this.element).fpnExtension.isFunctional());
        functionalCheckBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            ((Transition)this.element).fpnExtension.setFunctional(box.isSelected());
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(functionalCheckBox);
        JButton functionsEditorButton = new JButton(Tools.getResIcon32("/icons/functionsWindow/functionsIcon.png"));
        functionsEditorButton.setName("Functions editor");
        functionsEditorButton.setText("<html>Functions<br>&nbsp;&nbsp;&nbsp;editor&nbsp;</html>");
        functionsEditorButton.setMargin(new Insets(0, 0, 0, 0));
        functionsEditorButton.setBounds(columnA_posX + 125, columnA_Y - 16, 110, 32);
        functionsEditorButton.addActionListener(actionEvent -> new HolmesFunctionsBuilder((Transition)this.element));
        this.components.add(functionsEditorButton);
        columnB_Y += 20;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = transition.getElementLocations().indexOf(location);
        int xNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("xOff: ", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnA_Y, 40, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 125, columnA_Y, 60, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("yOff: ", 2);
        locNameLabelY.setBounds(columnA_posX + 195, columnB_Y, 40, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 230, columnA_Y, 60, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationYSpinner);
        JButton nameLocChangeButton = new JButton(Tools.getResIcon22("/icons/changeNameLocation.png"));
        nameLocChangeButton.setName("LocNameChanger");
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnA_posX + 90, columnA_Y += 25, 150, 40);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton button_tmp = (JButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocationON.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocation.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocChangeButton);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createTimeTransitionSubWindow(Transition transition, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.mode = 7;
        this.elementLocation = location;
        this.initiateContainers();
        this.element = transition;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("ID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        int gID = this.overlord.getWorkspace().getProject().getTransitions().lastIndexOf(transition);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 10, colACompLength, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("gID:");
        idLabel3.setBounds(columnB_posX + 35, columnA_Y, 50, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + transition.getID());
        idLabel4.setBounds(columnB_posX + 60, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setValue(transition.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(transition.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        JLabel changeTypeLabel = new JLabel("Trans. Type:", 2);
        changeTypeLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(changeTypeLabel);
        this.classicalTransitionCheckBox = new JCheckBox("PN");
        this.classicalTransitionCheckBox.setBounds(columnB_posX, columnB_Y += 20, 60, 20);
        this.classicalTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.PN);
        this.classicalTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.PN);
                this.doNotUpdate = true;
                this.timeTransitionCheckBox.setSelected(false);
                this.stochasticTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.classicalTransitionCheckBox);
        this.timeTransitionCheckBox = new JCheckBox("TPN");
        this.timeTransitionCheckBox.setBounds(columnB_posX + 70, columnB_Y, 60, 20);
        this.timeTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.TPN);
        this.timeTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.TPN);
                this.doNotUpdate = true;
                this.classicalTransitionCheckBox.setSelected(false);
                this.stochasticTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.timeTransitionCheckBox);
        this.stochasticTransitionCheckBox = new JCheckBox("SPN");
        this.stochasticTransitionCheckBox.setBounds(columnB_posX + 130, columnB_Y, 60, 20);
        this.stochasticTransitionCheckBox.setSelected(((Transition)this.element).getTransType() == Transition.TransitionType.SPN);
        this.stochasticTransitionCheckBox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                ((Transition)this.element).setTransType(Transition.TransitionType.SPN);
                this.doNotUpdate = true;
                this.classicalTransitionCheckBox.setSelected(false);
                this.timeTransitionCheckBox.setSelected(false);
                this.doNotUpdate = false;
                GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
            }
        });
        this.components.add(this.stochasticTransitionCheckBox);
        JLabel minMaxLabel = new JLabel("EFT / LFT:", 2);
        minMaxLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(minMaxLabel);
        JFormattedTextField minTimeField = new JFormattedTextField();
        minTimeField.setValue(transition.timeExtension.getEFT());
        minTimeField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double min = (Double)field.getValue();
            this.setMinFireTime(min);
            this.overlord.markNetChange();
        });
        JFormattedTextField maxTimeField = new JFormattedTextField();
        maxTimeField.setValue(transition.timeExtension.getLFT());
        maxTimeField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double max = (Double)field.getValue();
            this.setMaxFireTime(max);
            this.overlord.markNetChange();
        });
        JPanel minTimeSpinnerPanel = new JPanel();
        minTimeSpinnerPanel.setLayout(new BoxLayout(minTimeSpinnerPanel, 0));
        minTimeSpinnerPanel.add(minTimeField);
        minTimeSpinnerPanel.add(new JLabel(" / "));
        minTimeSpinnerPanel.add(maxTimeField);
        minTimeSpinnerPanel.setBounds(columnA_posX + 90, columnB_Y += 20, 200, 20);
        this.components.add(minTimeSpinnerPanel);
        JLabel durationLabel = new JLabel("Duration:", 2);
        durationLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(durationLabel);
        JFormattedTextField durationField = new JFormattedTextField();
        durationField.setValue(transition.timeExtension.getDPNduration());
        durationField.setBounds(columnA_posX + 90, columnB_Y += 20, 90, 20);
        durationField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
                double time = (Double)field.getValue();
                this.setDurationTime(time);
                this.overlord.markNetChange();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        });
        this.components.add(durationField);
        JCheckBox tpnBox = new JCheckBox("TPN active", transition.timeExtension.isTPN());
        tpnBox.setBounds(columnB_posX - 5, columnB_Y += 20, 100, 20);
        tpnBox.setEnabled(true);
        tpnBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.setTPNstatus(box.isSelected());
            this.overlord.markNetChange();
        });
        this.components.add(tpnBox);
        columnA_Y += 20;
        JCheckBox dpnBox = new JCheckBox("DPN active", transition.timeExtension.isDPN());
        dpnBox.setBounds(columnB_posX + 100, columnB_Y, 100, 20);
        dpnBox.setEnabled(true);
        dpnBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.setDPNstatus(box.isSelected());
            this.overlord.markNetChange();
        });
        this.components.add(dpnBox);
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnB_Y += 20, 100, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnB_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnB_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel comLabel2 = new JLabel("Location:", 2);
        comLabel2.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(comLabel2);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        JPanel locationSpinnerPanel = new JPanel();
        locationSpinnerPanel.setLayout(new BoxLayout(locationSpinnerPanel, 0));
        locationSpinnerPanel.add(locationXSpinner);
        locationSpinnerPanel.add(new JLabel(" , "));
        locationSpinnerPanel.add(locationYSpinner);
        locationSpinnerPanel.setBounds(columnA_posX + 90, columnB_Y += 20, 200, 20);
        this.components.add(locationSpinnerPanel);
        JLabel portalLabel = new JLabel("Portal:", 2);
        portalLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(portalLabel);
        JCheckBox portalBox = new JCheckBox("", transition.isPortal());
        portalBox.setBounds(columnB_posX, columnB_Y += 20, 30, 20);
        portalBox.setSelected(((Transition)this.element).isPortal());
        portalBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                this.makePortal();
            } else if (((Transition)this.element).getElementLocations().size() > 1) {
                JOptionPane.showMessageDialog(null, "Transition contains more than one location!", "Cannot proceed", 1);
            } else {
                this.unPortal();
                this.overlord.markNetChange();
            }
        });
        this.components.add(portalBox);
        JLabel functionLabel = new JLabel("Functional:", 2);
        functionLabel.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
        this.components.add(functionLabel);
        JCheckBox functionalCheckBox = new JCheckBox("", transition.fpnExtension.isFunctional());
        functionalCheckBox.setBounds(columnB_posX, columnB_Y += 20, 30, 20);
        functionalCheckBox.setSelected(((Transition)this.element).fpnExtension.isFunctional());
        functionalCheckBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            ((Transition)this.element).fpnExtension.setFunctional(box.isSelected());
            this.overlord.markNetChange();
        });
        this.components.add(functionalCheckBox);
        JButton functionsEditorButton = new JButton(Tools.getResIcon32("/icons/functionsWindow/functionsIcon.png"));
        functionsEditorButton.setName("Functions editor");
        functionsEditorButton.setText("<html>Functions<br>&nbsp;&nbsp;&nbsp;editor&nbsp;</html>");
        functionsEditorButton.setMargin(new Insets(0, 0, 0, 0));
        functionsEditorButton.setBounds(columnA_posX + 125, columnA_Y - 16, 110, 32);
        functionsEditorButton.addActionListener(actionEvent -> new HolmesFunctionsBuilder((Transition)this.element));
        this.components.add(functionsEditorButton);
        columnB_Y += 20;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = transition.getElementLocations().indexOf(location);
        int xNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("xOff: ", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnA_Y, 40, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 125, columnA_Y, 60, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("yOff: ", 2);
        locNameLabelY.setBounds(columnA_posX + 195, columnB_Y, 40, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 230, columnA_Y, 60, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationYSpinner);
        JButton nameLocChangeButton = new JButton(Tools.getResIcon22("/icons/changeNameLocation.png"));
        nameLocChangeButton.setName("LocNameChanger");
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnA_posX + 90, columnA_Y += 25, 150, 40);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton button_tmp = (JButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocationON.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocation.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocChangeButton);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createXTPNTransitionSubWindow(TransitionXTPN transition, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.mode = 14;
        this.elementLocation = location;
        this.initiateContainers();
        this.element = transition;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("ID XTPN:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        int gID = this.overlord.getWorkspace().getProject().getTransitions().lastIndexOf(transition);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 10, colACompLength, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("globalID:");
        idLabel3.setBounds(columnB_posX + 55, columnA_Y, 50, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + transition.getID());
        idLabel4.setBounds(columnB_posX + 120, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setValue(transition.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(transition.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        columnA_Y += 20;
        JLabel changeTypeLabel = new JLabel("Time mode:", 2);
        changeTypeLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(changeTypeLabel);
        HolmesRoundedButton buttonAlfaMode = new HolmesRoundedButton("<html><center>Alpha:<br>ON</center></html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        buttonAlfaMode.setName("alphaModeButton");
        buttonAlfaMode.setMargin(new Insets(0, 0, 0, 0));
        buttonAlfaMode.setBounds(columnB_posX, columnB_Y += 20, 65, 35);
        if (transition.isAlphaModeActive()) {
            buttonAlfaMode.setNewText("<html><center>Alpha:<br>ON</center></html>");
            buttonAlfaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        } else {
            buttonAlfaMode.setNewText("<html><center>Alpha:<br>OFF</center></html>");
            buttonAlfaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        }
        buttonAlfaMode.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            this.doNotUpdate = true;
            SharedActionsXTPN.access().buttonAlphaSwitchMode(e, transition, null, this.tauVisibilityButton, this.buttonClassicMode, this.alphaMaxTextField, this.elementLocation);
            this.doNotUpdate = false;
        });
        this.components.add(buttonAlfaMode);
        HolmesRoundedButton buttonBetaMode = new HolmesRoundedButton("<html><center>Beta:<br>ON</center></html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        buttonBetaMode.setName("betaModeButton");
        buttonBetaMode.setMargin(new Insets(0, 0, 0, 0));
        buttonBetaMode.setBounds(columnB_posX + 65, columnB_Y, 65, 35);
        if (transition.isBetaModeActive()) {
            buttonBetaMode.setNewText("<html><center>Beta:<br>ON</center></html>");
            buttonBetaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        } else {
            buttonBetaMode.setNewText("<html><center>Beta:<br>OFF</center></html>");
            buttonBetaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        }
        buttonBetaMode.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            this.doNotUpdate = true;
            SharedActionsXTPN.access().buttonBetaSwitchMode(e, transition, null, this.tauVisibilityButton, this.buttonClassicMode, this.betaMaxTextField, this.elementLocation);
            this.doNotUpdate = false;
        });
        this.components.add(buttonBetaMode);
        this.buttonClassicMode = new HolmesRoundedButton("<html><center>XTPN</center></html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.buttonClassicMode.setName("classXTPNswitchButton");
        this.buttonClassicMode.setMargin(new Insets(0, 0, 0, 0));
        this.buttonClassicMode.setBounds(columnB_posX + 130, columnB_Y, 65, 35);
        if (!transition.isAlphaModeActive() && !transition.isBetaModeActive()) {
            this.buttonClassicMode.setNewText("<html>Classical<html>");
            this.buttonClassicMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        } else {
            this.buttonClassicMode.setNewText("<html>XTPN<html>");
            this.buttonClassicMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        }
        this.buttonClassicMode.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            this.doNotUpdate = true;
            SharedActionsXTPN.access().buttonTransitionToXTPN_classicSwitchMode(e, transition, null, this.alphaMaxTextField, this.betaMaxTextField, this.elementLocation);
            this.doNotUpdate = false;
        });
        this.components.add(this.buttonClassicMode);
        this.alfaVisibilityButton = new HolmesRoundedButton("<html>\u03b1:visible</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.alfaVisibilityButton.setName("alphaVisButton");
        this.alfaVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.alfaVisibilityButton.setBounds(columnB_posX, columnB_Y += 37, 65, 35);
        this.alfaVisibilityButton.setFocusPainted(false);
        if (transition.isAlphaModeActive()) {
            if (transition.isAlphaRangeVisible()) {
                this.alfaVisibilityButton.setNewText("<html>\u03b1:visible<html>");
                this.alfaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.alfaVisibilityButton.setNewText("<html>\u03b1:hidden<html>");
                this.alfaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            if (transition.isAlphaRangeVisible()) {
                this.alfaVisibilityButton.setNewText("<html>\u03b1:visible<html>");
            } else {
                this.alfaVisibilityButton.setNewText("<html>\u03b1:hidden<html>");
            }
            this.alfaVisibilityButton.setEnabled(false);
        }
        this.alfaVisibilityButton.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            this.alphaLocChangeMode = SharedActionsXTPN.access().alphaVisButtonAction(e, transition, this.alphaLocChangeButton, this.alphaLocChangeMode, this.elementLocation);
        });
        this.components.add(this.alfaVisibilityButton);
        this.betaVisibilityButton = new HolmesRoundedButton("<html>\u03b2:visible</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.betaVisibilityButton.setName("betaVisButton1");
        this.betaVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.betaVisibilityButton.setBounds(columnB_posX + 65, columnB_Y, 65, 35);
        this.betaVisibilityButton.setFocusPainted(false);
        if (transition.isBetaModeActive()) {
            if (transition.isBetaRangeVisible()) {
                this.betaVisibilityButton.setNewText("<html>\u03b2:visible<html>");
                this.betaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.betaVisibilityButton.setNewText("<html>\u03b2:hidden<html>");
                this.betaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            if (transition.isBetaRangeVisible()) {
                this.betaVisibilityButton.setNewText("<html>\u03b2:visible<html>");
            } else {
                this.betaVisibilityButton.setNewText("<html>\u03b2:hidden<html>");
            }
            this.betaVisibilityButton.setEnabled(false);
        }
        this.betaVisibilityButton.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            this.betaLocChangeMode = SharedActionsXTPN.access().betaVisButtonAction(e, transition, this.betaLocChangeButton, this.betaLocChangeMode, this.elementLocation);
        });
        this.components.add(this.betaVisibilityButton);
        this.tauVisibilityButton = new HolmesRoundedButton("<html>\u03c4:visible</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.tauVisibilityButton.setName("tauVisButton");
        this.tauVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.tauVisibilityButton.setBounds(columnB_posX + 130, columnB_Y, 65, 35);
        this.tauVisibilityButton.setFocusPainted(false);
        if (transition.isAlphaModeActive() || transition.isBetaModeActive()) {
            if (transition.isTauTimerVisible()) {
                this.tauVisibilityButton.setNewText("<html>\u03c4:visible<html>");
                this.tauVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.tauVisibilityButton.setNewText("<html>\u03c4:hidden<html>");
                this.tauVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            if (transition.isTauTimerVisible()) {
                this.tauVisibilityButton.setNewText("<html>\u03c4:visible<html>");
            } else {
                this.tauVisibilityButton.setNewText("<html>\u03c4:hidden<html>");
            }
            this.tauVisibilityButton.setEnabled(false);
        }
        this.tauVisibilityButton.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            this.tauLocChangeMode = SharedActionsXTPN.access().tauVisButtonAction(e, transition, this.tauLocChangeButton, this.tauLocChangeMode, this.elementLocation);
        });
        this.components.add(this.tauVisibilityButton);
        this.alphaLocChangeButton = new HolmesRoundedButton("<html><center>Alpha<br>offset</center><html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.alphaLocChangeButton.setName("alphaOffsetButton");
        this.alphaLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        this.alphaLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        this.alphaLocChangeButton.setBounds(columnB_posX, columnB_Y += 37, 65, 35);
        this.alphaLocChangeButton.setFocusPainted(false);
        if (transition.isAlphaModeActive() && transition.isAlphaRangeVisible()) {
            if (this.alphaLocChangeMode) {
                this.alphaLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                this.alphaLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                this.alphaLocChangeButton.setNewText("<html><center>Alpha<br>offset</center><html>");
                this.alphaLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            }
        } else {
            this.alphaLocChangeMode = false;
            this.alphaLocChangeButton.setEnabled(false);
        }
        this.alphaLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HolmesDockWindowsTable.this.alphaLocChangeMode) {
                    HolmesDockWindowsTable.this.alphaLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                    HolmesDockWindowsTable.this.alphaLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                    HolmesDockWindowsTable.this.alphaLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.ALPHA);
                } else {
                    HolmesDockWindowsTable.this.alphaLocChangeButton.setNewText("<html><center>Alpha<br>offset</center><html>");
                    HolmesDockWindowsTable.this.alphaLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                    HolmesDockWindowsTable.this.alphaLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.ALPHA);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(this.alphaLocChangeButton);
        this.betaLocChangeButton = new HolmesRoundedButton("<html><center>Beta<br>offset</center><html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.betaLocChangeButton.setName("betaOffsetButton");
        this.betaLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        this.betaLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        this.betaLocChangeButton.setBounds(columnB_posX + 65, columnB_Y, 65, 35);
        this.betaLocChangeButton.setFocusPainted(false);
        if (transition.isBetaModeActive() && transition.isBetaRangeVisible()) {
            if (this.betaLocChangeMode) {
                this.betaLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                this.betaLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                this.betaLocChangeButton.setNewText("<html><center>Beta<br>offset</center><html>");
                this.betaLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            }
        } else {
            this.betaLocChangeMode = false;
            this.betaLocChangeButton.setEnabled(false);
        }
        this.betaLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HolmesDockWindowsTable.this.betaLocChangeMode) {
                    HolmesDockWindowsTable.this.betaLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                    HolmesDockWindowsTable.this.betaLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                    HolmesDockWindowsTable.this.betaLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.BETA);
                } else {
                    HolmesDockWindowsTable.this.betaLocChangeButton.setNewText("<html><center>Beta<br>offset</center><html>");
                    HolmesDockWindowsTable.this.betaLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                    HolmesDockWindowsTable.this.betaLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.BETA);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(this.betaLocChangeButton);
        this.tauLocChangeButton = new HolmesRoundedButton("<html><center>Tau<br>offset</center><html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.tauLocChangeButton.setName("tauOffsetButton");
        this.tauLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        this.tauLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        this.tauLocChangeButton.setBounds(columnB_posX + 130, columnB_Y, 65, 35);
        this.tauLocChangeButton.setFocusPainted(false);
        if (transition.isAlphaModeActive() || transition.isBetaModeActive()) {
            if (this.tauLocChangeMode) {
                this.tauLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                this.tauLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                this.tauLocChangeButton.setNewText("<html><center>Tau<br>offset</center><html>");
                this.tauLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            }
        } else {
            this.tauLocChangeMode = false;
            this.tauLocChangeButton.setEnabled(false);
        }
        this.tauLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HolmesDockWindowsTable.this.tauLocChangeMode) {
                    HolmesDockWindowsTable.this.tauLocChangeButton.setNewText("<html><center>Change<br>location</center><html>");
                    HolmesDockWindowsTable.this.tauLocChangeButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                    HolmesDockWindowsTable.this.tauLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.TAU);
                } else {
                    HolmesDockWindowsTable.this.tauLocChangeButton.setNewText("<html><center>Tau<br>offset</center><html>");
                    HolmesDockWindowsTable.this.tauLocChangeButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                    HolmesDockWindowsTable.this.tauLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.TAU);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(this.tauLocChangeButton);
        JLabel minMaxLabel = new JLabel("\u03b1 (min/max): ", 2);
        minMaxLabel.setBounds(columnA_posX, columnA_Y += 105, colACompLength + 10, 20);
        this.components.add(minMaxLabel);
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumFractionDigits(6);
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        Double example = 3.14;
        this.alphaMinTextField = new JFormattedTextField(formatter);
        this.alphaMinTextField.setValue(example);
        this.alphaMinTextField.setValue(transition.getAlphaMinValue());
        this.alphaMinTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double min = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setAlfaMinTime(min, transition, this.elementLocation);
            this.doNotUpdate = true;
            this.alphaMaxTextField.setValue(transition.getAlphaMaxValue());
            field.setValue(transition.getAlphaMinValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.alphaMaxTextField = new JFormattedTextField(formatter);
        this.alphaMaxTextField.setValue(example);
        this.alphaMaxTextField.setValue(transition.getAlphaMaxValue());
        this.alphaMaxTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double max = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setAlfaMaxTime(max, transition, this.elementLocation);
            this.doNotUpdate = true;
            this.alphaMinTextField.setValue(transition.getAlphaMinValue());
            field.setValue(transition.getAlphaMaxValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        if (!transition.isAlphaModeActive()) {
            this.alphaMinTextField.setEnabled(false);
            this.alphaMaxTextField.setEnabled(false);
        }
        this.alphaMinTextField.setBounds(columnB_posX, columnB_Y += 36, 80, 20);
        this.components.add(this.alphaMinTextField);
        JLabel slash1 = new JLabel(" / ", 2);
        slash1.setBounds(columnB_posX + 85, columnB_Y, 15, 20);
        this.components.add(slash1);
        this.alphaMaxTextField.setBounds(columnB_posX + 100, columnB_Y, 80, 20);
        this.components.add(this.alphaMaxTextField);
        JLabel betaLabel = new JLabel("\u03b2 (min/max): ", 2);
        betaLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(betaLabel);
        this.betaMinTextField = new JFormattedTextField(formatter);
        this.betaMinTextField.setValue(example);
        this.betaMinTextField.setValue(transition.getBetaMinValue());
        this.betaMinTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double min = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setBetaMinTime(min, transition, this.elementLocation);
            this.doNotUpdate = true;
            field.setValue(transition.getBetaMinValue());
            this.betaMaxTextField.setValue(transition.getBetaMaxValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.betaMaxTextField = new JFormattedTextField(formatter);
        this.betaMaxTextField.setValue(example);
        this.betaMaxTextField.setValue(transition.getBetaMaxValue());
        this.betaMaxTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double max = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setBetaMaxTime(max, transition, this.elementLocation);
            this.doNotUpdate = true;
            this.betaMinTextField.setValue(transition.getBetaMinValue());
            field.setValue(transition.getBetaMaxValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        if (!transition.isBetaModeActive()) {
            this.betaMinTextField.setEnabled(false);
            this.betaMaxTextField.setEnabled(false);
        }
        this.betaMinTextField.setBounds(columnB_posX, columnB_Y += 20, 80, 20);
        this.components.add(this.betaMinTextField);
        JLabel slash2 = new JLabel(" / ", 2);
        slash2.setBounds(columnB_posX + 85, columnB_Y, 15, 20);
        this.components.add(slash2);
        this.betaMaxTextField.setBounds(columnB_posX + 100, columnB_Y, 80, 20);
        this.components.add(this.betaMaxTextField);
        JCheckBox makCheckBox = new JCheckBox("Mass-Action kinetics");
        makCheckBox.setBounds(columnA_posX - 5, columnA_Y += 25, 150, 20);
        makCheckBox.setSelected(transition.isMassActionKineticsActiveXTPN());
        makCheckBox.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            transition.setMassActionKineticsXTPNstatus(makCheckBox.isSelected());
        });
        this.components.add(makCheckBox);
        JCheckBox immediateCheckBox = new JCheckBox("Immediate");
        immediateCheckBox.setBounds(columnA_posX + 150, columnA_Y, 100, 20);
        immediateCheckBox.setSelected(transition.isImmediateXTPN());
        immediateCheckBox.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            transition.setImmediateStatusXTPN(immediateCheckBox.isSelected());
        });
        this.components.add(immediateCheckBox);
        JCheckBox functionalCheckBox = new JCheckBox("Functional", transition.fpnExtension.isFunctional());
        functionalCheckBox.setBounds(columnA_posX - 5, columnA_Y += 20, 140, 20);
        functionalCheckBox.setSelected(((Transition)this.element).fpnExtension.isFunctional());
        functionalCheckBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            ((Transition)this.element).fpnExtension.setFunctional(box.isSelected());
            this.overlord.markNetChange();
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(functionalCheckBox);
        JButton functionsEditorButton = new JButton(Tools.getResIcon32("/icons/functionsWindow/functionsIcon.png"));
        functionsEditorButton.setName("Functions editor");
        functionsEditorButton.setText("<html>Functions<br>&nbsp;&nbsp;&nbsp;editor&nbsp;</html>");
        functionsEditorButton.setMargin(new Insets(0, 0, 0, 0));
        functionsEditorButton.setBounds(columnB_posX + 65, columnB_Y + 45, 110, 32);
        functionsEditorButton.addActionListener(actionEvent -> new HolmesFunctionsBuilder((Transition)this.element));
        this.components.add(functionsEditorButton);
        JCheckBox portalBox = new JCheckBox("Portal:", transition.isPortal());
        portalBox.setBounds(columnA_posX - 5, columnA_Y += 20, 90, 20);
        portalBox.setSelected(((Transition)this.element).isPortal());
        portalBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            if (box.isSelected()) {
                this.makePortal();
            } else if (((Transition)this.element).getElementLocations().size() > 1) {
                JOptionPane.showMessageDialog(null, "XTPN Transition contains more than one location!", "Cannot proceed", 1);
            } else {
                this.unPortal();
                this.overlord.markNetChange();
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.elementLocation);
        });
        this.components.add(portalBox);
        JLabel fractionLabel = new JLabel("Fraction:", 2);
        fractionLabel.setBounds(columnA_posX, columnA_Y += 20, 70, 20);
        this.components.add(fractionLabel);
        int fract = transition.getFraction_xTPN();
        SpinnerNumberModel fractionSpinnerModel = new SpinnerNumberModel(fract, 0, 6, 1);
        JSpinner fractionSpinner = new JSpinner(fractionSpinnerModel);
        fractionSpinner.setBounds(columnB_posX, columnB_Y += 82, 40, 20);
        fractionSpinner.addChangeListener(e -> {
            int fraction = (Integer)((JSpinner)e.getSource()).getValue();
            transition.setFraction_xTPN(fraction);
        });
        this.components.add(fractionSpinner);
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 25, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnB_Y += 25, 100, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnB_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnB_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel comLabel2 = new JLabel("Location:", 2);
        comLabel2.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(comLabel2);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.setBounds(columnB_posX, columnB_Y += 20, 60, 20);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JLabel labelCom = new JLabel(" , ");
        labelCom.setBounds(columnB_posX + 60, columnB_Y, 10, 20);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.setBounds(columnB_posX + 70, columnB_Y, 60, 20);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        this.components.add(locationXSpinner);
        this.components.add(labelCom);
        this.components.add(locationYSpinner);
        columnB_Y += 20;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = transition.getElementLocations().indexOf(location);
        int xNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = transition.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("x:", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnB_Y, 20, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 105, columnB_Y, 45, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("y:", 2);
        locNameLabelY.setBounds(columnA_posX + 160, columnB_Y, 10, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 175, columnA_Y, 45, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.trans_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocationYSpinner);
        HolmesRoundedButton nameLocChangeButton = new HolmesRoundedButton("<html><center>Name<br>offset</center><html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        nameLocChangeButton.setName("transNameOffsetButton");
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnB_posX + 131, columnA_Y - 15, 65, 35);
        nameLocChangeButton.setFocusPainted(false);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private Transition trans_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HolmesRoundedButton button = (HolmesRoundedButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button.setNewText("<html><center>Change<br>location</center><html>");
                    button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.trans_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button.setNewText("<html><center>Name<br>offset</center><html>");
                    button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(Transition transition, ElementLocation inLoc) {
                this.trans_tmp = transition;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(transition, location));
        this.components.add(nameLocChangeButton);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createMetaNodeSubWindow(MetaNode metaNode, ElementLocation location) {
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.mode = 11;
        this.elementLocation = location;
        this.initiateContainers();
        this.element = metaNode;
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("ID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        int gID = this.overlord.getWorkspace().getProject().getMetaNodes().lastIndexOf(metaNode);
        JLabel idLabel2 = new JLabel(Integer.toString(gID));
        idLabel2.setBounds(columnB_posX, columnB_Y += 10, colACompLength, 20);
        idLabel2.setFont(normalFont);
        this.components.add(idLabel2);
        JLabel idLabel3 = new JLabel("gID:");
        idLabel3.setBounds(columnB_posX + 35, columnA_Y, 50, 20);
        this.components.add(idLabel3);
        JLabel idLabel4 = new JLabel("" + metaNode.getID());
        idLabel4.setBounds(columnB_posX + 60, columnB_Y, 50, 20);
        idLabel4.setFont(normalFont);
        this.components.add(idLabel4);
        JLabel sheetRepresentedLabel = new JLabel("Subnet(sheet):");
        sheetRepresentedLabel.setBounds(columnA_posX, columnA_Y += 20, 95, 20);
        this.components.add(sheetRepresentedLabel);
        int shID = metaNode.getRepresentedSheetID();
        String text = "" + shID;
        text = text + " (" + this.overlord.getWorkspace().getIndexOfId(metaNode.getRepresentedSheetID()) + ")";
        JLabel sheetRepresentedLabelValue = new JLabel(text);
        sheetRepresentedLabelValue.setBounds(columnB_posX, columnB_Y += 20, 50, 20);
        sheetRepresentedLabelValue.setFont(normalFont);
        this.components.add(sheetRepresentedLabelValue);
        JLabel nameLabel = new JLabel("Name:", 2);
        nameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(nameLabel);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 20);
        nameField.setValue(metaNode.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.changeName(newName);
            this.overlord.markNetChange();
        });
        this.components.add(nameField);
        JLabel comLabel = new JLabel("Comment:", 2);
        comLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(comLabel);
        JTextArea commentField = new JTextArea(metaNode.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
                HolmesDockWindowsTable.this.overlord.markNetChange();
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        JRadioButton subnetTButton = new JRadioButton("Subnet T-type");
        subnetTButton.setBounds(columnA_posX - 5, columnA_Y += 20, 105, 20);
        subnetTButton.setActionCommand("0");
        subnetTButton.addActionListener(new ActionListener(){
            private MetaNode myMeta = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                boolean status = false;
                if (this.myMeta.getMetaType() != MetaNode.MetaType.SUBNETTRANS) {
                    status = HolmesDockWindowsTable.this.overlord.subnetsHQ.changeSubnetType(this.myMeta, MetaNode.MetaType.SUBNETTRANS);
                }
                if (!status) {
                    HolmesDockWindowsTable.this.doNotUpdate = true;
                    Enumeration<AbstractButton> wtf = HolmesDockWindowsTable.this.groupRadioMetaType.getElements();
                    JRadioButton radioB = (JRadioButton)wtf.nextElement();
                    if (this.myMeta.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                        radioB = (JRadioButton)wtf.nextElement();
                    }
                    if (this.myMeta.getMetaType() == MetaNode.MetaType.SUBNET) {
                        radioB = (JRadioButton)wtf.nextElement();
                        radioB = (JRadioButton)wtf.nextElement();
                    }
                    HolmesDockWindowsTable.this.groupRadioMetaType.setSelected(radioB.getModel(), true);
                    HolmesDockWindowsTable.this.doNotUpdate = false;
                }
            }

            private ActionListener yesWeCan(MetaNode metaN) {
                this.myMeta = metaN;
                return this;
            }
        }.yesWeCan(metaNode));
        this.groupRadioMetaType.add(subnetTButton);
        this.components.add(subnetTButton);
        JRadioButton subnetPButton = new JRadioButton("Subnet P-type");
        subnetPButton.setBounds(columnA_posX + 100, columnA_Y, 120, 20);
        subnetPButton.setActionCommand("1");
        subnetPButton.addActionListener(new ActionListener(){
            private MetaNode myMeta = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                boolean status = false;
                if (this.myMeta.getMetaType() != MetaNode.MetaType.SUBNETPLACE) {
                    status = HolmesDockWindowsTable.this.overlord.subnetsHQ.changeSubnetType(this.myMeta, MetaNode.MetaType.SUBNETPLACE);
                }
                if (!status) {
                    HolmesDockWindowsTable.this.doNotUpdate = true;
                    Enumeration<AbstractButton> wtf = HolmesDockWindowsTable.this.groupRadioMetaType.getElements();
                    JRadioButton radioB = (JRadioButton)wtf.nextElement();
                    if (this.myMeta.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                        radioB = (JRadioButton)wtf.nextElement();
                    }
                    if (this.myMeta.getMetaType() == MetaNode.MetaType.SUBNET) {
                        radioB = (JRadioButton)wtf.nextElement();
                        radioB = (JRadioButton)wtf.nextElement();
                    }
                    HolmesDockWindowsTable.this.groupRadioMetaType.setSelected(radioB.getModel(), true);
                    HolmesDockWindowsTable.this.doNotUpdate = false;
                }
            }

            private ActionListener yesWeCan(MetaNode metaN) {
                this.myMeta = metaN;
                return this;
            }
        }.yesWeCan(metaNode));
        this.groupRadioMetaType.add(subnetPButton);
        this.components.add(subnetPButton);
        JRadioButton subnetPTButton = new JRadioButton("P & T");
        subnetPTButton.setBounds(columnA_posX + 230, columnA_Y, 80, 20);
        subnetPTButton.setActionCommand("2");
        subnetPTButton.addActionListener(new ActionListener(){
            private MetaNode myMeta = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                if (this.myMeta.getMetaType() != MetaNode.MetaType.SUBNET) {
                    HolmesDockWindowsTable.this.overlord.subnetsHQ.changeSubnetType(this.myMeta, MetaNode.MetaType.SUBNET);
                }
                HolmesDockWindowsTable.this.doNotUpdate = true;
                Enumeration<AbstractButton> wtf = HolmesDockWindowsTable.this.groupRadioMetaType.getElements();
                JRadioButton radioB = (JRadioButton)wtf.nextElement();
                if (this.myMeta.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                    radioB = (JRadioButton)wtf.nextElement();
                }
                if (this.myMeta.getMetaType() == MetaNode.MetaType.SUBNET) {
                    radioB = (JRadioButton)wtf.nextElement();
                    radioB = (JRadioButton)wtf.nextElement();
                }
                HolmesDockWindowsTable.this.groupRadioMetaType.setSelected(radioB.getModel(), true);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ActionListener yesWeCan(MetaNode metaN) {
                this.myMeta = metaN;
                return this;
            }
        }.yesWeCan(metaNode));
        this.groupRadioMetaType.add(subnetPTButton);
        this.components.add(subnetPTButton);
        this.doNotUpdate = true;
        if (metaNode.getMetaType() == MetaNode.MetaType.SUBNETTRANS) {
            this.groupRadioMetaType.setSelected(subnetTButton.getModel(), true);
        } else if (metaNode.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
            this.groupRadioMetaType.setSelected(subnetPButton.getModel(), true);
        } else if (metaNode.getMetaType() == MetaNode.MetaType.SUBNET) {
            this.groupRadioMetaType.setSelected(subnetPTButton.getModel(), true);
        }
        this.doNotUpdate = false;
        columnB_Y += 20;
        int sheetIndex = this.overlord.IDtoIndex(location.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        int xPos = location.getPosition().x;
        int width = graphPanel.getSize().width;
        int zoom = graphPanel.getZoom();
        int yPos = location.getPosition().y;
        int height = graphPanel.getSize().height;
        width = (int)(100.0 / (double)zoom * (double)width);
        height = (int)(100.0 / (double)zoom * (double)height);
        JLabel sheetLabel = new JLabel("Sheet:", 2);
        sheetLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(sheetLabel);
        JLabel sheetIdLabel = new JLabel(Integer.toString(location.getSheetID()));
        sheetIdLabel.setBounds(columnB_posX, columnB_Y += 20, 100, 20);
        sheetIdLabel.setFont(normalFont);
        this.components.add(sheetIdLabel);
        JLabel zoomLabel = new JLabel("Zoom:");
        zoomLabel.setBounds(columnB_posX + 30, columnB_Y, 50, 20);
        this.components.add(zoomLabel);
        JLabel zoomLabel2 = new JLabel("" + zoom);
        zoomLabel2.setBounds(columnB_posX + 70, columnB_Y, colBCompLength, 20);
        zoomLabel2.setFont(normalFont);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel comLabel2 = new JLabel("Location:", 2);
        comLabel2.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(comLabel2);
        SpinnerNumberModel locationXSpinnerModel = new SpinnerNumberModel(xPos, 0, width, 1);
        SpinnerNumberModel locationYSpinnerModel = new SpinnerNumberModel(yPos, 0, height, 1);
        JSpinner locationXSpinner = new JSpinner(locationXSpinnerModel);
        locationXSpinner.addChangeListener(e -> this.setX((Integer)((JSpinner)e.getSource()).getValue()));
        JSpinner locationYSpinner = new JSpinner(locationYSpinnerModel);
        locationYSpinner.addChangeListener(e -> this.setY((Integer)((JSpinner)e.getSource()).getValue()));
        if (zoom != 100) {
            locationXSpinner.setEnabled(false);
            locationYSpinner.setEnabled(false);
        }
        JPanel locationSpinnerPanel = new JPanel();
        locationSpinnerPanel.setLayout(new BoxLayout(locationSpinnerPanel, 0));
        locationSpinnerPanel.add(locationXSpinner);
        locationSpinnerPanel.add(new JLabel(" , "));
        locationSpinnerPanel.add(locationYSpinner);
        locationSpinnerPanel.setBounds(columnA_posX + 90, columnB_Y += 20, 200, 20);
        this.components.add(locationSpinnerPanel);
        columnB_Y += 20;
        JLabel locNameLabel = new JLabel("Name offset:", 2);
        locNameLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength + 10, 20);
        this.components.add(locNameLabel);
        int locationIndex = metaNode.getElementLocations().indexOf(location);
        int xNameOffset = metaNode.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().x;
        int yNameOffset = metaNode.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)locationIndex).getPosition().y;
        this.nameLocationXSpinnerModel = new SpinnerNumberModel(xNameOffset, -99999, 99999, 1);
        this.nameLocationYSpinnerModel = new SpinnerNumberModel(yNameOffset, -99999, 99999, 1);
        JLabel locNameLabelX = new JLabel("xOff: ", 2);
        locNameLabelX.setBounds(columnA_posX + 90, columnA_Y, 40, 20);
        this.components.add(locNameLabelX);
        JSpinner nameLocationXSpinner = new JSpinner(this.nameLocationXSpinnerModel);
        nameLocationXSpinner.setBounds(columnA_posX + 125, columnA_Y, 60, 20);
        nameLocationXSpinner.addChangeListener(new ChangeListener(){
            private MetaNode meta_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetX((Integer)((JSpinner)e.getSource()).getValue(), this.meta_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationXSpinnerModel.setValue(res.x);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(MetaNode metaN, ElementLocation inLoc) {
                this.meta_tmp = metaN;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(metaNode, location));
        this.components.add(nameLocationXSpinner);
        JLabel locNameLabelY = new JLabel("yOff: ", 2);
        locNameLabelY.setBounds(columnA_posX + 195, columnB_Y, 40, 20);
        this.components.add(locNameLabelY);
        JSpinner nameLocationYSpinner = new JSpinner(this.nameLocationYSpinnerModel);
        nameLocationYSpinner.setBounds(columnA_posX + 230, columnA_Y, 60, 20);
        nameLocationYSpinner.addChangeListener(new ChangeListener(){
            private MetaNode meta_tmp;
            private ElementLocation el_tmp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HolmesDockWindowsTable.this.doNotUpdate) {
                    return;
                }
                Point res = HolmesDockWindowsTable.this.setNameOffsetY((Integer)((JSpinner)e.getSource()).getValue(), this.meta_tmp, this.el_tmp);
                HolmesDockWindowsTable.this.doNotUpdate = true;
                HolmesDockWindowsTable.this.nameLocationYSpinnerModel.setValue(res.y);
                HolmesDockWindowsTable.this.doNotUpdate = false;
            }

            private ChangeListener yesWeCan(MetaNode metaN, ElementLocation inLoc) {
                this.meta_tmp = metaN;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(metaNode, location));
        this.components.add(nameLocationYSpinner);
        JButton nameLocChangeButton = new JButton(Tools.getResIcon22("/icons/changeNameLocation.png"));
        nameLocChangeButton.setName("LocNameChanger");
        nameLocChangeButton.setToolTipText("MouseWheel - up/down ; SHIFT+MouseWheel - left/right");
        nameLocChangeButton.setMargin(new Insets(0, 0, 0, 0));
        nameLocChangeButton.setBounds(columnA_posX + 90, columnA_Y += 25, 150, 40);
        nameLocChangeButton.addActionListener(new ActionListener(){
            private MetaNode meta_tmp;
            private ElementLocation el_tmp;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton button_tmp = (JButton)actionEvent.getSource();
                if (!HolmesDockWindowsTable.this.nameLocChangeMode) {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocationON.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = true;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(this.meta_tmp, this.el_tmp, GUIManager.locationMoveType.NAME);
                } else {
                    button_tmp.setIcon(Tools.getResIcon22("/icons/changeNameLocation.png"));
                    HolmesDockWindowsTable.this.nameLocChangeMode = false;
                    HolmesDockWindowsTable.this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
                }
            }

            private ActionListener yesWeCan(MetaNode metaN, ElementLocation inLoc) {
                this.meta_tmp = metaN;
                this.el_tmp = inLoc;
                return this;
            }
        }.yesWeCan(metaNode, location));
        this.components.add(nameLocChangeButton);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createArcSubWindow(Arc arc) {
        int columnA_posX = 10;
        int columnB_posX = 110;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.initiateContainers();
        this.mode = 2;
        if (arc.arcXTPNbox.isXTPN()) {
            this.mode = 16;
        }
        this.element = arc;
        this.pairedArc = arc.getPairedArc();
        this.elementLocation = arc.getStartLocation();
        Font normalFont = new Font("Dialog", 0, 12);
        JLabel idLabel = new JLabel("gID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 10, colACompLength, 20);
        this.components.add(idLabel);
        JLabel idLabel2 = new JLabel(Integer.toString(arc.getID()));
        idLabel2.setFont(normalFont);
        idLabel2.setBounds(columnB_posX - 10, columnB_Y += 10, colACompLength, 20);
        this.components.add(idLabel2);
        JLabel commLabel = new JLabel("Comment:", 2);
        commLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        columnA_Y += 20;
        this.components.add(commLabel);
        JTextArea commentField = new JTextArea(arc.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesDockWindowsTable.this.changeComment(newComment);
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(commentField), "Center");
        CreationPanel.setBounds(columnB_posX - 10, columnB_Y += 20, colBCompLength, 40);
        columnB_Y += 20;
        this.components.add(CreationPanel);
        if (((Arc)this.element).getArcType() != Arc.TypeOfArc.RESET && ((Arc)this.element).getArcType() != Arc.TypeOfArc.COLOR) {
            if (((Arc)this.element).getArcType() == Arc.TypeOfArc.READARC && this.pairedArc != null) {
                String type1 = "T-->P";
                String type2 = "P-->T";
                if (((Arc)this.element).getStartNode() instanceof Place) {
                    type1 = "P-->T";
                    type2 = "T-->P";
                }
                JLabel weightLabel = new JLabel("Weight (" + type1 + ")", 2);
                weightLabel.setBounds(columnA_posX, columnA_Y += 20, 100, 20);
                this.components.add(weightLabel);
                SpinnerNumberModel weightSpinnerModel = new SpinnerNumberModel(arc.getWeight(), 0, Integer.MAX_VALUE, 1);
                JSpinner weightSpinner = new JSpinner(weightSpinnerModel);
                weightSpinner.setBounds(columnB_posX - 10, columnB_Y += 20, colBCompLength / 3, 20);
                weightSpinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setWeight(tokenz, (Arc)this.element);
                });
                this.components.add(weightSpinner);
                JLabel weightLabel2 = new JLabel("Weight (" + type2 + ")", 2);
                weightLabel2.setBounds(columnA_posX, columnA_Y += 20, 100, 20);
                this.components.add(weightLabel2);
                SpinnerNumberModel weightSpinnerModel2 = new SpinnerNumberModel(this.pairedArc.getWeight(), 0, Integer.MAX_VALUE, 1);
                JSpinner weightSpinner2 = new JSpinner(weightSpinnerModel2);
                weightSpinner2.setBounds(columnB_posX - 10, columnB_Y += 20, colBCompLength / 3, 20);
                weightSpinner2.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setWeight(tokenz, this.pairedArc);
                });
                this.components.add(weightSpinner2);
            } else {
                JLabel weightLabel = new JLabel("Weight:", 2);
                weightLabel.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
                this.components.add(weightLabel);
                SpinnerNumberModel weightSpinnerModel = new SpinnerNumberModel(arc.getWeight(), 0, Integer.MAX_VALUE, 1);
                JSpinner weightSpinner = new JSpinner(weightSpinnerModel);
                weightSpinner.setBounds(columnB_posX - 10, columnB_Y += 20, colBCompLength / 3, 20);
                weightSpinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setWeight(tokenz, (Arc)this.element);
                });
                this.components.add(weightSpinner);
            }
        }
        columnB_posX += 30;
        JLabel typeArcLabel = new JLabel("Type:", 2);
        typeArcLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength += 40, 20);
        this.components.add(typeArcLabel);
        JLabel typeArcLabel2 = new JLabel(arc.getArcType().toString());
        typeArcLabel2.setFont(normalFont);
        typeArcLabel2.setBounds(columnB_posX - 40, columnB_Y += 20, colACompLength + 40, 20);
        this.components.add(typeArcLabel2);
        JLabel readArcLabel = new JLabel("Read arc:", 2);
        readArcLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(readArcLabel);
        Object txt = "no";
        if (this.pairedArc != null) {
            txt = "yes [paired arc ID: " + this.pairedArc.getID() + "]";
        } else if (InvariantsTools.isDoubleArc(arc)) {
            txt = "double arc (hidden readarc)";
        }
        JLabel readArcLabel2 = new JLabel((String)txt);
        readArcLabel2.setFont(normalFont);
        readArcLabel2.setBounds(columnB_posX - 40, columnB_Y += 20, colACompLength + 60, 20);
        this.components.add(readArcLabel2);
        JLabel startNodeLabel = new JLabel("Start Node name:", 2);
        startNodeLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(startNodeLabel);
        JLabel label2B = new JLabel(arc.getStartNode().getName());
        label2B.setFont(normalFont);
        label2B.setBounds(columnA_posX + 110, columnB_Y += 20, colBCompLength + 40, 20);
        this.components.add(label2B);
        JLabel label1A = new JLabel("gID:", 2);
        label1A.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(label1A);
        JLabel label1B = new JLabel(Integer.toString(arc.getStartNode().getID()));
        label1B.setFont(normalFont);
        label1B.setBounds(columnA_posX + 40, columnB_Y += 20, 50, 20);
        this.components.add(label1B);
        JLabel label3A = new JLabel("Sheet:", 2);
        label3A.setBounds(columnA_posX + 80, columnA_Y, colACompLength, 20);
        this.components.add(label3A);
        JLabel label3B = new JLabel(Integer.toString(arc.getStartLocation().getSheetID()));
        label3B.setFont(normalFont);
        label3B.setBounds(columnA_posX + 120, columnB_Y, 40, 20);
        this.components.add(label3B);
        JLabel label4A = new JLabel("Location:", 2);
        label4A.setBounds(columnA_posX + 150, columnA_Y, colACompLength, 20);
        this.components.add(label4A);
        JLabel label4B = new JLabel(arc.getStartLocation().getPosition().x + ", " + arc.getStartLocation().getPosition().y);
        label4B.setBounds(columnA_posX + 210, columnB_Y, colBCompLength, 20);
        label4B.setFont(normalFont);
        this.components.add(label4B);
        JLabel endNodeLabel = new JLabel("End Node name:", 2);
        endNodeLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(endNodeLabel);
        JLabel label6B = new JLabel(arc.getEndNode().getName());
        label6B.setFont(normalFont);
        label6B.setBounds(columnA_posX + 110, columnB_Y += 20, colBCompLength + 40, 20);
        this.components.add(label6B);
        JLabel label5A = new JLabel("gID:", 2);
        label5A.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(label5A);
        JLabel label5B = new JLabel(Integer.toString(arc.getEndNode().getID()));
        label5B.setFont(normalFont);
        label5B.setBounds(columnA_posX + 40, columnB_Y += 20, colBCompLength, 20);
        this.components.add(label5B);
        JLabel label7A = new JLabel("Sheet:", 2);
        label7A.setBounds(columnA_posX + 80, columnA_Y, colACompLength, 20);
        this.components.add(label7A);
        JLabel label7B = new JLabel(Integer.toString(arc.getEndLocation().getSheetID()));
        label7B.setFont(normalFont);
        label7B.setBounds(columnA_posX + 120, columnB_Y, 40, 20);
        this.components.add(label7B);
        JLabel label8A = new JLabel("Location:", 2);
        label8A.setBounds(columnA_posX + 150, columnA_Y, colACompLength, 20);
        this.components.add(label8A);
        JLabel label8B = new JLabel(arc.getEndLocation().getPosition().x + ", " + arc.getEndLocation().getPosition().y);
        label8B.setFont(normalFont);
        label8B.setBounds(columnA_posX + 210, columnB_Y, colBCompLength, 20);
        this.components.add(label8B);
        if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
            String type1 = "T-->P (Transition to Place weights):";
            String type2 = "P-->T (Place to Transition weights):";
            this.pairedArc = InvariantsTools.getPairedArc(arc);
            if (this.pairedArc != null) {
                if (((Arc)this.element).getStartNode() instanceof Place) {
                    type1 = "P-->T (Place to Transition weights):";
                    type2 = "T-->P (Transition to Place weights):";
                }
                JLabel weightPair1Label = new JLabel(type1, 2);
                weightPair1Label.setBounds(columnA_posX, columnA_Y += 20, 260, 20);
                columnB_Y += 20;
                this.components.add(weightPair1Label);
            }
            JLabel weight0Label = new JLabel("W0 (red):", 2);
            weight0Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
            this.components.add(weight0Label);
            SpinnerNumberModel weightT0SpinnerModel = new SpinnerNumberModel(arc.getColorWeight(0), 0, Integer.MAX_VALUE, 1);
            JSpinner weightT0Spinner = new JSpinner(weightT0SpinnerModel);
            weightT0Spinner.setBounds(columnB_posX - 60, columnB_Y += 20, 65, 20);
            weightT0Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorWeight(tokenz, (Arc)this.element, 0);
            });
            this.components.add(weightT0Spinner);
            JLabel weight3Label = new JLabel("W3 (yellow):", 2);
            weight3Label.setBounds(columnB_posX + 10, columnB_Y, 80, 20);
            this.components.add(weight3Label);
            SpinnerNumberModel weightT3SpinnerModel = new SpinnerNumberModel(arc.getColorWeight(3), 0, Integer.MAX_VALUE, 1);
            JSpinner weightT3Spinner = new JSpinner(weightT3SpinnerModel);
            weightT3Spinner.setBounds(columnB_posX + 90, columnB_Y, 65, 20);
            weightT3Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorWeight(tokenz, (Arc)this.element, 3);
            });
            this.components.add(weightT3Spinner);
            JLabel weight1Label = new JLabel("W1 (green):", 2);
            weight1Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
            this.components.add(weight1Label);
            SpinnerNumberModel weightT1SpinnerModel = new SpinnerNumberModel(arc.getColorWeight(1), 0, Integer.MAX_VALUE, 1);
            JSpinner weightT1Spinner = new JSpinner(weightT1SpinnerModel);
            weightT1Spinner.setBounds(columnB_posX - 60, columnB_Y += 20, 65, 20);
            weightT1Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorWeight(tokenz, (Arc)this.element, 1);
            });
            this.components.add(weightT1Spinner);
            JLabel weight4Label = new JLabel("W4 (gray):", 2);
            weight4Label.setBounds(columnB_posX + 10, columnB_Y, 80, 20);
            this.components.add(weight4Label);
            SpinnerNumberModel weightT4SpinnerModel = new SpinnerNumberModel(arc.getColorWeight(4), 0, Integer.MAX_VALUE, 1);
            JSpinner weightT4Spinner = new JSpinner(weightT4SpinnerModel);
            weightT4Spinner.setBounds(columnB_posX + 90, columnB_Y, 65, 20);
            weightT4Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorWeight(tokenz, (Arc)this.element, 4);
            });
            this.components.add(weightT4Spinner);
            JLabel weight2Label = new JLabel("W2 (blue):", 2);
            weight2Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
            this.components.add(weight2Label);
            SpinnerNumberModel weightT2SpinnerModel = new SpinnerNumberModel(arc.getColorWeight(2), 0, Integer.MAX_VALUE, 1);
            JSpinner weightT2Spinner = new JSpinner(weightT2SpinnerModel);
            weightT2Spinner.setBounds(columnB_posX - 60, columnB_Y += 20, 65, 20);
            weightT2Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorWeight(tokenz, (Arc)this.element, 2);
            });
            this.components.add(weightT2Spinner);
            JLabel weight5Label = new JLabel("W5 (black):", 2);
            weight5Label.setBounds(columnB_posX + 10, columnB_Y, 80, 20);
            this.components.add(weight5Label);
            SpinnerNumberModel weightT5SpinnerModel = new SpinnerNumberModel(arc.getColorWeight(5), 0, Integer.MAX_VALUE, 1);
            JSpinner weightT5Spinner = new JSpinner(weightT5SpinnerModel);
            weightT5Spinner.setBounds(columnB_posX + 90, columnB_Y, 65, 20);
            weightT5Spinner.addChangeListener(e -> {
                int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                this.setColorWeight(tokenz, (Arc)this.element, 5);
            });
            this.components.add(weightT5Spinner);
            if (this.pairedArc != null) {
                JLabel weightPair2Label = new JLabel(type2, 2);
                weightPair2Label.setBounds(columnA_posX, columnA_Y += 20, 260, 20);
                columnB_Y += 20;
                this.components.add(weightPair2Label);
                JLabel weightp0Label = new JLabel("W0 (red):", 2);
                weightp0Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
                this.components.add(weightp0Label);
                SpinnerNumberModel weightTp0SpinnerModel = new SpinnerNumberModel(this.pairedArc.getColorWeight(0), 0, Integer.MAX_VALUE, 1);
                JSpinner weightTp0Spinner = new JSpinner(weightTp0SpinnerModel);
                weightTp0Spinner.setBounds(columnB_posX - 60, columnB_Y += 20, 65, 20);
                weightTp0Spinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setColorWeight(tokenz, this.pairedArc, 0);
                });
                this.components.add(weightTp0Spinner);
                JLabel weightp3Label = new JLabel("W3 (yellow):", 2);
                weightp3Label.setBounds(columnB_posX + 10, columnB_Y, 80, 20);
                this.components.add(weightp3Label);
                SpinnerNumberModel weightTp3SpinnerModel = new SpinnerNumberModel(this.pairedArc.getColorWeight(3), 0, Integer.MAX_VALUE, 1);
                JSpinner weightTp3Spinner = new JSpinner(weightTp3SpinnerModel);
                weightTp3Spinner.setBounds(columnB_posX + 90, columnB_Y, 65, 20);
                weightTp3Spinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setColorWeight(tokenz, this.pairedArc, 3);
                });
                this.components.add(weightTp3Spinner);
                JLabel weightp1Label = new JLabel("W1 (green):", 2);
                weightp1Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
                this.components.add(weightp1Label);
                SpinnerNumberModel weightTp1SpinnerModel = new SpinnerNumberModel(this.pairedArc.getColorWeight(1), 0, Integer.MAX_VALUE, 1);
                JSpinner weightTp1Spinner = new JSpinner(weightTp1SpinnerModel);
                weightTp1Spinner.setBounds(columnB_posX - 60, columnB_Y += 20, 65, 20);
                weightTp1Spinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setColorWeight(tokenz, this.pairedArc, 1);
                });
                this.components.add(weightTp1Spinner);
                JLabel weightp4Label = new JLabel("W4 (gray):", 2);
                weightp4Label.setBounds(columnB_posX + 10, columnB_Y, 80, 20);
                this.components.add(weightp4Label);
                SpinnerNumberModel weightTp4SpinnerModel = new SpinnerNumberModel(this.pairedArc.getColorWeight(4), 0, Integer.MAX_VALUE, 1);
                JSpinner weightTp4Spinner = new JSpinner(weightTp4SpinnerModel);
                weightTp4Spinner.setBounds(columnB_posX + 90, columnB_Y, 65, 20);
                weightTp4Spinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setColorWeight(tokenz, this.pairedArc, 4);
                });
                this.components.add(weightTp4Spinner);
                JLabel weightp2Label = new JLabel("W2 (blue):", 2);
                weightp2Label.setBounds(columnA_posX, columnA_Y += 20, 80, 20);
                this.components.add(weightp2Label);
                SpinnerNumberModel weightTp2SpinnerModel = new SpinnerNumberModel(this.pairedArc.getColorWeight(2), 0, Integer.MAX_VALUE, 1);
                JSpinner weightTp2Spinner = new JSpinner(weightTp2SpinnerModel);
                weightTp2Spinner.setBounds(columnB_posX - 60, columnB_Y += 20, 65, 20);
                weightTp2Spinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setColorWeight(tokenz, this.pairedArc, 2);
                });
                this.components.add(weightTp2Spinner);
                JLabel weightp5Label = new JLabel("W5 (black):", 2);
                weightp5Label.setBounds(columnB_posX + 10, columnB_Y, 80, 20);
                this.components.add(weightp5Label);
                SpinnerNumberModel weightTp5SpinnerModel = new SpinnerNumberModel(this.pairedArc.getColorWeight(5), 0, Integer.MAX_VALUE, 1);
                JSpinner weightTp5Spinner = new JSpinner(weightTp5SpinnerModel);
                weightTp5Spinner.setBounds(columnB_posX + 90, columnB_Y, 65, 20);
                weightTp5Spinner.addChangeListener(e -> {
                    int tokenz = (Integer)((JSpinner)e.getSource()).getValue();
                    this.setColorWeight(tokenz, this.pairedArc, 5);
                });
                this.components.add(weightTp5Spinner);
            }
        }
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createSheetSubWindow(WorkspaceSheet sheet) {
        int heightOrg;
        int widthOrg;
        int columnA_posX = 10;
        int columnB_posX = 100;
        int columnA_Y = 0;
        int columnB_Y = 0;
        int colACompLength = 70;
        int colBCompLength = 200;
        this.initiateContainers();
        this.mode = 3;
        this.currentSheet = sheet;
        JLabel projectTypeLabel = new JLabel("Project type:", 2);
        projectTypeLabel.setBounds(columnA_posX, columnA_Y += 10, 80, 20);
        this.components.add(projectTypeLabel);
        this.projectTypeLabelText = new JLabel("Petri net (normal)", 2);
        this.projectTypeLabelText.setBounds(columnB_posX, columnB_Y += 10, 200, 20);
        this.projectTypeLabelText.setText("" + GUIController.access().getCurrentNetType());
        this.components.add(this.projectTypeLabelText);
        JLabel netNameLabel = new JLabel("PN Name:", 2);
        netNameLabel.setBounds(columnA_posX, columnA_Y += 30, colACompLength, 20);
        this.components.add(netNameLabel);
        JFormattedTextField netNameField = new JFormattedTextField();
        netNameField.setBounds(columnB_posX, columnB_Y += 30, colBCompLength, 20);
        netNameField.setText(this.overlord.getWorkspace().getProject().getName());
        netNameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            String newName = field.getText();
            this.overlord.getWorkspace().getProject().setName(newName);
        });
        this.components.add(netNameField);
        JLabel idLabel = new JLabel("ID:", 2);
        idLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(idLabel);
        String text = "" + sheet.getId();
        int shPos = this.overlord.getWorkspace().getIndexOfId(sheet.getId());
        text = text + " (sheet position: " + shPos + ")";
        JLabel idLabel2 = new JLabel(text);
        idLabel2.setBounds(columnB_posX, columnB_Y += 20, colACompLength + 150, 20);
        this.components.add(idLabel2);
        int zoom = sheet.getGraphPanel().getZoom();
        Dimension x = sheet.getGraphPanel().getOriginSize();
        if (x != null) {
            widthOrg = (int)x.getWidth();
            heightOrg = (int)x.getHeight();
        } else {
            widthOrg = sheet.getGraphPanel().getSize().width;
            heightOrg = sheet.getGraphPanel().getSize().height;
        }
        JLabel zoomLabel1 = new JLabel("Zoom:", 2);
        zoomLabel1.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(zoomLabel1);
        JLabel zoomLabel2 = new JLabel(zoom + "%");
        zoomLabel2.setBounds(columnB_posX, columnB_Y += 20, colACompLength, 20);
        if (zoom != 100) {
            zoomLabel2.setForeground(Color.red);
        }
        this.components.add(zoomLabel2);
        JLabel widthLabel = new JLabel("Width:", 2);
        widthLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(widthLabel);
        SpinnerNumberModel widthSpinnerModel = new SpinnerNumberModel(sheet.getGraphPanel().getSize().width, 0, Integer.MAX_VALUE, 1);
        JSpinner widthSpinner = new JSpinner(widthSpinnerModel);
        widthSpinner.setBounds(columnB_posX, columnB_Y += 20, colBCompLength / 2, 20);
        widthSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int width = (Integer)spinner.getValue();
            this.setSheetWidth(width);
        });
        this.components.add(widthSpinner);
        JLabel widthLabel2 = new JLabel(Integer.toString(widthOrg), 2);
        widthLabel2.setBounds(columnB_posX + 110, columnA_Y, colACompLength, 20);
        this.components.add(widthLabel2);
        JLabel widthLabel3 = new JLabel("(orig.)", 2);
        widthLabel3.setBounds(columnB_posX + 150, columnA_Y, colACompLength, 20);
        this.components.add(widthLabel3);
        JLabel heightLabel = new JLabel("Height:", 2);
        heightLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(heightLabel);
        SpinnerNumberModel heightSpinnerModel = new SpinnerNumberModel(sheet.getGraphPanel().getSize().height, 0, Integer.MAX_VALUE, 1);
        JSpinner heightSpinner = new JSpinner(heightSpinnerModel);
        heightSpinner.setBounds(columnB_posX, columnB_Y += 20, colBCompLength / 2, 20);
        heightSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int height = (Integer)spinner.getValue();
            this.setSheetHeight(height);
        });
        this.components.add(heightSpinner);
        if (zoom != 100) {
            widthSpinner.setEnabled(false);
            heightSpinner.setEnabled(false);
        }
        JLabel heightLabel2 = new JLabel(Integer.toString(heightOrg), 2);
        heightLabel2.setBounds(columnB_posX + 110, columnB_Y, colACompLength, 20);
        this.components.add(heightLabel2);
        JLabel heightLabel3 = new JLabel("(orig.)", 2);
        heightLabel3.setBounds(columnB_posX + 150, columnB_Y, colACompLength, 20);
        this.components.add(heightLabel3);
        JLabel autoSrclLabel = new JLabel("Autoscroll:", 2);
        autoSrclLabel.setBounds(columnA_posX, columnA_Y += 20, colACompLength, 20);
        this.components.add(autoSrclLabel);
        JCheckBox autoscrollBox = new JCheckBox("", sheet.getGraphPanel().isAutoDragScroll());
        autoscrollBox.setBounds(columnB_posX - 4, columnB_Y, colACompLength, 20);
        autoscrollBox.setLocation(columnB_posX - 4, columnB_Y += 20);
        autoscrollBox.setSelected(false);
        autoscrollBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.setAutoscroll(box.isSelected());
        });
        this.components.add(autoscrollBox);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.add(this.panel);
    }

    private void createT_invSubWindow(ArrayList<ArrayList<Integer>> invariantsData) {
        this.doNotUpdate = true;
        if (invariantsData == null || invariantsData.size() == 0) {
            return;
        }
        this.mode = 5;
        this.t_invariantsMatrix = invariantsData;
        this.transitions = this.overlord.getWorkspace().getProject().getTransitions();
        this.places = this.overlord.getWorkspace().getProject().getPlaces();
        this.overlord.reset.setT_invariantsStatus(true);
        int colA_posX = 10;
        int colB_posX = 100;
        int positionY = 10;
        this.initiateContainers();
        JLabel chooseInvLabel = new JLabel("T-invariant: ");
        chooseInvLabel.setBounds(colA_posX, positionY, 80, 20);
        this.components.add(chooseInvLabel);
        String[] invariantHeaders = new String[this.t_invariantsMatrix.size() + 3];
        invariantHeaders[0] = "---";
        for (int i = 0; i < this.t_invariantsMatrix.size(); ++i) {
            int invSize = InvariantsTools.getSupport(this.t_invariantsMatrix.get(i)).size();
            invariantHeaders[i + 1] = "Inv. #" + (i + 1) + " (size: " + invSize + ")";
        }
        invariantHeaders[invariantHeaders.length - 2] = "null transitions";
        invariantHeaders[invariantHeaders.length - 1] = "inv/trans frequency";
        this.chooseInvBox = new JComboBox<String>(invariantHeaders);
        this.chooseInvBox.setBounds(colB_posX, positionY, 150, 20);
        this.chooseInvBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int items = comboBox.getItemCount();
            if (comboBox.getSelectedIndex() == 0) {
                this.selectedT_invIndex = -1;
                this.showT_invariant();
            } else if (comboBox.getSelectedIndex() == items - 2) {
                this.selectedT_invIndex = -1;
                this.showDeadT_inv();
            } else if (comboBox.getSelectedIndex() == items - 1) {
                this.selectedT_invIndex = -1;
                this.showT_invTransFrequency();
            } else {
                this.selectedT_invIndex = comboBox.getSelectedIndex() - 1;
                this.showT_invariant();
            }
        });
        this.components.add(this.chooseInvBox);
        JButton prevButton = new JButton("Previous");
        prevButton.setBounds(colB_posX - 50, positionY += 25, 100, 20);
        prevButton.setMargin(new Insets(0, 0, 0, 0));
        prevButton.setIcon(Tools.getResIcon16("/icons/invViewer/prevIcon.png"));
        prevButton.setToolTipText("Show previous invariant data.");
        prevButton.addActionListener(actionEvent -> {
            int sel = this.chooseInvBox.getSelectedIndex();
            if (sel > 0) {
                this.chooseInvBox.setSelectedIndex(sel - 1);
            }
        });
        this.components.add(prevButton);
        JButton nextButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Next&nbsp;</html>");
        nextButton.setBounds(colB_posX + 55, positionY, 100, 20);
        nextButton.setMargin(new Insets(0, 0, 0, 0));
        nextButton.setIcon(Tools.getResIcon16("/icons/invViewer/nextIcon.png"));
        nextButton.setToolTipText("Show next invariant data.");
        nextButton.addActionListener(actionEvent -> {
            int max;
            int sel = this.chooseInvBox.getSelectedIndex();
            if (sel < (max = this.chooseInvBox.getItemCount()) - 1) {
                this.chooseInvBox.setSelectedIndex(sel + 1);
            }
        });
        this.components.add(nextButton);
        JButton recalculateTypesButton = new JButton("Refresh");
        recalculateTypesButton.setBounds(colA_posX, positionY += 25, 100, 20);
        recalculateTypesButton.setToolTipText("If t-inv types have been determined, this button will refresh the content of the three comboboxes below:");
        recalculateTypesButton.addActionListener(actionEvent -> this.refreshSubSurCombos());
        this.components.add(recalculateTypesButton);
        JButton recalculateInvTypesButton = new JButton("Recalculate");
        recalculateInvTypesButton.setIcon(Tools.getResIcon16("/icons/portal.png"));
        recalculateInvTypesButton.setToolTipText("This will force the program to determine the type of t-invariants (it may take time) and refresh the comboboxes below:");
        recalculateInvTypesButton.setBounds(colA_posX + 105, positionY, 130, 20);
        recalculateInvTypesButton.addActionListener(actionEvent -> {
            try {
                InvariantsCalculator ic = new InvariantsCalculator(true);
                InvariantsTools.analyseInvariantTypes(ic.getCMatrix(), this.t_invariantsMatrix, true);
                this.refreshSubSurCombos();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        });
        this.components.add(recalculateInvTypesButton);
        ArrayList<Integer> typesVector = this.overlord.getWorkspace().getProject().accessT_InvTypesVector();
        ArrayList<Integer> sursInv = new ArrayList<Integer>();
        ArrayList<Integer> subsInv = new ArrayList<Integer>();
        ArrayList<Integer> nonsInv = new ArrayList<Integer>();
        for (int i = 0; i < typesVector.size(); ++i) {
            if (typesVector.get(i) == 1) {
                sursInv.add(i);
            } else if (typesVector.get(i) == -1) {
                subsInv.add(i);
            }
            if (typesVector.get(i) != 11) continue;
            nonsInv.add(i);
        }
        String[] surHeaders = new String[sursInv.size() + 1];
        surHeaders[0] = "---";
        if (sursInv.size() > 0) {
            for (int i = 0; i < sursInv.size(); ++i) {
                int invSize = InvariantsTools.getSupport(this.t_invariantsMatrix.get((Integer)sursInv.get(i))).size();
                surHeaders[i + 1] = "Inv. #" + ((Integer)sursInv.get(i) + 1) + " (size: " + invSize + ")";
            }
        }
        String[] subHeaders = new String[subsInv.size() + 1];
        subHeaders[0] = "---";
        if (subsInv.size() > 0) {
            for (int i = 0; i < subsInv.size(); ++i) {
                int invSize = InvariantsTools.getSupport(this.t_invariantsMatrix.get((Integer)subsInv.get(i))).size();
                subHeaders[i + 1] = "Inv. #" + ((Integer)subsInv.get(i) + 1) + " (size: " + invSize + ")";
            }
        }
        String[] nonsHeaders = new String[nonsInv.size() + 1];
        nonsHeaders[0] = "---";
        if (nonsInv.size() > 0) {
            for (int i = 0; i < nonsInv.size(); ++i) {
                int invSize = InvariantsTools.getSupport(this.t_invariantsMatrix.get((Integer)nonsInv.get(i))).size();
                nonsHeaders[i + 1] = "Inv. #" + ((Integer)nonsInv.get(i) + 1) + " (size: " + invSize + ")";
            }
        }
        JLabel surLabel1 = new JLabel("Sur-inv: ");
        surLabel1.setBounds(colA_posX, positionY += 25, 80, 20);
        this.components.add(surLabel1);
        this.chooseSurInvBox = new JComboBox<String>(surHeaders);
        this.chooseSurInvBox.setBounds(colB_posX, positionY, 150, 20);
        this.chooseSurInvBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            if (comboBox.getSelectedIndex() == 0) {
                this.selectedT_invIndex = -1;
                this.showT_invariant();
            } else {
                try {
                    String txt = (String)comboBox.getSelectedItem();
                    txt = Objects.requireNonNull(txt).substring(txt.indexOf("#") + 1);
                    txt = txt.substring(0, txt.indexOf(" "));
                    int index = Integer.parseInt(txt);
                    this.selectedT_invIndex = index - 1;
                    this.showT_invariant();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        this.components.add(this.chooseSurInvBox);
        JLabel subLabel1 = new JLabel("Sub-inv: ");
        subLabel1.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(subLabel1);
        this.chooseSubInvBox = new JComboBox<String>(subHeaders);
        this.chooseSubInvBox.setBounds(colB_posX, positionY, 150, 20);
        this.chooseSubInvBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            if (comboBox.getSelectedIndex() == 0) {
                this.selectedT_invIndex = -1;
                this.showT_invariant();
            } else {
                try {
                    String txt = (String)comboBox.getSelectedItem();
                    txt = Objects.requireNonNull(txt).substring(txt.indexOf("#") + 1);
                    txt = txt.substring(0, txt.indexOf(" "));
                    int index = Integer.parseInt(txt);
                    this.selectedT_invIndex = index - 1;
                    this.showT_invariant();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        this.components.add(this.chooseSubInvBox);
        JLabel noneLabel1 = new JLabel("None-inv: ");
        noneLabel1.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(noneLabel1);
        this.chooseNoneInvBox = new JComboBox<String>(subHeaders);
        this.chooseNoneInvBox.setBounds(colB_posX, positionY, 150, 20);
        this.chooseNoneInvBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            if (comboBox.getSelectedIndex() == 0) {
                this.selectedT_invIndex = -1;
                this.showT_invariant();
            } else {
                try {
                    String txt = (String)comboBox.getSelectedItem();
                    txt = Objects.requireNonNull(txt).substring(txt.indexOf("#") + 1);
                    txt = txt.substring(0, txt.indexOf(" "));
                    int index = Integer.parseInt(txt);
                    this.selectedT_invIndex = index - 1;
                    this.showT_invariant();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        this.components.add(this.chooseNoneInvBox);
        JButton showDetailsButton = new JButton();
        showDetailsButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show<br>&nbsp;&nbsp;&nbsp;&nbsp;details</html>");
        showDetailsButton.setIcon(Tools.getResIcon32("/icons/menu/menu_invViewer.png"));
        showDetailsButton.setBounds(colA_posX, positionY += 30, 120, 32);
        showDetailsButton.addActionListener(actionEvent -> {
            if (this.selectedT_invIndex == -1) {
                return;
            }
            new HolmesInvariantsViewer(this.selectedT_invIndex);
        });
        this.components.add(showDetailsButton);
        JCheckBox markMCTcheckBox = new JCheckBox("Color MCT");
        markMCTcheckBox.setBounds(colA_posX + 130, positionY - 5, 120, 20);
        markMCTcheckBox.setSelected(false);
        markMCTcheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.markMCT = abstractButton.getModel().isSelected();
            this.showT_invariant();
        });
        this.components.add(markMCTcheckBox);
        JCheckBox glowINVcheckBox = new JCheckBox("Transitions glow");
        glowINVcheckBox.setBounds(colA_posX + 130, positionY + 15, 120, 20);
        glowINVcheckBox.setSelected(true);
        glowINVcheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.glowT_inv = abstractButton.getModel().isSelected();
            this.showT_invariant();
        });
        this.components.add(glowINVcheckBox);
        this.t_invNameField = new JTextArea();
        this.t_invNameField.setLineWrap(true);
        this.t_invNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    HolmesDockWindowsTable.this.changeT_invName(field.getText());
                }
            }
        });
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.add((Component)new JScrollPane(this.t_invNameField), "Center");
        descPanel.setBounds(colA_posX, positionY += 40, 250, 80);
        this.components.add(descPanel);
        JCheckBox markAreaCheckBox = new JCheckBox("Invariant-net structure painted");
        markAreaCheckBox.setBounds(colA_posX, positionY += 85, 200, 20);
        markAreaCheckBox.setSelected(true);
        markAreaCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.invStructure = abstractButton.getModel().isSelected();
            this.showT_invariant();
        });
        this.components.add(markAreaCheckBox);
        JLabel labelTime1 = new JLabel("Min. time: ");
        labelTime1.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(labelTime1);
        this.minTimeLabel = new JLabel("---");
        this.minTimeLabel.setBounds(colB_posX, positionY, 80, 20);
        this.components.add(this.minTimeLabel);
        JLabel labelTime2 = new JLabel("Avg. time: ");
        labelTime2.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(labelTime2);
        this.avgTimeLabel = new JLabel("---");
        this.avgTimeLabel.setBounds(colB_posX, positionY, 80, 20);
        this.components.add(this.avgTimeLabel);
        JLabel labelTime3 = new JLabel("Max. time: ");
        labelTime3.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(labelTime3);
        this.maxTimeLabel = new JLabel("---");
        this.maxTimeLabel.setBounds(colB_posX, positionY, 80, 20);
        this.components.add(this.maxTimeLabel);
        JLabel labelTime4 = new JLabel("Structure:");
        labelTime4.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(labelTime4);
        this.structureLabel = new JLabel("---");
        this.structureLabel.setBounds(colB_posX, positionY, 200, 20);
        this.components.add(this.structureLabel);
        this.doNotUpdate = false;
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    public void refreshSubSurCombos() {
        ArrayList<Integer> typesVector = this.overlord.getWorkspace().getProject().accessT_InvTypesVector();
        ArrayList<Integer> sursInv = new ArrayList<Integer>();
        ArrayList<Integer> subsInv = new ArrayList<Integer>();
        ArrayList<Integer> nonsInv = new ArrayList<Integer>();
        for (int i = 0; i < typesVector.size(); ++i) {
            if (typesVector.get(i) == 1) {
                sursInv.add(i);
            } else if (typesVector.get(i) == -1) {
                subsInv.add(i);
            }
            if (typesVector.get(i) != 11) continue;
            nonsInv.add(i);
        }
        String[] surHeaders = new String[sursInv.size() + 1];
        surHeaders[0] = "---";
        if (sursInv.size() > 0) {
            for (int i = 0; i < sursInv.size(); ++i) {
                int invSize = InvariantsTools.getSupport(this.t_invariantsMatrix.get((Integer)sursInv.get(i))).size();
                surHeaders[i + 1] = "Inv. #" + ((Integer)sursInv.get(i) + 1) + " (size: " + invSize + ")";
            }
        }
        String[] subHeaders = new String[subsInv.size() + 1];
        subHeaders[0] = "---";
        if (subsInv.size() > 0) {
            for (int i = 0; i < subsInv.size(); ++i) {
                int invSize = InvariantsTools.getSupport(this.t_invariantsMatrix.get((Integer)subsInv.get(i))).size();
                subHeaders[i + 1] = "Inv. #" + ((Integer)subsInv.get(i) + 1) + " (size: " + invSize + ")";
            }
        }
        String[] nonsHeaders = new String[nonsInv.size() + 1];
        nonsHeaders[0] = "---";
        if (nonsInv.size() > 0) {
            for (int i = 0; i < nonsInv.size(); ++i) {
                int invSize = InvariantsTools.getSupport(this.t_invariantsMatrix.get((Integer)nonsInv.get(i))).size();
                nonsHeaders[i + 1] = "Inv. #" + ((Integer)nonsInv.get(i) + 1) + " (size: " + invSize + ")";
            }
        }
        this.chooseSurInvBox.setModel(new DefaultComboBoxModel<String>(surHeaders));
        this.chooseSubInvBox.setModel(new DefaultComboBoxModel<String>(subHeaders));
        this.chooseNoneInvBox.setModel(new DefaultComboBoxModel<String>(nonsHeaders));
    }

    private void changeT_invName(String newName) {
        if (this.selectedT_invIndex == -1) {
            return;
        }
        this.overlord.getWorkspace().getProject().accessT_InvDescriptions().set(this.selectedT_invIndex, newName);
    }

    private void showT_invariant() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (this.selectedT_invIndex != -1) {
            ArrayList<Integer> invariant = this.t_invariantsMatrix.get(this.selectedT_invIndex);
            if (this.transitions.size() != invariant.size()) {
                this.transitions = this.overlord.getWorkspace().getProject().getTransitions();
                if (this.transitions == null || this.transitions.size() != invariant.size()) {
                    this.overlord.log("Critical error in t-invariants subwindow. T-invariants size differ from transition set cardinality!", "error", true);
                    return;
                }
            }
            ArrayList<Integer> transMCTvector = this.overlord.getWorkspace().getProject().getMCTtransIndicesVector();
            ArrayList<Transition> invTransitions = new ArrayList<Transition>();
            ColorPalette cp = new ColorPalette();
            for (int t = 0; t < invariant.size(); ++t) {
                int fireValue = invariant.get(t);
                Transition trans = this.transitions.get(t);
                if (fireValue == 0) {
                    trans.qSimBoxT.qSimDrawed = false;
                    trans.qSimArcSign = false;
                    continue;
                }
                invTransitions.add(trans);
                if (this.markMCT) {
                    int mctNo = transMCTvector.get(t);
                    if (mctNo == -1) {
                        trans.drawGraphBoxT.setGlowedINV(this.glowT_inv, fireValue);
                    } else {
                        trans.drawGraphBoxT.setColorWithNumber(true, cp.getColor(mctNo), false, fireValue, true, "[MCT" + (mctNo + 1) + "]");
                        trans.drawGraphBoxT.setGlowedINV(false, fireValue);
                    }
                } else {
                    trans.drawGraphBoxT.setGlowedINV(this.glowT_inv, fireValue);
                }
                if (!this.invStructure) continue;
                trans.qSimBoxT.qSimDrawed = true;
                trans.qSimArcSign = true;
                trans.qSimBoxT.qSimFillColor = new Color(0, 102, 0);
                for (ElementLocation el : trans.getElementLocations()) {
                    el.qSimArcSign = true;
                }
            }
            if (this.invStructure) {
                for (Place place : this.places) {
                    for (ElementLocation el : place.getElementLocations()) {
                        boolean inFound = false;
                        for (Arc inArc : el.getInArcs()) {
                            if (!((Transition)inArc.getStartNode()).qSimBoxT.qSimDrawed) continue;
                            inFound = true;
                            break;
                        }
                        if (!inFound) continue;
                        block5: for (ElementLocation el2 : place.getElementLocations()) {
                            for (Arc outArc : el2.getOutArcs()) {
                                if (!((Transition)outArc.getEndNode()).qSimBoxT.qSimDrawed) continue;
                                el2.qSimArcSign = true;
                                el2.qSimDrawed = true;
                                el.qSimArcSign = true;
                                el.qSimDrawed = true;
                                place.qSimBoxP.qSimFillColor = new Color(0, 102, 0);
                                place.qSimBoxP.qSimDrawed = true;
                                place.qSimBoxP.qSimTokens = 0.0;
                                place.qSimBoxP.qSimOvalColor = new Color(0, 102, 0);
                                place.qSimBoxP.qSimOvalSize = 0;
                                continue block5;
                            }
                        }
                    }
                }
                for (Arc arc : pn.getArcs()) {
                    if (!arc.getStartLocation().qSimArcSign || !arc.getEndLocation().qSimArcSign) continue;
                    arc.arcQSimBox.qSimForcedArc = true;
                    arc.arcQSimBox.qSimForcedColor = new Color(0, 102, 0);
                }
            }
            String name = this.overlord.getWorkspace().getProject().accessT_InvDescriptions().get(this.selectedT_invIndex);
            this.t_invNameField.setText(name);
            ArrayList<Double> timeVector = TimeComputations.getT_InvTimeValues(invariant, this.transitions);
            if (timeVector != null) {
                this.minTimeLabel.setText(String.format("%.2f", timeVector.get(0) + timeVector.get(3)));
                this.avgTimeLabel.setText(String.format("%.2f", timeVector.get(2) + timeVector.get(3)));
                this.maxTimeLabel.setText(String.format("%.2f", timeVector.get(1) + timeVector.get(3)));
                Object structText = "";
                if (timeVector.get(5) > 0.0) {
                    structText = (String)structText + timeVector.get(5).intValue() + "xTPN; ";
                }
                if (timeVector.get(6) > 0.0) {
                    structText = (String)structText + timeVector.get(6).intValue() + "xDPN; ";
                }
                if (timeVector.get(7) > 0.0) {
                    structText = (String)structText + timeVector.get(7).intValue() + "xTDPN; ";
                }
                if (timeVector.get(4) > 0.0) {
                    structText = (String)structText + timeVector.get(4).intValue() + "xPN; ";
                }
                this.structureLabel.setText((String)structText);
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void showT_invTransFrequency() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        ArrayList<Integer> freqVector = InvariantsTools.getFrequencyRealInvariants(this.t_invariantsMatrix, false);
        ArrayList<Transition> transitions_tmp = this.overlord.getWorkspace().getProject().getTransitions();
        int max_freq = freqVector.stream().mapToInt(v -> v).max().orElseThrow(NoSuchElementException::new);
        if (freqVector == null) {
            JOptionPane.showMessageDialog(null, "T-invariants data unavailable.", "No t-invariants", 1);
        } else {
            for (int i = 0; i < freqVector.size(); ++i) {
                Transition realT = transitions_tmp.get(i);
                if (freqVector.get(i) != 0) {
                    double fr = (double)freqVector.get(i).intValue() / (double)max_freq;
                    realT.drawGraphBoxT.setColorWithNumber(true, HolmesDockWindowsTable.getDiscColor(fr), true, freqVector.get(i).intValue(), false, "");
                    System.out.println(realT.getName() + " trans \t" + realT.getID() + " \t " + fr + " \t " + freqVector.get(i));
                    continue;
                }
                realT.drawGraphBoxT.setColorWithNumber(true, Color.gray, true, 0.0, false, "");
                System.out.println(realT.getName() + " trans \t" + realT.getID() + " \t 0 \t 0");
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    public static Color getDiscColor(double fr) {
        if (fr == 1.0) {
            return new Color(87, 187, 138, 255);
        }
        if (fr > 0.9) {
            return new Color(104, 194, 150, 255);
        }
        if (fr > 0.8) {
            return new Color(121, 201, 162, 255);
        }
        if (fr > 0.7) {
            return new Color(138, 208, 174, 255);
        }
        if (fr > 0.6) {
            return new Color(55, 215, 185, 255);
        }
        if (fr > 0.5) {
            return new Color(171, 221, 197, 255);
        }
        if (fr > 0.4) {
            return new Color(171, 221, 197, 255);
        }
        if (fr > 0.3) {
            return new Color(205, 235, 220, 255);
        }
        if (fr > 0.2) {
            return new Color(222, 242, 232, 255);
        }
        if (fr > 0.1) {
            return new Color(222, 242, 232, 255);
        }
        return Color.white;
    }

    public static int[] getRGB(int gray) {
        double[] WEIGHTS = new double[]{0.2989, 0.587, 0.114};
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = (int)((double)gray / WEIGHTS[i]);
            if (rgb[i] < 256) {
                return rgb;
            }
            rgb[i] = 255;
            gray -= (int)(255.0 * WEIGHTS[i]);
        }
        return rgb;
    }

    private void showDeadT_inv() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        HolmesNotepad note = new HolmesNotepad(640, 480);
        note.addTextLineNL("Transitions not covered by t-invariants:", "text");
        ArrayList<Integer> deadTrans = InvariantsTools.detectUncovered(this.t_invariantsMatrix, true);
        ArrayList<Transition> transitions_tmp = this.overlord.getWorkspace().getProject().getTransitions();
        int counter = 0;
        if (deadTrans == null) {
            JOptionPane.showMessageDialog(null, "T-invariants data unavailable.", "No t-invariants", 1);
        } else {
            for (int deadOne : deadTrans) {
                Transition realT = transitions_tmp.get(deadOne);
                String t1 = Tools.setToSize("t" + deadOne, 5, false);
                note.addTextLineNL(t1 + " | " + realT.getName(), "text");
                realT.drawGraphBoxT.setGlowedINV(true, 0);
                ++counter;
            }
        }
        if (counter > 0) {
            note.setCaretFirstLine();
            note.setVisible(true);
        } else {
            note.dispose();
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void createP_invSubWindow(ArrayList<ArrayList<Integer>> pInvData) {
        this.doNotUpdate = true;
        if (pInvData == null || pInvData.size() == 0) {
            return;
        }
        this.mode = 8;
        this.p_invariantsMatrix = pInvData;
        this.places = this.overlord.getWorkspace().getProject().getPlaces();
        this.overlord.reset.setP_invariantsStatus(true);
        int colA_posX = 10;
        int colB_posX = 100;
        int positionY = 10;
        this.initiateContainers();
        JLabel chooseInvLabel = new JLabel("P-invariant: ");
        chooseInvLabel.setBounds(colA_posX, positionY, 80, 20);
        this.components.add(chooseInvLabel);
        String[] invariantHeaders = new String[this.p_invariantsMatrix.size() + 3];
        invariantHeaders[0] = "---";
        for (int i = 0; i < this.p_invariantsMatrix.size(); ++i) {
            int invSize = InvariantsTools.getSupport(this.p_invariantsMatrix.get(i)).size();
            invariantHeaders[i + 1] = "Inv. #" + (i + 1) + " (size: " + invSize + ")";
        }
        invariantHeaders[invariantHeaders.length - 2] = "null places";
        invariantHeaders[invariantHeaders.length - 1] = "inv/places frequency";
        JComboBox<String> chooseInvBox = new JComboBox<String>(invariantHeaders);
        chooseInvBox.setBounds(colB_posX, positionY, 150, 20);
        chooseInvBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int items = comboBox.getItemCount();
            if (comboBox.getSelectedIndex() == 0) {
                this.selectedP_invIndex = -1;
                this.showP_invariant();
            } else if (comboBox.getSelectedIndex() == items - 2) {
                this.selectedP_invIndex = -1;
                this.showDeadP_inv();
            } else if (comboBox.getSelectedIndex() == items - 1) {
                this.selectedP_invIndex = -1;
                this.showP_invTransFrequency();
            } else {
                this.selectedP_invIndex = comboBox.getSelectedIndex() - 1;
                this.showP_invariant();
            }
        });
        this.components.add(chooseInvBox);
        JButton showDetailsButton = new JButton();
        showDetailsButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show<br>&nbsp;&nbsp;&nbsp;&nbsp;details</html>");
        showDetailsButton.setIcon(Tools.getResIcon32("/icons/menu/menu_invViewer.png"));
        showDetailsButton.setBounds(colA_posX, positionY += 30, 120, 32);
        showDetailsButton.addActionListener(actionEvent -> {
            if (this.selectedP_invIndex == -1) {
                return;
            }
            try {
                new HolmesInvariantsViewer(this.selectedT_invIndex);
            }
            catch (Exception ex) {
                this.overlord.log("Error (468456017) : probably not implemented features for p-invariants in the t-invariants code window. Exception: " + ex.getMessage(), "error", true);
            }
        });
        this.components.add(showDetailsButton);
        this.p_invNameField = new JTextArea();
        this.p_invNameField.setLineWrap(true);
        this.p_invNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    HolmesDockWindowsTable.this.changeP_invName(field.getText());
                }
            }
        });
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.add((Component)new JScrollPane(this.p_invNameField), "Center");
        descPanel.setBounds(colA_posX, positionY += 40, 250, 80);
        this.components.add(descPanel);
        this.doNotUpdate = false;
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void changeP_invName(String newName) {
        if (this.selectedT_invIndex == -1) {
            return;
        }
        this.overlord.getWorkspace().getProject().accessP_InvDescriptions().set(this.selectedP_invIndex, newName);
    }

    private void showP_invariant() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (this.selectedP_invIndex != -1) {
            ArrayList<Integer> invariant = this.p_invariantsMatrix.get(this.selectedP_invIndex);
            if (this.places.size() != invariant.size()) {
                this.places = this.overlord.getWorkspace().getProject().getPlaces();
                if (this.places == null || this.places.size() != invariant.size()) {
                    this.overlord.log("Critical error in p-invariants subwindow. P-invariants size differ from transition set cardinality!", "error", true);
                    return;
                }
            }
            for (int p = 0; p < invariant.size(); ++p) {
                int value = invariant.get(p);
                if (value == 0) continue;
                this.places.get((int)p).drawGraphBoxP.setColorWithNumber(true, EditorResources.glowPlaceColorLevelBlue, false, -1.0, false, "");
            }
            String name = this.overlord.getWorkspace().getProject().accessP_InvDescriptions().get(this.selectedP_invIndex);
            this.p_invNameField.setText(name);
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void showP_invTransFrequency() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        ArrayList<Integer> freqVector = InvariantsTools.getFrequency(this.p_invariantsMatrix, false);
        ArrayList<Place> places_tmp = pn.getPlaces();
        if (freqVector == null) {
            JOptionPane.showMessageDialog(null, "P-invariants data unavailable.", "No p-invariants", 1);
        } else {
            for (int i = 0; i < freqVector.size(); ++i) {
                Place realP = places_tmp.get(i);
                if (freqVector.get(i) != 0) {
                    realP.drawGraphBoxP.setColorWithNumber(true, EditorResources.glowPlaceColorLevelBlue, true, freqVector.get(i).intValue(), false, "");
                    continue;
                }
                realP.drawGraphBoxP.setColorWithNumber(true, EditorResources.glowPlaceColorLevelRed, true, 0.0, false, "");
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void showDeadP_inv() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        HolmesNotepad note = new HolmesNotepad(640, 480);
        note.addTextLineNL("Places not covered by p-invariants:", "text");
        ArrayList<Integer> deadPlaces = InvariantsTools.detectUncovered(this.p_invariantsMatrix, false);
        ArrayList<Place> places_tmp = this.overlord.getWorkspace().getProject().getPlaces();
        int counter = 0;
        if (deadPlaces == null) {
            JOptionPane.showMessageDialog(null, "P-invariants data unavailable.", "No p-invariants", 1);
        } else {
            for (int deadOne : deadPlaces) {
                Place realP = places_tmp.get(deadOne);
                String p1 = Tools.setToSize("p" + deadOne, 5, false);
                note.addTextLineNL(p1 + " | " + realP.getName(), "text");
                realP.drawGraphBoxP.setColorWithNumber(true, EditorResources.glowPlaceColorLevelRed, false, -1.0, false, "");
                ++counter;
            }
        }
        if (counter > 0) {
            note.setCaretFirstLine();
            note.setVisible(true);
        } else {
            note.dispose();
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void createMCTSubWindow(ArrayList<ArrayList<Transition>> mct) {
        if (mct == null || mct.size() == 0) {
            return;
        }
        this.mode = 6;
        this.overlord.reset.setMCTStatus(true);
        this.doNotUpdate = true;
        int colA_posX = 10;
        int colB_posX = 100;
        int positionY = 10;
        this.initiateContainers();
        this.mctGroups = mct;
        String[] mctHeaders = new String[this.mctGroups.size() + 2];
        mctHeaders[0] = "---";
        for (int i = 0; i < this.mctGroups.size(); ++i) {
            if (i < this.mctGroups.size() - 1) {
                mctHeaders[i + 1] = "MCT #" + (i + 1) + " (size: " + this.mctGroups.get(i).size() + ")";
                continue;
            }
            mctHeaders[i + 1] = "No-MCT transitions";
            mctHeaders[i + 2] = "Show all";
        }
        JLabel chooseMctLabel = new JLabel("Choose MCT: ");
        chooseMctLabel.setBounds(colA_posX, positionY, 80, 20);
        this.components.add(chooseMctLabel);
        JComboBox<String> chooseMctBox = new JComboBox<String>(mctHeaders);
        chooseMctBox.setBounds(colB_posX, positionY, 150, 20);
        chooseMctBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.selectedMCTindex = -1;
                this.allMCTselected = false;
                this.showMct();
                this.MCTnameField.setText("");
            } else if (selected == comboBox.getItemCount() - 1) {
                this.allMCTselected = true;
                this.showAllColors();
            } else {
                this.selectedMCTindex = selected - 1;
                this.allMCTselected = false;
                this.showMct();
            }
        });
        this.components.add(chooseMctBox);
        JButton showDetailsButton = new JButton();
        showDetailsButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show<br>&nbsp;&nbsp;&nbsp;&nbsp;details</html>");
        showDetailsButton.setIcon(Tools.getResIcon32("/icons/invViewer/showInNotepad.png"));
        showDetailsButton.setBounds(colA_posX, positionY += 30, 120, 32);
        showDetailsButton.addActionListener(actionEvent -> this.showMCTNotepad());
        this.components.add(showDetailsButton);
        JCheckBox glowCheckBox = new JCheckBox("Different colors");
        glowCheckBox.setBounds(colA_posX + 130, positionY - 5, 120, 20);
        glowCheckBox.setSelected(false);
        glowCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.colorMCT = abstractButton.getModel().isSelected();
            if (this.allMCTselected) {
                this.showAllColors();
            } else {
                this.showMct();
            }
        });
        this.components.add(glowCheckBox);
        this.MCTnameField = new JTextArea();
        this.MCTnameField.setLineWrap(true);
        this.MCTnameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    HolmesDockWindowsTable.this.changeMCTname(field.getText());
                }
            }
        });
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.add((Component)new JScrollPane(this.MCTnameField), "Center");
        descPanel.setBounds(colA_posX, positionY += 40, 250, 80);
        this.components.add(descPanel);
        this.doNotUpdate = false;
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void changeMCTname(String newName) {
        if (this.selectedMCTindex == -1) {
            return;
        }
        this.overlord.getWorkspace().getProject().accessMCTnames().set(this.selectedMCTindex, newName);
    }

    private void showMCTNotepad() {
        if (this.selectedMCTindex == -1) {
            return;
        }
        HolmesNotepad note = new HolmesNotepad(800, 600);
        ArrayList<Transition> mct = this.mctGroups.get(this.selectedMCTindex);
        ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
        int size = mct.size();
        if (this.selectedMCTindex == this.mctGroups.size() - 1) {
            note.addTextLineNL("Trivial MCT-transitions (" + size + "):", "text");
        } else {
            note.addTextLineNL("Transitions (" + size + ") of MCT #" + (this.selectedMCTindex + 1), "text");
        }
        for (Transition transition : mct) {
            int globalIndex = transitions.lastIndexOf(transition);
            String t1 = Tools.setToSize("t" + globalIndex, 5, false);
            note.addTextLineNL(t1 + transition.getName(), "text");
        }
        note.setCaretFirstLine();
        note.setVisible(true);
    }

    private void showMct() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (this.selectedMCTindex == -1) {
            return;
        }
        ArrayList<Transition> mct = this.mctGroups.get(this.selectedMCTindex);
        int size = this.mctGroups.size();
        ColorPalette cp = new ColorPalette();
        for (Transition transition : mct) {
            if (!this.colorMCT) {
                transition.drawGraphBoxT.setGlowed_MTC(true);
                continue;
            }
            if (this.selectedMCTindex == size - 1) {
                transition.drawGraphBoxT.setColorWithNumber(true, cp.getColor(this.selectedMCTindex), false, 0.0, true, "[trivial]");
                continue;
            }
            transition.drawGraphBoxT.setColorWithNumber(true, cp.getColor(this.selectedMCTindex), false, 0.0, true, "[MCT" + (this.selectedMCTindex + 1) + "]");
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        String name = this.overlord.getWorkspace().getProject().accessMCTnames().get(this.selectedMCTindex);
        this.MCTnameField.setText(name);
    }

    private void showAllColors() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        ColorPalette cp = new ColorPalette();
        for (int m = 0; m < this.mctGroups.size() - 1; ++m) {
            Color currentColor = cp.getColor();
            ArrayList<Transition> mct = this.mctGroups.get(m);
            for (Transition transition : mct) {
                if (this.overlord.getSettingsManager().getValue("mctNameShow").equals("1")) {
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "MCT #" + (m + 1) + " (" + mct.size() + ")");
                    continue;
                }
                transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "");
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void createClustersSubWindow(ClusterDataPackage clusteringData) {
        this.initiateContainers();
        this.doNotUpdate = true;
        if (clusteringData == null || clusteringData.dataMatrix.size() == 0) {
            return;
        }
        this.mode = 9;
        this.clusterColorsData = clusteringData;
        this.overlord.reset.setClustersStatus(true);
        int colA_posX = 10;
        int colB_posX = 100;
        int positionY = 10;
        this.initiateContainers();
        JLabel label1 = new JLabel("Algorithm: ");
        label1.setBounds(colA_posX, positionY, 80, 20);
        this.components.add(label1);
        JLabel label2 = new JLabel(this.clusterColorsData.algorithm);
        label2.setBounds(colB_posX, positionY, 80, 20);
        this.components.add(label2);
        JLabel label3 = new JLabel("Metric: ");
        label3.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(label3);
        JLabel label4 = new JLabel(this.clusterColorsData.metric);
        label4.setBounds(colB_posX, positionY, 80, 20);
        this.components.add(label4);
        JLabel label5 = new JLabel("Clusters: ");
        label5.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(label5);
        JLabel label6 = new JLabel("" + this.clusterColorsData.clNumber);
        label6.setBounds(colB_posX, positionY, 80, 20);
        this.components.add(label6);
        JLabel chooseInvLabel = new JLabel("Selected: ");
        chooseInvLabel.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(chooseInvLabel);
        String[] clustersHeaders = new String[this.clusterColorsData.dataMatrix.size() + 1];
        clustersHeaders[0] = "---";
        for (int i = 0; i < this.clusterColorsData.dataMatrix.size(); ++i) {
            clustersHeaders[i + 1] = "Cluster " + (i + 1) + " (size: " + this.clusterColorsData.clSize.get(i) + " inv.)";
        }
        this.chooseCluster = new JComboBox<String>(clustersHeaders);
        this.chooseCluster.setBounds(colB_posX, positionY, 180, 20);
        this.chooseCluster.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            if (comboBox.getSelectedIndex() == 0) {
                this.selectedClusterIndex = -1;
                this.showClusters();
                this.fillClustInvCombo();
            } else {
                this.selectedClusterIndex = comboBox.getSelectedIndex() - 1;
                this.showClusters();
                this.fillClustInvCombo();
            }
        });
        this.components.add(this.chooseCluster);
        JLabel mssLabel1 = new JLabel("MSS value:");
        mssLabel1.setBounds(colA_posX, positionY += 20, 80, 20);
        this.components.add(mssLabel1);
        this.mssValueLabel = new JLabel("n/a");
        this.mssValueLabel.setBounds(colB_posX, positionY, 80, 20);
        this.components.add(this.mssValueLabel);
        JCheckBox transFiringMode = new JCheckBox("Show transition average firing");
        transFiringMode.setBounds(colA_posX - 3, positionY += 20, 220, 20);
        transFiringMode.setSelected(false);
        transFiringMode.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.clusterColorsData.showFirings = abstractButton.getModel().isSelected();
            int selected = this.chooseCluster.getSelectedIndex();
            this.chooseCluster.setSelectedIndex(selected);
        });
        this.components.add(transFiringMode);
        JCheckBox scaleMode = new JCheckBox("Show scaled colors");
        scaleMode.setBounds(colA_posX - 3, positionY += 20, 170, 20);
        scaleMode.setSelected(false);
        scaleMode.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.clusterColorsData.showScale = abstractButton.getModel().isSelected();
            int selected = this.chooseCluster.getSelectedIndex();
            this.chooseCluster.setSelectedIndex(selected);
        });
        this.components.add(scaleMode);
        JCheckBox mctMode = new JCheckBox("Show MCT sets");
        mctMode.setBounds(colA_posX - 3, positionY += 20, 120, 20);
        mctMode.setSelected(false);
        mctMode.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.clustersMCT = abstractButton.getModel().isSelected();
            int selected = this.chooseCluster.getSelectedIndex();
            this.chooseCluster.setSelectedIndex(selected);
        });
        this.components.add(mctMode);
        JButton showDetailsButton = new JButton();
        showDetailsButton.setText("<html>&nbsp;Show&nbsp;<br>details</html>");
        showDetailsButton.setIcon(Tools.getResIcon22("/icons/clustWindow/showInfo.png"));
        showDetailsButton.setBounds(colA_posX, positionY += 30, 130, 30);
        showDetailsButton.addActionListener(actionEvent -> this.showClustersNotepad());
        this.components.add(showDetailsButton);
        JButton screenshotsButton = new JButton();
        screenshotsButton.setText("<html>&nbsp;Export&nbsp;<br>pictures</html>");
        screenshotsButton.setIcon(Tools.getResIcon22("/icons/clustWindow/exportPictures.png"));
        screenshotsButton.setBounds(colA_posX + 135, positionY, 130, 30);
        screenshotsButton.addActionListener(actionEvent -> this.dropClustersToFiles());
        this.components.add(screenshotsButton);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(colA_posX + 135, positionY - 5, 130, 35);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder("Completed");
        this.progressBar.setBorder(border);
        this.progressBar.setVisible(false);
        this.progressBar.setForeground(Color.RED);
        this.components.add(this.progressBar);
        JLabel chooseClustInvLabel = new JLabel("Cluster inv.:");
        chooseClustInvLabel.setBounds(colA_posX, positionY += 40, 80, 20);
        this.components.add(chooseClustInvLabel);
        String[] clustersInvHeaders = new String[]{"---"};
        this.chooseClusterInv = new JComboBox<String>(clustersInvHeaders);
        this.chooseClusterInv.setBounds(colB_posX, positionY, 180, 20);
        this.chooseClusterInv.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            if (comboBox.getSelectedIndex() == 0) {
                this.selectedClusterInvIndex = -1;
                this.showClusters();
            } else {
                this.selectedClusterInvIndex = comboBox.getSelectedIndex() - 1;
                this.showClusterInv();
            }
        });
        this.components.add(this.chooseClusterInv);
        JButton showTimeDetailsButton = new JButton();
        showTimeDetailsButton.setText("<html>&nbsp;Time&nbsp;<br>details</html>");
        showTimeDetailsButton.setIcon(Tools.getResIcon22("/icons/clustWindow/showInfo.png"));
        showTimeDetailsButton.setBounds(colA_posX, positionY += 30, 130, 30);
        showTimeDetailsButton.addActionListener(actionEvent -> this.showTimeDataNotepad());
        this.components.add(showTimeDetailsButton);
        JButton showClustersDataButton = new JButton();
        showClustersDataButton.setText("<html>&nbsp;Clusters&nbsp;<br>details</html>");
        showClustersDataButton.setIcon(Tools.getResIcon22("/icons/clustWindow/showInfo.png"));
        showClustersDataButton.setBounds(colA_posX, positionY += 35, 130, 30);
        showClustersDataButton.addActionListener(actionEvent -> this.showClustersData());
        this.components.add(showClustersDataButton);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.doNotUpdate = true;
        this.add(this.panel);
    }

    private void showTimeDataNotepad() {
        Object eftStr;
        Object timeVector;
        if (this.selectedClusterIndex == -1) {
            return;
        }
        PetriNet pn = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        ArrayList<Transition> transitions = pn.getTransitions();
        ArrayList<ArrayList<Integer>> invMatrix = pn.getT_InvMatrix();
        if (invMatrix == null || invMatrix.size() == 0) {
            return;
        }
        ArrayList<Integer> clInvariants = this.clusterColorsData.clustersInvariants.get(this.selectedClusterIndex);
        ArrayList<ArrayList<Integer>> invSubMatrix = new ArrayList<ArrayList<Integer>>();
        for (int i : clInvariants) {
            invSubMatrix.add(invMatrix.get(i));
        }
        ArrayList<Double> avgStatsVector = new ArrayList<Double>();
        HolmesNotepad note = new HolmesNotepad(800, 600);
        note.addTextLineNL("", "text");
        note.addTextLineNL("Cluster: " + (this.selectedClusterIndex + 1) + " (" + this.clusterColorsData.clSize.get(this.selectedClusterIndex) + " inv.) alg.: " + this.clusterColorsData.algorithm + " metric: " + this.clusterColorsData.metric, "text");
        note.addTextLineNL("", "text");
        note.addTextLineNL("T-invariants and their time values:", "text");
        note.addTextLineNL(" No.           Min.         Avg.          Max.    PN   TPN  DPN TDPN", "text");
        for (int i = 0; i < invSubMatrix.size(); ++i) {
            ArrayList invariant = (ArrayList)invSubMatrix.get(i);
            timeVector = TimeComputations.getT_InvTimeValues(invariant, transitions);
            avgStatsVector.add((Double)((ArrayList)timeVector).get(2) + (Double)((ArrayList)timeVector).get(3));
            Object line = "";
            eftStr = String.format("%.2f", (Double)((ArrayList)timeVector).get(0) + (Double)((ArrayList)timeVector).get(3));
            String lftStr = String.format("%.2f", (Double)((ArrayList)timeVector).get(1) + (Double)((ArrayList)timeVector).get(3));
            String avgStr = String.format("%.2f", (Double)((ArrayList)timeVector).get(2) + (Double)((ArrayList)timeVector).get(3));
            String normal = "" + ((Double)((ArrayList)timeVector).get(4)).intValue();
            String tpn = "" + ((Double)((ArrayList)timeVector).get(5)).intValue();
            String dpn = "" + ((Double)((ArrayList)timeVector).get(6)).intValue();
            String tdpn = "" + ((Double)((ArrayList)timeVector).get(7)).intValue();
            line = (String)line + Tools.setToSize("i_" + clInvariants.get(i), 5, false);
            line = (String)line + Tools.setToSize((String)eftStr, 14, true);
            line = (String)line + Tools.setToSize(avgStr, 14, true);
            line = (String)line + Tools.setToSize(lftStr, 14, true);
            line = (String)line + "    ";
            line = (String)line + Tools.setToSize(normal, 5, false);
            line = (String)line + Tools.setToSize(tpn, 5, false);
            line = (String)line + Tools.setToSize(dpn, 5, false);
            line = (String)line + Tools.setToSize(tdpn, 5, false);
            note.addTextLineNL((String)line, "text");
        }
        double avgMean = 0.0;
        timeVector = avgStatsVector.iterator();
        while (timeVector.hasNext()) {
            double avg = (Double)timeVector.next();
            avgMean += avg;
        }
        avgMean /= (double)avgStatsVector.size();
        double variance = 0.0;
        eftStr = avgStatsVector.iterator();
        while (eftStr.hasNext()) {
            double avg = (Double)eftStr.next();
            variance += (avgMean - avg) * (avgMean - avg);
        }
        double stdDev = Math.sqrt(variance /= (double)avgStatsVector.size());
        note.addTextLineNL("", "text");
        note.addTextLineNL("Mean of average times: " + avgMean, "text");
        note.addTextLineNL("Variance: " + variance, "text");
        note.addTextLineNL("Standard deviation: " + stdDev, "text");
        note.setCaretFirstLine();
        note.setVisible(true);
    }

    private void showClustersData() {
        int trans;
        int invIndex;
        int inv;
        ArrayList<ArrayList<Integer>> invSubMatrix;
        ArrayList<Integer> invariantsIndices;
        int i;
        PetriNet pn = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        ArrayList<ArrayList<Integer>> invMatrix = pn.getT_InvMatrix();
        if (invMatrix == null || invMatrix.size() == 0) {
            return;
        }
        HolmesNotepad note = new HolmesNotepad(800, 600);
        for (i = 0; i < this.clusterColorsData.clustersInvariants.size(); ++i) {
            note.addTextLineNL("Cluster#" + i, "text");
            invariantsIndices = this.clusterColorsData.clustersInvariants.get(i);
            invSubMatrix = new ArrayList<ArrayList<Integer>>();
            for (int j : invariantsIndices) {
                invSubMatrix.add(invMatrix.get(j));
            }
            for (inv = 0; inv < invSubMatrix.size(); ++inv) {
                invIndex = invariantsIndices.get(inv);
                note.addTextLine("x" + invIndex, "text");
                for (trans = 0; trans < ((ArrayList)invSubMatrix.get(inv)).size(); ++trans) {
                    note.addTextLine(";" + ((ArrayList)invSubMatrix.get(inv)).get(trans), "text");
                }
                note.addTextLineNL("", "text");
            }
        }
        note.addTextLineNL("", "text");
        note.addTextLineNL("", "text");
        note.addTextLineNL("", "text");
        note.addTextLineNL("", "text");
        note.addTextLineNL("", "text");
        for (i = 0; i < this.clusterColorsData.clustersInvariants.size(); ++i) {
            note.addTextLineNL("Cluster#" + i, "text");
            invariantsIndices = this.clusterColorsData.clustersInvariants.get(i);
            invSubMatrix = new ArrayList();
            for (int j : invariantsIndices) {
                invSubMatrix.add(invMatrix.get(j));
            }
            for (inv = 0; inv < invSubMatrix.size(); ++inv) {
                invIndex = invariantsIndices.get(inv);
                note.addTextLine("x" + invIndex, "text");
                for (trans = 0; trans < ((ArrayList)invSubMatrix.get(inv)).size(); ++trans) {
                    if ((Integer)((ArrayList)invSubMatrix.get(inv)).get(trans) <= 0) continue;
                    note.addTextLine(";t" + trans, "text");
                }
                note.addTextLineNL("", "text");
            }
        }
        note.setCaretFirstLine();
        note.setVisible(true);
    }

    private void fillClustInvCombo() {
        try {
            if (this.selectedClusterIndex == -1) {
                this.chooseClusterInv.removeAllItems();
                this.chooseClusterInv.addItem("---");
                return;
            }
            this.doNotUpdate = true;
            ArrayList<Integer> clInvariants = this.clusterColorsData.clustersInvariants.get(this.selectedClusterIndex);
            this.chooseClusterInv.removeAllItems();
            String[] clustersInvHeaders = new String[clInvariants.size() + 1];
            clustersInvHeaders[0] = "---";
            for (int i = 0; i < clInvariants.size(); ++i) {
                int invIndex = clInvariants.get(i);
                clustersInvHeaders[i + 1] = "Cluster: " + (this.selectedClusterIndex + 1) + "  |#" + (i + 1) + "  Inv: " + (invIndex + 1);
            }
            this.chooseClusterInv.setModel(new DefaultComboBoxModel<String>(clustersInvHeaders));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.doNotUpdate = false;
    }

    private void showClusterInv() {
        int i;
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (this.selectedClusterIndex == -1) {
            return;
        }
        ArrayList<ClusterTransition> transColors = this.clusterColorsData.dataMatrix.get(this.selectedClusterIndex);
        ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
        ArrayList<Integer> clInvariants = this.clusterColorsData.clustersInvariants.get(this.selectedClusterIndex);
        int invIndex = clInvariants.get(this.selectedClusterInvIndex);
        ArrayList<Integer> invariant = this.overlord.getWorkspace().getProject().getT_InvMatrix().get(invIndex);
        for (i = 0; i < transColors.size(); ++i) {
            if (transColors.get((int)i).transInCluster == 0) continue;
            transitions.get((int)i).drawGraphBoxT.setColorWithNumber(true, Color.DARK_GRAY, false, -1.0, false, "");
        }
        for (i = 0; i < invariant.size(); ++i) {
            if (invariant.get(i) == 0) continue;
            transitions.get((int)i).drawGraphBoxT.setColorWithNumber(true, Color.GREEN, true, transColors.get((int)i).transInCluster, false, "", 0, 20, 5, -3);
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropClustersToFiles() {
        String lastPath = this.overlord.getLastPath();
        String dirPath = Tools.selectDirectoryDialog(lastPath, "Select dir", "Select directory for clusters screenshots.");
        if (dirPath.equals("")) {
            return;
        }
        int clusters = this.clusterColorsData.dataMatrix.size();
        int oldSelected = this.selectedClusterIndex;
        GraphPanel main = this.overlord.getWorkspace().getSheets().get(0).getGraphPanel();
        main.setZoom(120, main.getZoom());
        try {
            JOptionPane.showMessageDialog(null, "Please click OK and wait until another window with information shows up.\nDepending on the number of clusters this should take from 10 seconds to 1 minute.\nPlease do not use the program until operation is finished.", "Please wait", 1);
            this.progressBar.setMaximum(clusters - 1);
            this.progressBar.setValue(0);
            this.progressBar.setVisible(true);
            int c = 0;
            while (c < clusters) {
                this.progressBar.setValue(c);
                this.progressBar.update(this.progressBar.getGraphics());
                int number = c + 1;
                String clusterName = "cluster_" + number + "_(invariants_" + this.clusterColorsData.clSize.get(c) + ")";
                this.selectedClusterIndex = c++;
                this.clustersMCT = false;
                this.showClusters();
                String fileName = dirPath + "//" + clusterName + ".png";
                BufferedImage image = main.createImageFromSheet();
                ImageIO.write((RenderedImage)image, "png", new File(fileName));
                this.clustersMCT = true;
                this.showClusters();
                fileName = dirPath + "//" + clusterName + "_MCTview.png";
                BufferedImage image2 = main.createImageFromSheet();
                ImageIO.write((RenderedImage)image2, "png", new File(fileName));
            }
        }
        catch (Exception e) {
            this.overlord.log("Saving clusters screenshots failed.", "error", true);
            this.progressBar.setVisible(false);
        }
        finally {
            this.selectedClusterIndex = oldSelected;
            main.setZoom(100, main.getZoom());
        }
        this.progressBar.setVisible(false);
        JOptionPane.showMessageDialog(null, "Saving " + clusters + " clusters to graphic files completed.", "Success", 1);
    }

    private void showClustersNotepad() {
        if (this.selectedClusterIndex == -1) {
            return;
        }
        HolmesNotepad note = new HolmesNotepad(640, 480);
        note.addTextLineNL("", "text");
        note.addTextLineNL("Cluster: " + (this.selectedClusterIndex + 1) + " (" + this.clusterColorsData.clSize.get(this.selectedClusterIndex) + " inv.) alg.: " + this.clusterColorsData.algorithm + " metric: " + this.clusterColorsData.metric, "text");
        note.addTextLineNL("", "text");
        ArrayList<ClusterTransition> transColors = this.clusterColorsData.dataMatrix.get(this.selectedClusterIndex);
        ArrayList<Transition> holyVector = this.overlord.getWorkspace().getProject().getTransitions();
        for (int i = 0; i < transColors.size(); ++i) {
            int trInCluster = transColors.get((int)i).transInCluster;
            double firedInCluster = transColors.get((int)i).firedInCluster;
            if (trInCluster <= 0) continue;
            String t1 = Tools.setToSize("t" + i, 5, false);
            String t2 = Tools.setToSize("Freq.: " + trInCluster, 12, false);
            String t3 = Tools.setToSize("Fired: " + HolmesDockWindowsTable.formatD(firedInCluster), 15, false);
            String txt = t1 + t2 + t3 + " ; " + holyVector.get(i).getName();
            note.addTextLineNL(txt, "text");
        }
        note.setCaretFirstLine();
        note.setVisible(true);
    }

    private void showClusters() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (this.selectedClusterIndex == -1) {
            this.mssValueLabel.setText("n/a");
            return;
        }
        ArrayList<ClusterTransition> transColors = this.clusterColorsData.dataMatrix.get(this.selectedClusterIndex);
        ArrayList<Transition> holyVector = this.overlord.getWorkspace().getProject().getTransitions();
        ColorPalette cp = new ColorPalette();
        ArrayList<Integer> transMCTvector = this.overlord.getWorkspace().getProject().getMCTtransIndicesVector();
        float mss = this.clusterColorsData.clMSS.get(this.selectedClusterIndex).floatValue();
        this.mssValueLabel.setText("" + mss);
        for (int i = 0; i < transColors.size(); ++i) {
            int tranNumber;
            if (transColors.get((int)i).transInCluster == 0) {
                holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(false, Color.white, false, -1.0, false, "");
                continue;
            }
            if (this.clustersMCT) {
                int mctNo = transMCTvector.get(i);
                if (mctNo == -1) {
                    if (this.clusterColorsData.showFirings) {
                        if (this.clusterColorsData.showScale) {
                            holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, Color.CYAN, true, transColors.get((int)i).firedInCluster, false, "", 0, 20, 5, -3);
                            continue;
                        }
                        holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, Color.CYAN, true, transColors.get((int)i).firedInCluster, false, "", 0, 20, 5, -3);
                        continue;
                    }
                    if (this.clusterColorsData.showScale) {
                        holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, Color.CYAN, true, transColors.get((int)i).transInCluster, false, "", 0, 20, 5, -3);
                        continue;
                    }
                    holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, Color.CYAN, true, transColors.get((int)i).transInCluster, false, "", 0, 20, 5, -3);
                    continue;
                }
                double value = this.clusterColorsData.showFirings ? transColors.get((int)i).firedInCluster : (double)transColors.get((int)i).transInCluster;
                holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, cp.getColor(mctNo), true, value, true, "[MCT" + (mctNo + 1) + "]", -10, 15, 5, -3);
                continue;
            }
            if (this.clusterColorsData.showFirings) {
                Color tranColor;
                if (this.clusterColorsData.showScale) {
                    double tranNumber2 = transColors.get((int)i).firedInCluster;
                    tranColor = transColors.get((int)i).colorFiredScale;
                    holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, tranColor, true, tranNumber2, false, "", 0, 0, 5, -2);
                    continue;
                }
                double tranNumber3 = transColors.get((int)i).firedInCluster;
                tranColor = transColors.get((int)i).colorFiredGrade;
                holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, tranColor, true, tranNumber3, false, "", 0, 0, 5, -2);
                continue;
            }
            if (this.clusterColorsData.showScale) {
                tranNumber = transColors.get((int)i).transInCluster;
                Color tranColor = transColors.get((int)i).colorTransScale;
                holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, tranColor, true, tranNumber, false, "", 0, 0, 5, -2);
                continue;
            }
            tranNumber = transColors.get((int)i).transInCluster;
            Color tranColor = transColors.get((int)i).colorTransGrade;
            holyVector.get((int)i).drawGraphBoxT.setColorWithNumber(true, tranColor, true, tranNumber, false, "", 0, 0, 5, -2);
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private static String formatD(double value) {
        DecimalFormat df = new DecimalFormat("#.####");
        String txt = df.format(value);
        txt = txt.replace(",", ".");
        return txt;
    }

    private void createMCSSubWindow(MCSDataMatrix mcsData) {
        this.transitions = this.overlord.getWorkspace().getProject().getTransitions();
        this.initiateContainers();
        int posX = 10;
        int posY = 10;
        JLabel objRLabel = new JLabel("Reaction: ");
        objRLabel.setBounds(posX, posY, 80, 20);
        this.components.add(objRLabel);
        String[] objRset = new String[this.transitions.size() + 1];
        objRset[0] = "---";
        for (int i = 0; i < this.transitions.size(); ++i) {
            objRset[i + 1] = "t" + i + this.transitions.get(i).getName();
        }
        this.mcsObjRCombo = new JComboBox<String>(objRset);
        this.mcsObjRCombo.setBounds(posX + 60, posY, 230, 20);
        this.mcsObjRCombo.addActionListener(actionEvent -> {
            if (this.stopAction) {
                return;
            }
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected > 0) {
                MCSDataMatrix mcsDataCore = this.overlord.getWorkspace().getProject().getMCSdataCore();
                int n = --selected;
                --selected;
                ArrayList<ArrayList<Integer>> sets = mcsDataCore.getMCSlist(n);
                if (sets == null) {
                    return;
                }
                this.stopAction = true;
                this.mcsMCSforObjRCombo.removeAllItems();
                this.mcsMCSforObjRCombo.addItem("---");
                for (ArrayList<Integer> set : sets) {
                    StringBuilder newRowBuilder = new StringBuilder("[");
                    for (int el : set) {
                        newRowBuilder.append(el).append(", ");
                    }
                    Object newRow = newRowBuilder.toString();
                    newRow = (String)newRow + "]";
                    newRow = ((String)newRow).replace(", ]", "]");
                    this.mcsMCSforObjRCombo.addItem((String)newRow);
                }
                this.stopAction = false;
            }
        });
        this.components.add(this.mcsObjRCombo);
        JLabel mcsLabel = new JLabel("MCS: ");
        mcsLabel.setBounds(posX, posY += 25, 80, 20);
        this.components.add(mcsLabel);
        String[] init = new String[]{"---"};
        this.mcsMCSforObjRCombo = new JComboBox<String>(init);
        this.mcsMCSforObjRCombo.setBounds(posX + 60, posY, 160, 20);
        this.mcsMCSforObjRCombo.addActionListener(actionEvent -> {
            if (this.stopAction) {
                return;
            }
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected > 0) {
                --selected;
                int selTrans = this.mcsObjRCombo.getSelectedIndex();
                this.showMCSDataInNet(Objects.requireNonNull(comboBox.getSelectedItem()).toString(), --selTrans);
            }
        });
        this.components.add(this.mcsMCSforObjRCombo);
        JButton refreshButton = new JButton();
        refreshButton.setText("Refresh");
        refreshButton.setBounds(posX + 225, posY, 70, 20);
        refreshButton.addActionListener(actionEvent -> {
            this.transitions = this.overlord.getWorkspace().getProject().getTransitions();
            if (this.transitions.size() == 0) {
                return;
            }
            String[] objRset1 = new String[this.transitions.size() + 1];
            objRset1[0] = "---";
            for (int i = 0; i < this.transitions.size(); ++i) {
                objRset1[i + 1] = "t" + i + "_" + this.transitions.get(i).getName();
            }
            this.stopAction = true;
            this.mcsObjRCombo.removeAllItems();
            for (String str : objRset1) {
                this.mcsObjRCombo.addItem(str);
            }
            this.stopAction = false;
        });
        refreshButton.setFocusPainted(false);
        this.panel.add(refreshButton);
        posY += 20;
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void showMCSDataInNet(String sets, int objReactionID) {
        try {
            PetriNet pn = this.overlord.getWorkspace().getProject();
            pn.resetNetColors();
            sets = sets.replace("[", "");
            sets = sets.replace("]", "");
            sets = sets.replace(" ", "");
            String[] elements = sets.split(",");
            ArrayList<Integer> invIDs = new ArrayList<Integer>();
            for (String el : elements) {
                invIDs.add(Integer.parseInt(el));
            }
            Transition trans_TMP = this.overlord.getWorkspace().getProject().getTransitions().get(objReactionID);
            trans_TMP.drawGraphBoxT.setColorWithNumber(true, Color.red, false, -1.0, false, "");
            Iterator iterator = invIDs.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                trans_TMP = this.overlord.getWorkspace().getProject().getTransitions().get(id);
                trans_TMP.drawGraphBoxT.setColorWithNumber(true, Color.black, false, -1.0, false, "");
            }
            this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void createKnockoutData(ArrayList<ArrayList<Integer>> knockoutData) {
        if (knockoutData == null || knockoutData.isEmpty()) {
            return;
        }
        this.mode = 10;
        this.knockoutData = knockoutData;
        int colA_posX = 10;
        int colB_posX = 100;
        int positionY = 10;
        this.initiateContainers();
        MCTCalculator analyzer = this.overlord.getWorkspace().getProject().getMCTanalyzer();
        ArrayList<ArrayList<Transition>> mct = analyzer.generateMCT();
        mct = MCTCalculator.getSortedMCT(mct, false);
        ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
        int transSize = transitions.size();
        ArrayList<Object> mctOrNot = new ArrayList<Object>();
        for (int i = 0; i < transSize; ++i) {
            mctOrNot.add("");
        }
        int mctNo = 0;
        for (ArrayList<Transition> arr : mct) {
            ++mctNo;
            for (Transition t : arr) {
                int id = transitions.indexOf(t);
                mctOrNot.set(id, "MCT_" + mctNo);
            }
        }
        String[] headers = new String[transSize + 1];
        headers[0] = "---";
        for (int i = 0; i < transSize; ++i) {
            String newLine = "t" + i + "   " + (String)mctOrNot.get(i);
            headers[i + 1] = newLine;
        }
        JLabel chooseMctLabel = new JLabel("Knockout: ");
        chooseMctLabel.setBounds(colA_posX, positionY, 60, 20);
        this.components.add(chooseMctLabel);
        JComboBox<String> chooseMctBox = new JComboBox<String>(headers);
        chooseMctBox.setBounds(colB_posX, positionY, 150, 20);
        chooseMctBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.showKnockout(-1, false);
            } else {
                this.showKnockout(--selected, true);
            }
        });
        this.components.add(chooseMctBox);
        positionY += 30;
        this.knockoutTextArea = new JTextArea();
        this.knockoutTextArea.setEditable(false);
        this.knockoutTextArea.setFont(new Font("Monospaced", 0, 12));
        JPanel textAreaPanel = new JPanel();
        textAreaPanel.setLayout(new BorderLayout());
        textAreaPanel.add((Component)new JScrollPane(this.knockoutTextArea, 22, 30), "Center");
        int w = this.overlord.getMctBox().getWidth();
        int h = this.overlord.getMctBox().getHeight();
        textAreaPanel.setBounds(colA_posX, positionY, w - 30, h - 60);
        this.components.add(textAreaPanel);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void showKnockout(Integer knockIndex, boolean showOrClear) {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (showOrClear) {
            Transition trans_TMP;
            ArrayList<Integer> idToShow = this.knockoutData.get(knockIndex);
            ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
            for (int id : idToShow) {
                trans_TMP = transitions.get(id);
                trans_TMP.drawGraphBoxT.setColorWithNumber(true, Color.black, false, -1.0, false, "");
            }
            trans_TMP = transitions.get(knockIndex);
            trans_TMP.drawGraphBoxT.setColorWithNumber(true, Color.red, false, -1.0, false, "");
            this.knockoutTextArea.setText("");
            this.knockoutTextArea.append("Knocked out:" + knockIndex + ":\n");
            this.knockoutTextArea.append("\n");
            this.knockoutTextArea.append(" * * * Also knocked out: \n");
            for (int t_id : idToShow) {
                String t1 = Tools.setToSize("t" + t_id, 5, false);
                this.knockoutTextArea.append(t1 + " ; " + transitions.get(t_id).getName() + "\n");
            }
            this.knockoutTextArea.setCaretPosition(0);
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void createFixerSubWindow() {
        int posX = 10;
        int posY = 10;
        this.initiateContainers();
        this.detector = new ProblemDetector(this);
        JLabel label0 = new JLabel("t-invariants:");
        label0.setBounds(posX, posY, 100, 20);
        this.components.add(label0);
        this.fixInvariants = new JLabel("Normal: 0 / Non-inv.: 0");
        this.fixInvariants.setBounds(posX, posY += 20, 190, 20);
        this.components.add(this.fixInvariants);
        this.fixInvariants2 = new JLabel("Sub-inv.: 0 / Sur-inv: 0");
        this.fixInvariants2.setBounds(posX, posY += 20, 190, 20);
        this.components.add(this.fixInvariants2);
        JButton markInvButton = new JButton();
        markInvButton.setText("<html>Show<br>&nbsp;&nbsp;&nbsp;inv.</html>");
        markInvButton.setBounds(posX + 185, posY - 18, 100, 32);
        markInvButton.setMargin(new Insets(0, 0, 0, 0));
        markInvButton.setIcon(Tools.getResIcon22("/icons/fixGlass.png"));
        markInvButton.addActionListener(actionEvent -> this.detector.markSubSurNonInvariantsPlaces());
        markInvButton.setFocusPainted(false);
        this.components.add(markInvButton);
        JLabel label1 = new JLabel("Input and output places:");
        label1.setBounds(posX, posY += 25, 200, 20);
        this.components.add(label1);
        this.fixIOPlaces = new JLabel("Input: 0 / Output: 0");
        this.fixIOPlaces.setBounds(posX, posY += 20, 190, 20);
        this.components.add(this.fixIOPlaces);
        JButton markIOPlacesButton = new JButton();
        markIOPlacesButton.setText("<html>Show<br>places</html>");
        markIOPlacesButton.setBounds(posX + 185, posY - 16, 100, 32);
        markIOPlacesButton.setMargin(new Insets(0, 0, 0, 0));
        markIOPlacesButton.setIcon(Tools.getResIcon22("/icons/fixGlass.png"));
        markIOPlacesButton.addActionListener(actionEvent -> this.detector.markIOPlaces());
        markIOPlacesButton.setFocusPainted(false);
        this.components.add(markIOPlacesButton);
        JLabel label2 = new JLabel("Input and output transitions:");
        label2.setBounds(posX, posY += 25, 200, 20);
        this.components.add(label2);
        this.fixIOTransitions = new JLabel("Input: 0 / Output: 0");
        this.fixIOTransitions.setBounds(posX, posY += 20, 190, 20);
        this.components.add(this.fixIOTransitions);
        JButton markIOTransButton = new JButton();
        markIOTransButton.setText("<html>Show<br>trans.</html>");
        markIOTransButton.setBounds(posX + 185, posY - 14, 100, 32);
        markIOTransButton.setMargin(new Insets(0, 0, 0, 0));
        markIOTransButton.setIcon(Tools.getResIcon22("/icons/fixGlass.png"));
        markIOTransButton.addActionListener(actionEvent -> this.detector.markIOTransitions());
        markIOTransButton.setFocusPainted(false);
        this.components.add(markIOTransButton);
        JLabel label3 = new JLabel("Linear transitions and places");
        label3.setBounds(posX, posY += 25, 200, 20);
        this.components.add(label3);
        this.fixlinearTrans = new JLabel("Transitions: 0 / Places: 0");
        this.fixlinearTrans.setBounds(posX, posY += 20, 190, 20);
        this.components.add(this.fixlinearTrans);
        JButton markLinearTPButton = new JButton();
        markLinearTPButton.setText("<html>Show<br>T & P</html>");
        markLinearTPButton.setBounds(posX + 185, posY - 12, 100, 32);
        markLinearTPButton.setMargin(new Insets(0, 0, 0, 0));
        markLinearTPButton.setIcon(Tools.getResIcon22("/icons/fixGlass.png"));
        markLinearTPButton.addActionListener(actionEvent -> this.detector.markLinearRegions());
        markLinearTPButton.setFocusPainted(false);
        this.components.add(markLinearTPButton);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void createQuickSimSubWindow() {
        int posX = 10;
        int posY = 10;
        this.initiateContainers();
        this.quickSim = new QuickSimTools(this);
        JButton acqDataButton = new JButton("SimStart");
        acqDataButton.setBounds(posX, posY, 110, 40);
        acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        acqDataButton.setFocusPainted(false);
        acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        acqDataButton.setToolTipText("Compute steps from zero marking through the number of states");
        acqDataButton.addActionListener(actionEvent -> this.quickSim.acquireData(this.scanTransitions, this.scanPlaces, this.markArcs, this.repetitions, this.quickProgressBar));
        this.components.add(acqDataButton);
        JButton simSettingsButton = new JButton("SimSettings");
        simSettingsButton.setBounds(posX + 120, posY, 130, 40);
        simSettingsButton.setMargin(new Insets(0, 0, 0, 0));
        simSettingsButton.setFocusPainted(false);
        simSettingsButton.setIcon(Tools.getResIcon32("/icons/simSettings/setupIcon.png"));
        simSettingsButton.setToolTipText("Set simulator options.");
        simSettingsButton.addActionListener(actionEvent -> new HolmesSimSetup(GUIManager.getDefaultGUIManager().getFrame()));
        this.components.add(simSettingsButton);
        this.quickProgressBar = new JProgressBar();
        this.quickProgressBar.setBounds(posX, posY += 45, 280, 25);
        this.quickProgressBar.setMaximum(100);
        this.quickProgressBar.setMinimum(0);
        this.quickProgressBar.setValue(0);
        this.quickProgressBar.setStringPainted(true);
        this.components.add(this.quickProgressBar);
        JPanel borderPanel = new JPanel(null);
        borderPanel.setBounds(posX, posY += 30, 280, 80);
        borderPanel.setBorder(BorderFactory.createTitledBorder("Data type simulated"));
        this.components.add(borderPanel);
        JCheckBox transBox = new JCheckBox("Transitions firing data", this.scanTransitions);
        transBox.setBounds(5, 15, 160, 20);
        transBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.scanTransitions = box.isSelected();
        });
        borderPanel.add(transBox);
        JCheckBox placesBox = new JCheckBox("Places tokens data", this.scanPlaces);
        placesBox.setBounds(5, 35, 160, 20);
        placesBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.scanPlaces = box.isSelected();
        });
        borderPanel.add(placesBox);
        JCheckBox arcsBox = new JCheckBox("Color arcs", this.markArcs);
        arcsBox.setBounds(5, 55, 140, 20);
        arcsBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.markArcs = box.isSelected();
        });
        borderPanel.add(arcsBox);
        JCheckBox repsBox = new JCheckBox("Repetitions", this.repetitions);
        repsBox.setBounds(165, 15, 100, 20);
        repsBox.addItemListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.repetitions = box.isSelected();
        });
        borderPanel.add(repsBox);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void createDecompositionData() {
        int posX = 10;
        int posY = 10;
        if (!SubnetCalculator.functionalSubNets.isEmpty()) {
            this.mode = 13;
            SubnetCalculator.cleanSubnets();
        }
        SubnetCalculator.cleanSubnets();
        this.initiateContainers();
        JLabel chooseDecoLabel = new JLabel("Choose Decomposition: ");
        chooseDecoLabel.setBounds(posX, posY, 150, 20);
        this.components.add(chooseDecoLabel);
        String[] decoList = new String[]{"Functional", "S-nets", "T-nets", "maxADT", "Teng-Zhang", "Hou", "Nishi", "Cycle", "Ootsuki"};
        JComboBox<String> chooseMctBox = new JComboBox<String>(decoList);
        chooseMctBox.setBounds(posX, posY + 30, 150, 20);
        chooseMctBox.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            this.choosenDeco = comboBox.getSelectedIndex();
        });
        this.components.add(chooseMctBox);
        JButton calculateDeco = new JButton("Calculate");
        calculateDeco.setBounds(posX + 200, posY + 30, 100, 50);
        calculateDeco.addActionListener(actionEvent -> this.calculateDeco(this.choosenDeco));
        this.components.add(calculateDeco);
        JComboBox subnetList = new JComboBox();
        subnetList.setBounds(posX, posY + 60, 150, 20);
        subnetList.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.selectedMCTindex = -1;
                this.allMCTselected = false;
                this.showSubNet(0);
                this.MCTnameField.setText("");
            } else if (selected == comboBox.getItemCount() - 1) {
                this.allMCTselected = true;
                this.showAllColors();
            } else {
                this.selectedMCTindex = selected - 1;
                this.allMCTselected = false;
                this.showSubNet(0);
            }
        });
        this.components.add(subnetList);
        this.elementsOfDecomposedStructure = new JTextArea();
        this.elementsOfDecomposedStructure.setLineWrap(true);
        this.elementsOfDecomposedStructure.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    HolmesDockWindowsTable.this.changeSubNetname(field.getText());
                }
            }
        });
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.add((Component)new JScrollPane(this.MCTnameField), "Center");
        descPanel.setBounds(posX, posY + 100, 250, 80);
        this.components.add(descPanel);
        this.panel.setLayout(null);
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.setOpaque(true);
        this.panel.repaint();
        this.panel.setVisible(true);
        this.add(this.panel);
    }

    private void changeSubNetname(String newName) {
        if (this.selectedSubNetindex == -1) {
            return;
        }
        this.overlord.getWorkspace().getProject().accessMCTnames().set(this.selectedSubNetindex, newName);
    }

    private void calculateDeco(int index) {
        this.getSubnetOfType(index);
    }

    private void getSubnetOfType(int index) {
        this.generateProperSubNet(index);
        int listIndex = this.components.stream().map(Component::getLocation).collect(Collectors.toList()).indexOf(new Point(10, 70));
        JComboBox<String> newCB = this.generateButton(index);
        newCB.setBounds(10, 70, 150, 20);
        newCB.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.selectedSubNetindex = -1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
                this.elementsOfDecomposedStructure.setText("");
            } else if (selected == comboBox.getItemCount() - 1) {
                this.allSubNetsselected = true;
                this.showAllSubColors(true, index);
            } else if (selected == comboBox.getItemCount() - 2) {
                this.allSubNetsselected = true;
                this.showAllSubColors(false, index);
            } else {
                this.selectedSubNetindex = selected - 1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
            }
        });
        newCB.setVisible(true);
        this.components.set(listIndex, newCB);
        this.panel.removeAll();
        for (JComponent component : this.components) {
            this.panel.add(component);
        }
        this.panel.repaint();
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private JComboBox<String> generateButton(int index) {
        if (index == 0 || index == 1 || index == 2 || index == 3) {
            return this.generateProperDecoButton(index);
        }
        if (index == 4 || index == 5 || index == 6 || index == 7) {
            return this.generateInProperDecoButton(index);
        }
        return this.generateProperDecoButton(index);
    }

    private JComboBox<String> generateProperDecoButton(int index) {
        int size = this.getSubnetSize(index);
        String[] newComoList = new String[size + 3];
        for (int i = 0; i < size; ++i) {
            newComoList[i + 1] = this.getProperSubNetName(index) + i;
        }
        newComoList[0] = "--";
        newComoList[size + 1] = "All non trivial subnets";
        newComoList[size + 2] = "All subnets";
        JComboBox<String> newCB = new JComboBox<String>(newComoList);
        newCB.setBounds(10, 70, 150, 20);
        newCB.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.selectedSubNetindex = -1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
                this.elementsOfDecomposedStructure.setText("");
            } else if (selected == comboBox.getItemCount() - 1) {
                this.allSubNetsselected = true;
                this.showAllSubColors(true, index);
            } else if (selected == comboBox.getItemCount() - 2) {
                this.allSubNetsselected = true;
                this.showAllSubColors(false, index);
            } else {
                this.selectedSubNetindex = selected - 1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
            }
        });
        newCB.setVisible(true);
        return newCB;
    }

    private JComboBox<String> generateInProperDecoButton(int index) {
        int size = this.getSubnetSize(index);
        String[] newComoList = new String[size + 2];
        for (int i = 0; i < size; ++i) {
            newComoList[i + 1] = this.getProperSubNetName(index) + i;
        }
        newComoList[0] = "--";
        newComoList[size + 1] = "Net coverage";
        JComboBox<String> newCB = new JComboBox<String>(newComoList);
        newCB.setBounds(10, 70, 150, 20);
        newCB.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.selectedSubNetindex = -1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
                this.elementsOfDecomposedStructure.setText("");
            } else if (selected == comboBox.getItemCount() - 1) {
                this.allSubNetsselected = true;
                this.showCoverageColors(index);
            } else {
                this.selectedSubNetindex = selected - 1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
            }
        });
        newCB.setVisible(true);
        return newCB;
    }

    private String getProperSubNetName(int index) {
        return switch (index) {
            case 0 -> "Functional ";
            case 1 -> "S-net ";
            case 2 -> "T-net ";
            case 3 -> "maxADT ";
            case 4 -> "Teng-Zeng ";
            case 5 -> "Hou ";
            case 6 -> "Nishi ";
            case 7 -> "Cycle";
            case 8 -> "Ootsuki";
            default -> "";
        };
    }

    private void generateProperSubNet(int index) {
        SubnetCalculator.compileElements();
        switch (index) {
            case 0: {
                SubnetCalculator.generateFS();
                break;
            }
            case 1: {
                SubnetCalculator.generateSnets();
                break;
            }
            case 2: {
                SubnetCalculator.generateTnets();
                break;
            }
            case 3: {
                SubnetCalculator.generateADT();
                break;
            }
            case 4: {
                SubnetCalculator.generateTZ();
                break;
            }
            case 5: {
                SubnetCalculator.generateHou();
                break;
            }
            case 6: {
                SubnetCalculator.generateNishi();
                break;
            }
            case 7: {
                SubnetCalculator.generateCycle(false);
                break;
            }
            case 8: {
                SubnetCalculator.generateOotsuki();
            }
        }
    }

    private int getSubnetSize(int index) {
        return switch (index) {
            case 0 -> SubnetCalculator.functionalSubNets.size();
            case 1 -> SubnetCalculator.snetSubNets.size();
            case 2 -> SubnetCalculator.tnetSubNets.size();
            case 3 -> SubnetCalculator.adtSubNets.size();
            case 4 -> SubnetCalculator.tzSubNets.size();
            case 5 -> SubnetCalculator.houSubNets.size();
            case 6 -> SubnetCalculator.nishiSubNets.size();
            case 7 -> SubnetCalculator.cycleSubNets.size();
            case 8 -> SubnetCalculator.ootsukiSubNets.size();
            default -> 0;
        };
    }

    private void showSubNet(int typeOfDecomposition) {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (this.selectedSubNetindex == -1) {
            return;
        }
        SubnetCalculator.SubNet subnet = null;
        int size = 0;
        switch (typeOfDecomposition) {
            case 0: {
                subnet = SubnetCalculator.functionalSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.functionalSubNets.size();
                break;
            }
            case 1: {
                subnet = SubnetCalculator.snetSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.snetSubNets.size();
                break;
            }
            case 2: {
                subnet = SubnetCalculator.tnetSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.tnetSubNets.size();
                break;
            }
            case 3: {
                subnet = SubnetCalculator.adtSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.adtSubNets.size();
                break;
            }
            case 4: {
                subnet = SubnetCalculator.tzSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.tzSubNets.size();
                break;
            }
            case 5: {
                subnet = SubnetCalculator.houSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.houSubNets.size();
                break;
            }
            case 6: {
                subnet = SubnetCalculator.nishiSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.nishiSubNets.size();
                break;
            }
            case 7: {
                subnet = SubnetCalculator.cycleSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.cycleSubNets.size();
                break;
            }
            case 8: {
                subnet = SubnetCalculator.ootsukiSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.ootsukiSubNets.size();
            }
        }
        ColorPalette cp = new ColorPalette();
        boolean colorSubNet = false;
        assert (subnet != null);
        for (Place place : subnet.getSubPlaces()) {
            if (!colorSubNet) {
                place.setGlowedSub(true);
                continue;
            }
            if (this.selectedSubNetindex == size - 1) {
                place.drawGraphBoxP.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[trivial]");
                continue;
            }
            place.drawGraphBoxP.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
        }
        for (Arc arc : subnet.getSubArcs()) {
            if (colorSubNet) continue;
            arc.setGlowedSub(true);
        }
        for (Transition transition : subnet.getSubTransitions()) {
            if (!colorSubNet) {
                transition.drawGraphBoxT.setGlowed_MTC(true);
                continue;
            }
            if (this.selectedSubNetindex == size - 1) {
                transition.drawGraphBoxT.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[trivial]");
                continue;
            }
            transition.drawGraphBoxT.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        if (this.overlord.getWorkspace().getProject().accessSubNetNames() != null) {
            String name = this.overlord.getWorkspace().getProject().accessSubNetNames().get(this.selectedSubNetindex);
            this.elementsOfDecomposedStructure.setText(name);
        }
    }

    private void showCoverageColors(int subnetType) {
        ArrayList<SubnetCalculator.SubNet> subnets = this.getCorrectSubnet(subnetType);
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        for (int m = 0; m < subnets.size(); ++m) {
            SubnetCalculator.SubNet subNet = subnets.get(m);
            ArrayList<Node> transitions = subNet.getSubNode();
            for (Node transition : transitions) {
                if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                    ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, Color.red, false, m, true, "");
                }
                if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
                ((Place)transition).drawGraphBoxP.setColorWithNumber(true, Color.red, false, m, true, "");
            }
            ArrayList<Arc> arcs = subnets.get(m).getSubArcs();
            for (Arc arc : arcs) {
                arc.arcDecoBox.setColor(true, Color.red);
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void showAllSubColors(boolean trivial, int subnetType) {
        ArrayList<Place> places;
        ArrayList<Transition> transitions;
        SubnetCalculator.SubNet subNet;
        Color currentColor;
        int m;
        ArrayList<SubnetCalculator.SubNet> subnets = this.getCorrectSubnet(subnetType);
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        ColorPalette cp = new ColorPalette();
        if (subnetType == 0) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                transitions = subNet.getSubTransitions();
                if (transitions.size() <= 1 && !trivial) continue;
                for (Transition transition : transitions) {
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + (m + 1) + " (" + transitions.size() + ")");
                }
                places = subnets.get(m).getSubPlaces();
                for (Place place : places) {
                    if (subNet.getSubBorderPlaces().contains(place)) {
                        place.drawGraphBoxP.setColorWithNumber(true, this.calcMiddleColor(currentColor, place.drawGraphBoxP.getPlaceNewColor()), false, m, true, "");
                        continue;
                    }
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc2 : arrayList) {
                    arc2.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        if (subnetType == 1) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                ArrayList<Place> places2 = subNet.getSubPlaces();
                if (places2.size() <= 1 && !trivial) continue;
                for (Place place : places2) {
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + (m + 1) + " (" + places2.size() + ")");
                }
                ArrayList<Transition> transitions2 = subnets.get(m).getSubTransitions();
                Iterator iterator = transitions2.iterator();
                while (iterator.hasNext()) {
                    Transition transition = (Transition)iterator.next();
                    if (subNet.getSubBorderTransition().contains(transition)) {
                        transition.drawGraphBoxT.setColorWithNumber(true, this.calcMiddleColor(currentColor, transition.drawGraphBoxT.getTransitionNewColor()), false, m, true, "");
                        continue;
                    }
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc : arrayList) {
                    arc.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        if (subnetType == 2) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                transitions = subNet.getSubTransitions();
                if (transitions.size() <= 1 && !trivial) continue;
                for (Transition transition : transitions) {
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + (m + 1) + " (" + transitions.size() + ")");
                }
                places = subnets.get(m).getSubPlaces();
                for (Place place : places) {
                    if (subNet.getSubBorderPlaces().contains(place)) {
                        place.drawGraphBoxP.setColorWithNumber(true, this.calcMiddleColor(currentColor, place.drawGraphBoxP.getPlaceNewColor()), false, m, true, "");
                        continue;
                    }
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc : arrayList) {
                    arc.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        if (subnetType == 3) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                transitions = subNet.getSubTransitions();
                if (transitions.size() <= 1 && !trivial) continue;
                for (Transition transition : transitions) {
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + (m + 1) + " (" + transitions.size() + ")");
                }
                places = subnets.get(m).getSubPlaces();
                for (Place place : places) {
                    if (subNet.getSubBorderPlaces().contains(place)) {
                        place.drawGraphBoxP.setColorWithNumber(true, this.calcMiddleColor(currentColor, place.drawGraphBoxP.getPlaceNewColor()), false, m, true, "");
                        continue;
                    }
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc : arrayList) {
                    arc.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private ArrayList<SubnetCalculator.SubNet> getCorrectSubnet(int type) {
        return switch (type) {
            case 0 -> SubnetCalculator.functionalSubNets;
            case 1 -> SubnetCalculator.snetSubNets;
            case 2 -> SubnetCalculator.tnetSubNets;
            case 3 -> SubnetCalculator.adtSubNets;
            case 4 -> SubnetCalculator.tzSubNets;
            case 5 -> SubnetCalculator.houSubNets;
            case 6 -> SubnetCalculator.nishiSubNets;
            case 7 -> SubnetCalculator.cycleSubNets;
            case 8 -> SubnetCalculator.ootsukiSubNets;
            default -> SubnetCalculator.functionalSubNets;
        };
    }

    private Color calcMiddleColor(Color one, Color two) {
        int blue = 0;
        int red = 0;
        int green = 0;
        int absBlue = Math.abs(one.getBlue() - two.getBlue());
        int absRed = Math.abs(one.getRed() - two.getRed());
        int absGreen = Math.abs(one.getGreen() - two.getGreen());
        blue = one.getBlue() > two.getBlue() ? one.getBlue() - absBlue / 2 : two.getBlue() - absBlue / 2;
        red = one.getRed() > two.getRed() ? one.getRed() - absRed / 2 : two.getRed() - absRed / 2;
        green = one.getGreen() > two.getGreen() ? one.getGreen() - absGreen / 2 : two.getGreen() - absGreen / 2;
        return Color.LIGHT_GRAY;
    }

    private void initiateContainers() {
        this.setLayout(new BoxLayout(this, 1));
        this.components = new ArrayList();
        this.panel = new JPanel();
    }

    private void repaintGraphPanel() {
        int sheetIndex = this.overlord.IDtoIndex(this.elementLocation.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        graphPanel.repaint();
    }

    private void setSheetWidth(int width) {
        if (this.mode == 3) {
            this.setContainerWidth(width, this.currentSheet.getGraphPanel());
            this.setContainerWidth(width, this.currentSheet.getContainerPanel());
            this.currentSheet.getGraphPanel().setOriginSize(this.currentSheet.getGraphPanel().getSize());
        }
    }

    private void setSheetHeight(int height) {
        if (this.mode == 3) {
            this.setContainerHeight(height, this.currentSheet.getGraphPanel());
            this.setContainerHeight(height, this.currentSheet.getContainerPanel());
            this.currentSheet.getGraphPanel().setOriginSize(this.currentSheet.getGraphPanel().getSize());
        }
    }

    private void setContainerWidth(int width, JComponent container) {
        if (this.mode == 3) {
            Dimension dim = container.getSize();
            dim.setSize(width, dim.height);
            container.setSize(dim);
        }
    }

    private void setContainerHeight(int height, JComponent container) {
        if (this.mode == 3) {
            Dimension dim = container.getSize();
            dim.setSize(dim.width, height);
            container.setSize(dim);
        }
    }

    private void setAutoscroll(boolean value) {
        if (this.mode == 3) {
            this.currentSheet.getGraphPanel().setAutoDragScroll(value);
        }
    }

    private void setMinFireTime(double x) {
        if (this.mode == 7) {
            Transition transition = (Transition)this.element;
            transition.timeExtension.setEFT(x);
            this.repaintGraphPanel();
        }
    }

    private void setMaxFireTime(double x) {
        if (this.mode == 7) {
            Transition transition = (Transition)this.element;
            transition.timeExtension.setLFT(x);
            this.repaintGraphPanel();
        }
    }

    private void setDurationTime(double x) {
        if (this.mode == 7) {
            Transition transition = (Transition)this.element;
            transition.timeExtension.setDPNduration(x);
            this.repaintGraphPanel();
        }
    }

    private void setTPNstatus(boolean status) {
        if (this.mode == 7) {
            Transition transition = (Transition)this.element;
            transition.timeExtension.setTPNstatus(status);
            this.repaintGraphPanel();
        }
    }

    private void setDPNstatus(boolean status) {
        if (this.mode == 7) {
            Transition transition = (Transition)this.element;
            transition.timeExtension.setDPNstatus(status);
            this.repaintGraphPanel();
        }
    }

    private void setX(int x) {
        if (this.mode == 0 || this.mode == 1 || this.mode == 7 || this.mode == 15 || this.mode == 14) {
            this.elementLocation.setPosition(new Point(x, this.elementLocation.getPosition().y));
            this.repaintGraphPanel();
        }
    }

    private void setY(int y) {
        if (this.mode == 0 || this.mode == 1 || this.mode == 7 || this.mode == 15 || this.mode == 14) {
            this.elementLocation.setPosition(new Point(this.elementLocation.getPosition().x, y));
            this.repaintGraphPanel();
        }
    }

    private Point setNameOffsetY(int oldY, Node n, ElementLocation el) {
        int nameLocIndex = n.getElementLocations().indexOf(el);
        int oldX = n.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)nameLocIndex).getPosition().x;
        int sheetIndex = this.overlord.IDtoIndex(el.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        if (graphPanel.isLegalLocation(new Point(oldX + el.getPosition().x, oldY + el.getPosition().y))) {
            n.getTextsLocations(GUIManager.locationMoveType.NAME).get(nameLocIndex).getPosition().setLocation(oldX, oldY);
            graphPanel.repaint();
        }
        return n.getTextsLocations(GUIManager.locationMoveType.NAME).get(nameLocIndex).getPosition();
    }

    private Point setNameOffsetX(int oldX, Node n, ElementLocation el) {
        int nameLocIndex = n.getElementLocations().indexOf(el);
        int oldY = n.getTextsLocations((GUIManager.locationMoveType)GUIManager.locationMoveType.NAME).get((int)nameLocIndex).getPosition().y;
        int sheetIndex = this.overlord.IDtoIndex(el.getSheetID());
        GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        if (graphPanel.isLegalLocation(new Point(oldX + el.getPosition().x, oldY + el.getPosition().y))) {
            n.getTextsLocations(GUIManager.locationMoveType.NAME).get(nameLocIndex).getPosition().setLocation(oldX, oldY);
            graphPanel.repaint();
        }
        return n.getTextsLocations(GUIManager.locationMoveType.NAME).get(nameLocIndex).getPosition();
    }

    private void changeName(String newName) {
        if (this.mode == 0 || this.mode == 1 || this.mode == 7 || this.mode == 11 || this.mode == 15 || this.mode == 14) {
            Node node = (Node)this.element;
            node.setName(newName);
            this.repaintGraphPanel();
        }
    }

    private void changeComment(String newComment) {
        this.element.setComment(newComment);
    }

    private void makePortal() {
        if (this.mode == 0 || this.mode == 1 || this.mode == 7 || this.mode == 12 || this.mode == 15 || this.mode == 14) {
            Node node = (Node)this.element;
            node.setPortal(true);
        }
    }

    private void unPortal() {
        Node node;
        if ((this.mode == 0 || this.mode == 1 || this.mode == 7 || this.mode == 12 || this.mode == 15 || this.mode == 14) && (node = (Node)this.element).getElementLocations().size() == 1) {
            node.setPortal(false);
        }
    }

    private void setTokens(int tokens) {
        Place place = (Place)this.element;
        if (this.mode == 0) {
            place.setTokensNumber(tokens);
            if (this.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN == 0) {
                ArrayList<Place> places = this.overlord.getWorkspace().getProject().getPlaces();
                this.overlord.getWorkspace().getProject().accessStatesManager().getStatePN(0).setTokens(places.indexOf(place), tokens);
            }
            this.repaintGraphPanel();
        }
    }

    private void setColorTokens(int tokens, int i) {
        if (this.mode == 0 && this.element instanceof PlaceColored) {
            PlaceColored place = (PlaceColored)this.element;
            switch (i) {
                case 0: {
                    place.setColorTokensNumber(tokens, 0);
                    break;
                }
                case 1: {
                    place.setColorTokensNumber(tokens, 1);
                    break;
                }
                case 2: {
                    place.setColorTokensNumber(tokens, 2);
                    break;
                }
                case 3: {
                    place.setColorTokensNumber(tokens, 3);
                    break;
                }
                case 4: {
                    place.setColorTokensNumber(tokens, 4);
                    break;
                }
                case 5: {
                    place.setColorTokensNumber(tokens, 5);
                    break;
                }
                default: {
                    place.setTokensNumber(tokens);
                }
            }
            this.repaintGraphPanel();
        }
    }

    private void setWeight(int weight, Arc arc) {
        if (this.mode == 2 || this.mode == 16) {
            arc.setWeight(weight);
            this.repaintGraphPanel();
        }
    }

    private void setColorWeight(int weight, Arc arc, int i) {
        if (this.mode == 2 || this.mode == 16) {
            switch (i) {
                case 0: {
                    arc.setColorWeight(weight, i);
                    break;
                }
                case 1: {
                    arc.setColorWeight(weight, i);
                    break;
                }
                case 2: {
                    arc.setColorWeight(weight, i);
                    break;
                }
                case 3: {
                    arc.setColorWeight(weight, i);
                    break;
                }
                case 4: {
                    arc.setColorWeight(weight, i);
                    break;
                }
                case 5: {
                    arc.setColorWeight(weight, i);
                    break;
                }
                default: {
                    arc.setColorWeight(weight, i);
                }
            }
            this.repaintGraphPanel();
        }
    }

    private void setActivationWeight(int weight, Transition trans, int i) {
        if (trans instanceof TransitionColored) {
            TransitionColored transition = (TransitionColored)trans;
            switch (i) {
                case 0: {
                    transition.setRequiredColoredTokens(weight, 0);
                    break;
                }
                case 1: {
                    transition.setRequiredColoredTokens(weight, 1);
                    break;
                }
                case 2: {
                    transition.setRequiredColoredTokens(weight, 2);
                    break;
                }
                case 3: {
                    transition.setRequiredColoredTokens(weight, 3);
                    break;
                }
                case 4: {
                    transition.setRequiredColoredTokens(weight, 4);
                    break;
                }
                case 5: {
                    transition.setRequiredColoredTokens(weight, 5);
                    break;
                }
                default: {
                    transition.setRequiredColoredTokens(weight, 0);
                }
            }
        }
    }

    public void setSimulator(GraphicalSimulator netSim, GraphicalSimulatorXTPN netSimXTPN) {
        this.simulator = netSim;
        this.simulatorXTPN = netSimXTPN;
    }

    public GraphicalSimulator getSimulator() {
        return this.simulator;
    }

    public GraphicalSimulatorXTPN getSimulatorXTPN() {
        return this.simulatorXTPN;
    }

    public void allowOnlySimulationDisruptButtons() {
        this.setEnabledSimulationInitiateButtons(false);
        this.setEnabledSimulationDisruptButtons(true);
    }

    public void allowOnlySimulationInitiateButtons() {
        this.setEnabledSimulationInitiateButtons(true);
        this.setEnabledSimulationDisruptButtons(false);
    }

    private void setEnabledSimulationInitiateButtons(boolean enabled) {
        for (JComponent comp : this.components) {
            if (!(comp instanceof JButton) || comp.getName() == null || !comp.getName().equals("simB1") && !comp.getName().equals("simB2") && !comp.getName().equals("simB3") && !comp.getName().equals("simB4") && !comp.getName().equals("simB5") && !comp.getName().equals("simB6") && !comp.getName().equals("reset")) continue;
            comp.setEnabled(enabled);
        }
    }

    private void setEnabledSimulationDisruptButtons(boolean enabled) {
        for (JComponent comp : this.components) {
            if (!(comp instanceof JButton) || comp.getName() == null || !comp.getName().equals("stop") && !comp.getName().equals("pause")) continue;
            comp.setEnabled(enabled);
        }
    }

    public void allowOnlyUnpauseButton() {
        this.allowOnlySimulationDisruptButtons();
        for (JComponent comp : this.components) {
            if (!(comp instanceof JButton) || comp.getName() == null || !comp.getName().equals("pause")) continue;
            comp.setEnabled(true);
            break;
        }
    }

    public void allowOnlySimulationDisruptButtonsXTPN() {
        this.setEnabledSimulationInitiateButtonsXTPN(false);
        this.setEnabledSimulationDisruptButtonsXTPN(true);
    }

    public void allowOnlySimulationInitiateButtonsXTPN() {
        this.setEnabledSimulationInitiateButtonsXTPN(true);
        this.setEnabledSimulationDisruptButtonsXTPN(false);
    }

    private void setEnabledSimulationInitiateButtonsXTPN(boolean enabled) {
        for (JComponent comp : this.components) {
            if (!(comp instanceof HolmesRoundedButton) || comp.getName() == null || !comp.getName().equals("XTPNstart") && !comp.getName().equals("resetM0button")) continue;
            comp.setEnabled(enabled);
        }
    }

    private void setEnabledSimulationDisruptButtonsXTPN(boolean enabled) {
        for (JComponent comp : this.components) {
            if (!(comp instanceof HolmesRoundedButton) || comp.getName() == null || !comp.getName().equals("XTPNstop") && !comp.getName().equals("XTPNpause")) continue;
            comp.setEnabled(enabled);
        }
    }

    public void allowOnlyUnpauseButtonXTPN() {
        this.allowOnlySimulationDisruptButtonsXTPN();
        for (JComponent comp : this.components) {
            if (!(comp instanceof HolmesRoundedButton) || comp.getName() == null || !comp.getName().equals("XTPNpause")) continue;
            comp.setEnabled(true);
            break;
        }
    }

    public void resetT_invariants() {
        this.t_invariantsMatrix = null;
    }

    public void resetP_invariants() {
        this.p_invariantsMatrix = null;
    }

    public void resetMCT() {
        this.mctGroups = null;
    }

    public void resetClusters() {
        this.clusterColorsData = null;
    }

    public static enum SubWindow {
        SIMULATOR,
        PLACE,
        TRANSITION,
        TIMETRANSITION,
        SPNTRANSITION,
        XTPNTRANSITION,
        XTPNPLACE,
        XARC,
        CTRANSITION,
        META,
        ARC,
        SHEET,
        T_INVARIANTS,
        P_INVARIANTS,
        MCT,
        CLUSTERS,
        KNOCKOUT,
        MCS,
        FIXER,
        QUICKSIM,
        DECOMPOSITION;

    }
}

