/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.dockwindows;

import com.javadocking.dock.SingleDock;
import com.javadocking.dockable.DefaultDockable;
import com.javadocking.dockable.Dockable;
import holmes.clusters.ClusterDataPackage;
import holmes.darkgui.GUIManager;
import holmes.darkgui.dockwindows.HolmesDockWindowsTable;
import holmes.darkgui.dockwindows.SelectionPanel;
import holmes.graphpanel.SelectionActionListener;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JScrollPane;

public class HolmesDockWindow
extends SingleDock {
    private static final long serialVersionUID = -1966643269924197502L;
    private Dockable dockable;
    private GUIManager guiManager;
    private HolmesDockWindowsTable dockWindowPanel;
    private SelectionPanel selectionPanel;
    private JScrollPane scrollPane;
    private DockWindowType type;

    public HolmesDockWindow(DockWindowType propertiesType) {
        this.type = propertiesType;
        this.scrollPane = new JScrollPane();
        this.guiManager = GUIManager.getDefaultGUIManager();
        switch (this.type) {
            case EDITOR: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("NetElement", this.scrollPane, "Net Element"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case SIMULATOR: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Simulator", this.scrollPane, "Simulator"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case SELECTOR: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Selection", this.scrollPane, "Selection"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case T_INVARIANTS: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Transition_Invariants", this.scrollPane, "T-inv"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case P_INVARIANTS: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Place_Invariants", this.scrollPane, "P-inv"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case MctANALYZER: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("MCT_Groups", this.scrollPane, "MCT"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case ClusterSELECTOR: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Clusters_Selection", this.scrollPane, "Clusters"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case MCSselector: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("MCS_selector", this.scrollPane, "MCS"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case FIXNET: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Fix_selector", this.scrollPane, "Fix"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case QuickSim: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Quick_simulator", this.scrollPane, "qSim"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case Knockout: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Knockout_selector", this.scrollPane, "Knockout"), GUIManager.getDefaultGUIManager().getDockingListener()));
                break;
            }
            case DECOMPOSITION: {
                this.setDockable(GUIManager.externalWithListener(new DefaultDockable("Decomposition", this.scrollPane, "DECOMPOSITION"), GUIManager.getDefaultGUIManager().getDockingListener()));
            }
        }
        Point position = new Point(0, 0);
        this.addDockable(this.getDockable(), position, position);
        switch (this.type) {
            case SELECTOR: {
                this.setSelectionPanel(new SelectionPanel());
                this.scrollPane.getViewport().add(this.getSelectionPanel());
                break;
            }
            case FIXNET: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.FIXER, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case QuickSim: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.QUICKSIM, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case DECOMPOSITION: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.DECOMPOSITION, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
            }
        }
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    private void setDockable(Dockable dockable) {
        this.dockable = dockable;
    }

    public void createSimulatorProperties(boolean XTPN) {
        if (this.type == DockWindowType.SIMULATOR) {
            GraphicalSimulator netSim = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getSimulator();
            GraphicalSimulatorXTPN netSimXTPN = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getSimulatorXTPN();
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.SIMULATOR, netSim, netSimXTPN, XTPN));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showT_invBoxWindow(ArrayList<ArrayList<Integer>> t_invariants) {
        if (this.type == DockWindowType.T_INVARIANTS) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.T_INVARIANTS, t_invariants));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showP_invBoxWindow(ArrayList<ArrayList<Integer>> p_invariants) {
        if (this.type == DockWindowType.P_INVARIANTS) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.P_INVARIANTS, p_invariants));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showDecompositionBoxWindows() {
        if (this.type == DockWindowType.DECOMPOSITION) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.DECOMPOSITION, new Object[0]));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showClusterSelector(ClusterDataPackage data) {
        if (this.type == DockWindowType.ClusterSELECTOR) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.CLUSTERS, data));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showMCT(ArrayList<ArrayList<Transition>> mctGroups) {
        if (this.type == DockWindowType.MctANALYZER) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.MCT, mctGroups));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showMCS() {
        if (this.type == DockWindowType.MCSselector) {
            MCSDataMatrix mcsData = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore();
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.MCS, mcsData));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showKnockout(ArrayList<ArrayList<Integer>> knockoutData) {
        if (this.type == DockWindowType.Knockout) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.KNOCKOUT, knockoutData));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void updateSimulatorProperties() {
        if (this.type == DockWindowType.SIMULATOR) {
            // empty if block
        }
    }

    public void selectElement(SelectionActionListener.SelectionActionEvent e) {
        if (e.getActionType() == SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_ONE) {
            if (e.getElementLocationGroup().size() > 0) {
                Node n = e.getElementLocation().getParentNode();
                if (n.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                    if (n instanceof PlaceXTPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.XTPNPLACE, n, e.getElementLocation()));
                    } else {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.PLACE, n, e.getElementLocation()));
                    }
                } else if (n.getType() == PetriNetElement.PetriNetElementType.META) {
                    this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.META, n, e.getElementLocation()));
                } else if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    if (((Transition)n).getTransType() == Transition.TransitionType.PN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.TRANSITION, n, e.getElementLocation()));
                    } else if (((Transition)n).getTransType() == Transition.TransitionType.TPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.TIMETRANSITION, n, e.getElementLocation()));
                    } else if (((Transition)n).getTransType() == Transition.TransitionType.SPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.SPNTRANSITION, n, e.getElementLocation()));
                    } else if (n instanceof TransitionXTPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.XTPNTRANSITION, n, e.getElementLocation()));
                    } else if (((Transition)n).getTransType() == Transition.TransitionType.CPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.CTRANSITION, n, e.getElementLocation()));
                    }
                }
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
            } else if (e.getArcGroup().size() > 0) {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.ARC, e.getArc()));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
            }
        } else if (e.getActionType() == SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_SHEET) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.SHEET, this.guiManager.getWorkspace().getSheets().get(this.guiManager.getWorkspace().getIndexOfId(e.getSheetId()))));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public HolmesDockWindowsTable getCurrentDockWindow() {
        return this.dockWindowPanel;
    }

    public void setCurrentDockWindow(HolmesDockWindowsTable properties) {
        this.dockWindowPanel = properties;
    }

    public SelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    private void setSelectionPanel(SelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
    }

    public static enum DockWindowType {
        EDITOR,
        SIMULATOR,
        SELECTOR,
        T_INVARIANTS,
        P_INVARIANTS,
        ClusterSELECTOR,
        MctANALYZER,
        MCSselector,
        Knockout,
        FIXNET,
        QuickSim,
        DECOMPOSITION;

    }
}

