/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import com.javadocking.dock.CompositeDock;
import com.javadocking.dockable.Dockable;
import holmes.analyse.MCTCalculator;
import holmes.clusters.ClusterDataPackage;
import holmes.darkgui.GUIManager;
import holmes.darkgui.dockwindows.HolmesDockWindowsTable;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import holmes.workspace.Workspace;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class GUIReset {
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private boolean t_invGenerated = false;
    private boolean p_invGenerated = false;
    private boolean mctGenerated = false;
    private boolean clustersGenerated = false;
    private boolean subNetGenerated = false;

    public void clearGraphColors() {
        this.overlord.getWorkspace().getProject().resetNetColors();
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        this.overlord.simSettings.quickSimToken = false;
    }

    public boolean newProjectInitiated() {
        if (this.isSimulatorActiveWarning("Please stop simulation completely before continuing.", "Warning")) {
            return false;
        }
        if (this.isXTPNSimulatorActiveWarning("Please stop XTPN simulation completely before continuing.", "Warning")) {
            return false;
        }
        boolean hasSomethingChanged = this.overlord.getNetChangeStatus();
        if (hasSomethingChanged) {
            boolean savingStatus;
            Object[] options = new Object[]{"Continue", "Save and continue", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Net has been changed since the last save. Continue and clear all data?", "Data clear warning", 0, 3, null, options, options[2]);
            if (n == 2) {
                return false;
            }
            if (n == 1 && !(savingStatus = this.overlord.io.saveAsGlobal())) {
                return false;
            }
        }
        PetriNet pNet = this.overlord.getWorkspace().getProject();
        this.overlord.log("Net data deletion initiated.", "text", true);
        for (GraphPanel gp : pNet.getGraphPanels()) {
            gp.getSelectionManager().forceDeselectAllElements();
        }
        this.clearAll();
        return true;
    }

    public void emergencyRestart() {
        this.overlord.log("Something went terribly wrong. Holmes emergency restart initiated.", "error", true);
        this.clearAll();
    }

    private void clearAll() {
        PetriNet pNet = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        this.overlord.log("Net data deletion initiated.", "text", true);
        pNet.resetData();
        pNet.setProjectType(PetriNet.GlobalNetType.PN);
        pNet.setT_InvMatrix(null, false);
        pNet.setP_InvMatrix(null);
        pNet.setMCTMatrix(null, false);
        pNet.accessMCTnames().clear();
        pNet.accessStatesManager().resetPN(true);
        pNet.accessStatesManager().removeAllMultisets_M(true);
        pNet.accessSSAmanager().reset(false);
        pNet.accessFiringRatesManager().reset(false);
        pNet.setMCSdataCore(new MCSDataMatrix());
        this.overlord.simSettings.reset();
        pNet.clearSimKnockoutData();
        pNet.resetComm();
        pNet.setMCTanalyzer(new MCTCalculator(pNet));
        pNet.setSimulator(new GraphicalSimulator(SimulatorGlobals.SimNetType.BASIC, pNet));
        pNet.setSimulatorXTPN(new GraphicalSimulatorXTPN(SimulatorGlobals.SimNetType.XTPN, pNet));
        pNet.setSimulationActive(false);
        pNet.setFileName("");
        this.overlord.simSettings.currentStep = 0L;
        this.overlord.simSettings.currentTime = 0.0;
        this.overlord.accessStateSimulatorWindow().resetSimWindow();
        this.overlord.accessStateSimulatorXTPNWindow().resetSimWindow();
        this.overlord.accessClusterWindow().resetWindow();
        this.overlord.getSimulatorBox().createSimulatorProperties(false);
        this.overlord.resetModuls();
        pNet.repaintAllGraphPanels();
        Workspace workspace = this.overlord.getWorkspace();
        int dockableSize = workspace.getDockables().size();
        CompositeDock parentOfFirst = workspace.getDockables().get(0).getDock().getParentDock();
        for (int d = 0; d < dockableSize; ++d) {
            Dockable dockable = workspace.getDockables().get(d);
            String x = dockable.getID();
            if (x.equals("Sheet 0")) continue;
            workspace.deleteTab(dockable, true);
            --d;
            --dockableSize;
            if (!dockable.getDock().getParentDock().equals(parentOfFirst)) continue;
            this.overlord.globalSheetsList.remove(dockable);
        }
        this.reset2ndOrderData(false);
        IdGenerator.resetIDgenerator();
        GUIManager.getDefaultGUIManager().getFrame().setTitle("Holmes " + GUIManager.getDefaultGUIManager().getSettingsManager().getValue("holmes_version"));
        this.overlord.cleanDockables();
        this.overlord.markNetSaved();
    }

    public void reset2ndOrderData(boolean clearWindows) {
        PetriNet pNet = this.overlord.getWorkspace().getProject();
        if (clearWindows) {
            this.overlord.simSettings.currentStep = 0L;
            this.overlord.simSettings.currentTime = 0.0;
            this.overlord.accessStateSimulatorWindow().resetSimWindow();
            this.overlord.accessStateSimulatorXTPNWindow().resetSimWindow();
            this.overlord.accessClusterWindow().resetWindow();
        }
        if (this.t_invGenerated) {
            this.overlord.accessNetTablesWindow().resetT_invData();
            this.resetCommunicationProtocol();
            pNet.setT_InvMatrix(null, false);
            pNet.getMCSdataCore().resetMSC();
            if (this.overlord.getT_invBox().getCurrentDockWindow() != null) {
                this.overlord.getT_invBox().getCurrentDockWindow().resetT_invariants();
                this.overlord.getT_invBox().getCurrentDockWindow().removeAll();
            }
            this.overlord.getT_invBox().setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.T_INVARIANTS, pNet.getT_InvMatrix()));
            this.overlord.getT_invBox().validate();
            this.overlord.getT_invBox().repaint();
            this.t_invGenerated = false;
            this.overlord.log("T-invariants data removed from memory.", "text", true);
        }
        if (this.p_invGenerated) {
            this.resetCommunicationProtocol();
            pNet.setP_InvMatrix(null);
            if (this.overlord.getP_invBox().getCurrentDockWindow() != null) {
                this.overlord.getP_invBox().getCurrentDockWindow().resetP_invariants();
                this.overlord.getP_invBox().getCurrentDockWindow().removeAll();
            }
            this.overlord.getP_invBox().setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.P_INVARIANTS, pNet.getP_InvMatrix()));
            this.overlord.getP_invBox().validate();
            this.overlord.getP_invBox().repaint();
            this.p_invGenerated = false;
            this.overlord.log("P-invariants data removed from memory.", "text", true);
        }
        if (this.mctGenerated) {
            if (this.overlord.getMctBox().getCurrentDockWindow() != null) {
                this.overlord.getMctBox().getCurrentDockWindow().removeAll();
                this.overlord.getMctBox().getCurrentDockWindow().resetMCT();
            }
            this.overlord.getMctBox().setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.MCT, new ArrayList()));
            this.overlord.getMctBox().validate();
            this.overlord.getMctBox().repaint();
            pNet.setMCTMatrix(null, false);
            pNet.accessMCTnames().clear();
            this.mctGenerated = false;
            this.overlord.log("MCT data removed from memory.", "text", true);
        }
        if (this.clustersGenerated) {
            if (this.overlord.getClusterSelectionBox().getCurrentDockWindow() != null) {
                this.overlord.getClusterSelectionBox().getCurrentDockWindow().removeAll();
                this.overlord.getClusterSelectionBox().getCurrentDockWindow().resetClusters();
            }
            this.overlord.getClusterSelectionBox().setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.CLUSTERS, new ClusterDataPackage()));
            this.overlord.getClusterSelectionBox().validate();
            this.overlord.getClusterSelectionBox().repaint();
            this.clustersGenerated = false;
            this.overlord.log("Clustering data removed from memory.", "text", true);
        }
        if (this.subNetGenerated) {
            this.subNetGenerated = false;
            this.overlord.log("Decomposition data removed from memory.", "text", true);
        }
    }

    public void resetCommunicationProtocol() {
        this.overlord.getWorkspace().getProject().resetComm();
    }

    public void setT_invariantsStatus(boolean status) {
        this.t_invGenerated = status;
    }

    public void setP_invariantsStatus(boolean status) {
        this.p_invGenerated = status;
    }

    public void setMCTStatus(boolean status) {
        this.mctGenerated = status;
    }

    public void setClustersStatus(boolean status) {
        this.clustersGenerated = status;
    }

    public void setDecompositionStatus(boolean status) {
        this.subNetGenerated = status;
    }

    public boolean isSimulatorActive() {
        GraphicalSimulator ns = this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator();
        return ns.getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED;
    }

    public boolean isSimulatorActiveWarning(String msg, String msgTitle) {
        GraphicalSimulator obj = GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator();
        if (obj instanceof GraphicalSimulator) {
            if (obj.getSimulatorStatus() == GraphicalSimulator.SimulatorMode.STOPPED) {
                return false;
            }
            JOptionPane.showMessageDialog(null, msg, msgTitle, 2);
            return true;
        }
        return false;
    }

    public boolean isXTPNSimulatorActiveWarning(String msg, String msgTitle) {
        GraphicalSimulatorXTPN obj = GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulatorXTPN();
        if (obj instanceof GraphicalSimulatorXTPN) {
            if (obj.getsimulatorStatusXTPN() == GraphicalSimulatorXTPN.SimulatorModeXTPN.STOPPED) {
                return false;
            }
            JOptionPane.showMessageDialog(null, msg, msgTitle, 2);
            return true;
        }
        return false;
    }
}

