/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import holmes.adam.mct.Runner;
import holmes.analyse.InvariantsCalculator;
import holmes.darkgui.GUIManager;
import holmes.files.clusters.Rprotocols;
import holmes.files.io.ProjectReader;
import holmes.files.io.ProjectWriter;
import holmes.graphpanel.EditorResources;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.HolmesFileView;
import holmes.utilities.Tools;
import holmes.varia.Check;
import holmes.workspace.ExtensionFileFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GUIOperations {
    GUIManager overlord = GUIManager.getDefaultGUIManager();

    public GUIOperations() {
    }

    public GUIOperations(GUIManager mastah) {
        this();
        this.overlord = mastah;
    }

    public void importNetwork() {
        String lastPath = this.overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("All supported Snoopy files", new String[]{"SPPED", "SPEPT", "SPTPT", "PN"}), new ExtensionFileFilter("Snoopy Petri Net file (.spped), (.pn)", new String[]{"SPPED", "PN"}), new ExtensionFileFilter("Snoopy Extended PN file (.spept), (.xpn)", new String[]{"SPEPT", "XPN"}), new ExtensionFileFilter("Snoopy Time PN file (.sptpt)", new String[]{"SPTPT"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, "Select PN", "Select petri net file", "");
        if (selectedFile.equals("")) {
            return;
        }
        File file = new File(selectedFile);
        if (!file.exists()) {
            return;
        }
        boolean status = this.overlord.getWorkspace().getProject().loadFromFile(file.getPath());
        if (status) {
            this.overlord.setLastPath(file.getParentFile().getPath());
            this.overlord.getSimulatorBox().createSimulatorProperties(false);
            GUIManager.getDefaultGUIManager().getFrame().setTitle("Holmes " + GUIManager.getDefaultGUIManager().getSettingsManager().getValue("holmes_version") + "  " + Tools.getFileName(file));
        }
    }

    public void selectAndOpenHolmesProject() {
        String lastPath = this.overlord.getLastPath();
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter holmesProjFilter = new ExtensionFileFilter("Holmes Project file (.project)", new String[]{"PROJECT"});
        ExtensionFileFilter projFilter = new ExtensionFileFilter("Old project file (.apf)", new String[]{"APF"});
        ExtensionFileFilter abyssFilter = new ExtensionFileFilter("Abyss Petri Net (.abyss)", new String[]{"ABYSS"});
        fc.setFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(projFilter);
        fc.addChoosableFileFilter(abyssFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showOpenDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String extension = fc.getFileFilter().getDescription();
            if (fc.getSelectedFile().toString().equals("")) {
                return;
            }
            if (!file.exists()) {
                return;
            }
            boolean proceed = this.overlord.reset.newProjectInitiated();
            if (!proceed) {
                return;
            }
            boolean status = false;
            if (extension.toLowerCase().contains(".apf") || extension.toLowerCase().contains(".project")) {
                ProjectReader pRdr = new ProjectReader();
                status = pRdr.readProject(file.getPath());
                this.overlord.setLastPath(file.getParentFile().getPath());
                this.overlord.subnetsGraphics.resizePanels();
            } else if (extension.toLowerCase().contains(".abyss")) {
                status = this.overlord.getWorkspace().getProject().loadFromFile(file.getPath());
                this.overlord.setLastPath(file.getParentFile().getPath());
            }
            if (status) {
                this.overlord.log("Reading project file succcessful.", "text", true);
                GUIManager.getDefaultGUIManager().getFrame().setTitle("Holmes " + GUIManager.getDefaultGUIManager().getSettingsManager().getValue("holmes_version") + "  " + Tools.getFileName(file));
            }
        }
    }

    public void exportAsPNT() {
        String lastPath = this.overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("INA PNT file (.pnt)", new String[]{"PNT"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "", this.overlord.getWorkspace().getProject().getFileName());
        if (selectedFile.equals("")) {
            return;
        }
        File file = new File(selectedFile);
        String fileExtension = ".pnt";
        if (selectedFile.toLowerCase().contains(".pnt")) {
            fileExtension = "";
        }
        this.overlord.getWorkspace().getProject().saveAsPNT(file.getPath() + fileExtension);
        this.overlord.setLastPath(file.getParentFile().getPath());
    }

    public boolean exportGeneratedInvariants(boolean t_inv) {
        String lastPath = this.overlord.getLastPath();
        int result = 0;
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter inaFilter = new ExtensionFileFilter("INA Invariants File (.inv)", new String[]{"INV"});
        ExtensionFileFilter charlieFilter = new ExtensionFileFilter("Charlie Invariants File (.inv)", new String[]{"INV"});
        ExtensionFileFilter csvFilter = new ExtensionFileFilter("Comma Separated Values (.csv)", new String[]{"CSV"});
        fc.setFileFilter(inaFilter);
        fc.addChoosableFileFilter(inaFilter);
        fc.addChoosableFileFilter(charlieFilter);
        fc.addChoosableFileFilter(csvFilter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String description = fc.getFileFilter().getDescription();
            if (description.contains("INA")) {
                String fileExtension = file.getPath().toLowerCase().contains(".inv") ? "" : ".inv";
                result = this.overlord.getWorkspace().getProject().saveInvariantsToInaFormat(file.getPath() + fileExtension, t_inv);
            } else if (description.contains("Comma")) {
                String fileExtension = file.getPath().toLowerCase().contains(".csv") ? "" : ".csv";
                result = this.overlord.getWorkspace().getProject().saveInvariantsToCSV(file.getPath() + fileExtension, false, t_inv);
            } else if (description.contains("Charlie")) {
                String fileExtension = file.getPath().toLowerCase().contains(".inv") ? "" : ".inv";
                result = this.overlord.getWorkspace().getProject().saveInvariantsToCharlie(file.getPath() + fileExtension, t_inv);
            }
        }
        return result == 0;
    }

    public void exportProjectToImage() {
        String lastPath = this.overlord.getLastPath();
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter pngFilter = new ExtensionFileFilter("Portable Network Graphics (.png)", new String[]{"png"});
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter("Bitmap Image File (.bmp)", new String[]{"bmp"});
        ExtensionFileFilter jpegFilter = new ExtensionFileFilter("JPEG Image File (.jpeg)", new String[]{"jpeg"});
        ExtensionFileFilter jpgFilter = new ExtensionFileFilter("JPEG Image File (jpg)", new String[]{"jpg"});
        fc.setFileFilter(pngFilter);
        fc.addChoosableFileFilter(pngFilter);
        fc.addChoosableFileFilter(bmpFilter);
        fc.addChoosableFileFilter(jpegFilter);
        fc.addChoosableFileFilter(jpgFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String ext = "";
            String extension = fc.getFileFilter().getDescription();
            if (extension.toLowerCase().contains(".png")) {
                ext = ".png";
            }
            if (extension.toLowerCase().contains(".bmp")) {
                ext = ".bmp";
            }
            if (extension.toLowerCase().contains(".jpeg") || extension.contains(".jpg")) {
                ext = ".jpeg";
            }
            Object fullPath = "";
            for (BufferedImage bi : this.overlord.getWorkspace().getProject().getImagesFromGraphPanels()) {
                try {
                    String ext2 = "";
                    String path = file.getPath();
                    if (ext.equals(".png") && !path.contains(".png")) {
                        ext2 = ".png";
                    }
                    if (ext.equals(".bmp") && !file.getPath().contains(".bmp")) {
                        ext2 = ".bmp";
                    }
                    if (ext.equals(".jpeg") && !file.getPath().contains(".jpeg")) {
                        ext2 = ".jpeg";
                    }
                    if (ext.equals(".jpeg") && !file.getPath().contains(".jpg")) {
                        ext2 = ".jpg";
                    }
                    String fileName = file.getName();
                    String pathOutput = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)) + "//";
                    fullPath = pathOutput + fileName + ext2;
                    ImageIO.write((RenderedImage)bi, ext.substring(1), new File((String)fullPath));
                }
                catch (IOException ex) {
                    this.overlord.log("Unable to extract net as image. Cannot save to file " + (String)fullPath, "error", true);
                }
            }
            this.overlord.setLastPath(file.getParentFile().getPath());
        }
    }

    public boolean saveAsAbyssFile() {
        boolean status = false;
        String lastPath = this.overlord.getLastPath();
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter holmesProjFilter = new ExtensionFileFilter("Holmes Project file (.project)", new String[]{"PROJECT"});
        ExtensionFileFilter projFilter = new ExtensionFileFilter("Old Project file (.apf)", new String[]{"APF"});
        ExtensionFileFilter abyssFilter = new ExtensionFileFilter("Abyss Petri Net (.abyss)", new String[]{"ABYSS"});
        fc.setFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(projFilter);
        fc.addChoosableFileFilter(abyssFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String extension = fc.getFileFilter().getDescription();
            if (extension.toLowerCase().contains(".project")) {
                if (!Tools.overwriteDecision(file.getPath())) {
                    return false;
                }
                String fileExtension = ".project";
                if (file.getPath().toLowerCase().contains(".project")) {
                    fileExtension = "";
                }
                ProjectWriter pWrt = new ProjectWriter();
                status = pWrt.writeProject(file.getPath() + fileExtension);
                this.overlord.setLastPath(file.getParentFile().getPath());
                return status;
            }
            if (extension.toLowerCase().contains(".apf")) {
                if (!Tools.overwriteDecision(file.getPath())) {
                    return false;
                }
                String fileExtension = ".apf";
                if (file.getPath().toLowerCase().contains(".apf")) {
                    fileExtension = "";
                }
                ProjectWriter pWrt = new ProjectWriter();
                status = pWrt.writeProject(file.getPath() + fileExtension);
                this.overlord.setLastPath(file.getParentFile().getPath());
                return status;
            }
            if (extension.toLowerCase().contains(".abyss")) {
                if (!Tools.overwriteDecision(file.getPath())) {
                    return false;
                }
                String fileExtension = ".abyss";
                if (file.getPath().toLowerCase().contains(".abyss")) {
                    fileExtension = "";
                }
                status = this.overlord.getWorkspace().getProject().saveAsAbyss(file.getPath() + fileExtension);
                this.overlord.setLastPath(file.getParentFile().getPath());
                return status;
            }
        }
        return status;
    }

    public boolean saveAsGlobal() {
        FileFilter[] filters;
        String lastPath = this.overlord.getLastPath();
        String selectedFile = Tools.selectNetSaveFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("All supported Snoopy files", new String[]{"SPPED", "SPEPT", "SPTPT"}), new ExtensionFileFilter("Snoopy Petri Net (.spped)", new String[]{"SPPED"}), new ExtensionFileFilter("Snoopy Extended Petri Net (.spept)", new String[]{"SPEPT"}), new ExtensionFileFilter("Snoopy Time Petri Net (.sptpt)", new String[]{"SPTPT"}), new ExtensionFileFilter("Holmes Project File (.project)", new String[]{"PROJECT"}), new ExtensionFileFilter("INA PNT format (.pnt)", new String[]{"PNT"})}, "Save", "", this.overlord.getWorkspace().getProject().getFileName());
        if (selectedFile.equals("")) {
            return false;
        }
        if (!Tools.overwriteDecision(selectedFile)) {
            return false;
        }
        String extension = Tools.lastExtension;
        if (extension == null || extension.equals("")) {
            JOptionPane.showMessageDialog(null, "File choosing error. Cannot proceed.", "Error", 0);
            this.overlord.log("File choosing error. No extension: " + extension, "error", true);
            return false;
        }
        if ((extension = this.checkFileFormatCorrectness(extension)).contains(".spped")) {
            File file = new File(selectedFile);
            String fileExtension = ".spped";
            if (selectedFile.toLowerCase().contains(".spped")) {
                fileExtension = "";
            }
            boolean status = this.overlord.getWorkspace().getProject().saveAsSPPED(file.getPath() + fileExtension);
            this.overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".spept")) {
            File file = new File(selectedFile);
            String fileExtension = ".spept";
            if (selectedFile.toLowerCase().contains(".spept")) {
                fileExtension = "";
            }
            boolean status = this.overlord.getWorkspace().getProject().saveAsSPEPT(file.getPath() + fileExtension);
            this.overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".sptpt")) {
            File file = new File(selectedFile);
            String fileExtension = ".sptpt";
            if (selectedFile.toLowerCase().contains(".sptpt")) {
                fileExtension = "";
            }
            boolean status = this.overlord.getWorkspace().getProject().saveAsSPTPT(file.getPath() + fileExtension);
            this.overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".project")) {
            File file = new File(selectedFile);
            if (!Tools.overwriteDecision(file.getPath())) {
                return false;
            }
            String fileExtension = ".project";
            if (file.getPath().toLowerCase().contains(".project")) {
                fileExtension = "";
            }
            ProjectWriter pWrt = new ProjectWriter();
            boolean status = pWrt.writeProject(file.getPath() + fileExtension);
            this.overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".pnt")) {
            File file = new File(selectedFile);
            String fileExtension = ".pnt";
            if (selectedFile.toLowerCase().contains(".pnt")) {
                fileExtension = "";
            }
            boolean status = this.overlord.getWorkspace().getProject().saveAsPNT(file.getPath() + fileExtension);
            this.overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        return false;
    }

    private String checkFileFormatCorrectness(String extension) {
        String netRealName;
        String fileFormat;
        if (this.overlord.getSettingsManager().getValue("editorExportCheckAndWarning").equals("0")) {
            return extension;
        }
        if (extension.contains(".project")) {
            return extension;
        }
        if (extension.contains("all supported")) {
            Tools.lastExtension = extension = "snoopy petri net (.spped)";
        }
        PetriNet.GlobalNetType netType = Check.getSuggestedNetType();
        String additionalWhining = "";
        if (netType != null) {
            PetriNet.GlobalFileNetType suggestion = Check.suggestesFileFormat(netType);
            fileFormat = Check.getExtension(suggestion);
            fileFormat = fileFormat.toLowerCase();
            netRealName = Check.getNetName(netType);
            if (Check.isHierarchical()) {
                additionalWhining = "\nWarning: hierarchical net structure detected. Using Holmes project is strongly advised.\nOther save format will most probably fail.\n";
            }
        } else {
            netRealName = "Unknown";
            fileFormat = "Holmes Project file";
            additionalWhining = "Warning. There has been a problem detecting type of the Petri net.\nPlease advise authors and in the meantime: Holmes project file is STRONGLY RECOMMENDED.";
        }
        if (extension.toLowerCase().contains(fileFormat) && additionalWhining.length() == 0) {
            return extension;
        }
        if (fileFormat.equals(".project")) {
            fileFormat = "Holmes project file (.project)";
        }
        Object[] options = new Object[]{"Use selected anyway", "Use suggested format", "Save as project", "Cancel save"};
        int n = JOptionPane.showOptionDialog(null, "Selected net file format: " + extension + "\nNet real type: " + netRealName + "\nSuggested file format: " + fileFormat + "\n\nSelected format will not contain all features of the current Petri Net. Resulting file\nwill contain reduced net or will be corrupted.\n" + additionalWhining, "Invalid out net file format", 0, 2, null, options, options[0]);
        if (n == 0) {
            return extension;
        }
        if (n == 1) {
            return "." + fileFormat;
        }
        if (n == 2) {
            return ".project";
        }
        return "";
    }

    public boolean loadExternalAnalysis(boolean t_inv) {
        String lastPath = this.overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{t_inv ? new ExtensionFileFilter("T-invariants file (.inv)", new String[]{"INV"}) : new ExtensionFileFilter("P-invariants file (.inv)", new String[]{"INV"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, "Load invariants", "Select invariant file", "");
        if (selectedFile.equals("")) {
            return false;
        }
        File file = new File(selectedFile);
        if (!file.exists()) {
            return false;
        }
        PetriNet project = this.overlord.getWorkspace().getProject();
        boolean status = project.loadTPinvariantsFromFile(file.getPath(), t_inv);
        if (!status) {
            return false;
        }
        if (t_inv) {
            this.overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
            this.overlord.getSimulatorBox().createSimulatorProperties(false);
        } else {
            this.overlord.getP_invBox().showP_invBoxWindow(project.getP_InvMatrix());
        }
        return true;
    }

    public void generateINAinvariants(boolean t_inv) {
        String stars = "************************************************************************************************";
        String toolPath = this.overlord.getToolPath();
        File tmpPNTfile = new File(toolPath + "siec.pnt");
        String x = tmpPNTfile.getPath();
        this.overlord.getWorkspace().getProject().saveAsPNT(x);
        long size = tmpPNTfile.length();
        if (size < 154L) {
            String msg = "Net saving as .pnt file failed. There may be problems with file: " + x + " or there is no network yet.";
            JOptionPane.showMessageDialog(null, msg, "Missing net or file", 0);
            this.overlord.log(msg, "error", true);
            this.overlord.accessInvariantsWindow().setGeneratorStatus(false);
            return;
        }
        File inaExe = new File(toolPath + "INAwin32.exe");
        File batFile = new File(toolPath + "ina.bat");
        File commandFile = new File(toolPath + "COMMAND.ina");
        if (!t_inv) {
            commandFile = new File(toolPath + "COMMANDp.ina");
        }
        String holmesPath = this.overlord.getHolmesPath();
        if (inaExe.exists() && commandFile.exists()) {
            FileFilter[] filters;
            String selectedFile;
            try {
                JOptionPane.showMessageDialog(null, "INAwin32.exe will now start. This may take a while. Click OK and please wait.\nWhen console shows in, please type Y, then N after invariants are computed.", "Please wait", 1);
                this.overlord.log(stars, "text", false);
                this.overlord.log("Activating INAwin32.exe. Please wait, this may take a few seconds due to OS delays.", "text", true);
                Tools.copyFileByPath(inaExe.getPath(), holmesPath + "\\INAwin32.exe");
                Tools.copyFileByPath(batFile.getPath(), holmesPath + "\\ina.bat");
                Tools.copyFileByPath(commandFile.getPath(), holmesPath + "\\COMMAND.ina");
                Tools.copyFileByPath(tmpPNTfile.getPath(), holmesPath + "\\siec.pnt");
                tmpPNTfile.delete();
                String[] command = new String[]{"ina.bat"};
                ProcessBuilder b = new ProcessBuilder(command);
                Process proc = b.start();
                BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (in.readLine() != null) {
                }
                Thread.sleep(200L);
                proc.destroy();
                new File(holmesPath + "\\INAwin32.exe").delete();
                new File(holmesPath + "\\ina.bat").delete();
                new File(holmesPath + "\\COMMAND.ina").delete();
                new File(holmesPath + "\\siec.pnt").delete();
                File t1 = new File(holmesPath + "\\SESSION.ina");
                File t2 = new File(holmesPath + "\\OPTIONS.ina");
                File t3 = new File(holmesPath + "\\INVARI.hlp");
                if (t1.exists()) {
                    t1.delete();
                }
                if (t2.exists()) {
                    t2.delete();
                }
                if (t3.exists()) {
                    t3.delete();
                }
                this.overlord.log("INAwin32.exe process terminated. Reading results into network now.", "text", true);
            }
            catch (Exception e) {
                String msg = "I/O operation: activating INAwin32.exe failed.";
                JOptionPane.showMessageDialog(null, msg, "Critical error", 0);
                this.overlord.log(msg, "error", true);
                this.overlord.log(stars, "text", false);
                this.overlord.accessInvariantsWindow().setGeneratorStatus(false);
                return;
            }
            File invariantsFile = new File("siec.inv");
            if (!invariantsFile.exists()) {
                String msg = "No invariants file - using INAwin32.exe unsuccessful.";
                JOptionPane.showMessageDialog(null, msg, "Critical error", 0);
                this.overlord.log(msg, "error", true);
                this.overlord.accessInvariantsWindow().setGeneratorStatus(false);
                return;
            }
            PetriNet project = this.overlord.getWorkspace().getProject();
            boolean status = project.loadTPinvariantsFromFile(invariantsFile.getPath(), t_inv);
            if (!status) {
                return;
            }
            if (t_inv) {
                this.overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
                this.overlord.getSimulatorBox().createSimulatorProperties(false);
            } else {
                this.overlord.getP_invBox().showP_invBoxWindow(project.getP_InvMatrix());
            }
            String lastPath = this.overlord.getLastPath();
            Object[] options = new Object[]{"Save .inv file", "No, thanks"};
            int n = JOptionPane.showOptionDialog(null, "Do you want to save generated .inv file?", "Save the invariants?", 0, 3, null, options, options[0]);
            if (n == 0 && !(selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("INA Invariants file (.inv)", new String[]{"INV"})}, "Save", "Select invariants target path", "")).equals("")) {
                File file = new File(selectedFile);
                String ext = "";
                if (!file.getPath().contains(".inv")) {
                    ext = ".inv";
                }
                File properName = new File(file.getPath() + ext);
                Tools.copyFileDirectly(invariantsFile, properName);
            }
            this.overlord.log("Invariants generation successful.", "text", true);
            this.overlord.log(stars, "text", false);
            invariantsFile.delete();
            this.overlord.accessInvariantsWindow().setGeneratorStatus(false);
        } else {
            this.overlord.accessInvariantsWindow().setGeneratorStatus(false);
            String msg = "Missing executables in the tools directory. Required: INAwin32.exe, ina.bat and COMMAND.ina";
            JOptionPane.showMessageDialog(null, msg, "Missing files", 0);
            this.overlord.log(msg, "error", true);
        }
    }

    public void fastGenerateTinvariants() {
        boolean status = this.overlord.accessInvariantsWindow().isGeneratorWorking;
        if (status) {
            JOptionPane.showMessageDialog(null, "Invariants generation already in progress.", "Generator working", 2);
        } else {
            InvariantsCalculator invGenerator = new InvariantsCalculator(true);
            Thread myThread = new Thread(invGenerator);
            myThread.start();
        }
    }

    public void generateSimpleMCTFile() {
        String filePath = this.overlord.getTmpPath() + "input.csv";
        int result = this.overlord.getWorkspace().getProject().saveInvariantsToCSV(filePath, true, true);
        if (result == -1) {
            String msg = "Exporting net into CSV file failed.";
            JOptionPane.showMessageDialog(null, msg, "Write error", 0);
            this.overlord.log(msg, "error", true);
            return;
        }
        try {
            this.overlord.log("Starting MCT generator.", "text", true);
            Runner mctRunner = new Runner();
            String[] args = new String[]{filePath};
            mctRunner.activate(args);
            String lastPath = this.overlord.getLastPath();
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("MCT sets file (.mct)", new String[]{"MCT"})};
            String selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "Select MCT target path", "");
            if (selectedFile.equals("")) {
                File csvFile = new File(filePath);
                csvFile.delete();
                JOptionPane.showMessageDialog(null, "MCT file created", "Operation successful.", 1);
                this.overlord.log("MCT file saved. Path: " + this.overlord.getTmpPath() + "input.csv.analysed.txt", "text", true);
            } else {
                File file = new File(selectedFile);
                String ext = "";
                if (!file.getPath().contains(".mct")) {
                    ext = ".mct";
                }
                File properName = new File(file.getPath() + ext);
                File generatedMCT = new File(this.overlord.getTmpPath() + "input.csv.analysed.txt");
                Tools.copyFileDirectly(generatedMCT, properName);
                generatedMCT.delete();
                File csvFile = new File(filePath);
                csvFile.delete();
                JOptionPane.showMessageDialog(null, "MCT file created", "Operation successful.", 1);
                this.overlord.log("MCT file saved. Path: " + filePath, "text", true);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "File operation failed when creating MCT sets.", "MCT generator error", 0);
            this.overlord.log("MCT generator failed: " + e.getMessage(), "error", true);
        }
    }

    public String generateAllCHindexes(int howMany, ArrayList<String> commandsValidate) {
        String CSVfilePath;
        if (!this.overlord.getRStatus()) {
            this.overlord.checkRlangStatus(true);
            if (!this.overlord.getRStatus()) {
                return null;
            }
        }
        if ((CSVfilePath = this.selectionOfSource()) == null) {
            return null;
        }
        Object dir_path = "";
        int c_number = howMany;
        try {
            String r_path;
            if (this.overlord.getWorkspace().getProject().getT_InvMatrix() == null) {
                this.overlord.log("Warning: unable to check if given clusters number (" + howMany + ") exceeds invariants number. If so, the procedure may fail.", "warning", true);
            } else {
                int invNumber = this.overlord.getWorkspace().getProject().getT_InvMatrix().size();
                if (invNumber < howMany) {
                    howMany = invNumber;
                }
            }
            Object[] options = new Object[]{"Select CH metric directory", "Use temporary directory"};
            int n = JOptionPane.showOptionDialog(null, "Multiple CH metric files can we written into default temporary directory (inadvised) or into\nthe selected one. What to do?", "Directory selection", 0, 1, null, options, options[0]);
            if (n == 0) {
                String choosenDir = Tools.selectDirectoryDialog(this.overlord.getLastPath(), "Select CH metric dir", "Target directory for CH metric results");
                if (choosenDir.equals("")) {
                    dir_path = this.overlord.getTmpPath();
                    this.overlord.log("CH metric files will be put into the " + (String)dir_path, "text", true);
                } else {
                    File dir = new File(choosenDir);
                    dir_path = dir.getPath() + "//";
                    Tools.copyFileByPath(CSVfilePath, (String)dir_path + "cluster.csv");
                    this.overlord.log("Cluster files will be put into the " + (String)dir_path, "text", true);
                }
            } else {
                dir_path = this.overlord.getTmpPath();
                this.overlord.log("Cluster files will be put into the " + (String)dir_path, "text", true);
            }
            this.overlord.showConsole(true);
            dir_path = ((String)dir_path).replace("\\", "/");
            File test64 = new File(this.overlord.getSettingsManager().getValue("r_path64"));
            if (test64.exists()) {
                r_path = this.overlord.getSettingsManager().getValue("r_path64");
            } else {
                r_path = this.overlord.getSettingsManager().getValue("r_path");
                this.overlord.log("Warning: Celinski-Harabasz metric computation in 32bit mode for large number of invariants can cause R/system crash", "warning", true);
            }
            Rprotocols runnable = new Rprotocols(1);
            runnable.setForRunnableAllClusters(r_path, (String)dir_path, "cluster.csv", "scripts\\f_CHindex.r", "scripts\\f_clusters_run.r", "scripts\\f_CHindex_Pearson.r", "scripts\\f_clusters_Pearson_run.r", howMany, commandsValidate);
            Thread thread = new Thread(runnable);
            thread.start();
            return dir_path;
        }
        catch (IOException e) {
            String msg = "CH metric computation failed for " + c_number + " clusters.\nPath: " + (String)dir_path;
            JOptionPane.showMessageDialog(null, msg, "Critical error", 0);
            this.overlord.log(msg, "error", true);
            this.overlord.log(e.getMessage(), "error", true);
            return null;
        }
    }

    public String generateClustersCase56(int howMany, ArrayList<String> commandsValidate) {
        String CSVfilePath;
        if (!this.overlord.getRStatus()) {
            this.overlord.checkRlangStatus(true);
            if (!this.overlord.getRStatus()) {
                return null;
            }
        }
        if ((CSVfilePath = this.selectionOfSource()) == null) {
            return null;
        }
        Object dir_path = "";
        int c_number = howMany;
        try {
            if (this.overlord.getWorkspace().getProject().getT_InvMatrix() == null) {
                this.overlord.log("Warning: unable to check if a given number of clusters (" + howMany + ") exceeds invariants number. If so, the procedure may fail.", "warning", true);
            } else {
                int invNumber = this.overlord.getWorkspace().getProject().getT_InvMatrix().size();
                if (invNumber < howMany) {
                    howMany = invNumber;
                }
            }
            Object[] options = new Object[]{"Select cluster directory", "Use temporary directory", "Cancel operation"};
            int n = JOptionPane.showOptionDialog(null, "Multiple cluster files can we written into default temporary directory (not advised) or into\nthe selected one. What to do?", "Directory selection", 0, 1, null, options, options[0]);
            if (n == 0) {
                String choosenDir = Tools.selectDirectoryDialog(this.overlord.getLastPath(), "Select cluster dir", "Target directory for cluster results");
                if (choosenDir.equals("")) {
                    dir_path = this.overlord.getTmpPath();
                    this.overlord.log("Cluster files will be put into the " + (String)dir_path, "text", true);
                } else {
                    File dir = new File(choosenDir);
                    dir_path = dir.getPath() + "//";
                    Tools.copyFileByPath(CSVfilePath, (String)dir_path + "cluster.csv");
                    this.overlord.log("Cluster files will be put into the " + (String)dir_path, "text", true);
                }
            } else if (n == 1) {
                dir_path = this.overlord.getTmpPath();
                this.overlord.log("Cluster files will be put into the " + (String)dir_path, "text", true);
            } else {
                return null;
            }
            this.overlord.showConsole(true);
            dir_path = ((String)dir_path).replace("\\", "/");
            Rprotocols runnable = new Rprotocols();
            runnable.setForRunnableAllClusters(this.overlord.getSettingsManager().getValue("r_path"), (String)dir_path, "cluster.csv", "scripts\\f_clusters.r", "scripts\\f_clusters_run.r", "scripts\\f_clusters_Pearson.r", "scripts\\f_clusters_Pearson_run.r", c_number, commandsValidate);
            runnable.setWorkingMode(0);
            Thread thread = new Thread(runnable);
            thread.start();
            return (String)dir_path + "/cluster.csv";
        }
        catch (Exception e) {
            String msg = "Clustering generation failed for " + c_number + " clusters.\nPath: " + (String)dir_path;
            JOptionPane.showMessageDialog(null, msg, "Critical error", 0);
            this.overlord.log(msg, "error", true);
            this.overlord.log(e.getMessage(), "error", true);
            return null;
        }
    }

    private String selectionOfSource() {
        String lastPath = this.overlord.getLastPath();
        if (this.overlord.getWorkspace().getProject().getT_InvMatrix() == null) {
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("CSV invariants file (.csv)", new String[]{"CSV"})};
            String selectedFile = Tools.selectFileDialog(lastPath, filters, "Select CSV", "Select CSV file", "");
            if (selectedFile.equals("")) {
                return null;
            }
            return selectedFile;
        }
        Object[] options = new Object[]{"Select invariants file manually", "Use computed invariants", "Cancel operation"};
        int n = JOptionPane.showOptionDialog(null, "Please select invariant file (.CSV) for the clustering manually or use invariants\nfrom the current network (they MUST be computed/loaded already!).", "Invariants source", 0, 1, null, options, options[0]);
        if (n == 0) {
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("CSV invariants file (.csv)", new String[]{"CSV"})};
            String selectedFile = Tools.selectFileDialog(lastPath, filters, "Select CSV", "Select CSV file", "");
            if (selectedFile.equals("")) {
                return null;
            }
            return selectedFile;
        }
        if (n == 1) {
            String CSVfilePath = this.overlord.getTmpPath() + "cluster.csv";
            int result = this.overlord.getWorkspace().getProject().saveInvariantsToCSV(CSVfilePath, true, true);
            if (result == -1) {
                String msg = "Exporting invariants into CSV file failed. \nCluster procedure cannot begin.";
                JOptionPane.showMessageDialog(null, msg, "CSV export error", 0);
                this.overlord.log(msg, "error", true);
                return null;
            }
            return CSVfilePath;
        }
        return null;
    }

    public String[] generateSingleClustering(String clustersPath, String algorithm, String metric, int howMany) {
        String resultFilePath_r;
        String resultFilePath_MCT;
        Object filePath = clustersPath + "//cluster.csv";
        File csvFile = new File((String)filePath);
        if (!csvFile.exists()) {
            Object[] options = new Object[]{"Manually locate file", "Cancel procedure"};
            int n = JOptionPane.showOptionDialog(null, "No input.csv file in:\n" + (String)filePath + "\nDo you want to select location manually?", "No CSV invariants file", 0, 3, null, options, options[0]);
            if (n == 0) {
                FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter(".csv - Comma Separated Values", new String[]{"CSV"})};
                filePath = Tools.selectFileDialog(clustersPath, filters, "Select", "Select CSV invariants file", "");
                if (((String)filePath).equals("")) {
                    return null;
                }
                csvFile = new File((String)filePath);
                if (!csvFile.exists()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        String msg = "CSV invariants file: " + (String)filePath + " located. Starting single clustering procedure.";
        this.overlord.log(msg, "text", true);
        String resultFilePath_clusterCSV = filePath;
        try {
            this.overlord.log("Starting MCT generator for file: " + (String)filePath, "text", true);
            Runner mctRunner = new Runner();
            mctRunner.activate(new String[]{filePath});
            resultFilePath_MCT = (String)filePath + ".analysed.txt";
        }
        catch (Exception e) {
            msg = "MCT generation(file) failed for: " + (String)filePath;
            this.overlord.log(msg, "text", true);
            JOptionPane.showMessageDialog(null, msg, "Critical error", 0);
            return null;
        }
        Rprotocols rp = new Rprotocols();
        String rPath = this.overlord.getSettingsManager().getValue("r_path");
        String csvFileName = csvFile.getName();
        String absolutePath = csvFile.getAbsolutePath();
        Object pathOutput = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator)) + "//";
        pathOutput = ((String)pathOutput).replace("\\", "/");
        try {
            resultFilePath_r = metric.equals("pearson") || metric.equals("correlation") ? rp.generateSingleClustering(rPath, (String)pathOutput, csvFileName, "scripts\\f_SingleCluster_Pearson.r", metric, algorithm, howMany) : rp.generateSingleClustering(rPath, (String)pathOutput, csvFileName, "scripts\\f_SingleCluster.r", metric, algorithm, howMany);
        }
        catch (Exception e) {
            this.overlord.log("R function failed for parameters:", "error", true);
            this.overlord.log("File name: " + csvFileName, "error", true);
            this.overlord.log("Output dir: " + (String)pathOutput, "error", true);
            this.overlord.log("Algorithm: " + algorithm, "error", true);
            this.overlord.log("Metric: " + metric, "error", true);
            this.overlord.log("No. of clusters: " + howMany, "error", true);
            JOptionPane.showMessageDialog(null, "Clustering failed. Check log.", "Critical error", 0);
            return null;
        }
        String[] result = new String[]{resultFilePath_clusterCSV, resultFilePath_r, resultFilePath_MCT, clustersPath + "//" + algorithm + "_" + metric + "_clusters_ext_" + howMany + ".pdf", clustersPath + "//" + algorithm + "_" + metric + "_dendrogram_ext_" + howMany + ".pdf"};
        return result;
    }

    public void updateTimeStep(boolean XTPN, long stepsValue, double timeValue, double tau) {
        try {
            if (XTPN) {
                this.overlord.getSimulatorBox().getCurrentDockWindow().stepLabelXTPN.setText("" + stepsValue);
                this.overlord.getSimulatorBox().getCurrentDockWindow().timeLabelXTPN.setText(Tools.cutValueExt(timeValue, 2) + " (" + Tools.cutValueExt(tau, 2) + ")");
            } else {
                this.overlord.getSimulatorBox().getCurrentDockWindow().timeStepLabelValue.setText("" + stepsValue);
            }
        }
        catch (Exception e) {
            this.overlord.log("Unable to update simulator fields: (XTPN=" + XTPN + "; stepsValue=" + stepsValue + "; stepsValue=" + stepsValue + ".", "warning", true);
        }
    }

    public void markTransitions(int mode) {
        this.overlord.getWorkspace().getProject().resetNetColors();
        ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
        if (mode == 0) {
            for (Transition t : transitions) {
                if (!t.timeExtension.isTPN()) continue;
                t.drawGraphBoxT.setColorWithNumber(true, Color.green, false, -1.0, true, "TPN");
            }
        } else if (mode == 1) {
            for (Transition t : transitions) {
                if (!t.timeExtension.isDPN()) continue;
                t.drawGraphBoxT.setColorWithNumber(true, Color.green, false, -1.0, true, "DPN");
            }
        } else if (mode == 2) {
            for (Transition t : transitions) {
                if (t.timeExtension.isTPN() && !t.timeExtension.isDPN()) {
                    t.drawGraphBoxT.setColorWithNumber(true, EditorResources.tpnNOTdpn, false, -1.0, true, "TPN");
                    continue;
                }
                if (!t.timeExtension.isTPN() && t.timeExtension.isDPN()) {
                    t.drawGraphBoxT.setColorWithNumber(true, EditorResources.dpnNOTtpn, false, -1.0, true, "DPN");
                    continue;
                }
                if (!t.timeExtension.isTPN() || !t.timeExtension.isDPN()) continue;
                t.drawGraphBoxT.setColorWithNumber(true, EditorResources.tpnANDdpn, false, -1.0, true, "TPN / DPN");
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    public void fixArcsProblem() {
        ArrayList<Arc> outArcs;
        ArrayList<Place> places = this.overlord.getWorkspace().getProject().getPlaces();
        ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
        ArrayList<Arc> arcs = this.overlord.getWorkspace().getProject().getArcs();
        int arcSize = arcs.size();
        int arcCounter = 0;
        int ghosts = 0;
        for (Place p : places) {
            for (ElementLocation el : p.getElementLocations()) {
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    ++arcCounter;
                    if (arcs.contains(a)) continue;
                    ++ghosts;
                    int placeId = places.indexOf(p);
                    int transId = transitions.indexOf((Transition)a.getEndNode());
                    this.overlord.log("Invisible arc: p" + placeId + " -> t" + transId + ". Removing...", "error", true);
                    this.removeArc(a, arcs);
                }
            }
        }
        for (Transition t : transitions) {
            for (ElementLocation el : t.getElementLocations()) {
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    ++arcCounter;
                    if (arcs.contains(a)) continue;
                    ++ghosts;
                    int transId = transitions.indexOf(t);
                    int placeId = places.indexOf((Place)a.getEndNode());
                    this.overlord.log("Invisible arc: t" + transId + " -> p" + placeId + ". Removing...", "error", true);
                    this.removeArc(a, arcs);
                }
            }
        }
        this.overlord.log("Arc list: " + arcSize + ", processed arcs: " + arcCounter + ", removed ghost-arcs: " + ghosts, "text", true);
    }

    private void removeArc(Arc arc, ArrayList<Arc> arcs) {
        this.overlord.markNetChange();
        arc.unlinkElementLocations();
        arcs.remove(arc);
        if (arc.getPairedArc() != null) {
            Arc a = arc.getPairedArc();
            a.unlinkElementLocations();
            arcs.remove(a);
        }
    }
}

