/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import com.javadocking.DockingManager;
import com.javadocking.component.DefaultSwComponentFactory;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.CompositeTabDock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dock.SplitDock;
import com.javadocking.dock.factory.LeafDockFactory;
import com.javadocking.dockable.ActionDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.StateActionDockable;
import com.javadocking.dockable.action.DefaultDockableStateActionFactory;
import com.javadocking.dockable.action.DefaultPopupMenuFactory;
import com.javadocking.event.DockingListener;
import com.javadocking.model.DefaultDockingPath;
import com.javadocking.model.FloatDockModel;
import com.javadocking.visualizer.FloatExternalizer;
import com.javadocking.visualizer.LineMinimizer;
import com.javadocking.visualizer.SingleMaximizer;
import holmes.analyse.MCTCalculator;
import holmes.clusters.ClusterDataPackage;
import holmes.darkgui.DarkDockingListener;
import holmes.darkgui.DarkMenu;
import holmes.darkgui.GUIOperations;
import holmes.darkgui.GUIReset;
import holmes.darkgui.KeyManager;
import holmes.darkgui.dockable.DeleteAction;
import holmes.darkgui.dockwindows.HolmesDockWindow;
import holmes.darkgui.dockwindows.PetriNetTools;
import holmes.darkgui.settings.SettingsManager;
import holmes.darkgui.toolbar.Toolbar;
import holmes.files.io.TexExporter;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.subnets.SubnetsControl;
import holmes.petrinet.subnets.SubnetsGraphics;
import holmes.utilities.Tools;
import holmes.windows.HolmesAbout;
import holmes.windows.HolmesConsole;
import holmes.windows.HolmesInvariantsGenerator;
import holmes.windows.HolmesKnockout;
import holmes.windows.HolmesMCS;
import holmes.windows.HolmesNetProperties;
import holmes.windows.HolmesNetTables;
import holmes.windows.HolmesNotepad;
import holmes.windows.HolmesProgramProperties;
import holmes.windows.HolmesSearch;
import holmes.windows.clusters.HolmesClusters;
import holmes.windows.decompositions.HolmesBranchVerticesPrototype;
import holmes.windows.decompositions.HolmesComparisonModule;
import holmes.windows.decompositions.HolmesDecomposition;
import holmes.windows.decompositions.HolmesGraphlets;
import holmes.windows.decompositions.HolmesLabelComparison;
import holmes.windows.decompositions.HolmesReductionPrototype;
import holmes.windows.ssim.HolmesSim;
import holmes.windows.xtpn.HolmesSimXTPN;
import holmes.workspace.ExtensionFileFilter;
import holmes.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class GUIManager
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -817072868916096442L;
    private static GUIManager guiManager;
    public boolean debug = false;
    public Random randGen = new Random(System.currentTimeMillis());
    public GUIOperations io;
    public TexExporter tex;
    public GUIReset reset;
    public SubnetsGraphics subnetsGraphics;
    public SubnetsControl subnetsHQ;
    public SimulatorGlobals simSettings;
    private Dimension screenSize;
    private Dimension smallScreenSize;
    private FloatDockModel dockModel;
    private final SettingsManager settingsManager;
    private LineMinimizer minimizer;
    private SingleMaximizer maximizer;
    private FloatExternalizer externalizer;
    private Workspace workspace;
    private CompositeTabDock leftTabDock;
    private CompositeTabDock topRightTabDock;
    private CompositeTabDock bottomRightTabDock;
    private SplitDock leftSplitDock;
    private SplitDock rightSplitDock;
    private SplitDock totalSplitDock;
    private PetriNetTools toolBox;
    private HolmesDockWindow simulatorBox;
    private HolmesDockWindow selectionBox;
    private HolmesDockWindow mctBox;
    private HolmesDockWindow t_invariantsBox;
    private HolmesDockWindow p_invariantsBox;
    private HolmesDockWindow selElementBox;
    private HolmesDockWindow clustersBox;
    private HolmesDockWindow mcsBox;
    private HolmesDockWindow fixBox;
    private HolmesDockWindow knockoutBox;
    private HolmesDockWindow quickSimBox;
    private DarkDockingListener dockingListener;
    private Toolbar shortcutsBar;
    private JFrame frame;
    private DarkMenu menu;
    private String lastPath;
    private String holmesPath;
    private String tmpPath;
    private String toolPath;
    private String logPath;
    private HolmesClusters windowClusters;
    private HolmesConsole windowConsole;
    private HolmesNetProperties windowNetProperties;
    private HolmesAbout windowAbout;
    private HolmesSearch windowSearch;
    private HolmesProgramProperties windowProperties;
    private HolmesSim windowStateSim;
    private HolmesSimXTPN windowStateSimXTPN;
    private HolmesNetTables windowNetTables;
    private HolmesNotepad windowSimulationLog;
    private HolmesInvariantsGenerator windowInvariants;
    private HolmesMCS windowMCS;
    private HolmesKnockout windowsKnockout;
    private HolmesDecomposition windowsDeco;
    private HolmesGraphlets windowsGraphlet;
    private HolmesLabelComparison labelComparison;
    private HolmesBranchVerticesPrototype windowsBranch;
    private HolmesComparisonModule windowsComp;
    private HolmesReductionPrototype windowReduction;
    private boolean rReady = false;
    private boolean inaReady = true;
    private locationMoveType nameLocChangeMode = locationMoveType.NONE;
    private Node nameSelectedNode = null;
    private ElementLocation nameNodeEL = null;
    public ArrayList<Dockable> globalSheetsList = new ArrayList();

    public GUIManager(JFrame frejm) {
        super(new BorderLayout());
        if (!System.getProperty("java.version").contains(".")) {
            System.setProperty("java.version", System.getProperty("java.version") + ".0");
        }
        guiManager = this;
        this.io = new GUIOperations(this);
        this.tex = new TexExporter();
        this.reset = new GUIReset();
        this.subnetsGraphics = new SubnetsGraphics();
        this.subnetsHQ = new SubnetsControl(this);
        this.simSettings = new SimulatorGlobals();
        this.setFrame(frejm);
        try {
            this.frame.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.frame.getContentPane().add(this);
        this.frame.addComponentListener(this);
        this.getFrame().getContentPane().add(this);
        this.getFrame().addComponentListener(this);
        this.createHiddenConsole();
        this.settingsManager = new SettingsManager();
        this.settingsManager.loadSettings();
        this.frame.setTitle("Holmes " + this.settingsManager.getValue("holmes_version"));
        this.createClusterWindow();
        this.createNetPropertiesWindow();
        this.createSearchWindow();
        this.createNetTablesWindow();
        this.createInvariantsWindow();
        this.initializeEnvironment();
        this.getFrame().setDefaultCloseOperation(3);
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.getFrame().setLocation((int)((double)this.screenSize.width * 0.1) / 2, (int)((double)this.screenSize.height * 0.1) / 2);
        this.getFrame().setSize((int)(this.screenSize.getWidth() * 0.9), (int)(this.screenSize.getHeight() * 0.9));
        this.getFrame().setVisible(true);
        this.getFrame().setExtendedState(this.getFrame().getExtendedState() | 6);
        this.setDockModel(new FloatDockModel());
        this.getDockModel().addOwner("frame0", this.getFrame());
        FloatDock floatDock = this.getDockModel().getFloatDock(this.getFrame());
        floatDock.setChildDockFactory(new LeafDockFactory(false));
        DefaultPopupMenuFactory popupMenuFactory = new DefaultPopupMenuFactory();
        popupMenuFactory.setPopupActions(7);
        DefaultSwComponentFactory componentFactory = new DefaultSwComponentFactory();
        componentFactory.setPopupMenuFactory(popupMenuFactory);
        DockingManager.setComponentFactory(componentFactory);
        DockingManager.setDockModel(this.getDockModel());
        this.leftTabDock = new CompositeTabDock();
        this.topRightTabDock = new CompositeTabDock();
        this.bottomRightTabDock = new CompositeTabDock();
        this.setDockingListener(new DarkDockingListener());
        this.setToolBox(new PetriNetTools());
        this.setPropertiesBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.EDITOR));
        this.setSimulatorBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.SIMULATOR));
        this.setSelectionBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.SELECTOR));
        this.setT_invBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.T_INVARIANTS));
        this.setP_invSim(new HolmesDockWindow(HolmesDockWindow.DockWindowType.P_INVARIANTS));
        this.setClusterSelectionBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.ClusterSELECTOR));
        this.setMctBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.MctANALYZER));
        this.setMCSBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.MCSselector));
        this.setKnockoutBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.Knockout));
        this.setQuickSimBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.QuickSim));
        this.setMenu(new DarkMenu());
        this.getFrame().setJMenuBar(this.getMenu());
        this.createSimLogWindow();
        this.setWorkspace(new Workspace(this));
        this.getDockingListener().setWorkspace(this.workspace);
        this.setFixBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.FIXNET));
        this.leftTabDock.addChildDock(this.getToolBox(), new Position(0));
        this.leftTabDock.addChildDock(this.getSimulatorBox(), new Position(1));
        this.leftTabDock.setSelectedDock(this.getToolBox());
        this.topRightTabDock.addChildDock(this.getPropertiesBox(), new Position(0));
        this.topRightTabDock.setSelectedDock(this.getPropertiesBox());
        this.bottomRightTabDock.addChildDock(this.getT_invBox(), new Position(1));
        this.bottomRightTabDock.addChildDock(this.getP_invBox(), new Position(2));
        this.bottomRightTabDock.addChildDock(this.getMctBox(), new Position(3));
        this.bottomRightTabDock.addChildDock(this.getMCSBox(), new Position(4));
        this.bottomRightTabDock.addChildDock(this.getClusterSelectionBox(), new Position(5));
        this.bottomRightTabDock.addChildDock(this.getKnockoutBox(), new Position(6));
        this.bottomRightTabDock.addChildDock(this.getQuickSimBox(), new Position(7));
        this.bottomRightTabDock.addChildDock(this.getFixBox(), new Position(8));
        this.leftSplitDock = new SplitDock();
        this.leftSplitDock.addChildDock(this.leftTabDock, new Position(1));
        SplitDock workspaceSplit = new SplitDock();
        workspaceSplit.addChildDock(this.getWorkspace().getWorkspaceDock(), new Position(0));
        if (this.debug) {
            workspaceSplit.addChildDock(this.getSelectionBox(), new Position(4));
        } else {
            this.topRightTabDock.addChildDock(this.getSelectionBox(), new Position(1));
            this.topRightTabDock.setSelectedDock(this.getPropertiesBox());
        }
        workspaceSplit.setDividerLocation((int)(this.screenSize.getHeight() * 7.0 / 10.0));
        this.leftSplitDock.addChildDock(workspaceSplit, new Position(0));
        this.leftSplitDock.setDividerLocation(180);
        this.rightSplitDock = new SplitDock();
        this.rightSplitDock.addChildDock(this.topRightTabDock, new Position(3));
        this.rightSplitDock.addChildDock(this.bottomRightTabDock, new Position(4));
        this.rightSplitDock.setDividerLocation((int)(this.screenSize.getHeight() * 2.0 / 5.0));
        this.totalSplitDock = new SplitDock();
        this.totalSplitDock.addChildDock(this.leftSplitDock, new Position(1));
        this.totalSplitDock.addChildDock(this.rightSplitDock, new Position(2));
        this.totalSplitDock.setDividerLocation((int)this.screenSize.getWidth() - (int)this.screenSize.getWidth() / 6);
        this.getDockModel().addRootDock("totalSplitDock", this.totalSplitDock, this.getFrame());
        this.add((Component)this.totalSplitDock, "Center");
        DockingManager.getDockingPathModel().add(DefaultDockingPath.createDockingPath(this.getToolBox().getDockable()));
        DockingManager.getDockingPathModel().add(DefaultDockingPath.createDockingPath(this.getPropertiesBox().getDockable()));
        this.setExternalizer(new FloatExternalizer(this.getFrame()));
        this.dockModel.addVisualizer("externalizer", this.getExternalizer(), this.getFrame());
        this.setMinimizer(new LineMinimizer(this.totalSplitDock));
        this.dockModel.addVisualizer("minimizer", this.getMinimizer(), this.getFrame());
        this.setMaximizer(new SingleMaximizer(this.getMinimizer()));
        this.dockModel.addVisualizer("maximizer", this.getMaximizer(), this.getFrame());
        this.add((Component)this.getMaximizer(), "Center");
        this.smallScreenSize = new Dimension((int)(this.screenSize.getWidth() * 0.9), (int)(this.screenSize.getHeight() * 0.9));
        this.setShortcutsBar(new Toolbar());
        this.dockModel.addRootDock("toolBarBorderDock", this.getShortcutsBar().getToolBarBorderDock(), this.frame);
        this.add((Component)this.getShortcutsBar().getToolBarBorderDock(), "Center");
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyManager(this));
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                boolean status = GUIManager.getDefaultGUIManager().getNetChangeStatus();
                if (status) {
                    Object[] options = new Object[]{"Exit", "Save and exit", "Cancel"};
                    int n = JOptionPane.showOptionDialog(null, "Net or its data have been changed since last save. Exit, save&exit or do not exit now?", "Project has been modified", 0, 3, null, options, options[2]);
                    if (n == 0) {
                        GUIManager.this.log("Exiting program", "text", true);
                        GUIManager.this.windowConsole.saveLogToFile(null);
                        System.exit(0);
                    } else if (n == 1) {
                        boolean savingStatus = GUIManager.this.io.saveAsGlobal();
                        if (!savingStatus) {
                            return;
                        }
                        GUIManager.this.log("Exiting program", "text", true);
                        GUIManager.this.windowConsole.saveLogToFile(null);
                        System.exit(0);
                    }
                } else if (JOptionPane.showConfirmDialog(GUIManager.this.frame, "Are you sure you want to close the program?", "Exit?", 0, 3) == 0) {
                    GUIManager.this.log("Exiting program", "text", true);
                    GUIManager.this.windowConsole.saveLogToFile(null);
                    System.exit(0);
                }
            }
        });
        this.createStateSimulatorWindow();
        this.createStateSimulatorXTPNWindow();
        this.createMCSWindow();
        String path = this.settingsManager.getValue("lastOpenedPath");
        File f = new File(path);
        if (f.exists()) {
            this.lastPath = path;
        }
        this.getSimulatorBox().createSimulatorProperties(false);
    }

    private void initializeEnvironment() {
        this.lastPath = null;
        this.holmesPath = System.getProperty("user.dir");
        this.tmpPath = this.holmesPath + "\\tmp\\";
        this.toolPath = this.holmesPath + "\\tools\\";
        this.logPath = this.holmesPath + "\\log\\";
        File checkFile = new File(this.tmpPath);
        if (!checkFile.exists()) {
            checkFile.mkdirs();
        }
        if (!(checkFile = new File(this.logPath)).exists()) {
            checkFile.mkdirs();
        }
        File checkFileINA0 = new File(this.toolPath);
        File checkFileINA1 = new File(this.toolPath + "//INAwin32.exe");
        File checkFileINA2 = new File(this.toolPath + "//COMMAND.ina");
        File checkFileINA2p = new File(this.toolPath + "//COMMANDp.ina");
        File checkFileINA3 = new File(this.toolPath + "//ina.bat");
        if (!(checkFileINA0.exists() && checkFileINA1.exists() && checkFileINA2.exists() && checkFileINA2.length() == 80L && checkFileINA3.exists() && checkFileINA3.length() == 30L && checkFileINA2p.exists() && checkFileINA2p.length() == 77L)) {
            PrintWriter pw;
            if (!checkFileINA0.exists()) {
                checkFileINA0.mkdirs();
                this.logNoEnter("Tools directory does not exist: ", "warning", true);
                this.log("fixed", "italic", false);
            }
            if (!checkFileINA2.exists() || checkFileINA2.length() != 80L) {
                try {
                    pw = new PrintWriter(checkFileINA2.getPath());
                    pw.print(this.settingsManager.getValue("ina_COMMAND1") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND2") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND3") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND4"));
                    pw.close();
                    this.logNoEnter("File COMMAND.ina does not exist or is corrupted. ", "warning", true);
                    this.log("Fixed", "italic", false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Unable to recreate COMMAND.ina.", "Error - COMMAND.ina", 0);
                    this.inaReady = false;
                    this.log("Unable to recreate COMMAND.ina. Invariants generator will work in Holmes mode only.", "warning", true);
                }
            }
            if (!checkFileINA2p.exists() || checkFileINA2p.length() != 77L) {
                try {
                    pw = new PrintWriter(checkFileINA2p.getPath());
                    pw.print(this.settingsManager.getValue("ina_COMMAND1") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND2p") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND4"));
                    pw.close();
                    this.logNoEnter("File COMMANDp.ina does not exist or is corrupted. ", "warning", true);
                    this.log("Fixed", "italic", false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Unable to recreate COMMANDp.ina.", "Error - COMMANDp.ina", 0);
                    this.inaReady = false;
                    this.log("Unable to recreate COMMANDp.ina. Invariants generator will work in Holmes mode only.", "warning", true);
                }
            }
            if (!checkFileINA3.exists() || checkFileINA3.length() != 30L) {
                try {
                    pw = new PrintWriter(checkFileINA3.getPath());
                    pw.print(this.settingsManager.getValue("ina_bat"));
                    pw.close();
                    this.logNoEnter("File ina.bat did not exist or was corrupted: ", "warning", true);
                    this.log("fixed", "italic", false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Unable to recreate ina.bat. This is a critical error, possible write protection issues in program directory. Invariants generation using INAwin32 will most likely fail.", "Critical error - writing", 0);
                    this.inaReady = false;
                    this.log("Critical error, unable to recreate ina.bat file. Invariants generator will not work.", "warning", true);
                }
            }
            if (!checkFileINA1.exists()) {
                this.inaReady = false;
            }
        }
        this.checkRlangStatus(false);
        if (this.settingsManager.getValue("programDebugMode").equals("1")) {
            this.debug = true;
        }
    }

    public void checkRlangStatus(boolean forceCheck) {
        this.rReady = true;
        String Rpath = this.settingsManager.getValue("r_path");
        File rF = new File(Rpath);
        if (!rF.exists()) {
            this.rReady = false;
            this.log("Invalid path (" + Rpath + ") to Rscript executable file.", "warning", true);
            if (!forceCheck && this.getSettingsManager().getValue("programAskForRonStartup").equals("0")) {
                return;
            }
            Object[] options = new Object[]{"Manually locate Rscript.exe", "R not installed"};
            int n = JOptionPane.showOptionDialog(null, "Rscript.exe missing in path " + Rpath, "Missing executable", 0, 2, null, options, options[0]);
            if (n == 0) {
                FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter(".exe - Rscript", new String[]{"EXE"})};
                String selectedFile = Tools.selectFileDialog("", filters, "Select Rscript.exe", "Please select Rscript exe, usually located in R/Rx.x.x/bin directory.", "");
                if (selectedFile.equals("")) {
                    this.log("Rscript executable file inaccessible. Some features (clusters operations) will be disabled.", "error", true);
                } else {
                    if (!selectedFile.contains("x64")) {
                        Object dest = selectedFile.substring(0, selectedFile.lastIndexOf(File.separator));
                        if (Tools.ifExist((String)(dest = (String)dest + "\\x64\\Rscript.exe"))) {
                            this.settingsManager.setValue("r_path64", (String)dest, true);
                        } else {
                            this.settingsManager.setValue("r_path64", "", true);
                        }
                    } else {
                        this.settingsManager.setValue("r_path64", selectedFile, true);
                    }
                    if (Tools.ifExist(selectedFile)) {
                        this.settingsManager.setValue("r_path", selectedFile, true);
                        this.settingsManager.saveSettings();
                        this.setRStatus(true);
                        this.log("Rscript.exe manually located in " + selectedFile + ". Settings file updated.", "text", true);
                    } else {
                        this.settingsManager.setValue("r_path", "", true);
                        this.setRStatus(false);
                        this.log("Rscript.exe location unknown. Clustering procedures will not work.", "error", true);
                    }
                }
            }
        }
    }

    private void resetSplitDocks() {
        if (this.getFrame().getExtendedState() == 6) {
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.leftSplitDock.setDividerLocation(180);
            this.totalSplitDock.setDividerLocation((int)(this.screenSize.getWidth() - 350.0));
        } else {
            this.smallScreenSize = this.getFrame().getSize();
            this.leftSplitDock.setDividerLocation(180);
            this.totalSplitDock.setDividerLocation((int)(this.screenSize.getWidth() - 350.0));
        }
    }

    public Dockable decorateDockableWithActions(Dockable dockable, boolean deletable) {
        ActionDockable wrapper = new StateActionDockable(dockable, new DefaultDockableStateActionFactory(), new int[0]);
        int[] states = new int[]{1, 8, 4, 16, 2};
        wrapper = new StateActionDockable(wrapper, new DefaultDockableStateActionFactory(), states);
        if (deletable) {
            DeleteAction deleteAction = new DeleteAction(this, "Delete", Tools.getResIcon16("/icons/page_white_delete.png"));
            Action[][] actions = new Action[][]{new Action[1]};
            actions[0][0] = deleteAction;
            wrapper = new ActionDockable(wrapper, actions);
            deleteAction.setDockable(wrapper);
        }
        return wrapper;
    }

    public String getLastPath() {
        return this.lastPath;
    }

    public void setLastPath(String path) {
        this.lastPath = path;
        this.settingsManager.setValue("lastOpenedPath", this.lastPath, true);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    public void resetModuls() {
        this.windowsComp = new HolmesComparisonModule();
        this.windowsBranch = new HolmesBranchVerticesPrototype();
        this.windowsGraphlet = new HolmesGraphlets();
        this.windowsDeco = new HolmesDecomposition();
        this.windowsKnockout = new HolmesKnockout();
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.resetSplitDocks();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    public HolmesDockWindow getMctBox() {
        return this.mctBox;
    }

    private void setMctBox(HolmesDockWindow mctBox) {
        this.mctBox = mctBox;
    }

    private HolmesDockWindow getMCSBox() {
        return this.mcsBox;
    }

    private void setMCSBox(HolmesDockWindow mcsBox) {
        this.mcsBox = mcsBox;
    }

    private HolmesDockWindow getFixBox() {
        return this.fixBox;
    }

    private void setFixBox(HolmesDockWindow fixBox) {
        this.fixBox = fixBox;
    }

    private void setKnockoutBox(HolmesDockWindow knockoutBox) {
        this.knockoutBox = knockoutBox;
    }

    private HolmesDockWindow getKnockoutBox() {
        return this.knockoutBox;
    }

    private void setQuickSimBox(HolmesDockWindow quickSimBox) {
        this.quickSimBox = quickSimBox;
    }

    private HolmesDockWindow getQuickSimBox() {
        return this.quickSimBox;
    }

    public HolmesDockWindow getT_invBox() {
        return this.t_invariantsBox;
    }

    private void setT_invBox(HolmesDockWindow invariantsBox) {
        this.t_invariantsBox = invariantsBox;
    }

    private void setP_invSim(HolmesDockWindow invSim) {
        this.p_invariantsBox = invSim;
    }

    public HolmesDockWindow getP_invBox() {
        return this.p_invariantsBox;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public PetriNetTools getToolBox() {
        return this.toolBox;
    }

    private void setToolBox(PetriNetTools toolBox) {
        this.toolBox = toolBox;
    }

    public HolmesDockWindow getPropertiesBox() {
        return this.selElementBox;
    }

    private void setPropertiesBox(HolmesDockWindow propertiesBox) {
        this.selElementBox = propertiesBox;
    }

    public DarkMenu getMenu() {
        return this.menu;
    }

    private void setMenu(DarkMenu menu) {
        this.menu = menu;
    }

    public FloatDockModel getDockModel() {
        return this.dockModel;
    }

    private void setDockModel(FloatDockModel dockModel) {
        this.dockModel = dockModel;
    }

    public static GUIManager getDefaultGUIManager() {
        return guiManager;
    }

    public int IDtoIndex(int id) {
        return this.workspace.getIndexOfId(id);
    }

    public SingleMaximizer getMaximizer() {
        return this.maximizer;
    }

    private void setMaximizer(SingleMaximizer maximizer) {
        this.maximizer = maximizer;
    }

    public LineMinimizer getMinimizer() {
        return this.minimizer;
    }

    private void setMinimizer(LineMinimizer minimizer) {
        this.minimizer = minimizer;
    }

    public FloatExternalizer getExternalizer() {
        return this.externalizer;
    }

    private void setExternalizer(FloatExternalizer externalizer) {
        this.externalizer = externalizer;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public HolmesDockWindow getSimulatorBox() {
        return this.simulatorBox;
    }

    private void setSimulatorBox(HolmesDockWindow simulatorBox) {
        this.simulatorBox = simulatorBox;
    }

    public HolmesDockWindow getSelectionBox() {
        return this.selectionBox;
    }

    private void setSelectionBox(HolmesDockWindow selectionBox) {
        this.selectionBox = selectionBox;
    }

    private Toolbar getShortcutsBar() {
        return this.shortcutsBar;
    }

    private void setShortcutsBar(Toolbar shortcutsBar) {
        this.shortcutsBar = shortcutsBar;
    }

    public static Dockable externalWithListener(Dockable dockable, DockingListener listener) {
        Dockable wrapper = guiManager.decorateDockableWithActions(dockable, false);
        wrapper.addDockingListener(listener);
        return wrapper;
    }

    public DarkDockingListener getDockingListener() {
        return this.dockingListener;
    }

    public void setDockingListener(DarkDockingListener dockingListener) {
        this.dockingListener = dockingListener;
    }

    public HolmesDockWindow getClusterSelectionBox() {
        return this.clustersBox;
    }

    public void setClusterSelectionBox(HolmesDockWindow clusterBox) {
        this.clustersBox = clusterBox;
    }

    public HolmesConsole getConsoleWindow() {
        return this.windowConsole;
    }

    public String getToolPath() {
        return this.toolPath;
    }

    public String getHolmesPath() {
        return this.holmesPath;
    }

    public String getTmpPath() {
        return this.tmpPath;
    }

    public void generateMCT() {
        MCTCalculator analyzer = this.getWorkspace().getProject().getMCTanalyzer();
        ArrayList<ArrayList<Transition>> mct = analyzer.generateMCT();
        this.getWorkspace().getProject().setMCTMatrix(mct, true);
        this.getMctBox().showMCT(mct);
    }

    public void showMCS() {
        this.getMCSBox().showMCS();
    }

    public void showKnockout(ArrayList<ArrayList<Integer>> knockoutData) {
        this.getKnockoutBox().showKnockout(knockoutData);
    }

    public void showClusterSelectionBox(ClusterDataPackage data) {
        this.getClusterSelectionBox().showClusterSelector(data);
        GUIManager.getDefaultGUIManager().reset.setClustersStatus(true);
    }

    public void startInvariantsSimulation(int type, int value) throws CloneNotSupportedException {
        this.getWorkspace().getProject().startInvSim(type, value);
    }

    private void createClusterWindow() {
        this.windowClusters = new HolmesClusters(0);
    }

    public void showClusterWindow() {
        if (this.windowClusters != null) {
            this.windowClusters.setVisible(true);
        }
    }

    public HolmesClusters accessClusterWindow() {
        return this.windowClusters;
    }

    private void createNetPropertiesWindow() {
        this.windowNetProperties = new HolmesNetProperties();
        this.windowNetProperties.setLocationRelativeTo(this.frame);
    }

    public void showNetPropertiesWindow() {
        if (this.windowNetProperties != null) {
            this.windowNetProperties.setVisible(true);
        }
    }

    public void createAboutWindow() {
        this.windowAbout = new HolmesAbout(this.frame);
    }

    private void createSearchWindow() {
        this.windowSearch = new HolmesSearch();
    }

    public void showSearchWindow() {
        if (this.windowSearch != null) {
            this.windowSearch.setVisible(true);
        }
    }

    public HolmesSearch getSearchWindow() {
        return this.windowSearch;
    }

    private void createPropertiesWindow() {
        this.windowProperties = new HolmesProgramProperties(this.frame);
    }

    public void showPropertiesWindow() {
        if (this.windowProperties != null) {
            this.windowProperties.dispatchEvent(new WindowEvent(this.frame, 201));
            this.createPropertiesWindow();
        } else {
            this.createPropertiesWindow();
        }
        this.windowProperties.setVisible(true);
    }

    private void createStateSimulatorWindow() {
        this.windowStateSim = new HolmesSim(this);
    }

    public HolmesSim accessStateSimulatorWindow() {
        return this.windowStateSim;
    }

    public void showStateSimulatorWindow() {
        if (this.windowStateSim != null) {
            this.windowStateSim.setVisible(true);
        }
    }

    private void createStateSimulatorXTPNWindow() {
        this.windowStateSimXTPN = new HolmesSimXTPN(this);
    }

    public HolmesSimXTPN accessStateSimulatorXTPNWindow() {
        return this.windowStateSimXTPN;
    }

    public void showStateSimulatorWindowXTPN() {
        if (this.windowStateSimXTPN != null) {
            this.windowStateSimXTPN.setVisible(true);
        }
    }

    private void createNetTablesWindow() {
        this.windowNetTables = new HolmesNetTables(this.frame);
    }

    public void showNetTablesWindow() {
        if (this.windowNetTables != null && !this.reset.isSimulatorActiveWarning("Warning: simulator active. Cannot proceed until manually stopped.", "Net simulator working") && !this.reset.isXTPNSimulatorActiveWarning("Warning: XTPN simulator active. Cannot proceed until manually stopped.", "Net simulator working")) {
            this.windowNetTables.setVisible(true);
        }
    }

    public HolmesNetTables accessNetTablesWindow() {
        return this.windowNetTables;
    }

    private void createSimLogWindow() {
        this.windowSimulationLog = new HolmesNotepad(900, 600);
        this.windowSimulationLog.setVisible(false);
    }

    public void showSimLogWindow() {
        if (this.windowSimulationLog != null) {
            this.windowSimulationLog.setVisible(true);
        }
    }

    public HolmesNotepad getSimLog() {
        return this.windowSimulationLog;
    }

    private void createHiddenConsole() {
        this.windowConsole = new HolmesConsole();
        this.windowConsole.setLocationRelativeTo(this);
    }

    public void showConsole(boolean value) {
        if (this.windowConsole != null) {
            this.windowConsole.setVisible(value);
        }
    }

    public void createInvariantsWindow() {
        this.windowInvariants = new HolmesInvariantsGenerator();
        this.windowInvariants.setVisible(false);
    }

    public void showInvariantsWindow() {
        if (this.windowInvariants != null) {
            this.windowInvariants.setVisible(true);
        }
    }

    public HolmesInvariantsGenerator accessInvariantsWindow() {
        if (this.windowInvariants != null) {
            return this.windowInvariants;
        }
        return null;
    }

    public HolmesComparisonModule accessComparisonWindow() {
        if (this.windowsComp != null) {
            return this.windowsComp;
        }
        return null;
    }

    public void createMCSWindow() {
        if (this.windowMCS == null) {
            this.windowMCS = new HolmesMCS();
            this.windowMCS.setVisible(false);
        }
    }

    public void showMCSWindow() {
        if (this.windowMCS != null) {
            this.windowMCS.setVisible(true);
        }
    }

    public HolmesMCS accessMCSWindow() {
        if (this.windowMCS != null) {
            return this.windowMCS;
        }
        return null;
    }

    public void createKnockoutWindow() {
        if (this.windowsKnockout == null) {
            this.windowsKnockout = new HolmesKnockout();
        }
    }

    public void createDecompositionWindow() {
        if (this.windowsDeco == null) {
            this.windowsDeco = new HolmesDecomposition();
        }
    }

    public void createGraphletsWindow() {
        if (this.windowsGraphlet == null) {
            this.windowsGraphlet = new HolmesGraphlets();
        }
    }

    public void createLabelComparisonWindow() {
        if (this.labelComparison == null) {
            this.labelComparison = new HolmesLabelComparison();
        }
    }

    public void createBranchWindow() {
        if (this.windowsBranch == null) {
            this.windowsBranch = new HolmesBranchVerticesPrototype();
        }
    }

    public void createComparisonnWindow() {
        if (this.windowsComp == null) {
            this.windowsComp = new HolmesComparisonModule();
        }
    }

    public void createReductionWindow() {
        if (this.windowReduction == null) {
            this.windowReduction = new HolmesReductionPrototype();
        }
    }

    public void showKnockoutWindow() {
        if (this.windowsKnockout != null) {
            this.windowsKnockout.setVisible(true);
        }
    }

    public void showDecoWindow() {
        if (this.windowsDeco != null) {
            this.windowsDeco.setVisible(true);
        }
    }

    public void showGraphletsWindow() {
        if (this.windowsGraphlet != null) {
            this.windowsGraphlet.setVisible(true);
        }
    }

    public void showReductionsWindow() {
        if (this.windowReduction != null) {
            this.windowReduction.setVisible(true);
        }
    }

    public void showBranchWindow() {
        if (this.windowsBranch != null) {
            this.windowsBranch.setVisible(true);
        }
    }

    public void showCompWindow() {
        if (this.windowsComp != null) {
            this.windowsComp.setVisible(true);
        }
    }

    public void showLabelCompWindow() {
        if (this.labelComparison != null) {
            this.labelComparison.setVisible(true);
        }
    }

    public void log(String text, String mode, boolean time) {
        this.windowConsole.addText(text, mode, time, true);
        if (mode.equals("error")) {
            this.windowConsole.setVisible(true);
        }
    }

    public void logNoEnter(String text, String mode, boolean time) {
        this.windowConsole.addText(text, mode, time, false);
        if (mode.equals("error")) {
            this.windowConsole.setVisible(true);
        }
    }

    public boolean getRStatus() {
        return this.rReady;
    }

    public boolean getINAStatus() {
        return this.inaReady;
    }

    public void setRStatus(boolean status) {
        this.rReady = status;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setNameLocationChangeMode(Node n, ElementLocation el, locationMoveType mode) {
        this.nameSelectedNode = n;
        this.nameNodeEL = el;
        this.nameLocChangeMode = mode;
    }

    public locationMoveType getNameLocChangeMode() {
        return this.nameLocChangeMode;
    }

    public Node getNameLocChangeNode() {
        return this.nameSelectedNode;
    }

    public ElementLocation getNameLocChangeEL() {
        return this.nameNodeEL;
    }

    public void markNetChange() {
        this.getWorkspace().getProject().anythingChanged = true;
    }

    public void markNetSaved() {
        this.getWorkspace().getProject().anythingChanged = false;
    }

    public boolean getNetChangeStatus() {
        return this.getWorkspace().getProject().anythingChanged;
    }

    public void cleanLostOne(Dockable x) {
        LeafDock xxx = x.getDock();
        CompositeDock yyy = xxx.getParentDock();
        yyy.emptyChild(xxx);
    }

    public void cleanDockables() {
        ArrayList<Dockable> activeSheets = this.getWorkspace().getDockables();
        for (Dockable d : this.globalSheetsList) {
            if (activeSheets.contains(d)) continue;
            this.cleanLostOne(d);
        }
    }

    public static enum locationMoveType {
        NONE,
        NAME,
        ALPHA,
        BETA,
        GAMMA,
        TAU;

    }
}

