/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import com.javadocking.dockable.Dockable;
import holmes.darkgui.GUIManager;
import holmes.darkgui.dockable.DockableMenuItem;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.utilities.Tools;
import holmes.windows.HolmesInvariantsViewer;
import holmes.windows.decompositions.HolmesMergeNets;
import holmes.windows.managers.HolmesStatesManager;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class DarkMenu
extends JMenuBar {
    private static final long serialVersionUID = -1671996309149490657L;
    private GUIManager guiManager = GUIManager.getDefaultGUIManager();
    private JMenu sheetsMenu;
    private ArrayList<Dockable> dockables;
    private ArrayList<DockableMenuItem> sheetItems = new ArrayList();

    public DarkMenu() {
        this.dockables = new ArrayList();
        JMenu xMenu = new JMenu(" ");
        xMenu.setEnabled(false);
        this.add(xMenu);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.getAccessibleContext().setAccessibleDescription("The File Menu");
        this.add(fileMenu);
        JMenuItem projectMenuItem = new JMenuItem("New Project", 78);
        projectMenuItem.setEnabled(true);
        projectMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_newProject.png"));
        projectMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        projectMenuItem.getAccessibleContext().setAccessibleDescription("New project");
        projectMenuItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().reset.newProjectInitiated());
        fileMenu.add(projectMenuItem);
        fileMenu.addSeparator();
        JMenuItem openMenuItem = new JMenuItem("Open project...", 79);
        openMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_open.png"));
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        openMenuItem.getAccessibleContext().setAccessibleDescription("Open project");
        openMenuItem.addActionListener(arg0 -> this.guiManager.io.selectAndOpenHolmesProject());
        fileMenu.add(openMenuItem);
        JMenuItem importMenuItem = new JMenuItem("Import network...", 73);
        importMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_importNet.png"));
        importMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 192));
        importMenuItem.getAccessibleContext().setAccessibleDescription("Import project");
        importMenuItem.addActionListener(arg0 -> this.guiManager.io.importNetwork());
        fileMenu.add(importMenuItem);
        JMenuItem mergeMenuItem = new JMenuItem("Merge nets...");
        mergeMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_MergeIcon.png"));
        mergeMenuItem.getAccessibleContext().setAccessibleDescription("Merge projects");
        mergeMenuItem.addActionListener(arg0 -> new HolmesMergeNets());
        fileMenu.add(mergeMenuItem);
        fileMenu.addSeparator();
        JMenuItem saveMenuItem = new JMenuItem("Save project...", 83);
        saveMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_save.png"));
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        saveMenuItem.getAccessibleContext().setAccessibleDescription("Save project");
        saveMenuItem.addActionListener(arg0 -> this.guiManager.io.saveAsAbyssFile());
        fileMenu.add(saveMenuItem);
        JMenuItem saveAsMenuItem = new JMenuItem("Export network...");
        saveAsMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_saveAs.png"));
        saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        saveAsMenuItem.getAccessibleContext().setAccessibleDescription("Save project");
        saveAsMenuItem.addActionListener(arg0 -> this.guiManager.io.saveAsGlobal());
        fileMenu.add(saveAsMenuItem);
        JMenuItem exportMenuItem = new JMenuItem("Export as PNT...");
        exportMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportNet.png"));
        exportMenuItem.getAccessibleContext().setAccessibleDescription("Export project to PNT file");
        exportMenuItem.addActionListener(arg0 -> this.guiManager.io.exportAsPNT());
        fileMenu.add(exportMenuItem);
        JMenuItem expImgMenuItem = new JMenuItem("Export to image...");
        expImgMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportPicture.png"));
        expImgMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 192));
        expImgMenuItem.getAccessibleContext().setAccessibleDescription("Export project to image");
        expImgMenuItem.addActionListener(arg0 -> this.guiManager.io.exportProjectToImage());
        fileMenu.add(expImgMenuItem);
        JMenu texSubMenu = new JMenu("Tex Export");
        texSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        texSubMenu.getAccessibleContext().setAccessibleDescription("MCT Generator");
        fileMenu.add(texSubMenu);
        JMenuItem exportTexPTItem = new JMenuItem("Places and transitions table...", 49);
        exportTexPTItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        exportTexPTItem.getAccessibleContext().setAccessibleDescription("Export places and transitions tables");
        exportTexPTItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().tex.writePlacesTransitions());
        texSubMenu.add(exportTexPTItem);
        JMenuItem exportTexInvItem = new JMenuItem("Invariants table...", 50);
        exportTexInvItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        exportTexInvItem.getAccessibleContext().setAccessibleDescription("Export invariants into table");
        exportTexInvItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().tex.writeInvariants());
        texSubMenu.add(exportTexInvItem);
        JMenuItem exportTexMCTItem = new JMenuItem("MCT table...", 51);
        exportTexMCTItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        exportTexMCTItem.getAccessibleContext().setAccessibleDescription("Export MCT table");
        exportTexMCTItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().tex.writeMCT());
        texSubMenu.add(exportTexMCTItem);
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem("Exit", 69);
        exitMenuItem.setPreferredSize(new Dimension(1, 38));
        exitMenuItem.getAccessibleContext().setAccessibleDescription("Exit the application");
        exitMenuItem.addActionListener(arg0 -> {
            if (JOptionPane.showConfirmDialog(null, "Are you sure you want to close the program?", "Really Closing?", 0, 3) == 0) {
                GUIManager.getDefaultGUIManager().getConsoleWindow().saveLogToFile(null);
                System.exit(0);
            }
        });
        fileMenu.add(exitMenuItem);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        viewMenu.getAccessibleContext().setAccessibleDescription("View menu");
        this.add(viewMenu);
        JMenuItem resetZoomItem = new JMenuItem("Zoom 100%", 49);
        resetZoomItem.setIcon(Tools.getResIcon32("/icons/menu/menu_zoom_reset.png"));
        resetZoomItem.setAccelerator(KeyStroke.getKeyStroke(121, 128));
        resetZoomItem.getAccessibleContext().setAccessibleDescription("Reset zoom to 100%");
        resetZoomItem.addActionListener(arg0 -> {
            for (GraphPanel gp : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getGraphPanels()) {
                gp.setZoom(100, gp.getZoom());
            }
        });
        viewMenu.add(resetZoomItem);
        JMenuItem incZoomItem = new JMenuItem("Increase zoom 10%", 50);
        incZoomItem.setIcon(Tools.getResIcon32("/icons/menu/menu_zoom_inc.png"));
        incZoomItem.setAccelerator(KeyStroke.getKeyStroke(122, 128));
        incZoomItem.getAccessibleContext().setAccessibleDescription("Increase zoom 10%");
        incZoomItem.addActionListener(arg0 -> {
            for (GraphPanel gp : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getGraphPanels()) {
                gp.setZoom((int)((double)gp.getZoom() * 1.1), gp.getZoom());
            }
        });
        viewMenu.add(incZoomItem);
        JMenuItem decZoomItem = new JMenuItem("Decrease zoom 10%", 50);
        decZoomItem.setIcon(Tools.getResIcon32("/icons/menu/menu_zoom_dec.png"));
        decZoomItem.setAccelerator(KeyStroke.getKeyStroke(123, 128));
        decZoomItem.getAccessibleContext().setAccessibleDescription("Decrease zoom 10%");
        decZoomItem.addActionListener(arg0 -> {
            for (GraphPanel gp : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getGraphPanels()) {
                gp.setZoom((int)((double)gp.getZoom() * 0.9), gp.getZoom());
            }
        });
        viewMenu.add(decZoomItem);
        JMenu windowMenu = new JMenu("Windows");
        windowMenu.setMnemonic(87);
        windowMenu.getAccessibleContext().setAccessibleDescription("The Window Menu");
        this.add(windowMenu);
        this.sheetsMenu = new JMenu("Project");
        this.sheetsMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_Sheets.png"));
        this.sheetsMenu.setMnemonic(80);
        this.sheetsMenu.getAccessibleContext().setAccessibleDescription("The Project Sheets Menu");
        windowMenu.add(this.sheetsMenu);
        windowMenu.addSeparator();
        windowMenu.add(new DockableMenuItem(this.guiManager.getToolBox().getDockable(), Tools.getResIcon32("/icons/menu/menu_WindowTools.png")));
        windowMenu.add(new DockableMenuItem(this.guiManager.getPropertiesBox().getDockable(), Tools.getResIcon32("/icons/menu/menu_WindowProperties.png")));
        windowMenu.add(new DockableMenuItem(this.guiManager.getSimulatorBox().getDockable(), Tools.getResIcon32("/icons/menu/menu_WindowSimulator.png")));
        windowMenu.add(new DockableMenuItem(this.guiManager.getT_invBox().getDockable(), Tools.getResIcon32("/icons/menu/menu_WindowsAnalysis.png")));
        windowMenu.add(new DockableMenuItem(this.guiManager.getMctBox().getDockable(), Tools.getResIcon32("/icons/menu/menu_WindowMCT.png")));
        windowMenu.addSeparator();
        JMenuItem consoleItem = new JMenuItem("Log Console", 49);
        consoleItem.setIcon(Tools.getResIcon32("/icons/menu/menu_console.png"));
        consoleItem.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        consoleItem.getAccessibleContext().setAccessibleDescription("Show Holmes log window");
        consoleItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showConsole(true));
        windowMenu.add(consoleItem);
        JMenuItem propertiesItem = new JMenuItem("Properties", 49);
        propertiesItem.setIcon(Tools.getResIcon32("/icons/menu/menu_properties.png"));
        propertiesItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        propertiesItem.getAccessibleContext().setAccessibleDescription("Show Holmes properties window");
        propertiesItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showPropertiesWindow());
        windowMenu.add(propertiesItem);
        JMenu netMenu = new JMenu("Net");
        netMenu.setMnemonic(78);
        netMenu.getAccessibleContext().setAccessibleDescription("Net menu");
        this.add(netMenu);
        JMenuItem propItem = new JMenuItem("Net properties...", 49);
        propItem.setIcon(Tools.getResIcon32("/icons/menu/menu_NetProp.png"));
        propItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        propItem.getAccessibleContext().setAccessibleDescription("Show net properties");
        propItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showNetPropertiesWindow());
        netMenu.add(propItem);
        JMenuItem searchItem = new JMenuItem("Search node...", 50);
        searchItem.setIcon(Tools.getResIcon32("/icons/menu/menu_search.png"));
        searchItem.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        searchItem.getAccessibleContext().setAccessibleDescription("Show net properties");
        searchItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showSearchWindow());
        netMenu.add(searchItem);
        JMenuItem netTablesItem = new JMenuItem("Net data tables...", 52);
        netTablesItem.setIcon(Tools.getResIcon32("/icons/menu/menu_netTables.png"));
        netTablesItem.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        netTablesItem.getAccessibleContext().setAccessibleDescription("Show net data tables window");
        netTablesItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showNetTablesWindow());
        netMenu.add(netTablesItem);
        JMenuItem invViewItem = new JMenuItem("Invariants Viewer...", 53);
        invViewItem.setIcon(Tools.getResIcon32("/icons/menu/menu_invViewer.png"));
        invViewItem.setAccelerator(KeyStroke.getKeyStroke(74, 128));
        invViewItem.getAccessibleContext().setAccessibleDescription("Show invariants information window");
        invViewItem.addActionListener(arg0 -> new HolmesInvariantsViewer());
        netMenu.add(invViewItem);
        JMenuItem netStatessItem = new JMenuItem("Net m0 states...", 54);
        netStatessItem.setIcon(Tools.getResIcon32("/icons/menu/menu_statesViewer.png"));
        netStatessItem.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        netStatessItem.getAccessibleContext().setAccessibleDescription("Show net data states tables window");
        netStatessItem.addActionListener(arg0 -> {
            if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, "Net simulator must be stopped in order to access state manager.", "Simulator working", 2);
            } else {
                new HolmesStatesManager();
            }
        });
        netMenu.add(netStatessItem);
        JMenu hierachyMenu = new JMenu("Subnets");
        hierachyMenu.getAccessibleContext().setAccessibleDescription("Subnets tools");
        this.add(hierachyMenu);
        JMenuItem collapseNetItem = new JMenuItem("Compress subnets", 49);
        collapseNetItem.setIcon(Tools.getResIcon32("/icons/menu/menu_subnetCompress.png"));
        collapseNetItem.getAccessibleContext().setAccessibleDescription("Compress subnets (remove all empty sheets)");
        collapseNetItem.addActionListener(arg0 -> {
            GUIManager.getDefaultGUIManager().subnetsGraphics.collapseSubnets();
            GUIManager.getDefaultGUIManager().subnetsGraphics.resizePanels();
        });
        hierachyMenu.add(collapseNetItem);
        JMenuItem alignElementsItem = new JMenuItem("Align to upper left", 49);
        alignElementsItem.setIcon(Tools.getResIcon32("/icons/menu/menu_subnetAlignUpLeft.png"));
        alignElementsItem.getAccessibleContext().setAccessibleDescription("All net elements will be aligned to left upper corner");
        alignElementsItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().subnetsGraphics.realignElements());
        hierachyMenu.add(alignElementsItem);
        JMenuItem resizePanelsItem = new JMenuItem("Resize panels", 49);
        resizePanelsItem.setIcon(Tools.getResIcon32("/icons/menu/menu_subnetResize.png"));
        resizePanelsItem.getAccessibleContext().setAccessibleDescription("Resize all panels to better fit the contained subnet");
        resizePanelsItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().subnetsGraphics.resizePanels());
        hierachyMenu.add(resizePanelsItem);
        JMenu analysisMenu = new JMenu("Analysis");
        analysisMenu.setMnemonic(65);
        analysisMenu.getAccessibleContext().setAccessibleDescription("Net analysis");
        this.add(analysisMenu);
        JMenu invSubMenu = new JMenu("Invariants");
        invSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_InvariantsMenu.png"));
        invSubMenu.getAccessibleContext().setAccessibleDescription("Invariants-based analysis");
        analysisMenu.add(invSubMenu);
        JMenuItem invWindowItem = new JMenuItem("Invariants generator...", 49);
        invWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_analysis_invariants.png"));
        invWindowItem.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        invWindowItem.getAccessibleContext().setAccessibleDescription("Invariants generator and tools");
        invWindowItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showInvariantsWindow());
        invSubMenu.add(invWindowItem);
        JMenuItem mcsWindowItem = new JMenuItem("Minimal Cutting Sets...", 50);
        mcsWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_analysis_MCS.png"));
        mcsWindowItem.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        mcsWindowItem.getAccessibleContext().setAccessibleDescription("MCS generator and tools");
        mcsWindowItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showMCSWindow());
        invSubMenu.add(mcsWindowItem);
        JMenuItem knockoutWindowItem = new JMenuItem("Knockout analysis...", 51);
        knockoutWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_knockout.png"));
        knockoutWindowItem.setAccelerator(KeyStroke.getKeyStroke(75, 128));
        knockoutWindowItem.getAccessibleContext().setAccessibleDescription("Knockout analysis tools");
        knockoutWindowItem.addActionListener(arg0 -> {
            GUIManager.getDefaultGUIManager().createKnockoutWindow();
            GUIManager.getDefaultGUIManager().showKnockoutWindow();
        });
        invSubMenu.add(knockoutWindowItem);
        JMenuItem showClustersItem = new JMenuItem("Cluster analysis...", 52);
        showClustersItem.setIcon(Tools.getResIcon32("/icons/menu/menu_ClustersAnalysis.png"));
        showClustersItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        showClustersItem.getAccessibleContext().setAccessibleDescription("Show clusters window");
        showClustersItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showClusterWindow());
        invSubMenu.add(showClustersItem);
        JMenu simulatorSubMenu = new JMenu("Simulation");
        simulatorSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_simulators.png"));
        simulatorSubMenu.getAccessibleContext().setAccessibleDescription("Simulator");
        analysisMenu.add(simulatorSubMenu);
        JMenuItem netSimItem = new JMenuItem("State Simulator...", 53);
        netSimItem.setIcon(Tools.getResIcon32("/icons/menu/menu_stateSim.png"));
        netSimItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        netSimItem.getAccessibleContext().setAccessibleDescription("Show state simulator window");
        netSimItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showStateSimulatorWindow());
        simulatorSubMenu.add(netSimItem);
        JMenuItem netSimXTPNItem = new JMenuItem("XTPN Simulator...", 53);
        netSimXTPNItem.setIcon(Tools.getResIcon32("/icons/menu/menu_XTPNsimulator.png"));
        netSimXTPNItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        netSimXTPNItem.getAccessibleContext().setAccessibleDescription("Show state simulator window");
        netSimXTPNItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().showStateSimulatorWindowXTPN());
        simulatorSubMenu.add(netSimXTPNItem);
        JMenu decompSubMenu = new JMenu("Net decomposition");
        decompSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_decompSubmenu.png"));
        decompSubMenu.getAccessibleContext().setAccessibleDescription("Decomposition modules for Petri nets");
        analysisMenu.add(decompSubMenu);
        JMenuItem decoWindowItem = new JMenuItem("Decomposition analysis...", 54);
        decoWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompModule.png"));
        decoWindowItem.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        decoWindowItem.getAccessibleContext().setAccessibleDescription("Decomposition analysis tools");
        decoWindowItem.addActionListener(arg0 -> {
            GUIManager.getDefaultGUIManager().createDecompositionWindow();
            GUIManager.getDefaultGUIManager().showDecoWindow();
        });
        decompSubMenu.add(decoWindowItem);
        JMenuItem branchWindowItem = new JMenuItem("Branch analysis...", 55);
        branchWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompBranch.png"));
        branchWindowItem.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        branchWindowItem.getAccessibleContext().setAccessibleDescription("Branch prototype");
        branchWindowItem.addActionListener(arg0 -> {
            GUIManager.getDefaultGUIManager().createBranchWindow();
            GUIManager.getDefaultGUIManager().showBranchWindow();
        });
        decompSubMenu.add(branchWindowItem);
        JMenuItem compWindowItem = new JMenuItem("Net comparison", 56);
        compWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompNetComp.png"));
        compWindowItem.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        compWindowItem.getAccessibleContext().setAccessibleDescription("Comparison prototype");
        compWindowItem.addActionListener(arg0 -> {
            GUIManager.getDefaultGUIManager().createComparisonnWindow();
            GUIManager.getDefaultGUIManager().showCompWindow();
        });
        decompSubMenu.add(compWindowItem);
        JMenuItem graphletWindowItem = new JMenuItem("Graphlets", 48);
        graphletWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompGraphlets.png"));
        graphletWindowItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        graphletWindowItem.getAccessibleContext().setAccessibleDescription("Decomposition analysis tools");
        graphletWindowItem.addActionListener(arg0 -> {
            GUIManager.getDefaultGUIManager().createGraphletsWindow();
            GUIManager.getDefaultGUIManager().showGraphletsWindow();
        });
        decompSubMenu.add(graphletWindowItem);
        JMenuItem reductionWindowItem = new JMenuItem("Reduction", 48);
        reductionWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompReduction.png"));
        reductionWindowItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        reductionWindowItem.getAccessibleContext().setAccessibleDescription("Decomposition analysis tools");
        reductionWindowItem.addActionListener(arg0 -> {
            GUIManager.getDefaultGUIManager().createReductionWindow();
            GUIManager.getDefaultGUIManager().showReductionsWindow();
        });
        decompSubMenu.add(reductionWindowItem);
        JMenu otherMenu = new JMenu("Other");
        otherMenu.setMnemonic(79);
        otherMenu.getAccessibleContext().setAccessibleDescription("Other, unchecked or under-construction methods");
        this.add(otherMenu);
        JMenu mctOperationsMenu = new JMenu("MCT");
        mctOperationsMenu.setMnemonic(77);
        mctOperationsMenu.getAccessibleContext().setAccessibleDescription("MCT Operations menu");
        mctOperationsMenu.setPreferredSize(new Dimension(1, 38));
        mctOperationsMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        otherMenu.add(mctOperationsMenu);
        JMenuItem genMCTGroups = new JMenuItem("Generate MCT Groups", 49);
        genMCTGroups.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        genMCTGroups.getAccessibleContext().setAccessibleDescription("Generate MCT Groups");
        genMCTGroups.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().generateMCT());
        mctOperationsMenu.add(genMCTGroups);
        JMenuItem createMCTFile = new JMenuItem("Create simple MCT file", 50);
        createMCTFile.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        createMCTFile.getAccessibleContext().setAccessibleDescription("Create simple MCT file");
        createMCTFile.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().io.generateSimpleMCTFile());
        mctOperationsMenu.add(createMCTFile);
        JMenu mctSubMenu = new JMenu("MCT Files");
        mctSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        mctSubMenu.getAccessibleContext().setAccessibleDescription("MCT Generator");
        mctOperationsMenu.add(mctSubMenu);
        JMenuItem mctItem = new JMenuItem("MCT", 51);
        mctItem.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        mctItem.addActionListener(arg0 -> {
            try {
                JOptionPane.showMessageDialog(null, "Not implemented yet.", "Subsystem offline", 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        mctItem.setEnabled(false);
        mctSubMenu.add(mctItem);
        JMenuItem invSimul = new JMenuItem("Invariants Simulation", 54);
        invSimul.setIcon(Tools.getResIcon32("/icons/menu/menu_invSim.png"));
        invSimul.getAccessibleContext().setAccessibleDescription("Start Invariants Simulation");
        invSimul.addActionListener(arg0 -> {
            try {
                JOptionPane.showMessageDialog(null, "Not implemented yet.", "Subsystem offline", 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                GUIManager.getDefaultGUIManager().log("Error: " + e.getMessage(), "error", true);
            }
        });
        otherMenu.add(invSimul);
        JMenuItem fixNet = new JMenuItem("FixArcs", 55);
        fixNet.setIcon(Tools.getResIcon32("/icons/menu/aaa.png"));
        fixNet.getAccessibleContext().setAccessibleDescription("Fix arc problems");
        fixNet.addActionListener(arg0 -> {
            try {
                GUIManager.getDefaultGUIManager().io.fixArcsProblem();
            }
            catch (Exception e) {
                e.printStackTrace();
                GUIManager.getDefaultGUIManager().log("Error: " + e.getMessage(), "error", true);
            }
        });
        JMenu aboutMenu = new JMenu("Help");
        aboutMenu.setMnemonic(72);
        aboutMenu.getAccessibleContext().setAccessibleDescription("Help");
        this.add(aboutMenu);
        JMenuItem aboutItem = new JMenuItem("About Holmes");
        aboutItem.setIcon(Tools.getResIcon32("/icons/menu/menu_about.png"));
        aboutItem.getAccessibleContext().setAccessibleDescription("About the program");
        aboutItem.addActionListener(arg0 -> GUIManager.getDefaultGUIManager().createAboutWindow());
        aboutMenu.add(aboutItem);
    }

    public void addSheetItem(Dockable dockableItem) {
        this.dockables.add(dockableItem);
        DockableMenuItem menuItem = new DockableMenuItem(dockableItem, null);
        this.sheetItems.add(menuItem);
        this.sheetsMenu.add(menuItem);
    }

    public void deleteSheetItem(Dockable dockableItem) {
        int index = this.dockables.indexOf(dockableItem);
        if (index == -1) {
            return;
        }
        this.dockables.remove(index);
        this.sheetItems.remove(index);
        if (index > 0) {
            this.sheetsMenu.remove(index);
        }
    }
}

