/*
 * Decompiled with CFR 0.152.
 */
package holmes.clusters;

import holmes.clusters.ClusterTransition;
import holmes.clusters.Clustering;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;

public class ClusteringExtended {
    public Clustering metaData = null;
    public String[] transNames = new String[1];
    public ArrayList<ArrayList<Integer>> csvInvariants = new ArrayList();
    public ArrayList<ArrayList<Integer>> mctSets = new ArrayList();
    public ArrayList<ArrayList<Integer>> clustersInv = new ArrayList();

    public ArrayList<Integer> getMCTFrequencyInCluster(int clusterIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int mctInd = 0; mctInd < this.mctSets.size(); ++mctInd) {
            ArrayList<Integer> mctRow = this.mctSets.get(mctInd);
            int mctCounterInCluster = 0;
            ArrayList<Integer> invRow = this.clustersInv.get(clusterIndex);
            int rowSize = invRow.size();
            for (int invInd = 0; invInd < rowSize; ++invInd) {
                int invIndex = invRow.get(invInd);
                ArrayList<Integer> transRow = this.csvInvariants.get(invIndex);
                boolean isMCTinInv = this.isSubset(mctRow, transRow);
                if (!isMCTinInv) continue;
                ++mctCounterInCluster;
            }
            result.add(mctCounterInCluster);
        }
        return result;
    }

    public int[][] getTransitionFrequencyNoMCT(int clusterIndex, ArrayList<Integer> getMCTFrequencyInCluster) {
        int[] transFrequency = new int[this.transNames.length];
        int[] realFrequency = new int[this.transNames.length];
        ArrayList invTrans = new ArrayList();
        for (int invInd = 0; invInd < this.clustersInv.get(clusterIndex).size(); ++invInd) {
            int invIndex = this.clustersInv.get(clusterIndex).get(invInd);
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (int i = 1; i < this.csvInvariants.get(invIndex).size(); ++i) {
                if (this.csvInvariants.get(invIndex).get(i) > 0) {
                    transRow.add(1);
                    int n = i;
                    transFrequency[n] = transFrequency[n] + 1;
                    int n2 = i;
                    realFrequency[n2] = realFrequency[n2] + this.csvInvariants.get(invIndex).get(i);
                    continue;
                }
                transRow.add(0);
            }
            invTrans.add(transRow);
        }
        int[] mctTransitions = new int[this.transNames.length];
        int[] mctTransNumber = new int[this.transNames.length];
        for (int mctNumber = 0; mctNumber < getMCTFrequencyInCluster.size(); ++mctNumber) {
            if (getMCTFrequencyInCluster.get(mctNumber) <= 0) continue;
            ArrayList<Integer> mctRow = this.mctSets.get(mctNumber);
            for (int j = 0; j < mctRow.size(); ++j) {
                int trans;
                int n = trans = mctRow.get(j).intValue();
                mctTransitions[n] = mctTransitions[n] + getMCTFrequencyInCluster.get(mctNumber);
                mctTransNumber[trans] = mctNumber + 1;
            }
        }
        int[] realMCTTransFirings = new int[this.transNames.length];
        for (int i = 1; i < transFrequency.length; ++i) {
            int n = i;
            transFrequency[n] = transFrequency[n] - mctTransitions[i];
            if (mctTransitions[i] <= 0) continue;
            realMCTTransFirings[i] = realFrequency[i];
            realFrequency[i] = 0;
        }
        int[][] result = new int[][]{transFrequency, realFrequency, realMCTTransFirings, mctTransNumber};
        return result;
    }

    public ArrayList<String> getNormalizedInvariant(int invNumber, boolean transIndexOnly) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Integer> invRow = new ArrayList<Integer>((Collection)this.csvInvariants.get(invNumber));
        result.add("Inv. #" + invRow.get(0));
        StringBuilder mctCell = new StringBuilder("[");
        boolean alreadyCried = false;
        for (int mct = 0; mct < this.mctSets.size(); ++mct) {
            int tr;
            ArrayList<Integer> mctVector = this.mctSets.get(mct);
            int mctSize = mctVector.size();
            int mctPartsFound = 0;
            for (tr = 0; tr < mctVector.size(); ++tr) {
                if ((Integer)invRow.get(mctVector.get(tr)) <= 0) continue;
                ++mctPartsFound;
            }
            if (mctPartsFound != mctSize) continue;
            mctCell.append(mct + 1).append(",");
            for (tr = 0; tr < mctVector.size(); ++tr) {
                int transToRemove = mctVector.get(tr);
                int oldValue = (Integer)invRow.get(transToRemove);
                if (oldValue > 1 && !alreadyCried) {
                    alreadyCried = true;
                }
                invRow.set(transToRemove, 0);
            }
        }
        mctCell.append("]");
        mctCell = new StringBuilder(mctCell.toString().replace(",]", "]"));
        result.add(mctCell.toString());
        for (int i = 1; i < invRow.size(); ++i) {
            if ((Integer)invRow.get(i) <= 0) continue;
            String transName = this.transNames[i];
            int firing = (Integer)invRow.get(i);
            if (transIndexOnly) {
                result.add("" + (i - 1));
                continue;
            }
            result.add(transName + ":" + firing);
        }
        return result;
    }

    public ArrayList<ArrayList<ClusterTransition>> getClusteringColored() {
        ArrayList<ArrayList<ClusterTransition>> coloredClustering = new ArrayList<ArrayList<ClusterTransition>>();
        if (this.clustersInv.size() > 0) {
            for (int c = 0; c < this.clustersInv.size(); ++c) {
                ArrayList<ClusterTransition> dataRow = new ArrayList<ClusterTransition>();
                ArrayList<Integer> cTrans = this.getTransitionFromCluster(c, false);
                ArrayList<Integer> cFired = this.getTransitionFromCluster(c, true);
                ArrayList<Double> avgFire = new ArrayList<Double>();
                double clSize = this.clustersInv.get(c).size();
                for (int i = 0; i < cFired.size(); ++i) {
                    avgFire.add(cFired.get(i).doubleValue() / clSize);
                }
                ArrayList<Double> tmpCTrans = new ArrayList<Double>();
                for (int i = 0; i < cTrans.size(); ++i) {
                    tmpCTrans.add(cTrans.get(i).doubleValue());
                }
                ArrayList<Color> colorRowTransGrade = this.getTransitionColorsType1(c, false, tmpCTrans);
                ArrayList<Color> colorRowTransScale = this.getTransitionColorsType1(c, true, tmpCTrans);
                ArrayList<Color> colorRowFiredGrade = this.getTransitionColorsType1(c, false, avgFire);
                ArrayList<Color> colorRowFiredScale = this.getTransitionColorsType1(c, true, avgFire);
                for (int trans = 0; trans < colorRowTransGrade.size(); ++trans) {
                    ClusterTransition atomicData = new ClusterTransition(colorRowTransGrade.get(trans), colorRowTransScale.get(trans), colorRowFiredGrade.get(trans), colorRowFiredScale.get(trans), cTrans.get(trans), avgFire.get(trans));
                    dataRow.add(atomicData);
                }
                coloredClustering.add(dataRow);
            }
        }
        return coloredClustering;
    }

    private ArrayList<Color> getTransitionColorsType1(int clusterNumber, boolean scale, ArrayList<Double> data) {
        ArrayList<Double> clusterTransitions = data;
        double max = 0.0;
        for (int i = 0; i < clusterTransitions.size(); ++i) {
            if (!(clusterTransitions.get(i) > max)) continue;
            max = clusterTransitions.get(i);
        }
        if (scale) {
            return this.getColorScale(clusterTransitions, max);
        }
        return this.getColorsForTransitions(clusterTransitions, max);
    }

    private ArrayList<Color> getColorsForTransitions(ArrayList<Double> clusterTransitions, double value) {
        ArrayList<Color> colors = new ArrayList<Color>();
        double step = value / 10.0;
        for (int i = 0; i < clusterTransitions.size(); ++i) {
            double power = clusterTransitions.get(i);
            if (power >= 9.0 * step) {
                colors.add(new Color(25, 105, 0));
                continue;
            }
            if (power >= 8.0 * step) {
                colors.add(new Color(55, 235, 0));
                continue;
            }
            if (power >= 7.0 * step) {
                colors.add(new Color(145, 255, 0));
                continue;
            }
            if (power >= 6.0 * step) {
                colors.add(new Color(239, 255, 0));
                continue;
            }
            if (power >= 5.0 * step) {
                colors.add(new Color(255, 205, 0));
                continue;
            }
            if (power >= 4.0 * step) {
                colors.add(new Color(255, 162, 0));
                continue;
            }
            if (power >= 3.0 * step) {
                colors.add(new Color(255, 94, 0));
                continue;
            }
            if (power == 0.0) {
                colors.add(Color.white);
                continue;
            }
            if (!(power < 3.0 * step)) continue;
            colors.add(new Color(255, 0, 0));
        }
        return colors;
    }

    public ArrayList<Color> getColorScale(ArrayList<Double> clusterTransitions, double value) {
        double blue = 0.0;
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < clusterTransitions.size(); ++i) {
            double red;
            double green;
            double trValue = clusterTransitions.get(i);
            if (trValue == 0.0) {
                colors.add(Color.white);
                continue;
            }
            double power = trValue / value;
            if ((power = 1.0 - power) >= 0.0 && power < 0.5) {
                green = 1.0;
                red = 2.0 * power;
            } else {
                red = 1.0;
                green = 1.0 - 2.0 * (power - 0.5);
            }
            colors.add(new Color((int)(red *= 255.0), (int)(green *= 255.0), (int)(blue *= 255.0)));
        }
        return colors;
    }

    private ArrayList<Integer> getTransitionFromCluster(int clusterNumber, boolean real) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int inv = 0; inv < this.clustersInv.get(clusterNumber).size(); ++inv) {
            int value;
            int tr;
            int invID = this.clustersInv.get(clusterNumber).get(inv);
            ArrayList<Integer> transVector = this.csvInvariants.get(invID);
            if (inv == 0) {
                for (tr = 1; tr < transVector.size(); ++tr) {
                    value = transVector.get(tr);
                    if (real) {
                        result.add(value);
                        continue;
                    }
                    if (value > 0) {
                        result.add(1);
                        continue;
                    }
                    result.add(0);
                }
                continue;
            }
            for (tr = 1; tr < transVector.size(); ++tr) {
                int oldValue;
                value = transVector.get(tr);
                if (real) {
                    oldValue = result.get(tr - 1);
                    result.set(tr - 1, oldValue += value);
                    continue;
                }
                if (value <= 0) continue;
                oldValue = result.get(tr - 1);
                result.set(tr - 1, oldValue + 1);
            }
        }
        return result;
    }

    private boolean isSubset(ArrayList<Integer> subset, ArrayList<Integer> superset) {
        for (int i = 0; i < subset.size(); ++i) {
            boolean transFound = false;
            int transId = subset.get(i);
            for (int j = 1; j < superset.size(); ++j) {
                try {
                    if (superset.get(transId) <= 0) continue;
                    transFound = true;
                    break;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (transFound) continue;
            return false;
        }
        return true;
    }
}

