/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison;

import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Transition;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class KnockoutInvariantComparison {
    private GUIManager overlord;
    private IOprotocols communicationProtocol;
    private ArrayList<Integer> nodesList1;
    private ArrayList<ArrayList<Integer>> invariantsList1 = new ArrayList();
    private ArrayList<Integer> nodesList2;
    private ArrayList<ArrayList<Integer>> invariantsList2 = new ArrayList();
    private ArrayList<ArrayList<Integer>> commonInvariantsList = new ArrayList();
    private ArrayList<ArrayList<Integer>> onlyFirstInvariantsList = new ArrayList();
    private ArrayList<ArrayList<Integer>> onlySecondInvariantsList = new ArrayList();

    public KnockoutInvariantComparison() {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.resetComponents();
        this.communicationProtocol = new IOprotocols();
    }

    private void resetComponents() {
        this.nodesList1 = new ArrayList();
        this.nodesList2 = new ArrayList();
        this.commonInvariantsList = new ArrayList();
        this.onlyFirstInvariantsList = new ArrayList();
        this.onlySecondInvariantsList = new ArrayList();
    }

    public void compare() {
        boolean found;
        this.readT_invariants1("/home/Szavislav/Covid/inv/exportowane.inv");
        ArrayList<ArrayList<Integer>> tmp1 = new ArrayList<ArrayList<Integer>>(this.invariantsList1);
        System.out.println("Wczytywanie I sieci zako\u0144\u0107zone");
        this.readT_invariants2("/home/Szavislav/Covid/inv/49004_tinv.inv");
        ArrayList<ArrayList<Integer>> tmp2 = new ArrayList<ArrayList<Integer>>(this.invariantsList2);
        ArrayList<SimilarityInvarianStructure> ikl = new ArrayList<SimilarityInvarianStructure>();
        System.out.println("Wczytywanie II sieci zako\u0144\u0107zone");
        int count = 0;
        for (ArrayList<Integer> inv_net_1 : this.invariantsList1) {
            System.out.println(count + " \\ " + this.invariantsList1.size());
            ++count;
            found = false;
            int maxDegreeSim = Integer.MAX_VALUE;
            ArrayList<ArrayList<Integer>> listOfDisSimilar = new ArrayList<ArrayList<Integer>>();
            for (ArrayList<Integer> arrayList : this.invariantsList2) {
                int simVal = 0;
                int simDegree = 0;
                for (int i = 0; i < inv_net_1.size(); ++i) {
                    if (inv_net_1.get(i).equals(arrayList.get(i))) {
                        ++simVal;
                    }
                    simDegree += Math.abs(inv_net_1.get(i) - arrayList.get(i));
                }
                if (simVal == inv_net_1.size()) {
                    found = true;
                }
                if (simDegree < maxDegreeSim) {
                    maxDegreeSim = simDegree;
                    listOfDisSimilar.clear();
                    listOfDisSimilar.add(arrayList);
                    continue;
                }
                if (simDegree != maxDegreeSim) continue;
                listOfDisSimilar.add(arrayList);
            }
            if (found) {
                this.commonInvariantsList.add(inv_net_1);
                continue;
            }
            this.onlyFirstInvariantsList.add(inv_net_1);
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            for (ArrayList integers : listOfDisSimilar) {
                tmp.add(this.invariantsList2.indexOf(integers));
            }
            ikl.add(new SimilarityInvarianStructure(this.invariantsList1.indexOf(inv_net_1), tmp));
        }
        count = 0;
        for (ArrayList<Integer> inv_net_2 : this.invariantsList2) {
            System.out.println(count + " \\ " + this.invariantsList1.size());
            ++count;
            found = false;
            for (ArrayList<Integer> inv_net_1 : this.invariantsList1) {
                int simVal = 0;
                for (int i = 0; i < inv_net_1.size(); ++i) {
                    if (!inv_net_1.get(i).equals(inv_net_2.get(i))) continue;
                    ++simVal;
                }
                if (simVal != inv_net_1.size()) continue;
                found = true;
            }
            if (found) continue;
            this.onlySecondInvariantsList.add(inv_net_2);
        }
        if (this.commonInvariantsList.size() > 0) {
            this.communicationProtocol.writeT_invINA("/home/Szavislav/Covid/inv/comp1", this.commonInvariantsList, this.overlord.getWorkspace().getProject().getTransitions());
            System.out.println("Zapisywanie wsp\u00f3lnych invariant\u00f3w zako\u0144\u0107zone");
        }
        if (this.commonInvariantsList.size() > 0) {
            this.communicationProtocol.writeT_invINA("/home/Szavislav/Covid/inv/comp2", this.onlyFirstInvariantsList, this.overlord.getWorkspace().getProject().getTransitions());
            System.out.println("Zapisywanie invariant\u00f3w wyst\u0119puj\u0105cych jedynie w orginalnej sieci zako\u0144\u0107zone");
        }
        if (this.commonInvariantsList.size() > 0) {
            this.communicationProtocol.writeT_invINA("/home/Szavislav/Covid/inv/comp3", this.onlySecondInvariantsList, this.overlord.getWorkspace().getProject().getTransitions());
            System.out.println("Zapisywanie invariant\u00f3w wyst\u0119puj\u0105cych jedynie w knockoutowej sieci zako\u0144\u0107zone");
        }
        if (ikl.size() > 0) {
            this.writeSimTinv("/home/Szavislav/Covid/inv/comp4", ikl);
            System.out.println("Zapisywanie matchowania 1 to 2 invariant\u00f3w zako\u0144\u0107zone");
        }
    }

    public void checkInvariants() {
        String pathToResult = "/home/Szavislav/SARS-Cov-2/wynik.txt";
        String pathToNet_I = "/home/Szavislav/SARS-Cov-2/0-6-8-bez-sarsa.pnt";
        String pathToNet_II = "/home/Szavislav/SARS-Cov-2/sars-cov-2_v-0-6-8_2021-01-06_DF_PF_KG.pnt";
        String pathToInv_I = "/home/Szavislav/SARS-Cov-2/bez.inv";
        String pathToInv_II = "/home/Szavislav/SARS-Cov-2/z.inv";
        try {
            String readLine;
            DataInputStream in = new DataInputStream(new FileInputStream(pathToResult));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            Boolean readTransitions = false;
            HashMap<Integer, Integer> supportMap = new HashMap<Integer, Integer>();
            boolean count = false;
            while ((readLine = buffer.readLine()) != null) {
                String[] line = readLine.split("inv_2:");
                String line_3 = line[0].replaceAll("inv_1:", "");
                String val1 = line_3.replaceAll("\\s+", "");
                int lnv_1 = Integer.parseInt(val1);
                String[] line_2 = line[1].split("value:");
                String val = line_2[0].replaceAll("\\s+", "");
                int n = Integer.parseInt(val);
                supportMap.put(lnv_1, n);
            }
            supportMap.size();
            HashMap<Integer, String> mapIdNameI = this.readNetSupport(pathToNet_I);
            HashMap<Integer, String> mapIdNameII = this.readNetSupport(pathToNet_II);
            ArrayList<ArrayList<Integer>> mapIdFiringI = this.readNetInvariants(pathToInv_I);
            ArrayList<ArrayList<Integer>> mapIdFiringII = this.readNetInvariants(pathToInv_II);
            HashMap<Integer, Integer> matchedNodes = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, String> entry : mapIdNameI.entrySet()) {
                for (Map.Entry<Integer, String> secondPair : mapIdNameII.entrySet()) {
                    if (!entry.getValue().equals(secondPair.getValue())) continue;
                    matchedNodes.put(entry.getKey(), secondPair.getKey());
                    System.out.format("Matched :" + entry.getKey() + " - " + secondPair.getKey() + " - " + entry.getValue() + "\n", new Object[0]);
                }
            }
            for (Map.Entry<Integer, String> entry : supportMap.entrySet()) {
                Integer key = entry.getKey();
                Integer value = (Integer)((Object)entry.getValue());
                ArrayList<Integer> invariant = mapIdFiringI.get(key);
                boolean invariantsMMatched = true;
                for (int i = 0; i < invariant.size(); ++i) {
                    if (invariant.get(i).intValue() == mapIdFiringII.get(value).get((Integer)matchedNodes.get(i)).intValue()) continue;
                    invariantsMMatched = false;
                }
                if (invariantsMMatched) continue;
                System.out.println("NOT MATCHED : " + key + " - " + value);
                System.out.println("net1 inv : " + Arrays.toString(invariant.toArray()));
                System.out.println("net2 inv : " + Arrays.toString(mapIdFiringII.get(value).toArray()));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void getUnused() {
        String pathToInv_I = "/home/Szavislav/SARS-Cov-2/bez.inv";
        String pathToInv_II = "/home/Szavislav/SARS-Cov-2/z.inv";
        String pathToNet_I = "/home/Szavislav/SARS-Cov-2/0-6-8-bez-sarsa.pnt";
        String pathToNet_II = "/home/Szavislav/SARS-Cov-2/sars-cov-2_v-0-6-8_2021-01-06_DF_PF_KG.pnt";
        String pathToResult = "/home/Szavislav/SARS-Cov-2/wynik.txt";
        try {
            String readLine;
            DataInputStream in = new DataInputStream(new FileInputStream(pathToResult));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            Boolean readTransitions = false;
            ArrayList<Integer> listOFFoundInvariants = new ArrayList<Integer>();
            boolean count = false;
            while ((readLine = buffer.readLine()) != null) {
                String[] line = readLine.split("inv_2:");
                String[] line_2 = line[1].split("value:");
                String val = line_2[0].replaceAll("\\s+", "");
                int lnv_2 = Integer.parseInt(val);
                listOFFoundInvariants.add(lnv_2);
            }
            ArrayList<ArrayList<Integer>> inv = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
            ArrayList<ArrayList<Integer>> result_Inv = new ArrayList<ArrayList<Integer>>();
            for (int i = 0; i < inv.size(); ++i) {
                if (listOFFoundInvariants.contains(i)) continue;
                result_Inv.add(inv.get(i));
                System.out.println("new un usded inv " + i);
            }
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().setT_InvMatrix(result_Inv, false);
            IOprotocols io = new IOprotocols();
            io.writeT_invINA("/home/Szavislav/SARS-Cov-2/covidoveInvarianty.inv", result_Inv, GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions());
            System.out.println("Done ");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void compare_new() {
        String pathToInv_I = "/home/Szavislav/SARS-Cov-2/bez.inv";
        String pathToInv_II = "/home/Szavislav/SARS-Cov-2/z.inv";
        String pathToNet_I = "/home/Szavislav/SARS-Cov-2/0-6-8-bez-sarsa.pnt";
        String pathToNet_II = "/home/Szavislav/SARS-Cov-2/sars-cov-2_v-0-6-8_2021-01-06_DF_PF_KG.pnt";
        HashMap<Integer, String> mapIdNameI = this.readNetSupport(pathToNet_I);
        HashMap<Integer, String> mapIdNameII = this.readNetSupport(pathToNet_II);
        ArrayList<ArrayList<Integer>> mapIdFiringI = this.readNetInvariants(pathToInv_I);
        ArrayList<ArrayList<Integer>> mapIdFiringII = this.readNetInvariants(pathToInv_II);
        ArrayList<String> resultsHeuI = this.heuristic_I(mapIdNameI, mapIdNameII, mapIdFiringI, mapIdFiringII, false);
        try {
            FileWriter writer = new FileWriter("/home/Szavislav/SARS-Cov-2/wynik.txt");
            for (String str : resultsHeuI) {
                writer.write(str + System.lineSeparator());
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String line : resultsHeuI) {
            System.out.println(line);
        }
    }

    private ArrayList<String> heuristic_I(HashMap<Integer, String> mapIdNameI, HashMap<Integer, String> mapIdNameII, ArrayList<ArrayList<Integer>> mapIdFiringI, ArrayList<ArrayList<Integer>> mapIdFiringII, boolean type) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<Integer, Integer> matchedNodes = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, String> entry : mapIdNameI.entrySet()) {
            for (Map.Entry<Integer, String> entry2 : mapIdNameII.entrySet()) {
                if (!entry.getValue().equals(entry2.getValue())) continue;
                matchedNodes.put(entry.getKey(), entry2.getKey());
                System.out.format("Matched :" + entry.getKey() + " - " + entry2.getKey() + " - " + entry.getValue() + "\n", new Object[0]);
            }
        }
        ArrayList<Integer> unmatchedNodesI = new ArrayList<Integer>();
        for (Map.Entry<Integer, String> entry : mapIdNameI.entrySet()) {
            if (matchedNodes.containsKey(entry.getKey())) continue;
            unmatchedNodesI.add(entry.getKey());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<Integer, String> entry : mapIdNameII.entrySet()) {
            if (matchedNodes.containsValue(entry.getKey())) continue;
            arrayList.add(entry.getKey());
        }
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < mapIdFiringI.size(); ++i) {
            System.out.println("i - " + i + " / " + mapIdFiringI.size());
            double maxVal = -1.0;
            int maxIndex = -1;
            for (int j = 0; j < mapIdFiringII.size(); ++j) {
                double val;
                if (arrayList3.contains(j) || !((val = type ? (double)this.matchSupportsAndVectors(mapIdFiringI.get(i), mapIdFiringII.get(j), matchedNodes, unmatchedNodesI, arrayList) : this.matchSupports(mapIdFiringI.get(i), mapIdFiringII.get(j), matchedNodes, unmatchedNodesI, arrayList)) > maxVal)) continue;
                maxVal = val;
                maxIndex = j;
            }
            arrayList2.add(maxVal);
            arrayList3.add(maxIndex);
            String line = "inv_1: " + i + " inv_2: " + maxIndex + " value: " + maxVal;
            result.add(line);
        }
        return result;
    }

    private double matchSupports(ArrayList<Integer> inv1, ArrayList<Integer> inv2, HashMap<Integer, Integer> matchedNodes, ArrayList<Integer> unmatchedNodesI, ArrayList<Integer> unmatchedNodesII) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int index = 0; index < inv1.size(); ++index) {
            int supportMatch;
            if (matchedNodes.containsKey(index)) {
                int secondInvariantIndex = matchedNodes.get(index);
                supportMatch = inv1.get(index) > 0 && inv2.get(secondInvariantIndex) > 0 ? 1 : (inv1.get(index) == 0 && inv2.get(secondInvariantIndex) == 0 ? 0 : -1);
            } else {
                supportMatch = -1;
            }
            values.add(supportMatch);
        }
        long counted = values.stream().filter(x -> x > 0).count();
        long maxCounted = inv1.stream().filter(x -> x > 0).count();
        double value = (double)counted * 1.0 / (double)maxCounted;
        return value;
    }

    private int matchSupportsAndVectors(ArrayList<Integer> integers, ArrayList<Integer> integers1, HashMap<Integer, Integer> matchedNodes, ArrayList<Integer> unmatchedNodesI, ArrayList<Integer> unmatchedNodesII) {
        return 0;
    }

    private ArrayList<ArrayList<Integer>> readNetInvariants(String pathToInv_i) {
        ArrayList<ArrayList<Integer>> readedTransitions = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> nodesList = new ArrayList<Integer>();
        try {
            String readLine;
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(pathToInv_i));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String backup = readLine = buffer.readLine();
            if (backup.contains("transition invariants basis")) {
                JOptionPane.showMessageDialog(null, "Wrong invariants. Only semipositives are acceptable.", "ERROR:readINV", 0);
                buffer.close();
                return readedTransitions;
            }
            buffer.readLine();
            while (!readLine.contains("semipositive transition invariants =")) {
                readLine = buffer.readLine();
            }
            buffer.readLine();
            nodesList.clear();
            while (!(readLine = buffer.readLine()).endsWith("~~~~~~~~~~~") && !readLine.endsWith("~~~~~~~~~~~")) {
                String[] formattedLine;
                for (String s : formattedLine = readLine.split(" ")) {
                    if (s.isEmpty() || s.contains("Nr.")) continue;
                    try {
                        nodesList.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        this.overlord.log("Reading file failed in header section.", "text", true);
                    }
                }
            }
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            while ((readLine = buffer.readLine()) != null && !readLine.contains("@") && !readLine.isEmpty()) {
                String[] formattedLine = readLine.split("\\|");
                for (String s : formattedLine = formattedLine[1].split(" ")) {
                    if (s.isEmpty()) continue;
                    tmpInvariant.add(Integer.parseInt(s));
                }
                if (tmpInvariant.size() != nodesList.size()) continue;
                readedTransitions.add(tmpInvariant);
                tmpInvariant = new ArrayList();
            }
            buffer.close();
            this.overlord.log("T-invariants from INA file have been read.", "text", true);
            return readedTransitions;
        }
        catch (Exception e) {
            this.overlord.log("T-invariants reading operation failed.", "error", true);
            return new ArrayList<ArrayList<Integer>>();
        }
    }

    private HashMap<Integer, String> readNetSupport(String pathToNet_i) {
        HashMap<Integer, String> mapIdName = new HashMap<Integer, String>();
        try {
            String readLine;
            DataInputStream in = new DataInputStream(new FileInputStream(pathToNet_i));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String backup = readLine = buffer.readLine();
            boolean readTransitions = false;
            while ((readLine = buffer.readLine()) != null) {
                if (readTransitions) {
                    if (readLine.contains("@")) {
                        return mapIdName;
                    }
                    String[] splited = readLine.split(": ");
                    String cleaned = splited[0].replaceAll("\\s+", "");
                    System.out.println(readLine + " number spliting " + splited.length);
                    mapIdName.put(Integer.parseInt(cleaned), splited[1]);
                }
                if (!readLine.contains("trans nr.             name priority time")) continue;
                readTransitions = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mapIdName;
    }

    public void compare_inv_lab() {
        this.readT_invariants1("/home/Szavislav/SARS-Cov-2/bez.inv");
        IOprotocols io = new IOprotocols();
        io.readPNT("/home/Szavislav/SARS-Cov-2/0-6-8-bez-sarsa.pnt");
        PetriNet pn1 = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        System.out.println("Wczytywanie I sieci zako\u0144\u0107zone - liczba inwariant\u00f3w = " + this.invariantsList1.size());
        ArrayList<Transition> pn1T = pn1.getTransitions();
        this.readT_invariants2("/home/Szavislav/SARS-Cov-2/z.inv");
        io.readPNT("/home/Szavislav/SARS-Cov-2/sars-cov-2_v-0-6-8_2021-01-06_DF_PF_KG.pnt");
        PetriNet pn2 = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        ArrayList ikl = new ArrayList();
        System.out.println("Wczytywanie II sieci zako\u0144\u0107zone - liczba inwariant\u00f3w = " + this.invariantsList2.size());
        ArrayList<ArrayList<Integer>> TMPinvariantsList2 = new ArrayList<ArrayList<Integer>>(this.invariantsList2);
        ArrayList<MatchedInvariants> invariantsMatchings = new ArrayList<MatchedInvariants>();
        ArrayList<Transition> pn2T = pn2.getTransitions();
        for (int k = 0; k < this.invariantsList1.size(); ++k) {
            ArrayList<Integer> inv_net_1 = this.invariantsList1.get(k);
            if (TMPinvariantsList2.size() == 0) break;
            ArrayList<Integer> commonPartSum = new ArrayList<Integer>();
            ArrayList commonPart = new ArrayList();
            for (int j = 0; j < TMPinvariantsList2.size(); ++j) {
                ArrayList<Integer> part = new ArrayList<Integer>();
                int value = 0;
                for (int i = 0; i < inv_net_1.size(); ++i) {
                    for (int b = 0; b < TMPinvariantsList2.get(j).size(); ++b) {
                        System.out.println(i + " - " + j + " - " + b);
                        if (inv_net_1.get(i) == 0 || TMPinvariantsList2.get(j).get(b) == 0 || !pn1T.get(i).getName().equals(pn2T.get(b).getName())) continue;
                        value += inv_net_1.get(i).intValue();
                        part.add(inv_net_1.get(i));
                    }
                }
                commonPartSum.add(value);
                commonPart.add(part);
            }
            int maxCommon = commonPartSum.stream().mapToInt(x -> x).max().orElse(0);
            int indexOfBeastMatch = commonPartSum.indexOf(maxCommon);
            int index = this.invariantsList2.indexOf(TMPinvariantsList2.get(indexOfBeastMatch));
            MatchedInvariants mi = new MatchedInvariants(inv_net_1, this.invariantsList2.get(index), (ArrayList)commonPart.get(indexOfBeastMatch));
            System.out.println("Dopasowanie: oryginalny inwariant : " + k + " ; knockoutowany inwariant : " + index + " ; sorensen index : " + mi.index_Sorensen);
            invariantsMatchings.add(mi);
            TMPinvariantsList2.remove(indexOfBeastMatch);
        }
    }

    public void compare_baldan_cocco() {
        this.readT_invariants1("/home/Szavislav/SARS-Cov-2/0-6-8-bez-sarsa-tinv-ElementaryModes.inv");
        System.out.println("Wczytywanie I sieci zako\u0144\u0107zone - liczba inwariant\u00f3w = " + this.invariantsList1.size());
        this.readT_invariants2("/home/Szavislav/SARS-Cov-2/t-inv-0-6-8-ElementaryModes.inv");
        ArrayList ikl = new ArrayList();
        System.out.println("Wczytywanie II sieci zako\u0144\u0107zone");
        ArrayList<ArrayList<Integer>> TMPinvariantsList2 = new ArrayList<ArrayList<Integer>>(this.invariantsList2);
        ArrayList<MatchedInvariants> invariantsMatchings = new ArrayList<MatchedInvariants>();
        for (int k = 0; k < this.invariantsList1.size(); ++k) {
            ArrayList<Integer> inv_net_1 = this.invariantsList1.get(k);
            if (TMPinvariantsList2.size() == 0) break;
            double index_Sorensen = -1.0;
            double index_Tanimoto = -1.0;
            double index_Jacard = -1.0;
            ArrayList<Integer> commonPartSum = new ArrayList<Integer>();
            ArrayList commonPart = new ArrayList();
            for (ArrayList<Integer> integers : TMPinvariantsList2) {
                ArrayList<Integer> part = new ArrayList<Integer>();
                int value = 0;
                for (int i = 0; i < inv_net_1.size(); ++i) {
                    if (inv_net_1.get(i).equals(integers.get(i))) {
                        value += inv_net_1.get(i).intValue();
                        part.add(inv_net_1.get(i));
                        continue;
                    }
                    value += Math.min(inv_net_1.get(i), integers.get(i));
                    part.add(Math.min(inv_net_1.get(i), integers.get(i)));
                }
                commonPartSum.add(value);
                commonPart.add(part);
            }
            int maxCommon = commonPartSum.stream().mapToInt(x -> x).max().orElse(0);
            int indexOfBeastMatch = commonPartSum.indexOf(maxCommon);
            int index = this.invariantsList2.indexOf(TMPinvariantsList2.get(indexOfBeastMatch));
            MatchedInvariants mi = new MatchedInvariants(inv_net_1, this.invariantsList2.get(index), (ArrayList)commonPart.get(indexOfBeastMatch));
            System.out.println("Dopasowanie: oryginalny inwariant : " + k + " ; knockoutowany inwariant : " + index + " ; sorensen index : " + mi.index_Sorensen);
            invariantsMatchings.add(mi);
            TMPinvariantsList2.remove(indexOfBeastMatch);
        }
        double index_I = 0.0;
        double index_II = 0.0;
        double index_III = 0.0;
        double index_Sorensen = 0.0;
        double index_Tanimoto = 0.0;
        double index_Jacard = 0.0;
        for (MatchedInvariants invariantsMatching : invariantsMatchings) {
            index_I += invariantsMatching.index_I;
            index_II += invariantsMatching.index_II;
            index_III += invariantsMatching.index_III;
            index_Jacard += invariantsMatching.index_Jacard;
            index_Tanimoto += invariantsMatching.index_Tanimoto;
            index_Sorensen += invariantsMatching.index_Sorensen;
        }
        System.out.println("Sumy");
        System.out.println("Index I " + index_I);
        System.out.println("Index II " + index_II);
        System.out.println("Index III " + index_III);
        System.out.println("Jackard Index " + index_Jacard);
        System.out.println("Tanimoto Index " + index_Tanimoto);
        System.out.println("Sorensen Index " + index_Sorensen);
        System.out.println("Suma / proper invariant count");
        System.out.println("Index I " + index_I / (double)this.invariantsList1.size());
        System.out.println("Index II " + index_II / (double)this.invariantsList1.size());
        System.out.println("Index III " + index_III / (double)this.invariantsList1.size());
        System.out.println("Jackard Index " + index_Jacard / (double)this.invariantsList1.size());
        System.out.println("Tanimoto Index " + index_Tanimoto / (double)this.invariantsList1.size());
        System.out.println("Sorensen Index " + index_Sorensen / (double)this.invariantsList1.size());
        System.out.println("Suma / matched invariant count");
        System.out.println("Index I " + index_I / (double)invariantsMatchings.size());
        System.out.println("Index II " + index_II / (double)invariantsMatchings.size());
        System.out.println("Index III " + index_III / (double)invariantsMatchings.size());
        System.out.println("Jackard Index " + index_Jacard / (double)invariantsMatchings.size());
        System.out.println("Tanimoto Index " + index_Tanimoto / (double)invariantsMatchings.size());
        System.out.println("Sorensen Index " + index_Sorensen / (double)invariantsMatchings.size());
    }

    public void writeSimTinv(String path, ArrayList<SimilarityInvarianStructure> invariants) {
        try {
            String extension = "";
            if (!path.contains(".comp")) {
                extension = ".comp";
            }
            PrintWriter pw = new PrintWriter(path + extension);
            pw.print("\r\n");
            pw.print("\r\n");
            pw.print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            pw.print("\r\n");
            pw.print("Original invariant: Konckout invariants");
            for (SimilarityInvarianStructure invariant : invariants) {
                StringBuilder knocked = new StringBuilder();
                for (Integer in : invariant.knockedInvariantIndexes) {
                    knocked.append(in).append(",");
                }
                pw.print(invariant.originalInvariantindex + " :   " + knocked);
                pw.print("\r\n");
            }
            pw.print("\r\n");
            pw.print("@");
            pw.close();
            this.overlord.log("T-invariants in INA file format saved to " + path, "text", true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR: writeT_invINA", 0);
            this.overlord.log("Error: " + e.getMessage(), "error", true);
        }
    }

    private String convertIntToStr(boolean large, int tr) {
        if (large) {
            if (tr < 10) {
                return "    " + tr;
            }
            if (tr < 100) {
                return "   " + tr;
            }
            if (tr < 1000) {
                return "  " + tr;
            }
            return " " + tr;
        }
        if (tr < 10) {
            return "   " + tr;
        }
        if (tr < 100) {
            return "  " + tr;
        }
        return " " + tr;
    }

    public boolean readT_invariants1(String path) {
        try {
            String readLine;
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String backup = readLine = buffer.readLine();
            if (backup.contains("transition invariants basis")) {
                JOptionPane.showMessageDialog(null, "Wrong invariants. Only semipositives are acceptable.", "ERROR:readINV", 0);
                buffer.close();
                return false;
            }
            buffer.readLine();
            while (!readLine.contains("semipositive transition invariants =")) {
                readLine = buffer.readLine();
            }
            buffer.readLine();
            this.nodesList1.clear();
            while (!(readLine = buffer.readLine()).endsWith("~~~~~~~~~~~") && !readLine.endsWith("~~~~~~~~~~~")) {
                String[] formattedLine;
                for (String s : formattedLine = readLine.split(" ")) {
                    if (s.isEmpty() || s.contains("Nr.")) continue;
                    try {
                        this.nodesList1.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        this.overlord.log("Reading file failed in header section.", "text", true);
                    }
                }
            }
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            this.invariantsList1.clear();
            while ((readLine = buffer.readLine()) != null && !readLine.contains("@") && !readLine.isEmpty()) {
                String[] formattedLine = readLine.split("\\|");
                for (String s : formattedLine = formattedLine[1].split(" ")) {
                    if (s.isEmpty()) continue;
                    tmpInvariant.add(Integer.parseInt(s));
                }
                if (tmpInvariant.size() != this.nodesList1.size()) continue;
                this.invariantsList1.add(tmpInvariant);
                tmpInvariant = new ArrayList();
            }
            buffer.close();
            this.overlord.log("T-invariants from INA file have been read.", "text", true);
            return true;
        }
        catch (Exception e) {
            this.overlord.log("T-invariants reading operation failed.", "error", true);
            return false;
        }
    }

    public boolean readT_invariants2(String path) {
        try {
            String readLine;
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String backup = readLine = buffer.readLine();
            if (backup.contains("transition invariants basis")) {
                JOptionPane.showMessageDialog(null, "Wrong invariants. Only semipositives are acceptable.", "ERROR:readINV", 0);
                buffer.close();
                return false;
            }
            buffer.readLine();
            while (!readLine.contains("semipositive transition invariants =")) {
                readLine = buffer.readLine();
            }
            buffer.readLine();
            this.nodesList2.clear();
            while (!(readLine = buffer.readLine()).endsWith("~~~~~~~~~~~") && !readLine.endsWith("~~~~~~~~~~~")) {
                String[] formattedLine;
                for (String s : formattedLine = readLine.split(" ")) {
                    if (s.isEmpty() || s.contains("Nr.")) continue;
                    try {
                        this.nodesList2.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        this.overlord.log("Reading file failed in header section.", "text", true);
                    }
                }
            }
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            this.invariantsList2.clear();
            while ((readLine = buffer.readLine()) != null && !readLine.contains("@") && !readLine.isEmpty()) {
                String[] formattedLine = readLine.split("\\|");
                for (String s : formattedLine = formattedLine[1].split(" ")) {
                    if (s.isEmpty()) continue;
                    tmpInvariant.add(Integer.parseInt(s));
                }
                if (tmpInvariant.size() != this.nodesList2.size()) continue;
                this.invariantsList2.add(tmpInvariant);
                tmpInvariant = new ArrayList();
            }
            buffer.close();
            this.overlord.log("T-invariants from INA file have been read.", "text", true);
            return true;
        }
        catch (Exception e) {
            this.overlord.log("T-invariants reading operation failed.", "error", true);
            return false;
        }
    }

    public class SimilarityInvarianStructure {
        public ArrayList<Integer> originalInvariant = new ArrayList();
        public ArrayList<ArrayList<Integer>> knockedInvariants = new ArrayList();
        public int originalInvariantindex = -1;
        public ArrayList<Integer> knockedInvariantIndexes = new ArrayList();

        public SimilarityInvarianStructure(ArrayList<Integer> oi, ArrayList<ArrayList<Integer>> ki) {
            this.originalInvariant = oi;
            this.knockedInvariants = ki;
        }

        public SimilarityInvarianStructure(int oi, ArrayList<Integer> ki) {
            this.originalInvariantindex = oi;
            this.knockedInvariantIndexes = ki;
        }
    }

    public class MatchedInvariants {
        public ArrayList<Integer> firstNetInvariant;
        public ArrayList<Integer> secondNetInvariant;
        public ArrayList<Integer> commonPart;
        public ArrayList<Integer> maxPart;
        public double index_I;
        public double index_II;
        public double index_III;
        public double index_Sorensen;
        public double index_Tanimoto;
        public double index_Jacard;

        public MatchedInvariants(ArrayList<Integer> fni, ArrayList<Integer> sni, ArrayList<Integer> cp) {
            this.firstNetInvariant = fni;
            this.secondNetInvariant = sni;
            this.commonPart = cp;
            this.maxPart = new ArrayList();
            double AB = 0.0;
            double A2 = 0.0;
            double B2 = 0.0;
            for (int i = 0; i < this.firstNetInvariant.size() || i < this.secondNetInvariant.size(); ++i) {
                this.maxPart.add(Math.max(this.firstNetInvariant.get(i), this.secondNetInvariant.get(i)));
                AB += (double)(this.firstNetInvariant.get(i) * this.secondNetInvariant.get(i));
                A2 += (double)(this.firstNetInvariant.get(i) * this.firstNetInvariant.get(i));
                B2 += (double)(this.secondNetInvariant.get(i) * this.secondNetInvariant.get(i));
            }
            double fniSUM = this.firstNetInvariant.stream().mapToInt(Integer::intValue).sum();
            double sniSUM = this.secondNetInvariant.stream().mapToInt(Integer::intValue).sum();
            double cpSUM = this.commonPart.stream().mapToInt(Integer::intValue).sum();
            double mpSUM = this.maxPart.stream().mapToInt(Integer::intValue).sum();
            this.index_I = fniSUM + sniSUM - 2.0 * cpSUM;
            this.index_II = cpSUM * cpSUM / (2.0 * AB);
            this.index_III = (1.0 - this.index_II) / (fniSUM + sniSUM);
            this.index_Jacard = cpSUM / mpSUM;
            this.index_Tanimoto = AB / (A2 + B2 - AB);
            this.index_Sorensen = 2.0 * cpSUM / (sniSUM + fniSUM);
        }
    }
}

