/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class GatherData {
    String directory = "/home/bszawulak/Dokumenty/Eksperyment/Wyniki";
    Double[][][][] branchResult;
    Double[][][][] drgfResults;
    Integer[][][][][] drgfValues;
    Integer[][][][][] branchValues;
    int numberOfGraphlets = 151;

    public GatherData(boolean t) {
        this.branchValues = new Integer[8][8][100][6][50];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int p = 0; p < 100; ++p) {
                    this.branchValues[i][j][p][0] = this.extractedBr(i, j, p, "branch-similarity-V0");
                    this.branchValues[i][j][p][1] = this.extractedBr(i, j, p, "branch-similarity-V1");
                    this.branchValues[i][j][p][2] = this.extractedBr(i, j, p, "branch-similarity-V2");
                    this.branchValues[i][j][p][3] = this.extractedBr(i, j, p, "branch-similarity-V3");
                    this.branchValues[i][j][p][4] = this.extractedBr(i, j, p, "branch-similarity-V4");
                    this.branchValues[i][j][p][5] = this.extractedBr(i, j, p, "branch-similarity-V5");
                }
            }
        }
        this.branchResult = new Double[8][8][6][3];
        for (int type = 0; type < 6; ++type) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    Double[][] forSingleNet = new Double[100][3];
                    ArrayList min = new ArrayList();
                    ArrayList max = new ArrayList();
                    ArrayList<Double> avg = new ArrayList<Double>();
                    for (int p1 = 0; p1 < 100; ++p1) {
                    }
                    this.branchResult[i][j][type][0] = (Double)Collections.max(max);
                    this.branchResult[i][j][type][1] = (Double)Collections.min(min);
                    this.branchResult[i][j][type][2] = this.average(avg);
                }
            }
        }
        this.compressDataToCSV();
    }

    private void compressDataToCSV() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.directory + "/DRGF-RESULTS.txt");
            for (int type = 0; type < 10; ++type) {
                writer.append("type" + type + "\n");
                for (int mma = 0; mma < 3; ++mma) {
                    writer.append("mma" + mma + "\n");
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            writer.append(this.drgfResults[i][j][type][mma].toString());
                            writer.append(",");
                        }
                        writer.append("\n");
                    }
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GatherData() {
        this.drgfValues = new Integer[8][8][100][10][151];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int p = 0; p < 100; ++p) {
                    this.drgfValues[i][j][p][0] = this.extracted(i, j, p, "BASE");
                    this.drgfValues[i][j][p][1] = this.extracted(i, j, p, "C6VARIANT");
                    this.drgfValues[i][j][p][2] = this.extracted(i, j, p, "E2VARIANT");
                    this.drgfValues[i][j][p][3] = this.extracted(i, j, p, "K4LkVARIANT");
                    this.drgfValues[i][j][p][4] = this.extracted(i, j, p, "K4LVARIANT");
                    this.drgfValues[i][j][p][5] = this.extracted(i, j, p, "P3VARIANT");
                    this.drgfValues[i][j][p][6] = this.extracted(i, j, p, "S4VARIANT");
                    this.drgfValues[i][j][p][7] = this.extracted(i, j, p, "SS4VARIANT");
                    this.drgfValues[i][j][p][8] = this.extracted(i, j, p, "SSS4VARIANT");
                    this.drgfValues[i][j][p][9] = this.extracted(i, j, p, "ALLVARIANT");
                }
            }
        }
        this.drgfResults = new Double[8][8][10][3];
        for (int type = 0; type < 10; ++type) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    Double[][] forSingleNet = new Double[100][3];
                    ArrayList<Double> min = new ArrayList<Double>();
                    ArrayList<Double> max = new ArrayList<Double>();
                    ArrayList<Double> avg = new ArrayList<Double>();
                    for (int p1 = 0; p1 < 100; ++p1) {
                        ArrayList<Double> result = new ArrayList<Double>();
                        for (int p2 = 0; p2 < 100; ++p2) {
                            if (p1 == p2) continue;
                            result.add(this.compareDRGF(Arrays.stream(this.drgfValues[i][j][p1][type]).mapToLong(k -> k.intValue()).toArray(), Arrays.stream(this.drgfValues[i][j][p2][type]).mapToLong(k -> k.intValue()).toArray()));
                        }
                        min.add((Double)Collections.min(result));
                        max.add((Double)Collections.max(result));
                        avg.add(this.average(result));
                    }
                    this.drgfResults[i][j][type][0] = (Double)Collections.max(max);
                    this.drgfResults[i][j][type][1] = (Double)Collections.min(min);
                    this.drgfResults[i][j][type][2] = this.average(avg);
                }
            }
        }
        this.compressDRGFDataToCSV();
    }

    private void compressDRGFDataToCSV() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.directory + "/DRGF-RESULTS.txt");
            for (int type = 0; type < 10; ++type) {
                writer.append("type" + type + "\n");
                for (int mma = 0; mma < 3; ++mma) {
                    writer.append("mma" + mma + "\n");
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            writer.append(this.drgfResults[i][j][type][mma].toString());
                            writer.append(",");
                        }
                        writer.append("\n");
                    }
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double compareDRGF(long[] firstSingleDRGF, long[] secondSingleDRGF) {
        long firstSum = Arrays.stream(firstSingleDRGF).sum();
        long secondSum = Arrays.stream(secondSingleDRGF).sum();
        long[] distanceDRGF = new long[this.numberOfGraphlets];
        double result = 0.0;
        for (int i = 0; i < this.numberOfGraphlets; ++i) {
            if ((double)firstSingleDRGF[i] != 0.0 && (double)secondSingleDRGF[i] != 0.0) {
                result += Math.abs(Math.log(firstSingleDRGF[i]) / Math.log(firstSum) - Math.log(secondSingleDRGF[i]) / Math.log(secondSum));
                continue;
            }
            if ((double)firstSingleDRGF[i] != 0.0) {
                result += Math.abs(Math.log(firstSingleDRGF[i]) / Math.log(firstSum) - 0.0);
                continue;
            }
            if ((double)secondSingleDRGF[i] == 0.0) continue;
            result += Math.abs(0.0 - Math.log(secondSingleDRGF[i]) / Math.log(secondSum));
        }
        return result;
    }

    private Integer[] extracted(int i, int j, int p, String name) {
        ArrayList<String[]> records = new ArrayList<String[]>();
        String tmp = this.directory + this.setPath(i * 5, j * 5, p) + "DRGF-" + name + ".txt";
        try (BufferedReader br2 = new BufferedReader(new FileReader(tmp));){
            String line;
            while ((line = br2.readLine()) != null) {
                String[] values = line.split(",");
                records.add(values);
            }
        }
        catch (Exception br2) {
            // empty catch block
        }
        Integer[] result = new Integer[((String[])records.get(0)).length];
        for (int k = 0; k < ((String[])records.get(0)).length; ++k) {
            result[k] = Integer.parseInt(((String[])records.get(0))[k]);
        }
        return result;
    }

    private Integer[] extractedBr(int i, int j, int p, String name) {
        ArrayList<String[]> records = new ArrayList<String[]>();
        String tmp = this.directory + this.setPath(i * 5, j * 5, p) + name + ".txt";
        try (BufferedReader br2 = new BufferedReader(new FileReader(tmp));){
            String line;
            while ((line = br2.readLine()) != null) {
                String[] values = line.split(",");
                records.add(values);
            }
        }
        catch (Exception br2) {
            // empty catch block
        }
        Integer[] result = new Integer[((String[])records.get(0)).length];
        for (int k = 0; k < ((String[])records.get(0)).length; ++k) {
            result[k] = Integer.parseInt(((String[])records.get(0))[k]);
        }
        return result;
    }

    private String setPath(int i, int j, int p) {
        return "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/";
    }

    public double average(ArrayList<Double> array) {
        Double sum = 0.0;
        for (Double d : array) {
            sum = sum + d;
        }
        return sum / (double)array.size();
    }
}

