/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;

public class TimeComputations {
    public static ArrayList<Double> getT_InvTimeValues(ArrayList<Integer> invariant, ArrayList<Transition> transitions) {
        double eftTotalTime = 0.0;
        double lftTotalTime = 0.0;
        double avgTime = 0.0;
        double dpnTotalTime = 0.0;
        int normalTrans = 0;
        int tpnPureTrans = 0;
        int dpnPureTrans = 0;
        int tdpnTrans = 0;
        if (invariant.size() != transitions.size()) {
            GUIManager.getDefaultGUIManager().log("Error: t-invariant and transition set sizes do not match!", "error", true);
            return null;
        }
        for (int t = 0; t < invariant.size(); ++t) {
            int value = invariant.get(t);
            if (value <= 0) continue;
            Transition trans = transitions.get(t);
            if (trans.getTransType() != Transition.TransitionType.TPN) {
                ++normalTrans;
                continue;
            }
            boolean tpnStatus = trans.timeExtension.isTPN();
            boolean dpnStatus = trans.timeExtension.isDPN();
            if (tpnStatus && dpnStatus) {
                ++tdpnTrans;
                eftTotalTime += trans.timeExtension.getEFT();
                lftTotalTime += trans.timeExtension.getLFT();
                dpnTotalTime += trans.timeExtension.getDPNduration();
                continue;
            }
            if (tpnStatus) {
                ++tpnPureTrans;
                eftTotalTime += trans.timeExtension.getEFT();
                lftTotalTime += trans.timeExtension.getLFT();
                continue;
            }
            if (dpnStatus) {
                ++dpnPureTrans;
                dpnTotalTime += trans.timeExtension.getDPNduration();
                continue;
            }
            ++normalTrans;
        }
        avgTime += (eftTotalTime + lftTotalTime) / 2.0;
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(eftTotalTime);
        result.add(lftTotalTime);
        result.add(avgTime);
        result.add(dpnTotalTime);
        result.add(Double.valueOf(normalTrans));
        result.add(Double.valueOf(tpnPureTrans));
        result.add(Double.valueOf(dpnPureTrans));
        result.add(Double.valueOf(tdpnTrans));
        return result;
    }
}

