/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.windows.decompositions.HolmesBranchVerticesPrototype;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class SubnetCalculator
implements Serializable {
    public static ArrayList<SubNet> functionalSubNets = new ArrayList();
    public static ArrayList<SubNet> snetSubNets = new ArrayList();
    public static ArrayList<SubNet> tnetSubNets = new ArrayList();
    public static ArrayList<SubNet> adtSubNets = new ArrayList();
    public static ArrayList<SubNet> adpSubNets = new ArrayList();
    public static ArrayList<SubNet> tzSubNets = new ArrayList();
    public static ArrayList<SubNet> houSubNets = new ArrayList();
    public static ArrayList<SubNet> nishiSubNets = new ArrayList();
    public static ArrayList<SubNet> cycleSubNets = new ArrayList();
    public static ArrayList<SubNet> ootsukiSubNets = new ArrayList();
    public static ArrayList<SubNet> smcSubNets = new ArrayList();
    public static ArrayList<SubNet> mctSubNets = new ArrayList();
    public static ArrayList<SubNet> tinvSubNets = new ArrayList();
    public static ArrayList<SubNet> pinvSubNets = new ArrayList();
    public static ArrayList<SubNet> bvSubNets = new ArrayList();
    public static ArrayList<SubNet> btSubNets = new ArrayList();
    public static ArrayList<SubNet> bpSubNets = new ArrayList();
    public static ArrayList<SubNet> notTzCyclesiSubNets = new ArrayList();
    public static ArrayList<Path> paths = new ArrayList();
    private static ArrayList<ArrayList<Path>> houResultList = new ArrayList();
    private static ArrayList<ArrayList<Path>> nishiResultList = new ArrayList();
    private static ArrayList<ArrayList<Path>> tzResultList = new ArrayList();
    private static ArrayList<ArrayList<Path>> ootsukiResultList = new ArrayList();
    private static ArrayList<Transition> allTransitions;
    private static ArrayList<Place> allPlaces;
    private static ArrayList<ArrayList<Integer>> invMatrixT;
    private static ArrayList<ArrayList<Integer>> invMatrixP;
    private static ArrayList<Node> allNodes;
    private static ArrayList<Node> usedNodes;
    private static ArrayList<Arc> allArcs;
    private static ArrayList<Integer> inN;
    private static ArrayList<Integer> outN;

    public static void compileElements() {
        allTransitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        allPlaces = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        invMatrixT = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
        invMatrixP = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getP_InvMatrix();
        allNodes = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes();
        allArcs = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getArcs();
        usedNodes = new ArrayList();
    }

    public static void compileTestElements(ArrayList<Transition> at, ArrayList<Place> ap, ArrayList<Node> an, ArrayList<ArrayList<Integer>> ati, ArrayList<ArrayList<Integer>> api) {
        allTransitions = at;
        allPlaces = ap;
        invMatrixT = ati;
        invMatrixP = api;
        allNodes = an;
        usedNodes = new ArrayList();
    }

    public static void generateFS() {
        while (!allTransitions.isEmpty()) {
            Transition firstTransition = allTransitions.get(0);
            ArrayList<Transition> temporaryList = new ArrayList<Transition>();
            temporaryList.add(firstTransition);
            allTransitions.remove(firstTransition);
            temporaryList = SubnetCalculator.findFunctionalTransition(temporaryList, allTransitions);
            functionalSubNets.add(new SubNet(SubNetType.ZAJCEV, temporaryList, null, null, null, null));
        }
    }

    private static ArrayList<Transition> findFunctionalTransition(ArrayList<Transition> temporaryList, ArrayList<Transition> allTransitionsT) {
        boolean found = false;
        for (Transition transition : allTransitionsT) {
            ArrayList<Transition> listToAdd = new ArrayList<Transition>();
            if (SubnetCalculator.chceckParalellInputOutPut(transition, temporaryList) && !listToAdd.contains(transition)) {
                listToAdd.add(transition);
                found = true;
            }
            temporaryList.addAll(listToAdd);
        }
        allTransitionsT.removeAll(temporaryList);
        if (found) {
            temporaryList = SubnetCalculator.findFunctionalTransition(temporaryList, allTransitionsT);
        }
        return temporaryList;
    }

    private static boolean chceckParalellInputOutPut(Node newTran, ArrayList<Transition> sub) {
        boolean paralel = false;
        boolean seq = false;
        for (Transition subTran : sub) {
            boolean in = SubnetCalculator.chceckNodeOutIn(newTran.getInNodes(), subTran.getInNodes());
            boolean out = SubnetCalculator.chceckNodeOutIn(newTran.getOutNodes(), subTran.getOutNodes());
            boolean inout = SubnetCalculator.chceckNodeOutIn(newTran.getInNodes(), subTran.getOutNodes());
            boolean outin = SubnetCalculator.chceckNodeOutIn(newTran.getOutNodes(), subTran.getInNodes());
            if (in || out) {
                paralel = true;
            }
            if (!inout && !outin) continue;
            seq = true;
        }
        if (seq) {
            return false;
        }
        return paralel;
    }

    private static boolean chceckSeqInputOutPut(Node newPlac, ArrayList<Place> sub) {
        boolean paralel = false;
        boolean seq = false;
        for (Place subPlace : sub) {
            boolean in = SubnetCalculator.chceckNodeOutIn(newPlac.getInNodes(), subPlace.getInNodes());
            boolean out = SubnetCalculator.chceckNodeOutIn(newPlac.getOutNodes(), subPlace.getOutNodes());
            boolean inout = SubnetCalculator.chceckNodeOutIn(newPlac.getInNodes(), subPlace.getOutNodes());
            boolean outin = SubnetCalculator.chceckNodeOutIn(newPlac.getOutNodes(), subPlace.getInNodes());
            if (in || out) {
                paralel = true;
            }
            if (!inout && !outin) continue;
            seq = true;
        }
        if (paralel) {
            return false;
        }
        return seq;
    }

    private static boolean chceckSeqTInputOutPut(Node newPlac, ArrayList<Transition> sub) {
        boolean paralel = false;
        boolean seq = false;
        for (Transition subPlace : sub) {
            boolean in = SubnetCalculator.chceckNodeOutIn(newPlac.getInNodes(), subPlace.getInNodes());
            boolean out = SubnetCalculator.chceckNodeOutIn(newPlac.getOutNodes(), subPlace.getOutNodes());
            boolean inout = SubnetCalculator.chceckNodeOutIn(newPlac.getInNodes(), subPlace.getOutNodes());
            boolean outin = SubnetCalculator.chceckNodeOutIn(newPlac.getOutNodes(), subPlace.getInNodes());
            if (in || out) {
                paralel = true;
            }
            if (!inout && !outin) continue;
            seq = true;
        }
        if (paralel) {
            return false;
        }
        return seq;
    }

    private static boolean chceckNodeOutIn(ArrayList<Node> newNodes, ArrayList<Node> subNodes) {
        for (Node newNode : newNodes) {
            for (Node subNode : subNodes) {
                if (newNode.getID() != subNode.getID()) continue;
                return true;
            }
        }
        return false;
    }

    public static void cleanSubnets() {
        functionalSubNets = new ArrayList();
        snetSubNets = new ArrayList();
        tnetSubNets = new ArrayList();
        adtSubNets = new ArrayList();
        adpSubNets = new ArrayList();
        tzSubNets = new ArrayList();
        houSubNets = new ArrayList();
        nishiSubNets = new ArrayList();
        cycleSubNets = new ArrayList();
        houResultList = new ArrayList();
        nishiResultList = new ArrayList();
        tzResultList = new ArrayList();
        ootsukiResultList = new ArrayList();
        ootsukiSubNets = new ArrayList();
        smcSubNets = new ArrayList();
        tinvSubNets = new ArrayList();
        pinvSubNets = new ArrayList();
        bvSubNets = new ArrayList();
        mctSubNets = new ArrayList();
        btSubNets = new ArrayList();
        bpSubNets = new ArrayList();
        notTzCyclesiSubNets = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public static void generateSnets() {
        if (invMatrixT != null) {
            if (!invMatrixT.isEmpty()) {
                ArrayList placesOfSupport = new ArrayList();
                for (ArrayList<Integer> inv : invMatrixT) {
                    ArrayList invSupport = new ArrayList();
                    for (int i = 0; i < inv.size(); ++i) {
                        if (inv.get(i) <= 0) continue;
                        invSupport.add(allTransitions.get(i));
                    }
                    ArrayList<Place> invPlace = new ArrayList<Place>();
                    for (int i = 0; i < invSupport.size(); ++i) {
                        for (int j = i + 1; j < invSupport.size(); ++j) {
                            for (Place ip : ((Transition)invSupport.get(i)).getPostPlaces()) {
                                for (Place jp : ((Transition)invSupport.get(j)).getPrePlaces()) {
                                    if (ip.getID() != jp.getID() || inv.contains(ip)) continue;
                                    invPlace.add(ip);
                                }
                            }
                            for (Place ip : ((Transition)invSupport.get(i)).getPrePlaces()) {
                                for (Place jp : ((Transition)invSupport.get(j)).getPostPlaces()) {
                                    if (ip.getID() != jp.getID() || inv.contains(ip)) continue;
                                    invPlace.add(ip);
                                }
                            }
                        }
                    }
                    placesOfSupport.add(invPlace);
                }
                Integer[][] matrix = new Integer[allPlaces.size()][placesOfSupport.size()];
                ArrayList list = new ArrayList();
                for (Place p : allPlaces) {
                    ArrayList<Integer> l = new ArrayList<Integer>();
                    for (ArrayList arrayList : placesOfSupport) {
                        if (arrayList.contains(p)) {
                            matrix[SubnetCalculator.allPlaces.indexOf((Object)p)][placesOfSupport.indexOf((Object)arrayList)] = 1;
                            l.add(placesOfSupport.indexOf(arrayList));
                            continue;
                        }
                        matrix[SubnetCalculator.allPlaces.indexOf((Object)p)][placesOfSupport.indexOf((Object)arrayList)] = 0;
                    }
                    list.add(l);
                }
                ArrayList<ArrayList<Place>> snets = new ArrayList<ArrayList<Place>>();
                ArrayList<Integer> used = new ArrayList<Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    void var7_19;
                    if (used.contains(i)) continue;
                    ArrayList<Place> net = new ArrayList<Place>();
                    net.add(allPlaces.get(i));
                    used.add(i);
                    int n = i + 1;
                    while (var7_19 < list.size()) {
                        if (((ArrayList)list.get(i)).equals(list.get((int)var7_19)) && !used.contains((int)var7_19)) {
                            net.add(allPlaces.get((int)var7_19));
                            used.add((int)var7_19);
                        }
                        ++var7_19;
                    }
                    snets.add(net);
                    snetSubNets.add(new SubNet(SubNetType.SNET, null, net, null, null, null));
                }
            } else {
                JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Before determine ADT sets, you need to generate T-invariants.", "WARNING MESSAGE", 2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void generateTnets() {
        int i;
        HashMap<Place, Integer> placesMap = new HashMap<Place, Integer>();
        HashMap<Transition, Integer> transitionsMap = new HashMap<Transition, Integer>();
        for (i = 0; i < allPlaces.size(); ++i) {
            placesMap.put(allPlaces.get(i), i);
        }
        for (i = 0; i < allTransitions.size(); ++i) {
            transitionsMap.put(allTransitions.get(i), i);
        }
        ArrayList globalIncidenceMatrix = new ArrayList();
        ArrayList globalIdentityMatrix = new ArrayList();
        ArrayList<ArrayList<Integer>> CMatrix = new ArrayList<ArrayList<Integer>>();
        ArrayList removalList = new ArrayList();
        ArrayList doubleArcs = new ArrayList();
        for (int trans = 0; trans < allTransitions.size(); ++trans) {
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (int j = 0; j < allPlaces.size(); ++j) {
                transRow.add(0);
            }
            globalIncidenceMatrix.add(transRow);
            CMatrix.add(new ArrayList(transRow));
        }
        for (Arc oneArc : allArcs) {
            int n = 0;
            int pPosition = 0;
            int incidenceValue = 0;
            if (oneArc.getArcType() != Arc.TypeOfArc.NORMAL && oneArc.getArcType() != Arc.TypeOfArc.READARC || oneArc.getStartNode().isInvisible() || oneArc.getEndNode().isInvisible()) continue;
            if (oneArc.getStartNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                n = (Integer)transitionsMap.get(oneArc.getStartNode());
                pPosition = (Integer)placesMap.get(oneArc.getEndNode());
                incidenceValue = 1 * oneArc.getWeight();
            } else {
                n = (Integer)transitionsMap.get(oneArc.getEndNode());
                pPosition = (Integer)placesMap.get(oneArc.getStartNode());
                incidenceValue = -1 * oneArc.getWeight();
            }
            int oldValue = (Integer)((ArrayList)globalIncidenceMatrix.get(n)).get(pPosition);
            if (oldValue != 0) {
                ArrayList<Integer> hiddenReadArc = new ArrayList<Integer>();
                hiddenReadArc.add(pPosition);
                hiddenReadArc.add(n);
                doubleArcs.add(hiddenReadArc);
            }
            ((ArrayList)globalIncidenceMatrix.get(n)).set(pPosition, oldValue + incidenceValue);
            CMatrix.get(n).set(pPosition, oldValue + incidenceValue);
        }
        for (int i2 = 0; i2 < allTransitions.size(); ++i2) {
            ArrayList<Integer> row = new ArrayList<Integer>();
            for (int j = 0; j < allTransitions.size(); ++j) {
                if (i2 == j) {
                    row.add(1);
                    continue;
                }
                row.add(0);
            }
            removalList.add(row);
        }
        int numberOfColumns = ((ArrayList)CMatrix.get(0)).size();
        for (int c = 0; c < numberOfColumns; ++c) {
            int col;
            if (!SubnetCalculator.columnReductable(CMatrix, c)) continue;
            ArrayList<Integer> arrayList = CMatrix.get(inN.get(0));
            ArrayList<Integer> row2 = CMatrix.get(outN.get(0));
            ArrayList<Integer> rowV = new ArrayList<Integer>();
            ArrayList rrow1 = (ArrayList)removalList.get(inN.get(0));
            ArrayList rrow2 = (ArrayList)removalList.get(outN.get(0));
            ArrayList<Integer> rrowV = new ArrayList<Integer>();
            CMatrix.remove(arrayList);
            CMatrix.remove(row2);
            removalList.remove(rrow1);
            removalList.remove(rrow2);
            for (col = 0; col < allPlaces.size(); ++col) {
                rowV.add(arrayList.get(col) + row2.get(col));
            }
            for (col = 0; col < allTransitions.size(); ++col) {
                rrowV.add((Integer)rrow1.get(col) + (Integer)rrow2.get(col));
            }
            CMatrix.add(rowV);
            removalList.add(rrowV);
        }
        for (int i3 = 0; i3 < CMatrix.size(); ++i3) {
            void var9_20;
            boolean bl = false;
            while (var9_20 < CMatrix.get(i3).size()) {
                System.out.print(CMatrix.get(i3).get((int)var9_20));
                ++var9_20;
            }
            System.out.println();
        }
        for (ArrayList arrayList : removalList) {
            ArrayList<Integer> listOfPositions = new ArrayList<Integer>();
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                if ((Integer)arrayList.get(i4) <= 0) continue;
                listOfPositions.add(i4);
            }
            tnetSubNets.add(new SubNet(SubNetType.TNET, allTransitions, null, null, listOfPositions, null));
        }
    }

    private static boolean columnReductable(ArrayList<ArrayList<Integer>> cMatrix, int c) {
        inN = new ArrayList();
        outN = new ArrayList();
        for (int r = 0; r < cMatrix.size(); ++r) {
            if (cMatrix.get(r).get(c) > 0) {
                outN.add(r);
            }
            if (cMatrix.get(r).get(c) >= 0) continue;
            inN.add(r);
        }
        return outN.size() == 1 && inN.size() == 1 && Math.abs(cMatrix.get(outN.get(0)).get(c)) == Math.abs(cMatrix.get(inN.get(0)).get(c));
    }

    private static ArrayList<Integer> getMaxSubConnectionTnet(ArrayList<Integer> newADTset) {
        ArrayList<ArrayList<Integer>> partialResults = new ArrayList<ArrayList<Integer>>();
        while (newADTset.size() > 0) {
            ArrayList<Integer> local = new ArrayList<Integer>(newADTset);
            boolean newConnections = true;
            while (newConnections) {
                newConnections = false;
                for (Integer next : newADTset) {
                    if (local.contains(next) || !SubnetCalculator.checkConnection(local, next, GUIManager.getDefaultGUIManager().getWorkspace().getProject())) continue;
                    local.add(next);
                    newConnections = true;
                }
            }
            partialResults.add(local);
            newADTset.removeAll(local);
        }
        int size = 0;
        int longest = -1;
        for (int i = 0; i < partialResults.size(); ++i) {
            if (((ArrayList)partialResults.get(i)).size() <= size) continue;
            longest = i;
            size = ((ArrayList)partialResults.get(i)).size();
        }
        return (ArrayList)partialResults.get(longest);
    }

    public static void generateMCT() {
        ArrayList<ArrayList<Transition>> mctsets = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCTMatrix();
        if (mctsets != null && !mctsets.isEmpty()) {
            for (ArrayList<Transition> mct : mctsets) {
                mctSubNets.add(new SubNet(SubNetType.MCT, mct, null, null, null, null));
            }
            mctSubNets.remove(mctSubNets.size() - 1);
        } else {
            JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
        }
    }

    public static void generateTInv() {
        if (invMatrixT != null) {
            if (!invMatrixT.isEmpty()) {
                for (ArrayList<Integer> inv : invMatrixT) {
                    ArrayList<Transition> subTransitions = new ArrayList<Transition>();
                    for (int i = 0; i < inv.size(); ++i) {
                        if (inv.get(i) <= 0) continue;
                        subTransitions.add(allTransitions.get(i));
                    }
                    tinvSubNets.add(new SubNet(SubNetType.TINV, subTransitions, null, null, null, null));
                }
            } else {
                JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
        }
    }

    public static void generatePInv() {
        if (invMatrixT != null) {
            if (!invMatrixT.isEmpty()) {
                for (ArrayList<Integer> inv : invMatrixP) {
                    ArrayList<Place> subPlaces = new ArrayList<Place>();
                    for (int i = 0; i < inv.size(); ++i) {
                        if (inv.get(i) <= 0) continue;
                        subPlaces.add(allPlaces.get(i));
                    }
                    pinvSubNets.add(new SubNet(SubNetType.PINV, null, subPlaces, null, null, null));
                }
            } else {
                JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
        }
    }

    public static void generateADT() {
        if (invMatrixT != null) {
            for (int i = 0; i < invMatrixT.size(); ++i) {
                for (int j = 0; j < invMatrixT.get(i).size(); ++j) {
                    System.out.print(" " + invMatrixT.get(i).get(j) + " ");
                }
                System.out.println();
            }
            if (!invMatrixT.isEmpty()) {
                ArrayList nonAssignedRows = new ArrayList();
                for (int i = 0; i < invMatrixT.get(0).size(); ++i) {
                    ArrayList<Integer> newRow = new ArrayList<Integer>();
                    for (ArrayList<Integer> integers : invMatrixT) {
                        if (integers.get(i) > 0) {
                            newRow.add(1);
                            continue;
                        }
                        newRow.add(0);
                    }
                    nonAssignedRows.add(newRow);
                }
                ArrayList listOfusedTransitions = new ArrayList();
                for (int i = 0; i < nonAssignedRows.size(); ++i) {
                    ArrayList<Integer> localListOfusedTransitions = new ArrayList<Integer>(listOfusedTransitions);
                    ArrayList<Integer> newADTset = new ArrayList<Integer>();
                    if (!localListOfusedTransitions.contains(i)) {
                        newADTset.add(i);
                        localListOfusedTransitions.add(i);
                        for (int j = i; j < nonAssignedRows.size(); ++j) {
                            if (!SubnetCalculator.checkADT((ArrayList)nonAssignedRows.get(i), (ArrayList)nonAssignedRows.get(j)) || localListOfusedTransitions.contains(j)) continue;
                            localListOfusedTransitions.add(j);
                            newADTset.add(j);
                        }
                    }
                    if (!newADTset.isEmpty()) {
                        newADTset = SubnetCalculator.getMaxSubConnection(newADTset, GUIManager.getDefaultGUIManager().getWorkspace().getProject());
                        listOfusedTransitions.addAll(newADTset);
                        List UniqueNumbers = listOfusedTransitions.stream().distinct().collect(Collectors.toList());
                        listOfusedTransitions = (ArrayList)UniqueNumbers;
                    }
                    if (newADTset.isEmpty()) continue;
                    adtSubNets.add(new SubNet(SubNetType.ADTcomp, GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions(), null, null, newADTset, null));
                    listOfusedTransitions.addAll(listOfusedTransitions);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Before determine ADT sets, you need to generate T-invariants.", "WARNING MESSAGE", 2);
        }
    }

    private static ArrayList<Integer> getMaxSubConnection(ArrayList<Integer> newADTset, PetriNet pn) {
        ArrayList<ArrayList<Integer>> partialResults = new ArrayList<ArrayList<Integer>>();
        while (newADTset.size() > 0) {
            Integer start = newADTset.get(0);
            newADTset.remove(0);
            ArrayList<Integer> inicjator = new ArrayList<Integer>();
            inicjator.add(start);
            ArrayList<Integer> local = new ArrayList<Integer>(inicjator);
            boolean newConnections = true;
            while (newConnections) {
                newConnections = false;
                for (Integer next : newADTset) {
                    if (local.contains(next) || !SubnetCalculator.checkConnection(local, next, pn)) continue;
                    local.add(next);
                    newConnections = true;
                }
            }
            partialResults.add(local);
            newADTset.removeAll(local);
        }
        int size = 0;
        int longest = -1;
        for (int i = 0; i < partialResults.size(); ++i) {
            if (((ArrayList)partialResults.get(i)).size() <= size) continue;
            longest = i;
            size = ((ArrayList)partialResults.get(i)).size();
        }
        return (ArrayList)partialResults.get(longest);
    }

    private static boolean checkConnection(ArrayList<Integer> newADTset, int j, PetriNet pn) {
        boolean connected = false;
        for (Integer i : newADTset) {
            ArrayList<Node> common = new ArrayList<Node>(pn.getTransitions().get(i).getOutInNodes());
            common.retainAll(new ArrayList<Node>(pn.getTransitions().get(j).getOutInNodes()));
            if (common.size() <= 0) continue;
            connected = true;
        }
        return connected;
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<SubNet> generateTnetFromSecondNet(PetriNet pn) {
        int i;
        ArrayList<SubNet> result = new ArrayList<SubNet>();
        HashMap<Place, Integer> placesMap = new HashMap<Place, Integer>();
        HashMap<Transition, Integer> transitionsMap = new HashMap<Transition, Integer>();
        for (i = 0; i < pn.getPlaces().size(); ++i) {
            placesMap.put(pn.getPlaces().get(i), i);
        }
        for (i = 0; i < pn.getTransitions().size(); ++i) {
            transitionsMap.put(pn.getTransitions().get(i), i);
        }
        ArrayList globalIncidenceMatrix = new ArrayList();
        ArrayList globalIdentityMatrix = new ArrayList();
        ArrayList<ArrayList<Integer>> CMatrix = new ArrayList<ArrayList<Integer>>();
        ArrayList removalList = new ArrayList();
        ArrayList doubleArcs = new ArrayList();
        for (int trans = 0; trans < pn.getTransitions().size(); ++trans) {
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (int j = 0; j < pn.getPlaces().size(); ++j) {
                transRow.add(0);
            }
            globalIncidenceMatrix.add(transRow);
            CMatrix.add(new ArrayList(transRow));
        }
        for (Arc oneArc : pn.getArcs()) {
            int n = 0;
            int pPosition = 0;
            int incidenceValue = 0;
            if (oneArc.getArcType() != Arc.TypeOfArc.NORMAL && oneArc.getArcType() != Arc.TypeOfArc.READARC || oneArc.getStartNode().isInvisible() || oneArc.getEndNode().isInvisible()) continue;
            if (oneArc.getStartNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                n = (Integer)transitionsMap.get(oneArc.getStartNode());
                pPosition = (Integer)placesMap.get(oneArc.getEndNode());
                incidenceValue = 1 * oneArc.getWeight();
            } else {
                n = (Integer)transitionsMap.get(oneArc.getEndNode());
                pPosition = (Integer)placesMap.get(oneArc.getStartNode());
                incidenceValue = -1 * oneArc.getWeight();
            }
            int oldValue = (Integer)((ArrayList)globalIncidenceMatrix.get(n)).get(pPosition);
            if (oldValue != 0) {
                ArrayList<Integer> hiddenReadArc = new ArrayList<Integer>();
                hiddenReadArc.add(pPosition);
                hiddenReadArc.add(n);
                doubleArcs.add(hiddenReadArc);
            }
            ((ArrayList)globalIncidenceMatrix.get(n)).set(pPosition, oldValue + incidenceValue);
            CMatrix.get(n).set(pPosition, oldValue + incidenceValue);
        }
        for (int i2 = 0; i2 < pn.getTransitions().size(); ++i2) {
            ArrayList<Integer> row = new ArrayList<Integer>();
            for (int j = 0; j < pn.getTransitions().size(); ++j) {
                if (i2 == j) {
                    row.add(1);
                    continue;
                }
                row.add(0);
            }
            removalList.add(row);
        }
        int numberOfColumns = ((ArrayList)CMatrix.get(0)).size();
        for (int c = 0; c < numberOfColumns; ++c) {
            int col;
            if (!SubnetCalculator.columnReductable(CMatrix, c)) continue;
            ArrayList<Integer> arrayList = CMatrix.get(inN.get(0));
            ArrayList<Integer> row2 = CMatrix.get(outN.get(0));
            ArrayList<Integer> rowV = new ArrayList<Integer>();
            ArrayList rrow1 = (ArrayList)removalList.get(inN.get(0));
            ArrayList rrow2 = (ArrayList)removalList.get(outN.get(0));
            ArrayList<Integer> rrowV = new ArrayList<Integer>();
            CMatrix.remove(arrayList);
            CMatrix.remove(row2);
            removalList.remove(rrow1);
            removalList.remove(rrow2);
            for (col = 0; col < pn.getPlaces().size(); ++col) {
                rowV.add(arrayList.get(col) + row2.get(col));
            }
            for (col = 0; col < pn.getTransitions().size(); ++col) {
                rrowV.add((Integer)rrow1.get(col) + (Integer)rrow2.get(col));
            }
            CMatrix.add(rowV);
            removalList.add(rrowV);
        }
        for (int i3 = 0; i3 < CMatrix.size(); ++i3) {
            void var11_22;
            boolean bl = false;
            while (var11_22 < CMatrix.get(i3).size()) {
                System.out.print(CMatrix.get(i3).get((int)var11_22));
                ++var11_22;
            }
            System.out.println();
        }
        for (ArrayList arrayList : removalList) {
            ArrayList<Integer> listOfPositions = new ArrayList<Integer>();
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                if ((Integer)arrayList.get(i4) <= 0) continue;
                listOfPositions.add(i4);
            }
            result.add(new SubNet(SubNetType.TNET, pn.getTransitions(), null, null, listOfPositions, null));
        }
        return result;
    }

    public static ArrayList<SubNet> generateTcomponentFromSecondNet(PetriNet pn) {
        ArrayList<SubNet> result = new ArrayList<SubNet>();
        if (pn.getT_InvMatrix() != null) {
            if (!pn.getT_InvMatrix().isEmpty()) {
                for (ArrayList<Integer> inv : pn.getT_InvMatrix()) {
                    ArrayList<Transition> subTransitions = new ArrayList<Transition>();
                    for (int i = 0; i < inv.size(); ++i) {
                        if (inv.get(i) <= 0) continue;
                        subTransitions.add(pn.getTransitions().get(i));
                    }
                    result.add(new SubNet(SubNetType.TINV, subTransitions, null, null, null, null));
                }
            } else {
                JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
        }
        return result;
    }

    public static ArrayList<SubNet> generateADTFromSecondNet(PetriNet pn) {
        ArrayList<SubNet> result = new ArrayList<SubNet>();
        if (pn.getT_InvMatrix() != null) {
            if (!pn.getT_InvMatrix().isEmpty()) {
                ArrayList nonAssignedRows = new ArrayList();
                for (int i = 0; i < pn.getT_InvMatrix().get(0).size(); ++i) {
                    ArrayList<Integer> newRow = new ArrayList<Integer>();
                    for (ArrayList<Integer> integers : pn.getT_InvMatrix()) {
                        if (integers.get(i) > 0) {
                            newRow.add(1);
                            continue;
                        }
                        newRow.add(0);
                    }
                    nonAssignedRows.add(newRow);
                }
                ArrayList listOfusedTransitions = new ArrayList();
                for (int i = 0; i < nonAssignedRows.size(); ++i) {
                    ArrayList<Integer> localListOfusedTransitions = new ArrayList<Integer>(listOfusedTransitions);
                    ArrayList<Integer> newADTset = new ArrayList<Integer>();
                    if (!localListOfusedTransitions.contains(i)) {
                        newADTset.add(i);
                        localListOfusedTransitions.add(i);
                        for (int j = i; j < nonAssignedRows.size(); ++j) {
                            if (!SubnetCalculator.checkADT((ArrayList)nonAssignedRows.get(i), (ArrayList)nonAssignedRows.get(j)) || localListOfusedTransitions.contains(j)) continue;
                            localListOfusedTransitions.add(j);
                            newADTset.add(j);
                        }
                    }
                    if (!newADTset.isEmpty()) {
                        newADTset = SubnetCalculator.getMaxSubConnection(newADTset, pn);
                        listOfusedTransitions.addAll(newADTset);
                        List UniqueNumbers = listOfusedTransitions.stream().distinct().collect(Collectors.toList());
                        listOfusedTransitions = (ArrayList)UniqueNumbers;
                    }
                    if (newADTset.isEmpty()) continue;
                    result.add(new SubNet(SubNetType.ADTcomp, pn.getTransitions(), null, null, newADTset, null));
                    listOfusedTransitions.addAll(listOfusedTransitions);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Before determine ADT sets, you need to generate T-invariants.", "WARNING MESSAGE", 2);
        }
        return result;
    }

    public static ArrayList<SubNet> generateFunctionalFromSecondNet(PetriNet pn) {
        ArrayList<Transition> transitionsFromSecondNet = new ArrayList<Transition>(pn.getTransitions());
        ArrayList<SubNet> result = new ArrayList<SubNet>();
        while (!transitionsFromSecondNet.isEmpty()) {
            Transition firstTransition = transitionsFromSecondNet.get(0);
            ArrayList<Transition> temporaryList = new ArrayList<Transition>();
            temporaryList.add(firstTransition);
            transitionsFromSecondNet.remove(firstTransition);
            temporaryList = SubnetCalculator.findFunctionalTransition(temporaryList, transitionsFromSecondNet);
            result.add(new SubNet(SubNetType.ZAJCEV, temporaryList, null, null, null, null));
        }
        return result;
    }

    public static void generateADP() {
        if (GUIManager.getDefaultGUIManager().getWorkspace().getProject().getP_InvMatrix() != null) {
            if (!GUIManager.getDefaultGUIManager().getWorkspace().getProject().getP_InvMatrix().isEmpty()) {
                ArrayList<ArrayList<Integer>> invMatrix = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getP_InvMatrix();
                ArrayList nonAssignedRows = new ArrayList();
                for (int i = 0; i < invMatrix.get(0).size(); ++i) {
                    ArrayList<Integer> newRow = new ArrayList<Integer>();
                    for (ArrayList<Integer> matrix : invMatrix) {
                        newRow.add(matrix.get(i));
                    }
                    nonAssignedRows.add(newRow);
                }
                ArrayList<Integer> listOfusedTransitions = new ArrayList<Integer>();
                for (int i = 0; i < nonAssignedRows.size(); ++i) {
                    ArrayList<Integer> newADPset = new ArrayList<Integer>();
                    if (!listOfusedTransitions.contains(i)) {
                        newADPset.add(i);
                        listOfusedTransitions.add(i);
                        for (int j = i; j < nonAssignedRows.size(); ++j) {
                            if (!SubnetCalculator.checkADT((ArrayList)nonAssignedRows.get(i), (ArrayList)nonAssignedRows.get(j)) || listOfusedTransitions.contains(j)) continue;
                            listOfusedTransitions.add(j);
                            newADPset.add(j);
                        }
                    }
                    if (newADPset.isEmpty()) continue;
                    adpSubNets.add(new SubNet(SubNetType.ADP, null, null, null, newADPset, null));
                }
            } else {
                JOptionPane.showMessageDialog(null, "Decomposition can not be processed, because of the lack of invariants!", "WARNING MESSAGE", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Before determine ADT sets, you need to generate T-invariants.", "WARNING MESSAGE", 2);
        }
    }

    private static boolean checkADT(ArrayList<Integer> t1, ArrayList<Integer> t2) {
        boolean result = true;
        for (int i = 0; i < t1.size(); ++i) {
            if (t1.get(i).equals(t2.get(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static void generateTZ() {
        paths = SubnetCalculator.calculatePaths();
        for (Path path : paths) {
            if (path.isCycle) {
                ArrayList<Path> list = new ArrayList<Path>();
                list.add(path);
                tzResultList.add(list);
                continue;
            }
            ArrayList<Path> localListOfPaths = new ArrayList<Path>(paths);
            ArrayList<Path> listOfCycles = new ArrayList<Path>();
            localListOfPaths.remove(path);
            listOfCycles.add(path);
            for (Path p : localListOfPaths) {
                if (path.endNode != p.startNode) continue;
                SubnetCalculator.dep(listOfCycles, localListOfPaths);
            }
        }
        ArrayList<ArrayList<Path>> temp = new ArrayList<ArrayList<Path>>();
        for (int i = 0; i < tzResultList.size(); ++i) {
            boolean isDouble = false;
            for (int j = i + 1; j < tzResultList.size(); ++j) {
                if (!tzResultList.get(i).containsAll((Collection)tzResultList.get(j))) continue;
                isDouble = true;
            }
            SubnetCalculator.addSinkToSubnets(tzResultList.get(i));
            if (isDouble) continue;
            temp.add(tzResultList.get(i));
            tzSubNets.add(new SubNet(SubNetType.TZ, null, null, null, null, tzResultList.get(i)));
        }
        tzResultList = temp;
        tzResultList.clear();
    }

    public static void generateNotTzCycles() {
        paths = SubnetCalculator.calculatePaths();
        for (Path path : paths) {
            if (path.isCycle) {
                ArrayList<Path> list = new ArrayList<Path>();
                list.add(path);
                tzResultList.add(list);
                continue;
            }
            ArrayList<Path> localListOfPaths = new ArrayList<Path>(paths);
            ArrayList<Path> listOfCycles = new ArrayList<Path>();
            localListOfPaths.remove(path);
            listOfCycles.add(path);
            for (Path p : localListOfPaths) {
                if (path.endNode != p.startNode) continue;
                SubnetCalculator.dep(listOfCycles, localListOfPaths);
            }
        }
        ArrayList<ArrayList<Path>> temp = new ArrayList<ArrayList<Path>>();
        for (int i = 0; i < tzResultList.size(); ++i) {
            boolean isDouble = false;
            for (int j = i + 1; j < tzResultList.size(); ++j) {
                if (!tzResultList.get(i).containsAll((Collection)tzResultList.get(j))) continue;
                isDouble = true;
            }
            boolean isSink = SubnetCalculator.checkSinkToSubnets(tzResultList.get(i));
            if (isDouble || isSink) continue;
            temp.add(tzResultList.get(i));
            notTzCyclesiSubNets.add(new SubNet(SubNetType.NotTzCycles, null, null, null, null, tzResultList.get(i)));
        }
        tzResultList = temp;
        tzResultList.clear();
    }

    public static void addSinkToSubnets(ArrayList<Path> paths) {
        ArrayList<Path> sinkSourcePaths = new ArrayList<Path>();
        for (Path path : paths) {
            for (Node n : path.path) {
                Path sinkPath;
                ArrayList<Node> list;
                for (Node chceck : n.getOutNodes()) {
                    if (!chceck.getOutNodes().isEmpty()) continue;
                    list = new ArrayList<Node>();
                    list.add(n);
                    list.add(chceck);
                    sinkPath = new Path(n, chceck, list);
                    sinkSourcePaths.add(sinkPath);
                }
                for (Node chceck : n.getInNodes()) {
                    if (!chceck.getInNodes().isEmpty()) continue;
                    list = new ArrayList();
                    list.add(n);
                    list.add(chceck);
                    sinkPath = new Path(chceck, n, list);
                    sinkSourcePaths.add(sinkPath);
                }
            }
        }
        paths.addAll(sinkSourcePaths);
    }

    public static boolean checkSinkToSubnets(ArrayList<Path> paths) {
        ArrayList<Path> sinkSourcePaths = new ArrayList<Path>();
        boolean isSink = false;
        for (Path path : paths) {
            for (Node n : path.path) {
                Path sinkPath;
                ArrayList<Node> list;
                for (Node chceck : n.getOutNodes()) {
                    if (!chceck.getOutNodes().isEmpty()) continue;
                    list = new ArrayList<Node>();
                    list.add(n);
                    list.add(chceck);
                    sinkPath = new Path(n, chceck, list);
                    sinkSourcePaths.add(sinkPath);
                    isSink = true;
                }
                for (Node chceck : n.getInNodes()) {
                    if (!chceck.getInNodes().isEmpty()) continue;
                    list = new ArrayList();
                    list.add(n);
                    list.add(chceck);
                    sinkPath = new Path(chceck, n, list);
                    sinkSourcePaths.add(sinkPath);
                    isSink = true;
                }
            }
        }
        return isSink;
    }

    public static void generateCycle(boolean isOotsuki) {
        paths = SubnetCalculator.calculatePaths();
        for (Path path : paths) {
            if (path.isCycle) {
                ArrayList<Path> list = new ArrayList<Path>();
                list.add(path);
                tzResultList.add(list);
                continue;
            }
            ArrayList<Path> localListOfPaths = new ArrayList<Path>(paths);
            ArrayList<Path> listOfCycles = new ArrayList<Path>();
            localListOfPaths.remove(path);
            listOfCycles.add(path);
            for (Path p : localListOfPaths) {
                if (path.endNode != p.startNode) continue;
                SubnetCalculator.dep(listOfCycles, localListOfPaths);
            }
        }
        ArrayList<ArrayList<Path>> temp = new ArrayList<ArrayList<Path>>();
        for (int i = 0; i < tzResultList.size(); ++i) {
            boolean isDouble = false;
            for (int j = i + 1; j < tzResultList.size(); ++j) {
                if (!tzResultList.get(i).containsAll((Collection)tzResultList.get(j))) continue;
                isDouble = true;
            }
            if (isDouble) continue;
            temp.add(tzResultList.get(i));
            cycleSubNets.add(new SubNet(SubNetType.CYCLE, null, null, null, null, tzResultList.get(i)));
        }
        tzResultList = temp;
        if (!isOotsuki) {
            tzResultList.clear();
        }
    }

    public static void generateHou() {
        paths = SubnetCalculator.calculatePathsHou();
        ArrayList<Node> inNode = new ArrayList<Node>();
        ArrayList<Node> outNode = new ArrayList<Node>();
        for (Path p : paths) {
            if (p.startNode.getInNodes().size() == 0 && p.startNode.getOutNodes().size() != 0) {
                inNode.add(p.startNode);
            }
            if (p.endNode.getInNodes().size() == 0 || p.endNode.getOutNodes().size() != 0) continue;
            outNode.add(p.endNode);
        }
        for (Path path : paths) {
            if (inNode.contains(path.startNode) && outNode.contains(path.endNode)) {
                ArrayList<Path> pl = new ArrayList<Path>();
                pl.add(path);
                houResultList.add(pl);
                continue;
            }
            if (!inNode.contains(path.startNode)) continue;
            ArrayList<Path> localListOfPaths = new ArrayList<Path>(paths);
            ArrayList<Path> listOfCycles = new ArrayList<Path>();
            localListOfPaths.remove(path);
            listOfCycles.add(path);
            for (Path p : localListOfPaths) {
                if (path.endNode != p.startNode) continue;
                SubnetCalculator.depHou(listOfCycles, localListOfPaths, outNode);
            }
        }
        for (int i = 0; i < houResultList.size(); ++i) {
            boolean isDouble = false;
            for (int j = i + 1; j < houResultList.size(); ++j) {
                if (!houResultList.get(i).containsAll((Collection)houResultList.get(j))) continue;
                isDouble = true;
            }
            if (isDouble) continue;
            houSubNets.add(new SubNet(SubNetType.HOU, null, null, null, null, houResultList.get(i)));
        }
    }

    public static void generateNishi() {
        paths = SubnetCalculator.calculatePathsHou();
        ArrayList<Node> inNode = new ArrayList<Node>();
        ArrayList<Node> outNode = new ArrayList<Node>();
        for (Path p : paths) {
            if (p.startNode.getInNodes().size() == 0 && p.startNode.getOutNodes().size() != 0) {
                inNode.add(p.startNode);
            }
            if (p.endNode.getInNodes().size() == 0 || p.endNode.getOutNodes().size() != 0) continue;
            outNode.add(p.endNode);
        }
        for (Path path : paths) {
            if (inNode.contains(path.startNode) && outNode.contains(path.endNode)) {
                ArrayList<Path> pl = new ArrayList<Path>();
                pl.add(path);
                nishiResultList.add(pl);
                continue;
            }
            if (!inNode.contains(path.startNode)) continue;
            ArrayList<Path> localListOfPaths = new ArrayList<Path>(paths);
            ArrayList<Path> listOfCycles = new ArrayList<Path>();
            localListOfPaths.remove(path);
            listOfCycles.add(path);
            for (Path paralelPath : paths) {
                if (paralelPath.startNode == path.startNode && paralelPath.endNode == path.endNode || paralelPath.startNode.getInNodes().size() != 0 || paralelPath.endNode != path.endNode) continue;
                localListOfPaths.remove(paralelPath);
                listOfCycles.add(paralelPath);
            }
            for (Path p : localListOfPaths) {
                if (path.endNode != p.startNode) continue;
                SubnetCalculator.depNishi(listOfCycles, localListOfPaths, outNode);
            }
        }
        for (int i = 0; i < nishiResultList.size(); ++i) {
            boolean isDouble = false;
            for (int j = i + 1; j < nishiResultList.size(); ++j) {
                if (!nishiResultList.get(i).containsAll((Collection)nishiResultList.get(j))) continue;
                isDouble = true;
            }
            if (isDouble) continue;
            nishiSubNets.add(new SubNet(SubNetType.NISHI, null, null, null, null, nishiResultList.get(i)));
        }
        nishiResultList.clear();
    }

    public static void generateOotsuki() {
        if (cycleSubNets == null || cycleSubNets.isEmpty()) {
            SubnetCalculator.generateCycle(true);
        }
        if (houSubNets == null || houSubNets.isEmpty()) {
            SubnetCalculator.generateHou();
        }
        ootsukiResultList.addAll(houResultList);
        ootsukiResultList.addAll(tzResultList);
        ArrayList<ArrayList<Path>> allFiringSeq = new ArrayList<ArrayList<Path>>(ootsukiResultList);
        ArrayList fs = new ArrayList();
        while (!allFiringSeq.isEmpty()) {
            ArrayList<Path> root = allFiringSeq.get(0);
            allFiringSeq.remove(0);
            boolean repeat = true;
            while (repeat) {
                repeat = false;
                ArrayList<ArrayList<Path>> groupsToAdd = new ArrayList<ArrayList<Path>>();
                for (Path path : root) {
                    boolean isConnected = false;
                    for (ArrayList<Path> group : allFiringSeq) {
                        isConnected = SubnetCalculator.checkIfContains(group, path);
                        if (!isConnected) continue;
                        groupsToAdd.add(group);
                    }
                }
                if (groupsToAdd.isEmpty()) continue;
                repeat = true;
                for (ArrayList arrayList : groupsToAdd) {
                    root.addAll(arrayList);
                    allFiringSeq.remove(arrayList);
                }
            }
            ootsukiSubNets.add(new SubNet(SubNetType.OOSTUKI, null, null, null, null, new ArrayList<Path>(root)));
        }
    }

    public static void generateSMC() {
        for (ArrayList<Integer> inv : invMatrixP) {
            int numberOfTokensInInv = 0;
            ArrayList<Place> invSupp = new ArrayList<Place>();
            for (int i = 0; i < inv.size(); ++i) {
                if (inv.get(i) == 0) continue;
                numberOfTokensInInv += allPlaces.get(i).getTokensNumber();
                invSupp.add(allPlaces.get(i));
            }
            if (numberOfTokensInInv != true) continue;
            smcSubNets.add(new SubNet(SubNetType.SMC, null, invSupp, null, null, null));
        }
    }

    public static void generateBranchesVerticles() {
        for (Node n : allNodes) {
            if (n.getOutNodes().size() <= 1 && n.getInNodes().size() <= 1) continue;
            HolmesBranchVerticesPrototype.BranchStructure bs = new HolmesBranchVerticesPrototype.BranchStructure(n);
            bvSubNets.add(new SubNet(SubNetType.BV, null, null, null, null, bs.paths));
        }
    }

    public static void generateBranchesTransitions() {
        for (Node node : allTransitions) {
            if (node.getOutNodes().size() <= 1 && node.getInNodes().size() <= 1) continue;
            HolmesBranchVerticesPrototype.BranchStructure bs = new HolmesBranchVerticesPrototype.BranchStructure(node);
            btSubNets.add(new SubNet(SubNetType.BV, null, null, null, null, bs.paths));
        }
    }

    public static void generateBranchesPlaces() {
        for (Node node : allPlaces) {
            if (node.getOutNodes().size() <= 1 && node.getInNodes().size() <= 1) continue;
            HolmesBranchVerticesPrototype.BranchStructure bs = new HolmesBranchVerticesPrototype.BranchStructure(node);
            bpSubNets.add(new SubNet(SubNetType.BV, null, null, null, null, bs.paths));
        }
    }

    private static boolean checkIfContains(ArrayList<Path> anotherPath, Path path, ArrayList<ArrayList<Path>> connected) {
        for (Path pa : anotherPath) {
            for (Node n1 : pa.path) {
                for (Node n2 : path.path) {
                    if (!n1.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE) || n1.getID() != n2.getID()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkIfContains(ArrayList<Path> anotherPath, Path path) {
        for (Path pa : anotherPath) {
            for (Node n1 : pa.path) {
                for (Node n2 : path.path) {
                    if (!n1.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE) || n1.getID() != n2.getID()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean depHou(ArrayList<Path> used, ArrayList<Path> unUsed, ArrayList<Node> outNodes) {
        if (outNodes.contains(used.get((int)(used.size() - 1)).endNode)) {
            houResultList.add(used);
            return true;
        }
        ArrayList<Path> possible = SubnetCalculator.findPathsFrom(used.get((int)(used.size() - 1)).endNode, unUsed);
        for (Path pos : possible) {
            ArrayList<Path> NewUsed = new ArrayList<Path>(used);
            ArrayList<Path> NEWunUsed = new ArrayList<Path>(unUsed);
            NewUsed.add(pos);
            NEWunUsed.remove(pos);
            SubnetCalculator.depHou(NewUsed, NEWunUsed, outNodes);
        }
        return true;
    }

    private static boolean depNishi(ArrayList<Path> used, ArrayList<Path> unUsed, ArrayList<Node> outNodes) {
        if (outNodes.contains(used.get((int)(used.size() - 1)).endNode)) {
            for (Path paralelPath : paths) {
                if (paralelPath.endNode.getOutNodes().size() != 0) continue;
                used.add(paralelPath);
            }
            nishiResultList.add(used);
            return true;
        }
        ArrayList<Path> possible = SubnetCalculator.findNishiPathsFrom(used.get((int)(used.size() - 1)).endNode, unUsed);
        for (Path pos : possible) {
            ArrayList<Path> NewUsed = new ArrayList<Path>(used);
            ArrayList<Path> NEWunUsed = new ArrayList<Path>(unUsed);
            NewUsed.add(pos);
            NEWunUsed.remove(pos);
            for (Path parallelPath : paths) {
                if (parallelPath.startNode != pos.startNode || parallelPath.endNode != pos.endNode || parallelPath.equals(pos)) continue;
                NEWunUsed.remove(parallelPath);
                NewUsed.add(parallelPath);
            }
            SubnetCalculator.depNishi(NewUsed, NEWunUsed, outNodes);
        }
        return true;
    }

    private static boolean dep(ArrayList<Path> used, ArrayList<Path> unUsed) {
        if (used.get((int)0).startNode == used.get((int)(used.size() - 1)).endNode) {
            tzResultList.add(used);
            return true;
        }
        for (int i = 1; i < used.size(); ++i) {
            if (used.get((int)i).startNode != used.get((int)(used.size() - 1)).endNode) continue;
            return false;
        }
        ArrayList<Path> posible = SubnetCalculator.findPathsFrom(used.get((int)(used.size() - 1)).endNode, unUsed);
        for (Path pos : posible) {
            ArrayList<Path> NewUsed = new ArrayList<Path>(used);
            ArrayList<Path> NEWunUsed = new ArrayList<Path>(unUsed);
            NewUsed.add(pos);
            NEWunUsed.remove(pos);
            SubnetCalculator.dep(NewUsed, NEWunUsed);
        }
        return true;
    }

    private static ArrayList<Path> findPathsFrom(Node end, ArrayList<Path> list) {
        ArrayList<Path> possible = new ArrayList<Path>();
        for (Path p : list) {
            if (p.startNode != end || p.isCycle) continue;
            possible.add(p);
        }
        return possible;
    }

    private static ArrayList<Path> findNishiPathsFrom(Node end, ArrayList<Path> list) {
        ArrayList<Path> possible = new ArrayList<Path>();
        for (Path p : list) {
            boolean duble = false;
            for (Path n : possible) {
                if (n.endNode != p.endNode || n.startNode != p.startNode) continue;
                duble = true;
                break;
            }
            if (p.startNode != end || duble) continue;
            possible.add(p);
        }
        return possible;
    }

    private static ArrayList<Node> calculatePath(Node m, ArrayList<Node> path) {
        if (path.contains(m)) {
            return path;
        }
        usedNodes.add(m);
        path.add(m);
        if (m.getOutNodes().size() > 0 && m.getOutNodes().size() == 1) {
            SubnetCalculator.calculatePath(m.getOutNodes().get(0), path);
        }
        return path;
    }

    private static ArrayList<Path> calculatePaths() {
        ArrayList<Node> nodes;
        ArrayList<Path> listOfPaths = new ArrayList<Path>();
        for (Node n : allNodes) {
            if (n.getOutNodes().size() <= 1 && n.getInNodes().size() != 0 && (n.getInNodes().size() <= 1 || n.getOutNodes().size() == 0)) continue;
            if (n.getOutNodes().size() > 1) {
                usedNodes.add(n);
                for (Node m : n.getOutNodes()) {
                    ArrayList<Node> startPath = new ArrayList<Node>();
                    startPath.add(n);
                    ArrayList<Node> nodes2 = SubnetCalculator.calculatePath(m, startPath);
                    if (nodes2.get(nodes2.size() - 1).getOutNodes().contains(nodes2.get(0))) {
                        listOfPaths.add(new Path(nodes2.get(0), nodes2.get(nodes2.size() - 1), new ArrayList<Node>(nodes2), true));
                        continue;
                    }
                    listOfPaths.add(new Path(nodes2.get(0), nodes2.get(nodes2.size() - 1), new ArrayList<Node>(nodes2)));
                }
                continue;
            }
            nodes = SubnetCalculator.calculatePath(n, new ArrayList<Node>());
            listOfPaths.add(new Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes)));
        }
        for (Node n : allNodes) {
            if (usedNodes.contains(n)) continue;
            nodes = SubnetCalculator.calculatePath(n, new ArrayList<Node>());
            listOfPaths.add(new Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes), true));
        }
        return listOfPaths;
    }

    private static ArrayList<Path> calculatePathsHou() {
        ArrayList<Path> listOfPaths = new ArrayList<Path>();
        ArrayList<Node> listOfStartNodes = new ArrayList<Node>();
        for (Node n : allNodes) {
            if (n.getInNodes().size() == 1 && n.getOutNodes().size() == 1 || n.getInNodes().size() > 0 && n.getOutNodes().size() == 0) continue;
            listOfStartNodes.add(n);
        }
        for (Node n : listOfStartNodes) {
            ArrayList<Node> pathList = new ArrayList<Node>();
            pathList.add(n);
            for (Node singeOutNode : n.getOutNodes()) {
                pathList.add(singeOutNode);
                if ((pathList = SubnetCalculator.getDeeper(singeOutNode, pathList)).isEmpty()) continue;
                listOfPaths.add(new Path(pathList.get(0), pathList.get(pathList.size() - 1), new ArrayList<Node>(pathList)));
                pathList.clear();
                pathList.add(n);
            }
        }
        return listOfPaths;
    }

    private static ArrayList<Node> getDeeper(Node n, ArrayList<Node> list) {
        if (n.getOutNodes().size() > 1 || n.getInNodes().size() > 1) {
            return list;
        }
        if (!n.getOutNodes().isEmpty()) {
            list.add(n.getOutNodes().get(0));
            list = SubnetCalculator.getDeeper(n.getOutNodes().get(0), list);
        }
        return list;
    }

    private static ArrayList<Integer> getColumn(ArrayList<ArrayList<Integer>> im, int column) {
        ArrayList<Integer> newRow = new ArrayList<Integer>();
        for (ArrayList<Integer> integers : im) {
            newRow.add(integers.get(column));
        }
        return newRow;
    }

    private static boolean isSourceOrSink(ArrayList<Integer> rowOrColumn) {
        boolean isMore = false;
        boolean isLess = false;
        for (Integer integer : rowOrColumn) {
            if (integer > 0) {
                isMore = true;
            }
            if (integer >= 0) continue;
            isLess = true;
        }
        return isMore != isLess;
    }

    static {
        inN = new ArrayList();
        outN = new ArrayList();
    }

    public static class SubNet
    implements Serializable {
        private ArrayList<Transition> subTransitions;
        private ArrayList<Place> subPlaces;
        private ArrayList<Place> subBorderPlaces;
        private ArrayList<Place> subInternalPlaces;
        ArrayList<Arc> subArcs;
        private boolean proper;
        public HashMap<Integer, Node> orbitMap = new HashMap();
        private ArrayList<Transition> subBorderTransition;
        private ArrayList<Transition> subInternalTransition;
        int subNetID;

        public SubNet() {
        }

        public SubNet(SubNetType snt, ArrayList<Transition> subTransitions, ArrayList<Place> subPlaces, ArrayList<Node> subNode, ArrayList<Integer> maxADTset, ArrayList<Path> subPath) {
            this.proper = true;
            switch (snt) {
                case ZAJCEV: {
                    this.createTransirionBasedSubNet(subTransitions);
                    break;
                }
                case SNET: {
                    this.createPlaceBasedSubNet(subPlaces);
                    break;
                }
                case TNET: {
                    this.createTransirionBasedSubNet(this.getTransitionsForADT(maxADTset, subTransitions));
                    break;
                }
                case ADT: {
                    this.createTransirionBasedSubNet(this.getTransitionsForADT(maxADTset));
                    break;
                }
                case ADTcomp: {
                    this.createTransirionBasedSubNet(this.getTransitionsForADT(maxADTset, subTransitions));
                    break;
                }
                case ADP: {
                    this.createPlaceBasedSubNet(this.getTransitionsForADP(maxADTset));
                    break;
                }
                case TZ: {
                    this.createPathBasedSubNet(subPath);
                    break;
                }
                case HOU: {
                    this.createPathBasedSubNet(subPath);
                    break;
                }
                case NISHI: {
                    this.createPathBasedSubNet(subPath);
                    break;
                }
                case CYCLE: {
                    this.createPathBasedSubNet(subPath);
                    break;
                }
                case OOSTUKI: {
                    this.createPathOotsukiBasedSubNet(subPath);
                    break;
                }
                case SMC: {
                    this.createPlaceBasedSubNet(subPlaces);
                    break;
                }
                case MCT: {
                    this.createTransirionBasedSubNet(subTransitions);
                    break;
                }
                case TINV: {
                    this.createTransirionBasedSubNet(subTransitions);
                    break;
                }
                case PINV: {
                    this.createPlaceBasedSubNet(subPlaces);
                    break;
                }
                case BV: {
                    this.createBranchBasedSubNet(subPath);
                    break;
                }
                case NotTzCycles: {
                    this.createPathBasedSubNet(subPath);
                    break;
                }
                case Export: {
                    this.createExportSubnet(subNode);
                }
            }
        }

        private void createExportSubnet(ArrayList<Node> subNode) {
            this.subTransitions = new ArrayList();
            this.subPlaces = new ArrayList();
            this.subArcs = new ArrayList();
            for (Node n : subNode) {
                if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    this.subTransitions.add((Transition)n);
                    continue;
                }
                this.subPlaces.add((Place)n);
            }
            ArrayList<Arc> listOfAllArcs = new ArrayList<Arc>();
            for (Transition transition : this.subTransitions) {
                for (Arc arc : transition.getInArcs()) {
                    if (listOfAllArcs.contains(arc)) continue;
                    listOfAllArcs.add(arc);
                }
                for (Arc arc : transition.getOutArcs()) {
                    if (listOfAllArcs.contains(arc)) continue;
                    listOfAllArcs.add(arc);
                }
            }
            this.subArcs = listOfAllArcs;
        }

        public SubNet(ArrayList<Arc> al) {
            this.subTransitions = new ArrayList();
            this.subPlaces = new ArrayList();
            this.subArcs = al;
            for (Arc a : al) {
                if (a.getStartNode().getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    if (!this.subTransitions.contains(a.getStartNode())) {
                        this.subTransitions.add((Transition)a.getStartNode());
                    }
                } else if (!this.subPlaces.contains(a.getStartNode())) {
                    this.subPlaces.add((Place)a.getStartNode());
                }
                if (a.getEndNode().getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    if (this.subTransitions.contains(a.getEndNode())) continue;
                    this.subTransitions.add((Transition)a.getEndNode());
                    continue;
                }
                if (this.subPlaces.contains(a.getEndNode())) continue;
                this.subPlaces.add((Place)a.getEndNode());
            }
        }

        public SubNet(ArrayList<Arc> al, boolean mock) {
            this.subTransitions = new ArrayList();
            this.subPlaces = new ArrayList();
            this.subArcs = al;
            for (Arc a : al) {
                if (a.getStartNode().getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    if (!this.subTransitions.contains(a.getStartNode())) {
                        this.subTransitions.add((Transition)a.getStartNode());
                    }
                } else if (!this.subPlaces.contains(a.getStartNode())) {
                    this.subPlaces.add((Place)a.getStartNode());
                }
                if (a.getEndNode().getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    if (this.subTransitions.contains(a.getEndNode())) continue;
                    this.subTransitions.add((Transition)a.getEndNode());
                    continue;
                }
                if (this.subPlaces.contains(a.getEndNode())) continue;
                this.subPlaces.add((Place)a.getEndNode());
            }
        }

        private void createBranchBasedSubNet(ArrayList<Path> pathList) {
            this.subTransitions = new ArrayList();
            this.subPlaces = new ArrayList();
            for (Path path : pathList) {
                for (Node node : path.path) {
                    for (Transition t : allTransitions) {
                        if (t.getID() != node.getID() || this.subTransitions.contains(t)) continue;
                        this.subTransitions.add(t);
                    }
                    for (Place p : allPlaces) {
                        if (p.getID() != node.getID() || this.subPlaces.contains(p)) continue;
                        this.subPlaces.add(p);
                    }
                }
            }
            this.calculateBranchInternalArcs(this.subPlaces, this.subTransitions, pathList);
        }

        private void createPathBasedSubNet(ArrayList<Path> pathList) {
            this.subTransitions = new ArrayList();
            this.subPlaces = new ArrayList();
            for (Path path : pathList) {
                for (Node node : path.path) {
                    for (Transition t : allTransitions) {
                        if (t.getID() != node.getID() || this.subTransitions.contains(t)) continue;
                        this.subTransitions.add(t);
                    }
                    for (Place p : allPlaces) {
                        if (p.getID() != node.getID() || this.subPlaces.contains(p)) continue;
                        this.subPlaces.add(p);
                    }
                }
            }
            this.calculateInternalArcs(this.subPlaces, this.subTransitions, pathList);
        }

        private void calculateArcs(ArrayList<Place> subPlaces) {
            ArrayList<Arc> listOfAllArcs = new ArrayList<Arc>();
            for (Place place : subPlaces) {
                for (Arc arc : place.getInArcs()) {
                    if (listOfAllArcs.contains(arc)) continue;
                    listOfAllArcs.add(arc);
                }
                for (Arc arc : place.getOutArcs()) {
                    if (listOfAllArcs.contains(arc)) continue;
                    listOfAllArcs.add(arc);
                }
            }
            this.subArcs = listOfAllArcs;
        }

        private void createPathOotsukiBasedSubNet(ArrayList<Path> pathList) {
            ArrayList<Place> localSubPlaces = new ArrayList<Place>();
            for (Path path : pathList) {
                for (Node node : path.path) {
                    for (Place p : allPlaces) {
                        if (p.getID() != node.getID() || localSubPlaces.contains(p)) continue;
                        localSubPlaces.add(p);
                    }
                }
            }
            this.createPlaceBasedSubNet(localSubPlaces);
        }

        private void calculateInternalArcs(ArrayList<Place> subPlaces, ArrayList<Transition> subTransitions, ArrayList<Path> pathList) {
            ArrayList<Arc> listOfAllArcs = new ArrayList<Arc>();
            for (Path path : pathList) {
                for (int i = 0; i < path.path.size() - 1; ++i) {
                    Node startNode = path.path.get(i);
                    Node endNode = path.path.get(i + 1);
                    for (Arc arc : startNode.getOutArcs()) {
                        if (arc.getEndNode().getID() != endNode.getID()) continue;
                        listOfAllArcs.add(arc);
                    }
                }
                for (Arc arc : path.endNode.getOutArcs()) {
                    if (arc.getEndNode().getID() != path.startNode.getID()) continue;
                    listOfAllArcs.add(arc);
                }
            }
            this.subArcs = listOfAllArcs;
        }

        private void calculateBranchInternalArcs(ArrayList<Place> subPlaces, ArrayList<Transition> subTransitions, ArrayList<Path> pathList) {
            ArrayList<Arc> listOfAllArcs = new ArrayList<Arc>();
            for (Path path : pathList) {
                for (int i = 0; i < path.path.size() - 1; ++i) {
                    Node startNode = path.path.get(i);
                    Node endNode = path.path.get(i + 1);
                    for (Arc arc : startNode.getOutArcs()) {
                        if (arc.getEndNode().getID() != endNode.getID()) continue;
                        listOfAllArcs.add(arc);
                    }
                    for (Arc arc : startNode.getInArcs()) {
                        if (arc.getStartNode().getID() != endNode.getID()) continue;
                        listOfAllArcs.add(arc);
                    }
                }
                for (Arc arc : path.endNode.getOutArcs()) {
                    if (arc.getEndNode().getID() != path.startNode.getID()) continue;
                    listOfAllArcs.add(arc);
                }
            }
            this.subArcs = listOfAllArcs;
        }

        private ArrayList<Transition> getTransitionsForADT(ArrayList<Integer> maxADTset, ArrayList<Transition> transitions) {
            ArrayList<Transition> transitionsForADT = new ArrayList<Transition>();
            for (Integer number : maxADTset) {
                transitionsForADT.add(transitions.get(number));
            }
            return transitionsForADT;
        }

        private ArrayList<Transition> getTransitionsForADT(ArrayList<Integer> maxADTset) {
            ArrayList<Transition> transitionsForADT = new ArrayList<Transition>();
            for (Integer number : maxADTset) {
                transitionsForADT.add(allTransitions.get(number));
            }
            return transitionsForADT;
        }

        private ArrayList<Place> getTransitionsForADP(ArrayList<Integer> maxADPset) {
            ArrayList<Place> transitionsForADT = new ArrayList<Place>();
            for (Integer number : maxADPset) {
                transitionsForADT.add(allPlaces.get(number));
            }
            return transitionsForADT;
        }

        private void createTransirionBasedSubNet(ArrayList<Transition> subTransitions) {
            this.subTransitions = subTransitions;
            this.subInternalPlaces = new ArrayList();
            this.subBorderPlaces = new ArrayList();
            ArrayList<Place> listOfInOutPlaces = new ArrayList<Place>();
            for (Transition transition : this.subTransitions) {
                for (Place place : transition.getPostPlaces()) {
                    if (listOfInOutPlaces.contains(place)) continue;
                    listOfInOutPlaces.add(place);
                }
                for (Place place : transition.getPrePlaces()) {
                    if (listOfInOutPlaces.contains(place)) continue;
                    listOfInOutPlaces.add(place);
                }
            }
            this.subPlaces = listOfInOutPlaces;
            for (Place place : listOfInOutPlaces) {
                boolean border = false;
                for (Transition transition : place.getPostTransitions()) {
                    if (this.subTransitions.contains(transition)) continue;
                    border = true;
                    break;
                }
                for (Transition transition : place.getPreTransitions()) {
                    if (this.subTransitions.contains(transition)) continue;
                    border = true;
                    break;
                }
                if (border) {
                    this.subBorderPlaces.add(place);
                    continue;
                }
                this.subInternalPlaces.add(place);
            }
            ArrayList<Arc> listOfAllArcs = new ArrayList<Arc>();
            for (Transition transition : subTransitions) {
                for (Arc arc : transition.getInArcs()) {
                    if (listOfAllArcs.contains(arc)) continue;
                    listOfAllArcs.add(arc);
                }
                for (Arc arc : transition.getOutArcs()) {
                    if (listOfAllArcs.contains(arc)) continue;
                    listOfAllArcs.add(arc);
                }
            }
            this.subArcs = listOfAllArcs;
        }

        private void createPlaceBasedSubNet(ArrayList<Place> subPlaces) {
            this.subPlaces = subPlaces;
            this.subInternalTransition = new ArrayList();
            this.subBorderTransition = new ArrayList();
            ArrayList<Transition> listOfInOutTransition = new ArrayList<Transition>();
            for (Place place : this.subPlaces) {
                for (Transition transition : place.getPostTransitions()) {
                    if (listOfInOutTransition.contains(transition)) continue;
                    listOfInOutTransition.add(transition);
                }
                for (Transition transition : place.getPreTransitions()) {
                    if (listOfInOutTransition.contains(transition)) continue;
                    listOfInOutTransition.add(transition);
                }
            }
            this.subTransitions = listOfInOutTransition;
            for (Transition transition : listOfInOutTransition) {
                boolean border = false;
                for (Place place : transition.getPostPlaces()) {
                    if (this.subPlaces.contains(place)) continue;
                    border = true;
                    break;
                }
                for (Place place : transition.getPrePlaces()) {
                    if (this.subPlaces.contains(place)) continue;
                    border = true;
                    break;
                }
                if (border) {
                    this.subBorderTransition.add(transition);
                    continue;
                }
                this.subInternalTransition.add(transition);
            }
            this.calculateArcs(subPlaces);
        }

        public boolean isProper() {
            return this.proper;
        }

        public void setProper(boolean proper) {
            this.proper = proper;
        }

        public ArrayList<Transition> getSubBorderTransition() {
            return this.subBorderTransition;
        }

        public void setSubBorderTransition(ArrayList<Transition> subBorderTransition) {
            this.subBorderTransition = subBorderTransition;
        }

        public ArrayList<Transition> getSubInternalTransition() {
            return this.subInternalTransition;
        }

        public void setSubInternalTransition(ArrayList<Transition> subInternalTransition) {
            this.subInternalTransition = subInternalTransition;
        }

        public ArrayList<Transition> getSubTransitions() {
            return this.subTransitions;
        }

        public void setSubTransitions(ArrayList<Transition> subTransitions) {
            this.subTransitions = subTransitions;
        }

        public ArrayList<Node> getSubNode() {
            ArrayList<Node> listOfNodes = new ArrayList<Node>();
            listOfNodes.addAll(this.subTransitions);
            listOfNodes.addAll(this.subPlaces);
            return listOfNodes;
        }

        public void addTransitions(ArrayList<Transition> tl) {
            this.subTransitions.addAll(tl);
        }

        public ArrayList<Place> getSubPlaces() {
            return this.subPlaces;
        }

        public void setSubPlaces(ArrayList<Place> subPlaces) {
            this.subPlaces = subPlaces;
        }

        public ArrayList<Arc> getSubArcs() {
            return this.subArcs;
        }

        public void setSubArcs(ArrayList<Arc> subArcs) {
            this.subArcs = subArcs;
        }

        public int getSubNetID() {
            return this.subNetID;
        }

        public void setSubNetID(int subNetID) {
            this.subNetID = subNetID;
        }

        public ArrayList<Place> getSubBorderPlaces() {
            return this.subBorderPlaces;
        }

        public void setSubBorderPlaces(ArrayList<Place> subBorderPlaces) {
            this.subBorderPlaces = subBorderPlaces;
        }

        public ArrayList<Place> getSubInternalPlaces() {
            return this.subInternalPlaces;
        }

        public void setSubInternalPlaces(ArrayList<Place> subInternalPlaces) {
            this.subInternalPlaces = subInternalPlaces;
        }
    }

    public static enum SubNetType {
        ZAJCEV,
        SNET,
        TNET,
        ADT,
        ADTcomp,
        ADP,
        OOSTUKI,
        TZ,
        HOU,
        NISHI,
        CYCLE,
        NotTzCycles,
        SMC,
        MCT,
        TINV,
        PINV,
        BV,
        Export;

    }

    public static class Path
    implements Serializable {
        public Node startNode;
        public Node endNode;
        public ArrayList<Node> path;
        public ArrayList<Node> innerpath;
        public boolean isCycle = false;
        public boolean isRevers = false;

        public Path(Node s, Node e, ArrayList<Node> l) {
            this.startNode = s;
            this.endNode = e;
            this.path = new ArrayList<Node>(l);
            this.innerpath = new ArrayList<Node>(l);
            this.innerpath.remove(s);
            this.innerpath.remove(e);
        }

        public Path(Node s, Node e, ArrayList<Node> l, boolean cycle) {
            this.startNode = s;
            this.endNode = e;
            this.path = new ArrayList<Node>(l);
            this.innerpath = new ArrayList<Node>(l);
            this.innerpath.remove(s);
            this.innerpath.remove(e);
            this.isCycle = cycle;
        }

        public Path(Node s, Node e, ArrayList<Node> l, boolean cycle, boolean revers) {
            this.startNode = s;
            this.endNode = e;
            this.path = new ArrayList<Node>(l);
            this.innerpath = new ArrayList<Node>(l);
            this.innerpath.remove(s);
            this.innerpath.remove(e);
            this.isCycle = cycle;
            this.isRevers = revers;
        }

        private boolean checkConservativnes() {
            for (int i = 0; i < this.path.size(); ++i) {
            }
            return true;
        }
    }
}

