/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.darkgui.dockwindows.HolmesDockWindowsTable;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ProblemDetector {
    GUIManager overlord = GUIManager.getDefaultGUIManager();
    PetriNet pn = this.overlord.getWorkspace().getProject();
    HolmesDockWindowsTable subwindow;

    public ProblemDetector(HolmesDockWindowsTable holmesDockWindowsTable) {
        this.subwindow = holmesDockWindowsTable;
    }

    public void markSubSurNonInvariantsPlaces() {
        ArrayList<ArrayList<Object>> result = this.detectInvProblemPlaces();
        if (result == null) {
            return;
        }
        this.pn.resetNetColors();
        ArrayList<Object> res_places = result.get(0);
        ArrayList<Object> res_descr = result.get(1);
        for (int p = 0; p < res_places.size(); ++p) {
            Place place = (Place)res_places.get(p);
            String descr = (String)res_descr.get(p);
            place.drawGraphBoxP.setColorWithNumber(true, Color.GREEN, false, 0.0, true, descr, 0, 0, 0, 0);
        }
        this.pn.repaintAllGraphPanels();
    }

    public void markIOPlaces() {
        Place place;
        int p;
        ArrayList<Place> inPlaces = this.detectInPlaces();
        ArrayList<Place> outPlaces = this.detectOutPlaces();
        this.pn.resetNetColors();
        int inP = 0;
        int outP = 0;
        if (inPlaces != null) {
            inP = inPlaces.size();
            for (p = 0; p < inP; ++p) {
                place = inPlaces.get(p);
                place.drawGraphBoxP.setColorWithNumber(true, new Color(255, 0, 127), false, 0.0, true, "IN-place", 0, 0, 0, 0);
            }
        }
        if (outPlaces != null) {
            outP = outPlaces.size();
            for (p = 0; p < outP; ++p) {
                place = outPlaces.get(p);
                place.drawGraphBoxP.setColorWithNumber(true, new Color(255, 153, 204), false, 0.0, true, "OUT-place", 0, 0, 0, 0);
            }
        }
        this.subwindow.fixIOPlaces.setText("Input: " + inP + " / Output: " + outP);
        this.pn.repaintAllGraphPanels();
    }

    public void markIOTransitions() {
        Transition trans;
        ArrayList<Transition> inTransitions = this.detectInTrans();
        ArrayList<Transition> outTransitions = this.detectOutTrans();
        this.pn.resetNetColors();
        int inT = 0;
        int outT = 0;
        if (inTransitions != null) {
            inT = inTransitions.size();
            for (int p = 0; p < inT; ++p) {
                trans = inTransitions.get(p);
                trans.drawGraphBoxT.setColorWithNumber(true, new Color(0, 153, 153), false, 0.0, true, "IN-trans", 0, 0, 0, 0);
            }
        }
        if (outTransitions != null) {
            outT = outTransitions.size();
            for (int t = 0; t < outT; ++t) {
                trans = outTransitions.get(t);
                trans.drawGraphBoxT.setColorWithNumber(true, new Color(153, 255, 255), false, 0.0, true, "OUT-trans", 0, 0, 0, 0);
            }
        }
        this.subwindow.fixIOTransitions.setText("Input: " + inT + " / Output: " + outT);
        this.pn.repaintAllGraphPanels();
    }

    public void markLinearRegions() {
        int p;
        ArrayList<Place> linearPlaces = this.detectLinearPlaces();
        ArrayList<Transition> linearTransitions = this.detectLinearTrans();
        this.pn.resetNetColors();
        int linP = 0;
        int linT = 0;
        if (linearPlaces != null) {
            linP = linearPlaces.size();
            for (p = 0; p < linP; ++p) {
                Place place = linearPlaces.get(p);
                place.drawGraphBoxP.setColorWithNumber(true, new Color(0, 102, 0), false, 0.0, true, "Linear place", 0, 0, 0, 0);
            }
        }
        if (linearTransitions != null) {
            linT = linearTransitions.size();
            for (p = 0; p < linT; ++p) {
                Transition trans = linearTransitions.get(p);
                trans.drawGraphBoxT.setColorWithNumber(true, new Color(128, 255, 0), false, 0.0, true, "Linear trans", 0, 0, 0, 0);
            }
        }
        ArrayList<Place> places = this.pn.getPlaces();
        boolean regions = true;
        if (regions) {
            for (Place place : places) {
                if (!place.drawGraphBoxP.isColorChanged()) continue;
                for (ElementLocation el : place.getElementLocations()) {
                    for (Arc arc : el.getInArcs()) {
                        if (!((Transition)arc.getStartNode()).drawGraphBoxT.isColorChanged()) continue;
                        ((Transition)arc.getStartNode()).drawGraphBoxT.setColorWithNumber(true, Color.RED, false, 0.0, true, "LINEAR REGION", 0, 0, 0, 0);
                        place.drawGraphBoxP.setColorWithNumber(true, Color.RED, false, 0.0, true, "LINEAR REGION", 0, 0, 0, 0);
                    }
                    for (Arc arc : el.getOutArcs()) {
                        if (!((Transition)arc.getEndNode()).drawGraphBoxT.isColorChanged()) continue;
                        ((Transition)arc.getEndNode()).drawGraphBoxT.setColorWithNumber(true, Color.RED, false, 0.0, true, "LINEAR REGION", 0, 0, 0, 0);
                        place.drawGraphBoxP.setColorWithNumber(true, Color.RED, false, 0.0, true, "LINEAR REGION", 0, 0, 0, 0);
                    }
                }
            }
        }
        this.subwindow.fixlinearTrans.setText("Transitions: " + linT + " / Places: " + linP);
        this.pn.repaintAllGraphPanels();
    }

    public ArrayList<Place> detectInPlaces() {
        ArrayList<Place> inPlaces = new ArrayList<Place>();
        ArrayList<Place> places = this.pn.getPlaces();
        if (places == null || places.size() == 0) {
            return null;
        }
        for (Place place : places) {
            boolean ok = true;
            for (ElementLocation el : place.getElementLocations()) {
                if (el.getInArcs().size() <= 0) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            inPlaces.add(place);
        }
        return inPlaces;
    }

    public ArrayList<Place> detectOutPlaces() {
        ArrayList<Place> outPlaces = new ArrayList<Place>();
        ArrayList<Place> places = this.pn.getPlaces();
        if (places == null || places.size() == 0) {
            return null;
        }
        for (Place place : places) {
            boolean ok = true;
            for (ElementLocation el : place.getElementLocations()) {
                if (el.getOutArcs().size() <= 0) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            outPlaces.add(place);
        }
        return outPlaces;
    }

    public ArrayList<Transition> detectInTrans() {
        ArrayList<Transition> inTrans = new ArrayList<Transition>();
        ArrayList<Transition> transitions = this.pn.getTransitions();
        if (transitions == null || transitions.size() == 0) {
            return null;
        }
        for (Transition trans : transitions) {
            boolean ok = true;
            for (ElementLocation el : trans.getElementLocations()) {
                if (el.getInArcs().size() <= 0) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            inTrans.add(trans);
        }
        return inTrans;
    }

    public ArrayList<Transition> detectOutTrans() {
        ArrayList<Transition> outTrans = new ArrayList<Transition>();
        ArrayList<Transition> transitions = this.pn.getTransitions();
        if (transitions == null || transitions.size() == 0) {
            return null;
        }
        for (Transition trans : transitions) {
            boolean ok = true;
            for (ElementLocation el : trans.getElementLocations()) {
                if (el.getOutArcs().size() <= 0) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            outTrans.add(trans);
        }
        return outTrans;
    }

    public ArrayList<Place> detectLinearPlaces() {
        ArrayList<Place> linearPlaces = new ArrayList<Place>();
        ArrayList<Place> places = this.pn.getPlaces();
        if (places == null || places.size() == 0) {
            return null;
        }
        int inArcs = 0;
        int ourArcs = 0;
        int counter = -1;
        for (Place place : places) {
            if (++counter == 48) {
                boolean bl = true;
            }
            inArcs = 0;
            ourArcs = 0;
            boolean cancel = false;
            for (ElementLocation el : place.getElementLocations()) {
                if ((inArcs += el.getInArcs().size()) <= 1) continue;
                cancel = true;
                break;
            }
            if (cancel || inArcs == 0) continue;
            for (ElementLocation el : place.getElementLocations()) {
                if ((ourArcs += el.getOutArcs().size()) <= 1) continue;
                cancel = true;
                break;
            }
            if (cancel || ourArcs == 0) continue;
            linearPlaces.add(place);
        }
        return linearPlaces;
    }

    public ArrayList<Transition> detectLinearTrans() {
        ArrayList<Transition> linearTrans = new ArrayList<Transition>();
        ArrayList<Transition> transitions = this.pn.getTransitions();
        if (transitions == null || transitions.size() == 0) {
            return null;
        }
        int inArcs = 0;
        int ourArcs = 0;
        for (Transition trans : transitions) {
            inArcs = 0;
            ourArcs = 0;
            boolean cancel = false;
            for (ElementLocation el : trans.getElementLocations()) {
                if ((inArcs += el.getInArcs().size()) <= 1) continue;
                cancel = true;
                break;
            }
            if (cancel || inArcs == 0) continue;
            for (ElementLocation el : trans.getElementLocations()) {
                if ((ourArcs += el.getOutArcs().size()) <= 1) continue;
                cancel = true;
                break;
            }
            if (cancel || ourArcs == 0) continue;
            linearTrans.add(trans);
        }
        return linearTrans;
    }

    public ArrayList<ArrayList<Object>> detectInvProblemPlaces() {
        Object oldVal;
        int index;
        Place p;
        int value;
        int i;
        ArrayList<ArrayList<Integer>> invariants = this.pn.getT_InvMatrix();
        if (invariants == null || invariants.size() == 0) {
            JOptionPane.showMessageDialog(null, "T-invariants matrix has not been found.", "No t-invariants", 2);
            return null;
        }
        ArrayList<Place> places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        ArrayList<Place> res_places = new ArrayList<Place>();
        ArrayList<Object> res_descr = new ArrayList<Object>();
        ArrayList<ArrayList<Object>> result = new ArrayList<ArrayList<Object>>();
        result.add(res_places);
        result.add(res_descr);
        InvariantsCalculator ic = new InvariantsCalculator(true);
        ArrayList<ArrayList<Integer>> matrix = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), invariants, true);
        int invNumber = matrix.get(0).get(0);
        int surNumber = matrix.get(0).get(1);
        int subNumber = matrix.get(0).get(2);
        int nonNumber = matrix.get(0).get(3);
        this.subwindow.fixInvariants.setText("Normal: " + invNumber + " / Non-inv.: " + nonNumber);
        this.subwindow.fixInvariants2.setText("Sub-inv.: " + subNumber + " / Sur-inv: " + surNumber);
        if (surNumber > 0) {
            ArrayList<Integer> surVector = matrix.get(1);
            for (i = 0; i < surVector.size(); ++i) {
                value = surVector.get(i);
                if (value == 0) continue;
                res_places.add(places.get(i));
                res_descr.add("Sur:" + value);
            }
        }
        if (subNumber > 0) {
            ArrayList<Integer> subVector = matrix.get(2);
            for (i = 0; i < subVector.size(); ++i) {
                value = subVector.get(i);
                if (value == 0) continue;
                p = places.get(i);
                if (res_places.contains(p)) {
                    index = res_places.indexOf(p);
                    oldVal = res_descr.get(index).toString();
                    oldVal = (String)oldVal + " / Sub:" + value;
                    res_descr.set(index, oldVal);
                    continue;
                }
                res_places.add(places.get(i));
                res_descr.add("Sub:" + value);
            }
        }
        if (nonNumber > 0) {
            ArrayList<Integer> nonVector = matrix.get(3);
            for (i = 0; i < nonVector.size(); ++i) {
                value = nonVector.get(i);
                if (value == 0) continue;
                p = places.get(i);
                if (res_places.contains(p)) {
                    index = res_places.indexOf(p);
                    oldVal = res_descr.get(index).toString();
                    oldVal = (String)oldVal + " / NonI:" + value;
                    res_descr.set(index, oldVal);
                    continue;
                }
                res_places.add(places.get(i));
                res_descr.add("NonI:" + value);
            }
        }
        return result;
    }
}

