/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;

public class NetPropertiesAnalyzer {
    private ArrayList<Arc> arcs;
    private ArrayList<Place> places;
    private ArrayList<Transition> transitions;
    private ArrayList<Node> nodes;
    private ArrayList<MetaNode> metaNodes;
    ArrayList<Node> checked = new ArrayList();

    public NetPropertiesAnalyzer() {
        PetriNet pn = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        this.places = pn.getPlaces();
        this.transitions = pn.getTransitions();
        this.arcs = pn.getArcs();
        this.nodes = pn.getNodes();
        this.metaNodes = pn.getMetaNodes();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<ArrayList<Object>> propAnalyze() {
        int n;
        boolean bl;
        int n2;
        boolean bl2;
        boolean bl3;
        boolean arcOut;
        boolean arcIn;
        ArrayList<ArrayList<Object>> NetProps = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> purProp = new ArrayList<Object>();
        purProp.add("PUR");
        purProp.add(false);
        String[] purTxt = new String[]{"Pure", "There are no two nodes, directly connected in both directions. This precludes \nread arcs and double arcs.", "No component is produced and consumed by the same reaction."};
        purProp.add(purTxt);
        NetProps.add(purProp);
        ArrayList<Object> ordProp = new ArrayList<Object>();
        ordProp.add("ORD");
        ordProp.add(false);
        String[] ordTxt = new String[]{"Ordinary", "All arc weights are equal to 1.", "Every stoichiometric coefficient of each reaction is equal to one."};
        ordProp.add(ordTxt);
        NetProps.add(ordProp);
        ArrayList<Object> homProp = new ArrayList<Object>();
        homProp.add("HOM");
        homProp.add(false);
        String[] homTxt = new String[]{"Homogeneous", "All outgoing arcs of a given place have the same multiplicity.", "Each consuming reaction associated with one component takes the same \namount of molecules of this component."};
        homProp.add(homTxt);
        NetProps.add(homProp);
        ArrayList<Object> conProp = new ArrayList<Object>();
        conProp.add("CON");
        conProp.add(false);
        String[] conTxt = new String[]{"Connected", "A Petri net is connected if it holds for every two nodes a and b that \nthere is an undirected path between a and b. Disconnected parts of a \nPetri net can not influence each other, so they can be usually analysed \nseparately.", "All components in a system are directly or indirectly connected with \neach other through a set of reactions, e.g., metabolic paths, signal flows."};
        conProp.add(conTxt);
        NetProps.add(conProp);
        ArrayList<Object> scProp = new ArrayList<Object>();
        scProp.add("SC");
        scProp.add(false);
        String[] scTxt = new String[]{"Strongly Connected", "A Petri net is strongly connected if it holds for every two nodes a and b that \nthere is a directed path from a to b, vice versa. Strong connectedness \ninvolves connectedness and the absence of boundary nodes. It is a necessary \ncondition for a Petri net to be live and bounded at the same time.", "All components in a system are directly connected with each other through a set \nof reactions, e.g., metabolic paths, signal flows."};
        scProp.add(scTxt);
        NetProps.add(scProp);
        ArrayList<Object> nbmProp = new ArrayList<Object>();
        nbmProp.add("NBM");
        nbmProp.add(false);
        String[] nbmTxt = new String[]{"Non-blocking Multiplicity", "The minimum of the multiplicity of the incoming arcs for a place is not \nless than the maximum of the multiplicities of its outgoing arcs.", "The amount of produced and consumed molecules of a certain component \nis always equal."};
        nbmProp.add(nbmTxt);
        NetProps.add(nbmProp);
        ArrayList<Object> csvProp = new ArrayList<Object>();
        csvProp.add("CSV");
        csvProp.add(false);
        String[] csvTxt = new String[]{"Conservative", "All transitions add exactly as many tokens to their post-places as they \nsubtract from their pre-places (token-preservingly firing). A conservative \nPetri net is structurally bounded.", "The total amount of consumed and produced molecules by a certain reaction \nis always equal."};
        csvProp.add(csvTxt);
        NetProps.add(csvProp);
        ArrayList<Object> scfProp = new ArrayList<Object>();
        scfProp.add("SCF");
        scfProp.add(false);
        String[] scfTxt = new String[]{"Static Conflict Free", "There are no two transitions sharing a pre-place. Transitions involved in a \ndynamic conflict compete for the tokens on shared places.", "For every reactant exist just one possible reaction or there are no two \nreactions sharing at least one reactant."};
        scfProp.add(scfTxt);
        NetProps.add(scfProp);
        ArrayList<Object> ft0Prop = new ArrayList<Object>();
        ft0Prop.add("Ft0");
        ft0Prop.add(false);
        String[] ft0Txt = new String[]{"Input transitions", "There are transitions without a pre-place: Ft = {}", "Infinite source of a component."};
        ft0Prop.add(ft0Txt);
        NetProps.add(ft0Prop);
        ArrayList<Object> tf0Prop = new ArrayList<Object>();
        tf0Prop.add("tF0");
        tf0Prop.add(false);
        String[] tf0Txt = new String[]{"Output transitions", "There are transitions without a post-place: tF = {}", "Sink of a component."};
        tf0Prop.add(tf0Txt);
        NetProps.add(tf0Prop);
        ArrayList<Object> fp0Prop = new ArrayList<Object>();
        fp0Prop.add("Fp0");
        fp0Prop.add(false);
        String[] fp0Txt = new String[]{"Input places", "There are places without pre-transitions: Fp = {}", "Every component can be consumed by a reaction."};
        fp0Prop.add(fp0Txt);
        NetProps.add(fp0Prop);
        ArrayList<Object> pf0Prop = new ArrayList<Object>();
        pf0Prop.add("pF0");
        pf0Prop.add(false);
        String[] pf0Txt = new String[]{"Output places", "There are places without post-transitions: pF = {}", "Components can infinitely accumulate in the system."};
        pf0Prop.add(pf0Txt);
        NetProps.add(pf0Prop);
        if (this.places.size() == 0 || this.transitions.size() == 0 || this.arcs.size() == 0) {
            return NetProps;
        }
        boolean isFT0 = false;
        boolean isTF0 = false;
        boolean isFP0 = false;
        boolean isPF0 = false;
        for (Transition transition : this.transitions) {
            arcIn = false;
            arcOut = false;
            for (ElementLocation elementLocation : transition.getElementLocations()) {
                if (!elementLocation.getInArcs().isEmpty() && !arcIn) {
                    arcIn = true;
                }
                if (elementLocation.getOutArcs().isEmpty() || arcOut) continue;
                arcOut = true;
            }
            if (!arcIn && arcOut) {
                isFT0 = true;
            }
            if (!arcIn || arcOut) continue;
            isTF0 = true;
        }
        for (Place place : this.places) {
            arcIn = false;
            arcOut = false;
            for (ElementLocation elementLocation : place.getElementLocations()) {
                if (!elementLocation.getInArcs().isEmpty() && !arcIn) {
                    arcIn = true;
                }
                if (elementLocation.getOutArcs().isEmpty() || arcOut) continue;
                arcOut = true;
            }
            if (!arcIn && arcOut) {
                isFP0 = true;
            }
            if (!arcIn || arcOut) continue;
            isPF0 = true;
        }
        ft0Prop.set(1, isFT0);
        tf0Prop.set(1, isTF0);
        fp0Prop.set(1, isFP0);
        pf0Prop.set(1, isPF0);
        boolean isPure = true;
        for (Transition t : this.transitions) {
            for (ElementLocation elementLocation : t.getElementLocations()) {
                for (Arc arc : elementLocation.getInArcs()) {
                    for (ElementLocation elementLocation2 : arc.getStartNode().getElementLocations()) {
                        for (Arc arc2 : elementLocation2.getInArcs()) {
                            if (arc2.getStartNode().getID() != t.getID()) continue;
                            isPure = false;
                        }
                    }
                }
            }
        }
        purProp.set(1, isPure);
        boolean bl4 = true;
        for (Arc a : this.arcs) {
            if (a.getWeight() == 1) continue;
            bl3 = false;
            break;
        }
        ordProp.set(1, bl3);
        boolean isHomogenous = true;
        for (Place place : this.places) {
            int n3 = 0;
            for (ElementLocation el : place.getElementLocations()) {
                for (Arc arc : el.getOutArcs()) {
                    if (n3 == 0) {
                        n3 = arc.getWeight();
                        continue;
                    }
                    if (n3 == arc.getWeight()) continue;
                    isHomogenous = false;
                }
            }
        }
        homProp.set(1, isHomogenous);
        boolean isNonBlockingMulti = true;
        for (Place place : this.places) {
            int n4;
            int n5 = Integer.MAX_VALUE;
            int valOut = 0;
            for (ElementLocation elementLocation : place.getElementLocations()) {
                for (Arc arc : elementLocation.getInArcs()) {
                    if (arc.getWeight() >= n4) continue;
                    n4 = arc.getWeight();
                }
                for (Arc arc : elementLocation.getOutArcs()) {
                    if (arc.getWeight() <= valOut) continue;
                    valOut = arc.getWeight();
                }
            }
            if (valOut <= n4) continue;
            isNonBlockingMulti = false;
            break;
        }
        nbmProp.set(1, isNonBlockingMulti);
        boolean bl5 = true;
        for (Transition transition : this.transitions) {
            void var38_86;
            int arcIn2 = 0;
            boolean bl6 = false;
            for (ElementLocation elementLocation : transition.getElementLocations()) {
                for (Arc a : elementLocation.getInArcs()) {
                    arcIn2 += a.getWeight();
                }
                for (Arc a : elementLocation.getOutArcs()) {
                    var38_86 += a.getWeight();
                }
            }
            if (arcIn2 == var38_86) continue;
            bl2 = false;
            break;
        }
        csvProp.set(1, bl2);
        boolean bl7 = false;
        Node node = this.nodes.get(0);
        int tNo = this.transitions.size();
        int n6 = this.places.size();
        int n7 = this.metaNodes.size();
        int n8 = this.nodes.size();
        if (tNo + n6 != n8 - n7) {
            GUIManager.getDefaultGUIManager().log("Network analyzer detected a problem within the net. Number of places: " + n6 + " and number transitions: " + tNo + " do not sum to the total stored number of nodes: " + n8 + " minus number of meta-nodes: " + n7 + ".", "warning", true);
        }
        if ((n2 = this.checkNetConnectivity(node, new ArrayList<Node>())) == n8) {
            bl = true;
        }
        conProp.set(1, bl);
        boolean isStronglyConnected = false;
        if (this.fastStrongConnectivityTest() && (n = this.checkNetStrongConnectivity(node, new ArrayList<Node>())) == n8) {
            isStronglyConnected = true;
        }
        scProp.set(1, isStronglyConnected);
        boolean isStaticConFree = true;
        for (Transition t : this.transitions) {
            for (ElementLocation el : t.getElementLocations()) {
                for (Arc a1 : el.getInArcs()) {
                    for (Transition t2 : this.transitions) {
                        if (t.getID() == t2.getID()) continue;
                        for (ElementLocation el2 : t2.getElementLocations()) {
                            for (Arc a2 : el2.getInArcs()) {
                                if (a1.getStartNode().getID() != a2.getStartNode().getID()) continue;
                            }
                        }
                    }
                }
            }
        }
        isStaticConFree = false;
        scfProp.set(1, isStaticConFree);
        return NetProps;
    }

    private boolean checkStronglyConnectionExist(Node n1, Node n2, Node last, boolean mode) {
        if (mode && n1.getID() == n2.getID()) {
            return false;
        }
        if (n1.getInArcs() != null) {
            for (Arc a : n1.getInArcs()) {
                if (a.getStartNode().getID() != last.getID()) continue;
                return true;
            }
            for (Arc a : n1.getInArcs()) {
                if (!this.checkStronglyConnectionExist(a.getStartNode(), n2, last, true)) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private int checkNetConnectivity(Node start, ArrayList<Node> reachable) {
        Node nod;
        if (!reachable.contains(start)) {
            reachable.add(start);
        }
        if (start.getInArcs() != null) {
            for (Arc a : start.getInArcs()) {
                nod = a.getStartNode();
                if (reachable.contains(nod)) continue;
                reachable.add(nod);
                this.checkNetConnectivity(nod, reachable);
            }
        }
        if (start.getOutArcs() != null) {
            for (Arc a : start.getOutArcs()) {
                nod = a.getEndNode();
                if (reachable.contains(nod)) continue;
                reachable.add(nod);
                this.checkNetConnectivity(nod, reachable);
            }
        }
        return reachable.size();
    }

    private int checkNetStrongConnectivity(Node start, ArrayList<Node> reachable) {
        if (!reachable.contains(start)) {
            reachable.add(start);
        }
        if (start.getOutArcs() != null) {
            for (Arc a : start.getOutArcs()) {
                Node nod = a.getEndNode();
                if (reachable.contains(nod)) continue;
                reachable.add(nod);
                this.checkNetStrongConnectivity(nod, reachable);
            }
        }
        return reachable.size();
    }

    private boolean fastStrongConnectivityTest() {
        for (Node n : this.nodes) {
            if (n.getInArcs().size() != 0 && n.getOutArcs().size() != 0) continue;
            return false;
        }
        return true;
    }
}

