/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.InvariantsTools;
import holmes.analyse.matrix.IncidenceMatrix;
import holmes.analyse.matrix.InputMatrix;
import holmes.analyse.matrix.OutputMatrix;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class MCTCalculator {
    private InputMatrix inMatrix;
    private OutputMatrix outMatrix;
    private IncidenceMatrix matrix;
    private PetriNet petriNet;

    public MCTCalculator(PetriNet petriNet) {
        this.petriNet = petriNet;
    }

    public void initiateData() {
        this.inMatrix = new InputMatrix(this.petriNet.getTransitions(), this.petriNet.getPlaces());
        this.outMatrix = new OutputMatrix(this.petriNet.getTransitions(), this.petriNet.getPlaces());
        this.setMatrix(new IncidenceMatrix(this.petriNet.getTransitions(), this.petriNet.getPlaces(), this.inMatrix, this.outMatrix));
    }

    public IncidenceMatrix getMatrix() {
        return this.matrix;
    }

    private void setMatrix(IncidenceMatrix matrix) {
        this.matrix = matrix;
    }

    public ArrayList<ArrayList<Transition>> generateMCT() {
        ArrayList<Transition> allTransitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        ArrayList<ArrayList<Integer>> invariantsTranspose = null;
        if (GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_invTypesComputed()) {
            ArrayList<Integer> tInvTypes = GUIManager.getDefaultGUIManager().getWorkspace().getProject().accessT_InvTypesVector();
            ArrayList<ArrayList<Integer>> tInv = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
            ArrayList<ArrayList<Integer>> cleantInv = new ArrayList<ArrayList<Integer>>();
            for (int x = 0; x < tInv.size(); ++x) {
                if (tInvTypes.get(x) != 0) continue;
                cleantInv.add(tInv.get(x));
            }
            invariantsTranspose = InvariantsTools.transposeMatrix(cleantInv);
        } else {
            invariantsTranspose = InvariantsTools.transposeMatrix(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix());
        }
        invariantsTranspose = InvariantsTools.returnBinaryMatrix(invariantsTranspose);
        ArrayList<ArrayList<Transition>> mctGroups = new ArrayList<ArrayList<Transition>>();
        int size = allTransitions.size();
        for (int t1 = 0; t1 < size; ++t1) {
            ArrayList<Transition> currentMCT = new ArrayList<Transition>();
            ArrayList<Integer> invVector = invariantsTranspose.get(t1);
            ArrayList<Integer> support = InvariantsTools.getSupport(invVector);
            for (int t2 = 0; t2 < size; ++t2) {
                ArrayList<Integer> invVector2 = invariantsTranspose.get(t2);
                if (!invVector.equals(invVector2) || support.size() <= 0) continue;
                currentMCT.add(allTransitions.get(t2));
            }
            if (currentMCT.size() <= 0 || mctGroups.contains(currentMCT)) continue;
            mctGroups.add(currentMCT);
        }
        GUIManager.getDefaultGUIManager().reset.setMCTStatus(true);
        return mctGroups;
    }

    public static ArrayList<ArrayList<Transition>> getSortedMCT(ArrayList<ArrayList<Transition>> mctGroups, boolean addTrivial) {
        ArrayList<Transition> mctRow;
        int i;
        ArrayList<Transition> unused = new ArrayList<Transition>();
        for (i = 0; i < mctGroups.size(); ++i) {
            mctRow = mctGroups.get(i);
            if (mctRow.size() != 1) continue;
            unused.add(mctRow.get(0));
            mctGroups.set(i, null);
        }
        for (i = 0; i < mctGroups.size(); ++i) {
            mctRow = mctGroups.get(i);
            if (mctRow != null) continue;
            mctGroups.remove(i);
            --i;
        }
        Object[] temp = mctGroups.toArray();
        Arrays.sort(temp, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                ArrayList temp1 = (ArrayList)o1;
                ArrayList temp2 = (ArrayList)o2;
                if (temp1.size() > temp2.size()) {
                    return -1;
                }
                if (temp1.size() == temp2.size()) {
                    return 0;
                }
                return 1;
            }
        });
        mctGroups.clear();
        for (Object o : temp) {
            mctGroups.add((ArrayList)o);
        }
        if (addTrivial) {
            mctGroups.add(unused);
        }
        return mctGroups;
    }
}

