/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;

public class KnockoutCalculator {
    ArrayList<ArrayList<Integer>> calc_invariants;
    ArrayList<Transition> calc_transitions;
    ArrayList<Place> calc_places;

    public KnockoutCalculator() {
        ArrayList<ArrayList<Integer>> invariants = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
        if (invariants == null || invariants.size() == 0) {
            return;
        }
        this.calc_invariants = invariants;
        this.calc_transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        this.calc_places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
    }

    public ArrayList<Transition> calculateKnockout(ArrayList<Transition> knockout) {
        ArrayList<Transition> resultSet = new ArrayList<Transition>();
        int invNumber = this.calc_invariants.size();
        int transNumber = this.calc_transitions.size();
        for (Transition trans : knockout) {
            int transLocation = this.calc_transitions.indexOf(trans);
            for (int i = 0; i < invNumber; ++i) {
                if (this.calc_invariants.get(i).get(transLocation) <= 0) continue;
                for (int t = 0; t < transNumber; ++t) {
                    Transition knockedout;
                    if (this.calc_invariants.get(i).get(t) <= 0 || resultSet.contains(knockedout = this.calc_transitions.get(t))) continue;
                    resultSet.add(knockedout);
                }
            }
        }
        for (Transition trans : knockout) {
            resultSet.remove(trans);
        }
        return resultSet;
    }
}

