/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.GraphletsCalculator;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.windows.decompositions.HolmesComparisonModule;
import java.util.Arrays;
import javax.swing.table.DefaultTableModel;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.xy.XYSeries;

public class GRDFcalculator
implements Runnable {
    private HolmesComparisonModule masterWindow = GUIManager.getDefaultGUIManager().accessComparisonWindow();

    @Override
    public void run() {
        int chiisenGraohletSize = this.masterWindow.getChoosenGraohletSize(this.masterWindow.graphletSize.getSelectedIndex());
        this.masterWindow.infoPaneDRGF.append("Comparison process started. \n");
        this.masterWindow.infoPaneDRGF.append("First net count... \n");
        long[] firstSingleDRGF = this.calcDRGF(GUIManager.getDefaultGUIManager().getWorkspace().getProject());
        this.masterWindow.infoPaneDRGF.append("\nSecond net count... \n");
        long[] secondSingleDRGF = this.calcDRGF(this.masterWindow.secondNet);
        long firstSum = Arrays.stream(firstSingleDRGF).sum();
        long secondSum = Arrays.stream(secondSingleDRGF).sum();
        long[] distanceDRGF = new long[chiisenGraohletSize];
        double result = 0.0;
        for (int i = 0; i < chiisenGraohletSize; ++i) {
            distanceDRGF[i] = Math.abs(firstSingleDRGF[i] - secondSingleDRGF[i]);
            result += Math.abs((double)firstSingleDRGF[i] / (double)firstSum - (double)secondSingleDRGF[i] / (double)secondSum);
        }
        int nodeN = this.masterWindow.graphletSize.getSelectedIndex() + 1;
        this.masterWindow.infoPaneDRGF.append("\nGRDF (" + nodeN + "-node) : " + result);
        XYSeries series1 = new XYSeries((Comparable)((Object)"Number of graphlets of net 1"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Number of graphlets of net 2"));
        this.masterWindow.dataDRGF = new Object[chiisenGraohletSize][4];
        Object[] colNames = new String[]{"Graphlets", "First net", "Second net", "Distance"};
        for (int i = 0; i < chiisenGraohletSize; ++i) {
            this.masterWindow.dataDRGF[i][0] = "G " + i;
            this.masterWindow.dataDRGF[i][1] = firstSingleDRGF[i];
            this.masterWindow.dataDRGF[i][2] = secondSingleDRGF[i];
            this.masterWindow.dataDRGF[i][3] = distanceDRGF[i];
            series1.add((double)i, firstSingleDRGF[i]);
            series2.add((double)i, secondSingleDRGF[i]);
        }
        DefaultTableModel model = new DefaultTableModel(this.masterWindow.dataDRGF, colNames);
        this.masterWindow.drgfTable.setModel(model);
        this.masterWindow.grdfSeriesDataSet.removeAllSeries();
        this.masterWindow.grdfSeriesDataSet.addSeries(series1);
        this.masterWindow.grdfSeriesDataSet.addSeries(series2);
        this.masterWindow.grdfChartPanel.setVisible(true);
        CategoryPlot chartPlot = this.masterWindow.grdfChart.getCategoryPlot();
        ValueAxis yAxis = chartPlot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryAxis xAxis = chartPlot.getDomainAxis();
        this.masterWindow.drgfTable.revalidate();
        this.masterWindow.infoPaneDRGF.append("\nComparison process ended.\n");
    }

    private long[] calcDRGF(PetriNet project) {
        GraphletsCalculator.cleanAll();
        GraphletsCalculator.generateGraphlets();
        GraphletsCalculator.getFoundServerGraphlets(project, this.masterWindow.infoPaneDRGF);
        long[] singleDRGF = new long[GraphletsCalculator.graphetsList.size()];
        for (int k = 0; k < GraphletsCalculator.graphetsList.size(); ++k) {
            long val;
            int finalI = k;
            singleDRGF[k] = val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
        }
        return singleDRGF;
    }
}

