/*
 * Decompiled with CFR 0.152.
 */
package holmes.adam.mct;

import holmes.adam.mct.MCTPetriNet;
import holmes.adam.mct.MCTSet;
import holmes.adam.mct.MCTTransition;
import holmes.adam.mct.TInvariant;
import holmes.adam.mct.Utils;
import holmes.darkgui.GUIManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class Runner {
    private PrintWriter out = null;

    private void print(String s) throws FileNotFoundException {
        if (this.out == null) {
            this.out = new PrintWriter("output/output.txt");
        }
        this.out.print(s);
        this.out.flush();
    }

    private void print(PrintWriter pw, String s) {
        if (pw == null) {
            return;
        }
        pw.print(s);
        pw.flush();
    }

    private void println(String s) throws FileNotFoundException {
        if (this.out == null) {
            this.out = new PrintWriter("output/output.txt");
        }
        this.out.println(s);
        this.out.flush();
    }

    private void println(PrintWriter pw, String s) {
        if (pw == null) {
            return;
        }
        this.print(pw, s);
        pw.println();
        pw.flush();
    }

    public void activate(String[] args) throws FileNotFoundException, IOException {
        ProgramSettings ps;
        try {
            ps = new ProgramSettings(args);
        }
        catch (RuntimeException re) {
            ProgramSettings.printHelp();
            return;
        }
        String fileName = ps.inputFilePath;
        File file = new File(fileName);
        FileInputStream is = new FileInputStream(file);
        this.out = new PrintWriter(ps.outputFilePath);
        PrintWriter vOut = fileName.endsWith(".csv") ? null : new PrintWriter(ps.csvOutputFilePath);
        MCTPetriNet petriNet = new MCTPetriNet();
        SortedSet<TInvariant> tInvariants = file.getName().toLowerCase().endsWith(".inv") ? Utils.readFromCharlie(is, petriNet) : (file.getName().toLowerCase().endsWith(".csv") ? Utils.readFromCSV(is, petriNet) : Utils.readTInvariants(is, true, petriNet));
        Map<String, String> renameMap = ps.mctRenameFile != null ? Utils.readMCTNameMap(ps.mctRenameFile) : null;
        GUIManager.getDefaultGUIManager().log("MCT Generator: input file read.", "text", true);
        SortedSet<MCTSet> mctSets = Utils.buildMCT(tInvariants, renameMap);
        TreeSet<MCTSet> properMctSets = new TreeSet<MCTSet>();
        TreeSet<MCTSet> single = new TreeSet<MCTSet>();
        for (MCTSet mCTSet : mctSets) {
            if (mCTSet.getTransitionSet().size() > 1) {
                properMctSets.add(mCTSet);
                continue;
            }
            single.add(mCTSet);
        }
        if (ps.showAll) {
            this.println("---Invariants---------------------------");
            this.println(Utils.invariantsToString(tInvariants));
        }
        GUIManager.getDefaultGUIManager().log("MCT Generator: invariants section written.", "text", true);
        this.println("---Invariants[VECTORS]---------------------------");
        StringBuilder header = new StringBuilder(";");
        for (MCTTransition mCTTransition : petriNet.getTransitions()) {
            header.append(mCTTransition.id).append(";");
        }
        this.println(header.toString());
        this.println(vOut, header.toString());
        String string = Utils.invariantsToCsvVectors(tInvariants, false, true, ps.latexMode);
        this.println(string);
        this.println(vOut, string);
        this.println("");
        this.println("---Invariants[IN MCT]---------------------------");
        this.println(header.toString());
        this.println(Utils.invariantsWithMCT(tInvariants, properMctSets, ps.includeId, ps.includeVectors, ps.boolValues, ps.latexMode, ps.clusters));
        this.println("");
        this.println("Proper MCT sets (size > 1): ");
        for (MCTSet mct : properMctSets) {
            if (ps.latexMode) {
                this.println(" [" + mct.getTransitionSet().size() + "]. " + mct.toString(true));
                continue;
            }
            this.println(mct.getPrintName(false) + " [" + mct.getTransitionSet().size() + "]. " + mct);
        }
        GUIManager.getDefaultGUIManager().log("MCT Generator: properMCTsets section finished.", "text", true);
        this.println("Single MCT sets (size = 1): ");
        for (MCTSet mct : single) {
            if (ps.latexMode) {
                this.println(mct.toString(true));
                continue;
            }
            this.println(mct.getPrintName(ps.latexMode) + ". " + mct);
        }
        if (ps.clusters != null) {
            this.println("");
            this.println("List of common cluster MCT sets and");
            List<SortedMap<MCTTransition, Integer>> list = Utils.computeTransitionCoverance(ps.clusters, tInvariants);
            for (int i = 0; i < list.size(); ++i) {
                int clusterSize = ps.clusters.get(i).size();
                SortedMap<MCTTransition, Integer> transitionCount = list.get(i);
                String percent = String.valueOf((double)(1000 * clusterSize / tInvariants.size()) / 10.0).replaceFirst("\\.(.).*$", ".$1");
                if (ps.latexMode) {
                    this.print("$c_{" + (i + 1) + "}$ & " + clusterSize + " (" + percent + "\\%) & ");
                } else {
                    this.print("c" + (i + 1) + " [" + clusterSize + " (" + percent + "%)]: ");
                }
                if (ps.showClusterAsVector) {
                    for (MCTTransition t : transitionCount.keySet()) {
                        Integer tcount = (Integer)transitionCount.get(t);
                        this.print(tcount + ", ");
                    }
                    this.println("");
                    continue;
                }
                TreeSet<MCTSet> mctSetsInClusterForThreshold = new TreeSet<MCTSet>();
                TreeSet<MCTTransition> singleTransitionsInClusterForThreshold = new TreeSet<MCTTransition>();
                TreeSet<MCTSet> mctSetsInClusterBelowThreshold = new TreeSet<MCTSet>();
                TreeSet<MCTTransition> singleTransitionsInClusterBelowThreshold = new TreeSet<MCTTransition>();
                for (MCTTransition t : transitionCount.keySet()) {
                    MCTSet mct;
                    Integer tcount = (Integer)transitionCount.get(t);
                    double percentage = (double)tcount.intValue() / (double)clusterSize;
                    if (percentage >= ps.showAsCommonTransitionThreshold) {
                        mct = t.getMCTSet();
                        if (mct != null && mct.getTransitionSet().size() > 1) {
                            mctSetsInClusterForThreshold.add(mct);
                            continue;
                        }
                        singleTransitionsInClusterForThreshold.add(t);
                        continue;
                    }
                    if (!(percentage > 0.5)) continue;
                    mct = t.getMCTSet();
                    if (mct != null && mct.getTransitionSet().size() > 1) {
                        mctSetsInClusterBelowThreshold.add(mct);
                        continue;
                    }
                    singleTransitionsInClusterBelowThreshold.add(t);
                }
                if (!ps.latexMode) {
                    this.print("MCT = [");
                }
                for (MCTSet mct : mctSetsInClusterForThreshold) {
                    this.print(mct.getPrintName(ps.latexMode) + ", ");
                }
                if (!ps.latexMode) {
                    this.print("], transitions = [");
                }
                for (MCTTransition t : singleTransitionsInClusterForThreshold) {
                    this.print(t.getNodeShort(ps.latexMode) + ", ");
                }
                if (ps.latexMode) {
                    this.println("\t&\t");
                } else {
                    this.println("]");
                }
                if (!ps.latexMode) {
                    this.print("MCT = [");
                }
                for (MCTSet mct : mctSetsInClusterBelowThreshold) {
                    this.print(mct.getPrintName(ps.latexMode) + ", ");
                }
                if (!ps.latexMode) {
                    this.print("], transitions = [");
                }
                for (MCTTransition t : singleTransitionsInClusterBelowThreshold) {
                    this.print(t.getNodeShort(ps.latexMode) + ", ");
                }
                if (ps.latexMode) {
                    this.println("\t\\\\ \\hline");
                    continue;
                }
                this.println("]");
            }
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    private static class ProgramSettings {
        String inputFilePath = "input/input.csv";
        String outputFilePath = "output/output.txt";
        String csvOutputFilePath = "output/output.csv";
        String mctRenameFile = null;
        List<SortedSet<String>> clusters = null;
        boolean latexMode = false;
        boolean includeId = true;
        boolean includeVectors = false;
        boolean boolValues = false;
        boolean showAll = true;
        Double showAsCommonTransitionThreshold = 1.0;
        boolean showClusterAsVector = false;

        public ProgramSettings(String[] args) {
            block16: for (int i = 0; i < args.length; ++i) {
                String param = args[i];
                if (param.equals("-latex")) {
                    this.latexMode = true;
                    continue;
                }
                if (param.equals("-excludeId")) {
                    this.includeId = false;
                    continue;
                }
                if (param.equals("-includeVectors")) {
                    this.includeVectors = true;
                    continue;
                }
                if (param.equals("-boolValues")) {
                    this.boolValues = true;
                    continue;
                }
                if (param.equals("-showAll")) {
                    this.showAll = true;
                    continue;
                }
                if (param.equals("-showClusterAsVector")) {
                    this.showClusterAsVector = true;
                    continue;
                }
                if (param.startsWith("-")) {
                    if (i == args.length - 1) {
                        ProgramSettings.printHelp();
                        throw new RuntimeException("Wrong parameter list");
                    }
                } else {
                    this.inputFilePath = param;
                    if (this.outputFilePath.equals("output/output.txt")) {
                        this.outputFilePath = this.inputFilePath + ".analysed.txt";
                    }
                    if (!this.csvOutputFilePath.equals("output/output.csv")) continue;
                    this.csvOutputFilePath = this.inputFilePath + ".csv";
                    continue;
                }
                switch (param) {
                    case "-o": {
                        this.outputFilePath = args[++i];
                        continue block16;
                    }
                    case "-csvo": {
                        this.csvOutputFilePath = args[++i];
                        continue block16;
                    }
                    case "-mct": {
                        this.mctRenameFile = args[++i];
                        continue block16;
                    }
                    case "-cr": {
                        this.setClusters(args[++i]);
                        continue block16;
                    }
                    case "-sactt": {
                        String threshold = args[++i];
                        try {
                            this.showAsCommonTransitionThreshold = Double.parseDouble(threshold);
                            continue block16;
                        }
                        catch (NumberFormatException nfe) {
                            throw new NumberFormatException("Error in format of common transition threshold value (-scatt arg.): " + threshold);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong parameter: " + param);
                    }
                }
            }
        }

        private void setClusters(String tclusters) {
            String[] tInvariantsInClusters = tclusters.split(";");
            this.clusters = new ArrayList<SortedSet<String>>(tInvariantsInClusters.length);
            for (String clusterDescriptor : tInvariantsInClusters) {
                String[] ranges = clusterDescriptor.split(",");
                TreeSet<String> ss = new TreeSet<String>(new Utils.HybridStringNumberComparator());
                for (String range : ranges) {
                    if (range.indexOf(45) < 0 || !range.matches("[0-9]+-[0-9]+")) {
                        ss.add(range);
                        continue;
                    }
                    String[] limits = range.split("-");
                    try {
                        int from = Integer.parseInt(limits[0]);
                        int to = limits.length > 1 ? Integer.parseInt(limits[1]) : from;
                        for (int index = from; index <= to; ++index) {
                            ss.add(String.valueOf(index));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new NumberFormatException("Error in cluster range format: " + range);
                    }
                }
                this.clusters.add(ss);
            }
        }

        private static void printHelp() {
            try {
                InputStream is = Runner.class.getClassLoader().getResourceAsStream("abyss/adam/mct/help.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                br.close();
            }
            catch (Exception e) {
                GUIManager.getDefaultGUIManager().log("Error (915059067) | Ex: " + e.getMessage(), "error", true);
            }
        }
    }
}

