/*
 * Decompiled with CFR 0.152.
 */
package holmes.adam.mct;

import holmes.adam.mct.MCTPetriNet;
import holmes.adam.mct.MCTTransition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class MCTSet
implements Comparable<MCTSet> {
    private static int seq = 1;
    public static final Comparator<MCTSet> COMP_DEFAULT_BY_SEQ = new CompareMCT(0);
    public static final Comparator<MCTSet> COMP_BY_SIZE_DESCENDING = new CompareMCT(-1);
    private static final String MCT_NAME_PREFIX = "m";
    public final int id;
    private String name;
    private SortedSet<MCTTransition> set = new TreeSet<MCTTransition>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MCTSet() {
        this.id = seq++;
    }

    public SortedSet<MCTTransition> getTransitionSet() {
        return this.set;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean latexMode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPrintName(latexMode));
        sb.append("={");
        for (MCTTransition tr : this.set) {
            sb.append(tr.id).append(", ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public String getPrintName(boolean latexMode) {
        if (latexMode) {
            if (this.name == null) {
                return "$m_{" + this.id + "}$";
            }
            if (this.name.indexOf(46) < 0) {
                return this.name;
            }
            return "$" + this.name.replaceFirst("\\..*$", "") + "_{" + this.name.replaceFirst("^.*\\.", "") + "}$";
        }
        return this.name == null ? MCT_NAME_PREFIX + this.id : this.name;
    }

    @Override
    public int compareTo(MCTSet o) {
        return COMP_DEFAULT_BY_SEQ.compare(this, o);
    }

    private MCTSet(int id) {
        this.id = id;
    }

    public MCTPetriNet getPetriNet() {
        Iterator iterator = this.getTransitionSet().iterator();
        if (iterator.hasNext()) {
            MCTTransition t = (MCTTransition)iterator.next();
            return t.petriNet;
        }
        return null;
    }

    public static SortedSet<MCTSet> rebuildMctOrder(SortedSet<MCTSet> mctSets, Comparator<MCTSet> comp) {
        ArrayList<MCTSet> bySize = new ArrayList<MCTSet>(mctSets);
        int seq = 1;
        bySize.sort(comp);
        TreeSet<MCTSet> result = new TreeSet<MCTSet>();
        for (MCTSet mct : bySize) {
            MCTSet nmct = new MCTSet(seq++);
            nmct.setName(mct.getName());
            nmct.set.addAll(mct.set);
            result.add(nmct);
        }
        return result;
    }

    public static void renameMctSets(Set<MCTSet> mctSets, Map<String, String> renameMap) {
        MCTPetriNet pn = mctSets.iterator().next().getPetriNet();
        block0: for (MCTSet mct : mctSets) {
            for (String tid : renameMap.keySet()) {
                MCTTransition t = pn.getTransition(tid);
                if (t == null || !mct.getTransitionSet().contains(t)) continue;
                mct.setName(renameMap.get(tid));
                continue block0;
            }
        }
    }

    private static class CompareMCT
    implements Comparator<MCTSet> {
        private final int bySize;

        @Override
        public int compare(MCTSet o1, MCTSet o2) {
            if (o1.name != null && o2.name != null) {
                return o1.name.compareTo(o2.name);
            }
            return this.bySize * (o1.set.size() - o2.set.size()) * 2 * seq + (o1.id - o2.id);
        }

        public CompareMCT(int bySize) {
            this.bySize = bySize;
        }
    }
}

