/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.TinyDirectoryModel;
import de.muntjak.tinylookandfeel.TinyFileChooserUI;
import de.muntjak.tinylookandfeel.TinyTableHeaderUI;
import de.muntjak.tinylookandfeel.borders.TinyToolButtonBorder;
import de.muntjak.tinylookandfeel.table.SortableTableData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class TinyFileChooserUI
extends BasicFileChooserUI {
    public static final String IS_FILE_CHOOSER_BUTTON_KEY = "JFileChooser.isFileChooserButton";
    private boolean doScrolling = true;
    private JPanel centerPanel;
    private TinyDirectoryModel directoryModel = null;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                TinyFileChooserUI.this.applyEdit();
            }
        }
    };
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private DetailsTableModel detailsTableModel;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut1 = new Dimension(1, 1);
    private static final Dimension hstrut4 = new Dimension(4, 1);
    private static final Dimension hstrut11 = new Dimension(11, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(2, 2, 2, 2);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 183;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_COLCOUNT = 4;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 100};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static ComponentUI createUI(JComponent c) {
        return new TinyFileChooserUI((JFileChooser)c);
    }

    public TinyFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    public void installComponents(JFileChooser fc) {
        File[] cbFolders;
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 0));
        topPanel.add((Component)topButtonPanel, "East");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        TinyToolButtonBorder toolButtonBorder = new TinyToolButtonBorder();
        Insets margin = new Insets(2, 2, 2, 2);
        JButton b = new JButton(this.upFolderIcon);
        b.putClientProperty(IS_FILE_CHOOSER_BUTTON_KEY, Boolean.TRUE);
        b.setOpaque(false);
        b.setText(null);
        b.setIcon(this.upFolderIcon);
        b.setToolTipText(this.upFolderToolTipText);
        b.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(margin);
        b.addActionListener(this.getChangeToParentDirectoryAction());
        b.setBorder(toolButtonBorder);
        topButtonPanel.add(b);
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        b = new JButton(this.homeFolderIcon);
        b.putClientProperty(IS_FILE_CHOOSER_BUTTON_KEY, Boolean.TRUE);
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(margin);
        b.addActionListener(this.getGoHomeAction());
        b.setBorder(toolButtonBorder);
        topButtonPanel.add(b);
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            b = new JButton(this.newFolderIcon);
            b.putClientProperty(IS_FILE_CHOOSER_BUTTON_KEY, Boolean.TRUE);
            b.setText(null);
            b.setToolTipText(this.newFolderToolTipText);
            b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
            b.setAlignmentX(0.0f);
            b.setAlignmentY(0.5f);
            b.setMargin(margin);
            b.addActionListener(this.getNewFolderAction());
            b.setBorder(toolButtonBorder);
            topButtonPanel.add(b);
        }
        topButtonPanel.add(Box.createRigidArea(hstrut1));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;
            final /* synthetic */ TinyFileChooserUI this$0;

            ViewButtonListener(TinyFileChooserUI tinyFileChooserUI, JFileChooser fc) {
                this.this$0 = tinyFileChooserUI;
                this.fc = fc;
            }

            public void actionPerformed(ActionEvent e) {
                JToggleButton b = (JToggleButton)e.getSource();
                JPanel oldViewPanel = TinyFileChooserUI.access$15(this.this$0);
                if (b == TinyFileChooserUI.access$16(this.this$0)) {
                    if (TinyFileChooserUI.access$17(this.this$0) == null) {
                        TinyFileChooserUI.access$18(this.this$0, this.this$0.createDetailsView(this.fc));
                        TinyFileChooserUI.access$17(this.this$0).setPreferredSize(TinyFileChooserUI.access$19());
                    }
                    TinyFileChooserUI.access$20(this.this$0, TinyFileChooserUI.access$17(this.this$0));
                } else {
                    TinyFileChooserUI.access$20(this.this$0, TinyFileChooserUI.access$21(this.this$0));
                }
                if (TinyFileChooserUI.access$15(this.this$0) != oldViewPanel) {
                    TinyFileChooserUI.access$22(this.this$0).remove(oldViewPanel);
                    TinyFileChooserUI.access$22(this.this$0).add((Component)TinyFileChooserUI.access$15(this.this$0), "Center");
                    TinyFileChooserUI.access$22(this.this$0).revalidate();
                    TinyFileChooserUI.access$22(this.this$0).repaint();
                }
            }
        }
        ViewButtonListener viewButtonListener = new ViewButtonListener(this, fc);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.putClientProperty(IS_FILE_CHOOSER_BUTTON_KEY, Boolean.TRUE);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(new Insets(4, 2, 5, 2));
        this.listViewButton.addActionListener(viewButtonListener);
        this.listViewButton.setBorder(toolButtonBorder);
        topButtonPanel.add(this.listViewButton);
        topButtonPanel.add(Box.createRigidArea(hstrut1));
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.putClientProperty(IS_FILE_CHOOSER_BUTTON_KEY, Boolean.TRUE);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(new Insets(4, 2, 5, 2));
        this.detailsViewButton.addActionListener(viewButtonListener);
        this.detailsViewButton.setBorder(toolButtonBorder);
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        this.useShellFolder = false;
        File[] roots = fsv.getRoots();
        if (roots != null && roots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
            this.useShellFolder = true;
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(fc);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.centerPanel, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(vstrut5));
        AlignedLabel fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fileNamePanel.add(fileNameLabel);
        this.fileNameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fileNamePanel.add(this.fileNameTextField);
        fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!TinyFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    TinyFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        TinyFileChooserUI.groupLabels(new AlignedLabel[]{fileNameLabel, filesOfTypeLabel});
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", l);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", l);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", l);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", l);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", l);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", l);
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction escAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (TinyFileChooserUI.this.editFile != null) {
                    TinyFileChooserUI.this.cancelEdit();
                } else {
                    TinyFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }

            public boolean isEnabled() {
                return TinyFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    protected JPanel createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout());
        final JFileChooser fileChooser = fc;
        this.list = new JList(){

            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null || startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = startIndex;
                while (!(backwards ? i < 0 : i >= max)) {
                    String filename = fileChooser.getName((File)model.getElementAt(i));
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i;
                    }
                    i += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        if (fc.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(fc));
        this.list.addMouseListener(this.createDoubleClickListener(fc, this.list));
        this.list.addMouseListener(this.createSingleClickListener(fc, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            public void intervalRemoved(ListDataEvent e) {
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.list);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        TableHeaderUI headerUI;
        final JFileChooser chooser = fc;
        JPanel p = new JPanel(new BorderLayout());
        this.detailsTableModel = new DetailsTableModel(chooser);
        this.detailsTable = new JTable(this.detailsTableModel){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 27 && this.getCellEditor() == null) {
                    chooser.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.detailsTable.setComponentOrientation(chooser.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Font font = this.detailsTable.getFont();
        this.detailsTable.setRowHeight(Math.max(font.getSize(), 15) + 3);
        TableColumnModel columnModel = this.detailsTable.getColumnModel();
        TableColumn[] columns = new TableColumn[4];
        boolean isWin = System.getProperty("os.name").startsWith("Windows");
        int i = 0;
        while (i < 4) {
            columns[i] = columnModel.getColumn(i);
            columns[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
            ++i;
        }
        if (!isWin) {
            columnModel.removeColumn(columns[2]);
        }
        if ((headerUI = this.detailsTable.getTableHeader().getUI()) instanceof TinyTableHeaderUI) {
            ((TinyTableHeaderUI)headerUI).sortColumns(new int[1], new int[]{1}, this.detailsTable);
            if (isWin) {
                ((TinyTableHeaderUI)headerUI).setHorizontalAlignments(new int[]{10, 11, 10, 10});
            } else {
                ((TinyTableHeaderUI)headerUI).setHorizontalAlignments(new int[]{10, 11, 10});
            }
        }
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(chooser);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.detailsTable.setDefaultRenderer(clazz, cellRenderer);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.detailsTable.setDefaultRenderer(clazz2, cellRenderer);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.detailsTable.setDefaultRenderer(clazz3, cellRenderer);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.detailsTable.setDefaultRenderer(clazz4, cellRenderer);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.detailsTable.setDefaultRenderer(clazz5, cellRenderer);
        final JTextField tf = new JTextField();
        tf.addFocusListener(this.editorFocusListener);
        columns[0].setCellEditor(new DefaultCellEditor(tf){

            public boolean isCellEditable(EventObject e) {
                if (e instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e;
                    int index = TinyFileChooserUI.this.detailsTable.rowAtPoint(me.getPoint());
                    return me.getClickCount() == 1 && TinyFileChooserUI.this.detailsTable.isRowSelected(index);
                }
                return super.isCellEditable(e);
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (value instanceof File) {
                    tf.setText(chooser.getName((File)value));
                    tf.requestFocus();
                    tf.selectAll();
                }
                return comp;
            }
        });
        JList fakeList = new JList(this.detailsTableModel.listModel){
            JTable table;
            {
                this.table = TinyFileChooserUI.this.detailsTable;
            }

            public int locationToIndex(Point location) {
                return this.table.rowAtPoint(location);
            }

            public Rectangle getCellBounds(int index0, int index1) {
                Rectangle r0 = this.table.getCellRect(index0, 0, false);
                Rectangle r1 = this.table.getCellRect(index1, 0, false);
                return r0.union(r1);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public Component add(Component comp) {
                if (comp instanceof JTextField) {
                    return this.table.add(comp);
                }
                return super.add(comp);
            }

            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            public void setTransferHandler(TransferHandler newHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(newHandler);
                } else {
                    super.setTransferHandler(newHandler);
                }
            }

            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            public void setDragEnabled(boolean b) {
                if (this.table != null) {
                    this.table.setDragEnabled(b);
                } else {
                    super.setDragEnabled(b);
                }
            }
        };
        fakeList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(chooser, fakeList));
        JScrollPane scrollpane = new JScrollPane(this.detailsTable);
        scrollpane.setComponentOrientation(chooser.getComponentOrientation());
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                TinyFileChooserUI.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new BasicFileChooserUI.SelectionListener(this){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JFileChooser chooser = TinyFileChooserUI.this.getFileChooser();
                    FileSystemView fsv = chooser.getFileSystemView();
                    JList list = (JList)e.getSource();
                    if (chooser.isMultiSelectionEnabled()) {
                        File[] files = null;
                        Object[] objects = list.getSelectedValues();
                        if (objects != null) {
                            if (objects.length == 1 && ((File)objects[0]).isDirectory() && chooser.isTraversable((File)objects[0]) && (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem((File)objects[0]))) {
                                TinyFileChooserUI.this.setDirectorySelected(true);
                                TinyFileChooserUI.this.setDirectory((File)objects[0]);
                            } else {
                                files = new File[objects.length];
                                int j = 0;
                                int i = 0;
                                while (i < objects.length) {
                                    File f = (File)objects[i];
                                    if (chooser.isFileSelectionEnabled() && f.isFile() || chooser.isDirectorySelectionEnabled() && fsv.isFileSystem(f) && f.isDirectory()) {
                                        files[j++] = f;
                                    }
                                    ++i;
                                }
                                if (j == 0) {
                                    files = null;
                                } else if (j < objects.length) {
                                    File[] tmpFiles = new File[j];
                                    System.arraycopy(files, 0, tmpFiles, 0, j);
                                    files = tmpFiles;
                                }
                                TinyFileChooserUI.this.setDirectorySelected(false);
                            }
                        }
                        chooser.setSelectedFiles(files);
                    } else {
                        File file = (File)list.getSelectedValue();
                        if (file != null && file.isDirectory() && chooser.isTraversable(file) && (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem(file))) {
                            TinyFileChooserUI.this.setDirectorySelected(true);
                            TinyFileChooserUI.this.setDirectory(file);
                            chooser.setSelectedFile(null);
                        } else {
                            TinyFileChooserUI.this.setDirectorySelected(false);
                            if (file != null) {
                                chooser.setSelectedFile(file);
                            }
                        }
                    }
                }
            }
        };
    }

    private MouseListener createSingleClickListener(JFileChooser fc, JList list) {
        return new SingleClickListener(list);
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int i) {
        this.lastIndex = i;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int index) {
        if (UIManager.getBoolean("FileChooser.readOnly")) {
            return;
        }
        this.ensureIndexIsVisible(index);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(index);
            Rectangle r = this.list.getCellBounds(index, index);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + r.x, r.y, r.width - this.editX, r.height);
            } else {
                this.editCell.setBounds(r.x, r.y, r.width - this.editX, r.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(index, 0);
        }
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser chooser = this.getFileChooser();
            String oldDisplayName = chooser.getName(this.editFile);
            String oldFileName = this.editFile.getName();
            String newDisplayName = this.editCell.getText().trim();
            if (!newDisplayName.equals(oldDisplayName)) {
                FileSystemView fsv;
                File f2;
                int i2;
                String newFileName = newDisplayName;
                int i1 = oldFileName.length();
                if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                    newFileName = String.valueOf(newDisplayName) + oldFileName.substring(i2);
                }
                if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), newFileName)).exists() && this.getModel().renameFile(this.editFile, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                    if (chooser.isMultiSelectionEnabled()) {
                        chooser.setSelectedFiles(new File[]{f2});
                    } else {
                        chooser.setSelectedFile(f2);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = TinyFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < TinyFileChooserUI.PREF_SIZE.height ? TinyFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, TinyFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            int index;
            boolean found;
            File[] files = this.getFileChooser().getSelectedFiles();
            Object[] selectedObjects = this.list.getSelectedValues();
            int j = 0;
            while (j < selectedObjects.length) {
                found = false;
                int i = 0;
                while (i < files.length) {
                    if (files[i].equals(selectedObjects[j])) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found && (index = this.getModel().indexOf(selectedObjects[j])) >= 0) {
                    this.listSelectionModel.removeSelectionInterval(index, index);
                }
                ++j;
            }
            int i = 0;
            while (i < files.length) {
                found = false;
                int j2 = 0;
                while (j2 < selectedObjects.length) {
                    if (files[i].equals(selectedObjects[j2])) {
                        found = true;
                        break;
                    }
                    ++j2;
                }
                if (!found && (index = this.getModel().indexOf(files[i])) >= 0) {
                    this.listSelectionModel.addSelectionInterval(index, index);
                }
                ++i;
            }
        } else {
            int i;
            JFileChooser chooser = this.getFileChooser();
            File f = null;
            f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFile();
            if (f != null && (i = this.getModel().indexOf(f)) >= 0) {
                this.listSelectionModel.setSelectionInterval(i, i);
                this.ensureIndexIsVisible(i);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (files != null && i < files.length) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length > 1) {
                buf.append("\"");
            }
            ++i;
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    TinyFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    TinyFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    TinyFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    TinyFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    TinyFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    TinyFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    TinyFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    TinyFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    TinyFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    TinyFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    TinyFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("CancelSelection")) {
                    TinyFileChooserUI.this.applyEdit();
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                    if (TinyFileChooserUI.this.detailsTable != null) {
                        TinyFileChooserUI.this.detailsTable.setComponentOrientation(o);
                        TinyFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    TinyFileChooserUI.this.fileNameTextField.selectAll();
                    TinyFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void createModel() {
        if (this.directoryModel != null) {
            this.directoryModel.invalidateFileCache();
        }
        this.directoryModel = new TinyDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this.directoryModel;
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void ensureIndexIsVisible(int i) {
        if (i >= 0) {
            this.list.ensureIndexIsVisible(i);
            if (this.detailsTable != null) {
                Rectangle r1 = this.detailsTable.getCellRect(i, 0, true);
                Rectangle r2 = this.detailsTable.getCellRect(i, this.detailsTable.getColumnCount() - 1, true);
                r1.x = (r1.x + r2.x + r2.width) / 2;
                r1.width = 1;
                this.detailsTable.scrollRectToVisible(r1);
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        if (!this.doScrolling) {
            return;
        }
        this.ensureIndexIsVisible(this.getModel().indexOf(f));
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        int i = 0;
        while (i < group.length) {
            group[i].group = group;
            ++i;
        }
    }

    static /* synthetic */ JPanel access$15(TinyFileChooserUI tinyFileChooserUI) {
        return tinyFileChooserUI.currentViewPanel;
    }

    static /* synthetic */ JToggleButton access$16(TinyFileChooserUI tinyFileChooserUI) {
        return tinyFileChooserUI.detailsViewButton;
    }

    static /* synthetic */ JPanel access$17(TinyFileChooserUI tinyFileChooserUI) {
        return tinyFileChooserUI.detailsViewPanel;
    }

    static /* synthetic */ void access$18(TinyFileChooserUI tinyFileChooserUI, JPanel jPanel) {
        tinyFileChooserUI.detailsViewPanel = jPanel;
    }

    static /* synthetic */ Dimension access$19() {
        return LIST_PREF_SIZE;
    }

    static /* synthetic */ void access$20(TinyFileChooserUI tinyFileChooserUI, JPanel jPanel) {
        tinyFileChooserUI.currentViewPanel = jPanel;
    }

    static /* synthetic */ JPanel access$21(TinyFileChooserUI tinyFileChooserUI) {
        return tinyFileChooserUI.listViewPanel;
    }

    static /* synthetic */ JPanel access$22(TinyFileChooserUI tinyFileChooserUI) {
        return tinyFileChooserUI.centerPanel;
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener,
    SortableTableData {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;
        Comparator fileAttributeComparator;
        Comparator fileDateComparator;
        Comparator fileNameComparator;
        Comparator fileSizeComparator;
        Comparator fileTypeComparator;
        int sortingDirection;
        int[] sortColumns;
        int[] sortDirections;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;

        DetailsTableModel(JFileChooser fc) {
            this.columnNames = new String[]{" " + TinyFileChooserUI.this.fileNameHeaderText, TinyFileChooserUI.this.fileSizeHeaderText, " " + TinyFileChooserUI.this.fileTypeHeaderText, " " + TinyFileChooserUI.this.fileDateHeaderText, " " + TinyFileChooserUI.this.fileAttrHeaderText};
            this.chooser = fc;
            this.listModel = TinyFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                case 3: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.util.Date");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                case 1: {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                case 2: {
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
            }
            return super.getColumnClass(column);
        }

        public Object getValueAt(int row, int col) {
            File f = (File)this.listModel.getElementAt(row);
            switch (col) {
                case 0: {
                    return f;
                }
                case 1: {
                    if (!f.exists() || f.isDirectory()) {
                        return null;
                    }
                    return new Long(f.length());
                }
                case 2: {
                    if (!f.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(f);
                }
                case 3: {
                    if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) {
                        return null;
                    }
                    long time = f.lastModified();
                    return time == 0L ? null : new Date(time);
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                JFileChooser chooser = TinyFileChooserUI.this.getFileChooser();
                File f = (File)this.getValueAt(row, col);
                if (f != null) {
                    String oldDisplayName = chooser.getName(f);
                    String oldFileName = f.getName();
                    String newDisplayName = ((String)value).trim();
                    if (!newDisplayName.equals(oldDisplayName)) {
                        FileSystemView fsv;
                        File f2;
                        int i2;
                        String newFileName = newDisplayName;
                        int i1 = oldFileName.length();
                        if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                            newFileName = String.valueOf(newDisplayName) + oldFileName.substring(i2);
                        }
                        if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(f.getParentFile(), newFileName)).exists() && TinyFileChooserUI.this.getModel().renameFile(f, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                            if (chooser.isMultiSelectionEnabled()) {
                                chooser.setSelectedFiles(new File[]{f2});
                            } else {
                                chooser.setSelectedFile(f2);
                            }
                        }
                    }
                }
            }
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0 && !UIManager.getBoolean("FileChooser.readOnly");
        }

        public void contentsChanged(ListDataEvent e) {
            DetailsTableModel model = (DetailsTableModel)TinyFileChooserUI.this.detailsTable.getModel();
            model.sortColumns(TinyFileChooserUI.this.detailsTable);
        }

        public void intervalAdded(ListDataEvent e) {
            DetailsTableModel model = (DetailsTableModel)TinyFileChooserUI.this.detailsTable.getModel();
            model.sortColumns(TinyFileChooserUI.this.detailsTable);
        }

        public void intervalRemoved(ListDataEvent e) {
            DetailsTableModel model = (DetailsTableModel)TinyFileChooserUI.this.detailsTable.getModel();
            model.sortColumns(TinyFileChooserUI.this.detailsTable);
        }

        public void invalidateCachedFiles() {
        }

        public boolean isColumnSortable(int column) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.Comparable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.isAssignableFrom(this.getColumnClass(column));
        }

        public boolean supportsMultiColumnSort() {
            return false;
        }

        public void sortColumns(int[] columns, int[] sortingDirections, JTable table) {
            this.sortColumns = new int[columns.length];
            this.sortDirections = new int[sortingDirections.length];
            System.arraycopy(columns, 0, this.sortColumns, 0, columns.length);
            System.arraycopy(sortingDirections, 0, this.sortDirections, 0, sortingDirections.length);
            this.sortColumns(table);
        }

        private void sortColumns(JTable table) {
            Vector files = ((TinyDirectoryModel)this.listModel).getFileCache();
            int[] sc = table.getSelectedColumns();
            int[] sr = new int[table.getSelectedRowCount()];
            Vector<SelectedFile> sortFiles = new Vector<SelectedFile>(files.size());
            int end = files.size();
            int i = 0;
            while (i < end) {
                sortFiles.add(new SelectedFile((File)files.get(i), table.isRowSelected(i)));
                ++i;
            }
            if (this.sortColumns.length == 0) {
                this.sortingDirection = 1;
                if (this.fileNameComparator == null) {
                    this.fileNameComparator = this.createFileNameComparator();
                }
                Collections.sort(sortFiles, this.fileNameComparator);
            } else {
                this.sortingDirection = this.sortDirections[0] == 1 ? 1 : -1;
                switch (this.sortColumns[0]) {
                    case 0: {
                        if (this.fileNameComparator == null) {
                            this.fileNameComparator = this.createFileNameComparator();
                        }
                        Collections.sort(sortFiles, this.fileNameComparator);
                        break;
                    }
                    case 1: {
                        if (this.fileSizeComparator == null) {
                            this.fileSizeComparator = this.createFileSizeComparator();
                        }
                        Collections.sort(sortFiles, this.fileSizeComparator);
                        break;
                    }
                    case 2: {
                        if (this.fileTypeComparator == null) {
                            this.fileTypeComparator = this.createFileTypeComparator();
                        }
                        Collections.sort(sortFiles, this.fileTypeComparator);
                        break;
                    }
                    case 3: {
                        if (this.fileDateComparator == null) {
                            this.fileDateComparator = this.createFileDateComparator();
                        }
                        Collections.sort(sortFiles, this.fileDateComparator);
                    }
                }
            }
            files.clear();
            int row = 0;
            int index = 0;
            Iterator ii = sortFiles.iterator();
            while (ii.hasNext()) {
                SelectedFile sf = (SelectedFile)ii.next();
                files.add(sf.file);
                if (sf.selected) {
                    sr[index++] = row;
                }
                ++row;
            }
            this.fireTableDataChanged();
            TinyFileChooserUI.this.doScrolling = false;
            int i2 = 0;
            while (i2 < sr.length) {
                table.addRowSelectionInterval(sr[i2], sr[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < sc.length) {
                table.addColumnSelectionInterval(sc[i2], sc[i2]);
                ++i2;
            }
            TinyFileChooserUI.this.doScrolling = true;
        }

        Comparator createFileNameComparator() {
            return new Comparator(this){
                final /* synthetic */ DetailsTableModel this$1;
                {
                    this.this$1 = detailsTableModel;
                }

                public int compare(Object o1, Object o2) {
                    SelectedFile f1 = (SelectedFile)o1;
                    SelectedFile f2 = (SelectedFile)o2;
                    if (f1.isDirectory() == f2.isDirectory()) {
                        return f1.getName().compareTo(f2.getName()) * this.this$1.sortingDirection;
                    }
                    if (f1.isDirectory()) {
                        return -1 * this.this$1.sortingDirection;
                    }
                    return 1 * this.this$1.sortingDirection;
                }
            };
        }

        Comparator createFileSizeComparator() {
            return new Comparator(this){
                final /* synthetic */ DetailsTableModel this$1;
                {
                    this.this$1 = detailsTableModel;
                }

                public int compare(Object o1, Object o2) {
                    Long s1 = ((SelectedFile)o1).getSize();
                    Long s2 = ((SelectedFile)o2).getSize();
                    return s1.compareTo(s2) * this.this$1.sortingDirection;
                }
            };
        }

        Comparator createFileTypeComparator() {
            return new Comparator(this){
                final /* synthetic */ DetailsTableModel this$1;
                {
                    this.this$1 = detailsTableModel;
                }

                public int compare(Object o1, Object o2) {
                    SelectedFile f1 = (SelectedFile)o1;
                    SelectedFile f2 = (SelectedFile)o2;
                    if (f1.isDirectory() == f2.isDirectory()) {
                        return f1.getType().compareTo(f2.getType()) * this.this$1.sortingDirection;
                    }
                    if (f1.isDirectory()) {
                        return -1 * this.this$1.sortingDirection;
                    }
                    return 1 * this.this$1.sortingDirection;
                }
            };
        }

        Comparator createFileDateComparator() {
            return new Comparator(this){
                final /* synthetic */ DetailsTableModel this$1;
                {
                    this.this$1 = detailsTableModel;
                }

                public int compare(Object o1, Object o2) {
                    Long d1 = ((SelectedFile)o1).getDate();
                    Long d2 = ((SelectedFile)o2).getDate();
                    return d1.compareTo(d2) * this.this$1.sortingDirection;
                }
            };
        }

        private class SelectedFile {
            File file;
            boolean selected;
            String name;
            Long size;
            Long date;
            String type;
            Boolean isDirectory;
            Boolean exists;
            Boolean isFileSystemRoot;

            SelectedFile(File file, boolean selected) {
                this.file = file;
                this.selected = selected;
            }

            public Long getDate() {
                if (this.date == null) {
                    this.date = this.exists() && !this.isFileSystemRoot() ? new Long(this.file.lastModified()) : new Long(0L);
                }
                return this.date;
            }

            public String getName() {
                if (this.name == null) {
                    this.name = DetailsTableModel.this.chooser.getName(this.file);
                    this.name = this.name == null ? "" : this.name.toLowerCase();
                }
                return this.name;
            }

            public Long getSize() {
                if (this.size == null) {
                    this.size = this.exists() && !this.isDirectory() ? new Long(this.file.length()) : new Long(0L);
                }
                return this.size;
            }

            public String getType() {
                if (this.type == null) {
                    this.type = this.exists() ? DetailsTableModel.this.chooser.getFileSystemView().getSystemTypeDescription(this.file) : "";
                }
                return this.type;
            }

            public boolean isDirectory() {
                if (this.isDirectory == null) {
                    this.isDirectory = new Boolean(this.exists() && this.file.isDirectory());
                }
                return this.isDirectory;
            }

            public boolean exists() {
                if (this.exists == null) {
                    this.exists = new Boolean(this.file.exists());
                }
                return this.exists;
            }

            public boolean isFileSystemRoot() {
                if (this.isFileSystemRoot == null) {
                    this.isFileSystemRoot = new Boolean(DetailsTableModel.this.chooser.getFileSystemView().isFileSystemRoot(this.file));
                }
                return this.isFileSystemRoot;
            }
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int modelColumn = table.getColumnModel().getColumn(column).getModelIndex();
            if (modelColumn == 1) {
                super.setHorizontalAlignment(11);
            } else {
                super.setHorizontalAlignment(10);
            }
            Component c = super.getTableCellRendererComponent(table, value, isSelected & modelColumn == 0, false, row, column);
            int w1 = table.getColumnModel().getColumn(column).getWidth();
            int w2 = c.getPreferredSize().width;
            if (w2 > w1) {
                super.setToolTipText(this.getText());
            } else {
                super.setToolTipText(null);
            }
            return c;
        }

        public void setValue(Object value) {
            this.setIcon(null);
            if (value == null) {
                this.setText("");
            } else if (value instanceof File) {
                File file = (File)value;
                String fileName = this.chooser.getName(file);
                this.setText(fileName);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (value instanceof Date) {
                this.setText(value == null ? "" : this.df.format((Date)value));
            } else if (value instanceof Long) {
                long len = (Long)value / 1024L;
                if (len < 1024L) {
                    this.setText(String.valueOf(len == 0L ? 1L : len) + " KB");
                } else if ((len /= 1024L) < 1024L) {
                    this.setText(String.valueOf(len) + " MB");
                } else {
                    this.setText(String.valueOf(len /= 1024L) + " GB");
                }
            } else {
                super.setValue(value);
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            TinyFileChooserUI.this.setFileSelected();
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList list) {
            this.list = list;
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 1) {
                    JFileChooser fc = TinyFileChooserUI.this.getFileChooser();
                    int index = this.list.locationToIndex(e.getPoint());
                    if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && index >= 0 && this.list.isSelectedIndex(index) && TinyFileChooserUI.this.getEditIndex() == index && TinyFileChooserUI.this.editFile == null) {
                        TinyFileChooserUI.this.editFileName(index);
                    } else if (index >= 0) {
                        TinyFileChooserUI.this.setEditIndex(index);
                    } else {
                        TinyFileChooserUI.this.resetEditIndex();
                    }
                } else {
                    TinyFileChooserUI.this.resetEditIndex();
                }
            }
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TinyFileChooserUI.this.applyEdit();
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = TinyFileChooserUI.this.getFileChooser().getName(file);
            this.setText(fileName);
            Icon icon = TinyFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (isSelected) {
                TinyFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(TinyFileChooserUI.this.getFileChooser().getName(directory));
            this.ii.icon = icon = TinyFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = TinyFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser;
        FileSystemView fsv;

        public DirectoryComboBoxModel() {
            this.chooser = TinyFileChooserUI.this.getFileChooser();
            this.fsv = this.chooser.getFileSystemView();
            File dir = TinyFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = TinyFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException iOException) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                Vector<ShellFolder> path = new Vector<ShellFolder>(10);
                do {
                    path.addElement((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                int i = 0;
                while (i < pathCount) {
                    f = (File)path.get(i);
                    if (this.directories.contains(f)) {
                        int topIndex = this.directories.indexOf(f);
                        int j = i - 1;
                        while (j >= 0) {
                            this.directories.insertElementAt(path.get(j), topIndex + i - j);
                            --j;
                        }
                        break;
                    }
                    ++i;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int i = 0;
            while (i < this.depths.length) {
                File dir = (File)this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent != null) {
                    int j = i - 1;
                    while (j >= 0) {
                        if (parent.equals((File)this.directories.get(j))) {
                            this.depths[i] = this.depths[j] + 1;
                            break;
                        }
                        --j;
                    }
                }
                ++i;
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = TinyFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                TinyFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                TinyFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = TinyFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                int i = 0;
                while (i < this.filters.length) {
                    if (this.filters[i] == currentFilter) {
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    TinyFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return TinyFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return TinyFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            File f = (File)TinyFileChooserUI.this.directoryComboBox.getSelectedItem();
            TinyFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        ButtonAreaLayout() {
        }

        public void addLayoutComponent(String string, Component comp) {
        }

        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                int counter = 0;
                while (counter < numChildren) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                    ++counter;
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = this.hGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.hGap + maxWidth);
                }
                int counter2 = numChildren - 1;
                while (counter2 >= 0) {
                    children[counter2].setBounds(xLocation, yLocation, maxWidth, sizes[counter2].height);
                    xLocation -= xOffset;
                    --counter2;
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                int counter = 0;
                while (counter < numChildren) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                    ++counter;
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void removeLayoutComponent(Component c) {
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth = 0;

        AlignedLabel(String text) {
            super(text);
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int max = 0;
                int i = 0;
                while (i < this.group.length) {
                    max = Math.max(this.group[i].getSuperPreferredWidth(), max);
                    ++i;
                }
                i = 0;
                while (i < this.group.length) {
                    this.group[i].maxWidth = max;
                    ++i;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }
    }
}

