/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class NimRODTextFieldUI
extends BasicTextFieldUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiTextML miTextML;

    NimRODTextFieldUI(JComponent jComponent) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODTextFieldUI(jComponent);
    }

    protected void installListeners() {
        super.installListeners();
        this.miTextML = new MiTextML();
        this.getComponent().addMouseListener(this.miTextML);
        this.getComponent().addFocusListener(this.miTextML);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.miTextML);
        this.getComponent().removeFocusListener(this.miTextML);
    }

    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.getBorder() != null) {
            NimRODUtils.paintFocus(graphics, 0, 0, jTextComponent.getWidth() - 1, jTextComponent.getHeight() - 1, 0, 0, 3.0f, NimRODLookAndFeel.getControl());
        }
        if ((this.focus || this.rollover) && jTextComponent.isEnabled() && jTextComponent.isEditable()) {
            if (this.focus) {
                NimRODUtils.paintFocus(graphics, 1, 1, jTextComponent.getWidth() - 2, jTextComponent.getHeight() - 2, 2, 2, NimRODLookAndFeel.getFocusColor());
            } else if (this.rollover) {
                NimRODUtils.paintFocus(graphics, 1, 1, jTextComponent.getWidth() - 2, jTextComponent.getHeight() - 2, 2, 2, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
            }
        }
    }

    public class MiTextML
    extends MouseAdapter
    implements FocusListener {
        public void mouseExited(MouseEvent mouseEvent) {
            NimRODTextFieldUI.this.rollover = false;
            NimRODTextFieldUI.this.getComponent().repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODTextFieldUI.this.rollover = true;
            NimRODTextFieldUI.this.getComponent().repaint();
        }

        public void focusGained(FocusEvent focusEvent) {
            NimRODTextFieldUI.this.focus = true;
            NimRODTextFieldUI.this.getComponent().repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            NimRODTextFieldUI.this.focus = false;
            NimRODTextFieldUI.this.getComponent().repaint();
        }
    }
}

