/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODIconFactory;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class NimRODComboBoxUI
extends MetalComboBoxUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiML miML;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODComboBoxUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.miML = new MiML();
        this.comboBox.addMouseListener(this.miML);
        this.comboBox.addFocusListener(this.miML);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.miML);
        this.comboBox.removeFocusListener(this.miML);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        dimension.height = this.comboBox.isEditable() ? this.editor.getPreferredSize().height - 4 : (dimension.height += 7);
        dimension.width += 20;
        return dimension;
    }

    protected ComboBoxEditor createEditor() {
        return new NimRODComboBoxEditor();
    }

    protected JButton createArrowButton() {
        return new NimRODComboBoxButton(this.comboBox, NimRODIconFactory.getComboFlechaIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    public class MiML
    extends MouseAdapter
    implements FocusListener {
        public void mouseExited(MouseEvent mouseEvent) {
            NimRODComboBoxUI.this.rollover = false;
            mouseEvent.getComponent().repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODComboBoxUI.this.rollover = true;
            mouseEvent.getComponent().repaint();
        }

        public void focusGained(FocusEvent focusEvent) {
            NimRODComboBoxUI.this.focus = true;
            focusEvent.getComponent().repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            NimRODComboBoxUI.this.focus = false;
            focusEvent.getComponent().repaint();
        }
    }

    private final class NimRODComboBoxButton
    extends MetalComboBoxButton {
        private static final long serialVersionUID = 1L;

        public NimRODComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
            super(jComboBox, icon, bl, cellRendererPane, jList);
            this.setBorder(null);
            NimRODComboBoxUI.this.miML = new MiML();
            this.addMouseListener(NimRODComboBoxUI.this.miML);
            this.addFocusListener(NimRODComboBoxUI.this.miML);
        }

        public void setUI(ButtonUI buttonUI) {
            super.setUI(buttonUI);
            this.setBorder(null);
        }

        public void paintComponent(Graphics graphics) {
            if (this.getBorder() == null) {
                if (this.iconOnly) {
                    this.setBorder(NimRODBorders.getComboButtonBorder());
                } else {
                    this.setBorder(NimRODBorders.getComboEditorBorder());
                    this.setOpaque(false);
                    this.setMargin(new Insets(0, 5, 0, 7));
                }
            }
            if (!this.iconOnly && this.comboBox != null) {
                try {
                    JComponent jComponent = (JComponent)((Object)this.comboBox.getRenderer());
                    boolean bl = jComponent.getBackground() instanceof ColorUIResource;
                    jComponent.setOpaque(!bl);
                    this.paintLeches(graphics);
                    jComponent.setOpaque(bl);
                }
                catch (Exception exception) {}
            } else {
                super.paintComponent(graphics);
            }
            if (!this.iconOnly) {
                if (NimRODComboBoxUI.this.focus) {
                    NimRODUtils.paintFocus(graphics, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 2, 2, NimRODLookAndFeel.getFocusColor());
                } else if (NimRODComboBoxUI.this.rollover) {
                    NimRODUtils.paintFocus(graphics, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 2, 2, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
                }
            } else {
                NimRODUtils.paintFocus(graphics, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 7, 7, 3.0f, this.comboBox.getBackground());
                if (NimRODComboBoxUI.this.focus) {
                    NimRODUtils.paintFocus(graphics, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 7, 7, NimRODLookAndFeel.getFocusColor());
                } else if (NimRODComboBoxUI.this.rollover) {
                    NimRODUtils.paintFocus(graphics, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 7, 7, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintLeches(Graphics graphics) {
            int n;
            Object object;
            boolean bl = this.comboBox.getComponentOrientation().isLeftToRight();
            if (this.ui != null) {
                object = graphics == null ? null : graphics.create();
                try {
                    this.ui.update((Graphics)object, this);
                }
                finally {
                    ((Graphics)object).dispose();
                }
            }
            object = this.getInsets();
            int n2 = this.getWidth() - (((Insets)object).left + ((Insets)object).right);
            int n3 = this.getHeight() - (((Insets)object).top + ((Insets)object).bottom);
            if (n3 <= 0 || n2 <= 0) {
                return;
            }
            int n4 = ((Insets)object).left;
            int n5 = ((Insets)object).top;
            int n6 = n4 + (n2 - 1);
            int n7 = n5 + (n3 - 1);
            int n8 = 0;
            int n9 = n = bl ? n6 : n4;
            if (this.comboIcon != null) {
                n8 = this.comboIcon.getIconWidth();
                int n10 = this.comboIcon.getIconHeight();
                int n11 = 0;
                if (this.iconOnly) {
                    n = this.getWidth() / 2 - n8 / 2;
                    n11 = this.getHeight() / 2 - n10 / 2;
                } else {
                    n = bl ? n4 + (n2 - 1) - n8 : n4;
                    n11 = n5 + (n7 - n5) / 2 - n10 / 2;
                }
                this.comboIcon.paintIcon(this, graphics, n, n11);
                graphics.setColor(NimRODUtils.getSombra());
                graphics.drawLine(n - 6, 6, n - 6, this.getHeight() - 6);
                graphics.setColor(NimRODUtils.getBrillo());
                graphics.drawLine(n - 5, 6, n - 5, this.getHeight() - 6);
            }
            if (!this.iconOnly && this.comboBox != null) {
                ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
                boolean bl2 = this.getModel().isPressed();
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl2, false);
                component.setFont(this.rendererPane.getFont());
                if (this.model.isArmed() && this.model.isPressed()) {
                    if (this.isOpaque()) {
                        component.setBackground(UIManager.getColor("Button.select"));
                    }
                    component.setForeground(this.comboBox.getForeground());
                } else if (!this.comboBox.isEnabled()) {
                    if (this.isOpaque()) {
                        component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    }
                    component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                } else {
                    component.setForeground(this.comboBox.getForeground());
                    component.setBackground(this.comboBox.getBackground());
                }
                int n12 = n2 - (((Insets)object).right + n8);
                boolean bl3 = false;
                if (component instanceof JPanel) {
                    bl3 = true;
                }
                if (bl) {
                    this.rendererPane.paintComponent(graphics, component, this, n4, n5, n12, n3, bl3);
                } else {
                    this.rendererPane.paintComponent(graphics, component, this, n4 + n8, n5, n12, n3, bl3);
                }
            }
        }
    }

    public class NimRODComboBoxEditor
    extends MetalComboBoxEditor {
        public NimRODComboBoxEditor() {
            this.editor.setBorder(NimRODBorders.getComboEditorBorder());
        }
    }
}

