/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalButtonUI;

public class NimRODButtonUI
extends MetalButtonUI {
    protected MiML miml;
    private static NimRODButtonUI ui;

    public static ComponentUI createUI(JComponent jComponent) {
        if (ui == null) {
            ui = new NimRODButtonUI();
        }
        return ui;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setBorder(NimRODBorders.getButtonBorder());
    }

    public void unsinstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setBorder(MetalBorders.getButtonBorder());
    }

    public void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        this.miml = new MiML(abstractButton);
        abstractButton.addMouseListener(this.miml);
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        abstractButton.removeMouseListener(this.miml);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (!abstractButton.isOpaque()) {
            return;
        }
        if (abstractButton.isContentAreaFilled()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.selectColor);
            RoundRectangle2D.Float float_ = this.hazBoton(abstractButton);
            graphics2D.fill(float_);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (!abstractButton.isFocusPainted() || !abstractButton.isOpaque()) {
            return;
        }
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        graphics.setColor(this.getFocusColor());
        graphics.drawRoundRect(2, 2, abstractButton.getWidth() - 6, abstractButton.getHeight() - 6, 5, 5);
        graphics.drawRoundRect(3, 3, abstractButton.getWidth() - 6, abstractButton.getHeight() - 6, 4, 4);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ButtonModel buttonModel = ((AbstractButton)jComponent).getModel();
        if (jComponent.isOpaque()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RoundRectangle2D.Float float_ = this.hazBoton(jComponent);
            if (jComponent.getParent() instanceof JToolBar) {
                if (buttonModel.isRollover()) {
                    jComponent.setBorder(NimRODBorders.getGenBorder());
                } else {
                    jComponent.setBorder(NimRODBorders.getEmptyGenBorder());
                }
                if (buttonModel.isPressed() || buttonModel.isSelected()) {
                    graphics2D.setColor(NimRODLookAndFeel.getFocusColor());
                    graphics2D.fill(float_);
                }
            } else {
                GradientPaint gradientPaint = null;
                gradientPaint = buttonModel.isPressed() || buttonModel.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODUtils.getSombra(), 0.0f, jComponent.getHeight(), NimRODUtils.getBrillo()) : new GradientPaint(0.0f, 0.0f, NimRODUtils.getBrillo(), 0.0f, jComponent.getHeight(), NimRODUtils.getSombra());
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(float_);
                if (buttonModel.isRollover()) {
                    graphics2D.setColor(NimRODUtils.getRolloverColor());
                    graphics2D.fill(float_);
                }
            }
        }
        super.paint(graphics, jComponent);
    }

    private RoundRectangle2D.Float hazBoton(JComponent jComponent) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float();
        float_.x = 0.0f;
        float_.y = 0.0f;
        float_.width = jComponent.getWidth();
        float_.height = jComponent.getHeight();
        float_.arcwidth = 8.0f;
        float_.archeight = 8.0f;
        return float_;
    }

    public class MiML
    extends MouseInputAdapter {
        private AbstractButton papi;

        MiML(AbstractButton abstractButton) {
            this.papi = abstractButton;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.papi.getModel().setRollover(true);
            this.papi.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.papi.getModel().setRollover(false);
            this.papi.repaint();
        }
    }
}

