/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model;

import com.javadocking.model.DefaultDockingPath;
import com.javadocking.model.DockingPath;
import com.javadocking.model.DockingPathModel;
import com.javadocking.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

class DockingPathModelPropertiesUtil {
    private static final String PROPERTY_DOCKING_PATH = "dockingPath";
    private static final String PROPERTY_DOCKING_PATH_IDS = "dockingPathIds";

    public static void loadDockingProperties(DockingPathModel dockingPathModel, String prefix, Properties properties, Map docks) {
        String[] idsArray = null;
        idsArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_DOCKING_PATH_IDS, idsArray);
        if (idsArray != null && idsArray.length > 0) {
            for (int index = 0; index < idsArray.length; ++index) {
                String pathId = idsArray[index];
                String pathPrefix = prefix + PROPERTY_DOCKING_PATH + "." + pathId;
                DefaultDockingPath dockingPath = new DefaultDockingPath();
                dockingPath.loadProperties(pathPrefix, properties, docks);
                dockingPathModel.add(dockingPath);
            }
        }
    }

    public static void saveDockingProperties(DockingPathModel dockingPathModel, String prefix, Properties properties, Map dockKeys) {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator iterator = dockingPathModel.getIDs();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            DockingPath dockingPath = dockingPathModel.getDockingPath(id);
            ids.add(id);
            String pathPrefix = prefix + PROPERTY_DOCKING_PATH + "." + id;
            dockingPath.saveProperties(pathPrefix, properties, dockKeys);
        }
        String[] idsArray = new String[ids.size()];
        idsArray = ids.toArray(idsArray);
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_DOCKING_PATH_IDS, idsArray);
    }

    private DockingPathModelPropertiesUtil() {
    }
}

