/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.painter.DockableDragPainter;
import com.javadocking.drag.painter.RectanglePainter;
import com.javadocking.drag.painter.TransparentWindow;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class TransparentWindowDockableDragPainter
implements DockableDragPainter {
    private TransparentWindow window;
    private RectanglePainter rectanglePainter;
    private boolean drawLabel;

    public TransparentWindowDockableDragPainter(RectanglePainter rectanglePainter) {
        this(rectanglePainter, false);
    }

    public TransparentWindowDockableDragPainter(RectanglePainter rectanglePainter, boolean drawLabel) {
        this.rectanglePainter = rectanglePainter;
        this.drawLabel = drawLabel;
    }

    public void clear() {
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
    }

    public void paintDockableDrag(Dockable dockable, Dock dock, Rectangle rectangle, Point locationInDestinationDock) {
        if (dock instanceof FloatDock && rectangle != null) {
            if (this.window == null) {
                this.window = new TransparentWindow(this.rectanglePainter);
                this.window.setCursor(DockingManager.getCanDockCursor());
            }
            if (dockable != null && this.drawLabel) {
                this.rectanglePainter.setLabel(dockable.getTitle());
            }
            if (!this.window.isVisible()) {
                this.window.captureScreen();
            }
            this.window.setSize(new Dimension(rectangle.width, rectangle.height));
            this.window.setLocation(rectangle.x, rectangle.y);
            if (!this.window.isVisible()) {
                this.window.setVisible(true);
            }
            this.window.doRepaint();
        } else if (this.window != null) {
            this.window.setVisible(false);
        }
    }

    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
    }
}

