/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.drag.painter.DefaultRectanglePainter;
import com.javadocking.drag.painter.RectanglePainter;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferStrategy;

class TransparentWindowAlt
extends Window {
    private Image screenImage;
    private RectanglePainter rectanglePainter = new DefaultRectanglePainter();
    private static BufferCapabilities bufCap;
    private static BufferStrategy strategy;
    int frames = 0;

    public TransparentWindowAlt(RectanglePainter rectanglePainter, Window owner) {
        super(owner);
        this.rectanglePainter = rectanglePainter;
    }

    public void paint(Graphics graphics) {
        if (strategy == null) {
            this.init();
        }
        Graphics g = strategy.getDrawGraphics();
        g.drawImage(this.screenImage, 0, 0, this.getWidth(), this.getHeight(), this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), null);
        this.rectanglePainter.paintRectangle(g, 0, 0, this.getWidth(), this.getHeight());
        g.dispose();
        strategy.show();
    }

    public void doRepaint() {
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void captureScreen() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            Robot r = new Robot();
            Rectangle rect = new Rectangle(0, 0, d.width, d.height);
            this.screenImage = r.createScreenCapture(rect);
        }
        catch (AWTException awe) {
            System.out.println("Robot exception.");
        }
    }

    private void init() {
        int numBuffers = 2;
        this.createBufferStrategy(numBuffers);
        strategy = this.getBufferStrategy();
        bufCap = strategy.getCapabilities();
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        bufCap = gc.getBufferCapabilities();
        boolean page = bufCap.isPageFlipping();
        if (page) {
            System.out.println("Page flipping");
        } else {
            System.out.println("no page flipping");
        }
    }
}

