/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.painter.DockableDragPainter;
import com.javadocking.drag.painter.DragComponentFactory;
import com.javadocking.drag.painter.RectangleDragComponentFactory;
import com.javadocking.drag.painter.RectanglePainter;
import com.javadocking.model.DockModel;
import com.javadocking.util.SwingUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Iterator;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class SwDockableDragPainter
implements DockableDragPainter {
    private static final Integer LAYER_0 = new Integer(0);
    private Component dragComponent;
    private DragComponentFactory dragComponentFactory;
    private Point componentLocation = new Point();
    private JLayeredPane layeredPane;
    private JRootPane rootPane;
    private Rectangle previousDockableDragRectangle = new Rectangle();
    private Dock previousPaintingDock;
    private boolean onlyComponentDocks = true;

    public SwDockableDragPainter(DragComponentFactory dragComponentFactory) {
        this.dragComponentFactory = dragComponentFactory;
    }

    public SwDockableDragPainter(RectanglePainter rectanglePainter) {
        this.dragComponentFactory = new RectangleDragComponentFactory(rectanglePainter);
    }

    public SwDockableDragPainter(DragComponentFactory dragComponentFactory, boolean onlyComponentDocks) {
        this.dragComponentFactory = dragComponentFactory;
        this.onlyComponentDocks = onlyComponentDocks;
    }

    public SwDockableDragPainter(RectanglePainter rectanglePainter, boolean onlyComponentDocks) {
        this.dragComponentFactory = new RectangleDragComponentFactory(rectanglePainter);
        this.onlyComponentDocks = onlyComponentDocks;
    }

    public void paintDockableDrag(Dockable dockable, Dock dock, Rectangle rectangle, Point locationInDestinationDock) {
        if (dock == null && rectangle == null) {
            this.clear();
            return;
        }
        if (this.onlyComponentDocks && !(dock instanceof Component)) {
            this.clear();
            return;
        }
        if (!dock.equals(this.previousPaintingDock) || !rectangle.equals(this.previousDockableDragRectangle)) {
            this.previousPaintingDock = dock;
            this.previousDockableDragRectangle.setBounds(rectangle);
            this.clear();
            this.rootPane = this.retrieveRootPane(dock);
            if (this.rootPane != null) {
                this.layeredPane = SwingUtil.getLayeredPane(this.rootPane);
                if (this.layeredPane != null) {
                    this.componentLocation.move(rectangle.x, rectangle.y);
                    if (dock instanceof Component) {
                        SwingUtilities.convertPointToScreen(this.componentLocation, (Component)((Object)dock));
                    }
                    SwingUtilities.convertPointFromScreen(this.componentLocation, this.rootPane);
                    this.dragComponent = this.dragComponentFactory.createDragComponent(dockable, dock, rectangle);
                    this.layeredPane.add(this.dragComponent, LAYER_0, 0);
                    this.dragComponent.setLocation(this.componentLocation.x, this.componentLocation.y);
                }
            }
        }
    }

    public void clear() {
        if (this.layeredPane != null) {
            this.layeredPane.remove(this.dragComponent);
            this.rootPane.repaint();
            this.layeredPane = null;
            this.dragComponent = null;
            this.rootPane = null;
        }
    }

    private JRootPane retrieveRootPane(Dock dock) {
        if (dock instanceof Component) {
            return SwingUtilities.getRootPane((Component)((Object)dock));
        }
        if (dock instanceof FloatDock) {
            DockModel dockModel = DockingManager.getDockModel();
            for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
                Iterator iterator = dockModel.getRootKeys(dockModel.getOwner(index));
                while (iterator.hasNext()) {
                    String rootDockKey = (String)iterator.next();
                    Dock rootDock = dockModel.getRootDock(rootDockKey);
                    if (!rootDock.equals(dock)) continue;
                    Window window = dockModel.getOwner(index);
                    return SwingUtil.getRootPane(window);
                }
            }
        }
        return null;
    }

    public boolean isOnlyComponentDocks() {
        return this.onlyComponentDocks;
    }

    public void setOnlyComponentDocks(boolean onlyComponentDocks) {
        this.onlyComponentDocks = onlyComponentDocks;
    }
}

