/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.painter.DockableDragPainter;
import com.javadocking.drag.painter.DragComponentFactory;
import com.javadocking.drag.painter.RectangleDragComponentFactory;
import com.javadocking.drag.painter.RectanglePainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class OldWindowDockableDragPainter
implements DockableDragPainter {
    private JWindow window;
    private JPanel panel;
    private Point windowLocation = new Point();
    private Component dragComponent;
    private DragComponentFactory dragComponentFactory;

    public OldWindowDockableDragPainter(DragComponentFactory dragComponentFactory) {
        this.initializeWindow();
        this.dragComponentFactory = dragComponentFactory;
    }

    public OldWindowDockableDragPainter(RectanglePainter rectanglePainter) {
        this.initializeWindow();
        this.dragComponentFactory = new RectangleDragComponentFactory(rectanglePainter);
    }

    public void clear() {
        this.window.setVisible(false);
    }

    public void paintDockableDrag(Dockable dockable, Dock dock, Rectangle rectangle, Point locationInDestinationDock) {
        if (dock instanceof FloatDock) {
            this.windowLocation.move(rectangle.x, rectangle.y);
            this.window.setSize(new Dimension(rectangle.width, rectangle.height));
            this.window.setLocation(this.windowLocation);
            this.dragComponent = this.dragComponentFactory.createDragComponent(dockable, dock, rectangle);
            this.panel.removeAll();
            this.panel.add(this.dragComponent);
            if (!this.window.isVisible()) {
                this.window.setVisible(true);
            }
        } else {
            this.window.setVisible(false);
        }
    }

    private void initializeWindow() {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setOpaque(true);
        this.window = new JWindow();
        this.window.setBackground(new Color(0, 0, 0, 255));
        this.window.setCursor(DockingManager.getCanDockCursor());
        this.window.getContentPane().add(this.panel);
    }
}

