/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.painter.DockableDragPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class ImageDockableDragPainter
implements DockableDragPainter {
    private JWindow window;
    private JPanel contentPanel;
    private Dockable dockable;
    private Point windowLocation = new Point();
    private Image smallImage;
    private ImageComponent component;
    private int verticalShift = 5;
    private float preferredReduceFactor = 0.33333334f;
    private float minReduceFactor = 0.7692308f;
    private Dimension minImageSize = new Dimension(50, 50);
    private Dimension maxImageSize = new Dimension(200, 200);

    public void clear() {
        this.dockable = null;
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
        if (this.smallImage != null) {
            this.smallImage.flush();
            this.smallImage = null;
        }
    }

    public void paintDockableDrag(Dockable newDockable, Dock dock, Rectangle rectangle, Point locationInDestinationDock) {
        if (this.window == null) {
            this.window = new JWindow();
            this.contentPanel = new JPanel(new BorderLayout());
            this.contentPanel.setBackground(Color.white);
            this.window.getContentPane().add(this.contentPanel);
        }
        if (dock == null) {
            this.window.setCursor(DockingManager.getCanNotDockCursor());
        } else {
            this.window.setCursor(DockingManager.getCanDockCursor());
        }
        if (!newDockable.equals(this.dockable)) {
            Component dockableComponent = newDockable.getContent();
            if (dockableComponent == null || dockableComponent.getSize().width <= 0 || dockableComponent.getSize().height <= 0) {
                return;
            }
            float actualReduceFactor = this.calculateActualReduceFactor(dockableComponent.getSize());
            Point dockableLocation = new Point();
            SwingUtilities.convertPointToScreen(dockableLocation, dockableComponent);
            Rectangle dockableRectangle = new Rectangle(dockableLocation.x, dockableLocation.y, dockableComponent.getSize().width, dockableComponent.getSize().height);
            this.window.setSize((int)((float)dockableRectangle.width * actualReduceFactor), (int)((float)dockableRectangle.height * actualReduceFactor));
            this.dockable = newDockable;
            BufferedImage dockableImage = new BufferedImage(dockableComponent.getSize().width, dockableComponent.getSize().height, 2);
            Graphics dockableImageGraphics = dockableImage.getGraphics();
            dockableComponent.paint(dockableImage.getGraphics());
            dockableImageGraphics.dispose();
            this.smallImage = dockableImage.getScaledInstance(this.window.getWidth(), this.window.getHeight(), 4);
            dockableImage.flush();
            this.component = new ImageComponent((int)((float)dockableRectangle.width * actualReduceFactor), (int)((float)dockableRectangle.height * actualReduceFactor));
            this.contentPanel.removeAll();
            this.contentPanel.add((Component)this.component, "Center");
        }
        this.windowLocation.move(locationInDestinationDock.x - this.window.getSize().width / 2, locationInDestinationDock.y - this.window.getSize().height / 2 - this.verticalShift);
        if (dock instanceof Component) {
            SwingUtilities.convertPointToScreen(this.windowLocation, (Component)((Object)dock));
        }
        this.window.setLocation(this.windowLocation);
        if (!this.window.isVisible()) {
            this.window.setVisible(true);
            this.component.doRepaint();
        }
    }

    public float getPreferredReduceFactor() {
        return this.preferredReduceFactor;
    }

    public void setPreferredReduceFactor(float factor) {
        this.preferredReduceFactor = factor;
    }

    public float getMinReduceFactor() {
        return this.minReduceFactor;
    }

    public void setMinReduceFactor(float minReduceFactor) {
        this.minReduceFactor = minReduceFactor;
    }

    public Dimension getMaxImageSize() {
        return this.maxImageSize;
    }

    public void setMaxImageSize(Dimension maxImageSize) {
        this.maxImageSize = maxImageSize;
    }

    public Dimension getMinImageSize() {
        return this.minImageSize;
    }

    public void setMinImageSize(Dimension minImageSize) {
        if (minImageSize.width == 0 || minImageSize.height == 0) {
            throw new IllegalArgumentException("The width or height may not be 0.");
        }
        this.minImageSize = minImageSize;
    }

    public int getVerticalShift() {
        return this.verticalShift;
    }

    public void setVerticalShift(int verticalShift) {
        this.verticalShift = verticalShift;
    }

    protected float calculateActualReduceFactor(Dimension componentSize) {
        float actualWidth = (float)componentSize.width * this.preferredReduceFactor;
        float actualHeight = (float)componentSize.height * this.preferredReduceFactor;
        if (actualHeight < (float)this.minImageSize.height) {
            actualWidth = actualWidth * (float)this.minImageSize.height / actualHeight;
            actualHeight = this.minImageSize.height;
        }
        if (actualWidth < (float)this.minImageSize.width) {
            actualHeight = actualHeight * (float)this.minImageSize.width / actualWidth;
            actualWidth = this.minImageSize.width;
        }
        if (actualHeight > (float)this.maxImageSize.height) {
            actualWidth = actualWidth * (float)this.maxImageSize.height / actualHeight;
            actualHeight = this.maxImageSize.height;
        }
        if (actualWidth > (float)this.maxImageSize.width) {
            actualHeight = actualHeight * (float)this.maxImageSize.width / actualWidth;
            actualWidth = this.maxImageSize.width;
        }
        if (actualWidth / (float)componentSize.width > this.minReduceFactor) {
            return this.minReduceFactor;
        }
        return actualWidth / (float)componentSize.width;
    }

    private class ImageComponent
    extends JComponent {
        public ImageComponent(int width, int height) {
            this.setBounds(0, 0, width, height);
            this.setOpaque(false);
        }

        public void paint(Graphics graphics) {
            ((Graphics2D)graphics).drawImage(ImageDockableDragPainter.this.smallImage, 0, 0, this.getWidth(), this.getHeight(), null);
        }

        public void doRepaint() {
            Graphics g = this.getGraphics();
            this.paint(g);
        }
    }
}

