/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.drag.painter.RectanglePainter;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DefaultRectanglePainter
implements RectanglePainter {
    private static final int DEFAULT_BORDER_COUNT = 1;
    private static final int DEFAULT_BORDER_SHIFT = 1;
    private static final int DEFAULT_ARC_WIDTH = 10;
    private static final int DEFAULT_ARC_HEIGHT = 10;
    private static final Color DEFAULT_FILL_COLOR = new Color(180, 180, 255, 100);
    private static final Color DEFAULT_BORDER_COLOR = Color.blue;
    private int borderCount = 1;
    private int borderShift = 1;
    private Color borderColor = DEFAULT_BORDER_COLOR;
    private Stroke stroke = null;
    private int arcWidth = 10;
    private int arcHeight = 10;
    private Color fillColor = DEFAULT_FILL_COLOR;
    private String label;
    private Color labelBackground = Color.white;
    private Color labelForeground = Color.black;
    private Color labelBorderColor = Color.blue;

    public void paintRectangle(Graphics graphics, int x, int y, int width, int height) {
        Color oldColor = graphics.getColor();
        graphics.setColor(this.borderColor);
        Stroke oldStroke = ((Graphics2D)graphics).getStroke();
        if (this.stroke != null) {
            ((Graphics2D)graphics).setStroke(this.stroke);
        }
        for (int index = 0; index < this.borderCount; ++index) {
            int totalShift = index * this.borderShift;
            if (this.arcWidth == 0 && this.arcHeight == 0) {
                graphics.drawRect(totalShift, totalShift, width - 1 - totalShift * 2, height - 1 - totalShift * 2);
                continue;
            }
            graphics.drawRoundRect(totalShift, totalShift, width - 1 - totalShift * 2, height - 1 - totalShift * 2, this.arcWidth, this.arcHeight);
        }
        if (this.fillColor != null) {
            graphics.setColor(this.fillColor);
        }
        if (this.fillColor != null) {
            int totalShift = this.borderShift * this.borderCount;
            if (this.arcWidth == 0 && this.arcHeight == 0) {
                graphics.fillRect(x + totalShift, x + totalShift, width - 1 - totalShift * 2, height - 1 - totalShift * 2);
            } else {
                graphics.fillRoundRect(x + totalShift, y + totalShift, width - 1 - totalShift * 2, height - 1 - totalShift * 2, this.arcWidth, this.arcHeight);
            }
        }
        if (this.label != null) {
            FontMetrics fm = ((Graphics2D)graphics).getFontMetrics();
            int textWidth = fm.stringWidth(this.label);
            int stringAscent = fm.getAscent();
            int textHeight = stringAscent - fm.getLeading();
            int labelWidth = textWidth + 10;
            int labelHeight = textHeight + 10;
            graphics.setColor(this.labelBackground);
            graphics.fillRect(x + width / 2 - labelWidth / 2, y + height / 2 - labelHeight / 2, labelWidth, labelHeight);
            graphics.setColor(this.labelBorderColor);
            graphics.drawRect(x + width / 2 - labelWidth / 2, y + height / 2 - labelHeight / 2, labelWidth, labelHeight);
            graphics.setColor(this.labelForeground);
            graphics.drawString(this.label, x + width / 2 - textWidth / 2, y + height / 2 + textHeight / 2);
        }
        ((Graphics2D)graphics).setStroke(oldStroke);
        graphics.setColor(oldColor);
    }

    public int getBorderCount() {
        return this.borderCount;
    }

    public void setBorderCount(int borderCount) {
        this.borderCount = borderCount;
    }

    public int getBorderShift() {
        return this.borderShift;
    }

    public void setBorderShift(int borderShift) {
        this.borderShift = borderShift;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getLabelBackground() {
        return this.labelBackground;
    }

    public void setLabelBackground(Color labelBackground) {
        this.labelBackground = labelBackground;
    }

    public Color getLabelBorderColor() {
        return this.labelBorderColor;
    }

    public void setLabelBorderColor(Color labelBorderColor) {
        this.labelBorderColor = labelBorderColor;
    }

    public Color getLabelForeground() {
        return this.labelForeground;
    }

    public void setLabelForeground(Color labelForeground) {
        this.labelForeground = labelForeground;
    }
}

