/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.SingleDock;
import com.javadocking.dock.TabDock;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.DefaultCompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragCursorManager;
import com.javadocking.drag.Dragger;
import com.javadocking.drag.dockretriever.DockRetriever;
import com.javadocking.drag.dockretriever.DynamicDockRetriever;
import com.javadocking.util.CollectionUtil;
import com.javadocking.util.DockingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DynamicTabDragger
implements Dragger {
    private static final boolean TEST = false;
    private static final int FLOAT_DELAY = 150;
    private static final int NO_FLOATING = 0;
    private static final int START_FLOATING = 1;
    private static final int FLOATING = 2;
    private DockRetriever dockRetriever = new DynamicDockRetriever();
    private boolean undocked;
    private boolean floating;
    private int floatingDelay = 0;
    private Timer timer;
    private TabDock originDock;
    private LeafDock previousDock;
    private boolean mouseExitedPreviousDock;
    private Rectangle previousDockRectangle = new Rectangle();
    private LeafDock currentDock;
    private Dock currentRootDock;
    private Dock currentChildOfRootDock;
    private Point screenLocation = new Point();
    private Point locationInDestinationDock = new Point();
    private Point currentOffsetInTabbedPane = new Point();
    private Rectangle dockableDragRectangle = new Rectangle();
    private Point dockableOffset = new Point();
    private Point helpPoint = new Point();
    private Dockable draggedDockable;
    private boolean firstRemoved;
    private CompositeDock dockWithGhost;
    private Set singleDocksWithGhosts = new HashSet();
    private JTabbedPane sourceTabbedPane;
    private int oldTabIndex;
    private DragCursorManager cursorManager = new DragCursorManager();

    public boolean startDragging(MouseEvent mouseEvent) {
        TabDock tabDock;
        Container ancestorComponent;
        Component mouseComponent = (Component)mouseEvent.getSource();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        this.reset();
        if (mouseComponent instanceof JTabbedPane && (ancestorComponent = SwingUtilities.getAncestorOfClass(Component.class, mouseComponent)) instanceof TabDock && (tabDock = (TabDock)ancestorComponent).getDockableCount() > 0) {
            this.originDock = (TabDock)ancestorComponent;
            this.sourceTabbedPane = (JTabbedPane)mouseComponent;
            LeafDock originDock = (LeafDock)((Object)SwingUtilities.getAncestorOfClass(LeafDock.class, this.sourceTabbedPane));
            this.dockableOffset.setLocation(x, y);
            this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, this.sourceTabbedPane);
            this.oldTabIndex = this.sourceTabbedPane.indexAtLocation(this.dockableOffset.x, this.dockableOffset.y);
            if (this.oldTabIndex >= 0) {
                Component tabComponent = this.sourceTabbedPane.getComponentAt(this.oldTabIndex);
                this.draggedDockable = tabDock.retrieveDockableOfComponent(tabComponent);
                if (this.draggedDockable != null) {
                    Dimension size = this.draggedDockable.getContent().getPreferredSize();
                    if ((double)this.dockableOffset.x > size.getWidth()) {
                        this.dockableOffset.x = (int)Math.round(size.getWidth());
                    }
                    if ((double)this.dockableOffset.y > size.getHeight()) {
                        this.dockableOffset.y = (int)Math.round(size.getHeight());
                    }
                    this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                    return true;
                }
            } else {
                if (this.sourceTabbedPane.getTabCount() <= 0) {
                    return false;
                }
                Component selectedComponent = this.sourceTabbedPane.getSelectedComponent();
                Point helpPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                if (selectedComponent.contains(helpPoint = SwingUtilities.convertPoint(mouseComponent, helpPoint, selectedComponent))) {
                    return false;
                }
                Dockable[] dockables = new Dockable[this.sourceTabbedPane.getTabCount()];
                for (int index = 0; index < this.sourceTabbedPane.getTabCount(); ++index) {
                    dockables[index] = tabDock.retrieveDockableOfComponent(this.sourceTabbedPane.getComponentAt(index));
                    if (dockables[index] != null) continue;
                    return false;
                }
                this.draggedDockable = new DefaultCompositeDockable(dockables, this.sourceTabbedPane.getSelectedIndex());
                this.draggedDockable.setState(1, originDock);
                Dimension size = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)this.draggedDockable, 16);
                if ((double)this.dockableOffset.x > size.getWidth()) {
                    this.dockableOffset.x = (int)Math.round(size.getWidth());
                }
                if ((double)this.dockableOffset.y > size.getHeight()) {
                    this.dockableOffset.y = (int)Math.round(size.getHeight());
                }
                this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                return true;
            }
        }
        return false;
    }

    public void drag(MouseEvent mouseEvent) {
        int tabIndex;
        if (this.draggedDockable == null) {
            return;
        }
        if (!this.mouseExitedPreviousDock && !this.previousDockRectangle.contains(this.screenLocation)) {
            this.mouseExitedPreviousDock = true;
        }
        if ((tabIndex = this.tabDragged(mouseEvent)) >= 0) {
            Point locationInOriginDock = new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            locationInOriginDock = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), locationInOriginDock, this.originDock);
            if (!this.originDock.equals(this.draggedDockable.getDock())) {
                throw new IllegalStateException("The origin dock is not the parent of the dockable.");
            }
            DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, this.originDock, locationInOriginDock, new Point(0, 0));
            this.resetTabTitles(this.sourceTabbedPane);
            return;
        }
        this.computeScreenLocation(mouseEvent);
        Dock[] destinationDocks = this.dockRetriever.retrieveHighestPriorityDock(this.screenLocation, this.draggedDockable);
        if (destinationDocks == null) {
            return;
        }
        Dock destinationDock = destinationDocks[0];
        this.currentDock = this.draggedDockable.getDock();
        if (this.currentDock == null) {
            this.stopDragging(mouseEvent);
            return;
        }
        if (destinationDock != null) {
            if (!destinationDock.equals(this.currentDock)) {
                this.floating = this.isFloating();
                boolean changeDock = this.changeDock(mouseEvent, destinationDock);
                boolean moveInFloat = false;
                if (!changeDock) {
                    if (destinationDocks.length > 1) {
                        destinationDock = destinationDocks[1];
                        if (!destinationDock.equals(this.currentDock)) {
                            changeDock = this.changeDock(mouseEvent, destinationDock);
                        } else if (this.floating) {
                            changeDock = true;
                            moveInFloat = true;
                        }
                    } else if (this.floating) {
                        changeDock = true;
                        moveInFloat = true;
                    }
                }
                if (changeDock) {
                    if (moveInFloat) {
                        destinationDock = this.currentRootDock;
                    }
                    this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                    if (destinationDock instanceof Component) {
                        SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                    }
                    if (destinationDock instanceof FloatDock) {
                        if (this.floating) {
                            ((FloatDock)this.currentRootDock).moveDock(this.currentChildOfRootDock, this.locationInDestinationDock, this.dockableOffset);
                            this.undocked = true;
                            this.floatingDelay = 0;
                            return;
                        }
                        if (this.floatingDelay == 0) {
                            this.floatingDelay = 1;
                            this.startFloatDelay();
                            return;
                        }
                        if (this.floatingDelay == 1) {
                            return;
                        }
                    } else {
                        this.floatingDelay = 0;
                    }
                    this.previousDock = this.currentDock;
                    if (!this.floating) {
                        Component previousDockComponent = (Component)((Object)this.previousDock);
                        this.previousDockRectangle.setSize(previousDockComponent.getSize());
                        this.previousDockRectangle.setLocation(previousDockComponent.getLocationOnScreen());
                        this.mouseExitedPreviousDock = false;
                    } else {
                        this.mouseExitedPreviousDock = true;
                    }
                    if (!this.currentDock.equals(this.draggedDockable.getDock())) {
                        throw new IllegalStateException("Here it is");
                    }
                    DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, destinationDock, this.locationInDestinationDock, this.dockableOffset);
                    this.undocked = true;
                    if (this.currentDock instanceof SingleDock) {
                        this.singleDocksWithGhosts.add(this.currentDock);
                    }
                    if (this.firstRemoved) {
                        DockingManager.getDockingExecutor().cleanDock(this.currentDock, false);
                    } else {
                        this.dockWithGhost = DockingManager.getDockingExecutor().cleanDock(this.currentDock, true);
                    }
                    this.firstRemoved = true;
                }
            } else if (!(this.draggedDockable instanceof CompositeDockable)) {
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                if (destinationDock instanceof Component) {
                    SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                }
                DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, destinationDock, this.locationInDestinationDock, new Point(0, 0));
            }
        }
    }

    public void cancelDragging(MouseEvent mouseEvent) {
        this.stopDragging(mouseEvent);
    }

    public void stopDragging(MouseEvent mouseEvent) {
        this.cursorManager.resetCursor();
        if (this.dockWithGhost != null) {
            this.dockWithGhost.clearGhosts();
        }
        if (this.dockWithGhost != null) {
            this.dockWithGhost.clearGhosts();
        }
        Iterator iterator = this.singleDocksWithGhosts.iterator();
        while (iterator.hasNext()) {
            ((SingleDock)iterator.next()).clearGhosts();
        }
        this.reset();
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        Container ancestorComponent;
        Component mouseComponent = (Component)mouseEvent.getSource();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        Component pressedComponent = SwingUtilities.getDeepestComponentAt(mouseComponent, x, y);
        JTabbedPane pressedTabbedPane = null;
        pressedTabbedPane = pressedComponent instanceof JTabbedPane ? (JTabbedPane)pressedComponent : (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, pressedComponent);
        if (pressedTabbedPane != null && (ancestorComponent = SwingUtilities.getAncestorOfClass(Component.class, pressedTabbedPane)) instanceof TabDock) {
            TabDock clickedDock = (TabDock)ancestorComponent;
            this.dockableOffset.setLocation(x, y);
            this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, pressedTabbedPane);
            int oldTabIndex = pressedTabbedPane.indexAtLocation(this.dockableOffset.x, this.dockableOffset.y);
            JPopupMenu popupMenu = null;
            Dockable clickedDockable = null;
            if (oldTabIndex >= 0) {
                Component tabComponent = pressedTabbedPane.getComponentAt(oldTabIndex);
                clickedDockable = clickedDock.retrieveDockableOfComponent(tabComponent);
            }
            Dockable[] dockableArray = new Dockable[clickedDock.getDockableCount()];
            int selectedIndex = -1;
            for (int index = 0; index < clickedDock.getDockableCount(); ++index) {
                dockableArray[index] = clickedDock.getDockable(index);
                if (!dockableArray[index].equals(clickedDockable)) continue;
                selectedIndex = index;
            }
            DefaultCompositeDockable compositeDockable = new DefaultCompositeDockable(dockableArray, selectedIndex);
            popupMenu = DockingManager.getComponentFactory().createPopupMenu(clickedDockable, compositeDockable);
            if (popupMenu != null) {
                popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected Cursor retrieveCanDockCursor() {
        return DockingManager.getCanDockCursor();
    }

    private void reset() {
        this.undocked = false;
        this.originDock = null;
        this.previousDock = null;
        this.draggedDockable = null;
        this.firstRemoved = false;
        this.dockWithGhost = null;
    }

    private void computeScreenLocation(MouseEvent mouseEvent) {
        this.screenLocation.setLocation(mouseEvent.getX(), mouseEvent.getY());
        SwingUtilities.convertPointToScreen(this.screenLocation, (Component)mouseEvent.getSource());
    }

    private int tabDragged(MouseEvent mouseEvent) {
        if (this.undocked) {
            return -1;
        }
        if (!(this.draggedDockable instanceof CompositeDockable) && this.sourceTabbedPane != null) {
            this.currentOffsetInTabbedPane.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.currentOffsetInTabbedPane = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), this.currentOffsetInTabbedPane, this.sourceTabbedPane);
            return this.sourceTabbedPane.indexAtLocation(this.currentOffsetInTabbedPane.x, this.currentOffsetInTabbedPane.y);
        }
        return -1;
    }

    private void resetTabTitles(JTabbedPane tabbedPane) {
        TabDock originDock = (TabDock)SwingUtilities.getAncestorOfClass(TabDock.class, tabbedPane);
        for (int index = 0; index < tabbedPane.getTabCount(); ++index) {
            Component tabComponent = tabbedPane.getComponentAt(index);
            Dockable dockable = originDock.retrieveDockableOfComponent(tabComponent);
            tabbedPane.setTitleAt(index, dockable.getTitle());
            tabbedPane.setIconAt(index, dockable.getIcon());
        }
    }

    private boolean isFloating() {
        this.currentRootDock = this.draggedDockable.getDock();
        this.currentChildOfRootDock = null;
        while (this.currentRootDock.getParentDock() != null) {
            this.currentChildOfRootDock = this.currentRootDock;
            this.currentRootDock = this.currentRootDock.getParentDock();
        }
        if (this.currentRootDock instanceof FloatDock) {
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this.currentChildOfRootDock, childrenOfDock);
            if (CollectionUtil.sameElements(childrenOfDockable, childrenOfDock)) {
                return true;
            }
        }
        return false;
    }

    private boolean changeDock(MouseEvent mouseEvent, Dock destinationDock) {
        boolean changeDock = false;
        if (!this.undocked) {
            changeDock = true;
        } else if (this.floating) {
            if (destinationDock instanceof FloatDock) {
                changeDock = true;
            } else if (!destinationDock.equals(this.previousDock)) {
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                destinationDock.retrieveDockingRectangle(this.draggedDockable, this.locationInDestinationDock, this.dockableOffset, this.dockableDragRectangle);
                if (this.dockableDragRectangle.contains(this.locationInDestinationDock)) {
                    changeDock = true;
                }
            } else {
                changeDock = this.mouseExitedPreviousDock;
            }
        } else if (destinationDock instanceof FloatDock) {
            Component currentDockComponent = (Component)((Object)this.currentDock);
            this.helpPoint.setLocation(this.screenLocation.x, this.screenLocation.y);
            SwingUtilities.convertPointFromScreen(this.helpPoint, currentDockComponent);
            changeDock = !currentDockComponent.contains(this.helpPoint);
        } else {
            changeDock = true;
        }
        return changeDock;
    }

    private void floatDelayFinished() {
        this.timer = null;
        if (this.floatingDelay == 1) {
            this.floatingDelay = 2;
        }
    }

    private void startFloatDelay() {
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DynamicTabDragger.this.floatDelayFinished();
            }
        };
        this.timer = new Timer(150, taskPerformer);
        this.timer.setRepeats(false);
        this.timer.start();
    }
}

