/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.SingleDock;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragCursorManager;
import com.javadocking.drag.Dragger;
import com.javadocking.drag.dockretriever.DockRetriever;
import com.javadocking.drag.dockretriever.DynamicDockRetriever;
import com.javadocking.util.CollectionUtil;
import com.javadocking.util.DockingUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DynamicDockableDragger
implements Dragger {
    private static final boolean TEST = false;
    private boolean firstMoveInFloatDock;
    private Point sourceWindowLocation;
    private DockRetriever dockRetriever = new DynamicDockRetriever();
    private boolean undocked;
    private boolean floating;
    private LeafDock originDock;
    private LeafDock previousDock;
    private boolean mouseExitedPreviousDock;
    private Rectangle previousDockRectangle = new Rectangle();
    private LeafDock currentDock;
    private Dock currentRootDock;
    private Dock currentChildOfRootDock;
    private Point screenLocation = new Point();
    private Point locationInDestinationDock = new Point();
    private Rectangle dockableDragRectangle = new Rectangle();
    private Point dockableOffset = new Point();
    private Point helpPoint = new Point();
    private Dockable draggedDockable;
    private Dockable fixedDockable;
    private boolean firstRemoved;
    private CompositeDock dockWithGhost;
    private Set singleDocksWithGhosts = new HashSet();
    private DragCursorManager cursorManager = new DragCursorManager();

    public DynamicDockableDragger(Dockable fixedDockable) {
        if (fixedDockable == null) {
            throw new IllegalArgumentException("Dockable null");
        }
        this.fixedDockable = fixedDockable;
    }

    public boolean startDragging(MouseEvent mouseEvent) {
        Component mouseComponent = (Component)mouseEvent.getSource();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        this.reset();
        Component pressedComponent = SwingUtilities.getDeepestComponentAt(mouseComponent, x, y);
        LeafDock ancestorDock = (LeafDock)((Object)SwingUtilities.getAncestorOfClass(LeafDock.class, pressedComponent));
        if (ancestorDock.getDockableCount() > 0) {
            this.originDock = ancestorDock;
            if (this.originDock.containsDockable(this.fixedDockable)) {
                this.draggedDockable = this.fixedDockable;
                Component dockableComponent = this.draggedDockable.getContent();
                this.dockableOffset.setLocation(x, y);
                this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, this.draggedDockable.getContent());
                Dimension size = dockableComponent.getPreferredSize();
                if ((double)this.dockableOffset.x > size.getWidth()) {
                    this.dockableOffset.x = (int)Math.round(size.getWidth());
                }
                if ((double)this.dockableOffset.y > size.getHeight()) {
                    this.dockableOffset.y = (int)Math.round(size.getHeight());
                }
                this.currentDock = this.draggedDockable.getDock();
                this.floating = this.isFloating();
                this.sourceWindowLocation = !this.floating ? SwingUtilities.getWindowAncestor((Component)mouseEvent.getSource()).getLocationOnScreen() : new Point(0, 0);
                this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                return true;
            }
        }
        return false;
    }

    public void drag(MouseEvent mouseEvent) {
        Dock[] destinationDocks;
        this.computeScreenLocation(mouseEvent);
        if (!this.mouseExitedPreviousDock && !this.previousDockRectangle.contains(this.screenLocation)) {
            this.mouseExitedPreviousDock = true;
        }
        if ((destinationDocks = this.dockRetriever.retrieveHighestPriorityDock(this.screenLocation, this.draggedDockable)) == null) {
            return;
        }
        Dock destinationDock = destinationDocks[0];
        if (destinationDock != null) {
            this.currentDock = this.draggedDockable.getDock();
            if (!destinationDock.equals(this.currentDock)) {
                this.floating = this.isFloating();
                boolean changeDock = this.changeDock(mouseEvent, destinationDock);
                boolean moveInFloat = false;
                if (!changeDock) {
                    if (destinationDocks.length > 1) {
                        destinationDock = destinationDocks[1];
                        if (!destinationDock.equals(this.currentDock)) {
                            changeDock = this.changeDock(mouseEvent, destinationDock);
                        } else if (this.floating) {
                            changeDock = true;
                            moveInFloat = true;
                        }
                    } else if (this.floating) {
                        changeDock = true;
                        moveInFloat = true;
                    }
                }
                if (changeDock) {
                    if (moveInFloat) {
                        destinationDock = this.currentRootDock;
                    }
                    this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                    if (destinationDock instanceof Component) {
                        SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                    }
                    if (destinationDock instanceof FloatDock) {
                        if (this.floating) {
                            if (this.firstMoveInFloatDock) {
                                this.firstMoveInFloatDock = false;
                                return;
                            }
                            ((FloatDock)this.currentRootDock).moveDock(this.currentChildOfRootDock, this.locationInDestinationDock, this.dockableOffset);
                            this.undocked = true;
                            return;
                        }
                        this.firstMoveInFloatDock = true;
                        this.mouseExitedPreviousDock = false;
                    }
                    this.previousDock = this.currentDock;
                    if (!this.floating) {
                        Component previousDockComponent = (Component)((Object)this.previousDock);
                        this.previousDockRectangle.setSize(previousDockComponent.getSize());
                        this.previousDockRectangle.setLocation(previousDockComponent.getLocationOnScreen());
                        this.mouseExitedPreviousDock = false;
                    } else {
                        this.mouseExitedPreviousDock = true;
                    }
                    Dockable dockableWrapper = DockingUtil.retrieveDockableOfDockModel(this.draggedDockable.getID());
                    if (dockableWrapper == null) {
                        throw new IllegalStateException("The dragged dockable should be docked in the dock model.");
                    }
                    if (!this.currentDock.equals(this.draggedDockable.getDock())) {
                        throw new IllegalStateException("The origin dock is not the parent of the dockable.");
                    }
                    DockingManager.getDockingExecutor().changeDocking(dockableWrapper, destinationDock, this.locationInDestinationDock, this.dockableOffset);
                    this.undocked = true;
                    if (this.currentDock instanceof SingleDock) {
                        this.singleDocksWithGhosts.add(this.currentDock);
                    }
                    if (this.firstRemoved) {
                        DockingManager.getDockingExecutor().cleanDock(this.currentDock, false);
                    } else {
                        this.dockWithGhost = DockingManager.getDockingExecutor().cleanDock(this.currentDock, true);
                    }
                    this.firstRemoved = true;
                }
            } else if (!(this.draggedDockable instanceof CompositeDockable)) {
                Dockable dockableWrapper;
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                if (destinationDock instanceof Component) {
                    SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                }
                if ((dockableWrapper = DockingUtil.retrieveDockableOfDockModel(this.draggedDockable.getID())) == null) {
                    throw new IllegalStateException("The dragged dockable should be docked in the dock model.");
                }
                DockingManager.getDockingExecutor().changeDocking(dockableWrapper, destinationDock, this.locationInDestinationDock, new Point(0, 0));
            }
        }
    }

    public void cancelDragging(MouseEvent mouseEvent) {
        this.stopDragging(mouseEvent);
    }

    public void stopDragging(MouseEvent mouseEvent) {
        this.cursorManager.resetCursor();
        if (this.dockWithGhost != null) {
            this.dockWithGhost.clearGhosts();
        }
        if (this.dockWithGhost != null) {
            this.dockWithGhost.clearGhosts();
        }
        Iterator iterator = this.singleDocksWithGhosts.iterator();
        while (iterator.hasNext()) {
            ((SingleDock)iterator.next()).clearGhosts();
        }
        this.reset();
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu popupMenu = DockingManager.getComponentFactory().createPopupMenu(this.draggedDockable, null);
        if (popupMenu != null) {
            popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected Cursor retrieveCanDockCursor() {
        return DockingManager.getCanDockCursor();
    }

    private void reset() {
        this.undocked = false;
        this.originDock = null;
        this.previousDock = null;
        this.draggedDockable = null;
    }

    private void computeScreenLocation(MouseEvent mouseEvent) {
        this.screenLocation.setLocation(mouseEvent.getX(), mouseEvent.getY());
        SwingUtilities.convertPointToScreen(this.screenLocation, (Component)mouseEvent.getSource());
        if (this.floating) {
            this.screenLocation.translate(this.sourceWindowLocation.x, this.sourceWindowLocation.y);
        }
    }

    private boolean isFloating() {
        this.currentRootDock = this.draggedDockable.getDock();
        this.currentChildOfRootDock = null;
        while (this.currentRootDock.getParentDock() != null) {
            this.currentChildOfRootDock = this.currentRootDock;
            this.currentRootDock = this.currentRootDock.getParentDock();
        }
        if (this.currentRootDock instanceof FloatDock) {
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this.currentChildOfRootDock, childrenOfDock);
            if (CollectionUtil.sameElements(childrenOfDockable, childrenOfDock)) {
                return true;
            }
        }
        return false;
    }

    private boolean changeDock(MouseEvent mouseEvent, Dock destinationDock) {
        boolean changeDock = false;
        if (!this.undocked) {
            changeDock = true;
        } else if (this.floating) {
            if (destinationDock instanceof FloatDock) {
                changeDock = true;
            } else if (!destinationDock.equals(this.previousDock)) {
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                destinationDock.retrieveDockingRectangle(this.draggedDockable, this.locationInDestinationDock, this.dockableOffset, this.dockableDragRectangle);
                if (this.dockableDragRectangle.contains(this.locationInDestinationDock)) {
                    changeDock = true;
                }
            } else {
                changeDock = this.mouseExitedPreviousDock;
            }
        } else if (destinationDock instanceof FloatDock) {
            Component currentDockComponent = (Component)((Object)this.currentDock);
            this.helpPoint.setLocation(this.screenLocation.x, this.screenLocation.y);
            SwingUtilities.convertPointFromScreen(this.helpPoint, currentDockComponent);
            changeDock = !currentDockComponent.contains(this.helpPoint);
        } else {
            changeDock = true;
        }
        return changeDock;
    }
}

