/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dockable.action;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.DockableHider;
import com.javadocking.dock.LeafDock;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.action.DockableStateAction;
import com.javadocking.model.DefaultDockingPath;
import com.javadocking.model.DockModel;
import com.javadocking.model.DockingPath;
import com.javadocking.model.DockingPathModel;
import com.javadocking.util.DockingUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class DefaultDockableStateAction
extends AbstractAction
implements DockableStateAction {
    private static final boolean TEST = false;
    private int newDockableState;
    private Dockable dockable;

    public DefaultDockableStateAction(Dockable dockable, int newDockableState) {
        this.dockable = dockable;
        this.newDockableState = newDockableState;
    }

    public DefaultDockableStateAction(Dockable dockable, int newDockableState, String name) {
        super(name);
        this.dockable = dockable;
        this.newDockableState = newDockableState;
    }

    public DefaultDockableStateAction(Dockable dockable, int newDockableState, String name, Icon icon) {
        super(name, icon);
        this.putValue("ShortDescription", name);
        this.dockable = dockable;
        this.newDockableState = newDockableState;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.changeDockableState(this.dockable);
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public int getNewDockableState() {
        return this.newDockableState;
    }

    public void setDockable(Dockable dockable) {
        this.dockable = dockable;
    }

    public void setNewDockableState(int newWindowState) {
        this.newDockableState = newWindowState;
    }

    private void changeDockableState(Dockable dockableToChange) {
        if (dockableToChange instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToChange;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                this.changeDockableState(compositeDockable.getDockable(index));
            }
        } else if ((dockableToChange.getPossibleStates() & this.newDockableState) != 0 && this.newDockableState != dockableToChange.getState()) {
            if (this.newDockableState == 2) {
                DefaultDockableStateAction.close(dockableToChange);
            } else if (this.newDockableState == 1) {
                DefaultDockableStateAction.restore(dockableToChange);
            } else if (this.newDockableState == 4) {
                DefaultDockableStateAction.maximize(dockableToChange);
            } else if (this.newDockableState == 8) {
                DefaultDockableStateAction.minimize(dockableToChange);
            } else if (this.newDockableState == 16) {
                DefaultDockableStateAction.externalize(dockableToChange);
            }
        }
    }

    private static boolean externalize(Dockable dockableToChange) {
        Visualizer externalizer;
        Dockable dockableOfModel = DockingUtil.retrieveDockableOfDockModel(dockableToChange.getID());
        if (dockableOfModel == null) {
            dockableOfModel = dockableToChange;
        }
        if ((externalizer = DefaultDockableStateAction.retrieveVisualizer(dockableOfModel, 16)) == null) {
            return false;
        }
        DefaultDockableStateAction.removeDockableFromVisualizer(dockableOfModel);
        LeafDock dock = dockableOfModel.getDock();
        if (dock != null && !DefaultDockableStateAction.removeDockableFromeDock(dockableOfModel)) {
            return false;
        }
        dockableToChange.setState(16, externalizer);
        externalizer.visualizeDockable(dockableOfModel);
        return true;
    }

    private static boolean minimize(Dockable dockableToChange) {
        Visualizer minimizePanel;
        Dockable dockableOfModel = DockingUtil.retrieveDockableOfDockModel(dockableToChange.getID());
        if (dockableOfModel == null) {
            dockableOfModel = dockableToChange;
        }
        if ((minimizePanel = DefaultDockableStateAction.retrieveVisualizer(dockableOfModel, 8)) == null) {
            return false;
        }
        DefaultDockableStateAction.removeDockableFromVisualizer(dockableOfModel);
        LeafDock dock = dockableOfModel.getDock();
        if (dock != null) {
            if (dockableOfModel.getState() == 16) {
                DefaultDockableStateAction.removeDockableFromeExternalizer(dockableOfModel);
            } else if (!DefaultDockableStateAction.removeDockableFromeDock(dockableOfModel)) {
                return false;
            }
        }
        dockableOfModel.setState(8, minimizePanel);
        minimizePanel.visualizeDockable(dockableOfModel);
        return true;
    }

    private static boolean maximize(Dockable dockableToChange) {
        Visualizer maximizer;
        Dockable dockableOfModel = DockingUtil.retrieveDockableOfDockModel(dockableToChange.getID());
        if (dockableOfModel == null) {
            dockableOfModel = dockableToChange;
        }
        if ((maximizer = DefaultDockableStateAction.retrieveVisualizer(dockableOfModel, 4)) == null) {
            return false;
        }
        DefaultDockableStateAction.removeDockableFromVisualizer(dockableOfModel);
        DefaultDockableStateAction.closeMaximizedDockables();
        LeafDock dock = dockableOfModel.getDock();
        if (dock != null) {
            boolean maximizerContainsDockable = false;
            if (maximizer instanceof Component && dock instanceof Component && SwingUtilities.isDescendingFrom((Component)((Object)dock), (Component)((Object)maximizer))) {
                maximizerContainsDockable = true;
            }
            if (maximizerContainsDockable && dock instanceof DockableHider) {
                ((DockableHider)dock).hideDockable(dockableOfModel);
            } else if (dockableOfModel.getState() == 16) {
                DefaultDockableStateAction.removeDockableFromeExternalizer(dockableOfModel);
            } else if (!DefaultDockableStateAction.removeDockableFromeDock(dockableOfModel)) {
                return false;
            }
        }
        dockableOfModel.setState(4, maximizer);
        maximizer.visualizeDockable(dockableOfModel);
        return true;
    }

    private static boolean restore(Dockable dockableToChange) {
        int currentDockableState;
        Dockable dockableOfModel = DockingUtil.retrieveDockableOfDockModel(dockableToChange.getID());
        if (dockableOfModel == null) {
            dockableOfModel = dockableToChange;
        }
        if ((currentDockableState = dockableOfModel.getState()) == 4) {
            DefaultDockableStateAction.removeDockableFromVisualizer(dockableOfModel);
            LeafDock dock = dockableOfModel.getDock();
            if (dock != null) {
                if (DefaultDockableStateAction.dockableIsHidden(dockableOfModel, (DockableHider)dock)) {
                    ((DockableHider)dock).restoreDockable(dockableOfModel);
                    dockableOfModel.setState(1, dock);
                }
                return true;
            }
        }
        if (currentDockableState == 8 || currentDockableState == 16) {
            DefaultDockableStateAction.removeDockableFromVisualizer(dockableOfModel);
        }
        DefaultDockableStateAction.closeMaximizedDockables();
        DockingPathModel dockingPathModel = DockingManager.getDockingPathModel();
        DockingPath dockingPath = dockingPathModel.getDockingPath(dockableOfModel.getID());
        boolean succes = false;
        if (dockingPath != null) {
            succes = DockingManager.getDockingExecutor().changeDocking(dockableOfModel, dockingPath);
        }
        if (!succes) {
            DockModel dockModel = DockingManager.getDockModel();
            if (dockModel == null) {
                throw new NullPointerException("Dock model of docking manager null.");
            }
            for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
                Iterator iterator = dockModel.getRootKeys(dockModel.getOwner(index));
                while (iterator.hasNext() && !succes) {
                    String key = (String)iterator.next();
                    Dock rootDock = dockModel.getRootDock(key);
                    succes = DockingManager.getDockingExecutor().changeDocking(dockableOfModel, rootDock);
                }
                if (succes) break;
            }
        }
        return succes;
    }

    private static boolean dockableIsHidden(Dockable dockableOfModel, DockableHider dock) {
        for (int index = 0; index < dock.getHiddenDockableCount(); ++index) {
            if (!dockableOfModel.equals(dock.getHiddenDockable(index))) continue;
            return true;
        }
        return false;
    }

    private static boolean close(Dockable dockableToChange) {
        Dockable dockableOfModel = DockingUtil.retrieveDockableOfDockModel(dockableToChange.getID());
        if (dockableOfModel == null) {
            dockableOfModel = dockableToChange;
        }
        boolean canClose = true;
        DefaultDockableStateAction.removeDockableFromVisualizer(dockableOfModel);
        LeafDock dock = dockableOfModel.getDock();
        if (dock != null) {
            if (dockableOfModel.getState() == 16) {
                DefaultDockableStateAction.removeDockableFromeExternalizer(dockableOfModel);
            } else {
                canClose = DefaultDockableStateAction.removeDockableFromeDock(dockableOfModel);
            }
        }
        if (canClose) {
            dockableOfModel.setState(2, null);
        }
        return canClose;
    }

    private static boolean removeDockableFromVisualizer(Dockable dockableOfModel) {
        int currentDockableState = dockableOfModel.getState();
        if (currentDockableState != 2 && currentDockableState != 1) {
            Visualizer stateVisualizer;
            Object visualizer = dockableOfModel.getVisualizer();
            if (visualizer instanceof Visualizer && (stateVisualizer = (Visualizer)visualizer).getState() == currentDockableState) {
                stateVisualizer.removeVisualizedDockable(dockableOfModel);
                return true;
            }
            throw new IllegalStateException("The dockable is visualized, but it could not be removed from the visualizer");
        }
        return false;
    }

    private static boolean removeDockableFromeDock(Dockable dockableOfModel) {
        LeafDock dock = dockableOfModel.getDock();
        if (dock != null) {
            DefaultDockableStateAction.addDockingPath(dockableOfModel);
            boolean succes = DockingManager.getDockingExecutor().changeDocking(dockableOfModel, (Dock)null);
            if (succes) {
                DockingManager.getDockingExecutor().cleanDock(dock, false);
            }
            return succes;
        }
        return true;
    }

    private static boolean removeDockableFromeExternalizer(Dockable dockableOfModel) {
        LeafDock dock = dockableOfModel.getDock();
        if (dock != null) {
            boolean succes = DockingManager.getDockingExecutor().changeDocking(dockableOfModel, (Dock)null);
            if (succes) {
                DockingManager.getDockingExecutor().cleanDock(dock, false);
            }
            return succes;
        }
        return true;
    }

    private static Visualizer retrieveVisualizer(Dockable dockableOfModel, int dockableState) {
        LeafDock dock = dockableOfModel.getDock();
        if (dock == null) {
            int index;
            Visualizer[] visualizers = DefaultDockableStateAction.retrieveVisualizersOfDockModel(dockableOfModel, dockableState);
            for (index = 0; index < visualizers.length; ++index) {
                if (!visualizers[index].canVisualizeDockable(dockableOfModel)) continue;
                return visualizers[index];
            }
            visualizers = DefaultDockableStateAction.retrieveVisualizersOfDockModel(dockableState);
            for (index = 0; index < visualizers.length; ++index) {
                if (!visualizers[index].canVisualizeDockable(dockableOfModel)) continue;
                return visualizers[index];
            }
        } else {
            int index;
            Component dockableContent = dockableOfModel.getContent();
            Visualizer visualizer = DefaultDockableStateAction.findVizualizerAroundComponent(dockableState, dockableContent);
            if (visualizer != null) {
                return visualizer;
            }
            Visualizer[] visualizers = DefaultDockableStateAction.retrieveVisualizersOfDockModel(dockableOfModel, dockableState);
            for (index = 0; index < visualizers.length; ++index) {
                if (!visualizers[index].canVisualizeDockable(dockableOfModel)) continue;
                return visualizers[index];
            }
            visualizers = DefaultDockableStateAction.retrieveVisualizersOfDockModel(dockableState);
            for (index = 0; index < visualizers.length; ++index) {
                if (!visualizers[index].canVisualizeDockable(dockableOfModel)) continue;
                return visualizers[index];
            }
        }
        return null;
    }

    private static Visualizer findVizualizerAroundComponent(int dockableState, Component component) {
        Visualizer visualizer = (Visualizer)((Object)SwingUtilities.getAncestorOfClass(Visualizer.class, component));
        while (visualizer != null && visualizer.getState() != dockableState) {
            visualizer = (Visualizer)((Object)SwingUtilities.getAncestorOfClass(class$com$javadocking$visualizer$Visualizer == null ? DefaultDockableStateAction.class$("com.javadocking.visualizer.Visualizer") : class$com$javadocking$visualizer$Visualizer, (Component)((Object)visualizer)));
        }
        if (visualizer != null && visualizer.getState() == dockableState) {
            return visualizer;
        }
        return null;
    }

    private static void addDockingPath(Dockable dockable) {
        if (dockable.getDock() != null) {
            DefaultDockingPath dockingPath = DefaultDockingPath.createDockingPath(dockable);
            DockingManager.getDockingPathModel().add(dockingPath);
        }
    }

    private static Visualizer[] retrieveVisualizersOfDockModel(Dockable dockable, int dockableState) {
        Window owner;
        DockingPath dockingPath;
        DockingPathModel dockingPathModel;
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        String rootDockKey = null;
        LeafDock dock = dockable.getDock();
        if (dock != null) {
            Dock rootDock = DockingUtil.getRootDock(dock);
            rootDockKey = DockingUtil.getRootDockKey(rootDock);
        }
        if ((rootDockKey == null || dockable.getState() == 4) && (dockingPathModel = DockingManager.getDockingPathModel()) != null && (dockingPath = dockingPathModel.getDockingPath(dockable.getID())) != null) {
            Dock rootDock;
            rootDockKey = dockingPath.getRootDockKey();
            if (dockingPath.getDockCount() > 0 && DockingUtil.containsRootDock(dockModel, rootDock = dockingPath.getDock(0))) {
                for (int index = dockingPath.getDockCount() - 1; index >= 0; --index) {
                    Visualizer visualizer;
                    Dock pathDock = dockingPath.getDock(index);
                    if (!DockingUtil.containsDock(rootDock, pathDock) || !(pathDock instanceof Component) || (visualizer = DefaultDockableStateAction.findVizualizerAroundComponent(dockableState, (Component)((Object)pathDock))) == null) continue;
                    Visualizer[] visualizers = new Visualizer[]{visualizer};
                    return visualizers;
                }
            }
        }
        ArrayList<Visualizer> visualizers = new ArrayList<Visualizer>(1);
        if (rootDockKey != null && (owner = DockingUtil.getWindowOwner(rootDockKey)) != null) {
            Iterator visualizerKeysIterator = dockModel.getVisualizerKeys(owner);
            while (visualizerKeysIterator.hasNext()) {
                String key = (String)visualizerKeysIterator.next();
                Visualizer visualizer = dockModel.getVisualizer(key);
                if (visualizer.getState() != dockableState) continue;
                visualizers.add(visualizer);
            }
        }
        Visualizer[] visualizerArray = new Visualizer[visualizers.size()];
        visualizerArray = visualizers.toArray(visualizerArray);
        return visualizerArray;
    }

    private static Visualizer[] retrieveVisualizersOfDockModel(int dockableState) {
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        ArrayList<Visualizer> visualizers = new ArrayList<Visualizer>(1);
        for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
            Window owner = dockModel.getOwner(index);
            Iterator visualizerKeysIterator = dockModel.getVisualizerKeys(owner);
            while (visualizerKeysIterator.hasNext()) {
                String key = (String)visualizerKeysIterator.next();
                Visualizer visualizer = dockModel.getVisualizer(key);
                if (visualizer.getState() != dockableState) continue;
                visualizers.add(visualizer);
            }
        }
        Visualizer[] visualizerArray = new Visualizer[visualizers.size()];
        visualizerArray = visualizers.toArray(visualizerArray);
        return visualizerArray;
    }

    private static void closeMaximizedDockables() {
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
            Window owner = dockModel.getOwner(index);
            Iterator visualizers = dockModel.getVisualizerKeys(owner);
            while (visualizers.hasNext()) {
                String visualizerKey = (String)visualizers.next();
                Visualizer visualizer = dockModel.getVisualizer(visualizerKey);
                if (visualizer.getState() != 4) continue;
                for (int dockableIndex = 0; dockableIndex < visualizer.getVisualizedDockableCount(); ++dockableIndex) {
                    Dockable dockableToRemove = visualizer.getVisualizedDockable(dockableIndex);
                    visualizer.removeVisualizedDockable(dockableToRemove);
                    LeafDock dock = dockableToRemove.getDock();
                    if (dock != null) {
                        ((DockableHider)dock).restoreDockable(dockableToRemove);
                        dockableToRemove.setState(1, dock);
                        continue;
                    }
                    dockableToRemove.setState(2, null);
                }
            }
        }
    }
}

