/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dockable;

import com.javadocking.dock.LeafDock;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.Icon;

public class DefaultCompositeDockable
implements CompositeDockable {
    private static final String ID_SEPARATOR = " ";
    private Dockable[] dockablesArray;
    private int selectedIndex = -1;
    private int lastDockingMode = 0;
    private int possibleStates = 15;
    private int state = 2;
    private Object visualizer;
    private LeafDock dock;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();

    public DefaultCompositeDockable(Dockable[] dockablesArray) {
        this(dockablesArray, -1);
    }

    public DefaultCompositeDockable(Dockable[] dockablesArray, int selectedIndex) {
        this.dockablesArray = dockablesArray;
        this.selectedIndex = selectedIndex;
        if (dockablesArray.length > 0) {
            this.lastDockingMode = dockablesArray[0].getLastDockingMode();
        }
    }

    public Dockable getDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return this.dockablesArray[index];
    }

    public int getDockableCount() {
        return this.dockablesArray.length;
    }

    public Dockable getSelectedDockable() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.getDockableCount()) {
            return null;
        }
        return this.dockablesArray[this.selectedIndex];
    }

    public String getID() {
        StringBuffer compositeId = new StringBuffer();
        for (int index = 0; index < this.getDockableCount(); ++index) {
            if (index != 0) {
                compositeId.append(ID_SEPARATOR);
            }
            String childId = this.getDockable(index).getID();
            if (compositeId == null) continue;
            compositeId.append(childId);
        }
        return compositeId.toString();
    }

    public Component getContent() {
        return null;
    }

    public void setDock(LeafDock dock) {
        LeafDock oldValue = this.dock;
        this.dock = dock;
        this.propertyChangeSupport.firePropertyChange("dock", oldValue, dock);
    }

    public LeafDock getDock() {
        return this.dock;
    }

    public String getTitle() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public int getDockingModes() {
        if (this.dockablesArray.length > 0) {
            int combinedDockingModes = this.dockablesArray[0].getDockingModes();
            for (int index = 0; index < this.dockablesArray.length; ++index) {
                combinedDockingModes &= this.dockablesArray[index].getDockingModes();
            }
            return combinedDockingModes;
        }
        return 2147354623;
    }

    public void setLastDockingMode(int lastDockingMode) {
        int oldValue = this.lastDockingMode;
        this.lastDockingMode = lastDockingMode;
        this.propertyChangeSupport.firePropertyChange("lastDockingMode", oldValue, lastDockingMode);
    }

    public int getLastDockingMode() {
        return this.lastDockingMode;
    }

    public boolean isWithHeader() {
        return true;
    }

    public Action[][] getActions() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public void fireDockingWillChange(DockableEvent dockableEvent) {
        this.dockingEventSupport.fireDockingWillChange(dockableEvent);
        for (int index = 0; index < this.getDockableCount(); ++index) {
            this.getDockable(index).fireDockingWillChange(dockableEvent);
        }
    }

    public void fireDockingChanged(DockableEvent dockableEvent) {
        this.dockingEventSupport.fireDockingChanged(dockableEvent);
        for (int index = 0; index < this.getDockableCount(); ++index) {
            this.getDockable(index).fireDockingChanged(dockableEvent);
        }
    }

    public void setState(int state, Object visualizer) {
        if ((state & this.getPossibleStates()) == 0) {
            throw new IllegalArgumentException("Illegal state for dockable [" + state + "].");
        }
        this.state = state;
        if (state == 2) {
            this.setDock(null);
        } else if (state == 1) {
            if (!(visualizer instanceof LeafDock) && visualizer != null) {
                throw new IllegalArgumentException("The visualizer should be a com.javadocking.dock.LeafDock when the dockable is in state DockableState.NORMAL, not [" + visualizer.getClass() + "].");
            }
            this.setDock((LeafDock)visualizer);
        } else {
            this.visualizer = visualizer;
        }
    }

    public Object getVisualizer() {
        if (this.state == 1) {
            return this.dock;
        }
        if (this.state == 2) {
            return null;
        }
        return this.visualizer;
    }

    public int getState() {
        return this.state;
    }

    public int getPossibleStates() {
        return this.possibleStates;
    }

    public void setPossibleStates(int possibleStates) {
        this.possibleStates = possibleStates;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) throws IndexOutOfBoundsException {
        if (selectedIndex < 0 || selectedIndex >= this.getDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + selectedIndex);
        }
        this.selectedIndex = selectedIndex;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Dockable)) {
            return false;
        }
        Dockable other = (Dockable)object;
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        return "dockable [" + this.getID() + "]";
    }
}

