/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock.factory;

import com.javadocking.dock.Dock;
import com.javadocking.dock.GridDock;
import com.javadocking.dock.LineDock;
import com.javadocking.dock.SingleDock;
import com.javadocking.dock.TabDock;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Properties;

public class LeafDockFactory
implements DockFactory {
    private boolean useLastDockingMode = true;

    public LeafDockFactory() {
        this(true);
    }

    public LeafDockFactory(boolean useLastDockingMode) {
        this.useLastDockingMode = useLastDockingMode;
    }

    public Dock createDock(Dockable dockable, int dockingMode) {
        if (dockable == null) {
            return new TabDock();
        }
        int dockingModes = dockable.getDockingModes();
        if (this.useLastDockingMode) {
            switch (dockable.getLastDockingMode()) {
                case 8192: {
                    return new GridDock(8192);
                }
                case 2048: {
                    return new LineDock(0, false, 2048, 4096);
                }
                case 4096: {
                    return new LineDock(1, false, 2048, 4096);
                }
                case 65536: {
                    return new GridDock(65536);
                }
                case 16384: {
                    return new LineDock(0, false, 16384, 32768);
                }
                case 32768: {
                    return new LineDock(1, false, 16384, 32768);
                }
                case 16: {
                    return new TabDock();
                }
                case 64: {
                    if ((dockingModes & 0x40) == 0) break;
                    if (dockable instanceof CompositeDockable) {
                        if (((CompositeDockable)dockable).getDockableCount() != 1) break;
                        return new SingleDock();
                    }
                    return new SingleDock();
                }
                case 256: {
                    LineDock lineDock = new LineDock(0, false);
                    lineDock.setRealSizeRectangle(false);
                    return lineDock;
                }
                case 512: {
                    LineDock lineDock = new LineDock(1, false);
                    lineDock.setRealSizeRectangle(false);
                    return lineDock;
                }
                case 1024: {
                    return new GridDock();
                }
            }
        }
        if (dockable instanceof CompositeDockable) {
            if ((dockingModes & 0x2000) != 0) {
                return new GridDock(8192);
            }
            if ((dockingModes & 0x800) != 0) {
                return new LineDock(0, false, 2048, 4096);
            }
            if ((dockingModes & 0x1000) != 0) {
                return new LineDock(1, false, 2048, 4096);
            }
            if ((dockingModes & 0x10000) != 0) {
                return new GridDock(65536);
            }
            if ((dockingModes & 0x4000) != 0) {
                return new LineDock(0, false, 16384, 32768);
            }
            if ((dockingModes & 0x8000) != 0) {
                return new LineDock(1, false, 16384, 32768);
            }
            if ((dockingModes & 0x10) != 0) {
                return new TabDock();
            }
            if ((dockingModes & 0x40) != 0 && ((CompositeDockable)dockable).getDockableCount() == 1) {
                return new SingleDock();
            }
            if ((dockingModes & 0x100) != 0) {
                LineDock lineDock = new LineDock(0, false);
                lineDock.setRealSizeRectangle(false);
                return lineDock;
            }
            if ((dockingModes & 0x200) != 0) {
                LineDock lineDock = new LineDock(1, false);
                lineDock.setRealSizeRectangle(false);
                return lineDock;
            }
            if ((dockingModes & 0x400) != 0) {
                return new GridDock();
            }
            return null;
        }
        Component dockableObject = dockable.getContent();
        if (dockableObject != null && dockableObject instanceof Component) {
            if ((dockingModes & 0x2000) != 0) {
                return new GridDock(8192);
            }
            if ((dockingModes & 0x800) != 0) {
                return new LineDock(0, false, 2048, 4096);
            }
            if ((dockingModes & 0x1000) != 0) {
                return new LineDock(1, false, 2048, 4096);
            }
            if ((dockingModes & 0x10000) != 0) {
                return new GridDock(65536);
            }
            if ((dockingModes & 0x4000) != 0) {
                return new LineDock(0, false, 16384, 32768);
            }
            if ((dockingModes & 0x8000) != 0) {
                return new LineDock(1, false, 16384, 32768);
            }
            if ((dockingModes & 0x10) != 0) {
                return new TabDock();
            }
            if ((dockingModes & 0x40) != 0) {
                return new SingleDock();
            }
            if ((dockingModes & 0x100) != 0) {
                return new LineDock(0, false);
            }
            if ((dockingModes & 0x200) != 0) {
                return new LineDock(1, false);
            }
            if ((dockingModes & 0x400) != 0) {
                return new GridDock();
            }
        }
        return null;
    }

    public Dimension getDockPreferredSize(Dockable dockable, int dockingMode) {
        if (dockable instanceof CompositeDockable) {
            int dockingModes = dockable.getDockingModes();
            if (this.useLastDockingMode) {
                switch (dockable.getLastDockingMode()) {
                    case 8192: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 1024);
                    }
                    case 2048: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 256);
                    }
                    case 4096: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 512);
                    }
                    case 65536: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 1024);
                    }
                    case 16384: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 256);
                    }
                    case 32768: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 512);
                    }
                    case 16: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 16);
                    }
                    case 64: {
                        if (((CompositeDockable)dockable).getDockableCount() != 1) break;
                        return ((CompositeDockable)dockable).getDockable(0).getContent().getPreferredSize();
                    }
                    case 256: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 256);
                    }
                    case 512: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 512);
                    }
                    case 1024: {
                        return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 1024);
                    }
                }
            }
            if ((dockingModes & 0x2000) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 1024);
            }
            if ((dockingModes & 0x800) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 256);
            }
            if ((dockingModes & 0x1000) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 512);
            }
            if ((dockingModes & 0x10000) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 1024);
            }
            if ((dockingModes & 0x4000) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 256);
            }
            if ((dockingModes & 0x8000) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 512);
            }
            if ((dockingModes & 0x10) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 16);
            }
            if ((dockingModes & 0x40) != 0 && ((CompositeDockable)dockable).getDockableCount() == 1) {
                return ((CompositeDockable)dockable).getDockable(0).getContent().getPreferredSize();
            }
            if ((dockingModes & 0x100) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 256);
            }
            if ((dockingModes & 0x200) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 512);
            }
            if ((dockingModes & 0x400) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 1024);
            }
            return null;
        }
        if (dockable.getContent() != null) {
            return dockable.getContent().getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public void saveProperties(String prefix, Properties properties) {
        PropertiesUtil.setBoolean(properties, prefix + "useLastDockingMode", this.useLastDockingMode);
    }

    public void loadProperties(String prefix, Properties properties) {
        this.useLastDockingMode = PropertiesUtil.getBoolean(properties, prefix + "useLastDockingMode", this.useLastDockingMode);
    }

    public boolean getUseLastDockingMode() {
        return this.useLastDockingMode;
    }

    public void setUseLastDockingMode(boolean useLastDockingMode) {
        this.useLastDockingMode = useLastDockingMode;
    }
}

