/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock.docker;

import com.javadocking.DockingManager;
import com.javadocking.dock.BorderDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dock.docker.Docker;
import com.javadocking.dock.docker.LastDockables;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.DockingMode;
import com.javadocking.util.PropertiesUtil;
import java.awt.Point;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class BorderDocker
implements Docker {
    private static final int[] DEFAULT_CHILD_POSITIONS;
    private static final Point DEFAULT_LOCATION;
    private int[] childPositions = DEFAULT_CHILD_POSITIONS;
    private BorderDock borderDock;
    private LastDockables lastDockables = new LastDockables();

    public boolean dock(Dockable dockable) {
        boolean added;
        int index;
        boolean succes;
        LeafDock lastDock;
        if (this.borderDock == null) {
            throw new NullPointerException("Border dock null.");
        }
        Dockable lastDockedDockable = this.lastDockables.getLastValidDockable();
        if (lastDockedDockable != null && (lastDock = lastDockedDockable.getDock()) != null && lastDock.getDockPriority(dockable, DEFAULT_LOCATION) != 0 && (succes = DockingManager.getDockingExecutor().changeDocking(dockable, lastDock, DEFAULT_LOCATION, DEFAULT_LOCATION))) {
            this.lastDockables.add(dockable);
            return true;
        }
        Dock childDock = null;
        for (index = 0; index < this.childPositions.length; ++index) {
            Dock dockInPosition = this.borderDock.getChildDockOfPosition(this.childPositions[index]);
            if (dockInPosition == null) continue;
            childDock = dockInPosition;
            break;
        }
        if (childDock != null && (added = childDock.addDockable(dockable, new Point(), new Point()))) {
            this.lastDockables.add(dockable);
            return true;
        }
        if (!this.borderDock.isFull()) {
            for (index = 0; index < this.childPositions.length; ++index) {
                int positionToAdd = this.childPositions[index];
                int dockingMode = this.borderDock.getDockingMode(positionToAdd);
                childDock = this.borderDock.getChildDockFactory().createDock(dockable, dockingMode);
                if (childDock == null) {
                    throw new IllegalStateException("Cannot create a child dock with the child dock factory for docking mode [" + DockingMode.getDescription(dockingMode) + "].");
                }
                boolean added2 = childDock.addDockable(dockable, new Point(), new Point());
                if (!added2) continue;
                this.borderDock.addChildDock(childDock, new Position(positionToAdd));
                this.lastDockables.add(dockable);
                return true;
            }
        }
        return false;
    }

    public void saveProperties(String prefix, Properties properties) {
        PropertiesUtil.setIntegerArray(properties, prefix + "childPositions", this.childPositions);
        this.lastDockables.saveProperties(prefix + "lastDockables.", properties);
    }

    public void loadProperties(String prefix, Properties properties, Map dockablesMap) throws IOException {
        this.childPositions = DEFAULT_CHILD_POSITIONS;
        this.childPositions = PropertiesUtil.getIntegerArray(properties, prefix + "childPositions", this.childPositions);
        this.lastDockables.loadProperties(prefix + "lastDockables.", properties, dockablesMap);
    }

    public int[] getChildPositions() {
        return this.childPositions;
    }

    public void setChildPositions(int[] childPositions) {
        int[] childPositionsCopy = new int[childPositions.length];
        for (int index = 0; index < childPositions.length; ++index) {
            int position = childPositions[index];
            if (position != 4 && position != 1 && position != 2 && position != 3) {
                throw new IllegalArgumentException("invalid child position at ndex [" + index + "].");
            }
            childPositionsCopy[index] = position;
        }
        this.childPositions = childPositionsCopy;
    }

    public BorderDock getBorderDock() {
        return this.borderDock;
    }

    public void setBorderDock(BorderDock dock) {
        this.borderDock = dock;
    }

    static {
        DEFAULT_LOCATION = new Point(0, 0);
        DEFAULT_CHILD_POSITIONS = new int[3];
        BorderDocker.DEFAULT_CHILD_POSITIONS[0] = 4;
        BorderDocker.DEFAULT_CHILD_POSITIONS[1] = 1;
        BorderDocker.DEFAULT_CHILD_POSITIONS[2] = 2;
    }
}

